<?php
// This file was auto-generated from sdk-root/src/data/acm-pca/2017-08-22/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the <i>ACM Private CA API Reference</i>. It provides descriptions, syntax, and usage examples for each of the actions and data types involved in creating and managing private certificate authorities (CA) for your organization.</p> <p>The documentation for each action shows the Query API request parameters and the XML response. Alternatively, you can use one of the AWS SDKs to access an API that\'s tailored to the programming language or platform that you\'re using. For more information, see <a href="https://aws.amazon.com/tools/#SDKs">AWS SDKs</a>.</p> <p>Each ACM Private CA API operation has a quota that determines the number of times the operation can be called per second. ACM Private CA throttles API requests at different rates depending on the operation. Throttling means that ACM Private CA rejects an otherwise valid request because the request exceeds the operation\'s quota for the number of requests per second. When a request is throttled, ACM Private CA returns a <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/CommonErrors.html">ThrottlingException</a> error. ACM Private CA does not guarantee a minimum request rate for APIs. </p> <p>To see an up-to-date list of your ACM Private CA quotas, or to request a quota increase, log into your AWS account and visit the <a href="https://console.aws.amazon.com/servicequotas/">Service Quotas</a> console.</p>', 'operations' => [ 'CreateCertificateAuthority' => '<p>Creates a root or subordinate private certificate authority (CA). You must specify the CA configuration, an optional configuration for Online Certificate Status Protocol (OCSP) and/or a certificate revocation list (CRL), the CA type, and an optional idempotency token to avoid accidental creation of multiple CAs. The CA configuration specifies the name of the algorithm and key size to be used to create the CA private key, the type of signing algorithm that the CA uses, and X.500 subject information. The OCSP configuration can optionally specify a custom URL for the OCSP responder. The CRL configuration specifies the CRL expiration period in days (the validity period of the CRL), the Amazon S3 bucket that will contain the CRL, and a CNAME alias for the S3 bucket that is included in certificates issued by the CA. If successful, this action returns the Amazon Resource Name (ARN) of the CA.</p> <p>ACM Private CA assets that are stored in Amazon S3 can be protected with encryption. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#crl-encryption">Encrypting Your CRLs</a>.</p> <note> <p>Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuthAccess.html">Configure Access to ACM Private CA</a>.</p> </note>', 'CreateCertificateAuthorityAuditReport' => '<p>Creates an audit report that lists every time that your CA private key is used. The report is saved in the Amazon S3 bucket that you specify on input. The <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html">IssueCertificate</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html">RevokeCertificate</a> actions use the private key. </p> <note> <p>Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuthAccess.html">Configure Access to ACM Private CA</a>.</p> </note> <p>ACM Private CA assets that are stored in Amazon S3 can be protected with encryption. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuditReport.html#audit-report-encryption">Encrypting Your Audit Reports</a>.</p>', 'CreatePermission' => '<p>Grants one or more permissions on a private CA to the AWS Certificate Manager (ACM) service principal (<code>acm.amazonaws.com</code>). These permissions allow ACM to issue and renew ACM certificates that reside in the same AWS account as the CA.</p> <p>You can list current permissions with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html">ListPermissions</a> action and revoke them with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html">DeletePermission</a> action.</p> <p class="title"> <b>About Permissions</b> </p> <ul> <li> <p>If the private CA and the certificates it issues reside in the same account, you can use <code>CreatePermission</code> to grant permissions for ACM to carry out automatic certificate renewals.</p> </li> <li> <p>For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.</p> </li> <li> <p>If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA</a>.</p> </li> </ul>', 'DeleteCertificateAuthority' => '<p>Deletes a private certificate authority (CA). You must provide the Amazon Resource Name (ARN) of the private CA that you want to delete. You can find the ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. </p> <note> <p>Deleting a CA will invalidate other CAs and certificates below it in your CA hierarchy.</p> </note> <p>Before you can delete a CA that you have created and activated, you must disable it. To do this, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> action and set the <b>CertificateAuthorityStatus</b> parameter to <code>DISABLED</code>. </p> <p>Additionally, you can delete a CA if you are waiting for it to be created (that is, the status of the CA is <code>CREATING</code>). You can also delete it if the CA has been created but you haven\'t yet imported the signed certificate into ACM Private CA (that is, the status of the CA is <code>PENDING_CERTIFICATE</code>). </p> <p>When you successfully call <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html">DeleteCertificateAuthority</a>, the CA\'s status changes to <code>DELETED</code>. However, the CA won\'t be permanently deleted until the restoration period has passed. By default, if you do not set the <code>PermanentDeletionTimeInDays</code> parameter, the CA remains restorable for 30 days. You can set the parameter from 7 to 30 days. The <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html">DescribeCertificateAuthority</a> action returns the time remaining in the restoration window of a private CA in the <code>DELETED</code> state. To restore an eligible CA, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RestoreCertificateAuthority.html">RestoreCertificateAuthority</a> action.</p>', 'DeletePermission' => '<p>Revokes permissions on a private CA granted to the AWS Certificate Manager (ACM) service principal (acm.amazonaws.com). </p> <p>These permissions allow ACM to issue and renew ACM certificates that reside in the same AWS account as the CA. If you revoke these permissions, ACM will no longer renew the affected certificates automatically.</p> <p>Permissions can be granted with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html">CreatePermission</a> action and listed with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html">ListPermissions</a> action. </p> <p class="title"> <b>About Permissions</b> </p> <ul> <li> <p>If the private CA and the certificates it issues reside in the same account, you can use <code>CreatePermission</code> to grant permissions for ACM to carry out automatic certificate renewals.</p> </li> <li> <p>For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.</p> </li> <li> <p>If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA</a>.</p> </li> </ul>', 'DeletePolicy' => '<p>Deletes the resource-based policy attached to a private CA. Deletion will remove any access that the policy has granted. If there is no policy attached to the private CA, this action will return successful.</p> <p>If you delete a policy that was applied through AWS Resource Access Manager (RAM), the CA will be removed from all shares in which it was included. </p> <p>The AWS Certificate Manager Service Linked Role that the policy supports is not affected when you delete the policy. </p> <p>The current policy can be shown with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html">GetPolicy</a> and updated with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html">PutPolicy</a>.</p> <p class="title"> <b>About Policies</b> </p> <ul> <li> <p>A policy grants access on a private CA to an AWS customer account, to AWS Organizations, or to an AWS Organizations unit. Policies are under the control of a CA administrator. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA</a>.</p> </li> <li> <p>A policy permits a user of AWS Certificate Manager (ACM) to issue ACM certificates signed by a CA in another account.</p> </li> <li> <p>For ACM to manage automatic renewal of these certificates, the ACM user must configure a Service Linked Role (SLR). The SLR allows the ACM service to assume the identity of the user, subject to confirmation against the ACM Private CA policy. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html">Using a Service Linked Role with ACM</a>.</p> </li> <li> <p>Updates made in AWS Resource Manager (RAM) are reflected in policies. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account Access</a>.</p> </li> </ul>', 'DescribeCertificateAuthority' => '<p>Lists information about your private certificate authority (CA) or one that has been shared with you. You specify the private CA on input by its ARN (Amazon Resource Name). The output contains the status of your CA. This can be any of the following: </p> <ul> <li> <p> <code>CREATING</code> - ACM Private CA is creating your private certificate authority.</p> </li> <li> <p> <code>PENDING_CERTIFICATE</code> - The certificate is pending. You must use your ACM Private CA-hosted or on-premises root or subordinate CA to sign your private CA CSR and then import it into PCA. </p> </li> <li> <p> <code>ACTIVE</code> - Your private CA is active.</p> </li> <li> <p> <code>DISABLED</code> - Your private CA has been disabled.</p> </li> <li> <p> <code>EXPIRED</code> - Your private CA certificate has expired.</p> </li> <li> <p> <code>FAILED</code> - Your private CA has failed. Your CA can fail because of problems such a network outage or back-end AWS failure or other errors. A failed CA can never return to the pending state. You must create a new CA. </p> </li> <li> <p> <code>DELETED</code> - Your private CA is within the restoration period, after which it is permanently deleted. The length of time remaining in the CA\'s restoration period is also included in this action\'s output.</p> </li> </ul>', 'DescribeCertificateAuthorityAuditReport' => '<p>Lists information about a specific audit report created by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport</a> action. Audit information is created every time the certificate authority (CA) private key is used. The private key is used when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html">IssueCertificate</a> action or the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html">RevokeCertificate</a> action. </p>', 'GetCertificate' => '<p>Retrieves a certificate from your private CA or one that has been shared with you. The ARN of the certificate is returned when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html">IssueCertificate</a> action. You must specify both the ARN of your private CA and the ARN of the issued certificate when calling the <b>GetCertificate</b> action. You can retrieve the certificate if it is in the <b>ISSUED</b> state. You can call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport</a> action to create a report that contains information about all of the certificates issued and revoked by your private CA. </p>', 'GetCertificateAuthorityCertificate' => '<p>Retrieves the certificate and certificate chain for your private certificate authority (CA) or one that has been shared with you. Both the certificate and the chain are base64 PEM-encoded. The chain does not include the CA certificate. Each certificate in the chain signs the one before it. </p>', 'GetCertificateAuthorityCsr' => '<p>Retrieves the certificate signing request (CSR) for your private certificate authority (CA). The CSR is created when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. Sign the CSR with your ACM Private CA-hosted or on-premises root or subordinate CA. Then import the signed certificate back into ACM Private CA by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html">ImportCertificateAuthorityCertificate</a> action. The CSR is returned as a base64 PEM-encoded string. </p>', 'GetPolicy' => '<p>Retrieves the resource-based policy attached to a private CA. If either the private CA resource or the policy cannot be found, this action returns a <code>ResourceNotFoundException</code>. </p> <p>The policy can be attached or updated with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html">PutPolicy</a> and removed with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html">DeletePolicy</a>.</p> <p class="title"> <b>About Policies</b> </p> <ul> <li> <p>A policy grants access on a private CA to an AWS customer account, to AWS Organizations, or to an AWS Organizations unit. Policies are under the control of a CA administrator. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA</a>.</p> </li> <li> <p>A policy permits a user of AWS Certificate Manager (ACM) to issue ACM certificates signed by a CA in another account.</p> </li> <li> <p>For ACM to manage automatic renewal of these certificates, the ACM user must configure a Service Linked Role (SLR). The SLR allows the ACM service to assume the identity of the user, subject to confirmation against the ACM Private CA policy. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html">Using a Service Linked Role with ACM</a>.</p> </li> <li> <p>Updates made in AWS Resource Manager (RAM) are reflected in policies. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account Access</a>.</p> </li> </ul>', 'ImportCertificateAuthorityCertificate' => '<p>Imports a signed private CA certificate into ACM Private CA. This action is used when you are using a chain of trust whose root is located outside ACM Private CA. Before you can call this action, the following preparations must in place:</p> <ol> <li> <p>In ACM Private CA, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action to create the private CA that you plan to back with the imported certificate.</p> </li> <li> <p>Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificateAuthorityCsr.html">GetCertificateAuthorityCsr</a> action to generate a certificate signing request (CSR).</p> </li> <li> <p>Sign the CSR using a root or intermediate CA hosted by either an on-premises PKI hierarchy or by a commercial CA.</p> </li> <li> <p>Create a certificate chain and copy the signed certificate and the certificate chain to your working directory.</p> </li> </ol> <p>ACM Private CA supports three scenarios for installing a CA certificate:</p> <ul> <li> <p>Installing a certificate for a root CA hosted by ACM Private CA.</p> </li> <li> <p>Installing a subordinate CA certificate whose parent authority is hosted by ACM Private CA.</p> </li> <li> <p>Installing a subordinate CA certificate whose parent authority is externally hosted.</p> </li> </ul> <p>The following additional requirements apply when you import a CA certificate.</p> <ul> <li> <p>Only a self-signed certificate can be imported as a root CA.</p> </li> <li> <p>A self-signed certificate cannot be imported as a subordinate CA.</p> </li> <li> <p>Your certificate chain must not include the private CA certificate that you are importing.</p> </li> <li> <p>Your root CA must be the last certificate in your chain. The subordinate certificate, if any, that your root CA signed must be next to last. The subordinate certificate signed by the preceding subordinate CA must come next, and so on until your chain is built. </p> </li> <li> <p>The chain must be PEM-encoded.</p> </li> <li> <p>The maximum allowed size of a certificate is 32 KB.</p> </li> <li> <p>The maximum allowed size of a certificate chain is 2 MB.</p> </li> </ul> <p> <i>Enforcement of Critical Constraints</i> </p> <p>ACM Private CA allows the following extensions to be marked critical in the imported CA certificate or chain.</p> <ul> <li> <p>Basic constraints (<i>must</i> be marked critical)</p> </li> <li> <p>Subject alternative names</p> </li> <li> <p>Key usage</p> </li> <li> <p>Extended key usage</p> </li> <li> <p>Authority key identifier</p> </li> <li> <p>Subject key identifier</p> </li> <li> <p>Issuer alternative name</p> </li> <li> <p>Subject directory attributes</p> </li> <li> <p>Subject information access</p> </li> <li> <p>Certificate policies</p> </li> <li> <p>Policy mappings</p> </li> <li> <p>Inhibit anyPolicy</p> </li> </ul> <p>ACM Private CA rejects the following extensions when they are marked critical in an imported CA certificate or chain.</p> <ul> <li> <p>Name constraints</p> </li> <li> <p>Policy constraints</p> </li> <li> <p>CRL distribution points</p> </li> <li> <p>Authority information access</p> </li> <li> <p>Freshest CRL</p> </li> <li> <p>Any other extension</p> </li> </ul>', 'IssueCertificate' => '<p>Uses your private certificate authority (CA), or one that has been shared with you, to issue a client certificate. This action returns the Amazon Resource Name (ARN) of the certificate. You can retrieve the certificate by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate</a> action and specifying the ARN. </p> <note> <p>You cannot use the ACM <b>ListCertificateAuthorities</b> action to retrieve the ARNs of the certificates that you issue by using ACM Private CA.</p> </note>', 'ListCertificateAuthorities' => '<p>Lists the private certificate authorities that you created by using the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action.</p>', 'ListPermissions' => '<p>List all permissions on a private CA, if any, granted to the AWS Certificate Manager (ACM) service principal (acm.amazonaws.com). </p> <p>These permissions allow ACM to issue and renew ACM certificates that reside in the same AWS account as the CA. </p> <p>Permissions can be granted with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html">CreatePermission</a> action and revoked with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html">DeletePermission</a> action.</p> <p class="title"> <b>About Permissions</b> </p> <ul> <li> <p>If the private CA and the certificates it issues reside in the same account, you can use <code>CreatePermission</code> to grant permissions for ACM to carry out automatic certificate renewals.</p> </li> <li> <p>For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.</p> </li> <li> <p>If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA</a>.</p> </li> </ul>', 'ListTags' => '<p>Lists the tags, if any, that are associated with your private CA or one that has been shared with you. Tags are labels that you can use to identify and organize your CAs. Each tag consists of a key and an optional value. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html">TagCertificateAuthority</a> action to add one or more tags to your CA. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html">UntagCertificateAuthority</a> action to remove tags. </p>', 'PutPolicy' => '<p>Attaches a resource-based policy to a private CA. </p> <p>A policy can also be applied by sharing a private CA through AWS Resource Access Manager (RAM). For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account Access</a>.</p> <p>The policy can be displayed with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html">GetPolicy</a> and removed with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html">DeletePolicy</a>.</p> <p class="title"> <b>About Policies</b> </p> <ul> <li> <p>A policy grants access on a private CA to an AWS customer account, to AWS Organizations, or to an AWS Organizations unit. Policies are under the control of a CA administrator. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA</a>.</p> </li> <li> <p>A policy permits a user of AWS Certificate Manager (ACM) to issue ACM certificates signed by a CA in another account.</p> </li> <li> <p>For ACM to manage automatic renewal of these certificates, the ACM user must configure a Service Linked Role (SLR). The SLR allows the ACM service to assume the identity of the user, subject to confirmation against the ACM Private CA policy. For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html">Using a Service Linked Role with ACM</a>.</p> </li> <li> <p>Updates made in AWS Resource Manager (RAM) are reflected in policies. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account Access</a>.</p> </li> </ul>', 'RestoreCertificateAuthority' => '<p>Restores a certificate authority (CA) that is in the <code>DELETED</code> state. You can restore a CA during the period that you defined in the <b>PermanentDeletionTimeInDays</b> parameter of the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html">DeleteCertificateAuthority</a> action. Currently, you can specify 7 to 30 days. If you did not specify a <b>PermanentDeletionTimeInDays</b> value, by default you can restore the CA at any time in a 30 day period. You can check the time remaining in the restoration period of a private CA in the <code>DELETED</code> state by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html">DescribeCertificateAuthority</a> or <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> actions. The status of a restored CA is set to its pre-deletion status when the <b>RestoreCertificateAuthority</b> action returns. To change its status to <code>ACTIVE</code>, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> action. If the private CA was in the <code>PENDING_CERTIFICATE</code> state at deletion, you must use the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html">ImportCertificateAuthorityCertificate</a> action to import a certificate authority into the private CA before it can be activated. You cannot restore a CA after the restoration period has ended.</p>', 'RevokeCertificate' => '<p>Revokes a certificate that was issued inside ACM Private CA. If you enable a certificate revocation list (CRL) when you create or update your private CA, information about the revoked certificates will be included in the CRL. ACM Private CA writes the CRL to an S3 bucket that you specify. A CRL is typically updated approximately 30 minutes after a certificate is revoked. If for any reason the CRL update fails, ACM Private CA attempts makes further attempts every 15 minutes. With Amazon CloudWatch, you can create alarms for the metrics <code>CRLGenerated</code> and <code>MisconfiguredCRLBucket</code>. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCloudWatch.html">Supported CloudWatch Metrics</a>.</p> <note> <p>Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuthAccess.html">Configure Access to ACM Private CA</a>.</p> </note> <p>ACM Private CA also writes revocation information to the audit report. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport</a>.</p> <note> <p>You cannot revoke a root CA self-signed certificate.</p> </note>', 'TagCertificateAuthority' => '<p>Adds one or more tags to your private CA. Tags are labels that you can use to identify and organize your AWS resources. Each tag consists of a key and an optional value. You specify the private CA on input by its Amazon Resource Name (ARN). You specify the tag by using a key-value pair. You can apply a tag to just one private CA if you want to identify a specific characteristic of that CA, or you can apply the same tag to multiple private CAs if you want to filter for a common relationship among those CAs. To remove one or more tags, use the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html">UntagCertificateAuthority</a> action. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html">ListTags</a> action to see what tags are associated with your CA. </p>', 'UntagCertificateAuthority' => '<p>Remove one or more tags from your private CA. A tag consists of a key-value pair. If you do not specify the value portion of the tag when calling this action, the tag will be removed regardless of value. If you specify a value, the tag is removed only if it is associated with the specified value. To add tags to a private CA, use the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html">TagCertificateAuthority</a>. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html">ListTags</a> action to see what tags are associated with your CA. </p>', 'UpdateCertificateAuthority' => '<p>Updates the status or configuration of a private certificate authority (CA). Your private CA must be in the <code>ACTIVE</code> or <code>DISABLED</code> state before you can update it. You can disable a private CA that is in the <code>ACTIVE</code> state or make a CA that is in the <code>DISABLED</code> state active again.</p> <note> <p>Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuthAccess.html">Configure Access to ACM Private CA</a>.</p> </note>', ], 'shapes' => [ 'ASN1PrintableString64' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$DistinguishedNameQualifier' => '<p>Disambiguating information for the certificate subject.</p>', 'ASN1Subject$SerialNumber' => '<p>The certificate serial number.</p>', ], ], 'ASN1Subject' => [ 'base' => '<p>Contains information about the certificate subject. The <code>Subject</code> field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The <code>Subject </code>must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.</p>', 'refs' => [ 'ApiPassthrough$Subject' => NULL, 'CertificateAuthorityConfiguration$Subject' => '<p>Structure that contains X.500 distinguished name information for your private CA.</p>', 'GeneralName$DirectoryName' => NULL, ], ], 'AWSPolicy' => [ 'base' => NULL, 'refs' => [ 'GetPolicyResponse$Policy' => '<p>The policy attached to the private CA as a JSON document.</p>', 'Permission$Policy' => '<p>The name of the policy that is associated with the permission.</p>', 'PutPolicyRequest$Policy' => '<p>The path and file name of a JSON-formatted IAM policy to attach to the specified private CA resource. If this policy does not contain all required statements or if it includes any statement that is not allowed, the <code>PutPolicy</code> action returns an <code>InvalidPolicyException</code>. For information about IAM policy and statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies</a>.</p>', ], ], 'AccessDescription' => [ 'base' => '<p>Provides access information used by the <code>authorityInfoAccess</code> and <code>subjectInfoAccess</code> extensions described in <a href="https://tools.ietf.org/html/rfc5280">RFC 5280</a>.</p>', 'refs' => [ 'AccessDescriptionList$member' => NULL, ], ], 'AccessDescriptionList' => [ 'base' => NULL, 'refs' => [ 'CsrExtensions$SubjectInformationAccess' => '<p>For CA certificates, provides a path to additional information pertaining to the CA, such as revocation and policy. For more information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.2.2.2">Subject Information Access</a> in RFC 5280.</p>', ], ], 'AccessMethod' => [ 'base' => '<p>Describes the type and format of extension access. Only one of <code>CustomObjectIdentifier</code> or <code>AccessMethodType</code> may be provided. Providing both results in <code>InvalidArgsException</code>.</p>', 'refs' => [ 'AccessDescription$AccessMethod' => '<p>The type and format of <code>AccessDescription</code> information.</p>', ], ], 'AccessMethodType' => [ 'base' => NULL, 'refs' => [ 'AccessMethod$AccessMethodType' => '<p>Specifies the <code>AccessMethod</code>.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthority$OwnerAccount' => '<p>The AWS account ID that owns the certificate authority.</p>', 'CreatePermissionRequest$SourceAccount' => '<p>The ID of the calling account.</p>', 'DeletePermissionRequest$SourceAccount' => '<p>The AWS account that calls this action.</p>', 'Permission$SourceAccount' => '<p>The ID of the account that assigned the permission.</p>', ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionRequest$Actions' => '<p>The actions that the specified AWS service principal can use. These include <code>IssueCertificate</code>, <code>GetCertificate</code>, and <code>ListPermissions</code>.</p>', 'Permission$Actions' => '<p>The private CA actions that can be performed by the designated AWS service.</p>', ], ], 'ActionType' => [ 'base' => NULL, 'refs' => [ 'ActionList$member' => NULL, ], ], 'ApiPassthrough' => [ 'base' => '<p>Contains X.509 certificate information to be placed in an issued certificate. An <code>APIPassthrough</code> or <code>APICSRPassthrough</code> template variant must be selected, or else this parameter is ignored. </p> <p>If conflicting or duplicate certificate information is supplied from other sources, ACM Private CA applies <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations">order of operation rules</a> to determine what information is used.</p>', 'refs' => [ 'IssueCertificateRequest$ApiPassthrough' => '<p>Specifies X.509 certificate information to be included in the issued certificate. An <code>APIPassthrough</code> or <code>APICSRPassthrough</code> template variant must be selected, or else this parameter is ignored. For more information about using these templates, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate Templates</a>.</p> <p>If conflicting or duplicate certificate information is supplied during certificate issuance, ACM Private CA applies <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations">order of operation rules</a> to determine what information is used.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthority$Arn' => '<p>Amazon Resource Name (ARN) for your private certificate authority (CA). The format is <code> <i>12345678-1234-1234-1234-123456789012</i> </code>.</p>', 'CreateCertificateAuthorityAuditReportRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:</p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>.</p>', 'CreateCertificateAuthorityResponse$CertificateAuthorityArn' => '<p>If successful, the Amazon Resource Name (ARN) of the certificate authority (CA). This is of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'CreatePermissionRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'DeleteCertificateAuthorityRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must have the following form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'DeletePermissionRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Number (ARN) of the private CA that issued the permissions. You can find the CA\'s ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must have the following form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'DeletePolicyRequest$ResourceArn' => '<p>The Amazon Resource Number (ARN) of the private CA that will have its policy deleted. You can find the CA\'s ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. The ARN value must have the form <code>arn:aws:acm-pca:region:account:certificate-authority/01234567-89ab-cdef-0123-0123456789ab</code>. </p>', 'DescribeCertificateAuthorityAuditReportRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of the private CA. This must be of the form:</p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'DescribeCertificateAuthorityRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'GetCertificateAuthorityCertificateRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of your private CA. This is of the form:</p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'GetCertificateAuthorityCsrRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'GetCertificateRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'GetCertificateRequest$CertificateArn' => '<p>The ARN of the issued certificate. The ARN contains the certificate serial number and must be in the following form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i> </code> </p>', 'GetPolicyRequest$ResourceArn' => '<p>The Amazon Resource Number (ARN) of the private CA that will have its policy retrieved. You can find the CA\'s ARN by calling the ListCertificateAuthorities action. </p>', 'ImportCertificateAuthorityCertificateRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'IssueCertificateRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form:</p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'IssueCertificateRequest$TemplateArn' => '<p>Specifies a custom configuration template to use when issuing a certificate. If this parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template. For CA certificates, you should choose the shortest path length that meets your needs. The path length is indicated by the PathLen<i>N</i> portion of the ARN, where <i>N</i> is the <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaTerms.html#terms-cadepth">CA depth</a>.</p> <p>Note: The CA depth configured on a subordinate CA certificate must not exceed the limit set by its parents in the CA hierarchy.</p> <p>For a list of <code>TemplateArn</code> values supported by ACM Private CA, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Understanding Certificate Templates</a>.</p>', 'IssueCertificateResponse$CertificateArn' => '<p>The Amazon Resource Name (ARN) of the issued certificate and the certificate serial number. This is of the form:</p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i> </code> </p>', 'ListPermissionsRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action. This must be of the form: <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code> You can get a private CA\'s ARN by running the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p>', 'ListTagsRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'Permission$CertificateAuthorityArn' => '<p>The Amazon Resource Number (ARN) of the private CA from which the permission was issued.</p>', 'PutPolicyRequest$ResourceArn' => '<p>The Amazon Resource Number (ARN) of the private CA to associate with the policy. The ARN of the CA can be found by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a> action.</p> <p/>', 'RestoreCertificateAuthorityRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'RevokeCertificateRequest$CertificateAuthorityArn' => '<p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:</p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'TagCertificateAuthorityRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'UntagCertificateAuthorityRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a>. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'UpdateCertificateAuthorityRequest$CertificateAuthorityArn' => '<p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:</p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', ], ], 'AuditReportId' => [ 'base' => NULL, 'refs' => [ 'CreateCertificateAuthorityAuditReportResponse$AuditReportId' => '<p>An alphanumeric string that contains a report identifier.</p>', 'DescribeCertificateAuthorityAuditReportRequest$AuditReportId' => '<p>The report ID returned by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport</a> action.</p>', ], ], 'AuditReportResponseFormat' => [ 'base' => NULL, 'refs' => [ 'CreateCertificateAuthorityAuditReportRequest$AuditReportResponseFormat' => '<p>The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.</p>', ], ], 'AuditReportStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeCertificateAuthorityAuditReportResponse$AuditReportStatus' => '<p>Specifies whether report creation is in progress, has succeeded, or has failed.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CrlConfiguration$Enabled' => '<p>Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. You can use this value to enable certificate revocation for a new CA when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action or for an existing CA when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> action. </p>', 'KeyUsage$DigitalSignature' => '<p> Key can be used for digital signing.</p>', 'KeyUsage$NonRepudiation' => '<p>Key can be used for non-repudiation.</p>', 'KeyUsage$KeyEncipherment' => '<p>Key can be used to encipher data.</p>', 'KeyUsage$DataEncipherment' => '<p>Key can be used to decipher data.</p>', 'KeyUsage$KeyAgreement' => '<p>Key can be used in a key-agreement protocol.</p>', 'KeyUsage$KeyCertSign' => '<p>Key can be used to sign certificates.</p>', 'KeyUsage$CRLSign' => '<p>Key can be used to sign CRLs.</p>', 'KeyUsage$EncipherOnly' => '<p>Key can be used only to encipher data.</p>', 'KeyUsage$DecipherOnly' => '<p>Key can be used only to decipher data.</p>', 'OcspConfiguration$Enabled' => '<p>Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating certificate revocation status.</p>', ], ], 'CertificateAuthorities' => [ 'base' => NULL, 'refs' => [ 'ListCertificateAuthoritiesResponse$CertificateAuthorities' => '<p>Summary information about each certificate authority you have created.</p>', ], ], 'CertificateAuthority' => [ 'base' => '<p>Contains information about your private certificate authority (CA). Your private CA can issue and revoke X.509 digital certificates. Digital certificates verify that the entity named in the certificate <b>Subject</b> field owns or controls the public key contained in the <b>Subject Public Key Info</b> field. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action to create your private CA. You must then call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificateAuthorityCertificate.html">GetCertificateAuthorityCertificate</a> action to retrieve a private CA certificate signing request (CSR). Sign the CSR with your ACM Private CA-hosted or on-premises root or subordinate CA certificate. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html">ImportCertificateAuthorityCertificate</a> action to import the signed certificate into AWS Certificate Manager (ACM). </p>', 'refs' => [ 'CertificateAuthorities$member' => NULL, 'DescribeCertificateAuthorityResponse$CertificateAuthority' => '<p>A <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CertificateAuthority.html">CertificateAuthority</a> structure that contains information about your private CA.</p>', ], ], 'CertificateAuthorityConfiguration' => [ 'base' => '<p>Contains configuration information for your private certificate authority (CA). This includes information about the class of public key algorithm and the key pair that your private CA creates when it issues a certificate. It also includes the signature algorithm that it uses when issuing certificates, and its X.500 distinguished name. You must specify this information when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> action. </p>', 'refs' => [ 'CertificateAuthority$CertificateAuthorityConfiguration' => '<p>Your private CA configuration.</p>', 'CreateCertificateAuthorityRequest$CertificateAuthorityConfiguration' => '<p>Name and bit size of the private key algorithm, the name of the signing algorithm, and X.500 certificate subject information.</p>', ], ], 'CertificateAuthorityStatus' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthority$Status' => '<p>Status of your private CA.</p>', 'UpdateCertificateAuthorityRequest$Status' => '<p>Status of your private CA.</p>', ], ], 'CertificateAuthorityType' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthority$Type' => '<p>Type of your private CA.</p>', 'CreateCertificateAuthorityRequest$CertificateAuthorityType' => '<p>The type of the certificate authority.</p>', ], ], 'CertificateBody' => [ 'base' => NULL, 'refs' => [ 'GetCertificateAuthorityCertificateResponse$Certificate' => '<p>Base64-encoded certificate authority (CA) certificate.</p>', 'GetCertificateResponse$Certificate' => '<p>The base64 PEM-encoded certificate specified by the <code>CertificateArn</code> parameter.</p>', ], ], 'CertificateBodyBlob' => [ 'base' => NULL, 'refs' => [ 'ImportCertificateAuthorityCertificateRequest$Certificate' => '<p>The PEM-encoded certificate for a private CA. This may be a self-signed certificate in the case of a root CA, or it may be signed by another CA that you control.</p>', ], ], 'CertificateChain' => [ 'base' => NULL, 'refs' => [ 'GetCertificateAuthorityCertificateResponse$CertificateChain' => '<p>Base64-encoded certificate chain that includes any intermediate certificates and chains up to root certificate that you used to sign your private CA certificate. The chain does not include your private CA certificate. If this is a root CA, the value will be null.</p>', 'GetCertificateResponse$CertificateChain' => '<p>The base64 PEM-encoded certificate chain that chains up to the root CA certificate that you used to sign your private CA certificate. </p>', ], ], 'CertificateChainBlob' => [ 'base' => NULL, 'refs' => [ 'ImportCertificateAuthorityCertificateRequest$CertificateChain' => '<p>A PEM-encoded file that contains all of your certificates, other than the certificate you\'re importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root certificate is the last in the chain, and each certificate in the chain signs the one preceding. </p> <p>This parameter must be supplied when you import a subordinate CA. When you import a root CA, there is no chain.</p>', ], ], 'CertificateMismatchException' => [ 'base' => '<p>The certificate authority certificate you are importing does not comply with conditions specified in the certificate that signed it.</p>', 'refs' => [], ], 'CertificatePolicyList' => [ 'base' => NULL, 'refs' => [ 'Extensions$CertificatePolicies' => '<p>Contains a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers. For more information, see NIST\'s definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.</p> <p>In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the purposes for which it may be used. In a CA certificate, these terms limit the set of policies for certification paths that include this certificate.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>A previous update to your private CA is still ongoing.</p>', 'refs' => [], ], 'CountryCodeString' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$Country' => '<p>Two-digit code that specifies the country in which the certificate subject located.</p>', ], ], 'CreateCertificateAuthorityAuditReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCertificateAuthorityAuditReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCertificateAuthorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCertificateAuthorityResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CrlConfiguration' => [ 'base' => '<p>Contains configuration information for a certificate revocation list (CRL). Your private certificate authority (CA) creates base CRLs. Delta CRLs are not supported. You can enable CRLs for your new or an existing private CA by setting the <b>Enabled</b> parameter to <code>true</code>. Your private CA writes CRLs to an S3 bucket that you specify in the <b>S3BucketName</b> parameter. You can hide the name of your bucket by specifying a value for the <b>CustomCname</b> parameter. Your private CA copies the CNAME or the S3 bucket name to the <b>CRL Distribution Points</b> extension of each certificate it issues. Your S3 bucket policy must give write permission to ACM Private CA. </p> <p>ACM Private CA assets that are stored in Amazon S3 can be protected with encryption. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#crl-encryption">Encrypting Your CRLs</a>.</p> <p>Your private CA uses the value in the <b>ExpirationInDays</b> parameter to calculate the <b>nextUpdate</b> field in the CRL. The CRL is refreshed at 1/2 the age of next update or when a certificate is revoked. When a certificate is revoked, it is recorded in the next CRL that is generated and in the next audit report. Only time valid certificates are listed in the CRL. Expired certificates are not included.</p> <p>A CRL is typically updated approximately 30 minutes after a certificate is revoked. If for any reason a CRL update fails, ACM Private CA makes further attempts every 15 minutes.</p> <p>CRLs contain the following fields:</p> <ul> <li> <p> <b>Version</b>: The current version number defined in RFC 5280 is V2. The integer value is 0x1. </p> </li> <li> <p> <b>Signature Algorithm</b>: The name of the algorithm used to sign the CRL.</p> </li> <li> <p> <b>Issuer</b>: The X.500 distinguished name of your private CA that issued the CRL.</p> </li> <li> <p> <b>Last Update</b>: The issue date and time of this CRL.</p> </li> <li> <p> <b>Next Update</b>: The day and time by which the next CRL will be issued.</p> </li> <li> <p> <b>Revoked Certificates</b>: List of revoked certificates. Each list item contains the following information.</p> <ul> <li> <p> <b>Serial Number</b>: The serial number, in hexadecimal format, of the revoked certificate.</p> </li> <li> <p> <b>Revocation Date</b>: Date and time the certificate was revoked.</p> </li> <li> <p> <b>CRL Entry Extensions</b>: Optional extensions for the CRL entry.</p> <ul> <li> <p> <b>X509v3 CRL Reason Code</b>: Reason the certificate was revoked.</p> </li> </ul> </li> </ul> </li> <li> <p> <b>CRL Extensions</b>: Optional extensions for the CRL.</p> <ul> <li> <p> <b>X509v3 Authority Key Identifier</b>: Identifies the public key associated with the private key used to sign the certificate.</p> </li> <li> <p> <b>X509v3 CRL Number:</b>: Decimal sequence number for the CRL.</p> </li> </ul> </li> <li> <p> <b>Signature Algorithm</b>: Algorithm used by your private CA to sign the CRL.</p> </li> <li> <p> <b>Signature Value</b>: Signature computed over the CRL.</p> </li> </ul> <p>Certificate revocation lists created by ACM Private CA are DER-encoded. You can use the following OpenSSL command to list a CRL.</p> <p> <code>openssl crl -inform DER -text -in <i>crl_path</i> -noout</code> </p> <p>For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html">Planning a certificate revocation list (CRL)</a> in the <i>AWS Certificate Manager Private Certificate Authority (PCA) User Guide</i> </p>', 'refs' => [ 'RevocationConfiguration$CrlConfiguration' => '<p>Configuration of the certificate revocation list (CRL), if any, maintained by your private CA. A CRL is typically updated approximately 30 minutes after a certificate is revoked. If for any reason a CRL update fails, ACM Private CA makes further attempts every 15 minutes.</p>', ], ], 'CsrBlob' => [ 'base' => NULL, 'refs' => [ 'IssueCertificateRequest$Csr' => '<p>The certificate signing request (CSR) for the certificate you want to issue. As an example, you can use the following OpenSSL command to create the CSR and a 2048 bit RSA private key. </p> <p> <code>openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code> </p> <p>If you have a configuration file, you can then use the following OpenSSL command. The <code>usr_cert</code> block in the configuration file contains your X509 version 3 extensions. </p> <p> <code>openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days -365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code> </p> <p>Note: A CSR must provide either a <i>subject name</i> or a <i>subject alternative name</i> or the request will be rejected. </p>', ], ], 'CsrBody' => [ 'base' => NULL, 'refs' => [ 'GetCertificateAuthorityCsrResponse$Csr' => '<p>The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.</p>', ], ], 'CsrExtensions' => [ 'base' => '<p>Describes the certificate extensions to be added to the certificate signing request (CSR).</p>', 'refs' => [ 'CertificateAuthorityConfiguration$CsrExtensions' => '<p>Specifies information to be added to the extension section of the certificate signing request (CSR).</p>', ], ], 'CustomObjectIdentifier' => [ 'base' => NULL, 'refs' => [ 'AccessMethod$CustomObjectIdentifier' => '<p>An object identifier (OID) specifying the <code>AccessMethod</code>. The OID must satisfy the regular expression shown below. For more information, see NIST\'s definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.</p>', 'ExtendedKeyUsage$ExtendedKeyUsageObjectIdentifier' => '<p>Specifies a custom <code>ExtendedKeyUsage</code> with an object identifier (OID).</p>', 'GeneralName$RegisteredId' => '<p> Represents <code>GeneralName</code> as an object identifier (OID).</p>', 'OtherName$TypeId' => '<p>Specifies an OID. </p>', 'PolicyInformation$CertPolicyId' => '<p>Specifies the object identifier (OID) of the certificate policy under which the certificate was issued. For more information, see NIST\'s definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.</p>', ], ], 'DeleteCertificateAuthorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificateAuthorityAuditReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificateAuthorityAuditReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificateAuthorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificateAuthorityResponse' => [ 'base' => NULL, 'refs' => [], ], 'EdiPartyName' => [ 'base' => '<p>Describes an Electronic Data Interchange (EDI) entity as described in as defined in <a href="https://tools.ietf.org/html/rfc5280">Subject Alternative Name</a> in RFC 5280.</p>', 'refs' => [ 'GeneralName$EdiPartyName' => '<p>Represents <code>GeneralName</code> as an <code>EdiPartyName</code> object.</p>', ], ], 'ExtendedKeyUsage' => [ 'base' => '<p>Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the <code>KeyUsage</code> extension.</p>', 'refs' => [ 'ExtendedKeyUsageList$member' => NULL, ], ], 'ExtendedKeyUsageList' => [ 'base' => NULL, 'refs' => [ 'Extensions$ExtendedKeyUsage' => '<p>Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the <code>KeyUsage</code> extension.</p>', ], ], 'ExtendedKeyUsageType' => [ 'base' => NULL, 'refs' => [ 'ExtendedKeyUsage$ExtendedKeyUsageType' => '<p>Specifies a standard <code>ExtendedKeyUsage</code> as defined as in <a href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280</a>.</p>', ], ], 'Extensions' => [ 'base' => '<p>Contains X.509 extension information for a certificate.</p>', 'refs' => [ 'ApiPassthrough$Extensions' => '<p>Specifies X.509 extension information for a certificate.</p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthority$FailureReason' => '<p>Reason the request to create your private CA failed.</p>', ], ], 'GeneralName' => [ 'base' => '<p>Describes an ASN.1 X.400 <code>GeneralName</code> as defined in <a href="https://tools.ietf.org/html/rfc5280">RFC 5280</a>. Only one of the following naming options should be provided. Providing more than one option results in an <code>InvalidArgsException</code> error.</p>', 'refs' => [ 'AccessDescription$AccessLocation' => '<p>The location of <code>AccessDescription</code> information.</p>', 'GeneralNameList$member' => NULL, ], ], 'GeneralNameList' => [ 'base' => NULL, 'refs' => [ 'Extensions$SubjectAlternativeNames' => '<p>The subject alternative name extension allows identities to be bound to the subject of the certificate. These identities may be included in addition to or in place of the identity in the subject field of the certificate.</p>', ], ], 'GetCertificateAuthorityCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCertificateAuthorityCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCertificateAuthorityCsrRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCertificateAuthorityCsrResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'CreateCertificateAuthorityRequest$IdempotencyToken' => '<p>Custom string that can be used to distinguish between calls to the <b>CreateCertificateAuthority</b> action. Idempotency tokens for <b>CreateCertificateAuthority</b> time out after five minutes. Therefore, if you call <b>CreateCertificateAuthority</b> multiple times with the same idempotency token within five minutes, ACM Private CA recognizes that you are requesting only certificate authority and will issue only one. If you change the idempotency token for each call, PCA recognizes that you are requesting multiple certificate authorities.</p>', 'IssueCertificateRequest$IdempotencyToken' => '<p>Alphanumeric string that can be used to distinguish between calls to the <b>IssueCertificate</b> action. Idempotency tokens for <b>IssueCertificate</b> time out after one minute. Therefore, if you call <b>IssueCertificate</b> multiple times with the same idempotency token within one minute, ACM Private CA recognizes that you are requesting only one certificate and will issue only one. If you change the idempotency token for each call, PCA recognizes that you are requesting multiple certificates.</p>', ], ], 'ImportCertificateAuthorityCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'Integer1To5000' => [ 'base' => NULL, 'refs' => [ 'CrlConfiguration$ExpirationInDays' => '<p>Validity period of the CRL in days.</p>', ], ], 'InvalidArgsException' => [ 'base' => '<p>One or more of the specified arguments was not valid.</p>', 'refs' => [], ], 'InvalidArnException' => [ 'base' => '<p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your previous call to <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities</a>.</p>', 'refs' => [], ], 'InvalidPolicyException' => [ 'base' => '<p>The resource policy is invalid or is missing a required statement. For general information about IAM policy and statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies</a>.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request action cannot be performed or is prohibited.</p>', 'refs' => [], ], 'InvalidStateException' => [ 'base' => '<p>The state of the private CA does not allow this action to occur.</p>', 'refs' => [], ], 'InvalidTagException' => [ 'base' => '<p>The tag associated with the CA is not valid. The invalid argument is contained in the message field.</p>', 'refs' => [], ], 'IssueCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'IssueCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'KeyAlgorithm' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthorityConfiguration$KeyAlgorithm' => '<p>Type of the public key algorithm and size, in bits, of the key pair that your CA creates when it issues a certificate. When you create a subordinate CA, you must use a key algorithm supported by the parent CA.</p>', ], ], 'KeyStorageSecurityStandard' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthority$KeyStorageSecurityStandard' => '<p>Defines a cryptographic key management compliance standard used for handling CA keys. </p> <p>Default: FIPS_140_2_LEVEL_3_OR_HIGHER</p> <p>Note: AWS Region ap-northeast-3 supports only FIPS_140_2_LEVEL_2_OR_HIGHER. You must explicitly specify this parameter and value when creating a CA in that Region. Specifying a different value (or no value) results in an <code>InvalidArgsException</code> with the message "A certificate authority cannot be created in this region with the specified security standard."</p>', 'CreateCertificateAuthorityRequest$KeyStorageSecurityStandard' => '<p>Specifies a cryptographic key management compliance standard used for handling CA keys.</p> <p>Default: FIPS_140_2_LEVEL_3_OR_HIGHER</p> <p>Note: <code>FIPS_140_2_LEVEL_3_OR_HIGHER</code> is not supported in Region ap-northeast-3. When creating a CA in the ap-northeast-3, you must provide <code>FIPS_140_2_LEVEL_2_OR_HIGHER</code> as the argument for <code>KeyStorageSecurityStandard</code>. Failure to do this results in an <code>InvalidArgsException</code> with the message, "A certificate authority cannot be created in this region with the specified security standard."</p>', ], ], 'KeyUsage' => [ 'base' => '<p>Defines one or more purposes for which the key contained in the certificate can be used. Default value for each option is false.</p>', 'refs' => [ 'CsrExtensions$KeyUsage' => '<p>Indicates the purpose of the certificate and of the key contained in the certificate.</p>', 'Extensions$KeyUsage' => NULL, ], ], 'LimitExceededException' => [ 'base' => '<p>An ACM Private CA quota has been exceeded. See the exception message returned to determine the quota that was exceeded.</p>', 'refs' => [], ], 'ListCertificateAuthoritiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCertificateAuthoritiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LockoutPreventedException' => [ 'base' => '<p>The current action was prevented because it would lock the caller out from performing subsequent actions. Verify that the specified parameters would not result in the caller being denied access to the resource. </p>', 'refs' => [], ], 'MalformedCSRException' => [ 'base' => '<p>The certificate signing request is invalid.</p>', 'refs' => [], ], 'MalformedCertificateException' => [ 'base' => '<p>One or more fields in the certificate are invalid.</p>', 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCertificateAuthoritiesRequest$MaxResults' => '<p>Use this parameter when paginating results to specify the maximum number of items to return in the response on each page. If additional items exist beyond the number you specify, the <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional items.</p>', 'ListPermissionsRequest$MaxResults' => '<p>When paginating results, use this parameter to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the <b>NextToken</b> element is sent in the response. Use this <b>NextToken</b> value in a subsequent request to retrieve additional items.</p>', 'ListTagsRequest$MaxResults' => '<p>Use this parameter when paginating results to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the <b>NextToken</b> element is sent in the response. Use this <b>NextToken</b> value in a subsequent request to retrieve additional items.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListCertificateAuthoritiesRequest$NextToken' => '<p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.</p>', 'ListCertificateAuthoritiesResponse$NextToken' => '<p>When the list is truncated, this value is present and should be used for the <code>NextToken</code> parameter in a subsequent pagination request.</p>', 'ListPermissionsRequest$NextToken' => '<p>When paginating results, use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>', 'ListPermissionsResponse$NextToken' => '<p>When the list is truncated, this value is present and should be used for the <b>NextToken</b> parameter in a subsequent pagination request. </p>', 'ListTagsRequest$NextToken' => '<p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>', 'ListTagsResponse$NextToken' => '<p>When the list is truncated, this value is present and should be used for the <b>NextToken</b> parameter in a subsequent pagination request. </p>', ], ], 'OcspConfiguration' => [ 'base' => '<p>Contains information to enable and configure Online Certificate Status Protocol (OCSP) for validating certificate revocation status.</p> <p>When you revoke a certificate, OCSP responses may take up to 60 minutes to reflect the new status.</p>', 'refs' => [ 'RevocationConfiguration$OcspConfiguration' => '<p>Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by your private CA. When you revoke a certificate, OCSP responses may take up to 60 minutes to reflect the new status.</p>', ], ], 'OtherName' => [ 'base' => '<p>Defines a custom ASN.1 X.400 <code>GeneralName</code> using an object identifier (OID) and value. The OID must satisfy the regular expression shown below. For more information, see NIST\'s definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.</p>', 'refs' => [ 'GeneralName$OtherName' => '<p>Represents <code>GeneralName</code> using an <code>OtherName</code> object.</p>', ], ], 'PermanentDeletionTimeInDays' => [ 'base' => NULL, 'refs' => [ 'DeleteCertificateAuthorityRequest$PermanentDeletionTimeInDays' => '<p>The number of days to make a CA restorable after it has been deleted. This can be anywhere from 7 to 30 days, with 30 being the default.</p>', ], ], 'Permission' => [ 'base' => '<p>Permissions designate which private CA actions can be performed by an AWS service or entity. In order for ACM to automatically renew private certificates, you must give the ACM service principal all available permissions (<code>IssueCertificate</code>, <code>GetCertificate</code>, and <code>ListPermissions</code>). Permissions can be assigned with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html">CreatePermission</a> action, removed with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html">DeletePermission</a> action, and listed with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html">ListPermissions</a> action.</p>', 'refs' => [ 'PermissionList$member' => NULL, ], ], 'PermissionAlreadyExistsException' => [ 'base' => '<p>The designated permission has already been given to the user.</p>', 'refs' => [], ], 'PermissionList' => [ 'base' => NULL, 'refs' => [ 'ListPermissionsResponse$Permissions' => '<p>Summary information about each permission assigned by the specified private CA, including the action enabled, the policy provided, and the time of creation.</p>', ], ], 'PolicyInformation' => [ 'base' => '<p>Defines the X.509 <code>CertificatePolicies</code> extension.</p>', 'refs' => [ 'CertificatePolicyList$member' => NULL, ], ], 'PolicyQualifierId' => [ 'base' => NULL, 'refs' => [ 'PolicyQualifierInfo$PolicyQualifierId' => '<p>Identifies the qualifier modifying a <code>CertPolicyId</code>.</p>', ], ], 'PolicyQualifierInfo' => [ 'base' => '<p>Modifies the <code>CertPolicyId</code> of a <code>PolicyInformation</code> object with a qualifier. ACM Private CA supports the certification practice statement (CPS) qualifier.</p>', 'refs' => [ 'PolicyQualifierInfoList$member' => NULL, ], ], 'PolicyQualifierInfoList' => [ 'base' => NULL, 'refs' => [ 'PolicyInformation$PolicyQualifiers' => '<p>Modifies the given <code>CertPolicyId</code> with a qualifier. ACM Private CA supports the certification practice statement (CPS) qualifier.</p>', ], ], 'PositiveLong' => [ 'base' => NULL, 'refs' => [ 'Validity$Value' => '<p>A long integer interpreted according to the value of <code>Type</code>, below.</p>', ], ], 'Principal' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionRequest$Principal' => '<p>The AWS service or identity that receives the permission. At this time, the only valid principal is <code>acm.amazonaws.com</code>.</p>', 'DeletePermissionRequest$Principal' => '<p>The AWS service or identity that will have its CA permissions revoked. At this time, the only valid service principal is <code>acm.amazonaws.com</code> </p>', 'Permission$Principal' => '<p>The AWS service or entity that holds the permission. At this time, the only valid principal is <code>acm.amazonaws.com</code>.</p>', ], ], 'PutPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'Qualifier' => [ 'base' => '<p>Defines a <code>PolicyInformation</code> qualifier. ACM Private CA supports the <a href="https://tools.ietf.org/html/rfc5280#section-4.2.1.4">certification practice statement (CPS) qualifier</a> defined in RFC 5280. </p>', 'refs' => [ 'PolicyQualifierInfo$Qualifier' => '<p>Defines the qualifier type. ACM Private CA supports the use of a URI for a CPS qualifier in this field.</p>', ], ], 'RequestAlreadyProcessedException' => [ 'base' => '<p>Your request has already been completed.</p>', 'refs' => [], ], 'RequestFailedException' => [ 'base' => '<p>The request has failed for an unspecified reason.</p>', 'refs' => [], ], 'RequestInProgressException' => [ 'base' => '<p>Your request is already in progress.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>A resource such as a private CA, S3 bucket, certificate, audit report, or policy cannot be found.</p>', 'refs' => [], ], 'ResourceOwner' => [ 'base' => NULL, 'refs' => [ 'ListCertificateAuthoritiesRequest$ResourceOwner' => '<p>Use this parameter to filter the returned set of certificate authorities based on their owner. The default is SELF.</p>', ], ], 'RestoreCertificateAuthorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'RevocationConfiguration' => [ 'base' => '<p>Certificate revocation information used by the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> actions. Your private certificate authority (CA) can configure Online Certificate Status Protocol (OCSP) support and/or maintain a certificate revocation list (CRL). OCSP returns validation information about certificates as requested by clients, and a CRL contains an updated list of certificates revoked by your CA. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html">RevokeCertificate</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/revocation-setup.html">Setting up a certificate revocation method</a> in the <i>AWS Certificate Manager Private Certificate Authority (PCA) User Guide</i>.</p>', 'refs' => [ 'CertificateAuthority$RevocationConfiguration' => '<p>Information about the Online Certificate Status Protocol (OCSP) configuration or certificate revocation list (CRL) created and maintained by your private CA. </p>', 'CreateCertificateAuthorityRequest$RevocationConfiguration' => '<p>Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate revocation list (CRL), to enable both, or to enable neither. The default is for both certificate validation mechanisms to be disabled. For more information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>', 'UpdateCertificateAuthorityRequest$RevocationConfiguration' => '<p>Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate revocation list (CRL), to enable both, or to enable neither. If this parameter is not supplied, existing capibilites remain unchanged. For more information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a> and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a> types.</p>', ], ], 'RevocationReason' => [ 'base' => NULL, 'refs' => [ 'RevokeCertificateRequest$RevocationReason' => '<p>Specifies why you revoked the certificate.</p>', ], ], 'RevokeCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'CreateCertificateAuthorityAuditReportRequest$S3BucketName' => '<p>The name of the S3 bucket that will contain the audit report.</p>', 'DescribeCertificateAuthorityAuditReportResponse$S3BucketName' => '<p>Name of the S3 bucket that contains the report.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'CreateCertificateAuthorityAuditReportResponse$S3Key' => '<p>The <b>key</b> that uniquely identifies the report file in your S3 bucket.</p>', 'DescribeCertificateAuthorityAuditReportResponse$S3Key' => '<p>S3 <b>key</b> that uniquely identifies the report file in your S3 bucket.</p>', ], ], 'S3ObjectAcl' => [ 'base' => NULL, 'refs' => [ 'CrlConfiguration$S3ObjectAcl' => '<p>Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. If you choose PUBLIC_READ, the CRL will be accessible over the public internet. If you choose BUCKET_OWNER_FULL_CONTROL, only the owner of the CRL S3 bucket can access the CRL, and your PKI clients may need an alternative method of access. </p> <p>If no value is specified, the default is <code>PUBLIC_READ</code>.</p> <p> <i>Note:</i> This default can cause CA creation to fail in some circumstances. If you have have enabled the Block Public Access (BPA) feature in your S3 account, then you must specify the value of this parameter as <code>BUCKET_OWNER_FULL_CONTROL</code>, and not doing so results in an error. If you have disabled BPA in S3, then you can specify either <code>BUCKET_OWNER_FULL_CONTROL</code> or <code>PUBLIC_READ</code> as the value.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-bpa">Blocking public access to the S3 bucket</a>.</p>', ], ], 'SigningAlgorithm' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthorityConfiguration$SigningAlgorithm' => '<p>Name of the algorithm your private CA uses to sign certificate requests.</p> <p>This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign certificates when they are issued.</p>', 'IssueCertificateRequest$SigningAlgorithm' => '<p>The name of the algorithm that will be used to sign the certificate to be issued. </p> <p>This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign a CSR in the <code>CreateCertificateAuthority</code> action.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthority$Serial' => '<p>Serial number of your private CA.</p>', 'CertificateMismatchException$message' => NULL, 'ConcurrentModificationException$message' => NULL, 'InvalidArgsException$message' => NULL, 'InvalidArnException$message' => NULL, 'InvalidNextTokenException$message' => NULL, 'InvalidPolicyException$message' => NULL, 'InvalidRequestException$message' => NULL, 'InvalidStateException$message' => NULL, 'InvalidTagException$message' => NULL, 'LimitExceededException$message' => NULL, 'LockoutPreventedException$message' => NULL, 'MalformedCSRException$message' => NULL, 'MalformedCertificateException$message' => NULL, 'PermissionAlreadyExistsException$message' => NULL, 'RequestAlreadyProcessedException$message' => NULL, 'RequestFailedException$message' => NULL, 'RequestInProgressException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'TooManyTagsException$message' => NULL, ], ], 'String128' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$State' => '<p>State in which the subject of the certificate is located.</p>', 'ASN1Subject$Locality' => '<p>The locality (such as a city or town) in which the certificate subject is located.</p>', 'ASN1Subject$Pseudonym' => '<p>Typically a shortened version of a longer <b>GivenName</b>. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza.</p>', 'RevokeCertificateRequest$CertificateSerial' => '<p>Serial number of the certificate to be revoked. This must be in hexadecimal format. You can retrieve the serial number by calling <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate</a> with the Amazon Resource Name (ARN) of the certificate you want and the ARN of your private CA. The <b>GetCertificate</b> action retrieves the certificate in the PEM format. You can use the following OpenSSL command to list the certificate in text format and copy the hexadecimal serial number. </p> <p> <code>openssl x509 -in <i>file_path</i> -text -noout</code> </p> <p>You can also copy the serial number from the console or use the <a href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html">DescribeCertificate</a> action in the <i>AWS Certificate Manager API Reference</i>. </p>', ], ], 'String16' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$GivenName' => '<p>First name.</p>', ], ], 'String253' => [ 'base' => NULL, 'refs' => [ 'CrlConfiguration$CustomCname' => '<p>Name inserted into the certificate <b>CRL Distribution Points</b> extension that enables the use of an alias for the CRL distribution point. Use this value if you don\'t want the name of your S3 bucket to be public.</p>', 'GeneralName$DnsName' => '<p>Represents <code>GeneralName</code> as a DNS name.</p>', 'GeneralName$UniformResourceIdentifier' => '<p>Represents <code>GeneralName</code> as a URI.</p>', 'OcspConfiguration$OcspCustomCname' => '<p>By default, ACM Private CA injects an AWS domain into certificates being validated by the Online Certificate Status Protocol (OCSP). A customer can alternatively use this object to define a CNAME specifying a customized OCSP domain.</p> <p>Note: The value of the CNAME must not include a protocol prefix such as "http://" or "https://".</p> <p>For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/ocsp-customize.html">Customizing Online Certificate Status Protocol (OCSP) </a> in the <i>AWS Certificate Manager Private Certificate Authority (PCA) User Guide</i>.</p>', ], ], 'String256' => [ 'base' => NULL, 'refs' => [ 'EdiPartyName$PartyName' => '<p>Specifies the party name.</p>', 'EdiPartyName$NameAssigner' => '<p>Specifies the name assigner.</p>', 'GeneralName$Rfc822Name' => '<p>Represents <code>GeneralName</code> as an <a href="https://tools.ietf.org/html/rfc822">RFC 822</a> email address.</p>', 'OtherName$Value' => '<p>Specifies an OID value.</p>', 'Qualifier$CpsUri' => '<p>Contains a pointer to a certification practice statement (CPS) published by the CA.</p>', ], ], 'String3' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$GenerationQualifier' => '<p>Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third.</p>', ], ], 'String39' => [ 'base' => NULL, 'refs' => [ 'GeneralName$IpAddress' => '<p>Represents <code>GeneralName</code> as an IPv4 or IPv6 address.</p>', ], ], 'String3To255' => [ 'base' => NULL, 'refs' => [ 'CrlConfiguration$S3BucketName' => '<p>Name of the S3 bucket that contains the CRL. If you do not provide a value for the <b>CustomCname</b> argument, the name of your S3 bucket is placed into the <b>CRL Distribution Points</b> extension of the issued certificate. You can change the name of your bucket by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority</a> operation. You must specify a <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-policies">bucket policy</a> that allows ACM Private CA to write the CRL to your bucket.</p>', ], ], 'String40' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$Surname' => '<p>Family name. In the US and the UK, for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first.</p>', ], ], 'String5' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$Initials' => '<p>Concatenation that typically contains the first letter of the <b>GivenName</b>, the first letter of the middle name if one exists, and the first letter of the <b>Surname</b>.</p>', ], ], 'String64' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$Organization' => '<p>Legal name of the organization with which the certificate subject is affiliated. </p>', 'ASN1Subject$OrganizationalUnit' => '<p>A subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated.</p>', 'ASN1Subject$CommonName' => '<p>For CA and end-entity certificates in a private PKI, the common name (CN) can be any string within the length limit. </p> <p>Note: In publicly trusted certificates, the common name must be a fully qualified domain name (FQDN) associated with the certificate subject.</p>', 'ASN1Subject$Title' => '<p>A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the certificate subject.</p>', ], ], 'TStamp' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthority$CreatedAt' => '<p>Date and time at which your private CA was created.</p>', 'CertificateAuthority$LastStateChangeAt' => '<p>Date and time at which your private CA was last updated.</p>', 'CertificateAuthority$NotBefore' => '<p>Date and time before which your private CA certificate is not valid.</p>', 'CertificateAuthority$NotAfter' => '<p>Date and time after which your private CA certificate is not valid.</p>', 'CertificateAuthority$RestorableUntil' => '<p>The period during which a deleted CA can be restored. For more information, see the <code>PermanentDeletionTimeInDays</code> parameter of the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthorityRequest.html">DeleteCertificateAuthorityRequest</a> action. </p>', 'DescribeCertificateAuthorityAuditReportResponse$CreatedAt' => '<p>The date and time at which the report was created.</p>', 'Permission$CreatedAt' => '<p>The time at which the permission was created.</p>', ], ], 'Tag' => [ 'base' => '<p>Tags are labels that you can use to identify and organize your private CAs. Each tag consists of a key and an optional value. You can associate up to 50 tags with a private CA. To add one or more tags to a private CA, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html">TagCertificateAuthority</a> action. To remove a tag, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html">UntagCertificateAuthority</a> action. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagCertificateAuthorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>Key (name) of the tag.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateCertificateAuthorityRequest$Tags' => '<p>Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a private CA. For information using tags with IAM to manage permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>', 'ListTagsResponse$Tags' => '<p>The tags associated with your private CA.</p>', 'TagCertificateAuthorityRequest$Tags' => '<p>List of tags to be associated with the CA.</p>', 'UntagCertificateAuthorityRequest$Tags' => '<p>List of tags to be removed from the CA.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Value of the tag.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>You can associate up to 50 tags with a private CA. Exception information is contained in the exception message field.</p>', 'refs' => [], ], 'UntagCertificateAuthorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCertificateAuthorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'Validity' => [ 'base' => '<p>Validity specifies the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the validity of a certificate starts or expires, or as a span of time after issuance, stated in days, months, or years. For more information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280.</p> <p>ACM Private CA API consumes the <code>Validity</code> data type differently in two distinct parameters of the <code>IssueCertificate</code> action. The required parameter <code>IssueCertificate</code>:<code>Validity</code> specifies the end of a certificate\'s validity period. The optional parameter <code>IssueCertificate</code>:<code>ValidityNotBefore</code> specifies a customized starting time for the validity period.</p>', 'refs' => [ 'IssueCertificateRequest$Validity' => '<p>Information describing the end of the validity period of the certificate. This parameter sets the “Not After” date for the certificate.</p> <p>Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in days, months, or years. For more information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280. </p> <p>This value is unaffected when <code>ValidityNotBefore</code> is also specified. For example, if <code>Validity</code> is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the <code>ValidityNotBefore</code> value.</p> <p>The end of the validity period configured on a certificate must not exceed the limit set on its parents in the CA hierarchy.</p>', 'IssueCertificateRequest$ValidityNotBefore' => '<p>Information describing the start of the validity period of the certificate. This parameter sets the “Not Before" date for the certificate.</p> <p>By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize the “Not Before” value. </p> <p>Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code> parameter is optional.</p> <p>The <code>ValidityNotBefore</code> value is expressed as an explicit date and time, using the <code>Validity</code> type value <code>ABSOLUTE</code>. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_Validity.html">Validity</a> in this API reference and <a href="https://tools.ietf.org/html/rfc5280#section-4.1.2.5">Validity</a> in RFC 5280.</p>', ], ], 'ValidityPeriodType' => [ 'base' => NULL, 'refs' => [ 'Validity$Type' => '<p>Determines how <i>ACM Private CA</i> interprets the <code>Value</code> parameter, an integer. Supported validity types include those listed below. Type definitions with values include a sample input value and the resulting output. </p> <p> <code>END_DATE</code>: The specific date and time when the certificate will expire, expressed using UTCTime (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When UTCTime is used, if the year field (YY) is greater than or equal to 50, the year is interpreted as 19YY. If the year field is less than 50, the year is interpreted as 20YY.</p> <ul> <li> <p>Sample input value: 491231235959 (UTCTime format)</p> </li> <li> <p>Output expiration date/time: 12/31/2049 23:59:59</p> </li> </ul> <p> <code>ABSOLUTE</code>: The specific date and time when the validity of a certificate will start or expire, expressed in seconds since the Unix Epoch. </p> <ul> <li> <p>Sample input value: 2524608000</p> </li> <li> <p>Output expiration date/time: 01/01/2050 00:00:00</p> </li> </ul> <p> <code>DAYS</code>, <code>MONTHS</code>, <code>YEARS</code>: The relative time from the moment of issuance until the certificate will expire, expressed in days, months, or years. </p> <p>Example if <code>DAYS</code>, issued on 10/12/2020 at 12:34:54 UTC:</p> <ul> <li> <p>Sample input value: 90</p> </li> <li> <p>Output expiration date: 01/10/2020 12:34:54 UTC</p> </li> </ul> <p>The minimum validity duration for a certificate using relative time (<code>DAYS</code>) is one day. The minimum validity for a certificate using absolute time (<code>ABSOLUTE</code> or <code>END_DATE</code>) is one second.</p>', ], ], ],];
