<?php
// This file was auto-generated from sdk-root/src/data/alexaforbusiness/2017-11-09/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Alexa for Business helps you use Alexa in your organization. Alexa for Business provides you with the tools to manage Alexa devices, enroll your users, and assign skills, at scale. You can build your own context-aware voice skills using the Alexa Skills Kit and the Alexa for Business API operations. You can also make these available as private skills for your organization. Alexa for Business makes it efficient to voice-enable your products and services, thus providing context-aware voice experiences for your customers. Device makers building with the Alexa Voice Service (AVS) can create fully integrated solutions, register their products with Alexa for Business, and manage them as shared devices in their organization. </p>', 'operations' => [ 'ApproveSkill' => '<p>Associates a skill with the organization under the customer\'s AWS account. If a skill is private, the user implicitly accepts access to this skill during enablement.</p>', 'AssociateContactWithAddressBook' => '<p>Associates a contact with a given address book.</p>', 'AssociateDeviceWithNetworkProfile' => '<p>Associates a device with the specified network profile.</p>', 'AssociateDeviceWithRoom' => '<p>Associates a device with a given room. This applies all the settings from the room profile to the device, and all the skills in any skill groups added to that room. This operation requires the device to be online, or else a manual sync is required. </p>', 'AssociateSkillGroupWithRoom' => '<p>Associates a skill group with a given room. This enables all skills in the associated skill group on all devices in the room.</p>', 'AssociateSkillWithSkillGroup' => '<p>Associates a skill with a skill group.</p>', 'AssociateSkillWithUsers' => '<p>Makes a private skill available for enrolled users to enable on their devices.</p>', 'CreateAddressBook' => '<p>Creates an address book with the specified details.</p>', 'CreateBusinessReportSchedule' => '<p>Creates a recurring schedule for usage reports to deliver to the specified S3 location with a specified daily or weekly interval.</p>', 'CreateConferenceProvider' => '<p>Adds a new conference provider under the user\'s AWS account.</p>', 'CreateContact' => '<p>Creates a contact with the specified details.</p>', 'CreateGatewayGroup' => '<p>Creates a gateway group with the specified details.</p>', 'CreateNetworkProfile' => '<p>Creates a network profile with the specified details.</p>', 'CreateProfile' => '<p>Creates a new room profile with the specified details.</p>', 'CreateRoom' => '<p>Creates a room with the specified details.</p>', 'CreateSkillGroup' => '<p>Creates a skill group with a specified name and description.</p>', 'CreateUser' => '<p>Creates a user.</p>', 'DeleteAddressBook' => '<p>Deletes an address book by the address book ARN.</p>', 'DeleteBusinessReportSchedule' => '<p>Deletes the recurring report delivery schedule with the specified schedule ARN.</p>', 'DeleteConferenceProvider' => '<p>Deletes a conference provider.</p>', 'DeleteContact' => '<p>Deletes a contact by the contact ARN.</p>', 'DeleteDevice' => '<p>Removes a device from Alexa For Business.</p>', 'DeleteDeviceUsageData' => '<p>When this action is called for a specified shared device, it allows authorized users to delete the device\'s entire previous history of voice input data and associated response data. This action can be called once every 24 hours for a specific shared device.</p>', 'DeleteGatewayGroup' => '<p>Deletes a gateway group.</p>', 'DeleteNetworkProfile' => '<p>Deletes a network profile by the network profile ARN.</p>', 'DeleteProfile' => '<p>Deletes a room profile by the profile ARN.</p>', 'DeleteRoom' => '<p>Deletes a room by the room ARN.</p>', 'DeleteRoomSkillParameter' => '<p>Deletes room skill parameter details by room, skill, and parameter key ID.</p>', 'DeleteSkillAuthorization' => '<p>Unlinks a third-party account from a skill.</p>', 'DeleteSkillGroup' => '<p>Deletes a skill group by skill group ARN.</p>', 'DeleteUser' => '<p>Deletes a specified user by user ARN and enrollment ARN.</p>', 'DisassociateContactFromAddressBook' => '<p>Disassociates a contact from a given address book.</p>', 'DisassociateDeviceFromRoom' => '<p>Disassociates a device from its current room. The device continues to be connected to the Wi-Fi network and is still registered to the account. The device settings and skills are removed from the room.</p>', 'DisassociateSkillFromSkillGroup' => '<p>Disassociates a skill from a skill group.</p>', 'DisassociateSkillFromUsers' => '<p>Makes a private skill unavailable for enrolled users and prevents them from enabling it on their devices.</p>', 'DisassociateSkillGroupFromRoom' => '<p>Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in the room.</p>', 'ForgetSmartHomeAppliances' => '<p>Forgets smart home appliances associated to a room.</p>', 'GetAddressBook' => '<p>Gets address the book details by the address book ARN.</p>', 'GetConferencePreference' => '<p>Retrieves the existing conference preferences.</p>', 'GetConferenceProvider' => '<p>Gets details about a specific conference provider.</p>', 'GetContact' => '<p>Gets the contact details by the contact ARN.</p>', 'GetDevice' => '<p>Gets the details of a device by device ARN.</p>', 'GetGateway' => '<p>Retrieves the details of a gateway.</p>', 'GetGatewayGroup' => '<p>Retrieves the details of a gateway group.</p>', 'GetInvitationConfiguration' => '<p>Retrieves the configured values for the user enrollment invitation email template.</p>', 'GetNetworkProfile' => '<p>Gets the network profile details by the network profile ARN.</p>', 'GetProfile' => '<p>Gets the details of a room profile by profile ARN.</p>', 'GetRoom' => '<p>Gets room details by room ARN.</p>', 'GetRoomSkillParameter' => '<p>Gets room skill parameter details by room, skill, and parameter key ARN.</p>', 'GetSkillGroup' => '<p>Gets skill group details by skill group ARN.</p>', 'ListBusinessReportSchedules' => '<p>Lists the details of the schedules that a user configured. A download URL of the report associated with each schedule is returned every time this action is called. A new download URL is returned each time, and is valid for 24 hours.</p>', 'ListConferenceProviders' => '<p>Lists conference providers under a specific AWS account.</p>', 'ListDeviceEvents' => '<p>Lists the device event history, including device connection status, for up to 30 days.</p>', 'ListGatewayGroups' => '<p>Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.</p>', 'ListGateways' => '<p>Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that gateway group ARN.</p>', 'ListSkills' => '<p>Lists all enabled skills in a specific skill group.</p>', 'ListSkillsStoreCategories' => '<p>Lists all categories in the Alexa skill store.</p>', 'ListSkillsStoreSkillsByCategory' => '<p>Lists all skills in the Alexa skill store by category.</p>', 'ListSmartHomeAppliances' => '<p>Lists all of the smart home appliances associated with a room.</p>', 'ListTags' => '<p>Lists all tags for the specified resource.</p>', 'PutConferencePreference' => '<p>Sets the conference preferences on a specific conference provider at the account level.</p>', 'PutInvitationConfiguration' => '<p>Configures the email template for the user enrollment invitation with the specified attributes.</p>', 'PutRoomSkillParameter' => '<p>Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill parameter.</p>', 'PutSkillAuthorization' => '<p>Links a user\'s account to a third-party skill provider. If this API operation is called by an assumed IAM role, the skill being linked must be a private skill. Also, the skill must be owned by the AWS account that assumed the IAM role.</p>', 'RegisterAVSDevice' => '<p>Registers an Alexa-enabled device built by an Original Equipment Manufacturer (OEM) using Alexa Voice Service (AVS).</p>', 'RejectSkill' => '<p>Disassociates a skill from the organization under a user\'s AWS account. If the skill is a private skill, it moves to an AcceptStatus of PENDING. Any private or public skill that is rejected can be added later by calling the ApproveSkill API. </p>', 'ResolveRoom' => '<p>Determines the details for the room from which a skill request was invoked. This operation is used by skill developers.</p> <p>To query ResolveRoom from an Alexa skill, the skill ID needs to be authorized. When the skill is using an AWS Lambda function, the skill is automatically authorized when you publish your skill as a private skill to your AWS account. Skills that are hosted using a custom web service must be manually authorized. To get your skill authorized, contact AWS Support with your AWS account ID that queries the ResolveRoom API and skill ID. </p>', 'RevokeInvitation' => '<p>Revokes an invitation and invalidates the enrollment URL.</p>', 'SearchAddressBooks' => '<p>Searches address books and lists the ones that meet a set of filter and sort criteria.</p>', 'SearchContacts' => '<p>Searches contacts and lists the ones that meet a set of filter and sort criteria.</p>', 'SearchDevices' => '<p>Searches devices and lists the ones that meet a set of filter criteria.</p>', 'SearchNetworkProfiles' => '<p>Searches network profiles and lists the ones that meet a set of filter and sort criteria.</p>', 'SearchProfiles' => '<p>Searches room profiles and lists the ones that meet a set of filter criteria.</p>', 'SearchRooms' => '<p>Searches rooms and lists the ones that meet a set of filter and sort criteria.</p>', 'SearchSkillGroups' => '<p>Searches skill groups and lists the ones that meet a set of filter and sort criteria.</p>', 'SearchUsers' => '<p>Searches users and lists the ones that meet a set of filter and sort criteria.</p>', 'SendAnnouncement' => '<p>Triggers an asynchronous flow to send text, SSML, or audio announcements to rooms that are identified by a search or filter. </p>', 'SendInvitation' => '<p>Sends an enrollment invitation email with a URL to a user. The URL is valid for 30 days or until you call this operation again, whichever comes first. </p>', 'StartDeviceSync' => '<p>Resets a device and its account to the known default settings. This clears all information and settings set by previous users in the following ways:</p> <ul> <li> <p>Bluetooth - This unpairs all bluetooth devices paired with your echo device.</p> </li> <li> <p>Volume - This resets the echo device\'s volume to the default value.</p> </li> <li> <p>Notifications - This clears all notifications from your echo device.</p> </li> <li> <p>Lists - This clears all to-do items from your echo device.</p> </li> <li> <p>Settings - This internally syncs the room\'s profile (if the device is assigned to a room), contacts, address books, delegation access for account linking, and communications (if enabled on the room profile).</p> </li> </ul>', 'StartSmartHomeApplianceDiscovery' => '<p>Initiates the discovery of any smart home appliances associated with the room.</p>', 'TagResource' => '<p>Adds metadata tags to a specified resource.</p>', 'UntagResource' => '<p>Removes metadata tags from a specified resource.</p>', 'UpdateAddressBook' => '<p>Updates address book details by the address book ARN.</p>', 'UpdateBusinessReportSchedule' => '<p>Updates the configuration of the report delivery schedule with the specified schedule ARN.</p>', 'UpdateConferenceProvider' => '<p>Updates an existing conference provider\'s settings.</p>', 'UpdateContact' => '<p>Updates the contact details by the contact ARN.</p>', 'UpdateDevice' => '<p>Updates the device name by device ARN.</p>', 'UpdateGateway' => '<p>Updates the details of a gateway. If any optional field is not provided, the existing corresponding value is left unmodified.</p>', 'UpdateGatewayGroup' => '<p>Updates the details of a gateway group. If any optional field is not provided, the existing corresponding value is left unmodified.</p>', 'UpdateNetworkProfile' => '<p>Updates a network profile by the network profile ARN.</p>', 'UpdateProfile' => '<p>Updates an existing room profile by room profile ARN.</p>', 'UpdateRoom' => '<p>Updates room details by room ARN.</p>', 'UpdateSkillGroup' => '<p>Updates skill group details by skill group ARN.</p>', ], 'shapes' => [ 'Address' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$Address' => '<p>The valid address for the room.</p>', 'Profile$Address' => '<p>The address of a room profile.</p>', 'ProfileData$Address' => '<p>The address of a room profile.</p>', 'UpdateProfileRequest$Address' => '<p>The updated address for the room profile.</p>', ], ], 'AddressBook' => [ 'base' => '<p>An address book with attributes.</p>', 'refs' => [ 'GetAddressBookResponse$AddressBook' => '<p>The details of the requested address book.</p>', ], ], 'AddressBookData' => [ 'base' => '<p>Information related to an address book.</p>', 'refs' => [ 'AddressBookDataList$member' => NULL, ], ], 'AddressBookDataList' => [ 'base' => NULL, 'refs' => [ 'SearchAddressBooksResponse$AddressBooks' => '<p>The address books that meet the specified set of filter criteria, in sort order.</p>', ], ], 'AddressBookDescription' => [ 'base' => NULL, 'refs' => [ 'AddressBook$Description' => '<p>The description of the address book.</p>', 'AddressBookData$Description' => '<p>The description of the address book.</p>', 'CreateAddressBookRequest$Description' => '<p>The description of the address book.</p>', 'UpdateAddressBookRequest$Description' => '<p>The updated description of the room.</p>', ], ], 'AddressBookName' => [ 'base' => NULL, 'refs' => [ 'AddressBook$Name' => '<p>The name of the address book.</p>', 'AddressBookData$Name' => '<p>The name of the address book.</p>', 'CreateAddressBookRequest$Name' => '<p>The name of the address book.</p>', 'UpdateAddressBookRequest$Name' => '<p>The updated name of the room.</p>', ], ], 'AlreadyExistsException' => [ 'base' => '<p>The resource being created already exists.</p>', 'refs' => [], ], 'AmazonId' => [ 'base' => NULL, 'refs' => [ 'RegisterAVSDeviceRequest$AmazonId' => '<p>The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon\'s Developer Console.</p>', ], ], 'ApplianceDescription' => [ 'base' => NULL, 'refs' => [ 'SmartHomeAppliance$Description' => '<p>The description of the smart home appliance.</p>', ], ], 'ApplianceFriendlyName' => [ 'base' => NULL, 'refs' => [ 'SmartHomeAppliance$FriendlyName' => '<p>The friendly name of the smart home appliance.</p>', ], ], 'ApplianceManufacturerName' => [ 'base' => NULL, 'refs' => [ 'SmartHomeAppliance$ManufacturerName' => '<p>The name of the manufacturer of the smart home appliance.</p>', ], ], 'ApproveSkillRequest' => [ 'base' => NULL, 'refs' => [], ], 'ApproveSkillResponse' => [ 'base' => NULL, 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AddressBook$AddressBookArn' => '<p>The ARN of the address book.</p>', 'AddressBookData$AddressBookArn' => '<p>The ARN of the address book.</p>', 'AssociateContactWithAddressBookRequest$ContactArn' => '<p>The ARN of the contact to associate with an address book.</p>', 'AssociateContactWithAddressBookRequest$AddressBookArn' => '<p>The ARN of the address book with which to associate the contact.</p>', 'AssociateDeviceWithNetworkProfileRequest$DeviceArn' => '<p>The device ARN.</p>', 'AssociateDeviceWithNetworkProfileRequest$NetworkProfileArn' => '<p>The ARN of the network profile to associate with a device.</p>', 'AssociateDeviceWithRoomRequest$DeviceArn' => '<p>The ARN of the device to associate to a room. Required.</p>', 'AssociateDeviceWithRoomRequest$RoomArn' => '<p>The ARN of the room with which to associate the device. Required.</p>', 'AssociateSkillGroupWithRoomRequest$SkillGroupArn' => '<p>The ARN of the skill group to associate with a room. Required.</p>', 'AssociateSkillGroupWithRoomRequest$RoomArn' => '<p>The ARN of the room with which to associate the skill group. Required.</p>', 'AssociateSkillWithSkillGroupRequest$SkillGroupArn' => '<p>The ARN of the skill group to associate the skill to. Required.</p>', 'BusinessReportSchedule$ScheduleArn' => '<p>The ARN of the business report schedule.</p>', 'ConferencePreference$DefaultConferenceProviderArn' => '<p>The ARN of the default conference provider.</p>', 'ConferenceProvider$Arn' => '<p>The ARN of the newly created conference provider.</p>', 'Contact$ContactArn' => '<p>The ARN of the contact.</p>', 'ContactData$ContactArn' => '<p>The ARN of the contact.</p>', 'CreateAddressBookResponse$AddressBookArn' => '<p>The ARN of the newly created address book.</p>', 'CreateBusinessReportScheduleResponse$ScheduleArn' => '<p>The ARN of the business report schedule.</p>', 'CreateConferenceProviderResponse$ConferenceProviderArn' => '<p>The ARN of the newly-created conference provider.</p>', 'CreateContactResponse$ContactArn' => '<p>The ARN of the newly created address book.</p>', 'CreateGatewayGroupResponse$GatewayGroupArn' => '<p>The ARN of the created gateway group.</p>', 'CreateNetworkProfileRequest$CertificateAuthorityArn' => '<p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is used to issue certificates to the devices. </p>', 'CreateNetworkProfileResponse$NetworkProfileArn' => '<p>The ARN of the network profile associated with a device.</p>', 'CreateProfileResponse$ProfileArn' => '<p>The ARN of the newly created room profile in the response.</p>', 'CreateRoomRequest$ProfileArn' => '<p>The profile ARN for the room. This is required.</p>', 'CreateRoomResponse$RoomArn' => '<p>The ARN of the newly created room in the response.</p>', 'CreateSkillGroupResponse$SkillGroupArn' => '<p>The ARN of the newly created skill group in the response.</p>', 'CreateUserResponse$UserArn' => '<p>The ARN of the newly created user in the response.</p>', 'DeleteAddressBookRequest$AddressBookArn' => '<p>The ARN of the address book to delete.</p>', 'DeleteBusinessReportScheduleRequest$ScheduleArn' => '<p>The ARN of the business report schedule.</p>', 'DeleteConferenceProviderRequest$ConferenceProviderArn' => '<p>The ARN of the conference provider.</p>', 'DeleteContactRequest$ContactArn' => '<p>The ARN of the contact to delete.</p>', 'DeleteDeviceRequest$DeviceArn' => '<p>The ARN of the device for which to request details.</p>', 'DeleteDeviceUsageDataRequest$DeviceArn' => '<p>The ARN of the device.</p>', 'DeleteGatewayGroupRequest$GatewayGroupArn' => '<p>The ARN of the gateway group to delete.</p>', 'DeleteNetworkProfileRequest$NetworkProfileArn' => '<p>The ARN of the network profile associated with a device.</p>', 'DeleteProfileRequest$ProfileArn' => '<p>The ARN of the room profile to delete. Required.</p>', 'DeleteRoomRequest$RoomArn' => '<p>The ARN of the room to delete. Required.</p>', 'DeleteRoomSkillParameterRequest$RoomArn' => '<p>The ARN of the room from which to remove the room skill parameter details.</p>', 'DeleteSkillAuthorizationRequest$RoomArn' => '<p>The room that the skill is authorized for.</p>', 'DeleteSkillGroupRequest$SkillGroupArn' => '<p>The ARN of the skill group to delete. Required.</p>', 'DeleteUserRequest$UserArn' => '<p>The ARN of the user to delete in the organization. Required.</p>', 'Device$DeviceArn' => '<p>The ARN of a device.</p>', 'Device$RoomArn' => '<p>The room ARN of a device.</p>', 'DeviceData$DeviceArn' => '<p>The ARN of a device.</p>', 'DeviceData$NetworkProfileArn' => '<p>The ARN of the network profile associated with a device.</p>', 'DeviceData$RoomArn' => '<p>The room ARN associated with a device.</p>', 'DeviceNetworkProfileInfo$NetworkProfileArn' => '<p>The ARN of the network profile associated with a device.</p>', 'DeviceNetworkProfileInfo$CertificateArn' => '<p>The ARN of the certificate associated with a device.</p>', 'DisassociateContactFromAddressBookRequest$ContactArn' => '<p>The ARN of the contact to disassociate from an address book.</p>', 'DisassociateContactFromAddressBookRequest$AddressBookArn' => '<p>The ARN of the address from which to disassociate the contact.</p>', 'DisassociateDeviceFromRoomRequest$DeviceArn' => '<p>The ARN of the device to disassociate from a room. Required.</p>', 'DisassociateSkillFromSkillGroupRequest$SkillGroupArn' => '<p>The unique identifier of a skill. Required.</p>', 'DisassociateSkillGroupFromRoomRequest$SkillGroupArn' => '<p>The ARN of the skill group to disassociate from a room. Required.</p>', 'DisassociateSkillGroupFromRoomRequest$RoomArn' => '<p>The ARN of the room from which the skill group is to be disassociated. Required.</p>', 'ForgetSmartHomeAppliancesRequest$RoomArn' => '<p>The room that the appliances are associated with.</p>', 'Gateway$Arn' => '<p>The ARN of the gateway.</p>', 'Gateway$GatewayGroupArn' => '<p>The ARN of the gateway group that the gateway is associated to.</p>', 'GatewayGroup$Arn' => '<p>The ARN of the gateway group.</p>', 'GatewayGroupSummary$Arn' => '<p>The ARN of the gateway group.</p>', 'GatewaySummary$Arn' => '<p>The ARN of the gateway.</p>', 'GatewaySummary$GatewayGroupArn' => '<p>The ARN of the gateway group that the gateway is associated to.</p>', 'GetAddressBookRequest$AddressBookArn' => '<p>The ARN of the address book for which to request details.</p>', 'GetConferenceProviderRequest$ConferenceProviderArn' => '<p>The ARN of the newly created conference provider.</p>', 'GetContactRequest$ContactArn' => '<p>The ARN of the contact for which to request details.</p>', 'GetDeviceRequest$DeviceArn' => '<p>The ARN of the device for which to request details. Required.</p>', 'GetGatewayGroupRequest$GatewayGroupArn' => '<p>The ARN of the gateway group to get.</p>', 'GetGatewayRequest$GatewayArn' => '<p>The ARN of the gateway to get.</p>', 'GetNetworkProfileRequest$NetworkProfileArn' => '<p>The ARN of the network profile associated with a device.</p>', 'GetProfileRequest$ProfileArn' => '<p>The ARN of the room profile for which to request details. Required.</p>', 'GetRoomRequest$RoomArn' => '<p>The ARN of the room for which to request details. Required.</p>', 'GetRoomSkillParameterRequest$RoomArn' => '<p>The ARN of the room from which to get the room skill parameter details. </p>', 'GetSkillGroupRequest$SkillGroupArn' => '<p>The ARN of the skill group for which to get details. Required.</p>', 'ListDeviceEventsRequest$DeviceArn' => '<p>The ARN of a device.</p>', 'ListGatewaysRequest$GatewayGroupArn' => '<p>The gateway group ARN for which to list gateways.</p>', 'ListSkillsRequest$SkillGroupArn' => '<p>The ARN of the skill group for which to list enabled skills.</p>', 'ListSmartHomeAppliancesRequest$RoomArn' => '<p>The room that the appliances are associated with.</p>', 'ListTagsRequest$Arn' => '<p>The ARN of the specified resource for which to list tags.</p>', 'NetworkProfile$NetworkProfileArn' => '<p>The ARN of the network profile associated with a device.</p>', 'NetworkProfile$CertificateAuthorityArn' => '<p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is used to issue certificates to the devices. </p>', 'NetworkProfileData$NetworkProfileArn' => '<p>The ARN of the network profile associated with a device.</p>', 'NetworkProfileData$CertificateAuthorityArn' => '<p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is used to issue certificates to the devices.</p>', 'Profile$ProfileArn' => '<p>The ARN of a room profile.</p>', 'Profile$AddressBookArn' => '<p>The ARN of the address book.</p>', 'ProfileData$ProfileArn' => '<p>The ARN of a room profile.</p>', 'PutRoomSkillParameterRequest$RoomArn' => '<p>The ARN of the room associated with the room skill parameter. Required.</p>', 'PutSkillAuthorizationRequest$RoomArn' => '<p>The room that the skill is authorized for.</p>', 'RegisterAVSDeviceRequest$RoomArn' => '<p>The Amazon Resource Name (ARN) of the room with which to associate your AVS device.</p>', 'RegisterAVSDeviceResponse$DeviceArn' => '<p>The ARN of the device.</p>', 'ResolveRoomResponse$RoomArn' => '<p>The ARN of the room from which the skill request was invoked.</p>', 'RevokeInvitationRequest$UserArn' => '<p>The ARN of the user for whom to revoke an enrollment invitation. Required.</p>', 'Room$RoomArn' => '<p>The ARN of a room.</p>', 'Room$ProfileArn' => '<p>The profile ARN of a room.</p>', 'RoomData$RoomArn' => '<p>The ARN of a room.</p>', 'RoomData$ProfileArn' => '<p>The profile ARN of a room.</p>', 'SendAnnouncementResponse$AnnouncementArn' => '<p>The identifier of the announcement.</p>', 'SendInvitationRequest$UserArn' => '<p>The ARN of the user to whom to send an invitation. Required.</p>', 'SkillGroup$SkillGroupArn' => '<p>The ARN of a skill group.</p>', 'SkillGroupData$SkillGroupArn' => '<p>The skill group ARN of a skill group.</p>', 'StartDeviceSyncRequest$RoomArn' => '<p>The ARN of the room with which the device to sync is associated. Required.</p>', 'StartDeviceSyncRequest$DeviceArn' => '<p>The ARN of the device to sync. Required.</p>', 'StartSmartHomeApplianceDiscoveryRequest$RoomArn' => '<p>The room where smart home appliance discovery was initiated.</p>', 'TagResourceRequest$Arn' => '<p>The ARN of the resource to which to add metadata tags. Required. </p>', 'UntagResourceRequest$Arn' => '<p>The ARN of the resource from which to remove metadata tags. Required. </p>', 'UpdateAddressBookRequest$AddressBookArn' => '<p>The ARN of the room to update.</p>', 'UpdateBusinessReportScheduleRequest$ScheduleArn' => '<p>The ARN of the business report schedule.</p>', 'UpdateConferenceProviderRequest$ConferenceProviderArn' => '<p>The ARN of the conference provider.</p>', 'UpdateContactRequest$ContactArn' => '<p>The ARN of the contact to update.</p>', 'UpdateDeviceRequest$DeviceArn' => '<p>The ARN of the device to update. Required.</p>', 'UpdateGatewayGroupRequest$GatewayGroupArn' => '<p>The ARN of the gateway group to update.</p>', 'UpdateGatewayRequest$GatewayArn' => '<p>The ARN of the gateway to update.</p>', 'UpdateNetworkProfileRequest$NetworkProfileArn' => '<p>The ARN of the network profile associated with a device.</p>', 'UpdateNetworkProfileRequest$CertificateAuthorityArn' => '<p>The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is used to issue certificates to the devices. </p>', 'UpdateProfileRequest$ProfileArn' => '<p>The ARN of the room profile to update. Required.</p>', 'UpdateRoomRequest$RoomArn' => '<p>The ARN of the room to update. </p>', 'UpdateRoomRequest$ProfileArn' => '<p>The updated profile ARN for the room.</p>', 'UpdateSkillGroupRequest$SkillGroupArn' => '<p>The ARN of the skill group to update. </p>', 'UserData$UserArn' => '<p>The ARN of a user.</p>', ], ], 'AssociateContactWithAddressBookRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateContactWithAddressBookResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDeviceWithNetworkProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDeviceWithNetworkProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDeviceWithRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDeviceWithRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSkillGroupWithRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSkillGroupWithRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSkillWithSkillGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSkillWithSkillGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSkillWithUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSkillWithUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'Audio' => [ 'base' => '<p>The audio message. There is a 1 MB limit on the audio file input and the only supported format is MP3. To convert your MP3 audio files to an Alexa-friendly, </p> <p>required codec version (MPEG version 2) and bit rate (48 kbps), you might use converter software. One option for this is a command-line tool, FFmpeg. For more information, see <a href="https://www.ffmpeg.org/">FFmpeg</a>. The following command converts the provided &lt;input-file&gt; to an MP3 file that is played in the announcement:</p> <p> <code>ffmpeg -i &lt;input-file&gt; -ac 2 -codec:a libmp3lame -b:a 48k -ar 16000 &lt;output-file.mp3&gt;</code> </p>', 'refs' => [ 'AudioList$member' => NULL, ], ], 'AudioList' => [ 'base' => NULL, 'refs' => [ 'Content$AudioList' => '<p>The list of audio messages.</p>', ], ], 'AudioLocation' => [ 'base' => NULL, 'refs' => [ 'Audio$Location' => '<p>The location of the audio file. Currently, S3 URLs are supported. Only S3 locations comprised of safe characters are valid. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#Safe%20Characters">Safe Characters</a>.</p>', ], ], 'AuthorizationResult' => [ 'base' => NULL, 'refs' => [ 'PutSkillAuthorizationRequest$AuthorizationResult' => '<p>The authorization result specific to OAUTH code grant output. "Code” must be populated in the AuthorizationResult map to establish the authorization.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateEndOfMeetingReminder$Enabled' => '<p>Whether an end of meeting reminder is enabled or not.</p>', 'CreateInstantBooking$Enabled' => '<p>Whether instant booking is enabled or not.</p>', 'CreateMeetingRoomConfiguration$RoomUtilizationMetricsEnabled' => '<p>Whether room utilization metrics are enabled or not.</p>', 'CreateProfileRequest$SetupModeDisabled' => '<p>Whether room profile setup is enabled.</p>', 'CreateProfileRequest$PSTNEnabled' => '<p>Whether PSTN calling is enabled.</p>', 'CreateProfileRequest$DataRetentionOptIn' => '<p>Whether data retention of the profile is enabled.</p>', 'CreateRequireCheckIn$Enabled' => '<p>Whether require check in is enabled or not.</p>', 'EndOfMeetingReminder$Enabled' => '<p>Whether an end of meeting reminder is enabled or not.</p>', 'InstantBooking$Enabled' => '<p>Whether instant booking is enabled or not.</p>', 'MeetingRoomConfiguration$RoomUtilizationMetricsEnabled' => '<p>Whether room utilization metrics are enabled or not.</p>', 'Profile$IsDefault' => '<p>Retrieves if the profile is default or not.</p>', 'Profile$SetupModeDisabled' => '<p>The setup mode of a room profile.</p>', 'Profile$PSTNEnabled' => '<p>The PSTN setting of a room profile.</p>', 'Profile$DataRetentionOptIn' => '<p>Whether data retention of the profile is enabled.</p>', 'ProfileData$IsDefault' => '<p>Retrieves if the profile data is default or not.</p>', 'RequireCheckIn$Enabled' => '<p>Whether require check in is enabled or not.</p>', 'UpdateEndOfMeetingReminder$Enabled' => '<p>Whether an end of meeting reminder is enabled or not.</p>', 'UpdateInstantBooking$Enabled' => '<p>Whether instant booking is enabled or not.</p>', 'UpdateMeetingRoomConfiguration$RoomUtilizationMetricsEnabled' => '<p>Whether room utilization metrics are enabled or not.</p>', 'UpdateProfileRequest$IsDefault' => '<p>Sets the profile as default if selected. If this is missing, no update is done to the default status.</p>', 'UpdateProfileRequest$SetupModeDisabled' => '<p>Whether the setup mode of the profile is enabled.</p>', 'UpdateProfileRequest$PSTNEnabled' => '<p>Whether the PSTN setting of the room profile is enabled.</p>', 'UpdateProfileRequest$DataRetentionOptIn' => '<p>Whether data retention of the profile is enabled.</p>', 'UpdateRequireCheckIn$Enabled' => '<p>Whether require check in is enabled or not.</p>', ], ], 'BulletPoint' => [ 'base' => NULL, 'refs' => [ 'BulletPoints$member' => NULL, 'NewInThisVersionBulletPoints$member' => NULL, ], ], 'BulletPoints' => [ 'base' => NULL, 'refs' => [ 'SkillDetails$BulletPoints' => '<p>The details about what the skill supports organized as bullet points.</p>', ], ], 'BusinessReport' => [ 'base' => '<p>Usage report with specified parameters.</p>', 'refs' => [ 'BusinessReportSchedule$LastBusinessReport' => '<p>The details of the last business report delivery for a specified time interval.</p>', ], ], 'BusinessReportContentRange' => [ 'base' => '<p>The content range of the report.</p>', 'refs' => [ 'BusinessReportSchedule$ContentRange' => '<p>The content range of the reports.</p>', 'CreateBusinessReportScheduleRequest$ContentRange' => '<p>The content range of the reports.</p>', ], ], 'BusinessReportDeliveryTime' => [ 'base' => NULL, 'refs' => [ 'BusinessReport$DeliveryTime' => '<p>The time of report delivery.</p>', ], ], 'BusinessReportDownloadUrl' => [ 'base' => NULL, 'refs' => [ 'BusinessReport$DownloadUrl' => '<p>The download link where a user can download the report.</p>', ], ], 'BusinessReportFailureCode' => [ 'base' => NULL, 'refs' => [ 'BusinessReport$FailureCode' => '<p>The failure code.</p>', ], ], 'BusinessReportFormat' => [ 'base' => NULL, 'refs' => [ 'BusinessReportSchedule$Format' => '<p>The format of the generated report (individual CSV files or zipped files of individual files).</p>', 'CreateBusinessReportScheduleRequest$Format' => '<p>The format of the generated report (individual CSV files or zipped files of individual files).</p>', 'UpdateBusinessReportScheduleRequest$Format' => '<p>The format of the generated report (individual CSV files or zipped files of individual files).</p>', ], ], 'BusinessReportInterval' => [ 'base' => NULL, 'refs' => [ 'BusinessReportContentRange$Interval' => '<p>The interval of the content range.</p>', ], ], 'BusinessReportRecurrence' => [ 'base' => '<p>The recurrence of the reports.</p>', 'refs' => [ 'BusinessReportSchedule$Recurrence' => '<p>The recurrence of the reports.</p>', 'CreateBusinessReportScheduleRequest$Recurrence' => '<p>The recurrence of the reports. If this isn\'t specified, the report will only be delivered one time when the API is called. </p>', 'UpdateBusinessReportScheduleRequest$Recurrence' => '<p>The recurrence of the reports.</p>', ], ], 'BusinessReportS3Location' => [ 'base' => '<p>The S3 location of the output reports.</p>', 'refs' => [ 'BusinessReport$S3Location' => '<p>The S3 location of the output reports.</p>', ], ], 'BusinessReportS3Path' => [ 'base' => NULL, 'refs' => [ 'BusinessReportS3Location$Path' => '<p>The path of the business report.</p>', ], ], 'BusinessReportSchedule' => [ 'base' => '<p>The schedule of the usage report.</p>', 'refs' => [ 'BusinessReportScheduleList$member' => NULL, ], ], 'BusinessReportScheduleList' => [ 'base' => NULL, 'refs' => [ 'ListBusinessReportSchedulesResponse$BusinessReportSchedules' => '<p>The schedule of the reports.</p>', ], ], 'BusinessReportScheduleName' => [ 'base' => NULL, 'refs' => [ 'BusinessReportSchedule$ScheduleName' => '<p>The name identifier of the schedule.</p>', 'CreateBusinessReportScheduleRequest$ScheduleName' => '<p>The name identifier of the schedule.</p>', 'UpdateBusinessReportScheduleRequest$ScheduleName' => '<p>The name identifier of the schedule.</p>', ], ], 'BusinessReportStatus' => [ 'base' => NULL, 'refs' => [ 'BusinessReport$Status' => '<p>The status of the report generation execution (RUNNING, SUCCEEDED, or FAILED).</p>', ], ], 'Category' => [ 'base' => '<p>The skill store category that is shown. Alexa skills are assigned a specific skill category during creation, such as News, Social, and Sports.</p>', 'refs' => [ 'CategoryList$member' => NULL, ], ], 'CategoryId' => [ 'base' => NULL, 'refs' => [ 'Category$CategoryId' => '<p>The ID of the skill store category.</p>', 'ListSkillsStoreSkillsByCategoryRequest$CategoryId' => '<p>The category ID for which the skills are being retrieved from the skill store.</p>', ], ], 'CategoryList' => [ 'base' => NULL, 'refs' => [ 'ListSkillsStoreCategoriesResponse$CategoryList' => '<p>The list of categories.</p>', ], ], 'CategoryName' => [ 'base' => NULL, 'refs' => [ 'Category$CategoryName' => '<p>The name of the skill store category.</p>', ], ], 'CertificateTime' => [ 'base' => NULL, 'refs' => [ 'DeviceNetworkProfileInfo$CertificateExpirationTime' => '<p>The time (in epoch) when the certificate expires.</p>', ], ], 'ClientId' => [ 'base' => NULL, 'refs' => [ 'RegisterAVSDeviceRequest$ClientId' => '<p>The client ID of the OEM used for code-based linking authorization on an AVS device.</p>', ], ], 'ClientRequestToken' => [ 'base' => '<p>A unique, user-specified identifier for the request that ensures idempotency.</p>', 'refs' => [ 'CreateAddressBookRequest$ClientRequestToken' => '<p>A unique, user-specified identifier for the request that ensures idempotency.</p>', 'CreateBusinessReportScheduleRequest$ClientRequestToken' => '<p>The client request token.</p>', 'CreateConferenceProviderRequest$ClientRequestToken' => '<p>The request token of the client.</p>', 'CreateContactRequest$ClientRequestToken' => '<p>A unique, user-specified identifier for this request that ensures idempotency.</p>', 'CreateGatewayGroupRequest$ClientRequestToken' => '<p> A unique, user-specified identifier for the request that ensures idempotency.</p>', 'CreateNetworkProfileRequest$ClientRequestToken' => NULL, 'CreateProfileRequest$ClientRequestToken' => '<p>The user-specified token that is used during the creation of a profile.</p>', 'CreateRoomRequest$ClientRequestToken' => '<p>A unique, user-specified identifier for this request that ensures idempotency. </p>', 'CreateSkillGroupRequest$ClientRequestToken' => '<p>A unique, user-specified identifier for this request that ensures idempotency. </p>', 'CreateUserRequest$ClientRequestToken' => '<p>A unique, user-specified identifier for this request that ensures idempotency. </p>', 'ResourceInUseException$ClientRequestToken' => NULL, 'SendAnnouncementRequest$ClientRequestToken' => '<p>The unique, user-specified identifier for the request that ensures idempotency.</p>', ], ], 'CommsProtocol' => [ 'base' => NULL, 'refs' => [ 'IPDialIn$CommsProtocol' => '<p>The protocol, including SIP, SIPS, and H323.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>There is a concurrent modification of resources.</p>', 'refs' => [], ], 'ConferencePreference' => [ 'base' => '<p>The default conference provider that is used if no other scheduled meetings are detected.</p>', 'refs' => [ 'GetConferencePreferenceResponse$Preference' => '<p>The conference preference.</p>', 'PutConferencePreferenceRequest$ConferencePreference' => '<p>The conference preference of a specific conference provider.</p>', ], ], 'ConferenceProvider' => [ 'base' => '<p>An entity that provides a conferencing solution. Alexa for Business acts as the voice interface and mediator that connects users to their preferred conference provider. Examples of conference providers include Amazon Chime, Zoom, Cisco, and Polycom. </p>', 'refs' => [ 'ConferenceProvidersList$member' => NULL, 'GetConferenceProviderResponse$ConferenceProvider' => '<p>The conference provider.</p>', ], ], 'ConferenceProviderName' => [ 'base' => NULL, 'refs' => [ 'ConferenceProvider$Name' => '<p>The name of the conference provider.</p>', 'CreateConferenceProviderRequest$ConferenceProviderName' => '<p>The name of the conference provider.</p>', ], ], 'ConferenceProviderType' => [ 'base' => NULL, 'refs' => [ 'ConferenceProvider$Type' => '<p>The type of conference providers.</p>', 'CreateConferenceProviderRequest$ConferenceProviderType' => '<p>Represents a type within a list of predefined types.</p>', 'UpdateConferenceProviderRequest$ConferenceProviderType' => '<p>The type of the conference provider.</p>', ], ], 'ConferenceProvidersList' => [ 'base' => NULL, 'refs' => [ 'ListConferenceProvidersResponse$ConferenceProviders' => '<p>The conference providers.</p>', ], ], 'ConnectionStatus' => [ 'base' => NULL, 'refs' => [ 'DeviceStatusInfo$ConnectionStatus' => '<p>The latest available information about the connection status of a device. </p>', ], ], 'ConnectionStatusUpdatedTime' => [ 'base' => NULL, 'refs' => [ 'DeviceStatusInfo$ConnectionStatusUpdatedTime' => '<p>The time (in epoch) when the device connection status changed.</p>', ], ], 'Contact' => [ 'base' => '<p>A contact with attributes.</p>', 'refs' => [ 'GetContactResponse$Contact' => '<p>The details of the requested contact.</p>', ], ], 'ContactData' => [ 'base' => '<p>Information related to a contact.</p>', 'refs' => [ 'ContactDataList$member' => NULL, ], ], 'ContactDataList' => [ 'base' => NULL, 'refs' => [ 'SearchContactsResponse$Contacts' => '<p>The contacts that meet the specified set of filter criteria, in sort order.</p>', ], ], 'ContactName' => [ 'base' => NULL, 'refs' => [ 'Contact$DisplayName' => '<p>The name of the contact to display on the console.</p>', 'Contact$FirstName' => '<p>The first name of the contact, used to call the contact on the device.</p>', 'Contact$LastName' => '<p>The last name of the contact, used to call the contact on the device.</p>', 'ContactData$DisplayName' => '<p>The name of the contact to display on the console.</p>', 'ContactData$FirstName' => '<p>The first name of the contact, used to call the contact on the device.</p>', 'ContactData$LastName' => '<p>The last name of the contact, used to call the contact on the device.</p>', 'CreateContactRequest$DisplayName' => '<p>The name of the contact to display on the console.</p>', 'CreateContactRequest$FirstName' => '<p>The first name of the contact that is used to call the contact on the device.</p>', 'CreateContactRequest$LastName' => '<p>The last name of the contact that is used to call the contact on the device.</p>', 'UpdateContactRequest$DisplayName' => '<p>The updated display name of the contact.</p>', 'UpdateContactRequest$FirstName' => '<p>The updated first name of the contact.</p>', 'UpdateContactRequest$LastName' => '<p>The updated last name of the contact.</p>', ], ], 'Content' => [ 'base' => '<p>The content definition. This can contain only one text, SSML, or audio list object.</p>', 'refs' => [ 'SendAnnouncementRequest$Content' => '<p>The announcement content. This can contain only one of the three possible announcement types (text, SSML or audio).</p>', ], ], 'CountryCode' => [ 'base' => NULL, 'refs' => [ 'PSTNDialIn$CountryCode' => '<p>The zip code.</p>', ], ], 'CreateAddressBookRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAddressBookResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateBusinessReportScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBusinessReportScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateConferenceProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConferenceProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndOfMeetingReminder' => [ 'base' => '<p>Creates settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder enables Alexa to remind users when a meeting is ending.</p>', 'refs' => [ 'CreateMeetingRoomConfiguration$EndOfMeetingReminder' => NULL, ], ], 'CreateGatewayGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGatewayGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstantBooking' => [ 'base' => '<p>Creates settings for the instant booking feature that are applied to a room profile. When users start their meeting with Alexa, Alexa automatically books the room for the configured duration if the room is available.</p>', 'refs' => [ 'CreateMeetingRoomConfiguration$InstantBooking' => '<p>Settings to automatically book a room for a configured duration if it\'s free when joining a meeting with Alexa.</p>', ], ], 'CreateMeetingRoomConfiguration' => [ 'base' => '<p>Creates meeting room settings of a room profile.</p>', 'refs' => [ 'CreateProfileRequest$MeetingRoomConfiguration' => '<p>The meeting room settings of a room profile.</p>', ], ], 'CreateNetworkProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRequireCheckIn' => [ 'base' => '<p>Creates settings for the require check in feature that are applied to a room profile. Require check in allows a meeting room’s Alexa or AVS device to prompt the user to check in; otherwise, the room will be released.</p>', 'refs' => [ 'CreateMeetingRoomConfiguration$RequireCheckIn' => '<p>Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it\'s not checked into to make the room available for others. Users can check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check in.”</p>', ], ], 'CreateRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSkillGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSkillGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'CurrentWiFiPassword' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkProfileRequest$CurrentPassword' => '<p>The current password of the Wi-Fi network.</p>', 'NetworkProfile$CurrentPassword' => '<p>The current password of the Wi-Fi network.</p>', 'UpdateNetworkProfileRequest$CurrentPassword' => '<p>The current password of the Wi-Fi network.</p>', ], ], 'CustomerS3BucketName' => [ 'base' => NULL, 'refs' => [ 'BusinessReportS3Location$BucketName' => '<p>The S3 bucket name of the output reports.</p>', 'BusinessReportSchedule$S3BucketName' => '<p>The S3 bucket name of the output reports.</p>', 'CreateBusinessReportScheduleRequest$S3BucketName' => '<p>The S3 bucket name of the output reports. If this isn\'t specified, the report can be retrieved from a download link by calling ListBusinessReportSchedule. </p>', 'UpdateBusinessReportScheduleRequest$S3BucketName' => '<p>The S3 location of the output reports.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'BusinessReportRecurrence$StartDate' => '<p>The start date.</p>', ], ], 'DeleteAddressBookRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAddressBookResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBusinessReportScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBusinessReportScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConferenceProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConferenceProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDeviceUsageDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDeviceUsageDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGatewayGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGatewayGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRoomSkillParameterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRoomSkillParameterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSkillAuthorizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSkillAuthorizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSkillGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSkillGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeveloperInfo' => [ 'base' => '<p>The details about the developer that published the skill.</p>', 'refs' => [ 'SkillDetails$DeveloperInfo' => '<p>The details about the developer that published the skill.</p>', ], ], 'DeveloperName' => [ 'base' => NULL, 'refs' => [ 'DeveloperInfo$DeveloperName' => '<p>The name of the developer.</p>', ], ], 'Device' => [ 'base' => '<p>A device with attributes.</p>', 'refs' => [ 'GetDeviceResponse$Device' => '<p>The details of the device requested. Required.</p>', ], ], 'DeviceData' => [ 'base' => '<p>Device attributes.</p>', 'refs' => [ 'DeviceDataList$member' => NULL, ], ], 'DeviceDataCreatedTime' => [ 'base' => NULL, 'refs' => [ 'DeviceData$CreatedTime' => '<p>The time (in epoch) when the device data was created.</p>', ], ], 'DeviceDataList' => [ 'base' => NULL, 'refs' => [ 'SearchDevicesResponse$Devices' => '<p>The devices that meet the specified set of filter criteria, in sort order.</p>', ], ], 'DeviceEvent' => [ 'base' => '<p>The list of device events.</p>', 'refs' => [ 'DeviceEventList$member' => NULL, ], ], 'DeviceEventList' => [ 'base' => NULL, 'refs' => [ 'ListDeviceEventsResponse$DeviceEvents' => '<p>The device events requested for the device ARN.</p>', ], ], 'DeviceEventTime' => [ 'base' => NULL, 'refs' => [ 'DeviceEvent$Timestamp' => '<p>The time (in epoch) when the event occurred. </p>', ], ], 'DeviceEventType' => [ 'base' => NULL, 'refs' => [ 'DeviceEvent$Type' => '<p>The type of device event.</p>', 'ListDeviceEventsRequest$EventType' => '<p>The event type to filter device events. If EventType isn\'t specified, this returns a list of all device events in reverse chronological order. If EventType is specified, this returns a list of device events for that EventType in reverse chronological order. </p>', ], ], 'DeviceEventValue' => [ 'base' => NULL, 'refs' => [ 'DeviceEvent$Value' => '<p>The value of the event.</p>', ], ], 'DeviceLocale' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$Locale' => '<p>The locale of the room profile. (This is currently only available to a limited preview audience.)</p>', 'Profile$Locale' => '<p>The locale of a room profile. (This is currently available only to a limited preview audience.)</p>', 'ProfileData$Locale' => '<p>The locale of a room profile. (This is currently available only to a limited preview audience.)</p>', 'UpdateProfileRequest$Locale' => '<p>The updated locale for the room profile. (This is currently only available to a limited preview audience.)</p>', ], ], 'DeviceName' => [ 'base' => NULL, 'refs' => [ 'Device$DeviceName' => '<p>The name of a device.</p>', 'DeviceData$DeviceName' => '<p>The name of a device.</p>', 'UpdateDeviceRequest$DeviceName' => '<p>The updated device name. Required.</p>', ], ], 'DeviceNetworkProfileInfo' => [ 'base' => '<p>Detailed information about a device\'s network profile.</p>', 'refs' => [ 'Device$NetworkProfileInfo' => '<p>Detailed information about a device\'s network profile.</p>', ], ], 'DeviceNotRegisteredException' => [ 'base' => '<p>The request failed because this device is no longer registered and therefore no longer managed by this account.</p>', 'refs' => [], ], 'DeviceRoomName' => [ 'base' => NULL, 'refs' => [ 'DeviceData$RoomName' => '<p>The name of the room associated with a device.</p>', ], ], 'DeviceSerialNumber' => [ 'base' => NULL, 'refs' => [ 'Device$DeviceSerialNumber' => '<p>The serial number of a device.</p>', 'DeviceData$DeviceSerialNumber' => '<p>The serial number of a device.</p>', ], ], 'DeviceSerialNumberForAVS' => [ 'base' => NULL, 'refs' => [ 'RegisterAVSDeviceRequest$DeviceSerialNumber' => '<p>The key generated by the OEM that uniquely identifies a specified instance of your AVS device.</p>', ], ], 'DeviceStatus' => [ 'base' => NULL, 'refs' => [ 'Device$DeviceStatus' => '<p>The status of a device. If the status is not READY, check the DeviceStatusInfo value for details.</p>', 'DeviceData$DeviceStatus' => '<p>The status of a device.</p>', ], ], 'DeviceStatusDetail' => [ 'base' => '<p>Details of a device’s status.</p>', 'refs' => [ 'DeviceStatusDetails$member' => NULL, ], ], 'DeviceStatusDetailCode' => [ 'base' => NULL, 'refs' => [ 'DeviceStatusDetail$Code' => '<p>The device status detail code.</p>', ], ], 'DeviceStatusDetails' => [ 'base' => NULL, 'refs' => [ 'DeviceStatusInfo$DeviceStatusDetails' => '<p>One or more device status detail descriptions.</p>', ], ], 'DeviceStatusInfo' => [ 'base' => '<p>Detailed information about a device\'s status.</p>', 'refs' => [ 'Device$DeviceStatusInfo' => '<p>Detailed information about a device\'s status.</p>', 'DeviceData$DeviceStatusInfo' => '<p>Detailed information about a device\'s status.</p>', ], ], 'DeviceType' => [ 'base' => NULL, 'refs' => [ 'Device$DeviceType' => '<p>The type of a device.</p>', 'DeviceData$DeviceType' => '<p>The type of a device.</p>', ], ], 'DeviceUsageType' => [ 'base' => NULL, 'refs' => [ 'DeleteDeviceUsageDataRequest$DeviceUsageType' => '<p>The type of usage data to delete.</p>', ], ], 'DisassociateContactFromAddressBookRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateContactFromAddressBookResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateDeviceFromRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateDeviceFromRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSkillFromSkillGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSkillFromSkillGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSkillFromUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSkillFromUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSkillGroupFromRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSkillGroupFromRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'DistanceUnit' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$DistanceUnit' => '<p>The distance unit to be used by devices in the profile.</p>', 'Profile$DistanceUnit' => '<p>The distance unit of a room profile.</p>', 'ProfileData$DistanceUnit' => '<p>The distance unit of a room profile.</p>', 'UpdateProfileRequest$DistanceUnit' => '<p>The updated distance unit for the room profile.</p>', ], ], 'Email' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Email' => '<p>The email address for the user.</p>', 'DeveloperInfo$Email' => '<p>The email of the developer.</p>', 'GetInvitationConfigurationResponse$ContactEmail' => '<p>The email ID of the organization or individual contact that the enrolled user can use. </p>', 'PutInvitationConfigurationRequest$ContactEmail' => '<p>The email ID of the organization or individual contact that the enrolled user can use. </p>', 'UserData$Email' => '<p>The email of a user.</p>', ], ], 'EnablementType' => [ 'base' => NULL, 'refs' => [ 'SkillSummary$EnablementType' => '<p>Whether the skill is enabled under the user\'s account, or if it requires linking to be used.</p>', ], ], 'EnablementTypeFilter' => [ 'base' => NULL, 'refs' => [ 'ListSkillsRequest$EnablementType' => '<p>Whether the skill is enabled under the user\'s account.</p>', ], ], 'EndOfMeetingReminder' => [ 'base' => '<p>Settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder enables Alexa to remind users when a meeting is ending. </p>', 'refs' => [ 'MeetingRoomConfiguration$EndOfMeetingReminder' => '<p>Settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder enables Alexa to remind users when a meeting is ending. </p>', ], ], 'EndOfMeetingReminderMinutesList' => [ 'base' => NULL, 'refs' => [ 'CreateEndOfMeetingReminder$ReminderAtMinutes' => '<p> A range of 3 to 15 minutes that determines when the reminder begins.</p>', 'EndOfMeetingReminder$ReminderAtMinutes' => '<p>A range of 3 to 15 minutes that determines when the reminder begins.</p>', 'UpdateEndOfMeetingReminder$ReminderAtMinutes' => '<p>Updates settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder enables Alexa to remind users when a meeting is ending. </p>', ], ], 'EndOfMeetingReminderType' => [ 'base' => NULL, 'refs' => [ 'CreateEndOfMeetingReminder$ReminderType' => '<p>The type of sound that users hear during the end of meeting reminder. </p>', 'EndOfMeetingReminder$ReminderType' => '<p>The type of sound that users hear during the end of meeting reminder. </p>', 'UpdateEndOfMeetingReminder$ReminderType' => '<p>The type of sound that users hear during the end of meeting reminder. </p>', ], ], 'EndUserLicenseAgreement' => [ 'base' => NULL, 'refs' => [ 'SkillDetails$EndUserLicenseAgreement' => '<p>The URL of the end user license agreement.</p>', ], ], 'Endpoint' => [ 'base' => NULL, 'refs' => [ 'IPDialIn$Endpoint' => '<p>The IP address.</p>', ], ], 'EnrollmentId' => [ 'base' => NULL, 'refs' => [ 'DeleteUserRequest$EnrollmentId' => '<p>The ARN of the user\'s enrollment in the organization. Required.</p>', 'RevokeInvitationRequest$EnrollmentId' => '<p>The ARN of the enrollment invitation to revoke. Required.</p>', 'UserData$EnrollmentId' => '<p>The enrollment ARN of a user.</p>', ], ], 'EnrollmentStatus' => [ 'base' => NULL, 'refs' => [ 'UserData$EnrollmentStatus' => '<p>The enrollment status of a user.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AlreadyExistsException$Message' => NULL, 'ConcurrentModificationException$Message' => NULL, 'DeviceNotRegisteredException$Message' => NULL, 'InvalidCertificateAuthorityException$Message' => NULL, 'InvalidDeviceException$Message' => NULL, 'InvalidSecretsManagerResourceException$Message' => NULL, 'InvalidServiceLinkedRoleStateException$Message' => NULL, 'InvalidUserStatusException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'NameInUseException$Message' => NULL, 'NotFoundException$Message' => NULL, 'ResourceAssociatedException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'SkillNotLinkedException$Message' => NULL, 'UnauthorizedException$Message' => NULL, ], ], 'Feature' => [ 'base' => NULL, 'refs' => [ 'DeviceStatusDetail$Feature' => '<p>The list of available features on the device.</p>', 'Features$member' => NULL, ], ], 'Features' => [ 'base' => NULL, 'refs' => [ 'StartDeviceSyncRequest$Features' => '<p>Request structure to start the device sync. Required.</p>', ], ], 'Filter' => [ 'base' => '<p>A filter name and value pair that is used to return a more specific list of results. Filters can be used to match a set of resources by various criteria.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterKey' => [ 'base' => NULL, 'refs' => [ 'Filter$Key' => '<p>The key of a filter.</p>', ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'SearchAddressBooksRequest$Filters' => '<p>The filters to use to list a specified set of address books. The supported filter key is AddressBookName.</p>', 'SearchContactsRequest$Filters' => '<p>The filters to use to list a specified set of address books. The supported filter keys are DisplayName, FirstName, LastName, and AddressBookArns.</p>', 'SearchDevicesRequest$Filters' => '<p>The filters to use to list a specified set of devices. Supported filter keys are DeviceName, DeviceStatus, DeviceStatusDetailCode, RoomName, DeviceType, DeviceSerialNumber, UnassociatedOnly, ConnectionStatus (ONLINE and OFFLINE), NetworkProfileName, NetworkProfileArn, Feature, and FailureCode.</p>', 'SearchNetworkProfilesRequest$Filters' => '<p>The filters to use to list a specified set of network profiles. Valid filters are NetworkProfileName, Ssid, and SecurityType.</p>', 'SearchProfilesRequest$Filters' => '<p>The filters to use to list a specified set of room profiles. Supported filter keys are ProfileName and Address. Required. </p>', 'SearchRoomsRequest$Filters' => '<p>The filters to use to list a specified set of rooms. The supported filter keys are RoomName and ProfileName.</p>', 'SearchSkillGroupsRequest$Filters' => '<p>The filters to use to list a specified set of skill groups. The supported filter key is SkillGroupName. </p>', 'SearchUsersRequest$Filters' => '<p>The filters to use for listing a specific set of users. Required. Supported filter keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.</p>', 'SendAnnouncementRequest$RoomFilters' => '<p>The filters to use to send an announcement to a specified list of rooms. The supported filter keys are RoomName, ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters list.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValueList$member' => NULL, ], ], 'FilterValueList' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p>The values of a filter.</p>', ], ], 'ForgetSmartHomeAppliancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ForgetSmartHomeAppliancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Gateway' => [ 'base' => '<p>The details of the gateway. </p>', 'refs' => [ 'GetGatewayResponse$Gateway' => '<p>The details of the gateway.</p>', ], ], 'GatewayDescription' => [ 'base' => NULL, 'refs' => [ 'Gateway$Description' => '<p>The description of the gateway.</p>', 'GatewaySummary$Description' => '<p>The description of the gateway.</p>', 'UpdateGatewayRequest$Description' => '<p>The updated description of the gateway.</p>', ], ], 'GatewayGroup' => [ 'base' => '<p>The details of the gateway group.</p>', 'refs' => [ 'GetGatewayGroupResponse$GatewayGroup' => NULL, ], ], 'GatewayGroupDescription' => [ 'base' => NULL, 'refs' => [ 'CreateGatewayGroupRequest$Description' => '<p>The description of the gateway group.</p>', 'GatewayGroup$Description' => '<p>The description of the gateway group.</p>', 'GatewayGroupSummary$Description' => '<p>The description of the gateway group.</p>', 'UpdateGatewayGroupRequest$Description' => '<p>The updated description of the gateway group.</p>', ], ], 'GatewayGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateGatewayGroupRequest$Name' => '<p>The name of the gateway group.</p>', 'GatewayGroup$Name' => '<p>The name of the gateway group.</p>', 'GatewayGroupSummary$Name' => '<p>The name of the gateway group.</p>', 'UpdateGatewayGroupRequest$Name' => '<p>The updated name of the gateway group.</p>', ], ], 'GatewayGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListGatewayGroupsResponse$GatewayGroups' => '<p>The gateway groups in the list.</p>', ], ], 'GatewayGroupSummary' => [ 'base' => '<p>The summary of a gateway group.</p>', 'refs' => [ 'GatewayGroupSummaries$member' => NULL, ], ], 'GatewayName' => [ 'base' => NULL, 'refs' => [ 'Gateway$Name' => '<p>The name of the gateway.</p>', 'GatewaySummary$Name' => '<p>The name of the gateway.</p>', 'UpdateGatewayRequest$Name' => '<p>The updated name of the gateway.</p>', ], ], 'GatewaySummaries' => [ 'base' => NULL, 'refs' => [ 'ListGatewaysResponse$Gateways' => '<p>The gateways in the list.</p>', ], ], 'GatewaySummary' => [ 'base' => '<p>The summary of a gateway.</p>', 'refs' => [ 'GatewaySummaries$member' => NULL, ], ], 'GatewayVersion' => [ 'base' => NULL, 'refs' => [ 'Gateway$SoftwareVersion' => '<p>The software version of the gateway. The gateway automatically updates its software version during normal operation.</p>', 'GatewaySummary$SoftwareVersion' => '<p>The software version of the gateway. The gateway automatically updates its software version during normal operation.</p>', 'UpdateGatewayRequest$SoftwareVersion' => '<p>The updated software version of the gateway. The gateway automatically updates its software version during normal operation.</p>', ], ], 'GenericKeyword' => [ 'base' => NULL, 'refs' => [ 'GenericKeywords$member' => NULL, ], ], 'GenericKeywords' => [ 'base' => NULL, 'refs' => [ 'SkillDetails$GenericKeywords' => '<p>The generic keywords associated with the skill that can be used to find a skill.</p>', ], ], 'GetAddressBookRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAddressBookResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConferencePreferenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConferencePreferenceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConferenceProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConferenceProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetGatewayGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGatewayGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGatewayResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetInvitationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInvitationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRoomSkillParameterRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRoomSkillParameterResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSkillGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSkillGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'IPDialIn' => [ 'base' => '<p>The IP endpoint and protocol for calling.</p>', 'refs' => [ 'ConferenceProvider$IPDialIn' => '<p>The IP endpoint and protocol for calling.</p>', 'CreateConferenceProviderRequest$IPDialIn' => '<p>The IP endpoint and protocol for calling.</p>', 'UpdateConferenceProviderRequest$IPDialIn' => '<p>The IP endpoint and protocol for calling.</p>', ], ], 'IconUrl' => [ 'base' => NULL, 'refs' => [ 'SkillsStoreSkill$IconUrl' => '<p>The URL where the skill icon resides.</p>', ], ], 'InstantBooking' => [ 'base' => '<p>Settings for the instant booking feature that are applied to a room profile. When users start their meeting with Alexa, Alexa automatically books the room for the configured duration if the room is available.</p>', 'refs' => [ 'MeetingRoomConfiguration$InstantBooking' => '<p>Settings to automatically book the room if available for a configured duration when joining a meeting with Alexa. </p>', ], ], 'InvalidCertificateAuthorityException' => [ 'base' => '<p>The Certificate Authority can\'t issue or revoke a certificate.</p>', 'refs' => [], ], 'InvalidDeviceException' => [ 'base' => '<p>The device is in an invalid state.</p>', 'refs' => [], ], 'InvalidSecretsManagerResourceException' => [ 'base' => '<p>A password in SecretsManager is in an invalid state.</p>', 'refs' => [], ], 'InvalidServiceLinkedRoleStateException' => [ 'base' => '<p>The service linked role is locked for deletion. </p>', 'refs' => [], ], 'InvalidUserStatusException' => [ 'base' => '<p>The attempt to update a user is invalid due to the user\'s current status.</p>', 'refs' => [], ], 'InvocationPhrase' => [ 'base' => NULL, 'refs' => [ 'SkillDetails$InvocationPhrase' => '<p>The phrase used to trigger the skill.</p>', ], ], 'Key' => [ 'base' => NULL, 'refs' => [ 'AuthorizationResult$key' => NULL, ], ], 'LimitExceededException' => [ 'base' => '<p>You are performing an action that would put you beyond your account\'s limits.</p>', 'refs' => [], ], 'ListBusinessReportSchedulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBusinessReportSchedulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListConferenceProvidersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListConferenceProvidersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDeviceEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDeviceEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGatewayGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGatewayGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGatewaysResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSkillsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSkillsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSkillsStoreCategoriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSkillsStoreCategoriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSkillsStoreSkillsByCategoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSkillsStoreSkillsByCategoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSmartHomeAppliancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSmartHomeAppliancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Locale' => [ 'base' => NULL, 'refs' => [ 'Audio$Locale' => '<p>The locale of the audio message. Currently, en-US is supported.</p>', 'Ssml$Locale' => '<p>The locale of the SSML message. Currently, en-US is supported.</p>', 'Text$Locale' => '<p>The locale of the text message. Currently, en-US is supported.</p>', ], ], 'MacAddress' => [ 'base' => NULL, 'refs' => [ 'Device$MacAddress' => '<p>The MAC address of a device.</p>', 'DeviceData$MacAddress' => '<p>The MAC address of a device.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListBusinessReportSchedulesRequest$MaxResults' => '<p>The maximum number of schedules listed in the call.</p>', 'ListConferenceProvidersRequest$MaxResults' => '<p>The maximum number of conference providers to be returned, per paginated calls.</p>', 'ListDeviceEventsRequest$MaxResults' => '<p>The maximum number of results to include in the response. The default value is 50. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. </p>', 'ListGatewayGroupsRequest$MaxResults' => '<p>The maximum number of gateway group summaries to return. The default is 50.</p>', 'ListGatewaysRequest$MaxResults' => '<p>The maximum number of gateway summaries to return. The default is 50.</p>', 'ListSkillsStoreCategoriesRequest$MaxResults' => '<p>The maximum number of categories returned, per paginated calls.</p>', 'ListSmartHomeAppliancesRequest$MaxResults' => '<p>The maximum number of appliances to be returned, per paginated calls.</p>', 'ListTagsRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'SearchAddressBooksRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>', 'SearchContactsRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>', 'SearchDevicesRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'SearchNetworkProfilesRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. </p>', 'SearchProfilesRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'SearchRoomsRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved. </p>', 'SearchSkillGroupsRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved. </p>', 'SearchUsersRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved. Required.</p>', ], ], 'MaxVolumeLimit' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$MaxVolumeLimit' => '<p>The maximum volume limit for a room profile.</p>', 'Profile$MaxVolumeLimit' => '<p>The max volume limit of a room profile.</p>', 'UpdateProfileRequest$MaxVolumeLimit' => '<p>The updated maximum volume limit for the room profile.</p>', ], ], 'MeetingRoomConfiguration' => [ 'base' => '<p>Meeting room settings of a room profile.</p>', 'refs' => [ 'Profile$MeetingRoomConfiguration' => '<p>Meeting room settings of a room profile.</p>', ], ], 'MeetingSetting' => [ 'base' => '<p>The values that indicate whether a pin is always required (YES), never required (NO), or OPTIONAL.</p> <ul> <li> <p>If YES, Alexa will always ask for a meeting pin.</p> </li> <li> <p>If NO, Alexa will never ask for a meeting pin.</p> </li> <li> <p>If OPTIONAL, Alexa will ask if you have a meeting pin and if the customer responds with yes, it will ask for the meeting pin.</p> </li> </ul>', 'refs' => [ 'ConferenceProvider$MeetingSetting' => '<p>The meeting settings for the conference provider.</p>', 'CreateConferenceProviderRequest$MeetingSetting' => '<p>The meeting settings for the conference provider.</p>', 'UpdateConferenceProviderRequest$MeetingSetting' => '<p>The meeting settings for the conference provider.</p>', ], ], 'Minutes' => [ 'base' => NULL, 'refs' => [ 'CreateInstantBooking$DurationInMinutes' => '<p>Duration between 15 and 240 minutes at increments of 15 that determines how long to book an available room when a meeting is started with Alexa.</p>', 'CreateRequireCheckIn$ReleaseAfterMinutes' => '<p>Duration between 5 and 20 minutes to determine when to release the room if it\'s not checked into.</p>', 'EndOfMeetingReminderMinutesList$member' => NULL, 'InstantBooking$DurationInMinutes' => '<p>Duration between 15 and 240 minutes at increments of 15 that determines how long to book an available room when a meeting is started with Alexa. </p>', 'RequireCheckIn$ReleaseAfterMinutes' => '<p>Duration between 5 and 20 minutes to determine when to release the room if it\'s not checked into. </p>', 'UpdateInstantBooking$DurationInMinutes' => '<p>Duration between 15 and 240 minutes at increments of 15 that determines how long to book an available room when a meeting is started with Alexa.</p>', 'UpdateRequireCheckIn$ReleaseAfterMinutes' => '<p>Duration between 5 and 20 minutes to determine when to release the room if it\'s not checked into. </p>', ], ], 'NameInUseException' => [ 'base' => '<p>The name sent in the request is already in use.</p>', 'refs' => [], ], 'NetworkEapMethod' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkProfileRequest$EapMethod' => '<p>The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported.</p>', 'NetworkProfile$EapMethod' => '<p>The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported. </p>', 'NetworkProfileData$EapMethod' => '<p>The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported.</p>', ], ], 'NetworkProfile' => [ 'base' => '<p>The network profile associated with a device.</p>', 'refs' => [ 'GetNetworkProfileResponse$NetworkProfile' => '<p>The network profile associated with a device.</p>', ], ], 'NetworkProfileData' => [ 'base' => '<p>The data associated with a network profile.</p>', 'refs' => [ 'NetworkProfileDataList$member' => NULL, ], ], 'NetworkProfileDataList' => [ 'base' => NULL, 'refs' => [ 'SearchNetworkProfilesResponse$NetworkProfiles' => '<p>The network profiles that meet the specified set of filter criteria, in sort order. It is a list of NetworkProfileData objects. </p>', ], ], 'NetworkProfileDescription' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkProfileRequest$Description' => '<p>Detailed information about a device\'s network profile.</p>', 'NetworkProfile$Description' => '<p>Detailed information about a device\'s network profile.</p>', 'NetworkProfileData$Description' => '<p>Detailed information about a device\'s network profile.</p>', 'UpdateNetworkProfileRequest$Description' => '<p>Detailed information about a device\'s network profile.</p>', ], ], 'NetworkProfileName' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkProfileRequest$NetworkProfileName' => '<p>The name of the network profile associated with a device.</p>', 'DeviceData$NetworkProfileName' => '<p>The name of the network profile associated with a device.</p>', 'NetworkProfile$NetworkProfileName' => '<p>The name of the network profile associated with a device.</p>', 'NetworkProfileData$NetworkProfileName' => '<p>The name of the network profile associated with a device.</p>', 'UpdateNetworkProfileRequest$NetworkProfileName' => '<p>The name of the network profile associated with a device.</p>', ], ], 'NetworkSecurityType' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkProfileRequest$SecurityType' => '<p>The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.</p>', 'NetworkProfile$SecurityType' => '<p>The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.</p>', 'NetworkProfileData$SecurityType' => '<p>The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.</p>', ], ], 'NetworkSsid' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkProfileRequest$Ssid' => '<p>The SSID of the Wi-Fi network.</p>', 'NetworkProfile$Ssid' => '<p>The SSID of the Wi-Fi network.</p>', 'NetworkProfileData$Ssid' => '<p>The SSID of the Wi-Fi network.</p>', ], ], 'NewInThisVersionBulletPoints' => [ 'base' => NULL, 'refs' => [ 'SkillDetails$NewInThisVersionBulletPoints' => '<p>The updates added in bullet points.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListBusinessReportSchedulesRequest$NextToken' => '<p>The token used to list the remaining schedules from the previous API call.</p>', 'ListBusinessReportSchedulesResponse$NextToken' => '<p>The token used to list the remaining schedules from the previous API call.</p>', 'ListConferenceProvidersRequest$NextToken' => '<p>The tokens used for pagination.</p>', 'ListConferenceProvidersResponse$NextToken' => '<p>The tokens used for pagination.</p>', 'ListDeviceEventsRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response only includes results beyond the token, up to the value specified by MaxResults. When the end of results is reached, the response has a value of null.</p>', 'ListDeviceEventsResponse$NextToken' => '<p>The token returned to indicate that there is more data available.</p>', 'ListGatewayGroupsRequest$NextToken' => '<p>The token used to paginate though multiple pages of gateway group summaries.</p>', 'ListGatewayGroupsResponse$NextToken' => '<p>The token used to paginate though multiple pages of gateway group summaries.</p>', 'ListGatewaysRequest$NextToken' => '<p>The token used to paginate though multiple pages of gateway summaries.</p>', 'ListGatewaysResponse$NextToken' => '<p>The token used to paginate though multiple pages of gateway summaries.</p>', 'ListSkillsRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>', 'ListSkillsResponse$NextToken' => '<p>The token returned to indicate that there is more data available.</p>', 'ListSkillsStoreCategoriesRequest$NextToken' => '<p>The tokens used for pagination.</p>', 'ListSkillsStoreCategoriesResponse$NextToken' => '<p>The tokens used for pagination.</p>', 'ListSkillsStoreSkillsByCategoryRequest$NextToken' => '<p>The tokens used for pagination.</p>', 'ListSkillsStoreSkillsByCategoryResponse$NextToken' => '<p>The tokens used for pagination.</p>', 'ListSmartHomeAppliancesRequest$NextToken' => '<p>The tokens used for pagination.</p>', 'ListSmartHomeAppliancesResponse$NextToken' => '<p>The tokens used for pagination.</p>', 'ListTagsRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>. </p>', 'ListTagsResponse$NextToken' => '<p>The token returned to indicate that there is more data available.</p>', 'SearchAddressBooksRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response only includes results beyond the token, up to the value specified by MaxResults.</p>', 'SearchAddressBooksResponse$NextToken' => '<p>The token returned to indicate that there is more data available.</p>', 'SearchContactsRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response only includes results beyond the token, up to the value specified by MaxResults.</p>', 'SearchContactsResponse$NextToken' => '<p>The token returned to indicate that there is more data available.</p>', 'SearchDevicesRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>', 'SearchDevicesResponse$NextToken' => '<p>The token returned to indicate that there is more data available.</p>', 'SearchNetworkProfilesRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. </p>', 'SearchNetworkProfilesResponse$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults.</p>', 'SearchProfilesRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>', 'SearchProfilesResponse$NextToken' => '<p>The token returned to indicate that there is more data available.</p>', 'SearchRoomsRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>.</p>', 'SearchRoomsResponse$NextToken' => '<p>The token returned to indicate that there is more data available.</p>', 'SearchSkillGroupsRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>. Required.</p>', 'SearchSkillGroupsResponse$NextToken' => '<p>The token returned to indicate that there is more data available.</p>', 'SearchUsersRequest$NextToken' => '<p>An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by <code>MaxResults</code>. Required.</p>', 'SearchUsersResponse$NextToken' => '<p>The token returned to indicate that there is more data available.</p>', ], ], 'NextWiFiPassword' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkProfileRequest$NextPassword' => '<p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously transmitted to the device and is used when the password of the network changes to NextPassword. </p>', 'NetworkProfile$NextPassword' => '<p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously transmitted to the device and is used when the password of the network changes to NextPassword. </p>', 'UpdateNetworkProfileRequest$NextPassword' => '<p>The next, or subsequent, password of the Wi-Fi network. This password is asynchronously transmitted to the device and is used when the password of the network changes to NextPassword. </p>', ], ], 'NotFoundException' => [ 'base' => '<p>The resource is not found.</p>', 'refs' => [], ], 'OneClickIdDelay' => [ 'base' => NULL, 'refs' => [ 'PSTNDialIn$OneClickIdDelay' => '<p>The delay duration before Alexa enters the conference ID with dual-tone multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.</p>', ], ], 'OneClickPinDelay' => [ 'base' => NULL, 'refs' => [ 'PSTNDialIn$OneClickPinDelay' => '<p>The delay duration before Alexa enters the conference pin with dual-tone multi-frequency (DTMF). Each number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.</p>', ], ], 'OrganizationName' => [ 'base' => NULL, 'refs' => [ 'GetInvitationConfigurationResponse$OrganizationName' => '<p>The name of the organization sending the enrollment invite to a user.</p>', 'PutInvitationConfigurationRequest$OrganizationName' => '<p>The name of the organization sending the enrollment invite to a user.</p>', ], ], 'OutboundPhoneNumber' => [ 'base' => NULL, 'refs' => [ 'PSTNDialIn$PhoneNumber' => '<p>The phone number to call to join the conference.</p>', ], ], 'PSTNDialIn' => [ 'base' => '<p>The information for public switched telephone network (PSTN) conferencing.</p>', 'refs' => [ 'ConferenceProvider$PSTNDialIn' => '<p>The information for PSTN conferencing.</p>', 'CreateConferenceProviderRequest$PSTNDialIn' => '<p>The information for PSTN conferencing.</p>', 'UpdateConferenceProviderRequest$PSTNDialIn' => '<p>The information for PSTN conferencing.</p>', ], ], 'PhoneNumber' => [ 'base' => '<p>The phone number for the contact containing the raw number and phone number type.</p>', 'refs' => [ 'PhoneNumberList$member' => NULL, ], ], 'PhoneNumberList' => [ 'base' => NULL, 'refs' => [ 'Contact$PhoneNumbers' => '<p>The list of phone numbers for the contact.</p>', 'ContactData$PhoneNumbers' => '<p>The list of phone numbers for the contact.</p>', 'CreateContactRequest$PhoneNumbers' => '<p>The list of phone numbers for the contact.</p>', 'UpdateContactRequest$PhoneNumbers' => '<p>The list of phone numbers for the contact.</p>', ], ], 'PhoneNumberType' => [ 'base' => NULL, 'refs' => [ 'PhoneNumber$Type' => '<p>The type of the phone number.</p>', ], ], 'PrivacyPolicy' => [ 'base' => NULL, 'refs' => [ 'DeveloperInfo$PrivacyPolicy' => '<p>The URL of the privacy policy.</p>', ], ], 'ProductDescription' => [ 'base' => NULL, 'refs' => [ 'SkillDetails$ProductDescription' => '<p>The description of the product.</p>', ], ], 'ProductId' => [ 'base' => NULL, 'refs' => [ 'RegisterAVSDeviceRequest$ProductId' => '<p>The product ID used to identify your AVS device during authorization.</p>', ], ], 'Profile' => [ 'base' => '<p>A room profile with attributes.</p>', 'refs' => [ 'GetProfileResponse$Profile' => '<p>The details of the room profile requested. Required.</p>', ], ], 'ProfileData' => [ 'base' => '<p>The data of a room profile.</p>', 'refs' => [ 'ProfileDataList$member' => NULL, ], ], 'ProfileDataList' => [ 'base' => NULL, 'refs' => [ 'SearchProfilesResponse$Profiles' => '<p>The profiles that meet the specified set of filter criteria, in sort order.</p>', ], ], 'ProfileName' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$ProfileName' => '<p>The name of a room profile.</p>', 'Profile$ProfileName' => '<p>The name of a room profile.</p>', 'ProfileData$ProfileName' => '<p>The name of a room profile.</p>', 'RoomData$ProfileName' => '<p>The profile name of a room.</p>', 'UpdateProfileRequest$ProfileName' => '<p>The updated name for the room profile.</p>', ], ], 'ProviderCalendarId' => [ 'base' => NULL, 'refs' => [ 'CreateRoomRequest$ProviderCalendarId' => '<p>The calendar ARN for the room.</p>', 'Room$ProviderCalendarId' => '<p>The provider calendar ARN of a room.</p>', 'RoomData$ProviderCalendarId' => '<p>The provider calendar ARN of a room.</p>', 'UpdateRoomRequest$ProviderCalendarId' => '<p>The updated provider calendar ARN for the room.</p>', ], ], 'PutConferencePreferenceRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutConferencePreferenceResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutInvitationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutInvitationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutRoomSkillParameterRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRoomSkillParameterResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutSkillAuthorizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutSkillAuthorizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'RawPhoneNumber' => [ 'base' => NULL, 'refs' => [ 'Contact$PhoneNumber' => '<p>The phone number of the contact. The phone number type defaults to WORK. You can either specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone number type and multiple numbers.</p>', 'ContactData$PhoneNumber' => '<p>The phone number of the contact. The phone number type defaults to WORK. You can specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone number type and multiple numbers.</p>', 'CreateContactRequest$PhoneNumber' => '<p>The phone number of the contact in E.164 format. The phone number type defaults to WORK. You can specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone number type and multiple numbers.</p>', 'PhoneNumber$Number' => '<p>The raw value of the phone number.</p>', 'UpdateContactRequest$PhoneNumber' => '<p>The updated phone number of the contact. The phone number type defaults to WORK. You can either specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone number type and multiple numbers.</p>', ], ], 'RegisterAVSDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterAVSDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'RejectSkillRequest' => [ 'base' => NULL, 'refs' => [], ], 'RejectSkillResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReleaseDate' => [ 'base' => NULL, 'refs' => [ 'SkillDetails$ReleaseDate' => '<p>The date when the skill was released.</p>', ], ], 'RequireCheckIn' => [ 'base' => '<p>Settings for the require check in feature that are applied to a room profile. Require check in allows a meeting room’s Alexa or AVS device to prompt the user to check in; otherwise, the room will be released. </p>', 'refs' => [ 'MeetingRoomConfiguration$RequireCheckIn' => '<p>Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it\'s not checked into. This makes the room available for others. Users can check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check in.” </p>', ], ], 'RequirePin' => [ 'base' => NULL, 'refs' => [ 'MeetingSetting$RequirePin' => '<p>The values that indicate whether the pin is always required.</p>', ], ], 'ResolveRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResolveRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceAssociatedException' => [ 'base' => '<p>Another resource is associated with the resource in the request.</p>', 'refs' => [], ], 'ResourceInUseException' => [ 'base' => '<p>The resource in the request is already in use.</p>', 'refs' => [], ], 'ReviewKey' => [ 'base' => NULL, 'refs' => [ 'Reviews$key' => NULL, ], ], 'ReviewValue' => [ 'base' => NULL, 'refs' => [ 'Reviews$value' => NULL, ], ], 'Reviews' => [ 'base' => NULL, 'refs' => [ 'SkillDetails$Reviews' => '<p> <i>This member has been deprecated.</i> </p> <p>The list of reviews for the skill, including Key and Value pair.</p>', ], ], 'RevokeInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'RevokeInvitationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Room' => [ 'base' => '<p>A room with attributes.</p>', 'refs' => [ 'GetRoomResponse$Room' => '<p>The details of the room requested.</p>', ], ], 'RoomData' => [ 'base' => '<p>The data of a room.</p>', 'refs' => [ 'RoomDataList$member' => NULL, ], ], 'RoomDataList' => [ 'base' => NULL, 'refs' => [ 'SearchRoomsResponse$Rooms' => '<p>The rooms that meet the specified set of filter criteria, in sort order.</p>', ], ], 'RoomDescription' => [ 'base' => NULL, 'refs' => [ 'CreateRoomRequest$Description' => '<p>The description for the room.</p>', 'Room$Description' => '<p>The description of a room.</p>', 'RoomData$Description' => '<p>The description of a room.</p>', 'UpdateRoomRequest$Description' => '<p>The updated description for the room.</p>', ], ], 'RoomName' => [ 'base' => NULL, 'refs' => [ 'CreateRoomRequest$RoomName' => '<p>The name for the room.</p>', 'ResolveRoomResponse$RoomName' => '<p>The name of the room from which the skill request was invoked.</p>', 'Room$RoomName' => '<p>The name of a room.</p>', 'RoomData$RoomName' => '<p>The name of a room.</p>', 'UpdateRoomRequest$RoomName' => '<p>The updated name for the room.</p>', ], ], 'RoomSkillParameter' => [ 'base' => '<p>A skill parameter associated with a room.</p>', 'refs' => [ 'GetRoomSkillParameterResponse$RoomSkillParameter' => '<p>The details of the room skill parameter requested. Required.</p>', 'PutRoomSkillParameterRequest$RoomSkillParameter' => '<p>The updated room skill parameter. Required.</p>', 'RoomSkillParameters$member' => NULL, ], ], 'RoomSkillParameterKey' => [ 'base' => NULL, 'refs' => [ 'DeleteRoomSkillParameterRequest$ParameterKey' => '<p>The room skill parameter key for which to remove details.</p>', 'GetRoomSkillParameterRequest$ParameterKey' => '<p>The room skill parameter key for which to get details. Required.</p>', 'RoomSkillParameter$ParameterKey' => '<p>The parameter key of a room skill parameter. ParameterKey is an enumerated type that only takes “DEFAULT” or “SCOPE” as valid values.</p>', ], ], 'RoomSkillParameterValue' => [ 'base' => NULL, 'refs' => [ 'RoomSkillParameter$ParameterValue' => '<p>The parameter value of a room skill parameter.</p>', ], ], 'RoomSkillParameters' => [ 'base' => NULL, 'refs' => [ 'ResolveRoomResponse$RoomSkillParameters' => '<p>Response to get the room profile request. Required.</p>', ], ], 'S3KeyPrefix' => [ 'base' => NULL, 'refs' => [ 'BusinessReportSchedule$S3KeyPrefix' => '<p>The S3 key where the report is delivered.</p>', 'CreateBusinessReportScheduleRequest$S3KeyPrefix' => '<p>The S3 key where the report is delivered.</p>', 'UpdateBusinessReportScheduleRequest$S3KeyPrefix' => '<p>The S3 key where the report is delivered.</p>', ], ], 'SampleUtterances' => [ 'base' => NULL, 'refs' => [ 'SkillsStoreSkill$SampleUtterances' => '<p>Sample utterances that interact with the skill.</p>', ], ], 'SearchAddressBooksRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchAddressBooksResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchContactsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchContactsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchDevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchDevicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchNetworkProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchNetworkProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchRoomsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchRoomsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchSkillGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchSkillGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'SendAnnouncementRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendAnnouncementResponse' => [ 'base' => NULL, 'refs' => [], ], 'SendInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendInvitationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ShortDescription' => [ 'base' => NULL, 'refs' => [ 'SkillsStoreSkill$ShortDescription' => '<p>Short description about the skill.</p>', ], ], 'ShortSkillIdList' => [ 'base' => NULL, 'refs' => [ 'GetInvitationConfigurationResponse$PrivateSkillIds' => '<p>The list of private skill IDs that you want to recommend to the user to enable in the invitation.</p>', 'PutInvitationConfigurationRequest$PrivateSkillIds' => '<p>The list of private skill IDs that you want to recommend to the user to enable in the invitation.</p>', ], ], 'SipAddress' => [ 'base' => '<p>The SIP address for the contact containing the URI and SIP address type.</p>', 'refs' => [ 'SipAddressList$member' => NULL, ], ], 'SipAddressList' => [ 'base' => NULL, 'refs' => [ 'Contact$SipAddresses' => '<p>The list of SIP addresses for the contact.</p>', 'ContactData$SipAddresses' => '<p>The list of SIP addresses for the contact.</p>', 'CreateContactRequest$SipAddresses' => '<p>The list of SIP addresses for the contact.</p>', 'UpdateContactRequest$SipAddresses' => '<p>The list of SIP addresses for the contact.</p>', ], ], 'SipType' => [ 'base' => NULL, 'refs' => [ 'SipAddress$Type' => '<p>The type of the SIP address.</p>', ], ], 'SipUri' => [ 'base' => NULL, 'refs' => [ 'SipAddress$Uri' => '<p>The URI for the SIP address.</p>', ], ], 'SkillDetails' => [ 'base' => '<p>Granular information about the skill.</p>', 'refs' => [ 'SkillsStoreSkill$SkillDetails' => '<p>Information about the skill.</p>', ], ], 'SkillGroup' => [ 'base' => '<p>A skill group with attributes.</p>', 'refs' => [ 'GetSkillGroupResponse$SkillGroup' => '<p>The details of the skill group requested. Required.</p>', ], ], 'SkillGroupData' => [ 'base' => '<p>The attributes of a skill group.</p>', 'refs' => [ 'SkillGroupDataList$member' => NULL, ], ], 'SkillGroupDataList' => [ 'base' => NULL, 'refs' => [ 'SearchSkillGroupsResponse$SkillGroups' => '<p>The skill groups that meet the filter criteria, in sort order.</p>', ], ], 'SkillGroupDescription' => [ 'base' => NULL, 'refs' => [ 'CreateSkillGroupRequest$Description' => '<p>The description for the skill group.</p>', 'SkillGroup$Description' => '<p>The description of a skill group.</p>', 'SkillGroupData$Description' => '<p>The description of a skill group.</p>', 'UpdateSkillGroupRequest$Description' => '<p>The updated description for the skill group.</p>', ], ], 'SkillGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateSkillGroupRequest$SkillGroupName' => '<p>The name for the skill group.</p>', 'SkillGroup$SkillGroupName' => '<p>The name of a skill group.</p>', 'SkillGroupData$SkillGroupName' => '<p>The skill group name of a skill group.</p>', 'UpdateSkillGroupRequest$SkillGroupName' => '<p>The updated name for the skill group.</p>', ], ], 'SkillId' => [ 'base' => NULL, 'refs' => [ 'ApproveSkillRequest$SkillId' => '<p>The unique identifier of the skill.</p>', 'AssociateSkillWithSkillGroupRequest$SkillId' => '<p>The unique identifier of the skill.</p>', 'AssociateSkillWithUsersRequest$SkillId' => '<p>The private skill ID you want to make available to enrolled users.</p>', 'DeleteRoomSkillParameterRequest$SkillId' => '<p>The ID of the skill from which to remove the room skill parameter details.</p>', 'DeleteSkillAuthorizationRequest$SkillId' => '<p>The unique identifier of a skill.</p>', 'DisassociateSkillFromSkillGroupRequest$SkillId' => '<p>The ARN of a skill group to associate to a skill.</p>', 'DisassociateSkillFromUsersRequest$SkillId' => '<p> The private skill ID you want to make unavailable for enrolled users.</p>', 'GetRoomSkillParameterRequest$SkillId' => '<p>The ARN of the skill from which to get the room skill parameter details. Required.</p>', 'PutRoomSkillParameterRequest$SkillId' => '<p>The ARN of the skill associated with the room skill parameter. Required.</p>', 'PutSkillAuthorizationRequest$SkillId' => '<p>The unique identifier of a skill.</p>', 'RejectSkillRequest$SkillId' => '<p>The unique identifier of the skill.</p>', 'ResolveRoomRequest$SkillId' => '<p>The ARN of the skill that was requested. Required.</p>', 'ShortSkillIdList$member' => NULL, 'SkillSummary$SkillId' => '<p>The ARN of the skill summary.</p>', 'SkillsStoreSkill$SkillId' => '<p>The ARN of the skill.</p>', ], ], 'SkillListMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListSkillsRequest$MaxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListSkillsStoreSkillsByCategoryRequest$MaxResults' => '<p>The maximum number of skills returned per paginated calls.</p>', ], ], 'SkillName' => [ 'base' => NULL, 'refs' => [ 'SkillSummary$SkillName' => '<p>The name of the skill.</p>', 'SkillsStoreSkill$SkillName' => '<p>The name of the skill.</p>', ], ], 'SkillNotLinkedException' => [ 'base' => '<p>The skill must be linked to a third-party account.</p>', 'refs' => [], ], 'SkillStoreType' => [ 'base' => NULL, 'refs' => [ 'SkillTypes$member' => NULL, ], ], 'SkillSummary' => [ 'base' => '<p>The summary of skills.</p>', 'refs' => [ 'SkillSummaryList$member' => NULL, ], ], 'SkillSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListSkillsResponse$SkillSummaries' => '<p>The list of enabled skills requested. Required.</p>', ], ], 'SkillType' => [ 'base' => NULL, 'refs' => [ 'SkillSummary$SkillType' => '<p>Whether the skill is publicly available or is a private skill.</p>', ], ], 'SkillTypeFilter' => [ 'base' => NULL, 'refs' => [ 'ListSkillsRequest$SkillType' => '<p>Whether the skill is publicly available or is a private skill.</p>', ], ], 'SkillTypes' => [ 'base' => NULL, 'refs' => [ 'SkillDetails$SkillTypes' => '<p>The types of skills.</p>', ], ], 'SkillsStoreSkill' => [ 'base' => '<p>The detailed information about an Alexa skill.</p>', 'refs' => [ 'SkillsStoreSkillList$member' => NULL, ], ], 'SkillsStoreSkillList' => [ 'base' => NULL, 'refs' => [ 'ListSkillsStoreSkillsByCategoryResponse$SkillsStoreSkills' => '<p>The skill store skills.</p>', ], ], 'SmartHomeAppliance' => [ 'base' => '<p>A smart home appliance that can connect to a central system. Any domestic device can be a smart appliance. </p>', 'refs' => [ 'SmartHomeApplianceList$member' => NULL, ], ], 'SmartHomeApplianceList' => [ 'base' => NULL, 'refs' => [ 'ListSmartHomeAppliancesResponse$SmartHomeAppliances' => '<p>The smart home appliances.</p>', ], ], 'SoftwareVersion' => [ 'base' => NULL, 'refs' => [ 'Device$SoftwareVersion' => '<p>The software version of a device.</p>', 'DeviceData$SoftwareVersion' => '<p>The software version of a device.</p>', ], ], 'Sort' => [ 'base' => '<p>An object representing a sort criteria. </p>', 'refs' => [ 'SortList$member' => NULL, ], ], 'SortKey' => [ 'base' => NULL, 'refs' => [ 'Sort$Key' => '<p>The sort key of a sort object.</p>', ], ], 'SortList' => [ 'base' => NULL, 'refs' => [ 'SearchAddressBooksRequest$SortCriteria' => '<p>The sort order to use in listing the specified set of address books. The supported sort key is AddressBookName.</p>', 'SearchContactsRequest$SortCriteria' => '<p>The sort order to use in listing the specified set of contacts. The supported sort keys are DisplayName, FirstName, and LastName.</p>', 'SearchDevicesRequest$SortCriteria' => '<p>The sort order to use in listing the specified set of devices. Supported sort keys are DeviceName, DeviceStatus, RoomName, DeviceType, DeviceSerialNumber, ConnectionStatus, NetworkProfileName, NetworkProfileArn, Feature, and FailureCode.</p>', 'SearchNetworkProfilesRequest$SortCriteria' => '<p>The sort order to use to list the specified set of network profiles. Valid sort criteria includes NetworkProfileName, Ssid, and SecurityType.</p>', 'SearchProfilesRequest$SortCriteria' => '<p>The sort order to use in listing the specified set of room profiles. Supported sort keys are ProfileName and Address.</p>', 'SearchRoomsRequest$SortCriteria' => '<p>The sort order to use in listing the specified set of rooms. The supported sort keys are RoomName and ProfileName.</p>', 'SearchSkillGroupsRequest$SortCriteria' => '<p>The sort order to use in listing the specified set of skill groups. The supported sort key is SkillGroupName. </p>', 'SearchUsersRequest$SortCriteria' => '<p>The sort order to use in listing the filtered set of users. Required. Supported sort keys are UserId, FirstName, LastName, Email, and EnrollmentStatus.</p>', ], ], 'SortValue' => [ 'base' => NULL, 'refs' => [ 'Sort$Value' => '<p>The sort value of a sort object.</p>', ], ], 'Ssml' => [ 'base' => '<p>The SSML message. For more information, see <a href="https://developer.amazon.com/docs/custom-skills/speech-synthesis-markup-language-ssml-reference.html">SSML Reference</a>.</p>', 'refs' => [ 'SsmlList$member' => NULL, ], ], 'SsmlList' => [ 'base' => NULL, 'refs' => [ 'Content$SsmlList' => '<p>The list of SSML messages.</p>', ], ], 'SsmlValue' => [ 'base' => NULL, 'refs' => [ 'Ssml$Value' => '<p>The value of the SSML message in the correct SSML format. The audio tag is not supported.</p>', ], ], 'StartDeviceSyncRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDeviceSyncResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartSmartHomeApplianceDiscoveryRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSmartHomeApplianceDiscoveryResponse' => [ 'base' => NULL, 'refs' => [], ], 'Tag' => [ 'base' => '<p>A key-value pair that can be associated with a resource. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of a tag. Tag keys are case-sensitive. </p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tags to be removed from the specified resource. Do not provide system tags. Required. </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateAddressBookRequest$Tags' => '<p>The tags to be added to the specified resource. Do not provide system tags.</p>', 'CreateBusinessReportScheduleRequest$Tags' => '<p>The tags for the business report schedule.</p>', 'CreateConferenceProviderRequest$Tags' => '<p>The tags to be added to the specified resource. Do not provide system tags.</p>', 'CreateContactRequest$Tags' => '<p>The tags to be added to the specified resource. Do not provide system tags.</p>', 'CreateGatewayGroupRequest$Tags' => '<p>The tags to be added to the specified resource. Do not provide system tags.</p>', 'CreateNetworkProfileRequest$Tags' => '<p>The tags to be added to the specified resource. Do not provide system tags. </p>', 'CreateProfileRequest$Tags' => '<p>The tags for the profile.</p>', 'CreateRoomRequest$Tags' => '<p>The tags for the room.</p>', 'CreateSkillGroupRequest$Tags' => '<p>The tags for the skill group.</p>', 'CreateUserRequest$Tags' => '<p>The tags for the user.</p>', 'ListTagsResponse$Tags' => '<p>The tags requested for the specified resource.</p>', 'RegisterAVSDeviceRequest$Tags' => '<p>The tags to be added to the specified resource. Do not provide system tags.</p>', 'TagResourceRequest$Tags' => '<p>The tags to be added to the specified resource. Do not provide system tags. Required. </p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of a tag. Tag values are case sensitive and can be null.</p>', ], ], 'TemperatureUnit' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$TemperatureUnit' => '<p>The temperature unit to be used by devices in the profile.</p>', 'Profile$TemperatureUnit' => '<p>The temperature unit of a room profile.</p>', 'ProfileData$TemperatureUnit' => '<p>The temperature unit of a room profile.</p>', 'UpdateProfileRequest$TemperatureUnit' => '<p>The updated temperature unit for the room profile.</p>', ], ], 'Text' => [ 'base' => '<p>The text message.</p>', 'refs' => [ 'TextList$member' => NULL, ], ], 'TextList' => [ 'base' => NULL, 'refs' => [ 'Content$TextList' => '<p>The list of text messages.</p>', ], ], 'TextValue' => [ 'base' => NULL, 'refs' => [ 'Text$Value' => '<p>The value of the text message.</p>', ], ], 'TimeToLiveInSeconds' => [ 'base' => NULL, 'refs' => [ 'SendAnnouncementRequest$TimeToLiveInSeconds' => '<p>The time to live for an announcement. Default is 300. If delivery doesn\'t occur within this time, the announcement is not delivered.</p>', ], ], 'Timezone' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$Timezone' => '<p>The time zone used by a room profile.</p>', 'Profile$Timezone' => '<p>The time zone of a room profile.</p>', 'ProfileData$Timezone' => '<p>The time zone of a room profile.</p>', 'UpdateProfileRequest$Timezone' => '<p>The updated timezone for the room profile.</p>', ], ], 'TotalCount' => [ 'base' => NULL, 'refs' => [ 'SearchAddressBooksResponse$TotalCount' => '<p>The total number of address books returned.</p>', 'SearchContactsResponse$TotalCount' => '<p>The total number of contacts returned.</p>', 'SearchDevicesResponse$TotalCount' => '<p>The total number of devices returned.</p>', 'SearchNetworkProfilesResponse$TotalCount' => '<p>The total number of network profiles returned.</p>', 'SearchProfilesResponse$TotalCount' => '<p>The total number of room profiles returned.</p>', 'SearchRoomsResponse$TotalCount' => '<p>The total number of rooms returned.</p>', 'SearchSkillGroupsResponse$TotalCount' => '<p>The total number of skill groups returned.</p>', 'SearchUsersResponse$TotalCount' => '<p>The total number of users returned.</p>', ], ], 'TrustAnchor' => [ 'base' => NULL, 'refs' => [ 'TrustAnchorList$member' => NULL, ], ], 'TrustAnchorList' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkProfileRequest$TrustAnchors' => '<p>The root certificates of your authentication server that is installed on your devices and used to trust your authentication server during EAP negotiation. </p>', 'NetworkProfile$TrustAnchors' => '<p>The root certificates of your authentication server, which is installed on your devices and used to trust your authentication server during EAP negotiation.</p>', 'UpdateNetworkProfileRequest$TrustAnchors' => '<p>The root certificate(s) of your authentication server that will be installed on your devices and used to trust your authentication server during EAP negotiation. </p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>The caller has no permissions to operate on the resource involved in the API call.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAddressBookRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAddressBookResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBusinessReportScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBusinessReportScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConferenceProviderRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConferenceProviderResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndOfMeetingReminder' => [ 'base' => '<p>Settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder enables Alexa to remind users when a meeting is ending. </p>', 'refs' => [ 'UpdateMeetingRoomConfiguration$EndOfMeetingReminder' => '<p>Settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder enables Alexa to remind users when a meeting is ending. </p>', ], ], 'UpdateGatewayGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGatewayGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGatewayResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInstantBooking' => [ 'base' => '<p>Updates settings for the instant booking feature that are applied to a room profile. If instant booking is enabled, Alexa automatically reserves a room if it is free when a user joins a meeting with Alexa.</p>', 'refs' => [ 'UpdateMeetingRoomConfiguration$InstantBooking' => '<p>Settings to automatically book an available room available for a configured duration when joining a meeting with Alexa.</p>', ], ], 'UpdateMeetingRoomConfiguration' => [ 'base' => '<p>Updates meeting room settings of a room profile.</p>', 'refs' => [ 'UpdateProfileRequest$MeetingRoomConfiguration' => '<p>The updated meeting room settings of a room profile.</p>', ], ], 'UpdateNetworkProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNetworkProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRequireCheckIn' => [ 'base' => '<p>Updates settings for the require check in feature that are applied to a room profile. Require check in allows a meeting room’s Alexa or AVS device to prompt the user to check in; otherwise, the room will be released. </p>', 'refs' => [ 'UpdateMeetingRoomConfiguration$RequireCheckIn' => '<p>Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it\'s not checked into to make the room available for others. Users can check in by joining the meeting with Alexa or an AVS device, or by saying “Alexa, check in.” </p>', ], ], 'UpdateRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSkillGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSkillGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'DeveloperInfo$Url' => '<p>The website of the developer.</p>', ], ], 'UserCode' => [ 'base' => NULL, 'refs' => [ 'RegisterAVSDeviceRequest$UserCode' => '<p>The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device Authorization Request component of the OAuth code-based linking specification.</p>', ], ], 'UserData' => [ 'base' => '<p>Information related to a user.</p>', 'refs' => [ 'UserDataList$member' => NULL, ], ], 'UserDataList' => [ 'base' => NULL, 'refs' => [ 'SearchUsersResponse$Users' => '<p>The users that meet the specified set of filter criteria, in sort order.</p>', ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'ResolveRoomRequest$UserId' => '<p>The ARN of the user. Required.</p>', ], ], 'Utterance' => [ 'base' => NULL, 'refs' => [ 'SampleUtterances$member' => NULL, ], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'AuthorizationResult$value' => NULL, ], ], 'WakeWord' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$WakeWord' => '<p>A wake word for Alexa, Echo, Amazon, or a computer.</p>', 'Profile$WakeWord' => '<p>The wake word of a room profile.</p>', 'ProfileData$WakeWord' => '<p>The wake word of a room profile.</p>', 'UpdateProfileRequest$WakeWord' => '<p>The updated wake word for the room profile.</p>', ], ], 'boolean' => [ 'base' => NULL, 'refs' => [ 'SkillSummary$SupportsLinking' => '<p>Linking support for a skill.</p>', 'SkillsStoreSkill$SupportsLinking' => '<p>Linking support for a skill.</p>', ], ], 'user_FirstName' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$FirstName' => '<p>The first name for the user.</p>', 'UserData$FirstName' => '<p>The first name of a user.</p>', ], ], 'user_LastName' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$LastName' => '<p>The last name for the user.</p>', 'UserData$LastName' => '<p>The last name of a user.</p>', ], ], 'user_UserId' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$UserId' => '<p>The ARN for the user.</p>', ], ], ],];
