<?php
// This file was auto-generated from sdk-root/src/data/application-insights/2018-11-25/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon CloudWatch Application Insights</fullname> <p> Amazon CloudWatch Application Insights is a service that helps you detect common problems with your applications. It enables you to pinpoint the source of issues in your applications (built with technologies such as Microsoft IIS, .NET, and Microsoft SQL Server), by providing key insights into detected problems.</p> <p>After you onboard your application, CloudWatch Application Insights identifies, recommends, and sets up metrics and logs. It continuously analyzes and correlates your metrics and logs for unusual behavior to surface actionable problems with your application. For example, if your application is slow and unresponsive and leading to HTTP 500 errors in your Application Load Balancer (ALB), Application Insights informs you that a memory pressure problem with your SQL Server database is occurring. It bases this analysis on impactful metrics and log errors. </p>', 'operations' => [ 'CreateApplication' => '<p>Adds an application that is created from a resource group.</p>', 'CreateComponent' => '<p>Creates a custom component by grouping similar standalone instances to monitor.</p>', 'CreateLogPattern' => '<p>Adds an log pattern to a <code>LogPatternSet</code>.</p>', 'DeleteApplication' => '<p>Removes the specified application from monitoring. Does not delete the application.</p>', 'DeleteComponent' => '<p>Ungroups a custom component. When you ungroup custom components, all applicable monitors that are set up for the component are removed and the instances revert to their standalone status.</p>', 'DeleteLogPattern' => '<p>Removes the specified log pattern from a <code>LogPatternSet</code>.</p>', 'DescribeApplication' => '<p>Describes the application.</p>', 'DescribeComponent' => '<p>Describes a component and lists the resources that are grouped together in a component.</p>', 'DescribeComponentConfiguration' => '<p>Describes the monitoring configuration of the component.</p>', 'DescribeComponentConfigurationRecommendation' => '<p>Describes the recommended monitoring configuration of the component.</p>', 'DescribeLogPattern' => '<p>Describe a specific log pattern from a <code>LogPatternSet</code>.</p>', 'DescribeObservation' => '<p>Describes an anomaly or error with the application.</p>', 'DescribeProblem' => '<p>Describes an application problem.</p>', 'DescribeProblemObservations' => '<p>Describes the anomalies or errors associated with the problem.</p>', 'ListApplications' => '<p>Lists the IDs of the applications that you are monitoring. </p>', 'ListComponents' => '<p>Lists the auto-grouped, standalone, and custom components of the application.</p>', 'ListConfigurationHistory' => '<p> Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are: </p> <ul> <li> <p>INFO: creating a new alarm or updating an alarm threshold.</p> </li> <li> <p>WARN: alarm not created due to insufficient data points used to predict thresholds.</p> </li> <li> <p>ERROR: alarm not created due to permission errors or exceeding quotas. </p> </li> </ul>', 'ListLogPatternSets' => '<p>Lists the log pattern sets in the specific application.</p>', 'ListLogPatterns' => '<p>Lists the log patterns in the specific log <code>LogPatternSet</code>.</p>', 'ListProblems' => '<p>Lists the problems with your application.</p>', 'ListTagsForResource' => '<p>Retrieve a list of the tags (keys and values) that are associated with a specified application. A <i>tag</i> is a label that you optionally define and associate with an application. Each tag consists of a required <i>tag key</i> and an optional associated <i>tag value</i>. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.</p>', 'TagResource' => '<p>Add one or more tags (keys and values) to a specified application. A <i>tag</i> is a label that you optionally define and associate with an application. Tags can help you categorize and manage application in different ways, such as by purpose, owner, environment, or other criteria. </p> <p>Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.</p>', 'UntagResource' => '<p>Remove one or more tags (keys and values) from a specified application.</p>', 'UpdateApplication' => '<p>Updates the application.</p>', 'UpdateComponent' => '<p>Updates the custom component name and/or the list of resources that make up the component.</p>', 'UpdateComponentConfiguration' => '<p>Updates the monitoring configurations for the component. The configuration input parameter is an escaped JSON of the configuration and should match the schema of what is returned by <code>DescribeComponentConfigurationRecommendation</code>. </p>', 'UpdateLogPattern' => '<p>Adds a log pattern to a <code>LogPatternSet</code>.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p> User does not have permissions to perform this action. </p>', 'refs' => [], ], 'AffectedResource' => [ 'base' => NULL, 'refs' => [ 'Problem$AffectedResource' => '<p>The resource affected by the problem.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the application that you want to retrieve tag information for.</p>', 'TagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the application that you want to add one or more tags to.</p>', 'TooManyTagsException$ResourceName' => '<p>The name of the resource with too many tags.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the application that you want to remove one or more tags from.</p>', ], ], 'ApplicationComponent' => [ 'base' => '<p>Describes a standalone resource or similarly grouped resources that the application is made up of.</p>', 'refs' => [ 'ApplicationComponentList$member' => NULL, 'DescribeComponentResponse$ApplicationComponent' => NULL, ], ], 'ApplicationComponentList' => [ 'base' => NULL, 'refs' => [ 'ListComponentsResponse$ApplicationComponentList' => '<p>The list of application components.</p>', ], ], 'ApplicationInfo' => [ 'base' => '<p>Describes the status of the application.</p>', 'refs' => [ 'ApplicationInfoList$member' => NULL, 'CreateApplicationResponse$ApplicationInfo' => '<p>Information about the application.</p>', 'DescribeApplicationResponse$ApplicationInfo' => '<p>Information about the application.</p>', 'UpdateApplicationResponse$ApplicationInfo' => '<p>Information about the application. </p>', ], ], 'ApplicationInfoList' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsResponse$ApplicationInfoList' => '<p>The list of applications.</p>', ], ], 'AutoConfigEnabled' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$AutoConfigEnabled' => NULL, 'CreateApplicationRequest$AutoConfigEnabled' => NULL, 'UpdateApplicationRequest$AutoConfigEnabled' => NULL, 'UpdateComponentConfigurationRequest$AutoConfigEnabled' => NULL, ], ], 'AutoCreate' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationRequest$AutoCreate' => NULL, ], ], 'BadRequestException' => [ 'base' => '<p>The request is not understood by the server.</p>', 'refs' => [], ], 'CWEMonitorEnabled' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$CWEMonitorEnabled' => '<p> Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. </p>', 'CreateApplicationRequest$CWEMonitorEnabled' => '<p> Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. </p>', 'UpdateApplicationRequest$CWEMonitorEnabled' => '<p> Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as <code>instance terminated</code>, <code>failed deployment</code>, and others. </p>', ], ], 'CloudWatchEventDetailType' => [ 'base' => NULL, 'refs' => [ 'Observation$CloudWatchEventDetailType' => '<p> The detail type of the CloudWatch Event-based observation, for example, <code>EC2 Instance State-change Notification</code>. </p>', ], ], 'CloudWatchEventId' => [ 'base' => NULL, 'refs' => [ 'Observation$CloudWatchEventId' => '<p> The ID of the CloudWatch Event-based observation related to the detected problem. </p>', ], ], 'CloudWatchEventSource' => [ 'base' => NULL, 'refs' => [ 'Observation$CloudWatchEventSource' => '<p> The source of the CloudWatch Event. </p>', ], ], 'CodeDeployApplication' => [ 'base' => NULL, 'refs' => [ 'Observation$CodeDeployApplication' => '<p> The CodeDeploy application to which the deployment belongs. </p>', ], ], 'CodeDeployDeploymentGroup' => [ 'base' => NULL, 'refs' => [ 'Observation$CodeDeployDeploymentGroup' => '<p> The deployment group to which the CodeDeploy deployment belongs. </p>', ], ], 'CodeDeployDeploymentId' => [ 'base' => NULL, 'refs' => [ 'Observation$CodeDeployDeploymentId' => '<p> The deployment ID of the CodeDeploy-based observation related to the detected problem. </p>', ], ], 'CodeDeployInstanceGroupId' => [ 'base' => NULL, 'refs' => [ 'Observation$CodeDeployInstanceGroupId' => '<p> The instance group to which the CodeDeploy instance belongs. </p>', ], ], 'CodeDeployState' => [ 'base' => NULL, 'refs' => [ 'Observation$CodeDeployState' => '<p> The status of the CodeDeploy deployment, for example <code>SUCCESS</code> or <code> FAILURE</code>. </p>', ], ], 'ComponentConfiguration' => [ 'base' => NULL, 'refs' => [ 'DescribeComponentConfigurationRecommendationResponse$ComponentConfiguration' => '<p>The recommended configuration settings of the component. The value is the escaped JSON of the configuration.</p>', 'DescribeComponentConfigurationResponse$ComponentConfiguration' => '<p>The configuration settings of the component. The value is the escaped JSON of the configuration.</p>', 'UpdateComponentConfigurationRequest$ComponentConfiguration' => '<p>The configuration settings of the component. The value is the escaped JSON of the configuration. For more information about the JSON format, see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with JSON</a>. You can send a request to <code>DescribeComponentConfigurationRecommendation</code> to see the recommended configuration for a component. For the complete format of the component configuration file, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component Configuration</a>.</p>', ], ], 'ComponentName' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponent$ComponentName' => '<p>The name of the component.</p>', 'DescribeComponentConfigurationRecommendationRequest$ComponentName' => '<p>The name of the component.</p>', 'DescribeComponentConfigurationRequest$ComponentName' => '<p>The name of the component.</p>', 'DescribeComponentRequest$ComponentName' => '<p>The name of the component.</p>', 'ListProblemsRequest$ComponentName' => NULL, 'UpdateComponentConfigurationRequest$ComponentName' => '<p>The name of the component.</p>', ], ], 'ConfigurationEvent' => [ 'base' => '<p> The event information. </p>', 'refs' => [ 'ConfigurationEventList$member' => NULL, ], ], 'ConfigurationEventDetail' => [ 'base' => NULL, 'refs' => [ 'ConfigurationEvent$EventDetail' => '<p> The details of the event in plain text. </p>', ], ], 'ConfigurationEventList' => [ 'base' => NULL, 'refs' => [ 'ListConfigurationHistoryResponse$EventList' => '<p> The list of configuration events and their corresponding details. </p>', ], ], 'ConfigurationEventMonitoredResourceARN' => [ 'base' => NULL, 'refs' => [ 'ConfigurationEvent$MonitoredResourceARN' => '<p> The resource monitored by Application Insights. </p>', ], ], 'ConfigurationEventResourceName' => [ 'base' => NULL, 'refs' => [ 'ConfigurationEvent$EventResourceName' => '<p> The name of the resource Application Insights attempted to configure. </p>', ], ], 'ConfigurationEventResourceType' => [ 'base' => NULL, 'refs' => [ 'ConfigurationEvent$EventResourceType' => '<p> The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM. </p>', ], ], 'ConfigurationEventStatus' => [ 'base' => NULL, 'refs' => [ 'ConfigurationEvent$EventStatus' => '<p> The status of the configuration update event. Possible values include INFO, WARN, and ERROR. </p>', 'ListConfigurationHistoryRequest$EventStatus' => '<p>The status of the configuration update event. Possible values include INFO, WARN, and ERROR.</p>', ], ], 'ConfigurationEventTime' => [ 'base' => NULL, 'refs' => [ 'ConfigurationEvent$EventTime' => '<p> The timestamp of the event. </p>', ], ], 'CreateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLogPatternRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLogPatternResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomComponentName' => [ 'base' => NULL, 'refs' => [ 'CreateComponentRequest$ComponentName' => '<p>The name of the component.</p>', 'DeleteComponentRequest$ComponentName' => '<p>The name of the component.</p>', 'UpdateComponentRequest$ComponentName' => '<p>The name of the component.</p>', 'UpdateComponentRequest$NewComponentName' => '<p>The new name of the component.</p>', ], ], 'DeleteApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLogPatternRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLogPatternResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeComponentConfigurationRecommendationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeComponentConfigurationRecommendationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeComponentConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeComponentConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLogPatternRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLogPatternResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeObservationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeObservationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProblemObservationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProblemObservationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProblemRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProblemResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectedWorkload' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponent$DetectedWorkload' => '<p> Workloads detected in the application component. </p>', ], ], 'DiscoveryType' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$DiscoveryType' => NULL, ], ], 'EbsCause' => [ 'base' => NULL, 'refs' => [ 'Observation$EbsCause' => '<p> The cause of an EBS CloudWatch event. </p>', ], ], 'EbsEvent' => [ 'base' => NULL, 'refs' => [ 'Observation$EbsEvent' => '<p> The type of EBS CloudWatch event, such as <code>createVolume</code>, <code>deleteVolume</code> or <code>attachVolume</code>. </p>', ], ], 'EbsRequestId' => [ 'base' => NULL, 'refs' => [ 'Observation$EbsRequestId' => '<p> The request ID of an EBS CloudWatch event. </p>', ], ], 'EbsResult' => [ 'base' => NULL, 'refs' => [ 'Observation$EbsResult' => '<p> The result of an EBS CloudWatch event, such as <code>failed</code> or <code>succeeded</code>. </p>', ], ], 'Ec2State' => [ 'base' => NULL, 'refs' => [ 'Observation$Ec2State' => '<p> The state of the instance, such as <code>STOPPING</code> or <code>TERMINATING</code>. </p>', ], ], 'EndTime' => [ 'base' => NULL, 'refs' => [ 'ListConfigurationHistoryRequest$EndTime' => '<p>The end time of the event.</p>', 'ListProblemsRequest$EndTime' => '<p>The time when the problem ended, in epoch seconds. If not specified, problems within the past seven days are returned.</p>', 'Observation$EndTime' => '<p>The time when the observation ended, in epoch seconds.</p>', 'Problem$EndTime' => '<p>The time when the problem ended, in epoch seconds.</p>', ], ], 'ErrorMsg' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'BadRequestException$Message' => NULL, 'InternalServerException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'TagsAlreadyExistException$Message' => NULL, 'TooManyTagsException$Message' => NULL, ], ], 'Feedback' => [ 'base' => NULL, 'refs' => [ 'Problem$Feedback' => '<p>Feedback provided by the user about the problem.</p>', ], ], 'FeedbackKey' => [ 'base' => NULL, 'refs' => [ 'Feedback$key' => NULL, ], ], 'FeedbackValue' => [ 'base' => NULL, 'refs' => [ 'Feedback$value' => NULL, ], ], 'HealthEventArn' => [ 'base' => NULL, 'refs' => [ 'Observation$HealthEventArn' => '<p> The Amazon Resource Name (ARN) of the AWS Health Event-based observation.</p>', ], ], 'HealthEventDescription' => [ 'base' => NULL, 'refs' => [ 'Observation$HealthEventDescription' => '<p> The description of the AWS Health event provided by the service, such as Amazon EC2. </p>', ], ], 'HealthEventTypeCategory' => [ 'base' => NULL, 'refs' => [ 'Observation$HealthEventTypeCategory' => '<p> The category of the AWS Health event, such as <code>issue</code>. </p>', ], ], 'HealthEventTypeCode' => [ 'base' => NULL, 'refs' => [ 'Observation$HealthEventTypeCode' => '<p> The type of the AWS Health event, for example, <code>AWS_EC2_POWER_CONNECTIVITY_ISSUE</code>. </p>', ], ], 'HealthService' => [ 'base' => NULL, 'refs' => [ 'Observation$HealthService' => '<p> The service to which the AWS Health Event belongs, such as EC2. </p>', ], ], 'Insights' => [ 'base' => NULL, 'refs' => [ 'Problem$Insights' => '<p>A detailed analysis of the problem using machine learning.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The server encountered an internal error and is unable to complete the request.</p>', 'refs' => [], ], 'LastRecurrenceTime' => [ 'base' => NULL, 'refs' => [ 'Problem$LastRecurrenceTime' => NULL, ], ], 'LifeCycle' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$LifeCycle' => '<p>The lifecycle of the application. </p>', ], ], 'LineTime' => [ 'base' => NULL, 'refs' => [ 'Observation$LineTime' => '<p>The timestamp in the CloudWatch Logs that specifies when the matched line occurred.</p>', ], ], 'ListApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListConfigurationHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListConfigurationHistoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLogPatternSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLogPatternSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLogPatternsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLogPatternsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProblemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProblemsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogFilter' => [ 'base' => NULL, 'refs' => [ 'Observation$LogFilter' => '<p>The log filter of the observation.</p>', ], ], 'LogGroup' => [ 'base' => NULL, 'refs' => [ 'Observation$LogGroup' => '<p>The log group name.</p>', ], ], 'LogPattern' => [ 'base' => '<p>An object that defines the log patterns that belongs to a <code>LogPatternSet</code>.</p>', 'refs' => [ 'CreateLogPatternResponse$LogPattern' => '<p>The successfully created log pattern.</p>', 'DescribeLogPatternResponse$LogPattern' => '<p>The successfully created log pattern.</p>', 'LogPatternList$member' => NULL, 'UpdateLogPatternResponse$LogPattern' => '<p>The successfully created log pattern.</p>', ], ], 'LogPatternList' => [ 'base' => NULL, 'refs' => [ 'ListLogPatternsResponse$LogPatterns' => '<p>The list of log patterns.</p>', ], ], 'LogPatternName' => [ 'base' => NULL, 'refs' => [ 'CreateLogPatternRequest$PatternName' => '<p>The name of the log pattern.</p>', 'DeleteLogPatternRequest$PatternName' => '<p>The name of the log pattern.</p>', 'DescribeLogPatternRequest$PatternName' => '<p>The name of the log pattern.</p>', 'LogPattern$PatternName' => '<p>The name of the log pattern. A log pattern name can contain as many as 50 characters, and it cannot be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.</p>', 'UpdateLogPatternRequest$PatternName' => '<p>The name of the log pattern.</p>', ], ], 'LogPatternRank' => [ 'base' => NULL, 'refs' => [ 'CreateLogPatternRequest$Rank' => '<p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns. </p>', 'LogPattern$Rank' => '<p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns. </p>', 'UpdateLogPatternRequest$Rank' => '<p>Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for AWS-provided patterns. </p>', ], ], 'LogPatternRegex' => [ 'base' => NULL, 'refs' => [ 'CreateLogPatternRequest$Pattern' => '<p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>', 'LogPattern$Pattern' => '<p>A regular expression that defines the log pattern. A log pattern can contain as many as 50 characters, and it cannot be empty. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>', 'UpdateLogPatternRequest$Pattern' => '<p>The log pattern. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference constructions are not supported.</p>', ], ], 'LogPatternSetList' => [ 'base' => NULL, 'refs' => [ 'ListLogPatternSetsResponse$LogPatternSets' => '<p>The list of log pattern sets.</p>', ], ], 'LogPatternSetName' => [ 'base' => NULL, 'refs' => [ 'CreateLogPatternRequest$PatternSetName' => '<p>The name of the log pattern set.</p>', 'DeleteLogPatternRequest$PatternSetName' => '<p>The name of the log pattern set.</p>', 'DescribeLogPatternRequest$PatternSetName' => '<p>The name of the log pattern set.</p>', 'ListLogPatternsRequest$PatternSetName' => '<p>The name of the log pattern set.</p>', 'LogPattern$PatternSetName' => '<p>The name of the log pattern. A log pattern name can contain as many as 30 characters, and it cannot be empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.</p>', 'LogPatternSetList$member' => NULL, 'UpdateLogPatternRequest$PatternSetName' => '<p>The name of the log pattern set.</p>', ], ], 'LogText' => [ 'base' => NULL, 'refs' => [ 'Observation$LogText' => '<p>The log text of the observation.</p>', ], ], 'MaxEntities' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'ListComponentsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'ListConfigurationHistoryRequest$MaxResults' => '<p> The maximum number of results returned by <code>ListConfigurationHistory</code> in paginated output. When this parameter is used, <code>ListConfigurationHistory</code> returns only <code>MaxResults</code> in a single page along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListConfigurationHistory</code> request with the returned <code>NextToken</code> value. If this parameter is not used, then <code>ListConfigurationHistory</code> returns all results. </p>', 'ListLogPatternSetsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'ListLogPatternsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'ListProblemsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', ], ], 'MetaDataKey' => [ 'base' => NULL, 'refs' => [ 'WorkloadMetaData$key' => NULL, ], ], 'MetaDataValue' => [ 'base' => NULL, 'refs' => [ 'WorkloadMetaData$value' => NULL, ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'Observation$MetricName' => '<p>The name of the observation metric.</p>', ], ], 'MetricNamespace' => [ 'base' => NULL, 'refs' => [ 'Observation$MetricNamespace' => '<p>The namespace of the observation metric.</p>', ], ], 'Monitor' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponent$Monitor' => '<p>Indicates whether the application component is monitored. </p>', 'DescribeComponentConfigurationResponse$Monitor' => '<p>Indicates whether the application component is monitored.</p>', 'UpdateComponentConfigurationRequest$Monitor' => '<p>Indicates whether the application component is monitored.</p>', ], ], 'Observation' => [ 'base' => '<p>Describes an anomaly or error with the application.</p>', 'refs' => [ 'DescribeObservationResponse$Observation' => '<p>Information about the observation.</p>', 'ObservationList$member' => NULL, ], ], 'ObservationId' => [ 'base' => NULL, 'refs' => [ 'DescribeObservationRequest$ObservationId' => '<p>The ID of the observation.</p>', 'Observation$Id' => '<p>The ID of the observation type.</p>', ], ], 'ObservationList' => [ 'base' => NULL, 'refs' => [ 'RelatedObservations$ObservationList' => '<p>The list of observations related to the problem.</p>', ], ], 'OpsCenterEnabled' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$OpsCenterEnabled' => '<p> Indicates whether Application Insights will create opsItems for any problem detected by Application Insights for an application. </p>', 'CreateApplicationRequest$OpsCenterEnabled' => '<p> When set to <code>true</code>, creates opsItems for any problems detected on an application. </p>', 'UpdateApplicationRequest$OpsCenterEnabled' => '<p> When set to <code>true</code>, creates opsItems for any problems detected on an application. </p>', ], ], 'OpsItemSNSTopicArn' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$OpsItemSNSTopicArn' => '<p> The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS notifications for opsItem updates. </p>', 'CreateApplicationRequest$OpsItemSNSTopicArn' => '<p> The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem. </p>', 'UpdateApplicationRequest$OpsItemSNSTopicArn' => '<p> The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem.</p>', ], ], 'OsType' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponent$OsType' => '<p> The operating system of the component. </p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsRequest$NextToken' => '<p>The token to request the next page of results.</p>', 'ListApplicationsResponse$NextToken' => '<p>The token used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', 'ListComponentsRequest$NextToken' => '<p>The token to request the next page of results.</p>', 'ListComponentsResponse$NextToken' => '<p>The token to request the next page of results.</p>', 'ListConfigurationHistoryRequest$NextToken' => '<p>The <code>NextToken</code> value returned from a previous paginated <code>ListConfigurationHistory</code> request where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>NextToken</code> value. This value is <code>null</code> when there are no more results to return.</p>', 'ListConfigurationHistoryResponse$NextToken' => '<p>The <code>NextToken</code> value to include in a future <code>ListConfigurationHistory</code> request. When the results of a <code>ListConfigurationHistory</code> request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListLogPatternSetsRequest$NextToken' => '<p>The token to request the next page of results.</p>', 'ListLogPatternSetsResponse$NextToken' => '<p>The token used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', 'ListLogPatternsRequest$NextToken' => '<p>The token to request the next page of results.</p>', 'ListLogPatternsResponse$NextToken' => '<p>The token used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', 'ListProblemsRequest$NextToken' => '<p>The token to request the next page of results.</p>', 'ListProblemsResponse$NextToken' => '<p>The token used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', ], ], 'Problem' => [ 'base' => '<p>Describes a problem that is detected by correlating observations.</p>', 'refs' => [ 'DescribeProblemResponse$Problem' => '<p>Information about the problem. </p>', 'ProblemList$member' => NULL, ], ], 'ProblemId' => [ 'base' => NULL, 'refs' => [ 'DescribeProblemObservationsRequest$ProblemId' => '<p>The ID of the problem.</p>', 'DescribeProblemRequest$ProblemId' => '<p>The ID of the problem.</p>', 'Problem$Id' => '<p>The ID of the problem.</p>', ], ], 'ProblemList' => [ 'base' => NULL, 'refs' => [ 'ListProblemsResponse$ProblemList' => '<p>The list of problems. </p>', ], ], 'RdsEventCategories' => [ 'base' => NULL, 'refs' => [ 'Observation$RdsEventCategories' => '<p> The category of an RDS event. </p>', ], ], 'RdsEventMessage' => [ 'base' => NULL, 'refs' => [ 'Observation$RdsEventMessage' => '<p> The message of an RDS event. </p>', ], ], 'RecurringCount' => [ 'base' => NULL, 'refs' => [ 'Problem$RecurringCount' => NULL, ], ], 'RelatedObservations' => [ 'base' => '<p>Describes observations related to the problem.</p>', 'refs' => [ 'DescribeProblemObservationsResponse$RelatedObservations' => '<p>Observations related to the problem.</p>', ], ], 'Remarks' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponent$ComponentRemarks' => '<p> If logging is supported for the resource type, indicates whether the component has configured logs to be monitored. </p>', 'ApplicationInfo$Remarks' => '<p>The issues on the user side that block Application Insights from successfully monitoring an application. Example remarks include:</p> <ul> <li> <p>“Configuring application, detected 1 Errors, 3 Warnings”</p> </li> <li> <p>“Configuring application, detected 1 Unconfigured Components”</p> </li> </ul>', ], ], 'RemoveSNSTopic' => [ 'base' => NULL, 'refs' => [ 'UpdateApplicationRequest$RemoveSNSTopic' => '<p> Disassociates the SNS topic from the opsItem created for detected problems.</p>', ], ], 'ResourceARN' => [ 'base' => NULL, 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceGroupName' => [ 'base' => NULL, 'refs' => [ 'ApplicationInfo$ResourceGroupName' => '<p>The name of the resource group used for the application.</p>', 'CreateApplicationRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'CreateComponentRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'CreateLogPatternRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'CreateLogPatternResponse$ResourceGroupName' => '<p>The name of the resource group.</p>', 'DeleteApplicationRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'DeleteComponentRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'DeleteLogPatternRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'DescribeApplicationRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'DescribeComponentConfigurationRecommendationRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'DescribeComponentConfigurationRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'DescribeComponentRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'DescribeLogPatternRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'DescribeLogPatternResponse$ResourceGroupName' => '<p>The name of the resource group.</p>', 'ListComponentsRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'ListConfigurationHistoryRequest$ResourceGroupName' => '<p>Resource group to which the application belongs. </p>', 'ListLogPatternSetsRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'ListLogPatternSetsResponse$ResourceGroupName' => '<p>The name of the resource group.</p>', 'ListLogPatternsRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'ListLogPatternsResponse$ResourceGroupName' => '<p>The name of the resource group.</p>', 'ListProblemsRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'ListProblemsResponse$ResourceGroupName' => NULL, 'Problem$ResourceGroupName' => '<p>The name of the resource group affected by the problem.</p>', 'UpdateApplicationRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'UpdateComponentConfigurationRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'UpdateComponentRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'UpdateLogPatternRequest$ResourceGroupName' => '<p>The name of the resource group.</p>', 'UpdateLogPatternResponse$ResourceGroupName' => '<p>The name of the resource group.</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>The resource is already created or in use.</p>', 'refs' => [], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'CreateComponentRequest$ResourceList' => '<p>The list of resource ARNs that belong to the component.</p>', 'DescribeComponentResponse$ResourceList' => '<p>The list of resource ARNs that belong to the component.</p>', 'UpdateComponentRequest$ResourceList' => '<p>The list of resource ARNs that belong to the component.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource does not exist in the customer account.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponent$ResourceType' => '<p>The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB, Application ELB, and SQS Queue.</p>', ], ], 'S3EventName' => [ 'base' => NULL, 'refs' => [ 'Observation$S3EventName' => '<p> The name of the S3 CloudWatch Event-based observation. </p>', ], ], 'SeverityLevel' => [ 'base' => NULL, 'refs' => [ 'Problem$SeverityLevel' => '<p>A measure of the level of impact of the problem.</p>', ], ], 'SourceARN' => [ 'base' => NULL, 'refs' => [ 'Observation$SourceARN' => '<p>The source resource ARN of the observation.</p>', ], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'Observation$SourceType' => '<p>The source type of the observation.</p>', ], ], 'StartTime' => [ 'base' => NULL, 'refs' => [ 'ListConfigurationHistoryRequest$StartTime' => '<p>The start time of the event. </p>', 'ListProblemsRequest$StartTime' => '<p>The time when the problem was detected, in epoch seconds. If you don\'t specify a time frame for the request, problems within the past seven days are returned.</p>', 'Observation$StartTime' => '<p>The time when the observation was first detected, in epoch seconds.</p>', 'Problem$StartTime' => '<p>The time when the problem started, in epoch seconds.</p>', ], ], 'StatesArn' => [ 'base' => NULL, 'refs' => [ 'Observation$StatesArn' => '<p> The Amazon Resource Name (ARN) of the step function-based observation. </p>', ], ], 'StatesExecutionArn' => [ 'base' => NULL, 'refs' => [ 'Observation$StatesExecutionArn' => '<p> The Amazon Resource Name (ARN) of the step function execution-based observation. </p>', ], ], 'StatesInput' => [ 'base' => NULL, 'refs' => [ 'Observation$StatesInput' => '<p> The input to the step function-based observation. </p>', ], ], 'StatesStatus' => [ 'base' => NULL, 'refs' => [ 'Observation$StatesStatus' => '<p> The status of the step function-related observation. </p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'Problem$Status' => '<p>The status of the problem.</p>', ], ], 'Tag' => [ 'base' => '<p>An object that defines the tags associated with an application. A <i>tag</i> is a label that you optionally define and associate with an application. Tags can help you categorize and manage resources in different ways, such as by purpose, owner, environment, or other criteria.</p> <p>Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A tag key is a general label that acts as a category for a more specific tag value. A tag value acts as a descriptor within a tag key. A tag key can contain as many as 128 characters. A tag value can contain as many as 256 characters. The characters can be Unicode letters, digits, white space, or one of the following symbols: _ . : / = + -. The following additional restrictions apply to tags:</p> <ul> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>For each associated resource, each tag key must be unique and it can have only one value.</p> </li> <li> <p>The <code>aws:</code> prefix is reserved for use by AWS; you can’t use it in any tag keys or values that you define. In addition, you can\'t edit or remove tag keys or values that use this prefix. </p> </li> </ul>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>One part of a key-value pair that defines a tag. The maximum length of a tag key is 128 characters. The minimum length is 1 character.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p> <p>To remove more than one tag from the application, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationRequest$Tags' => '<p>List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>', 'ListTagsForResourceResponse$Tags' => '<p>An array that lists all the tags that are associated with the application. Each tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>).</p>', 'TagResourceRequest$Tags' => '<p>A list of tags that to add to the application. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The optional part of a key-value pair that defines a tag. The maximum length of a tag value is 256 characters. The minimum length is 0 characters. If you don\'t want an application to have a specific tag value, don\'t specify a value for this parameter.</p>', ], ], 'TagsAlreadyExistException' => [ 'base' => '<p>Tags are already registered for the specified application ARN.</p>', 'refs' => [], ], 'Tier' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponent$Tier' => '<p>The stack tier of the application component.</p>', 'DescribeComponentConfigurationRecommendationRequest$Tier' => '<p>The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.</p>', 'DescribeComponentConfigurationResponse$Tier' => '<p>The tier of the application component. Supported tiers include <code>DOT_NET_CORE</code>, <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code> </p>', 'DetectedWorkload$key' => NULL, 'UpdateComponentConfigurationRequest$Tier' => '<p>The tier of the application component. Supported tiers include <code>DOT_NET_WORKER</code>, <code>DOT_NET_WEB</code>, <code>DOT_NET_CORE</code>, <code>SQL_SERVER</code>, and <code>DEFAULT</code>.</p>', ], ], 'Title' => [ 'base' => NULL, 'refs' => [ 'Problem$Title' => '<p>The name of the problem.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>The number of the provided tags is beyond the limit, or the number of total tags you are trying to attach to the specified resource exceeds the limit.</p>', 'refs' => [], ], 'Unit' => [ 'base' => NULL, 'refs' => [ 'Observation$Unit' => '<p>The unit of the source observation metric.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComponentConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComponentConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLogPatternRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLogPatternResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The parameter is not valid.</p>', 'refs' => [], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'Observation$Value' => '<p>The value of the source observation metric.</p>', ], ], 'WorkloadMetaData' => [ 'base' => NULL, 'refs' => [ 'DetectedWorkload$value' => NULL, ], ], 'XRayErrorPercent' => [ 'base' => NULL, 'refs' => [ 'Observation$XRayErrorPercent' => '<p> The X-Ray request error percentage for this node. </p>', ], ], 'XRayFaultPercent' => [ 'base' => NULL, 'refs' => [ 'Observation$XRayFaultPercent' => '<p> The X-Ray request fault percentage for this node. </p>', ], ], 'XRayNodeName' => [ 'base' => NULL, 'refs' => [ 'Observation$XRayNodeName' => '<p> The name of the X-Ray node. </p>', ], ], 'XRayNodeType' => [ 'base' => NULL, 'refs' => [ 'Observation$XRayNodeType' => '<p> The type of the X-Ray node. </p>', ], ], 'XRayRequestAverageLatency' => [ 'base' => NULL, 'refs' => [ 'Observation$XRayRequestAverageLatency' => '<p> The X-Ray node request average latency for this node. </p>', ], ], 'XRayRequestCount' => [ 'base' => NULL, 'refs' => [ 'Observation$XRayRequestCount' => '<p> The X-Ray request count for this node. </p>', ], ], 'XRayThrottlePercent' => [ 'base' => NULL, 'refs' => [ 'Observation$XRayThrottlePercent' => '<p> The X-Ray request throttle percentage for this node. </p>', ], ], ],];
