<?php
// This file was auto-generated from sdk-root/src/data/chime/2018-05-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The Amazon Chime API (application programming interface) is designed for developers to perform key tasks, such as creating and managing Amazon Chime accounts, users, and Voice Connectors. This guide provides detailed information about the Amazon Chime API, including operations, types, inputs and outputs, and error codes. It also includes API actions for use with the Amazon Chime SDK, which developers use to build their own communication applications. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html"> Using the Amazon Chime SDK </a> in the <i>Amazon Chime Developer Guide</i>.</p> <p>You can use an AWS SDK, the AWS Command Line Interface (AWS CLI), or the REST API to make API calls. We recommend using an AWS SDK or the AWS CLI. Each API operation includes links to information about using it with a language-specific AWS SDK or the AWS CLI.</p> <dl> <dt>Using an AWS SDK</dt> <dd> <p> You don\'t need to write code to calculate a signature for request authentication. The SDK clients authenticate your requests by using access keys that you provide. For more information about AWS SDKs, see the <a href="http://aws.amazon.com/developer/">AWS Developer Center</a>. </p> </dd> <dt>Using the AWS CLI</dt> <dd> <p>Use your access keys with the AWS CLI to make API calls. For information about setting up the AWS CLI, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/installing.html">Installing the AWS Command Line Interface</a> in the <i>AWS Command Line Interface User Guide</i>. For a list of available Amazon Chime commands, see the <a href="https://docs.aws.amazon.com/cli/latest/reference/chime/index.html">Amazon Chime commands</a> in the <i>AWS CLI Command Reference</i>. </p> </dd> <dt>Using REST APIs</dt> <dd> <p>If you use REST to make API calls, you must authenticate your request by providing a signature. Amazon Chime supports signature version 4. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a> in the <i>Amazon Web Services General Reference</i>.</p> <p>When making REST API calls, use the service name <code>chime</code> and REST endpoint <code>https://service.chime.aws.amazon.com</code>.</p> </dd> </dl> <p>Administrative permissions are controlled using AWS Identity and Access Management (IAM). For more information, see <a href="https://docs.aws.amazon.com/chime/latest/ag/security-iam.html">Identity and Access Management for Amazon Chime</a> in the <i>Amazon Chime Administration Guide</i>.</p>', 'operations' => [ 'AssociatePhoneNumberWithUser' => '<p>Associates a phone number with the specified Amazon Chime user.</p>', 'AssociatePhoneNumbersWithVoiceConnector' => '<p>Associates phone numbers with the specified Amazon Chime Voice Connector.</p>', 'AssociatePhoneNumbersWithVoiceConnectorGroup' => '<p>Associates phone numbers with the specified Amazon Chime Voice Connector group.</p>', 'AssociateSigninDelegateGroupsWithAccount' => '<p>Associates the specified sign-in delegate groups with the specified Amazon Chime account.</p>', 'BatchCreateAttendee' => '<p> Creates up to 100 new attendees for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>', 'BatchCreateChannelMembership' => '<p>Adds a specified number of users to a channel.</p>', 'BatchCreateRoomMembership' => '<p>Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be users or bots. The member role designates whether the member is a chat room administrator or a general chat room member.</p>', 'BatchDeletePhoneNumber' => '<p> Moves phone numbers into the <b>Deletion queue</b>. Phone numbers must be disassociated from any users or Amazon Chime Voice Connectors before they can be deleted. </p> <p> Phone numbers remain in the <b>Deletion queue</b> for 7 days before they are deleted permanently. </p>', 'BatchSuspendUser' => '<p>Suspends up to 50 users from a <code>Team</code> or <code>EnterpriseLWA</code> Amazon Chime account. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration Guide</i>.</p> <p>Users suspended from a <code>Team</code> account are disassociated from the account,but they can continue to use Amazon Chime as free users. To remove the suspension from suspended <code>Team</code> account users, invite them to the <code>Team</code> account again. You can use the <a>InviteUsers</a> action to do so.</p> <p>Users suspended from an <code>EnterpriseLWA</code> account are immediately signed out of Amazon Chime and can no longer sign in. To remove the suspension from suspended <code>EnterpriseLWA</code> account users, use the <a>BatchUnsuspendUser</a> action.</p> <p> To sign out users without suspending them, use the <a>LogoutUser</a> action. </p>', 'BatchUnsuspendUser' => '<p>Removes the suspension from up to 50 previously suspended users for the specified Amazon Chime <code>EnterpriseLWA</code> account. Only users on <code>EnterpriseLWA</code> accounts can be unsuspended using this action. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html"> Managing Your Amazon Chime Accounts </a> in the account types, in the <i>Amazon Chime Administration Guide</i>. </p> <p> Previously suspended users who are unsuspended using this action are returned to <code>Registered</code> status. Users who are not previously suspended are ignored. </p>', 'BatchUpdatePhoneNumber' => '<p>Updates phone number product types or calling names. You can update one attribute at a time for each <code>UpdatePhoneNumberRequestItem</code>. For example, you can update the product type or the calling name.</p> <p>For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.</p> <p>Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.</p>', 'BatchUpdateUser' => '<p>Updates user details within the <a>UpdateUserRequestItem</a> object for up to 20 users for the specified Amazon Chime account. Currently, only <code>LicenseType</code> updates are supported for this action.</p>', 'CreateAccount' => '<p>Creates an Amazon Chime account under the administrator\'s AWS account. Only <code>Team</code> account types are currently supported for this action. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration Guide</i>.</p>', 'CreateAppInstance' => '<p>Creates an Amazon Chime SDK messaging <code>AppInstance</code> under an AWS account. Only SDK messaging customers use this API. <code>CreateAppInstance</code> supports idempotency behavior as described in the AWS API Standard.</p>', 'CreateAppInstanceAdmin' => '<p>Promotes an <code>AppInstanceUser</code> to an <code>AppInstanceAdmin</code>. The promoted user can perform the following actions. </p> <ul> <li> <p> <code>ChannelModerator</code> actions across all channels in the <code>AppInstance</code>.</p> </li> <li> <p> <code>DeleteChannelMessage</code> actions.</p> </li> </ul> <p>Only an <code>AppInstanceUser</code> can be promoted to an <code>AppInstanceAdmin</code> role.</p>', 'CreateAppInstanceUser' => '<p>Creates a user under an Amazon Chime <code>AppInstance</code>. The request consists of a unique <code>appInstanceUserId</code> and <code>Name</code> for that user.</p>', 'CreateAttendee' => '<p> Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>', 'CreateBot' => '<p>Creates a bot for an Amazon Chime Enterprise account.</p>', 'CreateChannel' => '<p>Creates a channel to which you can add users and send messages.</p> <p> <b>Restriction</b>: You can\'t change a channel\'s privacy.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'CreateChannelBan' => '<p>Permanently bans a member from a channel. Moderators can\'t add banned members to a channel. To undo a ban, you first have to <code>DeleteChannelBan</code>, and then <code>CreateChannelMembership</code>. Bans are cleaned up when you delete users or channels.</p> <p>If you ban a user who is already part of a channel, that user is automatically kicked from the channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'CreateChannelMembership' => '<p>Adds a user to a channel. The <code>InvitedBy</code> response field is derived from the request header. A channel member can:</p> <ul> <li> <p>List messages</p> </li> <li> <p>Send messages</p> </li> <li> <p>Receive messages</p> </li> <li> <p>Edit their own messages</p> </li> <li> <p>Leave the channel</p> </li> </ul> <p>Privacy settings impact this action as follows:</p> <ul> <li> <p>Public Channels: You do not need to be a member to list messages, but you must be a member to send messages.</p> </li> <li> <p>Private Channels: You must be a member to list or send messages.</p> </li> </ul> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'CreateChannelModerator' => '<p>Creates a new <code>ChannelModerator</code>. A channel moderator can:</p> <ul> <li> <p>Add and remove other members of the channel.</p> </li> <li> <p>Add and remove other moderators of the channel.</p> </li> <li> <p>Add and remove user bans for the channel.</p> </li> <li> <p>Redact messages in the channel.</p> </li> <li> <p>List messages in the channel.</p> </li> </ul> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'CreateMediaCapturePipeline' => '<p>Creates a media capture pipeline.</p>', 'CreateMeeting' => '<p> Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more information about specifying media Regions, see <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions</a> in the <i>Amazon Chime Developer Guide</i> . For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i> . </p>', 'CreateMeetingDialOut' => '<p>Uses the join token and call metadata in a meeting request (From number, To number, and so forth) to initiate an outbound call to a public switched telephone network (PSTN) and join them into a Chime meeting. Also ensures that the From number belongs to the customer.</p> <p>To play welcome audio or implement an interactive voice response (IVR), use the <code>CreateSipMediaApplicationCall</code> action with the corresponding SIP media application ID.</p>', 'CreateMeetingWithAttendees' => '<p> Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For more information about specifying media Regions, see <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions</a> in the <i>Amazon Chime Developer Guide</i> . For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i> . </p>', 'CreatePhoneNumberOrder' => '<p>Creates an order for phone numbers to be provisioned. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.</p>', 'CreateProxySession' => '<p>Creates a proxy session on the specified Amazon Chime Voice Connector for the specified participant phone numbers.</p>', 'CreateRoom' => '<p>Creates a chat room for the specified Amazon Chime Enterprise account.</p>', 'CreateRoomMembership' => '<p>Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The member role designates whether the member is a chat room administrator or a general chat room member.</p>', 'CreateSipMediaApplication' => '<p>Creates a SIP media application.</p>', 'CreateSipMediaApplicationCall' => '<p>Creates an outbound call to a phone number from the phone number specified in the request, and it invokes the endpoint of the specified <code>sipMediaApplicationId</code>.</p>', 'CreateSipRule' => '<p>Creates a SIP rule which can be used to run a SIP media application as a target for a specific trigger type.</p>', 'CreateUser' => '<p>Creates a user under the specified Amazon Chime account.</p>', 'CreateVoiceConnector' => '<p>Creates an Amazon Chime Voice Connector under the administrator\'s AWS account. You can choose to create an Amazon Chime Voice Connector in a specific AWS Region.</p> <p> Enabling <a>CreateVoiceConnectorRequest$RequireEncryption</a> configures your Amazon Chime Voice Connector to use TLS transport for SIP signaling and Secure RTP (SRTP) for media. Inbound calls use TLS transport, and unencrypted outbound calls are blocked. </p>', 'CreateVoiceConnectorGroup' => '<p>Creates an Amazon Chime Voice Connector group under the administrator\'s AWS account. You can associate Amazon Chime Voice Connectors with the Amazon Chime Voice Connector group by including <code>VoiceConnectorItems</code> in the request.</p> <p>You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault tolerant mechanism for fallback in case of availability events.</p>', 'DeleteAccount' => '<p>Deletes the specified Amazon Chime account. You must suspend all users before deleting <code>Team</code> account. You can use the <a>BatchSuspendUser</a> action to dodo.</p> <p>For <code>EnterpriseLWA</code> and <code>EnterpriseAD</code> accounts, you must release the claimed domains for your Amazon Chime account before deletion. As soon as you release the domain, all users under that account are suspended.</p> <p>Deleted accounts appear in your <code>Disabled</code> accounts list for 90 days. To restore deleted account from your <code>Disabled</code> accounts list, you must contact AWS Support.</p> <p>After 90 days, deleted accounts are permanently removed from your <code>Disabled</code> accounts list.</p>', 'DeleteAppInstance' => '<p>Deletes an <code>AppInstance</code> and all associated data asynchronously.</p>', 'DeleteAppInstanceAdmin' => '<p>Demotes an <code>AppInstanceAdmin</code> to an <code>AppInstanceUser</code>. This action does not delete the user.</p>', 'DeleteAppInstanceStreamingConfigurations' => '<p>Deletes the streaming configurations of an <code>AppInstance</code>.</p>', 'DeleteAppInstanceUser' => '<p>Deletes an <code>AppInstanceUser</code>.</p>', 'DeleteAttendee' => '<p>Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their <code>JoinToken</code>. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>', 'DeleteChannel' => '<p>Immediately makes a channel and its memberships inaccessible and marks them for deletion. This is an irreversible process.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DeleteChannelBan' => '<p>Removes a user from a channel\'s ban list.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DeleteChannelMembership' => '<p>Removes a member from a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DeleteChannelMessage' => '<p>Deletes a channel message. Only admins can perform this action. Deletion makes messages inaccessible immediately. A background process deletes any revisions created by <code>UpdateChannelMessage</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DeleteChannelModerator' => '<p>Deletes a channel moderator.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DeleteEventsConfiguration' => '<p>Deletes the events configuration that allows a bot to receive outgoing events.</p>', 'DeleteMediaCapturePipeline' => '<p>Deletes the media capture pipeline.</p>', 'DeleteMeeting' => '<p>Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees, disconnects all clients, and prevents new clients from joining the meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>', 'DeletePhoneNumber' => '<p>Moves the specified phone number into the <b>Deletion queue</b>. A phone number must be disassociated from any users or Amazon Chime Voice Connectors before it can be deleted.</p> <p>Deleted phone numbers remain in the <b>Deletion queue</b> for 7 days before they are deleted permanently.</p>', 'DeleteProxySession' => '<p>Deletes the specified proxy session from the specified Amazon Chime Voice Connector.</p>', 'DeleteRoom' => '<p>Deletes a chat room in an Amazon Chime Enterprise account.</p>', 'DeleteRoomMembership' => '<p>Removes a member from a chat room in an Amazon Chime Enterprise account.</p>', 'DeleteSipMediaApplication' => '<p>Deletes a SIP media application.</p>', 'DeleteSipRule' => '<p>Deletes a SIP rule. You must disable a SIP rule before you can delete it.</p>', 'DeleteVoiceConnector' => '<p>Deletes the specified Amazon Chime Voice Connector. Any phone numbers associated with the Amazon Chime Voice Connector must be disassociated from it before it can be deleted.</p>', 'DeleteVoiceConnectorEmergencyCallingConfiguration' => '<p>Deletes the emergency calling configuration details from the specified Amazon Chime Voice Connector.</p>', 'DeleteVoiceConnectorGroup' => '<p>Deletes the specified Amazon Chime Voice Connector group. Any <code>VoiceConnectorItems</code> and phone numbers associated with the group must be removed before it can be deleted.</p>', 'DeleteVoiceConnectorOrigination' => '<p>Deletes the origination settings for the specified Amazon Chime Voice Connector.</p> <note> <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the origination settings.</p> </note>', 'DeleteVoiceConnectorProxy' => '<p>Deletes the proxy configuration from the specified Amazon Chime Voice Connector.</p>', 'DeleteVoiceConnectorStreamingConfiguration' => '<p>Deletes the streaming configuration for the specified Amazon Chime Voice Connector.</p>', 'DeleteVoiceConnectorTermination' => '<p>Deletes the termination settings for the specified Amazon Chime Voice Connector.</p> <note> <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the termination settings.</p> </note>', 'DeleteVoiceConnectorTerminationCredentials' => '<p>Deletes the specified SIP credentials used by your equipment to authenticate during call termination.</p>', 'DescribeAppInstance' => '<p>Returns the full details of an <code>AppInstance</code>.</p>', 'DescribeAppInstanceAdmin' => '<p>Returns the full details of an <code>AppInstanceAdmin</code>.</p>', 'DescribeAppInstanceUser' => '<p>Returns the full details of an <code>AppInstanceUser</code>.</p>', 'DescribeChannel' => '<p>Returns the full details of a channel in an Amazon Chime <code>AppInstance</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DescribeChannelBan' => '<p>Returns the full details of a channel ban.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DescribeChannelMembership' => '<p>Returns the full details of a user\'s channel membership.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DescribeChannelMembershipForAppInstanceUser' => '<p> Returns the details of a channel based on the membership of the specified <code>AppInstanceUser</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DescribeChannelModeratedByAppInstanceUser' => '<p>Returns the full details of a channel moderated by the specified <code>AppInstanceUser</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DescribeChannelModerator' => '<p>Returns the full details of a single ChannelModerator.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DisassociatePhoneNumberFromUser' => '<p>Disassociates the primary provisioned phone number from the specified Amazon Chime user.</p>', 'DisassociatePhoneNumbersFromVoiceConnector' => '<p>Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector.</p>', 'DisassociatePhoneNumbersFromVoiceConnectorGroup' => '<p>Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector group.</p>', 'DisassociateSigninDelegateGroupsFromAccount' => '<p>Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.</p>', 'GetAccount' => '<p>Retrieves details for the specified Amazon Chime account, such as account type and supported licenses.</p>', 'GetAccountSettings' => '<p>Retrieves account settings for the specified Amazon Chime account ID, such as remote control and dialout settings. For more information about these settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the <i>Amazon Chime Administration Guide</i>. </p>', 'GetAppInstanceRetentionSettings' => '<p>Gets the retention settings for an <code>AppInstance</code>.</p>', 'GetAppInstanceStreamingConfigurations' => '<p>Gets the streaming settings for an <code>AppInstance</code>.</p>', 'GetAttendee' => '<p> Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i> . </p>', 'GetBot' => '<p>Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.</p>', 'GetChannelMessage' => '<p>Gets the full details of a channel message.</p> <note> <p>The x-amz-chime-bearer request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'GetEventsConfiguration' => '<p>Gets details for an events configuration that allows a bot to receive outgoing events, such as an HTTPS endpoint or Lambda function ARN.</p>', 'GetGlobalSettings' => '<p>Retrieves global settings for the administrator\'s AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.</p>', 'GetMediaCapturePipeline' => '<p>Gets an existing media capture pipeline.</p>', 'GetMeeting' => '<p> Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i> . </p>', 'GetMessagingSessionEndpoint' => '<p>The details of the endpoint for the messaging session.</p>', 'GetPhoneNumber' => '<p>Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.</p>', 'GetPhoneNumberOrder' => '<p>Retrieves details for the specified phone number order, such as the order creation timestamp, phone numbers in E.164 format, product type, and order status.</p>', 'GetPhoneNumberSettings' => '<p>Retrieves the phone number settings for the administrator\'s AWS account, such as the default outbound calling name.</p>', 'GetProxySession' => '<p>Gets the specified proxy session details for the specified Amazon Chime Voice Connector.</p>', 'GetRetentionSettings' => '<p> Gets the retention settings for the specified Amazon Chime Enterprise account. For more information about retention settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat Retention Policies</a> in the <i>Amazon Chime Administration Guide</i>. </p>', 'GetRoom' => '<p>Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.</p>', 'GetSipMediaApplication' => '<p>Retrieves the information for a SIP media application, including name, AWS Region, and endpoints.</p>', 'GetSipMediaApplicationLoggingConfiguration' => '<p>Returns the logging configuration for the specified SIP media application.</p>', 'GetSipRule' => '<p>Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target endpoints.</p>', 'GetUser' => '<p>Retrieves details for the specified user ID, such as primary email address, license type,and personal meeting PIN.</p> <p> To retrieve user details with an email address instead of a user ID, use the <a>ListUsers</a> action, and then filter by email address. </p>', 'GetUserSettings' => '<p>Retrieves settings for the specified user ID, such as any associated phone number settings.</p>', 'GetVoiceConnector' => '<p>Retrieves details for the specified Amazon Chime Voice Connector, such as timestamps,name, outbound host, and encryption requirements.</p>', 'GetVoiceConnectorEmergencyCallingConfiguration' => '<p>Gets the emergency calling configuration details for the specified Amazon Chime Voice Connector.</p>', 'GetVoiceConnectorGroup' => '<p> Retrieves details for the specified Amazon Chime Voice Connector group, such as timestamps,name, and associated <code>VoiceConnectorItems</code>.</p>', 'GetVoiceConnectorLoggingConfiguration' => '<p>Retrieves the logging configuration details for the specified Amazon Chime Voice Connector. Shows whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.</p>', 'GetVoiceConnectorOrigination' => '<p>Retrieves origination setting details for the specified Amazon Chime Voice Connector.</p>', 'GetVoiceConnectorProxy' => '<p>Gets the proxy configuration details for the specified Amazon Chime Voice Connector.</p>', 'GetVoiceConnectorStreamingConfiguration' => '<p>Retrieves the streaming configuration details for the specified Amazon Chime Voice Connector. Shows whether media streaming is enabled for sending to Amazon Kinesis. It also shows the retention period, in hours, for the Amazon Kinesis data.</p>', 'GetVoiceConnectorTermination' => '<p>Retrieves termination setting details for the specified Amazon Chime Voice Connector.</p>', 'GetVoiceConnectorTerminationHealth' => '<p>Retrieves information about the last time a SIP <code>OPTIONS</code> ping was received from your SIP infrastructure for the specified Amazon Chime Voice Connector.</p>', 'InviteUsers' => '<p>Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime <code>Team</code> account. Only <code>Team</code> account types are currently supported for this action.</p>', 'ListAccounts' => '<p>Lists the Amazon Chime accounts under the administrator\'s AWS account. You can filter accounts by account name prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user\'s email address, which returns one account result.</p>', 'ListAppInstanceAdmins' => '<p>Returns a list of the administrators in the <code>AppInstance</code>.</p>', 'ListAppInstanceUsers' => '<p>List all <code>AppInstanceUsers</code> created under a single <code>AppInstance</code>. </p>', 'ListAppInstances' => '<p>Lists all Amazon Chime <code>AppInstance</code>s created under a single AWS account.</p>', 'ListAttendeeTags' => '<p>Lists the tags applied to an Amazon Chime SDK attendee resource.</p>', 'ListAttendees' => '<p> Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>. </p>', 'ListBots' => '<p>Lists the bots associated with the administrator\'s Amazon Chime Enterprise account ID.</p>', 'ListChannelBans' => '<p>Lists all the users banned from a particular channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'ListChannelMemberships' => '<p>Lists all channel memberships in a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'ListChannelMembershipsForAppInstanceUser' => '<p> Lists all channels that a particular <code>AppInstanceUser</code> is a part of. Only an <code>AppInstanceAdmin</code> can call the API with a user ARN that is not their own. </p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'ListChannelMessages' => '<p>List all the messages in a channel. Returns a paginated list of <code>ChannelMessages</code>. By default, sorted by creation timestamp in descending order.</p> <note> <p>Redacted messages appear in the results as empty, since they are only redacted, not deleted. Deleted messages do not appear in the results. This action always returns the latest version of an edited message.</p> <p>Also, the x-amz-chime-bearer request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'ListChannelModerators' => '<p>Lists all the moderators for a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'ListChannels' => '<p>Lists all Channels created under a single Chime App as a paginated list. You can specify filters to narrow results.</p> <p class="title"> <b>Functionality &amp; restrictions</b> </p> <ul> <li> <p>Use privacy = <code>PUBLIC</code> to retrieve all public channels in the account.</p> </li> <li> <p>Only an <code>AppInstanceAdmin</code> can set privacy = <code>PRIVATE</code> to list the private channels in an account.</p> </li> </ul> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'ListChannelsModeratedByAppInstanceUser' => '<p>A list of the channels moderated by an <code>AppInstanceUser</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'ListMediaCapturePipelines' => '<p>Returns a list of media capture pipelines.</p>', 'ListMeetingTags' => '<p>Lists the tags applied to an Amazon Chime SDK meeting resource.</p>', 'ListMeetings' => '<p> Lists up to 100 active Amazon Chime SDK meetings. For more information about the Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK</a> in the <i>Amazon Chime Developer Guide</i>.</p>', 'ListPhoneNumberOrders' => '<p>Lists the phone number orders for the administrator\'s Amazon Chime account.</p>', 'ListPhoneNumbers' => '<p>Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.</p>', 'ListProxySessions' => '<p>Lists the proxy sessions for the specified Amazon Chime Voice Connector.</p>', 'ListRoomMemberships' => '<p>Lists the membership details for the specified room in an Amazon Chime Enterprise account, such as the members\' IDs, email addresses, and names.</p>', 'ListRooms' => '<p>Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a member ID (user ID or bot ID) to see a list of rooms that the member belongs to.</p>', 'ListSipMediaApplications' => '<p>Lists the SIP media applications under the administrator\'s AWS account.</p>', 'ListSipRules' => '<p>Lists the SIP rules under the administrator\'s AWS account.</p>', 'ListSupportedPhoneNumberCountries' => '<p>Lists supported phone number countries.</p>', 'ListTagsForResource' => '<p>Lists the tags applied to an Amazon Chime SDK meeting resource.</p>', 'ListUsers' => '<p>Lists the users that belong to the specified Amazon Chime account. You can specify an email address to list only the user that the email address belongs to.</p>', 'ListVoiceConnectorGroups' => '<p>Lists the Amazon Chime Voice Connector groups for the administrator\'s AWS account.</p>', 'ListVoiceConnectorTerminationCredentials' => '<p>Lists the SIP credentials for the specified Amazon Chime Voice Connector.</p>', 'ListVoiceConnectors' => '<p>Lists the Amazon Chime Voice Connectors for the administrator\'s AWS account.</p>', 'LogoutUser' => '<p>Logs out the specified user from all of the devices they are currently logged into.</p>', 'PutAppInstanceRetentionSettings' => '<p>Sets the amount of time in days that a given <code>AppInstance</code> retains data.</p>', 'PutAppInstanceStreamingConfigurations' => '<p>The data streaming configurations of an <code>AppInstance</code>.</p>', 'PutEventsConfiguration' => '<p>Creates an events configuration that allows a bot to receive outgoing events sent by Amazon Chime. Choose either an HTTPS endpoint or a Lambda function ARN. For more information, see <a>Bot</a>.</p>', 'PutRetentionSettings' => '<p> Puts retention settings for the specified Amazon Chime Enterprise account. We recommend using AWS CloudTrail to monitor usage of this API for your account. For more information, see <a href="https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html">Logging Amazon Chime API Calls with AWS CloudTrail</a> in the <i>Amazon Chime Administration Guide</i>.</p> <p> To turn off existing retention settings, remove the number of days from the corresponding <b>RetentionDays</b> field in the <b>RetentionSettings</b> object. For more information about retention settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat Retention Policies</a> in the <i>Amazon Chime Administration Guide</i>.</p>', 'PutSipMediaApplicationLoggingConfiguration' => '<p>Updates the logging configuration for the specified SIP media application.</p>', 'PutVoiceConnectorEmergencyCallingConfiguration' => '<p>Puts emergency calling configuration details to the specified Amazon Chime Voice Connector, such as emergency phone numbers and calling countries. Origination and termination settings must be enabled for the Amazon Chime Voice Connector before emergency calling can be configured.</p>', 'PutVoiceConnectorLoggingConfiguration' => '<p>Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.</p>', 'PutVoiceConnectorOrigination' => '<p>Adds origination settings for the specified Amazon Chime Voice Connector.</p> <note> <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off origination settings.</p> </note>', 'PutVoiceConnectorProxy' => '<p>Puts the specified proxy configuration to the specified Amazon Chime Voice Connector.</p>', 'PutVoiceConnectorStreamingConfiguration' => '<p>Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming configuration specifies whether media streaming is enabled for sending to Indonesians. It also sets the retention period, in hours, for the Amazon Kinesis data.</p>', 'PutVoiceConnectorTermination' => '<p>Adds termination settings for the specified Amazon Chime Voice Connector.</p> <note> <p>If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off termination settings.</p> </note>', 'PutVoiceConnectorTerminationCredentials' => '<p>Adds termination SIP credentials for the specified Amazon Chime Voice Connector.</p>', 'RedactChannelMessage' => '<p>Redacts message content, but not metadata. The message exists in the back end, but the action returns null content, and the state shows as redacted.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'RedactConversationMessage' => '<p>Redacts the specified message from the specified Amazon Chime conversation.</p>', 'RedactRoomMessage' => '<p>Redacts the specified message from the specified Amazon Chime channel.</p>', 'RegenerateSecurityToken' => '<p>Regenerates the security token for a bot.</p>', 'ResetPersonalPIN' => '<p>Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns the <a>User</a> object with the updated personal meeting PIN.</p>', 'RestorePhoneNumber' => '<p>Moves a phone number from the <b>Deletion queue</b> back into the phone number <b>Inventory</b>.</p>', 'SearchAvailablePhoneNumbers' => '<p>Searches for phone numbers that can be ordered. For US numbers, provide at least one of the following search filters: <code>AreaCode</code>, <code>City</code>, <code>State</code>, or <code>TollFreePrefix</code>. If you provide <code>City</code>, you must also provide <code>State</code>. Numbers outside the US only support the <code>PhoneNumberType</code> filter, which you must use.</p>', 'SendChannelMessage' => '<p>Sends a message to a particular channel that the member is a part of.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> <p>Also, <code>STANDARD</code> messages can contain 4KB of data and the 1KB of metadata. <code>CONTROL</code> messages can contain 30 bytes of data and no metadata.</p> </note>', 'StartMeetingTranscription' => '<p>Starts transcription for the specified <code>meetingId</code>. </p>', 'StopMeetingTranscription' => '<p>Stops transcription for the specified <code>meetingId</code>.</p>', 'TagAttendee' => '<p>Applies the specified tags to the specified Amazon Chime SDK attendee.</p>', 'TagMeeting' => '<p>Applies the specified tags to the specified Amazon Chime SDK meeting.</p>', 'TagResource' => '<p>Applies the specified tags to the specified Amazon Chime SDK meeting resource.</p>', 'UntagAttendee' => '<p>Untags the specified tags from the specified Amazon Chime SDK attendee.</p>', 'UntagMeeting' => '<p>Untags the specified tags from the specified Amazon Chime SDK meeting.</p>', 'UntagResource' => '<p>Untags the specified tags from the specified Amazon Chime SDK meeting resource.</p>', 'UpdateAccount' => '<p>Updates account details for the specified Amazon Chime account. Currently, only account name and default license updates are supported for this action.</p>', 'UpdateAccountSettings' => '<p>Updates the settings for the specified Amazon Chime account. You can update settings for remote control of shared screens, or for the dial-out option. For more information about these settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the <i>Amazon Chime Administration Guide</i>.</p>', 'UpdateAppInstance' => '<p>Updates <code>AppInstance</code> metadata.</p>', 'UpdateAppInstanceUser' => '<p>Updates the details of an <code>AppInstanceUser</code>. You can update names and metadata.</p>', 'UpdateBot' => '<p>Updates the status of the specified bot, such as starting or stopping the bot from running in your Amazon Chime Enterprise account.</p>', 'UpdateChannel' => '<p>Update a channel\'s attributes.</p> <p> <b>Restriction</b>: You can\'t change a channel\'s privacy. </p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'UpdateChannelMessage' => '<p>Updates the content of a message.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'UpdateChannelReadMarker' => '<p>The details of the time when a user last read messages in a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'UpdateGlobalSettings' => '<p>Updates global settings for the administrator\'s AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.</p>', 'UpdatePhoneNumber' => '<p>Updates phone number details, such as product type or calling name, for the specified phone number ID. You can update one phone number detail at a time. For example, you can update either the product type or the calling name in one action.</p> <p>For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.</p> <p>Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.</p>', 'UpdatePhoneNumberSettings' => '<p>Updates the phone number settings for the administrator\'s AWS account, such as the default outbound calling name. You can update the default outbound calling name once every seven days. Outbound calling names can take up to 72 hours to update.</p>', 'UpdateProxySession' => '<p>Updates the specified proxy session details, such as voice or SMS capabilities.</p>', 'UpdateRoom' => '<p>Updates room details, such as the room name, for a room in an Amazon Chime Enterprise account.</p>', 'UpdateRoomMembership' => '<p>Updates room membership details, such as the member role, for a room in an Amazon Chime Enterprise account. The member role designates whether the member is a chat room administrator or a general chat room member. The member role can be updated only for user IDs.</p>', 'UpdateSipMediaApplication' => '<p>Updates the details of the specified SIP media application.</p>', 'UpdateSipMediaApplicationCall' => '<p>Allows you to trigger a Lambda function at any time while a call is active, and replace the current actions with new actions returned by the invocation.</p>', 'UpdateSipRule' => '<p>Updates the details of the specified SIP rule.</p>', 'UpdateUser' => '<p>Updates user details for a specified user ID. Currently, only <code>LicenseType</code> updates are supported for this action.</p>', 'UpdateUserSettings' => '<p>Updates the settings for the specified user, such as phone number settings.</p>', 'UpdateVoiceConnector' => '<p>Updates details for the specified Amazon Chime Voice Connector.</p>', 'UpdateVoiceConnectorGroup' => '<p>Updates details of the specified Amazon Chime Voice Connector group, such as the name and Amazon Chime Voice Connector priority ranking.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have permissions to perform the requested operation.</p>', 'refs' => [], ], 'Account' => [ 'base' => '<p>The Amazon Chime account details. An AWS account can have multiple Amazon Chime accounts.</p>', 'refs' => [ 'AccountList$member' => NULL, 'CreateAccountResponse$Account' => '<p>The Amazon Chime account details.</p>', 'GetAccountResponse$Account' => '<p>The Amazon Chime account details.</p>', 'UpdateAccountResponse$Account' => '<p>The updated Amazon Chime account details.</p>', ], ], 'AccountList' => [ 'base' => NULL, 'refs' => [ 'ListAccountsResponse$Accounts' => '<p>List of Amazon Chime accounts and account details.</p>', ], ], 'AccountName' => [ 'base' => NULL, 'refs' => [ 'CreateAccountRequest$Name' => '<p>The name of the Amazon Chime account.</p>', 'ListAccountsRequest$Name' => '<p>Amazon Chime account name prefix with which to filter results.</p>', 'UpdateAccountRequest$Name' => '<p>The new name for the specified Amazon Chime account.</p>', ], ], 'AccountSettings' => [ 'base' => '<p>Settings related to the Amazon Chime account. This includes settings that start or stop remote control of shared screens, or start or stop the dial-out option in the Amazon Chime web application. For more information about these settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the <i>Amazon Chime Administration Guide</i>.</p>', 'refs' => [ 'GetAccountSettingsResponse$AccountSettings' => '<p>The Amazon Chime account settings.</p>', 'UpdateAccountSettingsRequest$AccountSettings' => '<p>The Amazon Chime account settings to update.</p>', ], ], 'AccountStatus' => [ 'base' => NULL, 'refs' => [ 'Account$AccountStatus' => '<p>The status of the account.</p>', ], ], 'AccountType' => [ 'base' => NULL, 'refs' => [ 'Account$AccountType' => '<p>The Amazon Chime account type. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts</a> in the <i>Amazon Chime Administration Guide</i>.</p>', ], ], 'AlexaForBusinessMetadata' => [ 'base' => '<p>The Alexa for Business metadata associated with an Amazon Chime user, used to integrate Alexa for Business with a device.</p>', 'refs' => [ 'UpdateUserRequest$AlexaForBusinessMetadata' => '<p>The Alexa for Business metadata.</p>', 'UpdateUserRequestItem$AlexaForBusinessMetadata' => '<p>The Alexa for Business metadata.</p>', 'User$AlexaForBusinessMetadata' => '<p>The Alexa for Business metadata.</p>', ], ], 'Alpha2CountryCode' => [ 'base' => NULL, 'refs' => [ 'DNISEmergencyCallingConfiguration$CallingCountry' => '<p>The country from which emergency calls are allowed, in ISO 3166-1 alpha-2 format.</p>', 'PhoneNumber$Country' => '<p>The phone number country. Format: ISO 3166-1 alpha-2.</p>', 'PhoneNumberCountry$CountryCode' => '<p>The phone number country code. Format: ISO 3166-1 alpha-2.</p>', 'SearchAvailablePhoneNumbersRequest$Country' => '<p>The country used to filter results. Defaults to the US Format: ISO 3166-1 alpha-2.</p>', ], ], 'AppInstance' => [ 'base' => '<p>The details of an <code>AppInstance</code>, an instance of an Amazon Chime SDK messaging application.</p>', 'refs' => [ 'DescribeAppInstanceResponse$AppInstance' => '<p>The ARN, metadata, created and last-updated timestamps, and the name of the <code>AppInstance</code>. All timestamps use epoch milliseconds.</p>', ], ], 'AppInstanceAdmin' => [ 'base' => '<p>The details of an <code>AppInstanceAdmin</code>.</p>', 'refs' => [ 'DescribeAppInstanceAdminResponse$AppInstanceAdmin' => '<p>The ARN and name of the <code>AppInstanceUser</code>, the ARN of the <code>AppInstance</code>, and the created and last-updated timestamps. All timestamps use epoch milliseconds.</p>', ], ], 'AppInstanceAdminList' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceAdminsResponse$AppInstanceAdmins' => '<p>The information for each administrator.</p>', ], ], 'AppInstanceAdminSummary' => [ 'base' => '<p>Summary of the details of an <code>AppInstanceAdmin</code>.</p>', 'refs' => [ 'AppInstanceAdminList$member' => NULL, ], ], 'AppInstanceDataType' => [ 'base' => NULL, 'refs' => [ 'AppInstanceStreamingConfiguration$AppInstanceDataType' => '<p>The type of data to be streamed.</p>', ], ], 'AppInstanceList' => [ 'base' => NULL, 'refs' => [ 'ListAppInstancesResponse$AppInstances' => '<p>The information for each <code>AppInstance</code>.</p>', ], ], 'AppInstanceRetentionSettings' => [ 'base' => '<p>The details of the data-retention settings for an <code>AppInstance</code>.</p>', 'refs' => [ 'GetAppInstanceRetentionSettingsResponse$AppInstanceRetentionSettings' => '<p>The retention settings for the <code>AppInstance</code>.</p>', 'PutAppInstanceRetentionSettingsRequest$AppInstanceRetentionSettings' => '<p>The time in days to retain data. Data type: number.</p>', 'PutAppInstanceRetentionSettingsResponse$AppInstanceRetentionSettings' => '<p>The time in days to retain data. Data type: number.</p>', ], ], 'AppInstanceStreamingConfiguration' => [ 'base' => '<p>The details of the streaming configuration of an <code>AppInstance</code>.</p>', 'refs' => [ 'AppInstanceStreamingConfigurationList$member' => NULL, ], ], 'AppInstanceStreamingConfigurationList' => [ 'base' => NULL, 'refs' => [ 'GetAppInstanceStreamingConfigurationsResponse$AppInstanceStreamingConfigurations' => '<p>The streaming settings.</p>', 'PutAppInstanceStreamingConfigurationsRequest$AppInstanceStreamingConfigurations' => '<p>The streaming configurations set for an <code>AppInstance</code>.</p>', 'PutAppInstanceStreamingConfigurationsResponse$AppInstanceStreamingConfigurations' => '<p>The streaming configurations of an <code>AppInstance</code>.</p>', ], ], 'AppInstanceSummary' => [ 'base' => '<p>Summary of the data for an <code>AppInstance</code>.</p>', 'refs' => [ 'AppInstanceList$member' => NULL, ], ], 'AppInstanceUser' => [ 'base' => '<p>The details of an <code>AppInstanceUser</code>.</p>', 'refs' => [ 'DescribeAppInstanceUserResponse$AppInstanceUser' => '<p>The name of the <code>AppInstanceUser</code>.</p>', ], ], 'AppInstanceUserList' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceUsersResponse$AppInstanceUsers' => '<p>The information for each requested <code>AppInstanceUser</code>.</p>', ], ], 'AppInstanceUserMembershipSummary' => [ 'base' => '<p>Summary of the membership details of an <code>AppInstanceUser</code>.</p>', 'refs' => [ 'ChannelMembershipForAppInstanceUserSummary$AppInstanceUserMembershipSummary' => NULL, ], ], 'AppInstanceUserSummary' => [ 'base' => '<p>Summary of the details of an <code>AppInstanceUser</code>.</p>', 'refs' => [ 'AppInstanceUserList$member' => NULL, ], ], 'AreaCode' => [ 'base' => NULL, 'refs' => [ 'GeoMatchParams$AreaCode' => '<p>The area code.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AppInstanceStreamingConfiguration$ResourceArn' => '<p>The resource ARN.</p>', 'CreateMediaCapturePipelineRequest$SourceArn' => '<p>ARN of the source from which the media artifacts are captured.</p>', 'CreateMediaCapturePipelineRequest$SinkArn' => '<p>The ARN of the sink type.</p>', 'ListTagsForResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', 'MediaCapturePipeline$SourceArn' => '<p>ARN of the source from which the media artifacts will be saved.</p>', 'MediaCapturePipeline$SinkArn' => '<p>ARN of the destination to which the media artifacts are saved.</p>', 'MeetingNotificationConfiguration$SnsTopicArn' => '<p>The SNS topic ARN.</p>', 'MeetingNotificationConfiguration$SqsQueueArn' => '<p>The SQS queue ARN.</p>', 'TagResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', ], ], 'ArtifactsConfiguration' => [ 'base' => '<p>The configuration for the artifacts.</p>', 'refs' => [ 'ChimeSdkMeetingConfiguration$ArtifactsConfiguration' => '<p>The configuration for the artifacts in an Amazon Chime SDK meeting.</p>', ], ], 'ArtifactsState' => [ 'base' => NULL, 'refs' => [ 'ContentArtifactsConfiguration$State' => '<p>Indicates whether the content artifact is enabled or disabled.</p>', 'VideoArtifactsConfiguration$State' => '<p>Indicates whether the video artifact is enabled or disabled.</p>', ], ], 'AssociatePhoneNumberWithUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociatePhoneNumberWithUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociatePhoneNumbersWithVoiceConnectorGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociatePhoneNumbersWithVoiceConnectorGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociatePhoneNumbersWithVoiceConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociatePhoneNumbersWithVoiceConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSigninDelegateGroupsWithAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSigninDelegateGroupsWithAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'Attendee' => [ 'base' => '<p> An Amazon Chime SDK meeting attendee. Includes a unique <code>AttendeeId</code> and <code>JoinToken</code> . The <code>JoinToken</code> allows a client to authenticate and join as the specified attendee. The <code>JoinToken</code> expires when the meeting ends or when <a>DeleteAttendee</a> is called. After that, the attendee is unable to join the meeting. </p> <p>We recommend securely transferring each <code>JoinToken</code> from your server application to the client so that no other client has access to the token except for the one authorized to represent the attendee.</p>', 'refs' => [ 'AttendeeList$member' => NULL, 'CreateAttendeeResponse$Attendee' => '<p>The attendee information, including attendee ID and join token.</p>', 'GetAttendeeResponse$Attendee' => '<p>The Amazon Chime SDK attendee information.</p>', ], ], 'AttendeeIdList' => [ 'base' => NULL, 'refs' => [ 'SelectedVideoStreams$AttendeeIds' => '<p>The attendee IDs of the streams selected for a media capture pipeline. </p>', ], ], 'AttendeeList' => [ 'base' => NULL, 'refs' => [ 'BatchCreateAttendeeResponse$Attendees' => '<p>The attendee information, including attendees IDs and join tokens.</p>', 'CreateMeetingWithAttendeesResponse$Attendees' => '<p>The attendee information, including attendees IDs and join tokens.</p>', 'ListAttendeesResponse$Attendees' => '<p>The Amazon Chime SDK attendee information.</p>', ], ], 'AttendeeTagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagAttendeeRequest$TagKeys' => '<p>The tag keys.</p>', ], ], 'AttendeeTagList' => [ 'base' => NULL, 'refs' => [ 'CreateAttendeeRequest$Tags' => '<p>The tag key-value pairs.</p>', 'CreateAttendeeRequestItem$Tags' => '<p>The tag key-value pairs.</p>', 'TagAttendeeRequest$Tags' => '<p>The tag key-value pairs.</p>', ], ], 'AudioArtifactsConfiguration' => [ 'base' => '<p>The audio artifact configuration object.</p>', 'refs' => [ 'ArtifactsConfiguration$Audio' => '<p>The configuration for the audio artifacts.</p>', ], ], 'AudioMuxType' => [ 'base' => NULL, 'refs' => [ 'AudioArtifactsConfiguration$MuxType' => '<p>The MUX type of the audio artifact configuration object.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>The input parameters don\'t match the service\'s restrictions.</p>', 'refs' => [], ], 'BatchChannelMemberships' => [ 'base' => '<p>The membership information, including member ARNs, the channel ARN, and membership types.</p>', 'refs' => [ 'BatchCreateChannelMembershipResponse$BatchChannelMemberships' => '<p>The list of channel memberships in the response.</p>', ], ], 'BatchCreateAttendeeErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchCreateAttendeeResponse$Errors' => '<p>If the action fails for one or more of the attendees in the request, a list of the attendees is returned, along with error codes and error messages.</p>', 'CreateMeetingWithAttendeesResponse$Errors' => '<p>If the action fails for one or more of the attendees in the request, a list of the attendees is returned, along with error codes and error messages.</p>', ], ], 'BatchCreateAttendeeRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreateAttendeeResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreateChannelMembershipError' => [ 'base' => '<p>A list of failed member ARNs, error codes, and error messages.</p>', 'refs' => [ 'BatchCreateChannelMembershipErrors$member' => NULL, ], ], 'BatchCreateChannelMembershipErrors' => [ 'base' => NULL, 'refs' => [ 'BatchCreateChannelMembershipResponse$Errors' => '<p>If the action fails for one or more of the memberships in the request, a list of the memberships is returned, along with error codes and error messages.</p>', ], ], 'BatchCreateChannelMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreateChannelMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreateRoomMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreateRoomMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeletePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeletePhoneNumberResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchSuspendUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchSuspendUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUnsuspendUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUnsuspendUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdatePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdatePhoneNumberResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AccountSettings$DisableRemoteControl' => '<p>Setting that stops or starts remote control of shared screens during meetings.</p>', 'AccountSettings$EnableDialOut' => '<p>Setting that allows meeting participants to choose the <b>Call me at a phone number</b> option. For more information, see <a href="https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html">Join a Meeting without the Amazon Chime App</a>.</p>', 'AlexaForBusinessMetadata$IsAlexaForBusinessEnabled' => '<p>Starts or stops Alexa for Business.</p>', 'CreateVoiceConnectorRequest$RequireEncryption' => '<p>When enabled, requires encryption for the Amazon Chime Voice Connector.</p>', 'EngineTranscribeSettings$EnablePartialResultsStabilization' => '<p>Generates partial transcription results that are less likely to change as meeting attendees speak. It does so by only allowing the last few words from the partial results to change.</p>', 'LoggingConfiguration$EnableSIPLogs' => '<p>When true, enables SIP message logs for sending to Amazon CloudWatch Logs.</p>', 'Origination$Disabled' => '<p>When origination settings are disabled, inbound calls are not enabled for your Amazon Chime Voice Connector. This parameter is not required, but you must specify this parameter or <code>Routes</code>.</p>', 'Proxy$Disabled' => '<p>When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.</p>', 'PutVoiceConnectorProxyRequest$Disabled' => '<p>When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.</p>', 'SipMediaApplicationLoggingConfiguration$EnableSipMediaApplicationMessageLogs' => '<p>Enables application message logs for the SIP media application.</p>', 'SipRule$Disabled' => '<p>Indicates whether the SIP rule is enabled or disabled. You must disable a rule before you can delete it.</p>', 'StreamingConfiguration$Disabled' => '<p>When true, media streaming to Amazon Kinesis is turned off.</p>', 'TelephonySettings$InboundCalling' => '<p>Allows or denies inbound calling.</p>', 'TelephonySettings$OutboundCalling' => '<p>Allows or denies outbound calling.</p>', 'TelephonySettings$SMS' => '<p>Allows or denies SMS messaging.</p>', 'Termination$Disabled' => '<p>When termination settings are disabled, outbound calls can not be made.</p>', 'UpdateVoiceConnectorRequest$RequireEncryption' => '<p>When enabled, requires encryption for the Amazon Chime Voice Connector.</p>', 'VoiceConnector$RequireEncryption' => '<p>Designates whether encryption is required for the Amazon Chime Voice Connector.</p>', ], ], 'Bot' => [ 'base' => '<p>A resource that allows Enterprise account administrators to configure an interface to receive events from Amazon Chime.</p>', 'refs' => [ 'BotList$member' => NULL, 'CreateBotResponse$Bot' => '<p>The bot details.</p>', 'GetBotResponse$Bot' => '<p>The chat bot details.</p>', 'RegenerateSecurityTokenResponse$Bot' => NULL, 'UpdateBotResponse$Bot' => '<p>The updated bot details.</p>', ], ], 'BotList' => [ 'base' => NULL, 'refs' => [ 'ListBotsResponse$Bots' => '<p>List of bots and bot details.</p>', ], ], 'BotType' => [ 'base' => NULL, 'refs' => [ 'Bot$BotType' => '<p>The bot type.</p>', ], ], 'BusinessCallingSettings' => [ 'base' => '<p>The Amazon Chime Business Calling settings for the administrator\'s AWS account. Includes any Amazon S3 buckets designated for storing call detail records.</p>', 'refs' => [ 'GetGlobalSettingsResponse$BusinessCalling' => '<p>The Amazon Chime Business Calling settings.</p>', 'UpdateGlobalSettingsRequest$BusinessCalling' => '<p>The Amazon Chime Business Calling settings.</p>', ], ], 'CallingName' => [ 'base' => NULL, 'refs' => [ 'GetPhoneNumberSettingsResponse$CallingName' => '<p>The default outbound calling name for the account.</p>', 'PhoneNumber$CallingName' => '<p>The outbound calling name associated with the phone number.</p>', 'UpdatePhoneNumberRequest$CallingName' => '<p>The outbound calling name associated with the phone number.</p>', 'UpdatePhoneNumberRequestItem$CallingName' => '<p>The outbound calling name to update.</p>', 'UpdatePhoneNumberSettingsRequest$CallingName' => '<p>The default outbound calling name for the account.</p>', ], ], 'CallingNameStatus' => [ 'base' => NULL, 'refs' => [ 'PhoneNumber$CallingNameStatus' => '<p>The outbound calling name status.</p>', ], ], 'CallingRegion' => [ 'base' => NULL, 'refs' => [ 'CallingRegionList$member' => NULL, ], ], 'CallingRegionList' => [ 'base' => NULL, 'refs' => [ 'Termination$CallingRegions' => '<p>The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.</p>', ], ], 'Capability' => [ 'base' => NULL, 'refs' => [ 'CapabilityList$member' => NULL, ], ], 'CapabilityList' => [ 'base' => NULL, 'refs' => [ 'CreateProxySessionRequest$Capabilities' => '<p>The proxy session capabilities.</p>', 'ProxySession$Capabilities' => '<p>The proxy session capabilities.</p>', 'UpdateProxySessionRequest$Capabilities' => '<p>The proxy session capabilities.</p>', ], ], 'Channel' => [ 'base' => '<p>The details of a channel.</p>', 'refs' => [ 'DescribeChannelResponse$Channel' => '<p>The channel details.</p>', ], ], 'ChannelBan' => [ 'base' => '<p>The details of a channel ban.</p>', 'refs' => [ 'DescribeChannelBanResponse$ChannelBan' => '<p>The details of the ban.</p>', ], ], 'ChannelBanSummary' => [ 'base' => '<p>Summary of the details of a <code>ChannelBan</code>.</p>', 'refs' => [ 'ChannelBanSummaryList$member' => NULL, ], ], 'ChannelBanSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelBansResponse$ChannelBans' => '<p>The information for each requested ban.</p>', ], ], 'ChannelMembership' => [ 'base' => '<p>The details of a channel member.</p>', 'refs' => [ 'DescribeChannelMembershipResponse$ChannelMembership' => '<p>The details of the membership.</p>', ], ], 'ChannelMembershipForAppInstanceUserSummary' => [ 'base' => '<p>Summary of the channel membership details of an <code>AppInstanceUser</code>.</p>', 'refs' => [ 'ChannelMembershipForAppInstanceUserSummaryList$member' => NULL, 'DescribeChannelMembershipForAppInstanceUserResponse$ChannelMembership' => '<p>The channel to which a user belongs.</p>', ], ], 'ChannelMembershipForAppInstanceUserSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelMembershipsForAppInstanceUserResponse$ChannelMemberships' => '<p>The token passed by previous API calls until all requested users are returned.</p>', ], ], 'ChannelMembershipSummary' => [ 'base' => '<p>Summary of the details of a <code>ChannelMembership</code>.</p>', 'refs' => [ 'ChannelMembershipSummaryList$member' => NULL, ], ], 'ChannelMembershipSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelMembershipsResponse$ChannelMemberships' => '<p>The information for the requested channel memberships.</p>', ], ], 'ChannelMembershipType' => [ 'base' => NULL, 'refs' => [ 'AppInstanceUserMembershipSummary$Type' => '<p>The type of <code>ChannelMembership</code>.</p>', 'BatchChannelMemberships$Type' => '<p>The membership types set for the channel users.</p>', 'BatchCreateChannelMembershipRequest$Type' => '<p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>', 'ChannelMembership$Type' => '<p>The membership type set for the channel member.</p>', 'CreateChannelMembershipRequest$Type' => '<p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>', 'ListChannelMembershipsRequest$Type' => '<p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned.</p>', ], ], 'ChannelMessage' => [ 'base' => '<p>The details of a message in a channel.</p>', 'refs' => [ 'GetChannelMessageResponse$ChannelMessage' => '<p>The details of and content in the message.</p>', ], ], 'ChannelMessagePersistenceType' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$Persistence' => '<p>The persistence setting for a channel message.</p>', 'SendChannelMessageRequest$Persistence' => '<p>Boolean that controls whether the message is persisted on the back end. Required.</p>', ], ], 'ChannelMessageSummary' => [ 'base' => '<p>Summary of the messages in a <code>Channel</code>.</p>', 'refs' => [ 'ChannelMessageSummaryList$member' => NULL, ], ], 'ChannelMessageSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelMessagesResponse$ChannelMessages' => '<p>The information about, and content of, each requested message.</p>', ], ], 'ChannelMessageType' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$Type' => '<p>The message type.</p>', 'ChannelMessageSummary$Type' => '<p>The type of message.</p>', 'SendChannelMessageRequest$Type' => '<p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p>', ], ], 'ChannelMode' => [ 'base' => NULL, 'refs' => [ 'Channel$Mode' => '<p>The mode of the channel.</p>', 'ChannelSummary$Mode' => '<p>The mode of the channel.</p>', 'CreateChannelRequest$Mode' => '<p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>', 'UpdateChannelRequest$Mode' => '<p>The mode of the update request.</p>', ], ], 'ChannelModeratedByAppInstanceUserSummary' => [ 'base' => '<p>Summary of the details of a moderated channel.</p>', 'refs' => [ 'ChannelModeratedByAppInstanceUserSummaryList$member' => NULL, 'DescribeChannelModeratedByAppInstanceUserResponse$Channel' => '<p>The moderated channel.</p>', ], ], 'ChannelModeratedByAppInstanceUserSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelsModeratedByAppInstanceUserResponse$Channels' => '<p>The moderated channels in the request.</p>', ], ], 'ChannelModerator' => [ 'base' => '<p>The details of a channel moderator.</p>', 'refs' => [ 'DescribeChannelModeratorResponse$ChannelModerator' => '<p>The details of the channel moderator.</p>', ], ], 'ChannelModeratorSummary' => [ 'base' => '<p>Summary of the details of a <code>ChannelModerator</code>.</p>', 'refs' => [ 'ChannelModeratorSummaryList$member' => NULL, ], ], 'ChannelModeratorSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelModeratorsResponse$ChannelModerators' => '<p>The information about and names of each moderator.</p>', ], ], 'ChannelPrivacy' => [ 'base' => NULL, 'refs' => [ 'Channel$Privacy' => '<p>The channel\'s privacy setting.</p>', 'ChannelSummary$Privacy' => '<p>The privacy setting of the channel.</p>', 'CreateChannelRequest$Privacy' => '<p>The channel\'s privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren\'t discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>', 'ListChannelsRequest$Privacy' => '<p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels. </p>', ], ], 'ChannelRetentionSettings' => [ 'base' => '<p>The details of the retention settings for a channel.</p>', 'refs' => [ 'AppInstanceRetentionSettings$ChannelRetentionSettings' => '<p>The length of time in days to retain the messages in a channel.</p>', ], ], 'ChannelSummary' => [ 'base' => '<p>Summary of the details of a <code>Channel</code>.</p>', 'refs' => [ 'ChannelMembershipForAppInstanceUserSummary$ChannelSummary' => NULL, 'ChannelModeratedByAppInstanceUserSummary$ChannelSummary' => '<p>Summary of the details of a <code>Channel</code>.</p>', 'ChannelSummaryList$member' => NULL, ], ], 'ChannelSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelsResponse$Channels' => '<p>The information about each channel.</p>', ], ], 'ChimeArn' => [ 'base' => NULL, 'refs' => [ 'AppInstance$AppInstanceArn' => '<p>The ARN of the messaging instance.</p>', 'AppInstanceAdmin$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code> for which the user is an administrator.</p>', 'AppInstanceSummary$AppInstanceArn' => '<p>The <code>AppInstance</code> ARN.</p>', 'AppInstanceUser$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'AppInstanceUserSummary$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'BatchChannelMemberships$ChannelArn' => '<p>The ARN of the channel to which you\'re adding users.</p>', 'BatchCreateChannelMembershipError$MemberArn' => '<p>The ARN of the member that the service couldn\'t add.</p>', 'BatchCreateChannelMembershipRequest$ChannelArn' => '<p>The ARN of the channel to which you\'re adding users.</p>', 'BatchCreateChannelMembershipRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'Channel$ChannelArn' => '<p>The ARN of the channel.</p>', 'ChannelBan$ChannelArn' => '<p>The ARN of the channel from which a member is being banned.</p>', 'ChannelMembership$ChannelArn' => '<p>The ARN of the member\'s channel.</p>', 'ChannelMessage$ChannelArn' => '<p>The ARN of the channel.</p>', 'ChannelModerator$ChannelArn' => '<p>The ARN of the moderator\'s channel.</p>', 'ChannelSummary$ChannelArn' => '<p>The ARN of the channel.</p>', 'CreateAppInstanceAdminRequest$AppInstanceAdminArn' => '<p>The ARN of the administrator of the current <code>AppInstance</code>.</p>', 'CreateAppInstanceAdminRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'CreateAppInstanceAdminResponse$AppInstanceArn' => '<p>The ARN of the of the admin for the <code>AppInstance</code>.</p>', 'CreateAppInstanceResponse$AppInstanceArn' => '<p>The Amazon Resource Number (ARN) of the <code>AppInstance</code>.</p>', 'CreateAppInstanceUserRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code> request.</p>', 'CreateAppInstanceUserResponse$AppInstanceUserArn' => '<p>The user\'s ARN.</p>', 'CreateChannelBanRequest$ChannelArn' => '<p>The ARN of the ban request.</p>', 'CreateChannelBanRequest$MemberArn' => '<p>The ARN of the member being banned.</p>', 'CreateChannelBanRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'CreateChannelBanResponse$ChannelArn' => '<p>The ARN of the response to the ban request.</p>', 'CreateChannelMembershipRequest$ChannelArn' => '<p>The ARN of the channel to which you\'re adding users.</p>', 'CreateChannelMembershipRequest$MemberArn' => '<p>The ARN of the member you want to add to the channel.</p>', 'CreateChannelMembershipRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'CreateChannelMembershipResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'CreateChannelModeratorRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'CreateChannelModeratorRequest$ChannelModeratorArn' => '<p>The ARN of the moderator.</p>', 'CreateChannelModeratorRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'CreateChannelModeratorResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'CreateChannelRequest$AppInstanceArn' => '<p>The ARN of the channel request.</p>', 'CreateChannelRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'CreateChannelResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'DeleteAppInstanceAdminRequest$AppInstanceAdminArn' => '<p>The ARN of the <code>AppInstance</code>\'s administrator.</p>', 'DeleteAppInstanceAdminRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'DeleteAppInstanceRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'DeleteAppInstanceStreamingConfigurationsRequest$AppInstanceArn' => '<p>The ARN of the streaming configurations being deleted.</p>', 'DeleteAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the user request being deleted.</p>', 'DeleteChannelBanRequest$ChannelArn' => '<p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>', 'DeleteChannelBanRequest$MemberArn' => '<p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>', 'DeleteChannelBanRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DeleteChannelMembershipRequest$ChannelArn' => '<p>The ARN of the channel from which you want to remove the user.</p>', 'DeleteChannelMembershipRequest$MemberArn' => '<p>The ARN of the member that you\'re removing from the channel.</p>', 'DeleteChannelMembershipRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DeleteChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DeleteChannelMessageRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DeleteChannelModeratorRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DeleteChannelModeratorRequest$ChannelModeratorArn' => '<p>The ARN of the moderator being deleted.</p>', 'DeleteChannelModeratorRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DeleteChannelRequest$ChannelArn' => '<p>The ARN of the channel being deleted.</p>', 'DeleteChannelRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DescribeAppInstanceAdminRequest$AppInstanceAdminArn' => '<p>The ARN of the <code>AppInstanceAdmin</code>.</p>', 'DescribeAppInstanceAdminRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'DescribeAppInstanceRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'DescribeAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'DescribeChannelBanRequest$ChannelArn' => '<p>The ARN of the channel from which the user is banned.</p>', 'DescribeChannelBanRequest$MemberArn' => '<p>The ARN of the member being banned.</p>', 'DescribeChannelBanRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DescribeChannelMembershipForAppInstanceUserRequest$ChannelArn' => '<p>The ARN of the channel to which the user belongs.</p>', 'DescribeChannelMembershipForAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the user in a channel.</p>', 'DescribeChannelMembershipForAppInstanceUserRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DescribeChannelMembershipRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DescribeChannelMembershipRequest$MemberArn' => '<p>The ARN of the member.</p>', 'DescribeChannelMembershipRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DescribeChannelModeratedByAppInstanceUserRequest$ChannelArn' => '<p>The ARN of the moderated channel.</p>', 'DescribeChannelModeratedByAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code> in the moderated channel.</p>', 'DescribeChannelModeratedByAppInstanceUserRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DescribeChannelModeratorRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DescribeChannelModeratorRequest$ChannelModeratorArn' => '<p>The ARN of the channel moderator.</p>', 'DescribeChannelModeratorRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'DescribeChannelRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DescribeChannelRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'GetAppInstanceRetentionSettingsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'GetAppInstanceStreamingConfigurationsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'GetChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'GetChannelMessageRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'Identity$Arn' => '<p>The ARN in an Identity.</p>', 'ListAppInstanceAdminsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListAppInstanceAdminsResponse$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListAppInstanceUsersRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListAppInstanceUsersResponse$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListChannelBansRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelBansRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'ListChannelBansResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelMembershipsForAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>s</p>', 'ListChannelMembershipsForAppInstanceUserRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'ListChannelMembershipsRequest$ChannelArn' => '<p>The maximum number of channel memberships that you want returned.</p>', 'ListChannelMembershipsRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'ListChannelMembershipsResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelMessagesRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelMessagesRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'ListChannelMessagesResponse$ChannelArn' => '<p>The ARN of the channel containing the requested messages.</p>', 'ListChannelModeratorsRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelModeratorsRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'ListChannelModeratorsResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelsModeratedByAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the user in the moderated channel.</p>', 'ListChannelsModeratedByAppInstanceUserRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'ListChannelsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListChannelsRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'MemberArns$member' => NULL, 'PutAppInstanceRetentionSettingsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'PutAppInstanceStreamingConfigurationsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'RedactChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel containing the messages that you want to redact.</p>', 'RedactChannelMessageRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'RedactChannelMessageResponse$ChannelArn' => '<p>The ARN of the channel containing the messages that you want to redact.</p>', 'SendChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'SendChannelMessageRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'SendChannelMessageResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateAppInstanceRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'UpdateAppInstanceResponse$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>. </p>', 'UpdateAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'UpdateAppInstanceUserResponse$AppInstanceUserArn' => '<p>The ARN of the <code>AppInstanceUser</code>.</p>', 'UpdateChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelMessageRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'UpdateChannelMessageResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelReadMarkerRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelReadMarkerRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'UpdateChannelReadMarkerResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user that makes the API call.</p>', 'UpdateChannelResponse$ChannelArn' => '<p>The ARN of the channel.</p>', ], ], 'ChimeSdkMeetingConfiguration' => [ 'base' => '<p>The configuration object of the Amazon Chime SDK meeting for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>', 'refs' => [ 'CreateMediaCapturePipelineRequest$ChimeSdkMeetingConfiguration' => '<p>The configuration for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>', 'MediaCapturePipeline$ChimeSdkMeetingConfiguration' => '<p>The configuration for a specified media capture pipeline. <code>SourceType</code> must be <code>ChimeSdkMeeting</code>.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'CreateAppInstanceRequest$ClientRequestToken' => '<p>The <code>ClientRequestToken</code> of the <code>AppInstance</code>.</p>', 'CreateAppInstanceUserRequest$ClientRequestToken' => '<p>The token assigned to the user requesting an <code>AppInstance</code>.</p>', 'CreateChannelRequest$ClientRequestToken' => '<p>The client token for the request. An <code>Idempotency</code> token.</p>', 'CreateMediaCapturePipelineRequest$ClientRequestToken' => '<p>The token assigned to the client making the pipeline request.</p>', 'CreateMeetingRequest$ClientRequestToken' => '<p>The unique identifier for the client request. Use a different token for different meetings.</p>', 'CreateMeetingWithAttendeesRequest$ClientRequestToken' => '<p>The unique identifier for the client request. Use a different token for different meetings.</p>', 'CreateRoomRequest$ClientRequestToken' => '<p>The idempotency token for the request.</p>', 'SendChannelMessageRequest$ClientRequestToken' => '<p>The <code>Idempotency</code> token for each client request.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request could not be processed because of conflict in the current state of the resource.</p>', 'refs' => [], ], 'Content' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$Content' => '<p>The message content.</p>', 'ChannelMessageSummary$Content' => '<p>The content of the message.</p>', 'UpdateChannelMessageRequest$Content' => '<p>The content of the message being updated.</p>', ], ], 'ContentArtifactsConfiguration' => [ 'base' => '<p>The content artifact object.</p>', 'refs' => [ 'ArtifactsConfiguration$Content' => '<p>The configuration for the content artifacts.</p>', ], ], 'ContentMuxType' => [ 'base' => NULL, 'refs' => [ 'ContentArtifactsConfiguration$MuxType' => '<p>The MUX type of the artifact configuration.</p>', ], ], 'ConversationRetentionSettings' => [ 'base' => '<p>The retention settings that determine how long to retain conversation messages for an Amazon Chime Enterprise account.</p>', 'refs' => [ 'RetentionSettings$ConversationRetentionSettings' => '<p>The chat conversation retention settings.</p>', ], ], 'Country' => [ 'base' => NULL, 'refs' => [ 'CountryList$member' => NULL, 'GeoMatchParams$Country' => '<p>The country.</p>', ], ], 'CountryList' => [ 'base' => NULL, 'refs' => [ 'PutVoiceConnectorProxyRequest$PhoneNumberPoolCountries' => '<p>The countries for proxy phone numbers to be selected from.</p>', ], ], 'CpsLimit' => [ 'base' => NULL, 'refs' => [ 'Termination$CpsLimit' => '<p>The limit on calls per second. Max value based on account service quota. Default value of 1.</p>', ], ], 'CreateAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceAdminRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceAdminResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAttendeeError' => [ 'base' => '<p>The list of errors returned when errors are encountered during the BatchCreateAttendee and CreateAttendee actions. This includes external user IDs, error codes, and error messages.</p>', 'refs' => [ 'BatchCreateAttendeeErrorList$member' => NULL, ], ], 'CreateAttendeeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAttendeeRequestItem' => [ 'base' => '<p>The Amazon Chime SDK attendee fields to create, used with the BatchCreateAttendee action.</p>', 'refs' => [ 'CreateAttendeeRequestItemList$member' => NULL, 'CreateMeetingWithAttendeesRequestItemList$member' => NULL, ], ], 'CreateAttendeeRequestItemList' => [ 'base' => NULL, 'refs' => [ 'BatchCreateAttendeeRequest$Attendees' => '<p>The request containing the attendees to create.</p>', ], ], 'CreateAttendeeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelBanRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelBanResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelModeratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelModeratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMediaCapturePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMediaCapturePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMeetingDialOutRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMeetingDialOutResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMeetingRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMeetingResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMeetingWithAttendeesRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMeetingWithAttendeesRequestItemList' => [ 'base' => NULL, 'refs' => [ 'CreateMeetingWithAttendeesRequest$Attendees' => '<p>The request containing the attendees to create.</p>', ], ], 'CreateMeetingWithAttendeesResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePhoneNumberOrderRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePhoneNumberOrderResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProxySessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProxySessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoomMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoomMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSipMediaApplicationCallRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSipMediaApplicationCallResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSipMediaApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSipMediaApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSipRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSipRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVoiceConnectorGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVoiceConnectorGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVoiceConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVoiceConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'Credential' => [ 'base' => '<p>The SIP credentials used to authenticate requests to your Amazon Chime Voice Connector.</p>', 'refs' => [ 'CredentialList$member' => NULL, ], ], 'CredentialList' => [ 'base' => NULL, 'refs' => [ 'PutVoiceConnectorTerminationCredentialsRequest$Credentials' => '<p>The termination SIP credentials.</p>', ], ], 'DNISEmergencyCallingConfiguration' => [ 'base' => '<p>The Dialed Number Identification Service (DNIS) emergency calling configuration details associated with an Amazon Chime Voice Connector\'s emergency calling configuration.</p>', 'refs' => [ 'DNISEmergencyCallingConfigurationList$member' => NULL, ], ], 'DNISEmergencyCallingConfigurationList' => [ 'base' => NULL, 'refs' => [ 'EmergencyCallingConfiguration$DNIS' => '<p>The Dialed Number Identification Service (DNIS) emergency calling configuration details.</p>', ], ], 'DataRetentionInHours' => [ 'base' => NULL, 'refs' => [ 'StreamingConfiguration$DataRetentionInHours' => '<p>The retention period, in hours, for the Amazon Kinesis data.</p>', ], ], 'DeleteAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppInstanceAdminRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppInstanceStreamingConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAttendeeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelBanRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelModeratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventsConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMediaCapturePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMeetingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProxySessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRoomMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSipMediaApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSipRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorEmergencyCallingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorOriginationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorProxyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorStreamingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorTerminationCredentialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVoiceConnectorTerminationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceAdminRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceAdminResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelBanRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelBanResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelMembershipForAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelMembershipForAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelModeratedByAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelModeratedByAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelModeratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelModeratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatePhoneNumberFromUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatePhoneNumberFromUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatePhoneNumbersFromVoiceConnectorGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatePhoneNumbersFromVoiceConnectorGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatePhoneNumbersFromVoiceConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatePhoneNumbersFromVoiceConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSigninDelegateGroupsFromAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSigninDelegateGroupsFromAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'E164PhoneNumber' => [ 'base' => NULL, 'refs' => [ 'AssociatePhoneNumberWithUserRequest$E164PhoneNumber' => '<p>The phone number, in E.164 format.</p>', 'CreateMeetingDialOutRequest$FromPhoneNumber' => '<p>Phone number used as the caller ID when the remote party receives a call.</p>', 'CreateMeetingDialOutRequest$ToPhoneNumber' => '<p>Phone number called when inviting someone to a meeting.</p>', 'CreateSipMediaApplicationCallRequest$FromPhoneNumber' => '<p>The phone number that a user calls from. This is a phone number in your Amazon Chime phone number inventory.</p>', 'CreateSipMediaApplicationCallRequest$ToPhoneNumber' => '<p>The phone number that the service should call.</p>', 'DNISEmergencyCallingConfiguration$EmergencyPhoneNumber' => '<p>The DNIS phone number to route emergency calls to, in E.164 format.</p>', 'DNISEmergencyCallingConfiguration$TestPhoneNumber' => '<p>The DNIS phone number to route test emergency calls to, in E.164 format.</p>', 'E164PhoneNumberList$member' => NULL, 'OrderedPhoneNumber$E164PhoneNumber' => '<p>The phone number, in E.164 format.</p>', 'Participant$PhoneNumber' => '<p>The participant\'s phone number.</p>', 'Participant$ProxyPhoneNumber' => '<p>The participant\'s proxy phone number.</p>', 'ParticipantPhoneNumberList$member' => NULL, 'PhoneNumber$E164PhoneNumber' => '<p>The phone number, in E.164 format.</p>', 'Proxy$FallBackPhoneNumber' => '<p>The phone number to route calls to after a proxy session expires.</p>', 'PutVoiceConnectorProxyRequest$FallBackPhoneNumber' => '<p>The phone number to route calls to after a proxy session expires.</p>', 'Termination$DefaultPhoneNumber' => '<p>The default caller ID phone number.</p>', ], ], 'E164PhoneNumberList' => [ 'base' => NULL, 'refs' => [ 'AssociatePhoneNumbersWithVoiceConnectorGroupRequest$E164PhoneNumbers' => '<p>List of phone numbers, in E.164 format.</p>', 'AssociatePhoneNumbersWithVoiceConnectorRequest$E164PhoneNumbers' => '<p>List of phone numbers, in E.164 format.</p>', 'CreatePhoneNumberOrderRequest$E164PhoneNumbers' => '<p>List of phone numbers, in E.164 format.</p>', 'DisassociatePhoneNumbersFromVoiceConnectorGroupRequest$E164PhoneNumbers' => '<p>List of phone numbers, in E.164 format.</p>', 'DisassociatePhoneNumbersFromVoiceConnectorRequest$E164PhoneNumbers' => '<p>List of phone numbers, in E.164 format.</p>', 'SearchAvailablePhoneNumbersResponse$E164PhoneNumbers' => '<p>List of phone numbers, in E.164 format.</p>', ], ], 'EmailAddress' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Email' => '<p>The user\'s email address.</p>', 'Invite$EmailAddress' => '<p>The email address to which the invite is sent.</p>', 'ListAccountsRequest$UserEmail' => '<p>User email address with which to filter results.</p>', 'ListUsersRequest$UserEmail' => '<p>Optional. The user email address used to filter results. Maximum 1.</p>', 'User$PrimaryEmail' => '<p>The primary email address of the user.</p>', 'UserEmailList$member' => NULL, ], ], 'EmailStatus' => [ 'base' => NULL, 'refs' => [ 'Invite$EmailStatus' => '<p>The status of the invite email.</p>', ], ], 'EmergencyCallingConfiguration' => [ 'base' => '<p>The emergency calling configuration details associated with an Amazon Chime Voice Connector.</p>', 'refs' => [ 'GetVoiceConnectorEmergencyCallingConfigurationResponse$EmergencyCallingConfiguration' => '<p>The emergency calling configuration details.</p>', 'PutVoiceConnectorEmergencyCallingConfigurationRequest$EmergencyCallingConfiguration' => '<p>The emergency calling configuration details.</p>', 'PutVoiceConnectorEmergencyCallingConfigurationResponse$EmergencyCallingConfiguration' => '<p>The emergency calling configuration details.</p>', ], ], 'EngineTranscribeMedicalSettings' => [ 'base' => '<p>Settings specific to the Amazon Transcribe Medical engine.</p>', 'refs' => [ 'TranscriptionConfiguration$EngineTranscribeMedicalSettings' => '<p>The transcription configuration settings passed to Amazon Transcribe Medical.</p>', ], ], 'EngineTranscribeSettings' => [ 'base' => '<p>Settings specific to the Amazon Transcribe engine.</p>', 'refs' => [ 'TranscriptionConfiguration$EngineTranscribeSettings' => '<p>The transcription configuration settings passed to Amazon Transcribe.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Code' => NULL, 'BadRequestException$Code' => NULL, 'BatchCreateChannelMembershipError$ErrorCode' => '<p>The error code.</p>', 'ConflictException$Code' => NULL, 'ForbiddenException$Code' => NULL, 'MemberError$ErrorCode' => '<p>The error code.</p>', 'NotFoundException$Code' => NULL, 'PhoneNumberError$ErrorCode' => '<p>The error code.</p>', 'ResourceLimitExceededException$Code' => NULL, 'ServiceFailureException$Code' => NULL, 'ServiceUnavailableException$Code' => NULL, 'ThrottledClientException$Code' => NULL, 'UnauthorizedClientException$Code' => NULL, 'UnprocessableEntityException$Code' => NULL, 'UserError$ErrorCode' => '<p>The error code.</p>', ], ], 'EventsConfiguration' => [ 'base' => '<p>The configuration that allows a bot to receive outgoing events. Can be either an HTTPS endpoint or a Lambda function ARN.</p>', 'refs' => [ 'GetEventsConfigurationResponse$EventsConfiguration' => '<p>The events configuration details.</p>', 'PutEventsConfigurationResponse$EventsConfiguration' => NULL, ], ], 'ExternalMeetingIdType' => [ 'base' => NULL, 'refs' => [ 'CreateMeetingRequest$ExternalMeetingId' => '<p>The external meeting ID.</p>', 'CreateMeetingWithAttendeesRequest$ExternalMeetingId' => '<p>The external meeting ID.</p>', 'Meeting$ExternalMeetingId' => '<p>The external meeting ID.</p>', ], ], 'ExternalUserIdList' => [ 'base' => NULL, 'refs' => [ 'SelectedVideoStreams$ExternalUserIds' => '<p>The external user IDs of the streams selected for a media capture pipeline.</p>', ], ], 'ExternalUserIdType' => [ 'base' => NULL, 'refs' => [ 'Attendee$ExternalUserId' => '<p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>', 'CreateAttendeeError$ExternalUserId' => '<p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>', 'CreateAttendeeRequest$ExternalUserId' => '<p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>', 'CreateAttendeeRequestItem$ExternalUserId' => '<p>The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.</p>', 'CreateMeetingRequest$MeetingHostId' => '<p>Reserved.</p>', 'CreateMeetingWithAttendeesRequest$MeetingHostId' => '<p>Reserved.</p>', 'ExternalUserIdList$member' => NULL, ], ], 'ForbiddenException' => [ 'base' => '<p>The client is permanently forbidden from making the request.</p>', 'refs' => [], ], 'FunctionArn' => [ 'base' => NULL, 'refs' => [ 'SipMediaApplicationEndpoint$LambdaArn' => '<p>Valid Amazon Resource Name (ARN) of the Lambda function. The function must be created in the same AWS Region as the SIP media application.</p>', ], ], 'GeoMatchLevel' => [ 'base' => NULL, 'refs' => [ 'CreateProxySessionRequest$GeoMatchLevel' => '<p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>', 'ProxySession$GeoMatchLevel' => '<p>The preference for matching the country or area code of the proxy phone number with that of the first participant.</p>', ], ], 'GeoMatchParams' => [ 'base' => '<p>The country and area code for a proxy phone number in a proxy phone session.</p>', 'refs' => [ 'CreateProxySessionRequest$GeoMatchParams' => '<p>The country and area code for the proxy phone number.</p>', 'ProxySession$GeoMatchParams' => '<p>The country and area code for the proxy phone number.</p>', ], ], 'GetAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAccountSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccountSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAppInstanceRetentionSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAppInstanceRetentionSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAppInstanceStreamingConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAppInstanceStreamingConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAttendeeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAttendeeResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEventsConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEventsConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetGlobalSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMediaCapturePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMediaCapturePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMeetingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMeetingResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMessagingSessionEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMessagingSessionEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPhoneNumberOrderRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPhoneNumberOrderResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPhoneNumberResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPhoneNumberSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetProxySessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetProxySessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRetentionSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRetentionSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSipMediaApplicationLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSipMediaApplicationLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSipMediaApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSipMediaApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSipRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSipRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorEmergencyCallingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorEmergencyCallingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorOriginationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorOriginationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorProxyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorProxyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorStreamingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorStreamingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorTerminationHealthRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorTerminationHealthResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorTerminationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVoiceConnectorTerminationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GuidString' => [ 'base' => NULL, 'refs' => [ 'Attendee$AttendeeId' => '<p>The Amazon Chime SDK attendee ID.</p>', 'AttendeeIdList$member' => NULL, 'BatchCreateAttendeeRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'CreateAttendeeRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'CreateMeetingDialOutRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'CreateMeetingDialOutResponse$TransactionId' => '<p>Unique ID that tracks API calls.</p>', 'DeleteAttendeeRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'DeleteAttendeeRequest$AttendeeId' => '<p>The Amazon Chime SDK attendee ID.</p>', 'DeleteMediaCapturePipelineRequest$MediaPipelineId' => '<p>The ID of the media capture pipeline being deleted. </p>', 'DeleteMeetingRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'GetAttendeeRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'GetAttendeeRequest$AttendeeId' => '<p>The Amazon Chime SDK attendee ID.</p>', 'GetMediaCapturePipelineRequest$MediaPipelineId' => '<p>The ID of the pipeline that you want to get.</p>', 'GetMeetingRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'GetPhoneNumberOrderRequest$PhoneNumberOrderId' => '<p>The ID for the phone number order.</p>', 'ListAttendeeTagsRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'ListAttendeeTagsRequest$AttendeeId' => '<p>The Amazon Chime SDK attendee ID.</p>', 'ListAttendeesRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'ListMeetingTagsRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'MediaCapturePipeline$MediaPipelineId' => '<p>The ID of a media capture pipeline.</p>', 'Meeting$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'PhoneNumberOrder$PhoneNumberOrderId' => '<p>The phone number order ID.</p>', 'SipMediaApplicationCall$TransactionId' => '<p>The transaction ID of a call.</p>', 'StartMeetingTranscriptionRequest$MeetingId' => '<p>The unique ID of the meeting being transcribed.</p>', 'StopMeetingTranscriptionRequest$MeetingId' => '<p>The unique ID of the meeting for which you stop transcription.</p>', 'TagAttendeeRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'TagAttendeeRequest$AttendeeId' => '<p>The Amazon Chime SDK attendee ID.</p>', 'TagMeetingRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'UntagAttendeeRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', 'UntagAttendeeRequest$AttendeeId' => '<p>The Amazon Chime SDK attendee ID.</p>', 'UntagMeetingRequest$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', ], ], 'Identity' => [ 'base' => '<p>The details of a user.</p>', 'refs' => [ 'AppInstanceAdmin$Admin' => '<p>The <code>AppInstanceAdmin</code> data.</p>', 'AppInstanceAdminSummary$Admin' => '<p>The details of the <code>AppInstanceAdmin</code>.</p>', 'BatchChannelMemberships$InvitedBy' => '<p>The identifier of the member who invited another member.</p>', 'Channel$CreatedBy' => '<p>The <code>AppInstanceUser</code> who created the channel.</p>', 'ChannelBan$Member' => '<p>The member being banned from the channel.</p>', 'ChannelBan$CreatedBy' => '<p>The <code>AppInstanceUser</code> who created the ban.</p>', 'ChannelBanSummary$Member' => '<p>The member being banned from a channel.</p>', 'ChannelMembership$InvitedBy' => '<p>The identifier of the member who invited another member.</p>', 'ChannelMembership$Member' => '<p>The data of the channel member.</p>', 'ChannelMembershipSummary$Member' => '<p>A member\'s summary data.</p>', 'ChannelMessage$Sender' => '<p>The message sender.</p>', 'ChannelMessageSummary$Sender' => '<p>The message sender.</p>', 'ChannelModerator$Moderator' => '<p>The moderator\'s data.</p>', 'ChannelModerator$CreatedBy' => '<p>The <code>AppInstanceUser</code> who created the moderator.</p>', 'ChannelModeratorSummary$Moderator' => '<p>The data for a moderator.</p>', 'CreateAppInstanceAdminResponse$AppInstanceAdmin' => '<p>The name and ARN of the admin for the <code>AppInstance</code>.</p>', 'CreateChannelBanResponse$Member' => '<p>The <code>ChannelArn</code> and <code>BannedIdentity</code> of the member in the ban response.</p>', 'CreateChannelMembershipResponse$Member' => '<p>The ARN and metadata of the member being added.</p>', 'CreateChannelModeratorResponse$ChannelModerator' => '<p>The ARNs of the channel and the moderator.</p>', 'Members$member' => NULL, ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Proxy$DefaultSessionExpiryMinutes' => '<p>The default number of minutes allowed for proxy sessions.</p>', 'PutVoiceConnectorProxyRequest$DefaultSessionExpiryMinutes' => '<p>The default number of minutes allowed for proxy sessions.</p>', ], ], 'Invite' => [ 'base' => '<p>Invitation object returned after emailing users to invite them to join the Amazon Chime <code>Team</code> account.</p>', 'refs' => [ 'InviteList$member' => NULL, ], ], 'InviteList' => [ 'base' => NULL, 'refs' => [ 'InviteUsersResponse$Invites' => '<p>The email invitation details.</p>', ], ], 'InviteStatus' => [ 'base' => NULL, 'refs' => [ 'Invite$Status' => '<p>The status of the invite.</p>', 'User$UserInvitationStatus' => '<p>The user invite status.</p>', ], ], 'InviteUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'InviteUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'Iso8601Timestamp' => [ 'base' => NULL, 'refs' => [ 'Account$CreatedTimestamp' => '<p>The Amazon Chime account creation timestamp, in ISO 8601 format.</p>', 'Bot$CreatedTimestamp' => '<p>The bot creation timestamp, in ISO 8601 format.</p>', 'Bot$UpdatedTimestamp' => '<p>The updated bot timestamp, in ISO 8601 format.</p>', 'GetPhoneNumberSettingsResponse$CallingNameUpdatedTimestamp' => '<p>The updated outbound calling name timestamp, in ISO 8601 format.</p>', 'GetRetentionSettingsResponse$InitiateDeletionTimestamp' => '<p>The timestamp representing the time at which the specified items are permanently deleted, in ISO 8601 format.</p>', 'MediaCapturePipeline$CreatedTimestamp' => '<p>The time at which the capture pipeline was created, in ISO 8601 format.</p>', 'MediaCapturePipeline$UpdatedTimestamp' => '<p>The time at which the capture pipeline was updated, in ISO 8601 format.</p>', 'PhoneNumber$CreatedTimestamp' => '<p>The phone number creation timestamp, in ISO 8601 format.</p>', 'PhoneNumber$UpdatedTimestamp' => '<p>The updated phone number timestamp, in ISO 8601 format.</p>', 'PhoneNumber$DeletionTimestamp' => '<p>The deleted phone number timestamp, in ISO 8601 format.</p>', 'PhoneNumberAssociation$AssociatedTimestamp' => '<p>The timestamp of the phone number association, in ISO 8601 format.</p>', 'PhoneNumberOrder$CreatedTimestamp' => '<p>The phone number order creation time stamp, in ISO 8601 format.</p>', 'PhoneNumberOrder$UpdatedTimestamp' => '<p>The updated phone number order time stamp, in ISO 8601 format.</p>', 'ProxySession$CreatedTimestamp' => '<p>The created time stamp, in ISO 8601 format.</p>', 'ProxySession$UpdatedTimestamp' => '<p>The updated time stamp, in ISO 8601 format.</p>', 'ProxySession$EndedTimestamp' => '<p>The ended time stamp, in ISO 8601 format.</p>', 'PutRetentionSettingsResponse$InitiateDeletionTimestamp' => '<p>The timestamp representing the time at which the specified items are permanently deleted, in ISO 8601 format.</p>', 'Room$CreatedTimestamp' => '<p>The room creation timestamp, in ISO 8601 format.</p>', 'Room$UpdatedTimestamp' => '<p>The room update timestamp, in ISO 8601 format.</p>', 'RoomMembership$UpdatedTimestamp' => '<p>The room membership update timestamp, in ISO 8601 format.</p>', 'SipMediaApplication$CreatedTimestamp' => '<p>The SIP media application creation timestamp, in ISO 8601 format.</p>', 'SipMediaApplication$UpdatedTimestamp' => '<p>The SIP media application updated timestamp, in ISO 8601 format.</p>', 'SipRule$CreatedTimestamp' => '<p>The time at which the SIP rule was created, in ISO 8601 format.</p>', 'SipRule$UpdatedTimestamp' => '<p>The time at which the SIP rule was last updated, in ISO 8601 format.</p>', 'TerminationHealth$Timestamp' => '<p>The timestamp, in ISO 8601 format.</p>', 'User$RegisteredOn' => '<p>Date and time when the user is registered, in ISO 8601 format.</p>', 'User$InvitedOn' => '<p>Date and time when the user is invited to the Amazon Chime account, in ISO 8601 format.</p>', 'VoiceConnector$CreatedTimestamp' => '<p>The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.</p>', 'VoiceConnector$UpdatedTimestamp' => '<p>The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.</p>', 'VoiceConnectorGroup$CreatedTimestamp' => '<p>The Amazon Chime Voice Connector group creation time stamp, in ISO 8601 format.</p>', 'VoiceConnectorGroup$UpdatedTimestamp' => '<p>The updated Amazon Chime Voice Connector group time stamp, in ISO 8601 format.</p>', ], ], 'JoinTokenString' => [ 'base' => NULL, 'refs' => [ 'Attendee$JoinToken' => '<p>The join token used by the Amazon Chime SDK attendee.</p>', 'CreateMeetingDialOutRequest$JoinToken' => '<p>Token used by the Amazon Chime SDK attendee. Call the <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAttendee.html">CreateAttendee</a> action to get a join token.</p>', ], ], 'License' => [ 'base' => NULL, 'refs' => [ 'Account$DefaultLicense' => '<p>The default license for the Amazon Chime account.</p>', 'LicenseList$member' => NULL, 'UpdateAccountRequest$DefaultLicense' => '<p>The default license applied when you add users to an Amazon Chime account.</p>', 'UpdateUserRequest$LicenseType' => '<p>The user license type to update. This must be a supported license type for the Amazon Chime account that the user belongs to.</p>', 'UpdateUserRequestItem$LicenseType' => '<p>The user license type.</p>', 'User$LicenseType' => '<p>The license type for the user.</p>', ], ], 'LicenseList' => [ 'base' => NULL, 'refs' => [ 'Account$SupportedLicenses' => '<p>Supported licenses for the Amazon Chime account.</p>', ], ], 'ListAccountsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstanceAdminsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstanceAdminsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstanceUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstanceUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppInstancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAttendeeTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAttendeeTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAttendeesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAttendeesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelBansRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelBansResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMembershipsForAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMembershipsForAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMembershipsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMembershipsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMessagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMessagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelModeratorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelModeratorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsModeratedByAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsModeratedByAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMediaCapturePipelinesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMediaCapturePipelinesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMeetingTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMeetingTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMeetingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMeetingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumberOrdersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumberOrdersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumbersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumbersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProxySessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProxySessionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRoomMembershipsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRoomMembershipsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRoomsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRoomsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSipMediaApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSipMediaApplicationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSipRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSipRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSupportedPhoneNumberCountriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSupportedPhoneNumberCountriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceConnectorGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceConnectorGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceConnectorTerminationCredentialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceConnectorTerminationCredentialsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceConnectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVoiceConnectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LoggingConfiguration' => [ 'base' => '<p>The logging configuration associated with an Amazon Chime Voice Connector. Specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.</p>', 'refs' => [ 'GetVoiceConnectorLoggingConfigurationResponse$LoggingConfiguration' => '<p>The logging configuration details.</p>', 'PutVoiceConnectorLoggingConfigurationRequest$LoggingConfiguration' => '<p>The logging configuration details to add.</p>', 'PutVoiceConnectorLoggingConfigurationResponse$LoggingConfiguration' => '<p>The updated logging configuration details.</p>', ], ], 'LogoutUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'LogoutUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceAdminsRequest$MaxResults' => '<p>The maximum number of administrators that you want to return.</p>', 'ListAppInstanceUsersRequest$MaxResults' => '<p>The maximum number of requests that you want returned.</p>', 'ListAppInstancesRequest$MaxResults' => '<p>The maximum number of <code>AppInstance</code>s that you want to return.</p>', 'ListChannelBansRequest$MaxResults' => '<p>The maximum number of bans that you want returned.</p>', 'ListChannelMembershipsForAppInstanceUserRequest$MaxResults' => '<p>The maximum number of users that you want returned.</p>', 'ListChannelMembershipsRequest$MaxResults' => '<p>The maximum number of channel memberships that you want returned.</p>', 'ListChannelMessagesRequest$MaxResults' => '<p>The maximum number of messages that you want returned.</p>', 'ListChannelModeratorsRequest$MaxResults' => '<p>The maximum number of moderators that you want returned.</p>', 'ListChannelsModeratedByAppInstanceUserRequest$MaxResults' => '<p>The maximum number of channels in the request.</p>', 'ListChannelsRequest$MaxResults' => '<p>The maximum number of channels that you want to return.</p>', ], ], 'MediaCapturePipeline' => [ 'base' => '<p>A media capture pipeline object consisting of an ID, source type, source ARN, a sink type, a sink ARN, and a configuration object.</p>', 'refs' => [ 'CreateMediaCapturePipelineResponse$MediaCapturePipeline' => '<p>A media capture pipeline object, the ID, source type, source ARN, sink type, and sink ARN of a media capture pipeline object.</p>', 'GetMediaCapturePipelineResponse$MediaCapturePipeline' => '<p>The media capture pipeline object.</p>', 'MediaCapturePipelineList$member' => NULL, ], ], 'MediaCapturePipelineList' => [ 'base' => NULL, 'refs' => [ 'ListMediaCapturePipelinesResponse$MediaCapturePipelines' => '<p>The media capture pipeline objects in the list.</p>', ], ], 'MediaPipelineSinkType' => [ 'base' => NULL, 'refs' => [ 'CreateMediaCapturePipelineRequest$SinkType' => '<p>Destination type to which the media artifacts are saved. You must use an S3 bucket. </p>', 'MediaCapturePipeline$SinkType' => '<p>Destination type to which the media artifacts are saved. You must use an S3 Bucket.</p>', ], ], 'MediaPipelineSourceType' => [ 'base' => NULL, 'refs' => [ 'CreateMediaCapturePipelineRequest$SourceType' => '<p>Source type from which the media artifacts will be captured. A Chime SDK Meeting is the only supported source.</p>', 'MediaCapturePipeline$SourceType' => '<p>Source type from which media artifacts are saved. You must use <code>ChimeMeeting</code>.</p>', ], ], 'MediaPipelineStatus' => [ 'base' => NULL, 'refs' => [ 'MediaCapturePipeline$Status' => '<p>The status of the media capture pipeline.</p>', ], ], 'MediaPlacement' => [ 'base' => '<p>A set of endpoints used by clients to connect to the media service group for an Amazon Chime SDK meeting.</p>', 'refs' => [ 'Meeting$MediaPlacement' => '<p>The media placement for the meeting.</p>', ], ], 'Meeting' => [ 'base' => '<p>A meeting created using the Amazon Chime SDK.</p>', 'refs' => [ 'CreateMeetingResponse$Meeting' => '<p> The meeting information, including the meeting ID and <code>MediaPlacement</code> . </p>', 'CreateMeetingWithAttendeesResponse$Meeting' => NULL, 'GetMeetingResponse$Meeting' => '<p>The Amazon Chime SDK meeting information.</p>', 'MeetingList$member' => NULL, ], ], 'MeetingList' => [ 'base' => NULL, 'refs' => [ 'ListMeetingsResponse$Meetings' => '<p>The Amazon Chime SDK meeting information.</p>', ], ], 'MeetingNotificationConfiguration' => [ 'base' => '<p> The resource target configurations for receiving Amazon Chime SDK meeting and attendee event notifications. The Amazon Chime SDK supports resource targets located in the US East (N. Virginia) AWS Region (<code>us-east-1</code>). </p>', 'refs' => [ 'CreateMeetingRequest$NotificationsConfiguration' => '<p>The configuration for resource targets to receive notifications when meeting and attendee events occur.</p>', 'CreateMeetingWithAttendeesRequest$NotificationsConfiguration' => NULL, ], ], 'MeetingTagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagMeetingRequest$TagKeys' => '<p>The tag keys.</p>', ], ], 'MeetingTagList' => [ 'base' => NULL, 'refs' => [ 'CreateMeetingRequest$Tags' => '<p>The tag key-value pairs.</p>', 'CreateMeetingWithAttendeesRequest$Tags' => '<p>The tag key-value pairs.</p>', 'TagMeetingRequest$Tags' => '<p>The tag key-value pairs.</p>', ], ], 'Member' => [ 'base' => '<p>The member details, such as email address, name, member ID, and member type.</p>', 'refs' => [ 'RoomMembership$Member' => NULL, ], ], 'MemberArns' => [ 'base' => NULL, 'refs' => [ 'BatchCreateChannelMembershipRequest$MemberArns' => '<p>The ARNs of the members you want to add to the channel.</p>', ], ], 'MemberError' => [ 'base' => '<p>The list of errors returned when a member action results in an error.</p>', 'refs' => [ 'MemberErrorList$member' => NULL, ], ], 'MemberErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchCreateRoomMembershipResponse$Errors' => '<p>If the action fails for one or more of the member IDs in the request, a list of the member IDs is returned, along with error codes and error messages.</p>', ], ], 'MemberType' => [ 'base' => NULL, 'refs' => [ 'Member$MemberType' => '<p>The member type.</p>', ], ], 'Members' => [ 'base' => NULL, 'refs' => [ 'BatchChannelMemberships$Members' => '<p>The users successfully added to the request.</p>', ], ], 'MembershipItem' => [ 'base' => '<p>Membership details, such as member ID and member role.</p>', 'refs' => [ 'MembershipItemList$member' => NULL, ], ], 'MembershipItemList' => [ 'base' => NULL, 'refs' => [ 'BatchCreateRoomMembershipRequest$MembershipItemList' => '<p>The list of membership items.</p>', ], ], 'MessageId' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$MessageId' => '<p>The ID of a message.</p>', 'ChannelMessageSummary$MessageId' => '<p>The ID of the message.</p>', 'DeleteChannelMessageRequest$MessageId' => '<p>The ID of the message being deleted.</p>', 'GetChannelMessageRequest$MessageId' => '<p>The ID of the message.</p>', 'RedactChannelMessageRequest$MessageId' => '<p>The ID of the message being redacted.</p>', 'RedactChannelMessageResponse$MessageId' => '<p>The ID of the message being redacted.</p>', 'SendChannelMessageResponse$MessageId' => '<p>The ID string assigned to each message.</p>', 'UpdateChannelMessageRequest$MessageId' => '<p>The ID string of the message being updated.</p>', 'UpdateChannelMessageResponse$MessageId' => '<p>The ID string of the message being updated.</p>', ], ], 'MessagingSessionEndpoint' => [ 'base' => '<p>The websocket endpoint used to connect to Amazon Chime SDK messaging.</p>', 'refs' => [ 'GetMessagingSessionEndpointResponse$Endpoint' => '<p>The endpoint returned in the response.</p>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'AppInstance$Metadata' => '<p>The metadata of an <code>AppInstance</code>.</p>', 'AppInstanceSummary$Metadata' => '<p>The metadata of the <code>AppInstance</code>.</p>', 'AppInstanceUser$Metadata' => '<p>The metadata of the <code>AppInstanceUser</code>.</p>', 'AppInstanceUserSummary$Metadata' => '<p>The metadata of the <code>AppInstanceUser</code>.</p>', 'Channel$Metadata' => '<p>The channel\'s metadata.</p>', 'ChannelMessage$Metadata' => '<p>The message metadata.</p>', 'ChannelMessageSummary$Metadata' => '<p>The metadata of the message.</p>', 'ChannelSummary$Metadata' => '<p>The metadata of the channel.</p>', 'CreateAppInstanceRequest$Metadata' => '<p>The metadata of the <code>AppInstance</code>. Limited to a 1KB string in UTF-8.</p>', 'CreateAppInstanceUserRequest$Metadata' => '<p>The request\'s metadata. Limited to a 1KB string in UTF-8.</p>', 'CreateChannelRequest$Metadata' => '<p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>', 'SendChannelMessageRequest$Metadata' => '<p>The optional metadata for each message.</p>', 'UpdateAppInstanceRequest$Metadata' => '<p>The metadata that you want to change.</p>', 'UpdateAppInstanceUserRequest$Metadata' => '<p>The metadata of the <code>AppInstanceUser</code>.</p>', 'UpdateChannelMessageRequest$Metadata' => '<p>The metadata of the message being updated.</p>', 'UpdateChannelRequest$Metadata' => '<p>The metadata for the update request.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAppInstanceAdminsRequest$NextToken' => '<p>The token returned from previous API requests until the number of administrators is reached.</p>', 'ListAppInstanceAdminsResponse$NextToken' => '<p>The token returned from previous API requests until the number of administrators is reached.</p>', 'ListAppInstanceUsersRequest$NextToken' => '<p>The token passed by previous API calls until all requested users are returned.</p>', 'ListAppInstanceUsersResponse$NextToken' => '<p>The token passed by previous API calls until all requested users are returned.</p>', 'ListAppInstancesRequest$NextToken' => '<p>The token passed by previous API requests until you reach the maximum number of <code>AppInstance</code>s.</p>', 'ListAppInstancesResponse$NextToken' => '<p>The token passed by previous API requests until the maximum number of <code>AppInstance</code>s is reached.</p>', 'ListChannelBansRequest$NextToken' => '<p>The token passed by previous API calls until all requested bans are returned.</p>', 'ListChannelBansResponse$NextToken' => '<p>The token passed by previous API calls until all requested bans are returned.</p>', 'ListChannelMembershipsForAppInstanceUserRequest$NextToken' => '<p>The token returned from previous API requests until the number of channel memberships is reached.</p>', 'ListChannelMembershipsForAppInstanceUserResponse$NextToken' => '<p>The token passed by previous API calls until all requested users are returned.</p>', 'ListChannelMembershipsRequest$NextToken' => '<p>The token passed by previous API calls until all requested channel memberships are returned.</p>', 'ListChannelMembershipsResponse$NextToken' => '<p>The token passed by previous API calls until all requested channel memberships are returned.</p>', 'ListChannelMessagesRequest$NextToken' => '<p>The token passed by previous API calls until all requested messages are returned.</p>', 'ListChannelMessagesResponse$NextToken' => '<p>The token passed by previous API calls until all requested messages are returned.</p>', 'ListChannelModeratorsRequest$NextToken' => '<p>The token passed by previous API calls until all requested moderators are returned.</p>', 'ListChannelModeratorsResponse$NextToken' => '<p>The token passed by previous API calls until all requested moderators are returned.</p>', 'ListChannelsModeratedByAppInstanceUserRequest$NextToken' => '<p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>', 'ListChannelsModeratedByAppInstanceUserResponse$NextToken' => '<p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>', 'ListChannelsRequest$NextToken' => '<p>The token passed by previous API calls until all requested channels are returned.</p>', 'ListChannelsResponse$NextToken' => '<p>The token returned from previous API requests until the number of channels is reached.</p>', ], ], 'NextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListProxySessionsRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListProxySessionsResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListSipMediaApplicationsRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListSipMediaApplicationsResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListSipRulesRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListSipRulesResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', ], ], 'NonEmptyContent' => [ 'base' => NULL, 'refs' => [ 'SendChannelMessageRequest$Content' => '<p>The content of the message.</p>', ], ], 'NonEmptyResourceName' => [ 'base' => NULL, 'refs' => [ 'AppInstance$Name' => '<p>The name of an <code>AppInstance</code>.</p>', 'AppInstanceSummary$Name' => '<p>The name of the <code>AppInstance</code>.</p>', 'Channel$Name' => '<p>The name of the channel.</p>', 'ChannelSummary$Name' => '<p>The name of the channel.</p>', 'CreateAppInstanceRequest$Name' => '<p>The name of the <code>AppInstance</code>.</p>', 'CreateChannelRequest$Name' => '<p>The name of the channel.</p>', 'UpdateAppInstanceRequest$Name' => '<p>The name that you want to change.</p>', 'UpdateChannelRequest$Name' => '<p>The name of the channel.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'AssociatePhoneNumbersWithVoiceConnectorGroupRequest$VoiceConnectorGroupId' => '<p>The Amazon Chime Voice Connector group ID.</p>', 'AssociatePhoneNumbersWithVoiceConnectorRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'AssociateSigninDelegateGroupsWithAccountRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'BatchCreateRoomMembershipRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'BatchCreateRoomMembershipRequest$RoomId' => '<p>The room ID.</p>', 'BatchSuspendUserRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'BatchUnsuspendUserRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'BatchUpdateUserRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'CreateBotRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'CreateBotRequest$Domain' => '<p>The domain of the Amazon Chime Enterprise account.</p>', 'CreateRoomMembershipRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'CreateRoomMembershipRequest$RoomId' => '<p>The room ID.</p>', 'CreateRoomMembershipRequest$MemberId' => '<p>The Amazon Chime member ID (user ID or bot ID).</p>', 'CreateRoomRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'CreateSipMediaApplicationCallRequest$SipMediaApplicationId' => '<p>The ID of the SIP media application.</p>', 'CreateSipRuleRequest$TriggerValue' => '<p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, the value can be the outbound host name of an Amazon Chime Voice Connector. If <code>TriggerType</code> is <code>ToPhoneNumber</code>, the value can be a customer-owned phone number in the E164 format. The <code>SipMediaApplication</code> specified in the <code>SipRule</code> is triggered if the request URI in an incoming SIP request matches the <code>RequestUriHostname</code>, or if the <code>To</code> header in the incoming SIP request matches the <code>ToPhoneNumber</code> value.</p>', 'CreateUserRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'DeleteAccountRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'DeleteEventsConfigurationRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'DeleteEventsConfigurationRequest$BotId' => '<p>The bot ID.</p>', 'DeleteRoomMembershipRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'DeleteRoomMembershipRequest$RoomId' => '<p>The room ID.</p>', 'DeleteRoomMembershipRequest$MemberId' => '<p>The member ID (user ID or bot ID).</p>', 'DeleteRoomRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'DeleteRoomRequest$RoomId' => '<p>The chat room ID.</p>', 'DeleteSipMediaApplicationRequest$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'DeleteSipRuleRequest$SipRuleId' => '<p>The SIP rule ID.</p>', 'DeleteVoiceConnectorEmergencyCallingConfigurationRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'DeleteVoiceConnectorGroupRequest$VoiceConnectorGroupId' => '<p>The Amazon Chime Voice Connector group ID.</p>', 'DeleteVoiceConnectorOriginationRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'DeleteVoiceConnectorRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'DeleteVoiceConnectorStreamingConfigurationRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'DeleteVoiceConnectorTerminationCredentialsRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'DeleteVoiceConnectorTerminationRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'DisassociatePhoneNumbersFromVoiceConnectorGroupRequest$VoiceConnectorGroupId' => '<p>The Amazon Chime Voice Connector group ID.</p>', 'DisassociatePhoneNumbersFromVoiceConnectorRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'DisassociateSigninDelegateGroupsFromAccountRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'GetAccountRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'GetAccountSettingsRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'GetBotRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'GetBotRequest$BotId' => '<p>The bot ID.</p>', 'GetEventsConfigurationRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'GetEventsConfigurationRequest$BotId' => '<p>The bot ID.</p>', 'GetRetentionSettingsRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'GetRoomRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'GetRoomRequest$RoomId' => '<p>The room ID.</p>', 'GetSipMediaApplicationLoggingConfigurationRequest$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'GetSipMediaApplicationRequest$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'GetSipRuleRequest$SipRuleId' => '<p>The SIP rule ID.</p>', 'GetUserRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'GetUserRequest$UserId' => '<p>The user ID.</p>', 'GetVoiceConnectorEmergencyCallingConfigurationRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'GetVoiceConnectorGroupRequest$VoiceConnectorGroupId' => '<p>The Amazon Chime Voice Connector group ID.</p>', 'GetVoiceConnectorLoggingConfigurationRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'GetVoiceConnectorOriginationRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'GetVoiceConnectorRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'GetVoiceConnectorStreamingConfigurationRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'GetVoiceConnectorTerminationHealthRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'GetVoiceConnectorTerminationRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'InviteUsersRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'ListBotsRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'ListRoomMembershipsRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'ListRoomMembershipsRequest$RoomId' => '<p>The room ID.</p>', 'ListRoomsRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'ListSipRulesRequest$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'ListUsersRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'ListVoiceConnectorTerminationCredentialsRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'LogoutUserRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'LogoutUserRequest$UserId' => '<p>The user ID.</p>', 'Member$MemberId' => '<p>The member ID (user ID or bot ID).</p>', 'Member$AccountId' => '<p>The Amazon Chime account ID.</p>', 'MemberError$MemberId' => '<p>The member ID.</p>', 'MembershipItem$MemberId' => '<p>The member ID.</p>', 'PhoneNumberError$PhoneNumberId' => '<p>The phone number ID for which the action failed.</p>', 'PutEventsConfigurationRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'PutEventsConfigurationRequest$BotId' => '<p>The bot ID.</p>', 'PutRetentionSettingsRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'PutSipMediaApplicationLoggingConfigurationRequest$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'PutVoiceConnectorEmergencyCallingConfigurationRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'PutVoiceConnectorLoggingConfigurationRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'PutVoiceConnectorOriginationRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'PutVoiceConnectorStreamingConfigurationRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'PutVoiceConnectorTerminationCredentialsRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'PutVoiceConnectorTerminationRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'RedactConversationMessageRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'RedactConversationMessageRequest$ConversationId' => '<p>The conversation ID.</p>', 'RedactConversationMessageRequest$MessageId' => '<p>The message ID.</p>', 'RedactRoomMessageRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'RedactRoomMessageRequest$RoomId' => '<p>The room ID.</p>', 'RedactRoomMessageRequest$MessageId' => '<p>The message ID.</p>', 'RegenerateSecurityTokenRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'RegenerateSecurityTokenRequest$BotId' => '<p>The bot ID.</p>', 'ResetPersonalPINRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'ResetPersonalPINRequest$UserId' => '<p>The user ID.</p>', 'RestorePhoneNumberRequest$PhoneNumberId' => '<p>The phone number.</p>', 'Room$RoomId' => '<p>The room ID.</p>', 'Room$AccountId' => '<p>The Amazon Chime account ID.</p>', 'Room$CreatedBy' => '<p>The identifier of the room creator.</p>', 'RoomMembership$RoomId' => '<p>The room ID.</p>', 'RoomMembership$InvitedBy' => '<p>The identifier of the user that invited the room member.</p>', 'SigninDelegateGroup$GroupName' => '<p>The group name.</p>', 'SipMediaApplication$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'SipRule$SipRuleId' => '<p>The SIP rule ID.</p>', 'SipRule$TriggerValue' => '<p>If <code>TriggerType</code> is <code>RequestUriHostname</code>, then the value can be the outbound host name of the Amazon Chime Voice Connector. If <code>TriggerType</code> is <code>ToPhoneNumber</code>, then the value can be a customer-owned phone number in E164 format. <code>SipRule</code> is triggered when a SIP rule requests host name or <code>ToPhoneNumber</code> matches in the incoming SIP request.</p>', 'SipRuleTargetApplication$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'UpdateAccountRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'UpdateAccountSettingsRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'UpdateBotRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'UpdateBotRequest$BotId' => '<p>The bot ID.</p>', 'UpdatePhoneNumberRequestItem$PhoneNumberId' => '<p>The phone number ID to update.</p>', 'UpdateRoomMembershipRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'UpdateRoomMembershipRequest$RoomId' => '<p>The room ID.</p>', 'UpdateRoomMembershipRequest$MemberId' => '<p>The member ID.</p>', 'UpdateRoomRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'UpdateRoomRequest$RoomId' => '<p>The room ID.</p>', 'UpdateSipMediaApplicationCallRequest$SipMediaApplicationId' => '<p>The ID of the SIP media application handling the call.</p>', 'UpdateSipMediaApplicationCallRequest$TransactionId' => '<p>The ID of the call transaction.</p>', 'UpdateSipMediaApplicationRequest$SipMediaApplicationId' => '<p>The SIP media application ID.</p>', 'UpdateSipRuleRequest$SipRuleId' => '<p>The SIP rule ID.</p>', 'UpdateUserRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'UpdateUserRequest$UserId' => '<p>The user ID.</p>', 'UpdateUserRequestItem$UserId' => '<p>The user ID.</p>', 'UpdateVoiceConnectorGroupRequest$VoiceConnectorGroupId' => '<p>The Amazon Chime Voice Connector group ID.</p>', 'UpdateVoiceConnectorRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'UserError$UserId' => '<p>The user ID for which the action failed.</p>', 'UserIdList$member' => NULL, 'VoiceConnector$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'VoiceConnector$VoiceConnectorArn' => '<p>The ARN of the specified Amazon Chime Voice Connector.</p>', 'VoiceConnectorGroup$VoiceConnectorGroupId' => '<p>The Amazon Chime Voice Connector group ID.</p>', 'VoiceConnectorGroup$VoiceConnectorGroupArn' => '<p>The ARN of the specified Amazon Chime Voice Connector group.</p>', 'VoiceConnectorItem$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', ], ], 'NonEmptyString128' => [ 'base' => NULL, 'refs' => [ 'CreateProxySessionRequest$VoiceConnectorId' => '<p>The Amazon Chime voice connector ID.</p>', 'DeleteProxySessionRequest$VoiceConnectorId' => '<p>The Amazon Chime voice connector ID.</p>', 'DeleteProxySessionRequest$ProxySessionId' => '<p>The proxy session ID.</p>', 'DeleteVoiceConnectorProxyRequest$VoiceConnectorId' => '<p>The Amazon Chime Voice Connector ID.</p>', 'GetProxySessionRequest$VoiceConnectorId' => '<p>The Amazon Chime voice connector ID.</p>', 'GetProxySessionRequest$ProxySessionId' => '<p>The proxy session ID.</p>', 'GetVoiceConnectorProxyRequest$VoiceConnectorId' => '<p>The Amazon Chime voice connector ID.</p>', 'ListProxySessionsRequest$VoiceConnectorId' => '<p>The Amazon Chime voice connector ID.</p>', 'ProxySession$VoiceConnectorId' => '<p>The Amazon Chime voice connector ID.</p>', 'ProxySession$ProxySessionId' => '<p>The proxy session ID.</p>', 'PutVoiceConnectorProxyRequest$VoiceConnectorId' => '<p>The Amazon Chime voice connector ID.</p>', 'UpdateProxySessionRequest$VoiceConnectorId' => '<p>The Amazon Chime voice connector ID.</p>', 'UpdateProxySessionRequest$ProxySessionId' => '<p>The proxy session ID.</p>', ], ], 'NonEmptyStringList' => [ 'base' => NULL, 'refs' => [ 'BatchDeletePhoneNumberRequest$PhoneNumberIds' => '<p>List of phone number IDs.</p>', 'DisassociateSigninDelegateGroupsFromAccountRequest$GroupNames' => '<p>The sign-in delegate group names.</p>', ], ], 'NonNullableBoolean' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$Redacted' => '<p>Hides the content of a message.</p>', 'ChannelMessageSummary$Redacted' => '<p>Indicates whether a message was redacted.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>One or more of the resources in the request does not exist in the system.</p>', 'refs' => [], ], 'NotificationTarget' => [ 'base' => NULL, 'refs' => [ 'StreamingNotificationTarget$NotificationTarget' => '<p>The streaming notification target.</p>', ], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'AssociatePhoneNumbersWithVoiceConnectorGroupRequest$ForceAssociate' => '<p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector Group and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>', 'AssociatePhoneNumbersWithVoiceConnectorRequest$ForceAssociate' => '<p>If true, associates the provided phone numbers with the provided Amazon Chime Voice Connector and removes any previously existing associations. If false, does not associate any phone numbers that have previously existing associations.</p>', 'Bot$Disabled' => '<p>When true, the bot is stopped from running in your account.</p>', 'CreateSipRuleRequest$Disabled' => '<p>Enables or disables a rule. You must disable rules before you can delete them.</p>', 'PhoneNumberCapabilities$InboundCall' => '<p>Allows or denies inbound calling for the specified phone number.</p>', 'PhoneNumberCapabilities$OutboundCall' => '<p>Allows or denies outbound calling for the specified phone number.</p>', 'PhoneNumberCapabilities$InboundSMS' => '<p>Allows or denies inbound SMS messaging for the specified phone number.</p>', 'PhoneNumberCapabilities$OutboundSMS' => '<p>Allows or denies outbound SMS messaging for the specified phone number.</p>', 'PhoneNumberCapabilities$InboundMMS' => '<p>Allows or denies inbound MMS messaging for the specified phone number.</p>', 'PhoneNumberCapabilities$OutboundMMS' => '<p>Allows or denies outbound MMS messaging for the specified phone number.</p>', 'UpdateBotRequest$Disabled' => '<p>When true, stops the specified bot from running in your account.</p>', 'UpdateSipRuleRequest$Disabled' => '<p>The new value specified to indicate whether the rule is disabled.</p>', ], ], 'NumberSelectionBehavior' => [ 'base' => NULL, 'refs' => [ 'CreateProxySessionRequest$NumberSelectionBehavior' => '<p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>', 'ProxySession$NumberSelectionBehavior' => '<p>The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.</p>', ], ], 'OrderedPhoneNumber' => [ 'base' => '<p>A phone number for which an order has been placed.</p>', 'refs' => [ 'OrderedPhoneNumberList$member' => NULL, ], ], 'OrderedPhoneNumberList' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberOrder$OrderedPhoneNumbers' => '<p>The ordered phone number details, such as the phone number in E.164 format and the phone number status.</p>', ], ], 'OrderedPhoneNumberStatus' => [ 'base' => NULL, 'refs' => [ 'OrderedPhoneNumber$Status' => '<p>The phone number status.</p>', ], ], 'Origination' => [ 'base' => '<p>Origination settings enable your SIP hosts to receive inbound calls using your Amazon Chime Voice Connector.</p> <note> <p>The parameters listed below are not required, but you must use at least one. </p> </note>', 'refs' => [ 'GetVoiceConnectorOriginationResponse$Origination' => '<p>The origination setting details.</p>', 'PutVoiceConnectorOriginationRequest$Origination' => '<p>The origination setting details to add.</p>', 'PutVoiceConnectorOriginationResponse$Origination' => '<p>The updated origination setting details.</p>', ], ], 'OriginationRoute' => [ 'base' => '<p>Origination routes define call distribution properties for your SIP hosts to receive inbound calls using your Amazon Chime Voice Connector. Limit: Ten origination routes for each Amazon Chime Voice Connector.</p> <note> <p>The parameters listed below are not required, but you must use at least one. </p> </note>', 'refs' => [ 'OriginationRouteList$member' => NULL, ], ], 'OriginationRouteList' => [ 'base' => NULL, 'refs' => [ 'Origination$Routes' => '<p>The call distribution properties defined for your SIP hosts. Valid range: Minimum value of 1. Maximum value of 20. This parameter is not required, but you must specify this parameter or <code>Disabled</code>.</p>', ], ], 'OriginationRoutePriority' => [ 'base' => NULL, 'refs' => [ 'OriginationRoute$Priority' => '<p>The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted first.</p>', ], ], 'OriginationRouteProtocol' => [ 'base' => NULL, 'refs' => [ 'OriginationRoute$Protocol' => '<p>The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.</p>', ], ], 'OriginationRouteWeight' => [ 'base' => NULL, 'refs' => [ 'OriginationRoute$Weight' => '<p>The weight associated with the host. If hosts are equal in priority, calls are redistributed among them based on their relative weight.</p>', ], ], 'Participant' => [ 'base' => '<p>The phone number and proxy phone number for a participant in an Amazon Chime Voice Connector proxy session.</p>', 'refs' => [ 'Participants$member' => NULL, ], ], 'ParticipantPhoneNumberList' => [ 'base' => NULL, 'refs' => [ 'CreateProxySessionRequest$ParticipantPhoneNumbers' => '<p>The participant phone numbers.</p>', ], ], 'Participants' => [ 'base' => NULL, 'refs' => [ 'ProxySession$Participants' => '<p>The proxy session participants.</p>', ], ], 'PhoneNumber' => [ 'base' => '<p>A phone number used for Amazon Chime Business Calling or an Amazon Chime Voice Connector.</p>', 'refs' => [ 'GetPhoneNumberResponse$PhoneNumber' => '<p>The phone number details.</p>', 'PhoneNumberList$member' => NULL, 'RestorePhoneNumberResponse$PhoneNumber' => '<p>The phone number details.</p>', 'UpdatePhoneNumberResponse$PhoneNumber' => '<p>The updated phone number details.</p>', ], ], 'PhoneNumberAssociation' => [ 'base' => '<p>The phone number associations, such as Amazon Chime account ID, Amazon Chime user ID, Amazon Chime Voice Connector ID, or Amazon Chime Voice Connector group ID.</p>', 'refs' => [ 'PhoneNumberAssociationList$member' => NULL, ], ], 'PhoneNumberAssociationList' => [ 'base' => NULL, 'refs' => [ 'PhoneNumber$Associations' => '<p>The phone number associations.</p>', ], ], 'PhoneNumberAssociationName' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersRequest$FilterName' => '<p>The filter to use to limit the number of results.</p>', 'PhoneNumberAssociation$Name' => '<p>Defines the association with an Amazon Chime account ID, user ID, Amazon Chime Voice Connector ID, or Amazon Chime Voice Connector group ID.</p>', ], ], 'PhoneNumberCapabilities' => [ 'base' => '<p>The phone number capabilities for Amazon Chime Business Calling phone numbers, such as enabled inbound and outbound calling and text messaging.</p>', 'refs' => [ 'PhoneNumber$Capabilities' => '<p>The phone number capabilities.</p>', ], ], 'PhoneNumberCountriesList' => [ 'base' => NULL, 'refs' => [ 'ListSupportedPhoneNumberCountriesResponse$PhoneNumberCountries' => '<p>The supported phone number countries.</p>', ], ], 'PhoneNumberCountry' => [ 'base' => '<p>The phone number country.</p>', 'refs' => [ 'PhoneNumberCountriesList$member' => NULL, ], ], 'PhoneNumberError' => [ 'base' => '<p>If the phone number action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>', 'refs' => [ 'PhoneNumberErrorList$member' => NULL, ], ], 'PhoneNumberErrorList' => [ 'base' => NULL, 'refs' => [ 'AssociatePhoneNumbersWithVoiceConnectorGroupResponse$PhoneNumberErrors' => '<p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>', 'AssociatePhoneNumbersWithVoiceConnectorResponse$PhoneNumberErrors' => '<p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>', 'BatchDeletePhoneNumberResponse$PhoneNumberErrors' => '<p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>', 'BatchUpdatePhoneNumberResponse$PhoneNumberErrors' => '<p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>', 'DisassociatePhoneNumbersFromVoiceConnectorGroupResponse$PhoneNumberErrors' => '<p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>', 'DisassociatePhoneNumbersFromVoiceConnectorResponse$PhoneNumberErrors' => '<p>If the action fails for one or more of the phone numbers in the request, a list of the phone numbers is returned, along with error codes and error messages.</p>', ], ], 'PhoneNumberList' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersResponse$PhoneNumbers' => '<p>The phone number details.</p>', ], ], 'PhoneNumberMaxResults' => [ 'base' => NULL, 'refs' => [ 'SearchAvailablePhoneNumbersRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', ], ], 'PhoneNumberOrder' => [ 'base' => '<p>The details of a phone number order created for Amazon Chime.</p>', 'refs' => [ 'CreatePhoneNumberOrderResponse$PhoneNumberOrder' => '<p>The phone number order details.</p>', 'GetPhoneNumberOrderResponse$PhoneNumberOrder' => '<p>The phone number order details.</p>', 'PhoneNumberOrderList$member' => NULL, ], ], 'PhoneNumberOrderList' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumberOrdersResponse$PhoneNumberOrders' => '<p>The phone number order details.</p>', ], ], 'PhoneNumberOrderStatus' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberOrder$Status' => '<p>The status of the phone number order.</p>', ], ], 'PhoneNumberProductType' => [ 'base' => NULL, 'refs' => [ 'CreatePhoneNumberOrderRequest$ProductType' => '<p>The phone number product type.</p>', 'ListPhoneNumbersRequest$ProductType' => '<p>The phone number product type.</p>', 'ListSupportedPhoneNumberCountriesRequest$ProductType' => '<p>The phone number product type.</p>', 'PhoneNumber$ProductType' => '<p>The phone number product type.</p>', 'PhoneNumberOrder$ProductType' => '<p>The phone number order product type.</p>', 'UpdatePhoneNumberRequest$ProductType' => '<p>The product type.</p>', 'UpdatePhoneNumberRequestItem$ProductType' => '<p>The product type to update.</p>', ], ], 'PhoneNumberStatus' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersRequest$Status' => '<p>The phone number status.</p>', 'PhoneNumber$Status' => '<p>The phone number status.</p>', ], ], 'PhoneNumberType' => [ 'base' => NULL, 'refs' => [ 'PhoneNumber$Type' => '<p>The phone number type.</p>', 'PhoneNumberTypeList$member' => NULL, 'SearchAvailablePhoneNumbersRequest$PhoneNumberType' => '<p>The phone number type used to filter results. Required for non-US numbers.</p>', ], ], 'PhoneNumberTypeList' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberCountry$SupportedPhoneNumberTypes' => '<p>The supported phone number types. </p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'OriginationRoute$Port' => '<p>The designated origination route port. Defaults to 5060.</p>', ], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'CreateProxySessionRequest$ExpiryMinutes' => '<p>The number of minutes allowed for the proxy session.</p>', 'ProxySession$ExpiryMinutes' => '<p>The number of minutes allowed for the proxy session.</p>', 'UpdateProxySessionRequest$ExpiryMinutes' => '<p>The number of minutes allowed for the proxy session.</p>', ], ], 'ProfileServiceMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAccountsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Defaults to 100.</p>', 'ListUsersRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Defaults to 100.</p>', ], ], 'Proxy' => [ 'base' => '<p>The proxy configuration for an Amazon Chime Voice Connector.</p>', 'refs' => [ 'GetVoiceConnectorProxyResponse$Proxy' => '<p>The proxy configuration details.</p>', 'PutVoiceConnectorProxyResponse$Proxy' => '<p>The proxy configuration details.</p>', ], ], 'ProxySession' => [ 'base' => '<p>The proxy session for an Amazon Chime Voice Connector.</p>', 'refs' => [ 'CreateProxySessionResponse$ProxySession' => '<p>The proxy session details.</p>', 'GetProxySessionResponse$ProxySession' => '<p>The proxy session details.</p>', 'ProxySessions$member' => NULL, 'UpdateProxySessionResponse$ProxySession' => '<p>The proxy session details.</p>', ], ], 'ProxySessionNameString' => [ 'base' => NULL, 'refs' => [ 'CreateProxySessionRequest$Name' => '<p>The name of the proxy session.</p>', ], ], 'ProxySessionStatus' => [ 'base' => NULL, 'refs' => [ 'ListProxySessionsRequest$Status' => '<p>The proxy session status.</p>', 'ProxySession$Status' => '<p>The status of the proxy session.</p>', ], ], 'ProxySessions' => [ 'base' => NULL, 'refs' => [ 'ListProxySessionsResponse$ProxySessions' => '<p>The proxy session details.</p>', ], ], 'PutAppInstanceRetentionSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAppInstanceRetentionSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutAppInstanceStreamingConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAppInstanceStreamingConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutEventsConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutEventsConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutRetentionSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRetentionSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutSipMediaApplicationLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutSipMediaApplicationLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorEmergencyCallingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorEmergencyCallingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorOriginationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorOriginationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorProxyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorProxyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorStreamingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorStreamingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorTerminationCredentialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorTerminationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutVoiceConnectorTerminationResponse' => [ 'base' => NULL, 'refs' => [], ], 'RedactChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'RedactChannelMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'RedactConversationMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'RedactConversationMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'RedactRoomMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'RedactRoomMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'RegenerateSecurityTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegenerateSecurityTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'RegistrationStatus' => [ 'base' => NULL, 'refs' => [ 'User$UserRegistrationStatus' => '<p>The user registration status.</p>', ], ], 'ResetPersonalPINRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetPersonalPINResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceLimitExceededException' => [ 'base' => '<p>The request exceeds the resource limit.</p>', 'refs' => [], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'Identity$Name' => '<p>The name in an Identity.</p>', ], ], 'RestorePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestorePhoneNumberResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResultMax' => [ 'base' => NULL, 'refs' => [ 'ListAttendeesRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListBotsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. The default is 10.</p>', 'ListMediaCapturePipelinesRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Valid Range: 1 - 99.</p>', 'ListMeetingsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListPhoneNumberOrdersRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListPhoneNumbersRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListProxySessionsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListRoomMembershipsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListRoomsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListSipMediaApplicationsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Defaults to 100.</p>', 'ListSipRulesRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Defaults to 100.</p>', 'ListVoiceConnectorGroupsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListVoiceConnectorsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', ], ], 'RetentionDays' => [ 'base' => NULL, 'refs' => [ 'ChannelRetentionSettings$RetentionDays' => '<p>The time in days to retain the messages in a channel.</p>', 'ConversationRetentionSettings$RetentionDays' => '<p>The number of days for which to retain conversation messages.</p>', 'RoomRetentionSettings$RetentionDays' => '<p>The number of days for which to retain chat-room messages.</p>', ], ], 'RetentionSettings' => [ 'base' => '<p>The retention settings for an Amazon Chime Enterprise account that determine how long to retain items such as chat-room messages and chat-conversation messages.</p>', 'refs' => [ 'GetRetentionSettingsResponse$RetentionSettings' => '<p>The retention settings.</p>', 'PutRetentionSettingsRequest$RetentionSettings' => '<p>The retention settings.</p>', 'PutRetentionSettingsResponse$RetentionSettings' => '<p>The retention settings.</p>', ], ], 'Room' => [ 'base' => '<p>The Amazon Chime chat room details.</p>', 'refs' => [ 'CreateRoomResponse$Room' => '<p>The room details.</p>', 'GetRoomResponse$Room' => '<p>The room details.</p>', 'RoomList$member' => NULL, 'UpdateRoomResponse$Room' => '<p>The room details.</p>', ], ], 'RoomList' => [ 'base' => NULL, 'refs' => [ 'ListRoomsResponse$Rooms' => '<p>The room details.</p>', ], ], 'RoomMembership' => [ 'base' => '<p>The room membership details.</p>', 'refs' => [ 'CreateRoomMembershipResponse$RoomMembership' => '<p>The room membership details.</p>', 'RoomMembershipList$member' => NULL, 'UpdateRoomMembershipResponse$RoomMembership' => '<p>The room membership details.</p>', ], ], 'RoomMembershipList' => [ 'base' => NULL, 'refs' => [ 'ListRoomMembershipsResponse$RoomMemberships' => '<p>The room membership details.</p>', ], ], 'RoomMembershipRole' => [ 'base' => NULL, 'refs' => [ 'CreateRoomMembershipRequest$Role' => '<p>The role of the member.</p>', 'MembershipItem$Role' => '<p>The member role.</p>', 'RoomMembership$Role' => '<p>The membership role.</p>', 'UpdateRoomMembershipRequest$Role' => '<p>The role of the member.</p>', ], ], 'RoomRetentionSettings' => [ 'base' => '<p>The retention settings that determine how long to retain chat-room messages for an Amazon Chime Enterprise account.</p>', 'refs' => [ 'RetentionSettings$RoomRetentionSettings' => '<p>The chat room retention settings.</p>', ], ], 'SMAUpdateCallArgumentsMap' => [ 'base' => NULL, 'refs' => [ 'UpdateSipMediaApplicationCallRequest$Arguments' => '<p>Arguments made available to the Lambda function as part of the <code>CALL_UPDATE_REQUESTED</code> event. Can contain 0-20 key-value pairs.</p>', ], ], 'SearchAvailablePhoneNumbersRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchAvailablePhoneNumbersResponse' => [ 'base' => NULL, 'refs' => [], ], 'SelectedVideoStreams' => [ 'base' => '<p>The video streams to capture for a specified media capture pipeline. The total number of video streams can\'t exceed 25.</p>', 'refs' => [ 'SourceConfiguration$SelectedVideoStreams' => '<p>The selected video streams to capture for a specified media capture pipeline. The number of video streams can\'t exceed 25.</p>', ], ], 'SendChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendChannelMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'SensitiveString' => [ 'base' => NULL, 'refs' => [ 'AlexaForBusinessMetadata$AlexaForBusinessRoomArn' => '<p>The ARN of the room resource.</p>', 'Bot$DisplayName' => '<p>The bot display name.</p>', 'Bot$BotEmail' => '<p>The bot email address.</p>', 'Bot$SecurityToken' => '<p>The security token used to authenticate Amazon Chime with the outgoing event endpoint.</p>', 'CreateBotRequest$DisplayName' => '<p>The bot display name.</p>', 'CreateRoomRequest$Name' => '<p>The room name.</p>', 'Credential$Username' => '<p>The RFC2617 compliant user name associated with the SIP credentials, in US-ASCII format.</p>', 'Credential$Password' => '<p>The RFC2617 compliant password associated with the SIP credentials, in US-ASCII format.</p>', 'EventsConfiguration$OutboundEventsHTTPSEndpoint' => '<p>HTTPS endpoint that allows a bot to receive outgoing events.</p>', 'EventsConfiguration$LambdaFunctionArn' => '<p>Lambda function ARN that allows a bot to receive outgoing events.</p>', 'Member$Email' => '<p>The member email address.</p>', 'Member$FullName' => '<p>The member name.</p>', 'PutEventsConfigurationRequest$OutboundEventsHTTPSEndpoint' => '<p>HTTPS endpoint that allows the bot to receive outgoing events.</p>', 'PutEventsConfigurationRequest$LambdaFunctionArn' => '<p>Lambda function ARN that allows the bot to receive outgoing events.</p>', 'Room$Name' => '<p>The room name.</p>', 'SMAUpdateCallArgumentsMap$key' => NULL, 'SMAUpdateCallArgumentsMap$value' => NULL, 'SensitiveStringList$member' => NULL, 'SipHeadersMap$key' => NULL, 'SipHeadersMap$value' => NULL, 'UpdateRoomRequest$Name' => '<p>The room name.</p>', 'User$PrimaryProvisionedNumber' => '<p>The primary phone number associated with the user.</p>', 'User$DisplayName' => '<p>The display name of the user.</p>', ], ], 'SensitiveStringList' => [ 'base' => NULL, 'refs' => [ 'DeleteVoiceConnectorTerminationCredentialsRequest$Usernames' => '<p>The RFC2617 compliant username associated with the SIP credentials, in US-ASCII format.</p>', 'ListVoiceConnectorTerminationCredentialsResponse$Usernames' => '<p>A list of user names.</p>', ], ], 'ServiceFailureException' => [ 'base' => '<p>The service encountered an unexpected error.</p>', 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is currently unavailable.</p>', 'refs' => [], ], 'SigninDelegateGroup' => [ 'base' => '<p>An Active Directory (AD) group whose members are granted permission to act as delegates.</p>', 'refs' => [ 'SigninDelegateGroupList$member' => NULL, ], ], 'SigninDelegateGroupList' => [ 'base' => NULL, 'refs' => [ 'Account$SigninDelegateGroups' => '<p>The sign-in delegate groups associated with the account.</p>', 'AssociateSigninDelegateGroupsWithAccountRequest$SigninDelegateGroups' => '<p>The sign-in delegate groups.</p>', ], ], 'SipApplicationPriority' => [ 'base' => NULL, 'refs' => [ 'SipRuleTargetApplication$Priority' => '<p>Priority of the SIP media application in the target list.</p>', ], ], 'SipHeadersMap' => [ 'base' => NULL, 'refs' => [ 'CreateSipMediaApplicationCallRequest$SipHeaders' => '<p>The SIP headers added to an outbound call leg.</p>', ], ], 'SipMediaApplication' => [ 'base' => '<p>The details of the SIP media application, including name and endpoints. An AWS account can have multiple SIP media applications.</p>', 'refs' => [ 'CreateSipMediaApplicationResponse$SipMediaApplication' => '<p>The SIP media application details.</p>', 'GetSipMediaApplicationResponse$SipMediaApplication' => '<p>The SIP media application details.</p>', 'SipMediaApplicationList$member' => NULL, 'UpdateSipMediaApplicationResponse$SipMediaApplication' => '<p>The updated SIP media application details.</p>', ], ], 'SipMediaApplicationCall' => [ 'base' => '<p>A <code>Call</code> instance for a SIP media application.</p>', 'refs' => [ 'CreateSipMediaApplicationCallResponse$SipMediaApplicationCall' => '<p>The actual call.</p>', 'UpdateSipMediaApplicationCallResponse$SipMediaApplicationCall' => NULL, ], ], 'SipMediaApplicationEndpoint' => [ 'base' => '<p>The endpoint assigned to the SIP media application.</p>', 'refs' => [ 'SipMediaApplicationEndpointList$member' => NULL, ], ], 'SipMediaApplicationEndpointList' => [ 'base' => NULL, 'refs' => [ 'CreateSipMediaApplicationRequest$Endpoints' => '<p>List of endpoints (Lambda Amazon Resource Names) specified for the SIP media application. Currently, only one endpoint is supported.</p>', 'SipMediaApplication$Endpoints' => '<p>List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is permitted.</p>', 'UpdateSipMediaApplicationRequest$Endpoints' => '<p>The new set of endpoints for the specified SIP media application.</p>', ], ], 'SipMediaApplicationList' => [ 'base' => NULL, 'refs' => [ 'ListSipMediaApplicationsResponse$SipMediaApplications' => '<p>List of SIP media applications and application details.</p>', ], ], 'SipMediaApplicationLoggingConfiguration' => [ 'base' => '<p>Logging configuration of the SIP media application.</p>', 'refs' => [ 'GetSipMediaApplicationLoggingConfigurationResponse$SipMediaApplicationLoggingConfiguration' => '<p>The actual logging configuration.</p>', 'PutSipMediaApplicationLoggingConfigurationRequest$SipMediaApplicationLoggingConfiguration' => '<p>The actual logging configuration.</p>', 'PutSipMediaApplicationLoggingConfigurationResponse$SipMediaApplicationLoggingConfiguration' => NULL, ], ], 'SipMediaApplicationName' => [ 'base' => NULL, 'refs' => [ 'CreateSipMediaApplicationRequest$Name' => '<p>The SIP media application name.</p>', 'SipMediaApplication$Name' => '<p>The name of the SIP media application.</p>', 'UpdateSipMediaApplicationRequest$Name' => '<p>The new name for the specified SIP media application.</p>', ], ], 'SipRule' => [ 'base' => '<p>The SIP rule details, including name, triggers, and target applications. An AWS account can have multiple SIP rules.</p>', 'refs' => [ 'CreateSipRuleResponse$SipRule' => '<p>Returns the SIP rule information, including the rule ID, triggers, and target applications.</p>', 'GetSipRuleResponse$SipRule' => '<p>The SIP rule details.</p>', 'SipRuleList$member' => NULL, 'UpdateSipRuleResponse$SipRule' => '<p>Updated SIP rule details.</p>', ], ], 'SipRuleList' => [ 'base' => NULL, 'refs' => [ 'ListSipRulesResponse$SipRules' => '<p>List of SIP rules and rule details.</p>', ], ], 'SipRuleName' => [ 'base' => NULL, 'refs' => [ 'CreateSipRuleRequest$Name' => '<p>The name of the SIP rule.</p>', 'SipRule$Name' => '<p>The name of the SIP rule.</p>', 'UpdateSipRuleRequest$Name' => '<p>The new name for the specified SIP rule.</p>', ], ], 'SipRuleTargetApplication' => [ 'base' => '<p>Target SIP media application and other details, such as priority and AWS Region, to be specified in the SIP rule. Only one SIP rule per AWS Region can be provided.</p>', 'refs' => [ 'SipRuleTargetApplicationList$member' => NULL, ], ], 'SipRuleTargetApplicationList' => [ 'base' => NULL, 'refs' => [ 'CreateSipRuleRequest$TargetApplications' => '<p>List of SIP media applications with priority and AWS Region. Only one SIP application per AWS Region can be used.</p>', 'SipRule$TargetApplications' => '<p>Target SIP media application and other details, such as priority and AWS Region, to be specified in the SIP rule. Only one SIP rule per AWS Region can be provided.</p>', 'UpdateSipRuleRequest$TargetApplications' => '<p>The new value of the list of target applications.</p>', ], ], 'SipRuleTriggerType' => [ 'base' => NULL, 'refs' => [ 'CreateSipRuleRequest$TriggerType' => '<p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.</p>', 'SipRule$TriggerType' => '<p>The type of trigger assigned to the SIP rule in <code>TriggerValue</code>, currently <code>RequestUriHostname</code> or <code>ToPhoneNumber</code>.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListChannelMessagesRequest$SortOrder' => '<p>The order in which you want messages sorted. Default is Descending, based on time created.</p>', ], ], 'SourceConfiguration' => [ 'base' => '<p>Source configuration for a specified media capture pipeline.</p>', 'refs' => [ 'ChimeSdkMeetingConfiguration$SourceConfiguration' => '<p>The source configuration for a specified media capture pipline.</p>', ], ], 'StartMeetingTranscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartMeetingTranscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopMeetingTranscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopMeetingTranscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StreamingConfiguration' => [ 'base' => '<p>The streaming configuration associated with an Amazon Chime Voice Connector. Specifies whether media streaming is enabled for sending to Amazon Kinesis, and shows the retention period for the Amazon Kinesis data, in hours.</p>', 'refs' => [ 'GetVoiceConnectorStreamingConfigurationResponse$StreamingConfiguration' => '<p>The streaming configuration details.</p>', 'PutVoiceConnectorStreamingConfigurationRequest$StreamingConfiguration' => '<p>The streaming configuration details to add.</p>', 'PutVoiceConnectorStreamingConfigurationResponse$StreamingConfiguration' => '<p>The updated streaming configuration details.</p>', ], ], 'StreamingNotificationTarget' => [ 'base' => '<p>The targeted recipient for a streaming configuration notification.</p>', 'refs' => [ 'StreamingNotificationTargetList$member' => NULL, ], ], 'StreamingNotificationTargetList' => [ 'base' => NULL, 'refs' => [ 'StreamingConfiguration$StreamingNotificationTargets' => '<p>The streaming notification targets.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'Account$AwsAccountId' => '<p>The AWS account ID.</p>', 'Account$AccountId' => '<p>The Amazon Chime account ID.</p>', 'Account$Name' => '<p>The Amazon Chime account name.</p>', 'AssociatePhoneNumberWithUserRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'AssociatePhoneNumberWithUserRequest$UserId' => '<p>The user ID.</p>', 'BadRequestException$Message' => NULL, 'BatchCreateChannelMembershipError$ErrorMessage' => '<p>The error message.</p>', 'Bot$BotId' => '<p>The bot ID.</p>', 'Bot$UserId' => '<p>The unique ID for the bot user.</p>', 'BusinessCallingSettings$CdrBucket' => '<p>The Amazon S3 bucket designated for call detail record storage.</p>', 'ConflictException$Message' => NULL, 'CreateAttendeeError$ErrorCode' => '<p>The error code.</p>', 'CreateAttendeeError$ErrorMessage' => '<p>The error message.</p>', 'CreateMeetingRequest$MediaRegion' => '<p> The Region in which to create the meeting. Default: <code>us-east-1</code>. </p> <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>', 'CreateMeetingWithAttendeesRequest$MediaRegion' => '<p> The Region in which to create the meeting. Default: <code>us-east-1</code> . </p> <p> Available values: <code>af-south-1</code> , <code>ap-northeast-1</code> , <code>ap-northeast-2</code> , <code>ap-south-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> , <code>ca-central-1</code> , <code>eu-central-1</code> , <code>eu-north-1</code> , <code>eu-south-1</code> , <code>eu-west-1</code> , <code>eu-west-2</code> , <code>eu-west-3</code> , <code>sa-east-1</code> , <code>us-east-1</code> , <code>us-east-2</code> , <code>us-west-1</code> , <code>us-west-2</code> . </p>', 'CreateSipMediaApplicationRequest$AwsRegion' => '<p>The AWS Region assigned to the SIP media application.</p>', 'CreateUserRequest$Username' => '<p>The user name.</p>', 'DeletePhoneNumberRequest$PhoneNumberId' => '<p>The phone number ID.</p>', 'DisassociatePhoneNumberFromUserRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'DisassociatePhoneNumberFromUserRequest$UserId' => '<p>The user ID.</p>', 'EngineTranscribeMedicalSettings$VocabularyName' => '<p>The name of the vocabulary passed to Amazon Transcribe Medical.</p>', 'EngineTranscribeSettings$VocabularyFilterName' => '<p>The name of the vocabulary filter passed to Amazon Transcribe.</p>', 'EngineTranscribeSettings$VocabularyName' => '<p>The name of the vocabulary passed to Amazon Transcribe.</p>', 'EventsConfiguration$BotId' => '<p>The bot ID.</p>', 'ForbiddenException$Message' => NULL, 'GetPhoneNumberRequest$PhoneNumberId' => '<p>The phone number ID.</p>', 'GetUserSettingsRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'GetUserSettingsRequest$UserId' => '<p>The user ID.</p>', 'Invite$InviteId' => '<p>The invite ID.</p>', 'ListAccountsRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListAccountsResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListAttendeesRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListAttendeesResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListBotsRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListBotsResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListMediaCapturePipelinesRequest$NextToken' => '<p>The token used to retrieve the next page of results.</p>', 'ListMediaCapturePipelinesResponse$NextToken' => '<p>The token used to retrieve the next page of results. </p>', 'ListMeetingsRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListMeetingsResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListPhoneNumberOrdersRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListPhoneNumberOrdersResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListPhoneNumbersRequest$FilterValue' => '<p>The value to use for the filter.</p>', 'ListPhoneNumbersRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListPhoneNumbersResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListRoomMembershipsRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListRoomMembershipsResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListRoomsRequest$MemberId' => '<p>The member ID (user ID or bot ID).</p>', 'ListRoomsRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListRoomsResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListUsersRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListUsersResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListVoiceConnectorGroupsRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListVoiceConnectorGroupsResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListVoiceConnectorsRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListVoiceConnectorsResponse$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'Meeting$MediaRegion' => '<p>The Region in which you create the meeting. Available values: <code>af-south-1</code>, <code>ap-northeast-1</code>, <code>ap-northeast-2</code>, <code>ap-south-1</code>, <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>, <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-south-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>, <code>us-west-1</code>, <code>us-west-2</code>.</p>', 'MemberError$ErrorMessage' => '<p>The error message.</p>', 'NonEmptyStringList$member' => NULL, 'NotFoundException$Message' => NULL, 'OriginationRoute$Host' => '<p>The FQDN or IP address to contact for origination traffic.</p>', 'PhoneNumber$PhoneNumberId' => '<p>The phone number ID.</p>', 'PhoneNumberAssociation$Value' => '<p>Contains the ID for the entity specified in Name.</p>', 'PhoneNumberError$ErrorMessage' => '<p>The error message.</p>', 'ResourceLimitExceededException$Message' => NULL, 'SearchAvailablePhoneNumbersRequest$AreaCode' => '<p>The area code used to filter results. Only applies to the US.</p>', 'SearchAvailablePhoneNumbersRequest$City' => '<p>The city used to filter results. Only applies to the US.</p>', 'SearchAvailablePhoneNumbersRequest$State' => '<p>The state used to filter results. Required only if you provide <code>City</code>. Only applies to the US.</p>', 'SearchAvailablePhoneNumbersRequest$NextToken' => '<p>The token used to retrieve the next page of results.</p>', 'SearchAvailablePhoneNumbersResponse$NextToken' => '<p>The token used to retrieve the next page of search results.</p>', 'ServiceFailureException$Message' => NULL, 'ServiceUnavailableException$Message' => NULL, 'SipMediaApplication$AwsRegion' => '<p>The AWS Region in which the SIP media application is created.</p>', 'SipRuleTargetApplication$AwsRegion' => '<p>The AWS Region of the target application.</p>', 'StringList$member' => NULL, 'TerminationHealth$Source' => '<p>The source IP address.</p>', 'ThrottledClientException$Message' => NULL, 'UnauthorizedClientException$Message' => NULL, 'UnprocessableEntityException$Message' => NULL, 'UpdatePhoneNumberRequest$PhoneNumberId' => '<p>The phone number ID.</p>', 'UpdateUserSettingsRequest$AccountId' => '<p>The Amazon Chime account ID.</p>', 'UpdateUserSettingsRequest$UserId' => '<p>The user ID.</p>', 'User$UserId' => '<p>The user ID.</p>', 'User$AccountId' => '<p>The Amazon Chime account ID.</p>', 'User$PersonalPIN' => '<p>The user\'s personal meeting PIN.</p>', 'UserError$ErrorMessage' => '<p>The error message.</p>', 'VoiceConnector$OutboundHostName' => '<p>The outbound host name for the Amazon Chime Voice Connector.</p>', 'VoiceConnectorSettings$CdrBucket' => '<p>The Amazon S3 bucket designated for call detail record storage.</p>', ], ], 'String128' => [ 'base' => NULL, 'refs' => [ 'ProxySession$Name' => '<p>The name of the proxy session.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'Proxy$PhoneNumberCountries' => '<p>The countries for proxy phone numbers to be selected from.</p>', 'Termination$CidrAllowedList' => '<p>The IP addresses allowed to make calls, in CIDR format. Required.</p>', ], ], 'Tag' => [ 'base' => '<p>Describes a tag applied to a resource.</p>', 'refs' => [ 'AttendeeTagList$member' => NULL, 'MeetingTagList$member' => NULL, 'TagList$member' => NULL, ], ], 'TagAttendeeRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'AttendeeTagKeyList$member' => NULL, 'MeetingTagKeyList$member' => NULL, 'Tag$Key' => '<p>The key of the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateAppInstanceRequest$Tags' => '<p>Tags assigned to the <code>AppInstanceUser</code>.</p>', 'CreateAppInstanceUserRequest$Tags' => '<p>Tags assigned to the <code>AppInstanceUser</code>.</p>', 'CreateChannelRequest$Tags' => '<p>The tags for the creation request.</p>', 'ListAttendeeTagsResponse$Tags' => '<p>A list of tag key-value pairs.</p>', 'ListMeetingTagsResponse$Tags' => '<p>A list of tag key-value pairs.</p>', 'ListTagsForResourceResponse$Tags' => '<p>A list of tag-key value pairs.</p>', 'TagResourceRequest$Tags' => '<p>The tag key-value pairs.</p>', ], ], 'TagMeetingRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'TelephonySettings' => [ 'base' => '<p>Settings that allow management of telephony permissions for an Amazon Chime user, such as inbound and outbound calling and text messaging.</p>', 'refs' => [ 'UserSettings$Telephony' => '<p>The telephony settings associated with the user.</p>', ], ], 'Termination' => [ 'base' => '<p>Termination settings enable your SIP hosts to make outbound calls using your Amazon Chime Voice Connector.</p>', 'refs' => [ 'GetVoiceConnectorTerminationResponse$Termination' => '<p>The termination setting details.</p>', 'PutVoiceConnectorTerminationRequest$Termination' => '<p>The termination setting details to add.</p>', 'PutVoiceConnectorTerminationResponse$Termination' => '<p>The updated termination setting details.</p>', ], ], 'TerminationHealth' => [ 'base' => '<p>The termination health details, including the source IP address and timestamp of the last successful SIP <code>OPTIONS</code> message from your SIP infrastructure.</p>', 'refs' => [ 'GetVoiceConnectorTerminationHealthResponse$TerminationHealth' => '<p>The termination health details.</p>', ], ], 'ThrottledClientException' => [ 'base' => '<p>The client exceeded its request rate limit.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AppInstance$CreatedTimestamp' => '<p>The time at which an <code>AppInstance</code> was created. In epoch milliseconds.</p>', 'AppInstance$LastUpdatedTimestamp' => '<p>The time an <code>AppInstance</code> was last updated. In epoch milliseconds.</p>', 'AppInstanceAdmin$CreatedTimestamp' => '<p>The time at which an administrator was created.</p>', 'AppInstanceUser$CreatedTimestamp' => '<p>The time at which the <code>AppInstanceUser</code> was created.</p>', 'AppInstanceUser$LastUpdatedTimestamp' => '<p>The time at which the <code>AppInstanceUser</code> was last updated.</p>', 'AppInstanceUserMembershipSummary$ReadMarkerTimestamp' => '<p>The time at which a message was last read.</p>', 'Channel$CreatedTimestamp' => '<p>The time at which the <code>AppInstanceUser</code> created the channel.</p>', 'Channel$LastMessageTimestamp' => '<p>The time at which a member sent the last message in the channel.</p>', 'Channel$LastUpdatedTimestamp' => '<p>The time at which a channel was last updated.</p>', 'ChannelBan$CreatedTimestamp' => '<p>The time at which the ban was created.</p>', 'ChannelMembership$CreatedTimestamp' => '<p>The time at which the channel membership was created.</p>', 'ChannelMembership$LastUpdatedTimestamp' => '<p>The time at which a channel membership was last updated.</p>', 'ChannelMessage$CreatedTimestamp' => '<p>The time at which the message was created.</p>', 'ChannelMessage$LastEditedTimestamp' => '<p>The time at which a message was edited.</p>', 'ChannelMessage$LastUpdatedTimestamp' => '<p>The time at which a message was updated.</p>', 'ChannelMessageSummary$CreatedTimestamp' => '<p>The time at which the message summary was created.</p>', 'ChannelMessageSummary$LastUpdatedTimestamp' => '<p>The time at which a message was last updated.</p>', 'ChannelMessageSummary$LastEditedTimestamp' => '<p>The time at which a message was last edited.</p>', 'ChannelModerator$CreatedTimestamp' => '<p>The time at which the moderator was created.</p>', 'ChannelSummary$LastMessageTimestamp' => '<p>The time at which the last message in a channel was sent.</p>', 'GetAppInstanceRetentionSettingsResponse$InitiateDeletionTimestamp' => '<p>The timestamp representing the time at which the specified items are retained, in Epoch Seconds.</p>', 'ListChannelMessagesRequest$NotBefore' => '<p>The initial or starting time stamp for your requested messages.</p>', 'ListChannelMessagesRequest$NotAfter' => '<p>The final or ending time stamp for your requested messages.</p>', 'PutAppInstanceRetentionSettingsResponse$InitiateDeletionTimestamp' => '<p>The time at which the API deletes data.</p>', ], ], 'TollFreePrefix' => [ 'base' => NULL, 'refs' => [ 'SearchAvailablePhoneNumbersRequest$TollFreePrefix' => '<p>The toll-free prefix that you use to filter results. Only applies to the US.</p>', ], ], 'TranscribeContentIdentificationType' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$ContentIdentificationType' => '<p>Set this field to <code>PII</code> to identify personal health information in the transcription output.</p>', ], ], 'TranscribeContentRedactionType' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$ContentRedactionType' => '<p>Set this field to <code>PII</code> to redact personally identifiable information in the transcription output. Content redaction is performed only upon complete transcription of the audio segments.</p>', ], ], 'TranscribeLanguageCode' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$LanguageCode' => '<p>The language code specified for the Amazon Transcribe engine.</p>', ], ], 'TranscribeLanguageModelName' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$LanguageModelName' => '<p>The name of the language model used during transcription.</p>', ], ], 'TranscribeMedicalContentIdentificationType' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeMedicalSettings$ContentIdentificationType' => '<p>Set this field to <code>PHI</code> to identify personal health information in the transcription output.</p>', ], ], 'TranscribeMedicalLanguageCode' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeMedicalSettings$LanguageCode' => '<p>The language code specified for the Amazon Transcribe Medical engine.</p>', ], ], 'TranscribeMedicalRegion' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeMedicalSettings$Region' => '<p>The AWS Region passed to Amazon Transcribe Medical. If you don\'t specify a Region, Amazon Chime uses the meeting\'s Region.</p>', ], ], 'TranscribeMedicalSpecialty' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeMedicalSettings$Specialty' => '<p>The specialty specified for the Amazon Transcribe Medical engine.</p>', ], ], 'TranscribeMedicalType' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeMedicalSettings$Type' => '<p>The type of transcription.</p>', ], ], 'TranscribePartialResultsStability' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$PartialResultsStability' => '<p>The stabity level of a partial results transcription. Determines how stable you want the transcription results to be. A higher level means the transcription results are less likely to change.</p>', ], ], 'TranscribePiiEntityTypes' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$PiiEntityTypes' => '<p>Lists the PII entity types you want to identify or redact. To specify entity types, you must enable <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p> <p> <code>PIIEntityTypes</code> must be comma-separated. The available values are: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING, CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, and <code>ALL</code>.</p> <p> <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.</p>', ], ], 'TranscribeRegion' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$Region' => '<p>The AWS Region passed to Amazon Transcribe. If you don\'t specify a Region, Amazon Chime uses the meeting\'s Region.</p>', ], ], 'TranscribeVocabularyFilterMethod' => [ 'base' => NULL, 'refs' => [ 'EngineTranscribeSettings$VocabularyFilterMethod' => '<p>The filtering method passed to Amazon Transcribe.</p>', ], ], 'TranscriptionConfiguration' => [ 'base' => '<p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>', 'refs' => [ 'StartMeetingTranscriptionRequest$TranscriptionConfiguration' => '<p>The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or <code>EngineTranscribeMedicalSettings</code>.</p>', ], ], 'UnauthorizedClientException' => [ 'base' => '<p>The client is not currently authorized to make the request.</p>', 'refs' => [], ], 'UnprocessableEntityException' => [ 'base' => '<p>The request was well-formed but was unable to be followed due to semantic errors.</p>', 'refs' => [], ], 'UntagAttendeeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagMeetingRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelReadMarkerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelReadMarkerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGlobalSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePhoneNumberRequestItem' => [ 'base' => '<p>The phone number ID, product type, or calling name fields to update, used with the <a>BatchUpdatePhoneNumber</a> and <a>UpdatePhoneNumber</a> actions.</p>', 'refs' => [ 'UpdatePhoneNumberRequestItemList$member' => NULL, ], ], 'UpdatePhoneNumberRequestItemList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdatePhoneNumberRequest$UpdatePhoneNumberRequestItems' => '<p>The request containing the phone number IDs and product types or calling names to update.</p>', ], ], 'UpdatePhoneNumberResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePhoneNumberSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProxySessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProxySessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoomMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoomMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoomRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoomResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSipMediaApplicationCallRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSipMediaApplicationCallResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSipMediaApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSipMediaApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSipRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSipRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserRequestItem' => [ 'base' => '<p>The user ID and user fields to update, used with the <a>BatchUpdateUser</a> action.</p>', 'refs' => [ 'UpdateUserRequestItemList$member' => NULL, ], ], 'UpdateUserRequestItemList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateUserRequest$UpdateUserRequestItems' => '<p>The request containing the user IDs and details to update.</p>', ], ], 'UpdateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVoiceConnectorGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVoiceConnectorGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVoiceConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVoiceConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'UriType' => [ 'base' => NULL, 'refs' => [ 'MediaPlacement$AudioHostUrl' => '<p>The audio host URL.</p>', 'MediaPlacement$AudioFallbackUrl' => '<p>The audio fallback URL.</p>', 'MediaPlacement$ScreenDataUrl' => '<p>The screen data URL.</p>', 'MediaPlacement$ScreenSharingUrl' => '<p>The screen sharing URL.</p>', 'MediaPlacement$ScreenViewingUrl' => '<p>The screen viewing URL.</p>', 'MediaPlacement$SignalingUrl' => '<p>The signaling URL.</p>', 'MediaPlacement$TurnControlUrl' => '<p>The turn control URL.</p>', 'MediaPlacement$EventIngestionUrl' => '<p>The event ingestion URL.</p>', ], ], 'UrlType' => [ 'base' => NULL, 'refs' => [ 'MessagingSessionEndpoint$Url' => '<p>The endpoint to which you establish a websocket connection.</p>', ], ], 'User' => [ 'base' => '<p>The user on the Amazon Chime account.</p>', 'refs' => [ 'CreateUserResponse$User' => NULL, 'GetUserResponse$User' => '<p>The user details.</p>', 'ResetPersonalPINResponse$User' => '<p>The user details and new personal meeting PIN.</p>', 'UpdateUserResponse$User' => '<p>The updated user details.</p>', 'UserList$member' => NULL, ], ], 'UserEmailList' => [ 'base' => NULL, 'refs' => [ 'InviteUsersRequest$UserEmailList' => '<p>The user email addresses to which to send the email invitation.</p>', ], ], 'UserError' => [ 'base' => '<p>The list of errors returned when errors are encountered during the <a>BatchSuspendUser</a>, <a>BatchUnsuspendUser</a>, or <a>BatchUpdateUser</a> actions. This includes user IDs, error codes, and error messages.</p>', 'refs' => [ 'UserErrorList$member' => NULL, ], ], 'UserErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchSuspendUserResponse$UserErrors' => '<p>If the <a>BatchSuspendUser</a> action fails for one or more of the user IDs in the request, a list of the user IDs is returned, along with error codes and error messages.</p>', 'BatchUnsuspendUserResponse$UserErrors' => '<p>If the <a>BatchUnsuspendUser</a> action fails for one or more of the user IDs in the request, a list of the user IDs is returned, along with error codes and error messages.</p>', 'BatchUpdateUserResponse$UserErrors' => '<p>If the <a>BatchUpdateUser</a> action fails for one or more of the user IDs in the request, a list of the user IDs is returned, along with error codes and error messages.</p>', ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'CreateAppInstanceUserRequest$AppInstanceUserId' => '<p>The user ID of the <code>AppInstance</code>.</p>', ], ], 'UserIdList' => [ 'base' => NULL, 'refs' => [ 'BatchSuspendUserRequest$UserIdList' => '<p>The request containing the user IDs to suspend.</p>', 'BatchUnsuspendUserRequest$UserIdList' => '<p>The request containing the user IDs to unsuspend.</p>', ], ], 'UserList' => [ 'base' => NULL, 'refs' => [ 'ListUsersResponse$Users' => '<p>List of users and user details.</p>', ], ], 'UserName' => [ 'base' => NULL, 'refs' => [ 'AppInstanceUser$Name' => '<p>The name of the <code>AppInstanceUser</code>.</p>', 'AppInstanceUserSummary$Name' => '<p>The name of an <code>AppInstanceUser</code>.</p>', 'CreateAppInstanceUserRequest$Name' => '<p>The user\'s name.</p>', 'UpdateAppInstanceUserRequest$Name' => '<p>The name of the <code>AppInstanceUser</code>.</p>', ], ], 'UserSettings' => [ 'base' => '<p>Settings associated with an Amazon Chime user, including inbound and outbound calling and text messaging.</p>', 'refs' => [ 'GetUserSettingsResponse$UserSettings' => '<p>The user settings.</p>', 'UpdateUserSettingsRequest$UserSettings' => '<p>The user settings to update.</p>', ], ], 'UserType' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$UserType' => '<p>The user type.</p>', 'InviteUsersRequest$UserType' => '<p>The user type.</p>', 'ListUsersRequest$UserType' => '<p>The user type.</p>', 'UpdateUserRequest$UserType' => '<p>The user type.</p>', 'UpdateUserRequestItem$UserType' => '<p>The user type.</p>', 'User$UserType' => '<p>The user type.</p>', ], ], 'VideoArtifactsConfiguration' => [ 'base' => '<p>The video artifact configuration object.</p>', 'refs' => [ 'ArtifactsConfiguration$Video' => '<p>The configuration for the video artifacts.</p>', ], ], 'VideoMuxType' => [ 'base' => NULL, 'refs' => [ 'VideoArtifactsConfiguration$MuxType' => '<p>The MUX type of the video artifact configuration object.</p>', ], ], 'VoiceConnector' => [ 'base' => '<p>The Amazon Chime Voice Connector configuration, including outbound host name and encryption settings.</p>', 'refs' => [ 'CreateVoiceConnectorResponse$VoiceConnector' => '<p>The Amazon Chime Voice Connector details.</p>', 'GetVoiceConnectorResponse$VoiceConnector' => '<p>The Amazon Chime Voice Connector details.</p>', 'UpdateVoiceConnectorResponse$VoiceConnector' => '<p>The updated Amazon Chime Voice Connector details.</p>', 'VoiceConnectorList$member' => NULL, ], ], 'VoiceConnectorAwsRegion' => [ 'base' => NULL, 'refs' => [ 'CreateVoiceConnectorRequest$AwsRegion' => '<p> The AWS Region in which the Amazon Chime Voice Connector is created. Default value: <code>us-east-1</code> . </p>', 'VoiceConnector$AwsRegion' => '<p> The AWS Region in which the Amazon Chime Voice Connector is created. Default: <code>us-east-1</code>. </p>', ], ], 'VoiceConnectorGroup' => [ 'base' => '<p>The Amazon Chime Voice Connector group configuration, including associated Amazon Chime Voice Connectors. You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault tolerant mechanism for fallback in case of availability events.</p>', 'refs' => [ 'CreateVoiceConnectorGroupResponse$VoiceConnectorGroup' => '<p>The Amazon Chime Voice Connector group details.</p>', 'GetVoiceConnectorGroupResponse$VoiceConnectorGroup' => '<p>The Amazon Chime Voice Connector group details.</p>', 'UpdateVoiceConnectorGroupResponse$VoiceConnectorGroup' => '<p>The updated Amazon Chime Voice Connector group details.</p>', 'VoiceConnectorGroupList$member' => NULL, ], ], 'VoiceConnectorGroupList' => [ 'base' => NULL, 'refs' => [ 'ListVoiceConnectorGroupsResponse$VoiceConnectorGroups' => '<p>The details of the Amazon Chime Voice Connector groups.</p>', ], ], 'VoiceConnectorGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateVoiceConnectorGroupRequest$Name' => '<p>The name of the Amazon Chime Voice Connector group.</p>', 'UpdateVoiceConnectorGroupRequest$Name' => '<p>The name of the Amazon Chime Voice Connector group.</p>', 'VoiceConnectorGroup$Name' => '<p>The name of the Amazon Chime Voice Connector group.</p>', ], ], 'VoiceConnectorItem' => [ 'base' => '<p>For Amazon Chime Voice Connector groups, the Amazon Chime Voice Connectors to which to route inbound calls. Includes priority configuration settings. Limit: 3 <code>VoiceConnectorItems</code> per Amazon Chime Voice Connector group.</p>', 'refs' => [ 'VoiceConnectorItemList$member' => NULL, ], ], 'VoiceConnectorItemList' => [ 'base' => NULL, 'refs' => [ 'CreateVoiceConnectorGroupRequest$VoiceConnectorItems' => '<p>The Amazon Chime Voice Connectors to route inbound calls to.</p>', 'UpdateVoiceConnectorGroupRequest$VoiceConnectorItems' => '<p>The <code>VoiceConnectorItems</code> to associate with the group.</p>', 'VoiceConnectorGroup$VoiceConnectorItems' => '<p>The Amazon Chime Voice Connectors to which to route inbound calls.</p>', ], ], 'VoiceConnectorItemPriority' => [ 'base' => NULL, 'refs' => [ 'VoiceConnectorItem$Priority' => '<p>The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher priority Amazon Chime Voice Connectors are attempted first.</p>', ], ], 'VoiceConnectorList' => [ 'base' => NULL, 'refs' => [ 'ListVoiceConnectorsResponse$VoiceConnectors' => '<p>The details of the Amazon Chime Voice Connectors.</p>', ], ], 'VoiceConnectorName' => [ 'base' => NULL, 'refs' => [ 'CreateVoiceConnectorRequest$Name' => '<p>The name of the Amazon Chime Voice Connector.</p>', 'UpdateVoiceConnectorRequest$Name' => '<p>The name of the Amazon Chime Voice Connector.</p>', 'VoiceConnector$Name' => '<p>The name of the Amazon Chime Voice Connector.</p>', ], ], 'VoiceConnectorSettings' => [ 'base' => '<p>The Amazon Chime Voice Connector settings. Includes any Amazon S3 buckets designated for storing call detail records.</p>', 'refs' => [ 'GetGlobalSettingsResponse$VoiceConnector' => '<p>The Amazon Chime Voice Connector settings.</p>', 'UpdateGlobalSettingsRequest$VoiceConnector' => '<p>The Amazon Chime Voice Connector settings.</p>', ], ], ],];
