<?php
// This file was auto-generated from sdk-root/src/data/cloudfront/2020-05-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon CloudFront</fullname> <p>This is the <i>Amazon CloudFront API Reference</i>. This guide is for developers who need detailed information about CloudFront API actions, data types, and errors. For detailed information about CloudFront features, see the <i>Amazon CloudFront Developer Guide</i>.</p>', 'operations' => [ 'AssociateAlias' => '<p>Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront distribution.</p> <p>With this operation you can move an alias that’s already in use on a CloudFront distribution to a different distribution in one step. This prevents the downtime that could occur if you first remove the alias from one distribution and then separately add the alias to another distribution.</p> <p>To use this operation to associate an alias with a distribution, you provide the alias and the ID of the target distribution for the alias. For more information, including how to set up the target distribution, prerequisites that you must complete, and other restrictions, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move">Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'CreateCachePolicy' => '<p>Creates a cache policy.</p> <p>After you create a cache policy, you can attach it to one or more cache behaviors. When it’s attached to a cache behavior, the cache policy determines the following:</p> <ul> <li> <p>The values that CloudFront includes in the <i>cache key</i>. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.</p> </li> <li> <p>The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.</p> </li> </ul> <p>The headers, cookies, and query strings that are included in the cache key are automatically included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t find an object in its cache that matches the request’s cache key. If you want to send values to the origin but <i>not</i> include them in the cache key, use <code>OriginRequestPolicy</code>.</p> <p>For more information about cache policies, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html">Controlling the cache key</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'CreateCloudFrontOriginAccessIdentity' => '<p>Creates a new origin access identity. If you\'re using Amazon S3 for your origin, you can use an origin access identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more information about how to use origin access identities, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'CreateDistribution' => '<p>Creates a new web distribution. You create a CloudFront distribution to tell CloudFront where you want content to be delivered from, and the details about how to track and manage content delivery. Send a <code>POST</code> request to the <code>/<i>CloudFront API version</i>/distribution</code>/<code>distribution ID</code> resource.</p> <important> <p>When you update a distribution, there are more required fields than when you create a distribution. When you update your distribution by using <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution</a>, follow the steps included in the documentation to get the current configuration and then make your updates. This helps to make sure that you include all of the required fields. To view a summary, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html">Required Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> </important>', 'CreateDistributionWithTags' => '<p>Create a new distribution with tags.</p>', 'CreateFieldLevelEncryptionConfig' => '<p>Create a new field-level encryption configuration.</p>', 'CreateFieldLevelEncryptionProfile' => '<p>Create a field-level encryption profile.</p>', 'CreateFunction' => '<p>Creates a CloudFront function.</p> <p>To create a function, you provide the function code and some configuration information about the function. The response contains an Amazon Resource Name (ARN) that uniquely identifies the function.</p> <p>When you create a function, it’s in the <code>DEVELOPMENT</code> stage. In this stage, you can test the function with <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.</p> <p>When you’re ready to use your function with a CloudFront distribution, use <code>PublishFunction</code> to copy the function from the <code>DEVELOPMENT</code> stage to <code>LIVE</code>. When it’s live, you can attach the function to a distribution’s cache behavior, using the function’s ARN.</p>', 'CreateInvalidation' => '<p>Create a new invalidation. </p>', 'CreateKeyGroup' => '<p>Creates a key group that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed URLs and signed cookies</a>.</p> <p>To create a key group, you must specify at least one public key for the key group. After you create a key group, you can reference it from one or more cache behaviors. When you reference a key group in a cache behavior, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'CreateMonitoringSubscription' => '<p>Enables additional CloudWatch metrics for the specified CloudFront distribution. The additional metrics incur an additional cost.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional">Viewing additional CloudFront distribution metrics</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'CreateOriginRequestPolicy' => '<p>Creates an origin request policy.</p> <p>After you create an origin request policy, you can attach it to one or more cache behaviors. When it’s attached to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:</p> <ul> <li> <p>The request body and the URL path (without the domain name) from the viewer request.</p> </li> <li> <p>The headers that CloudFront automatically includes in every origin request, including <code>Host</code>, <code>User-Agent</code>, and <code>X-Amz-Cf-Id</code>.</p> </li> <li> <p>All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.</p> </li> </ul> <p>CloudFront sends a request when it can’t find a valid object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use <code>CachePolicy</code>.</p> <p>For more information about origin request policies, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html">Controlling origin requests</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'CreatePublicKey' => '<p>Uploads a public key to CloudFront that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>', 'CreateRealtimeLogConfig' => '<p>Creates a real-time log configuration.</p> <p>After you create a real-time log configuration, you can attach it to one or more cache behaviors to send real-time log data to the specified Amazon Kinesis data stream.</p> <p>For more information about real-time log configurations, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'CreateResponseHeadersPolicy' => '<p>Creates a response headers policy.</p> <p>A response headers policy contains information about a set of HTTP response headers and their values. To create a response headers policy, you provide some metadata about the policy, and a set of configurations that specify the response headers.</p> <p>After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a CloudFront distribution. When it’s attached to a cache behavior, CloudFront adds the headers in the policy to HTTP responses that it sends for requests that match the cache behavior.</p>', 'CreateStreamingDistribution' => '<p>This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the announcement</a> on the Amazon CloudFront discussion forum.</p>', 'CreateStreamingDistributionWithTags' => '<p>This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the announcement</a> on the Amazon CloudFront discussion forum.</p>', 'DeleteCachePolicy' => '<p>Deletes a cache policy.</p> <p>You cannot delete a cache policy if it’s attached to a cache behavior. First update your distributions to remove the cache policy from all cache behaviors, then delete the cache policy.</p> <p>To delete a cache policy, you must provide the policy’s identifier and version. To get these values, you can use <code>ListCachePolicies</code> or <code>GetCachePolicy</code>.</p>', 'DeleteCloudFrontOriginAccessIdentity' => '<p>Delete an origin access identity. </p>', 'DeleteDistribution' => '<p>Delete a distribution. </p>', 'DeleteFieldLevelEncryptionConfig' => '<p>Remove a field-level encryption configuration.</p>', 'DeleteFieldLevelEncryptionProfile' => '<p>Remove a field-level encryption profile.</p>', 'DeleteFunction' => '<p>Deletes a CloudFront function.</p> <p>You cannot delete a function if it’s associated with a cache behavior. First, update your distributions to remove the function association from all cache behaviors, then delete the function.</p> <p>To delete a function, you must provide the function’s name and version (<code>ETag</code> value). To get these values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.</p>', 'DeleteKeyGroup' => '<p>Deletes a key group.</p> <p>You cannot delete a key group that is referenced in a cache behavior. First update your distributions to remove the key group from all cache behaviors, then delete the key group.</p> <p>To delete a key group, you must provide the key group’s identifier and version. To get these values, use <code>ListKeyGroups</code> followed by <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.</p>', 'DeleteMonitoringSubscription' => '<p>Disables additional CloudWatch metrics for the specified CloudFront distribution.</p>', 'DeleteOriginRequestPolicy' => '<p>Deletes an origin request policy.</p> <p>You cannot delete an origin request policy if it’s attached to any cache behaviors. First update your distributions to remove the origin request policy from all cache behaviors, then delete the origin request policy.</p> <p>To delete an origin request policy, you must provide the policy’s identifier and version. To get the identifier, you can use <code>ListOriginRequestPolicies</code> or <code>GetOriginRequestPolicy</code>.</p>', 'DeletePublicKey' => '<p>Remove a public key you previously added to CloudFront.</p>', 'DeleteRealtimeLogConfig' => '<p>Deletes a real-time log configuration.</p> <p>You cannot delete a real-time log configuration if it’s attached to a cache behavior. First update your distributions to remove the real-time log configuration from all cache behaviors, then delete the real-time log configuration.</p> <p>To delete a real-time log configuration, you can provide the configuration’s name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to delete.</p>', 'DeleteResponseHeadersPolicy' => '<p>Deletes a response headers policy.</p> <p>You cannot delete a response headers policy if it’s attached to a cache behavior. First update your distributions to remove the response headers policy from all cache behaviors, then delete the response headers policy.</p> <p>To delete a response headers policy, you must provide the policy’s identifier and version. To get these values, you can use <code>ListResponseHeadersPolicies</code> or <code>GetResponseHeadersPolicy</code>. </p>', 'DeleteStreamingDistribution' => '<p>Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following steps.</p> <p> <b>To delete an RTMP distribution using the CloudFront API</b>:</p> <ol> <li> <p>Disable the RTMP distribution.</p> </li> <li> <p>Submit a <code>GET Streaming Distribution Config</code> request to get the current configuration and the <code>Etag</code> header for the distribution. </p> </li> <li> <p>Update the XML document that was returned in the response to your <code>GET Streaming Distribution Config</code> request to change the value of <code>Enabled</code> to <code>false</code>.</p> </li> <li> <p>Submit a <code>PUT Streaming Distribution Config</code> request to update the configuration for your distribution. In the request body, include the XML document that you updated in Step 3. Then set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the <code>GET Streaming Distribution Config</code> request in Step 2.</p> </li> <li> <p>Review the response to the <code>PUT Streaming Distribution Config</code> request to confirm that the distribution was successfully disabled.</p> </li> <li> <p>Submit a <code>GET Streaming Distribution Config</code> request to confirm that your changes have propagated. When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.</p> </li> <li> <p>Submit a <code>DELETE Streaming Distribution</code> request. Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the <code>GET Streaming Distribution Config</code> request in Step 2.</p> </li> <li> <p>Review the response to your <code>DELETE Streaming Distribution</code> request to confirm that the distribution was successfully deleted.</p> </li> </ol> <p>For information about deleting a distribution using the CloudFront console, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'DescribeFunction' => '<p>Gets configuration information and metadata about a CloudFront function, but not the function’s code. To get a function’s code, use <code>GetFunction</code>.</p> <p>To get configuration information and metadata about a function, you must provide the function’s name and stage. To get these values, you can use <code>ListFunctions</code>.</p>', 'GetCachePolicy' => '<p>Gets a cache policy, including the following metadata:</p> <ul> <li> <p>The policy’s identifier.</p> </li> <li> <p>The date and time when the policy was last modified.</p> </li> </ul> <p>To get a cache policy, you must provide the policy’s identifier. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>', 'GetCachePolicyConfig' => '<p>Gets a cache policy configuration.</p> <p>To get a cache policy configuration, you must provide the policy’s identifier. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>', 'GetCloudFrontOriginAccessIdentity' => '<p>Get the information about an origin access identity. </p>', 'GetCloudFrontOriginAccessIdentityConfig' => '<p>Get the configuration information about an origin access identity. </p>', 'GetDistribution' => '<p>Get the information about a distribution.</p>', 'GetDistributionConfig' => '<p>Get the configuration information about a distribution. </p>', 'GetFieldLevelEncryption' => '<p>Get the field-level encryption configuration information.</p>', 'GetFieldLevelEncryptionConfig' => '<p>Get the field-level encryption configuration information.</p>', 'GetFieldLevelEncryptionProfile' => '<p>Get the field-level encryption profile information.</p>', 'GetFieldLevelEncryptionProfileConfig' => '<p>Get the field-level encryption profile configuration information.</p>', 'GetFunction' => '<p>Gets the code of a CloudFront function. To get configuration information and metadata about a function, use <code>DescribeFunction</code>.</p> <p>To get a function’s code, you must provide the function’s name and stage. To get these values, you can use <code>ListFunctions</code>.</p>', 'GetInvalidation' => '<p>Get the information about an invalidation. </p>', 'GetKeyGroup' => '<p>Gets a key group, including the date and time when the key group was last modified.</p> <p>To get a key group, you must provide the key group’s identifier. If the key group is referenced in a distribution’s cache behavior, you can get the key group’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier using <code>ListKeyGroups</code>.</p>', 'GetKeyGroupConfig' => '<p>Gets a key group configuration.</p> <p>To get a key group configuration, you must provide the key group’s identifier. If the key group is referenced in a distribution’s cache behavior, you can get the key group’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier using <code>ListKeyGroups</code>.</p>', 'GetMonitoringSubscription' => '<p>Gets information about whether additional CloudWatch metrics are enabled for the specified CloudFront distribution.</p>', 'GetOriginRequestPolicy' => '<p>Gets an origin request policy, including the following metadata:</p> <ul> <li> <p>The policy’s identifier.</p> </li> <li> <p>The date and time when the policy was last modified.</p> </li> </ul> <p>To get an origin request policy, you must provide the policy’s identifier. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>', 'GetOriginRequestPolicyConfig' => '<p>Gets an origin request policy configuration.</p> <p>To get an origin request policy configuration, you must provide the policy’s identifier. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>', 'GetPublicKey' => '<p>Gets a public key.</p>', 'GetPublicKeyConfig' => '<p>Gets a public key configuration.</p>', 'GetRealtimeLogConfig' => '<p>Gets a real-time log configuration.</p> <p>To get a real-time log configuration, you can provide the configuration’s name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to get.</p>', 'GetResponseHeadersPolicy' => '<p>Gets a response headers policy, including metadata (the policy’s identifier and the date and time when the policy was last modified).</p> <p>To get a response headers policy, you must provide the policy’s identifier. If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>', 'GetResponseHeadersPolicyConfig' => '<p>Gets a response headers policy configuration.</p> <p>To get a response headers policy configuration, you must provide the policy’s identifier. If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>', 'GetStreamingDistribution' => '<p>Gets information about a specified RTMP distribution, including the distribution configuration.</p>', 'GetStreamingDistributionConfig' => '<p>Get the configuration information about a streaming distribution. </p>', 'ListCachePolicies' => '<p>Gets a list of cache policies.</p> <p>You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the custom policies created in your Amazon Web Services account.</p> <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>', 'ListCloudFrontOriginAccessIdentities' => '<p>Lists origin access identities.</p>', 'ListConflictingAliases' => '<p>Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or overlap with the provided alias, and the associated CloudFront distributions and Amazon Web Services accounts for each conflicting alias. In the returned list, the distribution and account IDs are partially hidden, which allows you to identify the distributions and accounts that you own, but helps to protect the information of ones that you don’t own.</p> <p>Use this operation to find aliases that are in use in CloudFront that conflict or overlap with the provided alias. For example, if you provide <code>www.example.com</code> as input, the returned list can include <code>www.example.com</code> and the overlapping wildcard alternate domain name (<code>*.example.com</code>), if they exist. If you provide <code>*.example.com</code> as input, the returned list can include <code>*.example.com</code> and any alternate domain names covered by that wildcard (for example, <code>www.example.com</code>, <code>test.example.com</code>, <code>dev.example.com</code>, and so on), if they exist.</p> <p>To list conflicting aliases, you provide the alias to search and the ID of a distribution in your account that has an attached SSL/TLS certificate that includes the provided alias. For more information, including how to set up the distribution and certificate, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move">Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>', 'ListDistributions' => '<p>List CloudFront distributions.</p>', 'ListDistributionsByCachePolicyId' => '<p>Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified cache policy.</p> <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>', 'ListDistributionsByKeyGroup' => '<p>Gets a list of distribution IDs for distributions that have a cache behavior that references the specified key group.</p> <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>', 'ListDistributionsByOriginRequestPolicyId' => '<p>Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified origin request policy.</p> <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>', 'ListDistributionsByRealtimeLogConfig' => '<p>Gets a list of distributions that have a cache behavior that’s associated with the specified real-time log configuration.</p> <p>You can specify the real-time log configuration by its name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to list distributions for.</p> <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request. </p>', 'ListDistributionsByResponseHeadersPolicyId' => '<p>Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified response headers policy.</p> <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>', 'ListDistributionsByWebACLId' => '<p>List the distributions that are associated with a specified WAF web ACL.</p>', 'ListFieldLevelEncryptionConfigs' => '<p>List all field-level encryption configurations that have been created in CloudFront for this account.</p>', 'ListFieldLevelEncryptionProfiles' => '<p>Request a list of field-level encryption profiles that have been created in CloudFront for this account.</p>', 'ListFunctions' => '<p>Gets a list of all CloudFront functions in your Amazon Web Services account.</p> <p>You can optionally apply a filter to return only the functions that are in the specified stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p> <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>', 'ListInvalidations' => '<p>Lists invalidation batches. </p>', 'ListKeyGroups' => '<p>Gets a list of key groups.</p> <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>', 'ListOriginRequestPolicies' => '<p>Gets a list of origin request policies.</p> <p>You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the custom policies created in your Amazon Web Services account.</p> <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>', 'ListPublicKeys' => '<p>List all public keys that have been added to CloudFront for this account.</p>', 'ListRealtimeLogConfigs' => '<p>Gets a list of real-time log configurations.</p> <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request. </p>', 'ListResponseHeadersPolicies' => '<p>Gets a list of response headers policies.</p> <p>You can optionally apply a filter to get only the managed policies created by Amazon Web Services, or only the custom policies created in your Amazon Web Services account.</p> <p>You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current response as the <code>Marker</code> value in the subsequent request.</p>', 'ListStreamingDistributions' => '<p>List streaming distributions. </p>', 'ListTagsForResource' => '<p>List tags for a CloudFront resource.</p>', 'PublishFunction' => '<p>Publishes a CloudFront function by copying the function code from the <code>DEVELOPMENT</code> stage to <code>LIVE</code>. This automatically updates all cache behaviors that are using this function to use the newly published copy in the <code>LIVE</code> stage.</p> <p>When a function is published to the <code>LIVE</code> stage, you can attach the function to a distribution’s cache behavior, using the function’s Amazon Resource Name (ARN).</p> <p>To publish a function, you must provide the function’s name and version (<code>ETag</code> value). To get these values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.</p>', 'TagResource' => '<p>Add tags to a CloudFront resource.</p>', 'TestFunction' => '<p>Tests a CloudFront function.</p> <p>To test a function, you provide an <i>event object</i> that represents an HTTP request or response that your CloudFront distribution could receive in production. CloudFront runs the function, passing it the event object that you provided, and returns the function’s result (the modified event object) in the response. The response also contains function logs and error messages, if any exist. For more information about testing functions, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>To test a function, you provide the function’s name and version (<code>ETag</code> value) along with the event object. To get the function’s name and version, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.</p>', 'UntagResource' => '<p>Remove tags from a CloudFront resource.</p>', 'UpdateCachePolicy' => '<p>Updates a cache policy configuration.</p> <p>When you update a cache policy configuration, all the fields are updated with the values provided in the request. You cannot update some fields independent of others. To update a cache policy configuration:</p> <ol> <li> <p>Use <code>GetCachePolicyConfig</code> to get the current configuration.</p> </li> <li> <p>Locally modify the fields in the cache policy configuration that you want to update.</p> </li> <li> <p>Call <code>UpdateCachePolicy</code> by providing the entire cache policy configuration, including the fields that you modified and those that you didn’t.</p> </li> </ol>', 'UpdateCloudFrontOriginAccessIdentity' => '<p>Update an origin access identity. </p>', 'UpdateDistribution' => '<p>Updates the configuration for a web distribution. </p> <important> <p>When you update a distribution, there are more required fields than when you create a distribution. When you update your distribution by using this API action, follow the steps here to get the current configuration and then make your updates, to make sure that you include all of the required fields. To view a summary, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html">Required Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> </important> <p>The update process includes getting the current distribution configuration, updating the XML document that is returned to make your changes, and then submitting an <code>UpdateDistribution</code> request to make the updates.</p> <p>For information about updating a distribution using the CloudFront console instead, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html">Creating a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p> <b>To update a web distribution using the CloudFront API</b> </p> <ol> <li> <p>Submit a <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html">GetDistributionConfig</a> request to get the current configuration and an <code>Etag</code> header for the distribution.</p> <note> <p>If you update the distribution again, you must get a new <code>Etag</code> header.</p> </note> </li> <li> <p>Update the XML document that was returned in the response to your <code>GetDistributionConfig</code> request to include your changes. </p> <important> <p>When you edit the XML file, be aware of the following:</p> <ul> <li> <p>You must strip out the ETag parameter that is returned.</p> </li> <li> <p>Additional fields are required when you update a distribution. There may be fields included in the XML file for features that you haven\'t configured for your distribution. This is expected and required to successfully update the distribution.</p> </li> <li> <p>You can\'t change the value of <code>CallerReference</code>. If you try to change this value, CloudFront returns an <code>IllegalUpdate</code> error. </p> </li> <li> <p>The new configuration replaces the existing configuration; the values that you specify in an <code>UpdateDistribution</code> request are not merged into your existing configuration. When you add, delete, or replace values in an element that allows multiple values (for example, <code>CNAME</code>), you must specify all of the values that you want to appear in the updated distribution. In addition, you must update the corresponding <code>Quantity</code> element.</p> </li> </ul> </important> </li> <li> <p>Submit an <code>UpdateDistribution</code> request to update the configuration for your distribution:</p> <ul> <li> <p>In the request body, include the XML document that you updated in Step 2. The request body must include an XML document with a <code>DistributionConfig</code> element.</p> </li> <li> <p>Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the <code>GetDistributionConfig</code> request in Step 1.</p> </li> </ul> </li> <li> <p>Review the response to the <code>UpdateDistribution</code> request to confirm that the configuration was successfully updated.</p> </li> <li> <p>Optional: Submit a <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html">GetDistribution</a> request to confirm that your changes have propagated. When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.</p> </li> </ol>', 'UpdateFieldLevelEncryptionConfig' => '<p>Update a field-level encryption configuration. </p>', 'UpdateFieldLevelEncryptionProfile' => '<p>Update a field-level encryption profile. </p>', 'UpdateFunction' => '<p>Updates a CloudFront function.</p> <p>You can update a function’s code or the comment that describes the function. You cannot update a function’s name.</p> <p>To update a function, you provide the function’s name and version (<code>ETag</code> value) along with the updated function code. To get the name and version, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.</p>', 'UpdateKeyGroup' => '<p>Updates a key group.</p> <p>When you update a key group, all the fields are updated with the values provided in the request. You cannot update some fields independent of others. To update a key group:</p> <ol> <li> <p>Get the current key group with <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.</p> </li> <li> <p>Locally modify the fields in the key group that you want to update. For example, add or remove public key IDs.</p> </li> <li> <p>Call <code>UpdateKeyGroup</code> with the entire key group object, including the fields that you modified and those that you didn’t.</p> </li> </ol>', 'UpdateOriginRequestPolicy' => '<p>Updates an origin request policy configuration.</p> <p>When you update an origin request policy configuration, all the fields are updated with the values provided in the request. You cannot update some fields independent of others. To update an origin request policy configuration:</p> <ol> <li> <p>Use <code>GetOriginRequestPolicyConfig</code> to get the current configuration.</p> </li> <li> <p>Locally modify the fields in the origin request policy configuration that you want to update.</p> </li> <li> <p>Call <code>UpdateOriginRequestPolicy</code> by providing the entire origin request policy configuration, including the fields that you modified and those that you didn’t.</p> </li> </ol>', 'UpdatePublicKey' => '<p>Update public key information. Note that the only value you can change is the comment.</p>', 'UpdateRealtimeLogConfig' => '<p>Updates a real-time log configuration.</p> <p>When you update a real-time log configuration, all the parameters are updated with the values provided in the request. You cannot update some parameters independent of others. To update a real-time log configuration:</p> <ol> <li> <p>Call <code>GetRealtimeLogConfig</code> to get the current real-time log configuration.</p> </li> <li> <p>Locally modify the parameters in the real-time log configuration that you want to update.</p> </li> <li> <p>Call this API (<code>UpdateRealtimeLogConfig</code>) by providing the entire real-time log configuration, including the parameters that you modified and those that you didn’t.</p> </li> </ol> <p>You cannot update a real-time log configuration’s <code>Name</code> or <code>ARN</code>.</p>', 'UpdateResponseHeadersPolicy' => '<p>Updates a response headers policy.</p> <p>When you update a response headers policy, the entire policy is replaced. You cannot update some policy fields independent of others. To update a response headers policy configuration:</p> <ol> <li> <p>Use <code>GetResponseHeadersPolicyConfig</code> to get the current policy’s configuration.</p> </li> <li> <p>Modify the fields in the response headers policy configuration that you want to update.</p> </li> <li> <p>Call <code>UpdateResponseHeadersPolicy</code>, providing the entire response headers policy configuration, including the fields that you modified and those that you didn’t.</p> </li> </ol>', 'UpdateStreamingDistribution' => '<p>Update a streaming distribution. </p>', ], 'shapes' => [ 'AccessControlAllowHeadersList' => [ 'base' => NULL, 'refs' => [ 'ResponseHeadersPolicyAccessControlAllowHeaders$Items' => '<p>The list of HTTP header names. You can specify <code>*</code> to allow all headers.</p>', ], ], 'AccessControlAllowMethodsList' => [ 'base' => NULL, 'refs' => [ 'ResponseHeadersPolicyAccessControlAllowMethods$Items' => '<p>The list of HTTP methods. Valid values are:</p> <ul> <li> <p> <code>GET</code> </p> </li> <li> <p> <code>DELETE</code> </p> </li> <li> <p> <code>HEAD</code> </p> </li> <li> <p> <code>OPTIONS</code> </p> </li> <li> <p> <code>PATCH</code> </p> </li> <li> <p> <code>POST</code> </p> </li> <li> <p> <code>PUT</code> </p> </li> <li> <p> <code>ALL</code> </p> </li> </ul> <p> <code>ALL</code> is a special value that includes all of the listed HTTP methods.</p>', ], ], 'AccessControlAllowOriginsList' => [ 'base' => NULL, 'refs' => [ 'ResponseHeadersPolicyAccessControlAllowOrigins$Items' => '<p>The list of origins (domain names). You can specify <code>*</code> to allow all origins.</p>', ], ], 'AccessControlExposeHeadersList' => [ 'base' => NULL, 'refs' => [ 'ResponseHeadersPolicyAccessControlExposeHeaders$Items' => '<p>The list of HTTP headers. You can specify <code>*</code> to expose all headers.</p>', ], ], 'AccessDenied' => [ 'base' => '<p>Access denied.</p>', 'refs' => [], ], 'ActiveTrustedKeyGroups' => [ 'base' => '<p>A list of key groups, and the public keys in each key group, that CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>', 'refs' => [ 'Distribution$ActiveTrustedKeyGroups' => '<p>CloudFront automatically adds this field to the response if you’ve configured a cache behavior in this distribution to serve private content using key groups. This field contains a list of key groups and the public keys in each key group that CloudFront can use to verify the signatures of signed URLs or signed cookies.</p>', ], ], 'ActiveTrustedSigners' => [ 'base' => '<p>A list of Amazon Web Services accounts and the active CloudFront key pairs in each account that CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>', 'refs' => [ 'Distribution$ActiveTrustedSigners' => '<important> <p>We recommend using <code>TrustedKeyGroups</code> instead of <code>TrustedSigners</code>.</p> </important> <p>CloudFront automatically adds this field to the response if you’ve configured a cache behavior in this distribution to serve private content using trusted signers. This field contains a list of Amazon Web Services account IDs and the active CloudFront key pairs in each account that CloudFront can use to verify the signatures of signed URLs or signed cookies.</p>', 'StreamingDistribution$ActiveTrustedSigners' => '<p>A complex type that lists the Amazon Web Services accounts, if any, that you included in the <code>TrustedSigners</code> complex type for this distribution. These are the accounts that you want to allow to create signed URLs for private content.</p> <p>The <code>Signer</code> complex type lists the Amazon Web Services account number of the trusted signer or <code>self</code> if the signer is the Amazon Web Services account that created the distribution. The <code>Signer</code> element also includes the IDs of any active CloudFront key pairs that are associated with the trusted signer\'s Amazon Web Services account. If no <code>KeyPairId</code> element appears for a <code>Signer</code>, that signer can\'t create signed URLs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>', ], ], 'AliasICPRecordal' => [ 'base' => '<p>Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content publicly on an alternate domain name, also known as a CNAME, that they\'ve added to CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs associated with distributions. The status is returned in the CloudFront response; you can\'t configure it yourself.</p> <p>For more information about ICP recordals, see <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html"> Signup, Accounts, and Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.</p>', 'refs' => [ 'AliasICPRecordals$member' => NULL, ], ], 'AliasICPRecordals' => [ 'base' => NULL, 'refs' => [ 'Distribution$AliasICPRecordals' => '<p>Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content publicly on an alternate domain name, also known as a CNAME, that they\'ve added to CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs associated with distributions.</p> <p>For more information about ICP recordals, see <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html"> Signup, Accounts, and Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.</p>', 'DistributionSummary$AliasICPRecordals' => '<p>Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content publicly on an alternate domain name, also known as a CNAME, that they\'ve added to CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs associated with distributions.</p> <p>For more information about ICP recordals, see <a href="https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html"> Signup, Accounts, and Credentials</a> in <i>Getting Started with Amazon Web Services services in China</i>.</p>', ], ], 'AliasList' => [ 'base' => NULL, 'refs' => [ 'Aliases$Items' => '<p>A complex type that contains the CNAME aliases, if any, that you want to associate with this distribution.</p>', ], ], 'Aliases' => [ 'base' => '<p>A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution. </p>', 'refs' => [ 'DistributionConfig$Aliases' => '<p>A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.</p>', 'DistributionSummary$Aliases' => '<p>A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.</p>', 'StreamingDistributionConfig$Aliases' => '<p>A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming distribution. </p>', 'StreamingDistributionSummary$Aliases' => '<p>A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming distribution.</p>', ], ], 'AllowedMethods' => [ 'base' => '<p>A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:</p> <ul> <li> <p>CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.</p> </li> <li> <p>CloudFront forwards only <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code> requests.</p> </li> <li> <p>CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and <code>DELETE</code> requests.</p> </li> </ul> <p>If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can\'t perform operations that you don\'t want them to. For example, you might not want users to have permissions to delete objects from your origin.</p>', 'refs' => [ 'CacheBehavior$AllowedMethods' => NULL, 'DefaultCacheBehavior$AllowedMethods' => NULL, ], ], 'AssociateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'AwsAccountNumberList' => [ 'base' => NULL, 'refs' => [ 'TrustedSigners$Items' => '<p>A list of Amazon Web Services account identifiers.</p>', ], ], 'BatchTooLarge' => [ 'base' => '<p>Invalidation batch specified is too large.</p>', 'refs' => [], ], 'CNAMEAlreadyExists' => [ 'base' => '<p>The CNAME specified is already defined for CloudFront.</p>', 'refs' => [], ], 'CacheBehavior' => [ 'base' => '<p>A complex type that describes how CloudFront processes requests.</p> <p>You must create at least as many cache behaviors (including the default cache behavior) as you have origins if you want CloudFront to serve objects from all of the origins. Each cache behavior specifies the one origin from which you want CloudFront to get objects. If you have two origins and only the default cache behavior, the default cache behavior will cause CloudFront to get objects from one of the origins, but the other origin is never used.</p> <p>For the current quota (formerly known as limit) on the number of cache behaviors that you can add to a distribution, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you don’t want to specify any cache behaviors, include only an empty <code>CacheBehaviors</code> element. Don’t include an empty <code>CacheBehavior</code> element because this is invalid.</p> <p>To delete all cache behaviors in an existing distribution, update the distribution configuration and include only an empty <code>CacheBehaviors</code> element.</p> <p>To add, change, or remove one or more cache behaviors, update the distribution configuration and specify all of the cache behaviors that you want to include in the updated distribution.</p> <p>For more information about cache behaviors, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior">Cache Behavior Settings</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [ 'CacheBehaviorList$member' => NULL, ], ], 'CacheBehaviorList' => [ 'base' => NULL, 'refs' => [ 'CacheBehaviors$Items' => '<p>Optional: A complex type that contains cache behaviors for this distribution. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.</p>', ], ], 'CacheBehaviors' => [ 'base' => '<p>A complex type that contains zero or more <code>CacheBehavior</code> elements. </p>', 'refs' => [ 'DistributionConfig$CacheBehaviors' => '<p>A complex type that contains zero or more <code>CacheBehavior</code> elements. </p>', 'DistributionSummary$CacheBehaviors' => '<p>A complex type that contains zero or more <code>CacheBehavior</code> elements.</p>', ], ], 'CachePolicy' => [ 'base' => '<p>A cache policy.</p> <p>When it’s attached to a cache behavior, the cache policy determines the following:</p> <ul> <li> <p>The values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.</p> </li> <li> <p>The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.</p> </li> </ul> <p>The headers, cookies, and query strings that are included in the cache key are automatically included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t find a valid object in its cache that matches the request’s cache key. If you want to send values to the origin but <i>not</i> include them in the cache key, use <code>OriginRequestPolicy</code>.</p>', 'refs' => [ 'CachePolicySummary$CachePolicy' => '<p>The cache policy.</p>', 'CreateCachePolicyResult$CachePolicy' => '<p>A cache policy.</p>', 'GetCachePolicyResult$CachePolicy' => '<p>The cache policy.</p>', 'UpdateCachePolicyResult$CachePolicy' => '<p>A cache policy.</p>', ], ], 'CachePolicyAlreadyExists' => [ 'base' => '<p>A cache policy with this name already exists. You must provide a unique name. To modify an existing cache policy, use <code>UpdateCachePolicy</code>.</p>', 'refs' => [], ], 'CachePolicyConfig' => [ 'base' => '<p>A cache policy configuration.</p> <p>This configuration determines the following:</p> <ul> <li> <p>The values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.</p> </li> <li> <p>The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.</p> </li> </ul> <p>The headers, cookies, and query strings that are included in the cache key are automatically included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t find a valid object in its cache that matches the request’s cache key. If you want to send values to the origin but <i>not</i> include them in the cache key, use <code>OriginRequestPolicy</code>.</p>', 'refs' => [ 'CachePolicy$CachePolicyConfig' => '<p>The cache policy configuration.</p>', 'CreateCachePolicyRequest$CachePolicyConfig' => '<p>A cache policy configuration.</p>', 'GetCachePolicyConfigResult$CachePolicyConfig' => '<p>The cache policy configuration.</p>', 'UpdateCachePolicyRequest$CachePolicyConfig' => '<p>A cache policy configuration.</p>', ], ], 'CachePolicyCookieBehavior' => [ 'base' => NULL, 'refs' => [ 'CachePolicyCookiesConfig$CookieBehavior' => '<p>Determines whether any cookies in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values are:</p> <ul> <li> <p> <code>none</code> – Cookies in viewer requests are not included in the cache key and are not automatically included in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code>, any cookies that are listed in an <code>OriginRequestPolicy</code> <i>are</i> included in origin requests.</p> </li> <li> <p> <code>whitelist</code> – The cookies in viewer requests that are listed in the <code>CookieNames</code> type are included in the cache key and automatically included in requests that CloudFront sends to the origin.</p> </li> <li> <p> <code>allExcept</code> – All cookies in viewer requests that are <i> <b>not</b> </i> listed in the <code>CookieNames</code> type are included in the cache key and automatically included in requests that CloudFront sends to the origin.</p> </li> <li> <p> <code>all</code> – All cookies in viewer requests are included in the cache key and are automatically included in requests that CloudFront sends to the origin.</p> </li> </ul>', ], ], 'CachePolicyCookiesConfig' => [ 'base' => '<p>An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and automatically included in requests that CloudFront sends to the origin.</p>', 'refs' => [ 'ParametersInCacheKeyAndForwardedToOrigin$CookiesConfig' => '<p>An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache key and automatically included in requests that CloudFront sends to the origin.</p>', ], ], 'CachePolicyHeaderBehavior' => [ 'base' => NULL, 'refs' => [ 'CachePolicyHeadersConfig$HeaderBehavior' => '<p>Determines whether any HTTP headers are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values are:</p> <ul> <li> <p> <code>none</code> – HTTP headers are not included in the cache key and are not automatically included in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code>, any headers that are listed in an <code>OriginRequestPolicy</code> <i>are</i> included in origin requests.</p> </li> <li> <p> <code>whitelist</code> – The HTTP headers that are listed in the <code>Headers</code> type are included in the cache key and are automatically included in requests that CloudFront sends to the origin.</p> </li> </ul>', ], ], 'CachePolicyHeadersConfig' => [ 'base' => '<p>An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and automatically included in requests that CloudFront sends to the origin.</p>', 'refs' => [ 'ParametersInCacheKeyAndForwardedToOrigin$HeadersConfig' => '<p>An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and automatically included in requests that CloudFront sends to the origin.</p>', ], ], 'CachePolicyInUse' => [ 'base' => '<p>Cannot delete the cache policy because it is attached to one or more cache behaviors.</p>', 'refs' => [], ], 'CachePolicyList' => [ 'base' => '<p>A list of cache policies.</p>', 'refs' => [ 'ListCachePoliciesResult$CachePolicyList' => '<p>A list of cache policies.</p>', ], ], 'CachePolicyQueryStringBehavior' => [ 'base' => NULL, 'refs' => [ 'CachePolicyQueryStringsConfig$QueryStringBehavior' => '<p>Determines whether any URL query strings in viewer requests are included in the cache key and automatically included in requests that CloudFront sends to the origin. Valid values are:</p> <ul> <li> <p> <code>none</code> – Query strings in viewer requests are not included in the cache key and are not automatically included in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code>, any query strings that are listed in an <code>OriginRequestPolicy</code> <i>are</i> included in origin requests.</p> </li> <li> <p> <code>whitelist</code> – The query strings in viewer requests that are listed in the <code>QueryStringNames</code> type are included in the cache key and automatically included in requests that CloudFront sends to the origin.</p> </li> <li> <p> <code>allExcept</code> – All query strings in viewer requests that are <i> <b>not</b> </i> listed in the <code>QueryStringNames</code> type are included in the cache key and automatically included in requests that CloudFront sends to the origin.</p> </li> <li> <p> <code>all</code> – All query strings in viewer requests are included in the cache key and are automatically included in requests that CloudFront sends to the origin.</p> </li> </ul>', ], ], 'CachePolicyQueryStringsConfig' => [ 'base' => '<p>An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and automatically included in requests that CloudFront sends to the origin.</p>', 'refs' => [ 'ParametersInCacheKeyAndForwardedToOrigin$QueryStringsConfig' => '<p>An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and automatically included in requests that CloudFront sends to the origin.</p>', ], ], 'CachePolicySummary' => [ 'base' => '<p>Contains a cache policy.</p>', 'refs' => [ 'CachePolicySummaryList$member' => NULL, ], ], 'CachePolicySummaryList' => [ 'base' => NULL, 'refs' => [ 'CachePolicyList$Items' => '<p>Contains the cache policies in the list.</p>', ], ], 'CachePolicyType' => [ 'base' => NULL, 'refs' => [ 'CachePolicySummary$Type' => '<p>The type of cache policy, either <code>managed</code> (created by Amazon Web Services) or <code>custom</code> (created in this Amazon Web Services account).</p>', 'ListCachePoliciesRequest$Type' => '<p>A filter to return only the specified kinds of cache policies. Valid values are:</p> <ul> <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li> <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li> </ul>', ], ], 'CachedMethods' => [ 'base' => '<p>A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:</p> <ul> <li> <p>CloudFront caches responses to <code>GET</code> and <code>HEAD</code> requests.</p> </li> <li> <p>CloudFront caches responses to <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code> requests.</p> </li> </ul> <p>If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly. </p>', 'refs' => [ 'AllowedMethods$CachedMethods' => NULL, ], ], 'CannotChangeImmutablePublicKeyFields' => [ 'base' => '<p>You can\'t change the value of a public key.</p>', 'refs' => [], ], 'CertificateSource' => [ 'base' => NULL, 'refs' => [ 'ViewerCertificate$CertificateSource' => '<p>This field is deprecated. Use one of the following fields instead:</p> <ul> <li> <p> <code>ACMCertificateArn</code> </p> </li> <li> <p> <code>IAMCertificateId</code> </p> </li> <li> <p> <code>CloudFrontDefaultCertificate</code> </p> </li> </ul>', ], ], 'CloudFrontOriginAccessIdentity' => [ 'base' => '<p>CloudFront origin access identity.</p>', 'refs' => [ 'CreateCloudFrontOriginAccessIdentityResult$CloudFrontOriginAccessIdentity' => '<p>The origin access identity\'s information.</p>', 'GetCloudFrontOriginAccessIdentityResult$CloudFrontOriginAccessIdentity' => '<p>The origin access identity\'s information.</p>', 'UpdateCloudFrontOriginAccessIdentityResult$CloudFrontOriginAccessIdentity' => '<p>The origin access identity\'s information.</p>', ], ], 'CloudFrontOriginAccessIdentityAlreadyExists' => [ 'base' => '<p>If the <code>CallerReference</code> is a value you already sent in a previous request to create an identity but the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request, CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error. </p>', 'refs' => [], ], 'CloudFrontOriginAccessIdentityConfig' => [ 'base' => '<p>Origin access identity configuration. Send a <code>GET</code> request to the <code>/<i>CloudFront API version</i>/CloudFront/identity ID/config</code> resource. </p>', 'refs' => [ 'CloudFrontOriginAccessIdentity$CloudFrontOriginAccessIdentityConfig' => '<p>The current configuration information for the identity. </p>', 'CreateCloudFrontOriginAccessIdentityRequest$CloudFrontOriginAccessIdentityConfig' => '<p>The current configuration information for the identity.</p>', 'GetCloudFrontOriginAccessIdentityConfigResult$CloudFrontOriginAccessIdentityConfig' => '<p>The origin access identity\'s configuration information. </p>', 'UpdateCloudFrontOriginAccessIdentityRequest$CloudFrontOriginAccessIdentityConfig' => '<p>The identity\'s configuration information.</p>', ], ], 'CloudFrontOriginAccessIdentityInUse' => [ 'base' => '<p>The Origin Access Identity specified is already in use.</p>', 'refs' => [], ], 'CloudFrontOriginAccessIdentityList' => [ 'base' => '<p>Lists the origin access identities for CloudFront.Send a <code>GET</code> request to the <code>/<i>CloudFront API version</i>/origin-access-identity/cloudfront</code> resource. The response includes a <code>CloudFrontOriginAccessIdentityList</code> element with zero or more <code>CloudFrontOriginAccessIdentitySummary</code> child elements. By default, your entire list of origin access identities is returned in one single page. If the list is long, you can paginate it using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>', 'refs' => [ 'ListCloudFrontOriginAccessIdentitiesResult$CloudFrontOriginAccessIdentityList' => '<p>The <code>CloudFrontOriginAccessIdentityList</code> type. </p>', ], ], 'CloudFrontOriginAccessIdentitySummary' => [ 'base' => '<p>Summary of the information about a CloudFront origin access identity.</p>', 'refs' => [ 'CloudFrontOriginAccessIdentitySummaryList$member' => NULL, ], ], 'CloudFrontOriginAccessIdentitySummaryList' => [ 'base' => NULL, 'refs' => [ 'CloudFrontOriginAccessIdentityList$Items' => '<p>A complex type that contains one <code>CloudFrontOriginAccessIdentitySummary</code> element for each origin access identity that was created by the current Amazon Web Services account.</p>', ], ], 'CommentType' => [ 'base' => NULL, 'refs' => [ 'DistributionConfig$Comment' => '<p>An optional comment to describe the distribution. The comment cannot be longer than 128 characters.</p>', ], ], 'ConflictingAlias' => [ 'base' => '<p>An alias (also called a CNAME) and the CloudFront distribution and Amazon Web Services account ID that it’s associated with. The distribution and account IDs are partially hidden, which allows you to identify the distributions and accounts that you own, but helps to protect the information of ones that you don’t own.</p>', 'refs' => [ 'ConflictingAliases$member' => NULL, ], ], 'ConflictingAliases' => [ 'base' => NULL, 'refs' => [ 'ConflictingAliasesList$Items' => '<p>Contains the conflicting aliases in the list.</p>', ], ], 'ConflictingAliasesList' => [ 'base' => '<p>A list of aliases (also called CNAMEs) and the CloudFront distributions and Amazon Web Services accounts that they are associated with. In the list, the distribution and account IDs are partially hidden, which allows you to identify the distributions and accounts that you own, but helps to protect the information of ones that you don’t own.</p>', 'refs' => [ 'ListConflictingAliasesResult$ConflictingAliasesList' => '<p>A list of conflicting aliases.</p>', ], ], 'ContentTypeProfile' => [ 'base' => '<p>A field-level encryption content type profile. </p>', 'refs' => [ 'ContentTypeProfileList$member' => NULL, ], ], 'ContentTypeProfileConfig' => [ 'base' => '<p>The configuration for a field-level encryption content type-profile mapping. </p>', 'refs' => [ 'FieldLevelEncryptionConfig$ContentTypeProfileConfig' => '<p>A complex data type that specifies when to forward content if a content type isn\'t recognized and profiles to use as by default in a request if a query argument doesn\'t specify a profile to use.</p>', 'FieldLevelEncryptionSummary$ContentTypeProfileConfig' => '<p> A summary of a content type-profile mapping. </p>', ], ], 'ContentTypeProfileList' => [ 'base' => NULL, 'refs' => [ 'ContentTypeProfiles$Items' => '<p>Items in a field-level encryption content type-profile mapping. </p>', ], ], 'ContentTypeProfiles' => [ 'base' => '<p>Field-level encryption content type-profile. </p>', 'refs' => [ 'ContentTypeProfileConfig$ContentTypeProfiles' => '<p>The configuration for a field-level encryption content type-profile. </p>', ], ], 'CookieNameList' => [ 'base' => NULL, 'refs' => [ 'CookieNames$Items' => '<p>A list of cookie names.</p>', ], ], 'CookieNames' => [ 'base' => '<p>Contains a list of cookie names.</p>', 'refs' => [ 'CachePolicyCookiesConfig$Cookies' => NULL, 'CookiePreference$WhitelistedNames' => '<p>This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.</p> <p>If you want to include cookies in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>Required if you specify <code>whitelist</code> for the value of <code>Forward</code>. A complex type that specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior and, if you want to forward selected cookies, the names of those cookies.</p> <p>If you specify <code>all</code> or <code>none</code> for the value of <code>Forward</code>, omit <code>WhitelistedNames</code>. If you change the value of <code>Forward</code> from <code>whitelist</code> to <code>all</code> or <code>none</code> and you don\'t delete the <code>WhitelistedNames</code> element and its child elements, CloudFront deletes them automatically.</p> <p>For the current limit on the number of cookie names that you can whitelist for each cache behavior, see <a href="https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront"> CloudFront Limits</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'OriginRequestPolicyCookiesConfig$Cookies' => NULL, ], ], 'CookiePreference' => [ 'base' => '<p>This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.</p> <p>If you want to include cookies in the cache key, use <code>CookiesConfig</code> in a cache policy. See <code>CachePolicy</code>.</p> <p>If you want to send cookies to the origin but not include them in the cache key, use <code>CookiesConfig</code> in an origin request policy. See <code>OriginRequestPolicy</code>.</p> <p>A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">Caching Content Based on Cookies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [ 'ForwardedValues$Cookies' => '<p>This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.</p> <p>If you want to include cookies in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront Forwards, Caches, and Logs Cookies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', ], ], 'CreateCachePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCachePolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCloudFrontOriginAccessIdentityRequest' => [ 'base' => '<p>The request to create a new origin access identity (OAI). An origin access identity is a special CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or just some of your Amazon S3 content. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"> Restricting Access to Amazon S3 Content by Using an Origin Access Identity</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>', 'refs' => [], ], 'CreateCloudFrontOriginAccessIdentityResult' => [ 'base' => '<p>The returned result of the corresponding request.</p>', 'refs' => [], ], 'CreateDistributionRequest' => [ 'base' => '<p>The request to create a new distribution.</p>', 'refs' => [], ], 'CreateDistributionResult' => [ 'base' => '<p>The returned result of the corresponding request.</p>', 'refs' => [], ], 'CreateDistributionWithTagsRequest' => [ 'base' => '<p>The request to create a new distribution with tags. </p>', 'refs' => [], ], 'CreateDistributionWithTagsResult' => [ 'base' => '<p>The returned result of the corresponding request. </p>', 'refs' => [], ], 'CreateFieldLevelEncryptionConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFieldLevelEncryptionConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateFieldLevelEncryptionProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFieldLevelEncryptionProfileResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFunctionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateInvalidationRequest' => [ 'base' => '<p>The request to create an invalidation.</p>', 'refs' => [], ], 'CreateInvalidationResult' => [ 'base' => '<p>The returned result of the corresponding request.</p>', 'refs' => [], ], 'CreateKeyGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateKeyGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateMonitoringSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMonitoringSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateOriginRequestPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOriginRequestPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'CreatePublicKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePublicKeyResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateRealtimeLogConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRealtimeLogConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateResponseHeadersPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResponseHeadersPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamingDistributionRequest' => [ 'base' => '<p>The request to create a new streaming distribution.</p>', 'refs' => [], ], 'CreateStreamingDistributionResult' => [ 'base' => '<p>The returned result of the corresponding request.</p>', 'refs' => [], ], 'CreateStreamingDistributionWithTagsRequest' => [ 'base' => '<p>The request to create a new streaming distribution with tags.</p>', 'refs' => [], ], 'CreateStreamingDistributionWithTagsResult' => [ 'base' => '<p>The returned result of the corresponding request. </p>', 'refs' => [], ], 'CustomErrorResponse' => [ 'base' => '<p>A complex type that controls:</p> <ul> <li> <p>Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer. </p> </li> <li> <p>How long CloudFront caches HTTP status codes in the 4xx and 5xx range.</p> </li> </ul> <p>For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [ 'CustomErrorResponseList$member' => NULL, ], ], 'CustomErrorResponseList' => [ 'base' => NULL, 'refs' => [ 'CustomErrorResponses$Items' => '<p>A complex type that contains a <code>CustomErrorResponse</code> element for each HTTP status code for which you want to specify a custom error page and/or a caching duration. </p>', ], ], 'CustomErrorResponses' => [ 'base' => '<p>A complex type that controls:</p> <ul> <li> <p>Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.</p> </li> <li> <p>How long CloudFront caches HTTP status codes in the 4xx and 5xx range.</p> </li> </ul> <p>For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [ 'DistributionConfig$CustomErrorResponses' => '<p>A complex type that controls the following:</p> <ul> <li> <p>Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.</p> </li> <li> <p>How long CloudFront caches HTTP status codes in the 4xx and 5xx range.</p> </li> </ul> <p>For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'DistributionSummary$CustomErrorResponses' => '<p>A complex type that contains zero or more <code>CustomErrorResponses</code> elements.</p>', ], ], 'CustomHeaders' => [ 'base' => '<p>A complex type that contains the list of Custom Headers for each origin. </p>', 'refs' => [ 'Origin$CustomHeaders' => '<p>A list of HTTP header names and values that CloudFront adds to the requests that it sends to the origin.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html">Adding Custom Headers to Origin Requests</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', ], ], 'CustomOriginConfig' => [ 'base' => '<p>A custom origin. A custom origin is any origin that is <i>not</i> an Amazon S3 bucket, with one exception. An Amazon S3 bucket that is <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">configured with static website hosting</a> <i>is</i> a custom origin.</p>', 'refs' => [ 'Origin$CustomOriginConfig' => '<p>Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket is not configured with static website hosting, use the <code>S3OriginConfig</code> type instead.</p>', ], ], 'DefaultCacheBehavior' => [ 'base' => '<p>A complex type that describes the default cache behavior if you don’t specify a <code>CacheBehavior</code> element or if request URLs don’t match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code> elements. You must create exactly one default cache behavior.</p>', 'refs' => [ 'DistributionConfig$DefaultCacheBehavior' => '<p>A complex type that describes the default cache behavior if you don\'t specify a <code>CacheBehavior</code> element or if files don\'t match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code> elements. You must create exactly one default cache behavior.</p>', 'DistributionSummary$DefaultCacheBehavior' => '<p>A complex type that describes the default cache behavior if you don\'t specify a <code>CacheBehavior</code> element or if files don\'t match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code> elements. You must create exactly one default cache behavior.</p>', ], ], 'DeleteCachePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCloudFrontOriginAccessIdentityRequest' => [ 'base' => '<p>Deletes a origin access identity.</p>', 'refs' => [], ], 'DeleteDistributionRequest' => [ 'base' => '<p>This action deletes a web distribution. To delete a web distribution using the CloudFront API, perform the following steps.</p> <p> <b>To delete a web distribution using the CloudFront API:</b> </p> <ol> <li> <p>Disable the web distribution </p> </li> <li> <p>Submit a <code>GET Distribution Config</code> request to get the current configuration and the <code>Etag</code> header for the distribution.</p> </li> <li> <p>Update the XML document that was returned in the response to your <code>GET Distribution Config</code> request to change the value of <code>Enabled</code> to <code>false</code>.</p> </li> <li> <p>Submit a <code>PUT Distribution Config</code> request to update the configuration for your distribution. In the request body, include the XML document that you updated in Step 3. Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the <code>GET Distribution Config</code> request in Step 2.</p> </li> <li> <p>Review the response to the <code>PUT Distribution Config</code> request to confirm that the distribution was successfully disabled.</p> </li> <li> <p>Submit a <code>GET Distribution</code> request to confirm that your changes have propagated. When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.</p> </li> <li> <p>Submit a <code>DELETE Distribution</code> request. Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the <code>GET Distribution Config</code> request in Step 6.</p> </li> <li> <p>Review the response to your <code>DELETE Distribution</code> request to confirm that the distribution was successfully deleted.</p> </li> </ol> <p>For information about deleting a distribution using the CloudFront console, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'DeleteFieldLevelEncryptionConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFieldLevelEncryptionProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKeyGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMonitoringSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMonitoringSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOriginRequestPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePublicKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRealtimeLogConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResponseHeadersPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamingDistributionRequest' => [ 'base' => '<p>The request to delete a streaming distribution.</p>', 'refs' => [], ], 'DescribeFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFunctionResult' => [ 'base' => NULL, 'refs' => [], ], 'Distribution' => [ 'base' => '<p>A distribution tells CloudFront where you want content to be delivered from, and the details about how to track and manage content delivery.</p>', 'refs' => [ 'CreateDistributionResult$Distribution' => '<p>The distribution\'s information.</p>', 'CreateDistributionWithTagsResult$Distribution' => '<p>The distribution\'s information. </p>', 'GetDistributionResult$Distribution' => '<p>The distribution\'s information.</p>', 'UpdateDistributionResult$Distribution' => '<p>The distribution\'s information.</p>', ], ], 'DistributionAlreadyExists' => [ 'base' => '<p>The caller reference you attempted to create the distribution with is associated with another distribution.</p>', 'refs' => [], ], 'DistributionConfig' => [ 'base' => '<p>A distribution configuration.</p>', 'refs' => [ 'CreateDistributionRequest$DistributionConfig' => '<p>The distribution\'s configuration information.</p>', 'Distribution$DistributionConfig' => '<p>The current configuration information for the distribution. Send a <code>GET</code> request to the <code>/<i>CloudFront API version</i>/distribution ID/config</code> resource.</p>', 'DistributionConfigWithTags$DistributionConfig' => '<p>A distribution configuration.</p>', 'GetDistributionConfigResult$DistributionConfig' => '<p>The distribution\'s configuration information.</p>', 'UpdateDistributionRequest$DistributionConfig' => '<p>The distribution\'s configuration information.</p>', ], ], 'DistributionConfigWithTags' => [ 'base' => '<p>A distribution Configuration and a list of tags to be associated with the distribution.</p>', 'refs' => [ 'CreateDistributionWithTagsRequest$DistributionConfigWithTags' => '<p>The distribution\'s configuration information. </p>', ], ], 'DistributionIdList' => [ 'base' => '<p>A list of distribution IDs.</p>', 'refs' => [ 'ListDistributionsByCachePolicyIdResult$DistributionIdList' => '<p>A list of distribution IDs.</p>', 'ListDistributionsByKeyGroupResult$DistributionIdList' => NULL, 'ListDistributionsByOriginRequestPolicyIdResult$DistributionIdList' => '<p>A list of distribution IDs.</p>', 'ListDistributionsByResponseHeadersPolicyIdResult$DistributionIdList' => NULL, ], ], 'DistributionIdListSummary' => [ 'base' => NULL, 'refs' => [ 'DistributionIdList$Items' => '<p>Contains the distribution IDs in the list.</p>', ], ], 'DistributionList' => [ 'base' => '<p>A distribution list.</p>', 'refs' => [ 'ListDistributionsByRealtimeLogConfigResult$DistributionList' => NULL, 'ListDistributionsByWebACLIdResult$DistributionList' => '<p>The <code>DistributionList</code> type. </p>', 'ListDistributionsResult$DistributionList' => '<p>The <code>DistributionList</code> type. </p>', ], ], 'DistributionNotDisabled' => [ 'base' => '<p>The specified CloudFront distribution is not disabled. You must disable the distribution before you can delete it.</p>', 'refs' => [], ], 'DistributionSummary' => [ 'base' => '<p>A summary of the information about a CloudFront distribution.</p>', 'refs' => [ 'DistributionSummaryList$member' => NULL, ], ], 'DistributionSummaryList' => [ 'base' => NULL, 'refs' => [ 'DistributionList$Items' => '<p>A complex type that contains one <code>DistributionSummary</code> element for each distribution that was created by the current Amazon Web Services account.</p>', ], ], 'EncryptionEntities' => [ 'base' => '<p>Complex data type for field-level encryption profiles that includes all of the encryption entities. </p>', 'refs' => [ 'FieldLevelEncryptionProfileConfig$EncryptionEntities' => '<p>A complex data type of encryption entities for the field-level encryption profile that include the public key ID, provider, and field patterns for specifying which fields to encrypt with this key.</p>', 'FieldLevelEncryptionProfileSummary$EncryptionEntities' => '<p>A complex data type of encryption entities for the field-level encryption profile that include the public key ID, provider, and field patterns for specifying which fields to encrypt with this key.</p>', ], ], 'EncryptionEntity' => [ 'base' => '<p>Complex data type for field-level encryption profiles that includes the encryption key and field pattern specifications. </p>', 'refs' => [ 'EncryptionEntityList$member' => NULL, ], ], 'EncryptionEntityList' => [ 'base' => NULL, 'refs' => [ 'EncryptionEntities$Items' => '<p>An array of field patterns in a field-level encryption content type-profile mapping. </p>', ], ], 'EndPoint' => [ 'base' => '<p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data in a real-time log configuration.</p>', 'refs' => [ 'EndPointList$member' => NULL, ], ], 'EndPointList' => [ 'base' => NULL, 'refs' => [ 'CreateRealtimeLogConfigRequest$EndPoints' => '<p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>', 'RealtimeLogConfig$EndPoints' => '<p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this real-time log configuration.</p>', 'UpdateRealtimeLogConfigRequest$EndPoints' => '<p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>', ], ], 'EventType' => [ 'base' => NULL, 'refs' => [ 'FunctionAssociation$EventType' => '<p>The event type of the function, either <code>viewer-request</code> or <code>viewer-response</code>. You cannot use origin-facing event types (<code>origin-request</code> and <code>origin-response</code>) with a CloudFront function.</p>', 'LambdaFunctionAssociation$EventType' => '<p>Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:</p> <ul> <li> <p> <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer and before it checks to see whether the requested object is in the edge cache. </p> </li> <li> <p> <code>origin-request</code>: The function executes only when CloudFront sends a request to your origin. When the requested object is in the edge cache, the function doesn\'t execute.</p> </li> <li> <p> <code>origin-response</code>: The function executes after CloudFront receives a response from the origin and before it caches the object in the response. When the requested object is in the edge cache, the function doesn\'t execute.</p> </li> <li> <p> <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the viewer. The function executes regardless of whether the object was already in the edge cache.</p> <p>If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn\'t execute.</p> </li> </ul>', ], ], 'FieldLevelEncryption' => [ 'base' => '<p>A complex data type that includes the profile configurations and other options specified for field-level encryption. </p>', 'refs' => [ 'CreateFieldLevelEncryptionConfigResult$FieldLevelEncryption' => '<p>Returned when you create a new field-level encryption configuration.</p>', 'GetFieldLevelEncryptionResult$FieldLevelEncryption' => '<p>Return the field-level encryption configuration information.</p>', 'UpdateFieldLevelEncryptionConfigResult$FieldLevelEncryption' => '<p>Return the results of updating the configuration.</p>', ], ], 'FieldLevelEncryptionConfig' => [ 'base' => '<p>A complex data type that includes the profile configurations specified for field-level encryption. </p>', 'refs' => [ 'CreateFieldLevelEncryptionConfigRequest$FieldLevelEncryptionConfig' => '<p>The request to create a new field-level encryption configuration.</p>', 'FieldLevelEncryption$FieldLevelEncryptionConfig' => '<p>A complex data type that includes the profile configurations specified for field-level encryption. </p>', 'GetFieldLevelEncryptionConfigResult$FieldLevelEncryptionConfig' => '<p>Return the field-level encryption configuration information.</p>', 'UpdateFieldLevelEncryptionConfigRequest$FieldLevelEncryptionConfig' => '<p>Request to update a field-level encryption configuration. </p>', ], ], 'FieldLevelEncryptionConfigAlreadyExists' => [ 'base' => '<p>The specified configuration for field-level encryption already exists.</p>', 'refs' => [], ], 'FieldLevelEncryptionConfigInUse' => [ 'base' => '<p>The specified configuration for field-level encryption is in use.</p>', 'refs' => [], ], 'FieldLevelEncryptionList' => [ 'base' => '<p>List of field-level encrpytion configurations.</p>', 'refs' => [ 'ListFieldLevelEncryptionConfigsResult$FieldLevelEncryptionList' => '<p>Returns a list of all field-level encryption configurations that have been created in CloudFront for this account.</p>', ], ], 'FieldLevelEncryptionProfile' => [ 'base' => '<p>A complex data type for field-level encryption profiles.</p>', 'refs' => [ 'CreateFieldLevelEncryptionProfileResult$FieldLevelEncryptionProfile' => '<p>Returned when you create a new field-level encryption profile.</p>', 'GetFieldLevelEncryptionProfileResult$FieldLevelEncryptionProfile' => '<p>Return the field-level encryption profile information.</p>', 'UpdateFieldLevelEncryptionProfileResult$FieldLevelEncryptionProfile' => '<p>Return the results of updating the profile.</p>', ], ], 'FieldLevelEncryptionProfileAlreadyExists' => [ 'base' => '<p>The specified profile for field-level encryption already exists.</p>', 'refs' => [], ], 'FieldLevelEncryptionProfileConfig' => [ 'base' => '<p>A complex data type of profiles for the field-level encryption.</p>', 'refs' => [ 'CreateFieldLevelEncryptionProfileRequest$FieldLevelEncryptionProfileConfig' => '<p>The request to create a field-level encryption profile.</p>', 'FieldLevelEncryptionProfile$FieldLevelEncryptionProfileConfig' => '<p>A complex data type that includes the profile name and the encryption entities for the field-level encryption profile.</p>', 'GetFieldLevelEncryptionProfileConfigResult$FieldLevelEncryptionProfileConfig' => '<p>Return the field-level encryption profile configuration information.</p>', 'UpdateFieldLevelEncryptionProfileRequest$FieldLevelEncryptionProfileConfig' => '<p>Request to update a field-level encryption profile. </p>', ], ], 'FieldLevelEncryptionProfileInUse' => [ 'base' => '<p>The specified profile for field-level encryption is in use.</p>', 'refs' => [], ], 'FieldLevelEncryptionProfileList' => [ 'base' => '<p>List of field-level encryption profiles.</p>', 'refs' => [ 'ListFieldLevelEncryptionProfilesResult$FieldLevelEncryptionProfileList' => '<p>Returns a list of the field-level encryption profiles that have been created in CloudFront for this account.</p>', ], ], 'FieldLevelEncryptionProfileSizeExceeded' => [ 'base' => '<p>The maximum size of a profile for field-level encryption was exceeded.</p>', 'refs' => [], ], 'FieldLevelEncryptionProfileSummary' => [ 'base' => '<p>The field-level encryption profile summary.</p>', 'refs' => [ 'FieldLevelEncryptionProfileSummaryList$member' => NULL, ], ], 'FieldLevelEncryptionProfileSummaryList' => [ 'base' => NULL, 'refs' => [ 'FieldLevelEncryptionProfileList$Items' => '<p>The field-level encryption profile items.</p>', ], ], 'FieldLevelEncryptionSummary' => [ 'base' => '<p>A summary of a field-level encryption item.</p>', 'refs' => [ 'FieldLevelEncryptionSummaryList$member' => NULL, ], ], 'FieldLevelEncryptionSummaryList' => [ 'base' => NULL, 'refs' => [ 'FieldLevelEncryptionList$Items' => '<p>An array of field-level encryption items.</p>', ], ], 'FieldList' => [ 'base' => NULL, 'refs' => [ 'CreateRealtimeLogConfigRequest$Fields' => '<p>A list of fields to include in each real-time log record.</p> <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'RealtimeLogConfig$Fields' => '<p>A list of fields that are included in each real-time log record. In an API response, the fields are provided in the same order in which they are sent to the Amazon Kinesis data stream.</p> <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'UpdateRealtimeLogConfigRequest$Fields' => '<p>A list of fields to include in each real-time log record.</p> <p>For more information about fields, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields">Real-time log configuration fields</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', ], ], 'FieldPatternList' => [ 'base' => NULL, 'refs' => [ 'FieldPatterns$Items' => '<p>An array of the field-level encryption field patterns.</p>', ], ], 'FieldPatterns' => [ 'base' => '<p>A complex data type that includes the field patterns to match for field-level encryption.</p>', 'refs' => [ 'EncryptionEntity$FieldPatterns' => '<p>Field patterns in a field-level encryption content type profile specify the fields that you want to be encrypted. You can provide the full field name, or any beginning characters followed by a wildcard (*). You can\'t overlap field patterns. For example, you can\'t have both ABC* and AB*. Note that field patterns are case-sensitive. </p>', ], ], 'Format' => [ 'base' => NULL, 'refs' => [ 'ContentTypeProfile$Format' => '<p>The format for a field-level encryption content type-profile mapping. </p>', ], ], 'ForwardedValues' => [ 'base' => '<p>This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.</p> <p>If you want to include values in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.</p>', 'refs' => [ 'CacheBehavior$ForwardedValues' => '<p>This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you want to include values in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>A <code>CacheBehavior</code> must include either a <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you use a <code>CachePolicyId</code>.</p> <p>A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.</p>', 'DefaultCacheBehavior$ForwardedValues' => '<p>This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you want to include values in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you use a <code>CachePolicyId</code>.</p> <p>A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.</p>', ], ], 'FrameOptionsList' => [ 'base' => NULL, 'refs' => [ 'ResponseHeadersPolicyFrameOptions$FrameOption' => '<p>The value of the <code>X-Frame-Options</code> HTTP response header. Valid values are <code>DENY</code> and <code>SAMEORIGIN</code>. </p> <p>For more information about these values, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.</p>', ], ], 'FunctionARN' => [ 'base' => NULL, 'refs' => [ 'FunctionAssociation$FunctionARN' => '<p>The Amazon Resource Name (ARN) of the function.</p>', ], ], 'FunctionAlreadyExists' => [ 'base' => '<p>A function with the same name already exists in this Amazon Web Services account. To create a function, you must provide a unique name. To update an existing function, use <code>UpdateFunction</code>.</p>', 'refs' => [], ], 'FunctionAssociation' => [ 'base' => '<p>A CloudFront function that is associated with a cache behavior in a CloudFront distribution.</p>', 'refs' => [ 'FunctionAssociationList$member' => NULL, ], ], 'FunctionAssociationList' => [ 'base' => NULL, 'refs' => [ 'FunctionAssociations$Items' => '<p>The CloudFront functions that are associated with a cache behavior in a CloudFront distribution. CloudFront functions must be published to the <code>LIVE</code> stage to associate them with a cache behavior.</p>', ], ], 'FunctionAssociations' => [ 'base' => '<p>A list of CloudFront functions that are associated with a cache behavior in a CloudFront distribution. CloudFront functions must be published to the <code>LIVE</code> stage to associate them with a cache behavior.</p>', 'refs' => [ 'CacheBehavior$FunctionAssociations' => '<p>A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be published to the <code>LIVE</code> stage to associate them with a cache behavior.</p>', 'DefaultCacheBehavior$FunctionAssociations' => '<p>A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be published to the <code>LIVE</code> stage to associate them with a cache behavior.</p>', ], ], 'FunctionBlob' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$FunctionCode' => '<p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'GetFunctionResult$FunctionCode' => '<p>The function code of a CloudFront function.</p>', 'UpdateFunctionRequest$FunctionCode' => '<p>The function code. For more information about writing a CloudFront function, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html">Writing function code for CloudFront Functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', ], ], 'FunctionConfig' => [ 'base' => '<p>Contains configuration information about a CloudFront function.</p>', 'refs' => [ 'CreateFunctionRequest$FunctionConfig' => '<p>Configuration information about the function, including an optional comment and the function’s runtime.</p>', 'FunctionSummary$FunctionConfig' => '<p>Contains configuration information about a CloudFront function.</p>', 'UpdateFunctionRequest$FunctionConfig' => '<p>Configuration information about the function.</p>', ], ], 'FunctionEventObject' => [ 'base' => NULL, 'refs' => [ 'TestFunctionRequest$EventObject' => '<p>The event object to test the function with. For more information about the structure of the event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function">Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', ], ], 'FunctionExecutionLogList' => [ 'base' => NULL, 'refs' => [ 'TestResult$FunctionExecutionLogs' => '<p>Contains the log lines that the function wrote (if any) when running the test.</p>', ], ], 'FunctionInUse' => [ 'base' => '<p>Cannot delete the function because it’s attached to one or more cache behaviors.</p>', 'refs' => [], ], 'FunctionList' => [ 'base' => '<p>A list of CloudFront functions.</p>', 'refs' => [ 'ListFunctionsResult$FunctionList' => '<p>A list of CloudFront functions.</p>', ], ], 'FunctionMetadata' => [ 'base' => '<p>Contains metadata about a CloudFront function.</p>', 'refs' => [ 'FunctionSummary$FunctionMetadata' => '<p>Contains metadata about a CloudFront function.</p>', ], ], 'FunctionName' => [ 'base' => NULL, 'refs' => [ 'CreateFunctionRequest$Name' => '<p>A name to identify the function.</p>', 'FunctionSummary$Name' => '<p>The name of the CloudFront function.</p>', ], ], 'FunctionRuntime' => [ 'base' => NULL, 'refs' => [ 'FunctionConfig$Runtime' => '<p>The function’s runtime environment. The only valid value is <code>cloudfront-js-1.0</code>.</p>', ], ], 'FunctionSizeLimitExceeded' => [ 'base' => '<p>The function is too large. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'FunctionStage' => [ 'base' => NULL, 'refs' => [ 'DescribeFunctionRequest$Stage' => '<p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>', 'FunctionMetadata$Stage' => '<p>The stage that the function is in, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p> <p>When a function is in the <code>DEVELOPMENT</code> stage, you can test the function with <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.</p> <p>When a function is in the <code>LIVE</code> stage, you can attach the function to a distribution’s cache behavior, using the function’s ARN.</p>', 'GetFunctionRequest$Stage' => '<p>The function’s stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>', 'ListFunctionsRequest$Stage' => '<p>An optional filter to return only the functions that are in the specified stage, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>', 'TestFunctionRequest$Stage' => '<p>The stage of the function that you are testing, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>', ], ], 'FunctionSummary' => [ 'base' => '<p>Contains configuration information and metadata about a CloudFront function.</p>', 'refs' => [ 'CreateFunctionResult$FunctionSummary' => '<p>Contains configuration information and metadata about a CloudFront function.</p>', 'DescribeFunctionResult$FunctionSummary' => '<p>Contains configuration information and metadata about a CloudFront function.</p>', 'FunctionSummaryList$member' => NULL, 'PublishFunctionResult$FunctionSummary' => '<p>Contains configuration information and metadata about a CloudFront function.</p>', 'TestResult$FunctionSummary' => '<p>Contains configuration information and metadata about the CloudFront function that was tested.</p>', 'UpdateFunctionResult$FunctionSummary' => '<p>Contains configuration information and metadata about a CloudFront function.</p>', ], ], 'FunctionSummaryList' => [ 'base' => NULL, 'refs' => [ 'FunctionList$Items' => '<p>Contains the functions in the list.</p>', ], ], 'GeoRestriction' => [ 'base' => '<p>A complex type that controls the countries in which your content is distributed. CloudFront determines the location of your users using <code>MaxMind</code> GeoIP databases. </p>', 'refs' => [ 'Restrictions$GeoRestriction' => '<p>A complex type that controls the countries in which your content is distributed. CloudFront determines the location of your users using <code>MaxMind</code> GeoIP databases.</p>', ], ], 'GeoRestrictionType' => [ 'base' => NULL, 'refs' => [ 'GeoRestriction$RestrictionType' => '<p>The method that you want to use to restrict distribution of your content by country:</p> <ul> <li> <p> <code>none</code>: No geo restriction is enabled, meaning access to content is not restricted by client geo location.</p> </li> <li> <p> <code>blacklist</code>: The <code>Location</code> elements specify the countries in which you don\'t want CloudFront to distribute your content.</p> </li> <li> <p> <code>whitelist</code>: The <code>Location</code> elements specify the countries in which you want CloudFront to distribute your content.</p> </li> </ul>', ], ], 'GetCachePolicyConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCachePolicyConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'GetCachePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCachePolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'GetCloudFrontOriginAccessIdentityConfigRequest' => [ 'base' => '<p>The origin access identity\'s configuration information. For more information, see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CloudFrontOriginAccessIdentityConfig.html">CloudFrontOriginAccessIdentityConfig</a>.</p>', 'refs' => [], ], 'GetCloudFrontOriginAccessIdentityConfigResult' => [ 'base' => '<p>The returned result of the corresponding request.</p>', 'refs' => [], ], 'GetCloudFrontOriginAccessIdentityRequest' => [ 'base' => '<p>The request to get an origin access identity\'s information.</p>', 'refs' => [], ], 'GetCloudFrontOriginAccessIdentityResult' => [ 'base' => '<p>The returned result of the corresponding request.</p>', 'refs' => [], ], 'GetDistributionConfigRequest' => [ 'base' => '<p>The request to get a distribution configuration.</p>', 'refs' => [], ], 'GetDistributionConfigResult' => [ 'base' => '<p>The returned result of the corresponding request.</p>', 'refs' => [], ], 'GetDistributionRequest' => [ 'base' => '<p>The request to get a distribution\'s information.</p>', 'refs' => [], ], 'GetDistributionResult' => [ 'base' => '<p>The returned result of the corresponding request.</p>', 'refs' => [], ], 'GetFieldLevelEncryptionConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFieldLevelEncryptionConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'GetFieldLevelEncryptionProfileConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFieldLevelEncryptionProfileConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'GetFieldLevelEncryptionProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFieldLevelEncryptionProfileResult' => [ 'base' => NULL, 'refs' => [], ], 'GetFieldLevelEncryptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFieldLevelEncryptionResult' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFunctionResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInvalidationRequest' => [ 'base' => '<p>The request to get an invalidation\'s information. </p>', 'refs' => [], ], 'GetInvalidationResult' => [ 'base' => '<p>The returned result of the corresponding request.</p>', 'refs' => [], ], 'GetKeyGroupConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKeyGroupConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'GetKeyGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKeyGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMonitoringSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMonitoringSubscriptionResult' => [ 'base' => NULL, 'refs' => [], ], 'GetOriginRequestPolicyConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOriginRequestPolicyConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'GetOriginRequestPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOriginRequestPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'GetPublicKeyConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPublicKeyConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'GetPublicKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPublicKeyResult' => [ 'base' => NULL, 'refs' => [], ], 'GetRealtimeLogConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRealtimeLogConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'GetResponseHeadersPolicyConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResponseHeadersPolicyConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'GetResponseHeadersPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResponseHeadersPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamingDistributionConfigRequest' => [ 'base' => '<p>To request to get a streaming distribution configuration.</p>', 'refs' => [], ], 'GetStreamingDistributionConfigResult' => [ 'base' => '<p>The returned result of the corresponding request.</p>', 'refs' => [], ], 'GetStreamingDistributionRequest' => [ 'base' => '<p>The request to get a streaming distribution\'s information.</p>', 'refs' => [], ], 'GetStreamingDistributionResult' => [ 'base' => '<p>The returned result of the corresponding request.</p>', 'refs' => [], ], 'HeaderList' => [ 'base' => NULL, 'refs' => [ 'Headers$Items' => '<p>A list of HTTP header names.</p>', ], ], 'Headers' => [ 'base' => '<p>Contains a list of HTTP header names.</p>', 'refs' => [ 'CachePolicyHeadersConfig$Headers' => NULL, 'ForwardedValues$Headers' => '<p>This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.</p> <p>If you want to include headers in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you want to send headers to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>A complex type that specifies the <code>Headers</code>, if any, that you want CloudFront to forward to the origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches separate versions of a specified object that is based on the header values in viewer requests.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html"> Caching Content Based on Request Headers</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'OriginRequestPolicyHeadersConfig$Headers' => NULL, ], ], 'HttpVersion' => [ 'base' => NULL, 'refs' => [ 'DistributionConfig$HttpVersion' => '<p>(Optional) Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default value for new web distributions is http2. Viewers that don\'t support HTTP/2 automatically use an earlier HTTP version.</p> <p>For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or later, and must support Server Name Identification (SNI).</p> <p>In general, configuring CloudFront to communicate with viewers using HTTP/2 reduces latency. You can improve performance by optimizing for HTTP/2. For more information, do an Internet search for "http/2 optimization." </p>', 'DistributionSummary$HttpVersion' => '<p> Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default value for new web distributions is <code>http2</code>. Viewers that don\'t support <code>HTTP/2</code> will automatically use an earlier version.</p>', ], ], 'ICPRecordalStatus' => [ 'base' => NULL, 'refs' => [ 'AliasICPRecordal$ICPRecordalStatus' => '<p>The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to APPROVED for all CNAMEs (aliases) in regions outside of China. </p> <p>The status values returned are the following:</p> <ul> <li> <p> <b>APPROVED</b> indicates that the associated CNAME has a valid ICP recordal number. Multiple CNAMEs can be associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number associated with it.</p> </li> <li> <p> <b>SUSPENDED</b> indicates that the associated CNAME does not have a valid ICP recordal number.</p> </li> <li> <p> <b>PENDING</b> indicates that CloudFront can\'t determine the ICP recordal status of the CNAME associated with the distribution because there was an error in trying to determine the status. You can try again to see if the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.</p> </li> </ul>', ], ], 'IllegalDelete' => [ 'base' => '<p>You cannot delete a managed policy.</p>', 'refs' => [], ], 'IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior' => [ 'base' => '<p>The specified configuration for field-level encryption can\'t be associated with the specified cache behavior.</p>', 'refs' => [], ], 'IllegalUpdate' => [ 'base' => '<p>The update contains modifications that are not allowed.</p>', 'refs' => [], ], 'InconsistentQuantities' => [ 'base' => '<p>The value of <code>Quantity</code> and the size of <code>Items</code> don\'t match.</p>', 'refs' => [], ], 'InvalidArgument' => [ 'base' => '<p>An argument is invalid.</p>', 'refs' => [], ], 'InvalidDefaultRootObject' => [ 'base' => '<p>The default root object file name is too big or contains an invalid character.</p>', 'refs' => [], ], 'InvalidErrorCode' => [ 'base' => '<p>An invalid error code was specified.</p>', 'refs' => [], ], 'InvalidForwardCookies' => [ 'base' => '<p>Your request contains forward cookies option which doesn\'t match with the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not allowed or list of cookie names is missing when expected.</p>', 'refs' => [], ], 'InvalidFunctionAssociation' => [ 'base' => '<p>A CloudFront function association is invalid.</p>', 'refs' => [], ], 'InvalidGeoRestrictionParameter' => [ 'base' => '<p>The specified geo restriction parameter is not valid.</p>', 'refs' => [], ], 'InvalidHeadersForS3Origin' => [ 'base' => '<p>The headers specified are not valid for an Amazon S3 origin.</p>', 'refs' => [], ], 'InvalidIfMatchVersion' => [ 'base' => '<p>The <code>If-Match</code> version is missing or not valid.</p>', 'refs' => [], ], 'InvalidLambdaFunctionAssociation' => [ 'base' => '<p>The specified Lambda@Edge function association is invalid.</p>', 'refs' => [], ], 'InvalidLocationCode' => [ 'base' => '<p>The location code specified is not valid.</p>', 'refs' => [], ], 'InvalidMinimumProtocolVersion' => [ 'base' => '<p>The minimum protocol version specified is not valid.</p>', 'refs' => [], ], 'InvalidOrigin' => [ 'base' => '<p>The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.</p>', 'refs' => [], ], 'InvalidOriginAccessIdentity' => [ 'base' => '<p>The origin access identity is not valid or doesn\'t exist.</p>', 'refs' => [], ], 'InvalidOriginKeepaliveTimeout' => [ 'base' => '<p>The keep alive timeout specified for the origin is not valid.</p>', 'refs' => [], ], 'InvalidOriginReadTimeout' => [ 'base' => '<p>The read timeout specified for the origin is not valid.</p>', 'refs' => [], ], 'InvalidProtocolSettings' => [ 'base' => '<p>You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that support Server Name Indication (SNI).</p>', 'refs' => [], ], 'InvalidQueryStringParameters' => [ 'base' => '<p>The query string parameters specified are not valid.</p>', 'refs' => [], ], 'InvalidRelativePath' => [ 'base' => '<p>The relative path is too big, is not URL-encoded, or does not begin with a slash (/).</p>', 'refs' => [], ], 'InvalidRequiredProtocol' => [ 'base' => '<p>This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your distribution configuration.</p>', 'refs' => [], ], 'InvalidResponseCode' => [ 'base' => '<p>A response code is not valid.</p>', 'refs' => [], ], 'InvalidTTLOrder' => [ 'base' => '<p>The TTL order specified is not valid.</p>', 'refs' => [], ], 'InvalidTagging' => [ 'base' => '<p>The tagging specified is not valid.</p>', 'refs' => [], ], 'InvalidViewerCertificate' => [ 'base' => '<p>A viewer certificate specified is not valid.</p>', 'refs' => [], ], 'InvalidWebACLId' => [ 'base' => '<p>A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>. To specify a web ACL created using WAF Classic, use the ACL ID, for example <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</p>', 'refs' => [], ], 'Invalidation' => [ 'base' => '<p>An invalidation. </p>', 'refs' => [ 'CreateInvalidationResult$Invalidation' => '<p>The invalidation\'s information.</p>', 'GetInvalidationResult$Invalidation' => '<p>The invalidation\'s information. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/InvalidationDatatype.html">Invalidation Complex Type</a>. </p>', ], ], 'InvalidationBatch' => [ 'base' => '<p>An invalidation batch.</p>', 'refs' => [ 'CreateInvalidationRequest$InvalidationBatch' => '<p>The batch information for the invalidation.</p>', 'Invalidation$InvalidationBatch' => '<p>The current invalidation information for the batch request. </p>', ], ], 'InvalidationList' => [ 'base' => '<p>The <code>InvalidationList</code> complex type describes the list of invalidation objects. For more information about invalidation, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html">Invalidating Objects (Web Distributions Only)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [ 'ListInvalidationsResult$InvalidationList' => '<p>Information about invalidation batches. </p>', ], ], 'InvalidationSummary' => [ 'base' => '<p>A summary of an invalidation request.</p>', 'refs' => [ 'InvalidationSummaryList$member' => NULL, ], ], 'InvalidationSummaryList' => [ 'base' => NULL, 'refs' => [ 'InvalidationList$Items' => '<p>A complex type that contains one <code>InvalidationSummary</code> element for each invalidation batch created by the current Amazon Web Services account.</p>', ], ], 'ItemSelection' => [ 'base' => NULL, 'refs' => [ 'CookiePreference$Forward' => '<p>This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.</p> <p>If you want to include cookies in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you want to send cookies to the origin but not include them in the cache key, use origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies specified in the <code>WhitelistedNames</code> complex type.</p> <p>Amazon S3 doesn\'t process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin, specify none for the <code>Forward</code> element.</p>', ], ], 'KGKeyPairIds' => [ 'base' => '<p>A list of identifiers for the public keys that CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>', 'refs' => [ 'KGKeyPairIdsList$member' => NULL, ], ], 'KGKeyPairIdsList' => [ 'base' => NULL, 'refs' => [ 'ActiveTrustedKeyGroups$Items' => '<p>A list of key groups, including the identifiers of the public keys in each key group that CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>', ], ], 'KeyGroup' => [ 'base' => '<p>A key group.</p> <p>A key group contains a list of public keys that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed URLs and signed cookies</a>.</p>', 'refs' => [ 'CreateKeyGroupResult$KeyGroup' => '<p>The key group that was just created.</p>', 'GetKeyGroupResult$KeyGroup' => '<p>The key group.</p>', 'KeyGroupSummary$KeyGroup' => '<p>A key group.</p>', 'UpdateKeyGroupResult$KeyGroup' => '<p>The key group that was just updated.</p>', ], ], 'KeyGroupAlreadyExists' => [ 'base' => '<p>A key group with this name already exists. You must provide a unique name. To modify an existing key group, use <code>UpdateKeyGroup</code>.</p>', 'refs' => [], ], 'KeyGroupConfig' => [ 'base' => '<p>A key group configuration.</p> <p>A key group contains a list of public keys that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed URLs and signed cookies</a>.</p>', 'refs' => [ 'CreateKeyGroupRequest$KeyGroupConfig' => '<p>A key group configuration.</p>', 'GetKeyGroupConfigResult$KeyGroupConfig' => '<p>The key group configuration.</p>', 'KeyGroup$KeyGroupConfig' => '<p>The key group configuration.</p>', 'UpdateKeyGroupRequest$KeyGroupConfig' => '<p>The key group configuration.</p>', ], ], 'KeyGroupList' => [ 'base' => '<p>A list of key groups.</p>', 'refs' => [ 'ListKeyGroupsResult$KeyGroupList' => '<p>A list of key groups.</p>', ], ], 'KeyGroupSummary' => [ 'base' => '<p>Contains information about a key group.</p>', 'refs' => [ 'KeyGroupSummaryList$member' => NULL, ], ], 'KeyGroupSummaryList' => [ 'base' => NULL, 'refs' => [ 'KeyGroupList$Items' => '<p>A list of key groups.</p>', ], ], 'KeyPairIdList' => [ 'base' => NULL, 'refs' => [ 'KeyPairIds$Items' => '<p>A list of CloudFront key pair identifiers.</p>', ], ], 'KeyPairIds' => [ 'base' => '<p>A list of CloudFront key pair identifiers.</p>', 'refs' => [ 'KGKeyPairIds$KeyPairIds' => NULL, 'Signer$KeyPairIds' => '<p>A list of CloudFront key pair identifiers.</p>', ], ], 'KinesisStreamConfig' => [ 'base' => '<p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>', 'refs' => [ 'EndPoint$KinesisStreamConfig' => '<p>Contains information about the Amazon Kinesis data stream where you are sending real-time log data.</p>', ], ], 'LambdaFunctionARN' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionAssociation$LambdaFunctionARN' => '<p>The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can\'t specify an alias or $LATEST.</p>', ], ], 'LambdaFunctionAssociation' => [ 'base' => '<p>A complex type that contains a Lambda@Edge function association.</p>', 'refs' => [ 'LambdaFunctionAssociationList$member' => NULL, ], ], 'LambdaFunctionAssociationList' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionAssociations$Items' => '<p> <b>Optional</b>: A complex type that contains <code>LambdaFunctionAssociation</code> items for this cache behavior. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.</p>', ], ], 'LambdaFunctionAssociations' => [ 'base' => '<p>A complex type that specifies a list of Lambda@Edge functions associations for a cache behavior.</p> <p>If you want to invoke one or more Lambda@Edge functions triggered by requests that match the <code>PathPattern</code> of the cache behavior, specify the applicable values for <code>Quantity</code> and <code>Items</code>. Note that there can be up to 4 <code>LambdaFunctionAssociation</code> items in this list (one for each possible value of <code>EventType</code>) and each <code>EventType</code> can be associated with only one function.</p> <p>If you don\'t want to invoke any Lambda@Edge functions for the requests that match <code>PathPattern</code>, specify <code>0</code> for <code>Quantity</code> and omit <code>Items</code>. </p>', 'refs' => [ 'CacheBehavior$LambdaFunctionAssociations' => '<p>A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.</p>', 'DefaultCacheBehavior$LambdaFunctionAssociations' => '<p>A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.</p>', ], ], 'ListCachePoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCachePoliciesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListCloudFrontOriginAccessIdentitiesRequest' => [ 'base' => '<p>The request to list origin access identities. </p>', 'refs' => [], ], 'ListCloudFrontOriginAccessIdentitiesResult' => [ 'base' => '<p>The returned result of the corresponding request. </p>', 'refs' => [], ], 'ListConflictingAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListConflictingAliasesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributionsByCachePolicyIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributionsByCachePolicyIdResult' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributionsByKeyGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributionsByKeyGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributionsByOriginRequestPolicyIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributionsByOriginRequestPolicyIdResult' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributionsByRealtimeLogConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributionsByRealtimeLogConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributionsByResponseHeadersPolicyIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributionsByResponseHeadersPolicyIdResult' => [ 'base' => NULL, 'refs' => [], ], 'ListDistributionsByWebACLIdRequest' => [ 'base' => '<p>The request to list distributions that are associated with a specified WAF web ACL.</p>', 'refs' => [], ], 'ListDistributionsByWebACLIdResult' => [ 'base' => '<p>The response to a request to list the distributions that are associated with a specified WAF web ACL.</p>', 'refs' => [], ], 'ListDistributionsRequest' => [ 'base' => '<p>The request to list your distributions. </p>', 'refs' => [], ], 'ListDistributionsResult' => [ 'base' => '<p>The returned result of the corresponding request. </p>', 'refs' => [], ], 'ListFieldLevelEncryptionConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFieldLevelEncryptionConfigsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListFieldLevelEncryptionProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFieldLevelEncryptionProfilesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListFunctionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFunctionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListInvalidationsRequest' => [ 'base' => '<p>The request to list invalidations. </p>', 'refs' => [], ], 'ListInvalidationsResult' => [ 'base' => '<p>The returned result of the corresponding request. </p>', 'refs' => [], ], 'ListKeyGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKeyGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListOriginRequestPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOriginRequestPoliciesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListPublicKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPublicKeysResult' => [ 'base' => NULL, 'refs' => [], ], 'ListRealtimeLogConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRealtimeLogConfigsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListResponseHeadersPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResponseHeadersPoliciesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamingDistributionsRequest' => [ 'base' => '<p>The request to list your streaming distributions. </p>', 'refs' => [], ], 'ListStreamingDistributionsResult' => [ 'base' => '<p>The returned result of the corresponding request. </p>', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => '<p> The request to list tags for a CloudFront resource.</p>', 'refs' => [], ], 'ListTagsForResourceResult' => [ 'base' => '<p> The returned result of the corresponding request.</p>', 'refs' => [], ], 'LocationList' => [ 'base' => NULL, 'refs' => [ 'GeoRestriction$Items' => '<p> A complex type that contains a <code>Location</code> element for each country in which you want CloudFront either to distribute your content (<code>whitelist</code>) or not distribute your content (<code>blacklist</code>).</p> <p>The <code>Location</code> element is a two-letter, uppercase country code for a country that you want to include in your <code>blacklist</code> or <code>whitelist</code>. Include one <code>Location</code> element for each country.</p> <p>CloudFront and <code>MaxMind</code> both use <code>ISO 3166</code> country codes. For the current list of countries and the corresponding codes, see <code>ISO 3166-1-alpha-2</code> code on the <i>International Organization for Standardization</i> website. You can also refer to the country list on the CloudFront console, which includes both country names and codes.</p>', ], ], 'LoggingConfig' => [ 'base' => '<p>A complex type that controls whether access logs are written for the distribution.</p>', 'refs' => [ 'DistributionConfig$Logging' => '<p>A complex type that controls whether access logs are written for the distribution.</p> <p>For more information about logging, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access Logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', ], ], 'Method' => [ 'base' => NULL, 'refs' => [ 'MethodsList$member' => NULL, ], ], 'MethodsList' => [ 'base' => NULL, 'refs' => [ 'AllowedMethods$Items' => '<p>A complex type that contains the HTTP methods that you want CloudFront to process and forward to your origin.</p>', 'CachedMethods$Items' => '<p>A complex type that contains the HTTP methods that you want CloudFront to cache responses to.</p>', ], ], 'MinimumProtocolVersion' => [ 'base' => NULL, 'refs' => [ 'ViewerCertificate$MinimumProtocolVersion' => '<p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), specify the security policy that you want CloudFront to use for HTTPS connections with viewers. The security policy determines two settings:</p> <ul> <li> <p>The minimum SSL/TLS protocol that CloudFront can use to communicate with viewers.</p> </li> <li> <p>The ciphers that CloudFront can use to encrypt the content that it returns to viewers.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy">Security Policy</a> and <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers">Supported Protocols and Ciphers Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <note> <p>On the CloudFront console, this setting is called <b>Security Policy</b>.</p> </note> <p>When you’re using SNI only (you set <code>SSLSupportMethod</code> to <code>sni-only</code>), you must specify <code>TLSv1</code> or higher.</p> <p>If the distribution uses the CloudFront domain name such as <code>d111111abcdef8.cloudfront.net</code> (you set <code>CloudFrontDefaultCertificate</code> to <code>true</code>), CloudFront automatically sets the security policy to <code>TLSv1</code> regardless of the value that you set here.</p>', ], ], 'MissingBody' => [ 'base' => '<p>This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header is set.</p>', 'refs' => [], ], 'MonitoringSubscription' => [ 'base' => '<p>A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.</p>', 'refs' => [ 'CreateMonitoringSubscriptionRequest$MonitoringSubscription' => '<p>A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.</p>', 'CreateMonitoringSubscriptionResult$MonitoringSubscription' => '<p>A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.</p>', 'GetMonitoringSubscriptionResult$MonitoringSubscription' => '<p>A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.</p>', ], ], 'NoSuchCachePolicy' => [ 'base' => '<p>The cache policy does not exist.</p>', 'refs' => [], ], 'NoSuchCloudFrontOriginAccessIdentity' => [ 'base' => '<p>The specified origin access identity does not exist.</p>', 'refs' => [], ], 'NoSuchDistribution' => [ 'base' => '<p>The specified distribution does not exist.</p>', 'refs' => [], ], 'NoSuchFieldLevelEncryptionConfig' => [ 'base' => '<p>The specified configuration for field-level encryption doesn\'t exist.</p>', 'refs' => [], ], 'NoSuchFieldLevelEncryptionProfile' => [ 'base' => '<p>The specified profile for field-level encryption doesn\'t exist.</p>', 'refs' => [], ], 'NoSuchFunctionExists' => [ 'base' => '<p>The function does not exist.</p>', 'refs' => [], ], 'NoSuchInvalidation' => [ 'base' => '<p>The specified invalidation does not exist.</p>', 'refs' => [], ], 'NoSuchOrigin' => [ 'base' => '<p>No origin exists with the specified <code>Origin Id</code>. </p>', 'refs' => [], ], 'NoSuchOriginRequestPolicy' => [ 'base' => '<p>The origin request policy does not exist.</p>', 'refs' => [], ], 'NoSuchPublicKey' => [ 'base' => '<p>The specified public key doesn\'t exist.</p>', 'refs' => [], ], 'NoSuchRealtimeLogConfig' => [ 'base' => '<p>The real-time log configuration does not exist.</p>', 'refs' => [], ], 'NoSuchResource' => [ 'base' => '<p>A resource that was specified is not valid.</p>', 'refs' => [], ], 'NoSuchResponseHeadersPolicy' => [ 'base' => '<p>The response headers policy does not exist.</p>', 'refs' => [], ], 'NoSuchStreamingDistribution' => [ 'base' => '<p>The specified streaming distribution does not exist.</p>', 'refs' => [], ], 'Origin' => [ 'base' => '<p>An origin.</p> <p>An origin is the location where content is stored, and from which CloudFront gets content to serve to viewers. To specify an origin:</p> <ul> <li> <p>Use <code>S3OriginConfig</code> to specify an Amazon S3 bucket that is not configured with static website hosting.</p> </li> <li> <p>Use <code>CustomOriginConfig</code> to specify all other kinds of origins, including:</p> <ul> <li> <p>An Amazon S3 bucket that is configured with static website hosting</p> </li> <li> <p>An Elastic Load Balancing load balancer</p> </li> <li> <p>An AWS Elemental MediaPackage endpoint</p> </li> <li> <p>An AWS Elemental MediaStore container</p> </li> <li> <p>Any other HTTP server, running on an Amazon EC2 instance or any other kind of host</p> </li> </ul> </li> </ul> <p>For the current maximum number of origins that you can specify per distribution, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions">General Quotas on Web Distributions</a> in the <i>Amazon CloudFront Developer Guide</i> (quotas were formerly referred to as limits).</p>', 'refs' => [ 'OriginList$member' => NULL, ], ], 'OriginCustomHeader' => [ 'base' => '<p>A complex type that contains <code>HeaderName</code> and <code>HeaderValue</code> elements, if any, for this distribution. </p>', 'refs' => [ 'OriginCustomHeadersList$member' => NULL, ], ], 'OriginCustomHeadersList' => [ 'base' => NULL, 'refs' => [ 'CustomHeaders$Items' => '<p> <b>Optional</b>: A list that contains one <code>OriginCustomHeader</code> element for each custom header that you want CloudFront to forward to the origin. If Quantity is <code>0</code>, omit <code>Items</code>.</p>', ], ], 'OriginGroup' => [ 'base' => '<p>An origin group includes two origins (a primary origin and a second origin to failover to) and a failover criteria that you specify. You create an origin group to support origin failover in CloudFront. When you create or update a distribution, you can specifiy the origin group instead of a single origin, and CloudFront will failover from the primary origin to the second origin under the failover conditions that you\'ve chosen.</p>', 'refs' => [ 'OriginGroupList$member' => NULL, ], ], 'OriginGroupFailoverCriteria' => [ 'base' => '<p>A complex data type that includes information about the failover criteria for an origin group, including the status codes for which CloudFront will failover from the primary origin to the second origin.</p>', 'refs' => [ 'OriginGroup$FailoverCriteria' => '<p>A complex type that contains information about the failover criteria for an origin group.</p>', ], ], 'OriginGroupList' => [ 'base' => '<p>List of origin groups for a distribution.</p>', 'refs' => [ 'OriginGroups$Items' => '<p>The items (origin groups) in a distribution.</p>', ], ], 'OriginGroupMember' => [ 'base' => '<p>An origin in an origin group.</p>', 'refs' => [ 'OriginGroupMemberList$member' => NULL, ], ], 'OriginGroupMemberList' => [ 'base' => '<p>List of origins in an origin group.</p>', 'refs' => [ 'OriginGroupMembers$Items' => '<p>Items (origins) in an origin group.</p>', ], ], 'OriginGroupMembers' => [ 'base' => '<p>A complex data type for the origins included in an origin group.</p>', 'refs' => [ 'OriginGroup$Members' => '<p>A complex type that contains information about the origins in an origin group.</p>', ], ], 'OriginGroups' => [ 'base' => '<p>A complex data type for the origin groups specified for a distribution.</p>', 'refs' => [ 'DistributionConfig$OriginGroups' => '<p> A complex type that contains information about origin groups for this distribution.</p>', 'DistributionSummary$OriginGroups' => '<p> A complex type that contains information about origin groups for this distribution.</p>', ], ], 'OriginList' => [ 'base' => NULL, 'refs' => [ 'Origins$Items' => '<p>A list of origins.</p>', ], ], 'OriginProtocolPolicy' => [ 'base' => NULL, 'refs' => [ 'CustomOriginConfig$OriginProtocolPolicy' => '<p>Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values are:</p> <ul> <li> <p> <code>http-only</code> – CloudFront always uses HTTP to connect to the origin.</p> </li> <li> <p> <code>match-viewer</code> – CloudFront connects to the origin using the same protocol that the viewer used to connect to CloudFront.</p> </li> <li> <p> <code>https-only</code> – CloudFront always uses HTTPS to connect to the origin.</p> </li> </ul>', ], ], 'OriginRequestPolicy' => [ 'base' => '<p>An origin request policy.</p> <p>When it’s attached to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:</p> <ul> <li> <p>The request body and the URL path (without the domain name) from the viewer request.</p> </li> <li> <p>The headers that CloudFront automatically includes in every origin request, including <code>Host</code>, <code>User-Agent</code>, and <code>X-Amz-Cf-Id</code>.</p> </li> <li> <p>All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.</p> </li> </ul> <p>CloudFront sends a request when it can’t find an object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use <code>CachePolicy</code>.</p>', 'refs' => [ 'CreateOriginRequestPolicyResult$OriginRequestPolicy' => '<p>An origin request policy.</p>', 'GetOriginRequestPolicyResult$OriginRequestPolicy' => '<p>The origin request policy.</p>', 'OriginRequestPolicySummary$OriginRequestPolicy' => '<p>The origin request policy.</p>', 'UpdateOriginRequestPolicyResult$OriginRequestPolicy' => '<p>An origin request policy.</p>', ], ], 'OriginRequestPolicyAlreadyExists' => [ 'base' => '<p>An origin request policy with this name already exists. You must provide a unique name. To modify an existing origin request policy, use <code>UpdateOriginRequestPolicy</code>.</p>', 'refs' => [], ], 'OriginRequestPolicyConfig' => [ 'base' => '<p>An origin request policy configuration.</p> <p>This configuration determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:</p> <ul> <li> <p>The request body and the URL path (without the domain name) from the viewer request.</p> </li> <li> <p>The headers that CloudFront automatically includes in every origin request, including <code>Host</code>, <code>User-Agent</code>, and <code>X-Amz-Cf-Id</code>.</p> </li> <li> <p>All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.</p> </li> </ul> <p>CloudFront sends a request when it can’t find an object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use <code>CachePolicy</code>.</p>', 'refs' => [ 'CreateOriginRequestPolicyRequest$OriginRequestPolicyConfig' => '<p>An origin request policy configuration.</p>', 'GetOriginRequestPolicyConfigResult$OriginRequestPolicyConfig' => '<p>The origin request policy configuration.</p>', 'OriginRequestPolicy$OriginRequestPolicyConfig' => '<p>The origin request policy configuration.</p>', 'UpdateOriginRequestPolicyRequest$OriginRequestPolicyConfig' => '<p>An origin request policy configuration.</p>', ], ], 'OriginRequestPolicyCookieBehavior' => [ 'base' => NULL, 'refs' => [ 'OriginRequestPolicyCookiesConfig$CookieBehavior' => '<p>Determines whether cookies in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:</p> <ul> <li> <p> <code>none</code> – Cookies in viewer requests are not included in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code>, any cookies that are listed in a <code>CachePolicy</code> <i>are</i> included in origin requests.</p> </li> <li> <p> <code>whitelist</code> – The cookies in viewer requests that are listed in the <code>CookieNames</code> type are included in requests that CloudFront sends to the origin.</p> </li> <li> <p> <code>all</code> – All cookies in viewer requests are included in requests that CloudFront sends to the origin.</p> </li> </ul>', ], ], 'OriginRequestPolicyCookiesConfig' => [ 'base' => '<p>An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in requests that CloudFront sends to the origin.</p>', 'refs' => [ 'OriginRequestPolicyConfig$CookiesConfig' => '<p>The cookies from viewer requests to include in origin requests.</p>', ], ], 'OriginRequestPolicyHeaderBehavior' => [ 'base' => NULL, 'refs' => [ 'OriginRequestPolicyHeadersConfig$HeaderBehavior' => '<p>Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid values are:</p> <ul> <li> <p> <code>none</code> – HTTP headers are not included in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code>, any headers that are listed in a <code>CachePolicy</code> <i>are</i> included in origin requests.</p> </li> <li> <p> <code>whitelist</code> – The HTTP headers that are listed in the <code>Headers</code> type are included in requests that CloudFront sends to the origin.</p> </li> <li> <p> <code>allViewer</code> – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin.</p> </li> <li> <p> <code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the additional CloudFront headers that are listed in the <code>Headers</code> type are included in requests that CloudFront sends to the origin. The additional headers are added by CloudFront.</p> </li> </ul>', ], ], 'OriginRequestPolicyHeadersConfig' => [ 'base' => '<p>An object that determines whether any HTTP headers (and if so, which headers) are included in requests that CloudFront sends to the origin.</p>', 'refs' => [ 'OriginRequestPolicyConfig$HeadersConfig' => '<p>The HTTP headers to include in origin requests. These can include headers from viewer requests and additional headers added by CloudFront.</p>', ], ], 'OriginRequestPolicyInUse' => [ 'base' => '<p>Cannot delete the origin request policy because it is attached to one or more cache behaviors.</p>', 'refs' => [], ], 'OriginRequestPolicyList' => [ 'base' => '<p>A list of origin request policies.</p>', 'refs' => [ 'ListOriginRequestPoliciesResult$OriginRequestPolicyList' => '<p>A list of origin request policies.</p>', ], ], 'OriginRequestPolicyQueryStringBehavior' => [ 'base' => NULL, 'refs' => [ 'OriginRequestPolicyQueryStringsConfig$QueryStringBehavior' => '<p>Determines whether any URL query strings in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:</p> <ul> <li> <p> <code>none</code> – Query strings in viewer requests are not included in requests that CloudFront sends to the origin. Even when this field is set to <code>none</code>, any query strings that are listed in a <code>CachePolicy</code> <i>are</i> included in origin requests.</p> </li> <li> <p> <code>whitelist</code> – The query strings in viewer requests that are listed in the <code>QueryStringNames</code> type are included in requests that CloudFront sends to the origin.</p> </li> <li> <p> <code>all</code> – All query strings in viewer requests are included in requests that CloudFront sends to the origin.</p> </li> </ul>', ], ], 'OriginRequestPolicyQueryStringsConfig' => [ 'base' => '<p>An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in requests that CloudFront sends to the origin.</p>', 'refs' => [ 'OriginRequestPolicyConfig$QueryStringsConfig' => '<p>The URL query strings from viewer requests to include in origin requests.</p>', ], ], 'OriginRequestPolicySummary' => [ 'base' => '<p>Contains an origin request policy.</p>', 'refs' => [ 'OriginRequestPolicySummaryList$member' => NULL, ], ], 'OriginRequestPolicySummaryList' => [ 'base' => NULL, 'refs' => [ 'OriginRequestPolicyList$Items' => '<p>Contains the origin request policies in the list.</p>', ], ], 'OriginRequestPolicyType' => [ 'base' => NULL, 'refs' => [ 'ListOriginRequestPoliciesRequest$Type' => '<p>A filter to return only the specified kinds of origin request policies. Valid values are:</p> <ul> <li> <p> <code>managed</code> – Returns only the managed policies created by Amazon Web Services.</p> </li> <li> <p> <code>custom</code> – Returns only the custom policies created in your Amazon Web Services account.</p> </li> </ul>', 'OriginRequestPolicySummary$Type' => '<p>The type of origin request policy, either <code>managed</code> (created by Amazon Web Services) or <code>custom</code> (created in this Amazon Web Services account).</p>', ], ], 'OriginShield' => [ 'base' => '<p>CloudFront Origin Shield.</p> <p>Using Origin Shield can help reduce the load on your origin. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [ 'Origin$OriginShield' => '<p>CloudFront Origin Shield. Using Origin Shield can help reduce the load on your origin.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', ], ], 'OriginShieldRegion' => [ 'base' => NULL, 'refs' => [ 'OriginShield$OriginShieldRegion' => '<p>The Amazon Web Services Region for Origin Shield.</p> <p>Specify the Amazon Web Services Region that has the lowest latency to your origin. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as <code>us-east-2</code>.</p> <p>When you enable CloudFront Origin Shield, you must specify the Amazon Web Services Region for Origin Shield. For the list of Amazon Web Services Regions that you can specify, and for help choosing the best Region for your origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region">Choosing the Amazon Web Services Region for Origin Shield</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', ], ], 'OriginSslProtocols' => [ 'base' => '<p>A complex type that contains information about the SSL/TLS protocols that CloudFront can use when establishing an HTTPS connection with your origin. </p>', 'refs' => [ 'CustomOriginConfig$OriginSslProtocols' => '<p>Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include <code>SSLv3</code>, <code>TLSv1</code>, <code>TLSv1.1</code>, and <code>TLSv1.2</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols">Minimum Origin SSL Protocol</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', ], ], 'Origins' => [ 'base' => '<p>Contains information about the origins for this distribution.</p>', 'refs' => [ 'DistributionConfig$Origins' => '<p>A complex type that contains information about origins for this distribution. </p>', 'DistributionSummary$Origins' => '<p>A complex type that contains information about origins for this distribution.</p>', ], ], 'ParametersInCacheKeyAndForwardedToOrigin' => [ 'base' => '<p>This object determines the values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.</p> <p>The headers, cookies, and query strings that are included in the cache key are automatically included in requests that CloudFront sends to the origin. CloudFront sends a request when it can’t find an object in its cache that matches the request’s cache key. If you want to send values to the origin but <i>not</i> include them in the cache key, use <code>OriginRequestPolicy</code>.</p>', 'refs' => [ 'CachePolicyConfig$ParametersInCacheKeyAndForwardedToOrigin' => '<p>The HTTP headers, cookies, and URL query strings to include in the cache key. The values included in the cache key are automatically included in requests that CloudFront sends to the origin.</p>', ], ], 'PathList' => [ 'base' => NULL, 'refs' => [ 'Paths$Items' => '<p>A complex type that contains a list of the paths that you want to invalidate.</p>', ], ], 'Paths' => [ 'base' => '<p>A complex type that contains information about the objects that you want to invalidate. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects">Specifying the Objects to Invalidate</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>', 'refs' => [ 'InvalidationBatch$Paths' => '<p>A complex type that contains information about the objects that you want to invalidate. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects">Specifying the Objects to Invalidate</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>', ], ], 'PreconditionFailed' => [ 'base' => '<p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>', 'refs' => [], ], 'PriceClass' => [ 'base' => NULL, 'refs' => [ 'DistributionConfig$PriceClass' => '<p>The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all CloudFront edge locations.</p> <p>If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects from the CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who are in or near regions that are excluded from your specified price class may encounter slower performance.</p> <p>For more information about price classes, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For information about CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions, see <a href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a>.</p>', 'DistributionSummary$PriceClass' => '<p>A complex type that contains information about price class for this streaming distribution. </p>', 'StreamingDistributionConfig$PriceClass' => '<p>A complex type that contains information about price class for this streaming distribution. </p>', 'StreamingDistributionSummary$PriceClass' => '<p>A complex type that contains information about price class for this streaming distribution. </p>', ], ], 'PublicKey' => [ 'base' => '<p>A public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>', 'refs' => [ 'CreatePublicKeyResult$PublicKey' => '<p>The public key.</p>', 'GetPublicKeyResult$PublicKey' => '<p>The public key.</p>', 'UpdatePublicKeyResult$PublicKey' => '<p>The public key.</p>', ], ], 'PublicKeyAlreadyExists' => [ 'base' => '<p>The specified public key already exists.</p>', 'refs' => [], ], 'PublicKeyConfig' => [ 'base' => '<p>Configuration information about a public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>', 'refs' => [ 'CreatePublicKeyRequest$PublicKeyConfig' => '<p>A CloudFront public key configuration.</p>', 'GetPublicKeyConfigResult$PublicKeyConfig' => '<p>A public key configuration.</p>', 'PublicKey$PublicKeyConfig' => '<p>Configuration information about a public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>', 'UpdatePublicKeyRequest$PublicKeyConfig' => '<p>A public key configuration.</p>', ], ], 'PublicKeyIdList' => [ 'base' => NULL, 'refs' => [ 'KeyGroupConfig$Items' => '<p>A list of the identifiers of the public keys in the key group.</p>', ], ], 'PublicKeyInUse' => [ 'base' => '<p>The specified public key is in use. </p>', 'refs' => [], ], 'PublicKeyList' => [ 'base' => '<p>A list of public keys that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>', 'refs' => [ 'ListPublicKeysResult$PublicKeyList' => '<p>Returns a list of all public keys that have been added to CloudFront for this account.</p>', ], ], 'PublicKeySummary' => [ 'base' => '<p>Contains information about a public key.</p>', 'refs' => [ 'PublicKeySummaryList$member' => NULL, ], ], 'PublicKeySummaryList' => [ 'base' => NULL, 'refs' => [ 'PublicKeyList$Items' => '<p>A list of public keys.</p>', ], ], 'PublishFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'PublishFunctionResult' => [ 'base' => NULL, 'refs' => [], ], 'QueryArgProfile' => [ 'base' => '<p>Query argument-profile mapping for field-level encryption.</p>', 'refs' => [ 'QueryArgProfileList$member' => NULL, ], ], 'QueryArgProfileConfig' => [ 'base' => '<p>Configuration for query argument-profile mapping for field-level encryption.</p>', 'refs' => [ 'FieldLevelEncryptionConfig$QueryArgProfileConfig' => '<p>A complex data type that specifies when to forward content if a profile isn\'t found and the profile that can be provided as a query argument in a request.</p>', 'FieldLevelEncryptionSummary$QueryArgProfileConfig' => '<p> A summary of a query argument-profile mapping. </p>', ], ], 'QueryArgProfileEmpty' => [ 'base' => '<p>No profile specified for the field-level encryption query argument.</p>', 'refs' => [], ], 'QueryArgProfileList' => [ 'base' => NULL, 'refs' => [ 'QueryArgProfiles$Items' => '<p>Number of items for query argument-profile mapping for field-level encryption.</p>', ], ], 'QueryArgProfiles' => [ 'base' => '<p>Query argument-profile mapping for field-level encryption.</p>', 'refs' => [ 'QueryArgProfileConfig$QueryArgProfiles' => '<p>Profiles specified for query argument-profile mapping for field-level encryption.</p>', ], ], 'QueryStringCacheKeys' => [ 'base' => '<p>This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.</p> <p>If you want to include query strings in the cache key, use <code>QueryStringsConfig</code> in a cache policy. See <code>CachePolicy</code>.</p> <p>If you want to send query strings to the origin but not include them in the cache key, use <code>QueryStringsConfig</code> in an origin request policy. See <code>OriginRequestPolicy</code>.</p> <p>A complex type that contains information about the query string parameters that you want CloudFront to use for caching for a cache behavior. </p>', 'refs' => [ 'ForwardedValues$QueryStringCacheKeys' => '<p>This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.</p> <p>If you want to include query strings in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>A complex type that contains information about the query string parameters that you want CloudFront to use for caching for this cache behavior.</p>', ], ], 'QueryStringCacheKeysList' => [ 'base' => NULL, 'refs' => [ 'QueryStringCacheKeys$Items' => '<p>A list that contains the query string parameters that you want CloudFront to use as a basis for caching for a cache behavior. If <code>Quantity</code> is 0, you can omit <code>Items</code>. </p>', ], ], 'QueryStringNames' => [ 'base' => '<p>Contains a list of query string names.</p>', 'refs' => [ 'CachePolicyQueryStringsConfig$QueryStrings' => '<p>Contains the specific query strings in viewer requests that either <i> <b>are</b> </i> or <i> <b>are not</b> </i> included in the cache key and automatically included in requests that CloudFront sends to the origin. The behavior depends on whether the <code>QueryStringBehavior</code> field in the <code>CachePolicyQueryStringsConfig</code> type is set to <code>whitelist</code> (the listed query strings <i> <b>are</b> </i> included) or <code>allExcept</code> (the listed query strings <i> <b>are not</b> </i> included, but all other query strings are).</p>', 'OriginRequestPolicyQueryStringsConfig$QueryStrings' => '<p>Contains a list of the query strings in viewer requests that are included in requests that CloudFront sends to the origin.</p>', ], ], 'QueryStringNamesList' => [ 'base' => NULL, 'refs' => [ 'QueryStringNames$Items' => '<p>A list of query string names.</p>', ], ], 'RealtimeLogConfig' => [ 'base' => '<p>A real-time log configuration.</p>', 'refs' => [ 'CreateRealtimeLogConfigResult$RealtimeLogConfig' => '<p>A real-time log configuration.</p>', 'GetRealtimeLogConfigResult$RealtimeLogConfig' => '<p>A real-time log configuration.</p>', 'RealtimeLogConfigList$member' => NULL, 'UpdateRealtimeLogConfigResult$RealtimeLogConfig' => '<p>A real-time log configuration.</p>', ], ], 'RealtimeLogConfigAlreadyExists' => [ 'base' => '<p>A real-time log configuration with this name already exists. You must provide a unique name. To modify an existing real-time log configuration, use <code>UpdateRealtimeLogConfig</code>.</p>', 'refs' => [], ], 'RealtimeLogConfigInUse' => [ 'base' => '<p>Cannot delete the real-time log configuration because it is attached to one or more cache behaviors.</p>', 'refs' => [], ], 'RealtimeLogConfigList' => [ 'base' => NULL, 'refs' => [ 'RealtimeLogConfigs$Items' => '<p>Contains the list of real-time log configurations.</p>', ], ], 'RealtimeLogConfigOwnerMismatch' => [ 'base' => '<p>The specified real-time log configuration belongs to a different Amazon Web Services account.</p>', 'refs' => [], ], 'RealtimeLogConfigs' => [ 'base' => '<p>A list of real-time log configurations.</p>', 'refs' => [ 'ListRealtimeLogConfigsResult$RealtimeLogConfigs' => '<p>A list of real-time log configurations.</p>', ], ], 'RealtimeMetricsSubscriptionConfig' => [ 'base' => '<p>A subscription configuration for additional CloudWatch metrics.</p>', 'refs' => [ 'MonitoringSubscription$RealtimeMetricsSubscriptionConfig' => '<p>A subscription configuration for additional CloudWatch metrics.</p>', ], ], 'RealtimeMetricsSubscriptionStatus' => [ 'base' => NULL, 'refs' => [ 'RealtimeMetricsSubscriptionConfig$RealtimeMetricsSubscriptionStatus' => '<p>A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution.</p>', ], ], 'ReferrerPolicyList' => [ 'base' => NULL, 'refs' => [ 'ResponseHeadersPolicyReferrerPolicy$ReferrerPolicy' => '<p>The value of the <code>Referrer-Policy</code> HTTP response header. Valid values are:</p> <ul> <li> <p> <code>no-referrer</code> </p> </li> <li> <p> <code>no-referrer-when-downgrade</code> </p> </li> <li> <p> <code>origin</code> </p> </li> <li> <p> <code>origin-when-cross-origin</code> </p> </li> <li> <p> <code>same-origin</code> </p> </li> <li> <p> <code>strict-origin</code> </p> </li> <li> <p> <code>strict-origin-when-cross-origin</code> </p> </li> <li> <p> <code>unsafe-url</code> </p> </li> </ul> <p>For more information about these values, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.</p>', ], ], 'ResourceARN' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$Resource' => '<p> An ARN of a CloudFront resource.</p>', 'TagResourceRequest$Resource' => '<p> An ARN of a CloudFront resource.</p>', 'UntagResourceRequest$Resource' => '<p> An ARN of a CloudFront resource.</p>', ], ], 'ResourceInUse' => [ 'base' => '<p>Cannot delete this resource because it is in use.</p>', 'refs' => [], ], 'ResponseHeadersPolicy' => [ 'base' => '<p>A response headers policy.</p> <p>A response headers policy contains information about a set of HTTP response headers and their values.</p> <p>After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a CloudFront distribution. When it’s attached to a cache behavior, CloudFront adds the headers in the policy to HTTP responses that it sends for requests that match the cache behavior.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/adding-response-headers.html">Adding HTTP headers to CloudFront responses</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [ 'CreateResponseHeadersPolicyResult$ResponseHeadersPolicy' => '<p>Contains a response headers policy.</p>', 'GetResponseHeadersPolicyResult$ResponseHeadersPolicy' => '<p>Contains a response headers policy.</p>', 'ResponseHeadersPolicySummary$ResponseHeadersPolicy' => '<p>The response headers policy.</p>', 'UpdateResponseHeadersPolicyResult$ResponseHeadersPolicy' => '<p>A response headers policy.</p>', ], ], 'ResponseHeadersPolicyAccessControlAllowHeaders' => [ 'base' => '<p>A list of HTTP header names that CloudFront includes as values for the <code>Access-Control-Allow-Headers</code> HTTP response header.</p> <p>For more information about the <code>Access-Control-Allow-Headers</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers">Access-Control-Allow-Headers</a> in the MDN Web Docs.</p>', 'refs' => [ 'ResponseHeadersPolicyCorsConfig$AccessControlAllowHeaders' => '<p>A list of HTTP header names that CloudFront includes as values for the <code>Access-Control-Allow-Headers</code> HTTP response header.</p> <p>For more information about the <code>Access-Control-Allow-Headers</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers">Access-Control-Allow-Headers</a> in the MDN Web Docs.</p>', ], ], 'ResponseHeadersPolicyAccessControlAllowMethods' => [ 'base' => '<p>A list of HTTP methods that CloudFront includes as values for the <code>Access-Control-Allow-Methods</code> HTTP response header.</p> <p>For more information about the <code>Access-Control-Allow-Methods</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods">Access-Control-Allow-Methods</a> in the MDN Web Docs.</p>', 'refs' => [ 'ResponseHeadersPolicyCorsConfig$AccessControlAllowMethods' => '<p>A list of HTTP methods that CloudFront includes as values for the <code>Access-Control-Allow-Methods</code> HTTP response header.</p> <p>For more information about the <code>Access-Control-Allow-Methods</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods">Access-Control-Allow-Methods</a> in the MDN Web Docs.</p>', ], ], 'ResponseHeadersPolicyAccessControlAllowMethodsValues' => [ 'base' => NULL, 'refs' => [ 'AccessControlAllowMethodsList$member' => NULL, ], ], 'ResponseHeadersPolicyAccessControlAllowOrigins' => [ 'base' => '<p>A list of origins (domain names) that CloudFront can use as the value for the <code>Access-Control-Allow-Origin</code> HTTP response header.</p> <p>For more information about the <code>Access-Control-Allow-Origin</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin">Access-Control-Allow-Origin</a> in the MDN Web Docs.</p>', 'refs' => [ 'ResponseHeadersPolicyCorsConfig$AccessControlAllowOrigins' => '<p>A list of origins (domain names) that CloudFront can use as the value for the <code>Access-Control-Allow-Origin</code> HTTP response header.</p> <p>For more information about the <code>Access-Control-Allow-Origin</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin">Access-Control-Allow-Origin</a> in the MDN Web Docs.</p>', ], ], 'ResponseHeadersPolicyAccessControlExposeHeaders' => [ 'base' => '<p>A list of HTTP headers that CloudFront includes as values for the <code>Access-Control-Expose-Headers</code> HTTP response header.</p> <p>For more information about the <code>Access-Control-Expose-Headers</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers">Access-Control-Expose-Headers</a> in the MDN Web Docs.</p>', 'refs' => [ 'ResponseHeadersPolicyCorsConfig$AccessControlExposeHeaders' => '<p>A list of HTTP headers that CloudFront includes as values for the <code>Access-Control-Expose-Headers</code> HTTP response header.</p> <p>For more information about the <code>Access-Control-Expose-Headers</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers">Access-Control-Expose-Headers</a> in the MDN Web Docs.</p>', ], ], 'ResponseHeadersPolicyAlreadyExists' => [ 'base' => '<p>A response headers policy with this name already exists. You must provide a unique name. To modify an existing response headers policy, use <code>UpdateResponseHeadersPolicy</code>.</p>', 'refs' => [], ], 'ResponseHeadersPolicyConfig' => [ 'base' => '<p>A response headers policy configuration.</p> <p>A response headers policy configuration contains metadata about the response headers policy, and configurations for sets of HTTP response headers and their values. CloudFront adds the headers in the policy to HTTP responses that it sends for requests that match a cache behavior associated with the policy.</p>', 'refs' => [ 'CreateResponseHeadersPolicyRequest$ResponseHeadersPolicyConfig' => '<p>Contains metadata about the response headers policy, and a set of configurations that specify the response headers.</p>', 'GetResponseHeadersPolicyConfigResult$ResponseHeadersPolicyConfig' => '<p>Contains a response headers policy.</p>', 'ResponseHeadersPolicy$ResponseHeadersPolicyConfig' => '<p>A response headers policy configuration.</p> <p>A response headers policy contains information about a set of HTTP response headers and their values. CloudFront adds the headers in the policy to HTTP responses that it sends for requests that match a cache behavior that’s associated with the policy.</p>', 'UpdateResponseHeadersPolicyRequest$ResponseHeadersPolicyConfig' => '<p>A response headers policy configuration.</p>', ], ], 'ResponseHeadersPolicyContentSecurityPolicy' => [ 'base' => '<p>The policy directives and their values that CloudFront includes as values for the <code>Content-Security-Policy</code> HTTP response header.</p> <p>For more information about the <code>Content-Security-Policy</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy">Content-Security-Policy</a> in the MDN Web Docs.</p>', 'refs' => [ 'ResponseHeadersPolicySecurityHeadersConfig$ContentSecurityPolicy' => '<p>The policy directives and their values that CloudFront includes as values for the <code>Content-Security-Policy</code> HTTP response header.</p> <p>For more information about the <code>Content-Security-Policy</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy">Content-Security-Policy</a> in the MDN Web Docs.</p>', ], ], 'ResponseHeadersPolicyContentTypeOptions' => [ 'base' => '<p>Determines whether CloudFront includes the <code>X-Content-Type-Options</code> HTTP response header with its value set to <code>nosniff</code>.</p> <p>For more information about the <code>X-Content-Type-Options</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options">X-Content-Type-Options</a> in the MDN Web Docs.</p>', 'refs' => [ 'ResponseHeadersPolicySecurityHeadersConfig$ContentTypeOptions' => '<p>Determines whether CloudFront includes the <code>X-Content-Type-Options</code> HTTP response header with its value set to <code>nosniff</code>.</p> <p>For more information about the <code>X-Content-Type-Options</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options">X-Content-Type-Options</a> in the MDN Web Docs.</p>', ], ], 'ResponseHeadersPolicyCorsConfig' => [ 'base' => '<p>A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS). CloudFront adds these headers to HTTP responses that it sends for CORS requests that match a cache behavior associated with this response headers policy.</p> <p>For more information about CORS, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">Cross-Origin Resource Sharing (CORS)</a> in the MDN Web Docs.</p>', 'refs' => [ 'ResponseHeadersPolicyConfig$CorsConfig' => '<p>A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).</p>', ], ], 'ResponseHeadersPolicyCustomHeader' => [ 'base' => '<p>An HTTP response header name and its value. CloudFront includes this header in HTTP responses that it sends for requests that match a cache behavior that’s associated with this response headers policy.</p>', 'refs' => [ 'ResponseHeadersPolicyCustomHeaderList$member' => NULL, ], ], 'ResponseHeadersPolicyCustomHeaderList' => [ 'base' => NULL, 'refs' => [ 'ResponseHeadersPolicyCustomHeadersConfig$Items' => '<p>The list of HTTP response headers and their values.</p>', ], ], 'ResponseHeadersPolicyCustomHeadersConfig' => [ 'base' => '<p>A list of HTTP response header names and their values. CloudFront includes these headers in HTTP responses that it sends for requests that match a cache behavior that’s associated with this response headers policy.</p>', 'refs' => [ 'ResponseHeadersPolicyConfig$CustomHeadersConfig' => '<p>A configuration for a set of custom HTTP response headers.</p>', ], ], 'ResponseHeadersPolicyFrameOptions' => [ 'base' => '<p>Determines whether CloudFront includes the <code>X-Frame-Options</code> HTTP response header and the header’s value.</p> <p>For more information about the <code>X-Frame-Options</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.</p>', 'refs' => [ 'ResponseHeadersPolicySecurityHeadersConfig$FrameOptions' => '<p>Determines whether CloudFront includes the <code>X-Frame-Options</code> HTTP response header and the header’s value.</p> <p>For more information about the <code>X-Frame-Options</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options">X-Frame-Options</a> in the MDN Web Docs.</p>', ], ], 'ResponseHeadersPolicyInUse' => [ 'base' => '<p>Cannot delete the response headers policy because it is attached to one or more cache behaviors in a CloudFront distribution. </p>', 'refs' => [], ], 'ResponseHeadersPolicyList' => [ 'base' => '<p>A list of response headers policies.</p>', 'refs' => [ 'ListResponseHeadersPoliciesResult$ResponseHeadersPolicyList' => '<p>A list of response headers policies.</p>', ], ], 'ResponseHeadersPolicyReferrerPolicy' => [ 'base' => '<p>Determines whether CloudFront includes the <code>Referrer-Policy</code> HTTP response header and the header’s value.</p> <p>For more information about the <code>Referrer-Policy</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.</p>', 'refs' => [ 'ResponseHeadersPolicySecurityHeadersConfig$ReferrerPolicy' => '<p>Determines whether CloudFront includes the <code>Referrer-Policy</code> HTTP response header and the header’s value.</p> <p>For more information about the <code>Referrer-Policy</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy">Referrer-Policy</a> in the MDN Web Docs.</p>', ], ], 'ResponseHeadersPolicySecurityHeadersConfig' => [ 'base' => '<p>A configuration for a set of security-related HTTP response headers. CloudFront adds these headers to HTTP responses that it sends for requests that match a cache behavior associated with this response headers policy.</p>', 'refs' => [ 'ResponseHeadersPolicyConfig$SecurityHeadersConfig' => '<p>A configuration for a set of security-related HTTP response headers.</p>', ], ], 'ResponseHeadersPolicyStrictTransportSecurity' => [ 'base' => '<p>Determines whether CloudFront includes the <code>Strict-Transport-Security</code> HTTP response header and the header’s value.</p> <p>For more information about the <code>Strict-Transport-Security</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security">Strict-Transport-Security</a> in the MDN Web Docs.</p>', 'refs' => [ 'ResponseHeadersPolicySecurityHeadersConfig$StrictTransportSecurity' => '<p>Determines whether CloudFront includes the <code>Strict-Transport-Security</code> HTTP response header and the header’s value.</p> <p>For more information about the <code>Strict-Transport-Security</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security">Strict-Transport-Security</a> in the MDN Web Docs.</p>', ], ], 'ResponseHeadersPolicySummary' => [ 'base' => '<p>Contains a response headers policy.</p>', 'refs' => [ 'ResponseHeadersPolicySummaryList$member' => NULL, ], ], 'ResponseHeadersPolicySummaryList' => [ 'base' => NULL, 'refs' => [ 'ResponseHeadersPolicyList$Items' => '<p>The response headers policies in the list.</p>', ], ], 'ResponseHeadersPolicyType' => [ 'base' => NULL, 'refs' => [ 'ListResponseHeadersPoliciesRequest$Type' => '<p>A filter to get only the specified kind of response headers policies. Valid values are:</p> <ul> <li> <p> <code>managed</code> – Gets only the managed policies created by Amazon Web Services.</p> </li> <li> <p> <code>custom</code> – Gets only the custom policies created in your Amazon Web Services account.</p> </li> </ul>', 'ResponseHeadersPolicySummary$Type' => '<p>The type of response headers policy, either <code>managed</code> (created by Amazon Web Services) or <code>custom</code> (created in this Amazon Web Services account).</p>', ], ], 'ResponseHeadersPolicyXSSProtection' => [ 'base' => '<p>Determines whether CloudFront includes the <code>X-XSS-Protection</code> HTTP response header and the header’s value.</p> <p>For more information about the <code>X-XSS-Protection</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>', 'refs' => [ 'ResponseHeadersPolicySecurityHeadersConfig$XSSProtection' => '<p>Determines whether CloudFront includes the <code>X-XSS-Protection</code> HTTP response header and the header’s value.</p> <p>For more information about the <code>X-XSS-Protection</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>', ], ], 'Restrictions' => [ 'base' => '<p>A complex type that identifies ways in which you want to restrict distribution of your content.</p>', 'refs' => [ 'DistributionConfig$Restrictions' => '<p>A complex type that identifies ways in which you want to restrict distribution of your content.</p>', 'DistributionSummary$Restrictions' => '<p>A complex type that identifies ways in which you want to restrict distribution of your content.</p>', ], ], 'S3Origin' => [ 'base' => '<p>A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your media files for distribution.</p>', 'refs' => [ 'StreamingDistributionConfig$S3Origin' => '<p>A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your media files for distribution. </p>', 'StreamingDistributionSummary$S3Origin' => '<p>A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your media files for distribution.</p>', ], ], 'S3OriginConfig' => [ 'base' => '<p>A complex type that contains information about the Amazon S3 origin. If the origin is a custom origin or an S3 bucket that is configured as a website endpoint, use the <code>CustomOriginConfig</code> element instead.</p>', 'refs' => [ 'Origin$S3OriginConfig' => '<p>Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static website hosting. To specify any other type of origin, including an Amazon S3 bucket that is configured with static website hosting, use the <code>CustomOriginConfig</code> type instead.</p>', ], ], 'SSLSupportMethod' => [ 'base' => NULL, 'refs' => [ 'ViewerCertificate$SSLSupportMethod' => '<p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), specify which viewers the distribution accepts HTTPS connections from.</p> <ul> <li> <p> <code>sni-only</code> – The distribution accepts HTTPS connections from only viewers that support <a href="https://en.wikipedia.org/wiki/Server_Name_Indication">server name indication (SNI)</a>. This is recommended. Most browsers and clients support SNI.</p> </li> <li> <p> <code>vip</code> – The distribution accepts HTTPS connections from all viewers including those that don’t support SNI. This is not recommended, and results in additional monthly charges from CloudFront.</p> </li> <li> <p> <code>static-ip</code> - Do not specify this value unless your distribution has been enabled for this feature by the CloudFront team. If you have a use case that requires static IP addresses for a distribution, contact CloudFront through the <a href="https://console.aws.amazon.com/support/home">Amazon Web Services Support Center</a>.</p> </li> </ul> <p>If the distribution uses the CloudFront domain name such as <code>d111111abcdef8.cloudfront.net</code>, don’t set a value for this field.</p>', ], ], 'Signer' => [ 'base' => '<p>A list of Amazon Web Services accounts and the active CloudFront key pairs in each account that CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>', 'refs' => [ 'SignerList$member' => NULL, ], ], 'SignerList' => [ 'base' => NULL, 'refs' => [ 'ActiveTrustedSigners$Items' => '<p>A list of Amazon Web Services accounts and the identifiers of active CloudFront key pairs in each account that CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>', ], ], 'SslProtocol' => [ 'base' => NULL, 'refs' => [ 'SslProtocolsList$member' => NULL, ], ], 'SslProtocolsList' => [ 'base' => NULL, 'refs' => [ 'OriginSslProtocols$Items' => '<p>A list that contains allowed SSL/TLS protocols for this distribution.</p>', ], ], 'StatusCodeList' => [ 'base' => '<p>List of status codes for origin failover.</p>', 'refs' => [ 'StatusCodes$Items' => '<p>The items (status codes) for an origin group.</p>', ], ], 'StatusCodes' => [ 'base' => '<p>A complex data type for the status codes that you specify that, when returned by a primary origin, trigger CloudFront to failover to a second origin.</p>', 'refs' => [ 'OriginGroupFailoverCriteria$StatusCodes' => '<p>The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the second origin.</p>', ], ], 'StreamingDistribution' => [ 'base' => '<p>A streaming distribution tells CloudFront where you want RTMP content to be delivered from, and the details about how to track and manage content delivery.</p>', 'refs' => [ 'CreateStreamingDistributionResult$StreamingDistribution' => '<p>The streaming distribution\'s information.</p>', 'CreateStreamingDistributionWithTagsResult$StreamingDistribution' => '<p>The streaming distribution\'s information. </p>', 'GetStreamingDistributionResult$StreamingDistribution' => '<p>The streaming distribution\'s information.</p>', 'UpdateStreamingDistributionResult$StreamingDistribution' => '<p>The streaming distribution\'s information.</p>', ], ], 'StreamingDistributionAlreadyExists' => [ 'base' => '<p>The caller reference you attempted to create the streaming distribution with is associated with another distribution</p>', 'refs' => [], ], 'StreamingDistributionConfig' => [ 'base' => '<p>The RTMP distribution\'s configuration information.</p>', 'refs' => [ 'CreateStreamingDistributionRequest$StreamingDistributionConfig' => '<p>The streaming distribution\'s configuration information.</p>', 'GetStreamingDistributionConfigResult$StreamingDistributionConfig' => '<p>The streaming distribution\'s configuration information.</p>', 'StreamingDistribution$StreamingDistributionConfig' => '<p>The current configuration information for the RTMP distribution.</p>', 'StreamingDistributionConfigWithTags$StreamingDistributionConfig' => '<p>A streaming distribution Configuration.</p>', 'UpdateStreamingDistributionRequest$StreamingDistributionConfig' => '<p>The streaming distribution\'s configuration information.</p>', ], ], 'StreamingDistributionConfigWithTags' => [ 'base' => '<p>A streaming distribution Configuration and a list of tags to be associated with the streaming distribution.</p>', 'refs' => [ 'CreateStreamingDistributionWithTagsRequest$StreamingDistributionConfigWithTags' => '<p> The streaming distribution\'s configuration information. </p>', ], ], 'StreamingDistributionList' => [ 'base' => '<p>A streaming distribution list. </p>', 'refs' => [ 'ListStreamingDistributionsResult$StreamingDistributionList' => '<p>The <code>StreamingDistributionList</code> type. </p>', ], ], 'StreamingDistributionNotDisabled' => [ 'base' => '<p>The specified CloudFront distribution is not disabled. You must disable the distribution before you can delete it.</p>', 'refs' => [], ], 'StreamingDistributionSummary' => [ 'base' => '<p> A summary of the information for a CloudFront streaming distribution.</p>', 'refs' => [ 'StreamingDistributionSummaryList$member' => NULL, ], ], 'StreamingDistributionSummaryList' => [ 'base' => NULL, 'refs' => [ 'StreamingDistributionList$Items' => '<p>A complex type that contains one <code>StreamingDistributionSummary</code> element for each distribution that was created by the current Amazon Web Services account.</p>', ], ], 'StreamingLoggingConfig' => [ 'base' => '<p>A complex type that controls whether access logs are written for this streaming distribution.</p>', 'refs' => [ 'StreamingDistributionConfig$Logging' => '<p>A complex type that controls whether access logs are written for the streaming distribution. </p>', ], ], 'Tag' => [ 'base' => '<p> A complex type that contains <code>Tag</code> key and <code>Tag</code> value.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => '<p> A string that contains <code>Tag</code> key.</p> <p>The string length should be between 1 and 128 characters. Valid characters include <code>a-z</code>, <code>A-Z</code>, <code>0-9</code>, space, and the special characters <code>_ - . : / = + @</code>.</p>', 'refs' => [ 'Tag$Key' => '<p> A string that contains <code>Tag</code> key.</p> <p>The string length should be between 1 and 128 characters. Valid characters include <code>a-z</code>, <code>A-Z</code>, <code>0-9</code>, space, and the special characters <code>_ - . : / = + @</code>.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'TagKeys$Items' => '<p> A complex type that contains <code>Tag</code> key elements.</p>', ], ], 'TagKeys' => [ 'base' => '<p> A complex type that contains zero or more <code>Tag</code> elements.</p>', 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p> A complex type that contains zero or more <code>Tag</code> key elements.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'Tags$Items' => '<p> A complex type that contains <code>Tag</code> elements.</p>', ], ], 'TagResourceRequest' => [ 'base' => '<p> The request to add tags to a CloudFront resource.</p>', 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p> A string that contains an optional <code>Tag</code> value.</p> <p>The string length should be between 0 and 256 characters. Valid characters include <code>a-z</code>, <code>A-Z</code>, <code>0-9</code>, space, and the special characters <code>_ - . : / = + @</code>.</p>', ], ], 'Tags' => [ 'base' => '<p> A complex type that contains zero or more <code>Tag</code> elements.</p>', 'refs' => [ 'DistributionConfigWithTags$Tags' => '<p>A complex type that contains zero or more <code>Tag</code> elements.</p>', 'ListTagsForResourceResult$Tags' => '<p> A complex type that contains zero or more <code>Tag</code> elements.</p>', 'StreamingDistributionConfigWithTags$Tags' => '<p>A complex type that contains zero or more <code>Tag</code> elements.</p>', 'TagResourceRequest$Tags' => '<p> A complex type that contains zero or more <code>Tag</code> elements.</p>', ], ], 'TestFunctionFailed' => [ 'base' => '<p>The CloudFront function failed.</p>', 'refs' => [], ], 'TestFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'TestFunctionResult' => [ 'base' => NULL, 'refs' => [], ], 'TestResult' => [ 'base' => '<p>Contains the result of testing a CloudFront function with <code>TestFunction</code>.</p>', 'refs' => [ 'TestFunctionResult$TestResult' => '<p>An object that represents the result of running the function with the provided event object.</p>', ], ], 'TooManyCacheBehaviors' => [ 'base' => '<p>You cannot create more cache behaviors for the distribution.</p>', 'refs' => [], ], 'TooManyCachePolicies' => [ 'base' => '<p>You have reached the maximum number of cache policies for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyCertificates' => [ 'base' => '<p>You cannot create anymore custom SSL/TLS certificates.</p>', 'refs' => [], ], 'TooManyCloudFrontOriginAccessIdentities' => [ 'base' => '<p>Processing your request would cause you to exceed the maximum number of origin access identities allowed.</p>', 'refs' => [], ], 'TooManyCookieNamesInWhiteList' => [ 'base' => '<p>Your request contains more cookie names in the whitelist than are allowed per cache behavior.</p>', 'refs' => [], ], 'TooManyCookiesInCachePolicy' => [ 'base' => '<p>The number of cookies in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyCookiesInOriginRequestPolicy' => [ 'base' => '<p>The number of cookies in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyCustomHeadersInResponseHeadersPolicy' => [ 'base' => '<p>The number of custom headers in the response headers policy exceeds the maximum.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyDistributionCNAMEs' => [ 'base' => '<p>Your request contains more CNAMEs than are allowed per distribution.</p>', 'refs' => [], ], 'TooManyDistributions' => [ 'base' => '<p>Processing your request would cause you to exceed the maximum number of distributions allowed.</p>', 'refs' => [], ], 'TooManyDistributionsAssociatedToCachePolicy' => [ 'base' => '<p>The maximum number of distributions have been associated with the specified cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyDistributionsAssociatedToFieldLevelEncryptionConfig' => [ 'base' => '<p>The maximum number of distributions have been associated with the specified configuration for field-level encryption.</p>', 'refs' => [], ], 'TooManyDistributionsAssociatedToKeyGroup' => [ 'base' => '<p>The number of distributions that reference this key group is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyDistributionsAssociatedToOriginRequestPolicy' => [ 'base' => '<p>The maximum number of distributions have been associated with the specified origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyDistributionsAssociatedToResponseHeadersPolicy' => [ 'base' => '<p>The maximum number of distributions have been associated with the specified response headers policy.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyDistributionsWithFunctionAssociations' => [ 'base' => '<p>You have reached the maximum number of distributions that are associated with a CloudFront function. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyDistributionsWithLambdaAssociations' => [ 'base' => '<p>Processing your request would cause the maximum number of distributions with Lambda@Edge function associations per owner to be exceeded.</p>', 'refs' => [], ], 'TooManyDistributionsWithSingleFunctionARN' => [ 'base' => '<p>The maximum number of distributions have been associated with the specified Lambda@Edge function.</p>', 'refs' => [], ], 'TooManyFieldLevelEncryptionConfigs' => [ 'base' => '<p>The maximum number of configurations for field-level encryption have been created.</p>', 'refs' => [], ], 'TooManyFieldLevelEncryptionContentTypeProfiles' => [ 'base' => '<p>The maximum number of content type profiles for field-level encryption have been created.</p>', 'refs' => [], ], 'TooManyFieldLevelEncryptionEncryptionEntities' => [ 'base' => '<p>The maximum number of encryption entities for field-level encryption have been created.</p>', 'refs' => [], ], 'TooManyFieldLevelEncryptionFieldPatterns' => [ 'base' => '<p>The maximum number of field patterns for field-level encryption have been created.</p>', 'refs' => [], ], 'TooManyFieldLevelEncryptionProfiles' => [ 'base' => '<p>The maximum number of profiles for field-level encryption have been created.</p>', 'refs' => [], ], 'TooManyFieldLevelEncryptionQueryArgProfiles' => [ 'base' => '<p>The maximum number of query arg profiles for field-level encryption have been created.</p>', 'refs' => [], ], 'TooManyFunctionAssociations' => [ 'base' => '<p>You have reached the maximum number of CloudFront function associations for this distribution. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyFunctions' => [ 'base' => '<p>You have reached the maximum number of CloudFront functions for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyHeadersInCachePolicy' => [ 'base' => '<p>The number of headers in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyHeadersInForwardedValues' => [ 'base' => '<p>Your request contains too many headers in forwarded values.</p>', 'refs' => [], ], 'TooManyHeadersInOriginRequestPolicy' => [ 'base' => '<p>The number of headers in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyInvalidationsInProgress' => [ 'base' => '<p>You have exceeded the maximum number of allowable InProgress invalidation batch requests, or invalidation objects.</p>', 'refs' => [], ], 'TooManyKeyGroups' => [ 'base' => '<p>You have reached the maximum number of key groups for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyKeyGroupsAssociatedToDistribution' => [ 'base' => '<p>The number of key groups referenced by this distribution is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyLambdaFunctionAssociations' => [ 'base' => '<p>Your request contains more Lambda@Edge function associations than are allowed per distribution.</p>', 'refs' => [], ], 'TooManyOriginCustomHeaders' => [ 'base' => '<p>Your request contains too many origin custom headers.</p>', 'refs' => [], ], 'TooManyOriginGroupsPerDistribution' => [ 'base' => '<p>Processing your request would cause you to exceed the maximum number of origin groups allowed.</p>', 'refs' => [], ], 'TooManyOriginRequestPolicies' => [ 'base' => '<p>You have reached the maximum number of origin request policies for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyOrigins' => [ 'base' => '<p>You cannot create more origins for the distribution.</p>', 'refs' => [], ], 'TooManyPublicKeys' => [ 'base' => '<p>The maximum number of public keys for field-level encryption have been created. To create a new public key, delete one of the existing keys.</p>', 'refs' => [], ], 'TooManyPublicKeysInKeyGroup' => [ 'base' => '<p>The number of public keys in this key group is more than the maximum allowed. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyQueryStringParameters' => [ 'base' => '<p>Your request contains too many query string parameters.</p>', 'refs' => [], ], 'TooManyQueryStringsInCachePolicy' => [ 'base' => '<p>The number of query strings in the cache policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyQueryStringsInOriginRequestPolicy' => [ 'base' => '<p>The number of query strings in the origin request policy exceeds the maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyRealtimeLogConfigs' => [ 'base' => '<p>You have reached the maximum number of real-time log configurations for this Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyResponseHeadersPolicies' => [ 'base' => '<p>You have reached the maximum number of response headers policies for this Amazon Web Services account.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [], ], 'TooManyStreamingDistributionCNAMEs' => [ 'base' => '<p>Your request contains more CNAMEs than are allowed per distribution.</p>', 'refs' => [], ], 'TooManyStreamingDistributions' => [ 'base' => '<p>Processing your request would cause you to exceed the maximum number of streaming distributions allowed.</p>', 'refs' => [], ], 'TooManyTrustedSigners' => [ 'base' => '<p>Your request contains more trusted signers than are allowed per distribution.</p>', 'refs' => [], ], 'TrustedKeyGroupDoesNotExist' => [ 'base' => '<p>The specified key group does not exist.</p>', 'refs' => [], ], 'TrustedKeyGroupIdList' => [ 'base' => NULL, 'refs' => [ 'TrustedKeyGroups$Items' => '<p>A list of key groups identifiers.</p>', ], ], 'TrustedKeyGroups' => [ 'base' => '<p>A list of key groups whose public keys CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>', 'refs' => [ 'CacheBehavior$TrustedKeyGroups' => '<p>A list of key groups that CloudFront can use to validate signed URLs or signed cookies.</p> <p>When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'DefaultCacheBehavior$TrustedKeyGroups' => '<p>A list of key groups that CloudFront can use to validate signed URLs or signed cookies.</p> <p>When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', ], ], 'TrustedSignerDoesNotExist' => [ 'base' => '<p>One or more of your trusted signers don\'t exist.</p>', 'refs' => [], ], 'TrustedSigners' => [ 'base' => '<p>A list of Amazon Web Services accounts whose public keys CloudFront can use to verify the signatures of signed URLs and signed cookies.</p>', 'refs' => [ 'CacheBehavior$TrustedSigners' => '<important> <p>We recommend using <code>TrustedKeyGroups</code> instead of <code>TrustedSigners</code>.</p> </important> <p>A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.</p> <p>When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in the trusted signer’s Amazon Web Services account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'DefaultCacheBehavior$TrustedSigners' => '<important> <p>We recommend using <code>TrustedKeyGroups</code> instead of <code>TrustedSigners</code>.</p> </important> <p>A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.</p> <p>When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in a trusted signer’s Amazon Web Services account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'StreamingDistributionConfig$TrustedSigners' => '<p>A complex type that specifies any Amazon Web Services accounts that you want to permit to create signed URLs for private content. If you want the distribution to use signed URLs, include this element; if you want the distribution to use public URLs, remove this element. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>', 'StreamingDistributionSummary$TrustedSigners' => '<p>A complex type that specifies the Amazon Web Services accounts, if any, that you want to allow to create signed URLs for private content. If you want to require signed URLs in requests for objects in the target origin that match the <code>PathPattern</code> for this cache behavior, specify <code>true</code> for <code>Enabled</code>, and specify the applicable values for <code>Quantity</code> and <code>Items</code>.If you don\'t want to require signed URLs in requests for objects that match <code>PathPattern</code>, specify <code>false</code> for <code>Enabled</code> and <code>0</code> for <code>Quantity</code>. Omit <code>Items</code>. To add, change, or remove one or more trusted signers, change <code>Enabled</code> to <code>true</code> (if it\'s currently <code>false</code>), change <code>Quantity</code> as applicable, and specify all of the trusted signers that you want to include in the updated distribution.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>. </p>', ], ], 'UnsupportedOperation' => [ 'base' => '<p>This operation is not supported in this region.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => '<p> The request to remove tags from a CloudFront resource.</p>', 'refs' => [], ], 'UpdateCachePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCachePolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCloudFrontOriginAccessIdentityRequest' => [ 'base' => '<p>The request to update an origin access identity.</p>', 'refs' => [], ], 'UpdateCloudFrontOriginAccessIdentityResult' => [ 'base' => '<p>The returned result of the corresponding request.</p>', 'refs' => [], ], 'UpdateDistributionRequest' => [ 'base' => '<p>The request to update a distribution.</p>', 'refs' => [], ], 'UpdateDistributionResult' => [ 'base' => '<p>The returned result of the corresponding request.</p>', 'refs' => [], ], 'UpdateFieldLevelEncryptionConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFieldLevelEncryptionConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFieldLevelEncryptionProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFieldLevelEncryptionProfileResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFunctionResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKeyGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKeyGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOriginRequestPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOriginRequestPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePublicKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePublicKeyResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRealtimeLogConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRealtimeLogConfigResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResponseHeadersPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResponseHeadersPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStreamingDistributionRequest' => [ 'base' => '<p>The request to update a streaming distribution.</p>', 'refs' => [], ], 'UpdateStreamingDistributionResult' => [ 'base' => '<p>The returned result of the corresponding request.</p>', 'refs' => [], ], 'ViewerCertificate' => [ 'base' => '<p>A complex type that determines the distribution’s SSL/TLS configuration for communicating with viewers.</p> <p>If the distribution doesn’t use <code>Aliases</code> (also known as alternate domain names or CNAMEs)—that is, if the distribution uses the CloudFront domain name such as <code>d111111abcdef8.cloudfront.net</code>—set <code>CloudFrontDefaultCertificate</code> to <code>true</code> and leave all other fields empty.</p> <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), use the fields in this type to specify the following settings:</p> <ul> <li> <p>Which viewers the distribution accepts HTTPS connections from: only viewers that support <a href="https://en.wikipedia.org/wiki/Server_Name_Indication">server name indication (SNI)</a> (recommended), or all viewers including those that don’t support SNI.</p> <ul> <li> <p>To accept HTTPS connections from only viewers that support SNI, set <code>SSLSupportMethod</code> to <code>sni-only</code>. This is recommended. Most browsers and clients support SNI. </p> </li> <li> <p>To accept HTTPS connections from all viewers, including those that don’t support SNI, set <code>SSLSupportMethod</code> to <code>vip</code>. This is not recommended, and results in additional monthly charges from CloudFront.</p> </li> </ul> </li> <li> <p>The minimum SSL/TLS protocol version that the distribution can use to communicate with viewers. To specify a minimum version, choose a value for <code>MinimumProtocolVersion</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy">Security Policy</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> </li> <li> <p>The location of the SSL/TLS certificate, <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html">Certificate Manager (ACM)</a> (recommended) or <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Identity and Access Management (IAM)</a>. You specify the location by setting a value in one of the following fields (not both):</p> <ul> <li> <p> <code>ACMCertificateArn</code> </p> </li> <li> <p> <code>IAMCertificateId</code> </p> </li> </ul> </li> </ul> <p>All distributions support HTTPS connections from viewers. To require viewers to use HTTPS only, or to redirect them from HTTP to HTTPS, use <code>ViewerProtocolPolicy</code> in the <code>CacheBehavior</code> or <code>DefaultCacheBehavior</code>. To specify how CloudFront should use SSL/TLS to communicate with your custom origin, use <code>CustomOriginConfig</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https.html">Using HTTPS with CloudFront</a> and <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-alternate-domain-names.html"> Using Alternate Domain Names and HTTPS</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'refs' => [ 'DistributionConfig$ViewerCertificate' => '<p>A complex type that determines the distribution’s SSL/TLS configuration for communicating with viewers.</p>', 'DistributionSummary$ViewerCertificate' => '<p>A complex type that determines the distribution’s SSL/TLS configuration for communicating with viewers.</p>', ], ], 'ViewerProtocolPolicy' => [ 'base' => NULL, 'refs' => [ 'CacheBehavior$ViewerProtocolPolicy' => '<p>The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code>. You can specify the following options:</p> <ul> <li> <p> <code>allow-all</code>: Viewers can use HTTP or HTTPS.</p> </li> <li> <p> <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL. </p> </li> <li> <p> <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden). </p> </li> </ul> <p>For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <note> <p>The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects’ cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache Expiration</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> </note>', 'DefaultCacheBehavior$ViewerProtocolPolicy' => '<p>The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code>. You can specify the following options:</p> <ul> <li> <p> <code>allow-all</code>: Viewers can use HTTP or HTTPS.</p> </li> <li> <p> <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.</p> </li> <li> <p> <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).</p> </li> </ul> <p>For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <note> <p>The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects’ cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache Expiration</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> </note>', ], ], 'aliasString' => [ 'base' => NULL, 'refs' => [ 'ListConflictingAliasesRequest$Alias' => '<p>The alias (also called a CNAME) to search for conflicting aliases.</p>', ], ], 'boolean' => [ 'base' => NULL, 'refs' => [ 'ActiveTrustedKeyGroups$Enabled' => '<p>This field is <code>true</code> if any of the key groups have public keys that CloudFront can use to verify the signatures of signed URLs and signed cookies. If not, this field is <code>false</code>.</p>', 'ActiveTrustedSigners$Enabled' => '<p>This field is <code>true</code> if any of the Amazon Web Services accounts in the list have active CloudFront key pairs that CloudFront can use to verify the signatures of signed URLs and signed cookies. If not, this field is <code>false</code>.</p>', 'CacheBehavior$SmoothStreaming' => '<p>Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify <code>true</code>; if not, specify <code>false</code>. If you specify <code>true</code> for <code>SmoothStreaming</code>, you can still distribute other content using this cache behavior if the content matches the value of <code>PathPattern</code>. </p>', 'CacheBehavior$Compress' => '<p>Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify true; if not, specify false. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'CloudFrontOriginAccessIdentityList$IsTruncated' => '<p>A flag that indicates whether more origin access identities remain to be listed. If your results were truncated, you can make a follow-up pagination request using the <code>Marker</code> request parameter to retrieve more items in the list.</p>', 'ContentTypeProfileConfig$ForwardWhenContentTypeIsUnknown' => '<p>The setting in a field-level encryption content type-profile mapping that specifies what to do when an unknown content type is provided for the profile. If true, content is forwarded without being encrypted when the content type is unknown. If false (the default), an error is returned when the content type is unknown. </p>', 'DefaultCacheBehavior$SmoothStreaming' => '<p>Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify <code>true</code>; if not, specify <code>false</code>. If you specify <code>true</code> for <code>SmoothStreaming</code>, you can still distribute other content using this cache behavior if the content matches the value of <code>PathPattern</code>. </p>', 'DefaultCacheBehavior$Compress' => '<p>Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify <code>true</code>; if not, specify <code>false</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'DistributionConfig$Enabled' => '<p>From this field, you can enable or disable the selected distribution.</p>', 'DistributionConfig$IsIPV6Enabled' => '<p>If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify <code>true</code>. If you specify <code>false</code>, CloudFront responds to IPv6 DNS requests with the DNS response code <code>NOERROR</code> and with no IP addresses. This allows viewers to submit a second request, for an IPv4 address for your distribution. </p> <p>In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However, if you\'re using signed URLs or signed cookies to restrict access to your content, and if you\'re using a custom policy that includes the <code>IpAddress</code> parameter to restrict the IP addresses that can access your content, don\'t enable IPv6. If you want to restrict access to some content by IP address and not restrict access to other content (or restrict access but not by IP address), you can create two distributions. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html">Creating a Signed URL Using a Custom Policy</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you\'re using an Route 53 Amazon Web Services Integration alias resource record set to route traffic to your CloudFront distribution, you need to create a second alias resource record set when both of the following are true:</p> <ul> <li> <p>You enable IPv6 for the distribution</p> </li> <li> <p>You\'re using alternate domain names in the URLs for your objects</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html">Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the <i>Route 53 Amazon Web Services Integration Developer Guide</i>.</p> <p>If you created a CNAME resource record set, either with Route 53 Amazon Web Services Integration or with another DNS service, you don\'t need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP address format of the viewer request.</p>', 'DistributionIdList$IsTruncated' => '<p>A flag that indicates whether more distribution IDs remain to be listed. If your results were truncated, you can make a subsequent request using the <code>Marker</code> request field to retrieve more distribution IDs in the list.</p>', 'DistributionList$IsTruncated' => '<p>A flag that indicates whether more distributions remain to be listed. If your results were truncated, you can make a follow-up pagination request using the <code>Marker</code> request parameter to retrieve more distributions in the list.</p>', 'DistributionSummary$Enabled' => '<p>Whether the distribution is enabled to accept user requests for content.</p>', 'DistributionSummary$IsIPV6Enabled' => '<p>Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.</p>', 'ForwardedValues$QueryString' => '<p>This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.</p> <p>If you want to include query strings in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value of <code>QueryString</code> and on the values that you specify for <code>QueryStringCacheKeys</code>, if any:</p> <p>If you specify true for <code>QueryString</code> and you don\'t specify any values for <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin and caches based on all query string parameters. Depending on how many query string parameters and values you have, this can adversely affect performance because CloudFront must forward more requests to the origin.</p> <p>If you specify true for <code>QueryString</code> and you specify one or more values for <code>QueryStringCacheKeys</code>, CloudFront forwards all query string parameters to the origin, but it only caches based on the query string parameters that you specify.</p> <p>If you specify false for <code>QueryString</code>, CloudFront doesn\'t forward any query string parameters to the origin, and doesn\'t cache based on query string parameters.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html">Configuring CloudFront to Cache Based on Query String Parameters</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'InvalidationList$IsTruncated' => '<p>A flag that indicates whether more invalidation batch requests remain to be listed. If your results were truncated, you can make a follow-up pagination request using the <code>Marker</code> request parameter to retrieve more invalidation batches in the list.</p>', 'LambdaFunctionAssociation$IncludeBody' => '<p>A flag that allows a Lambda@Edge function to have read access to the body content. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html">Accessing the Request Body by Choosing the Include Body Option</a> in the Amazon CloudFront Developer Guide.</p>', 'LoggingConfig$Enabled' => '<p>Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don\'t want to enable logging when you create a distribution or if you want to disable logging for an existing distribution, specify <code>false</code> for <code>Enabled</code>, and specify empty <code>Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for <code>Enabled</code> but you specify values for <code>Bucket</code>, <code>prefix</code>, and <code>IncludeCookies</code>, the values are automatically deleted.</p>', 'LoggingConfig$IncludeCookies' => '<p>Specifies whether you want CloudFront to include cookies in access logs, specify <code>true</code> for <code>IncludeCookies</code>. If you choose to include cookies in logs, CloudFront logs all cookies regardless of how you configure the cache behaviors for this distribution. If you don\'t want to include cookies when you create a distribution or if you want to disable include cookies for an existing distribution, specify <code>false</code> for <code>IncludeCookies</code>.</p>', 'OriginShield$Enabled' => '<p>A flag that specifies whether Origin Shield is enabled.</p> <p>When it’s enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin. When it’s disabled, CloudFront might send requests directly to your origin from multiple edge locations or regional edge caches.</p>', 'ParametersInCacheKeyAndForwardedToOrigin$EnableAcceptEncodingGzip' => '<p>A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.</p> <p>This field is related to the <code>EnableAcceptEncodingBrotli</code> field. If one or both of these fields is <code>true</code> <i>and</i> the viewer request includes the <code>Accept-Encoding</code> header, then CloudFront does the following:</p> <ul> <li> <p>Normalizes the value of the viewer’s <code>Accept-Encoding</code> header</p> </li> <li> <p>Includes the normalized header in the cache key</p> </li> <li> <p>Includes the normalized header in the request to the origin, if a request is necessary</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you set this value to <code>true</code>, and this cache behavior also has an origin request policy attached, do not include the <code>Accept-Encoding</code> header in the origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in origin requests when the value of this field is <code>true</code>, so including this header in an origin request policy has no effect.</p> <p>If both of these fields are <code>false</code>, then CloudFront treats the <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer request. By default, it’s not included in the cache key and it’s not included in origin requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers whitelist like any other HTTP header.</p>', 'ParametersInCacheKeyAndForwardedToOrigin$EnableAcceptEncodingBrotli' => '<p>A flag that can affect whether the <code>Accept-Encoding</code> HTTP header is included in the cache key and included in requests that CloudFront sends to the origin.</p> <p>This field is related to the <code>EnableAcceptEncodingGzip</code> field. If one or both of these fields is <code>true</code> <i>and</i> the viewer request includes the <code>Accept-Encoding</code> header, then CloudFront does the following:</p> <ul> <li> <p>Normalizes the value of the viewer’s <code>Accept-Encoding</code> header</p> </li> <li> <p>Includes the normalized header in the cache key</p> </li> <li> <p>Includes the normalized header in the request to the origin, if a request is necessary</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects">Compression support</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>If you set this value to <code>true</code>, and this cache behavior also has an origin request policy attached, do not include the <code>Accept-Encoding</code> header in the origin request policy. CloudFront always includes the <code>Accept-Encoding</code> header in origin requests when the value of this field is <code>true</code>, so including this header in an origin request policy has no effect.</p> <p>If both of these fields are <code>false</code>, then CloudFront treats the <code>Accept-Encoding</code> header the same as any other HTTP header in the viewer request. By default, it’s not included in the cache key and it’s not included in origin requests. In this case, you can manually add <code>Accept-Encoding</code> to the headers whitelist like any other HTTP header.</p>', 'QueryArgProfileConfig$ForwardWhenQueryArgProfileIsUnknown' => '<p>Flag to set if you want a request to be forwarded to the origin even if the profile specified by the field-level encryption query argument, fle-profile, is unknown.</p>', 'RealtimeLogConfigs$IsTruncated' => '<p>A flag that indicates whether there are more real-time log configurations than are contained in this list.</p>', 'ResponseHeadersPolicyContentSecurityPolicy$Override' => '<p>A Boolean that determines whether CloudFront overrides the <code>Content-Security-Policy</code> HTTP response header received from the origin with the one specified in this response headers policy.</p>', 'ResponseHeadersPolicyContentTypeOptions$Override' => '<p>A Boolean that determines whether CloudFront overrides the <code>X-Content-Type-Options</code> HTTP response header received from the origin with the one specified in this response headers policy.</p>', 'ResponseHeadersPolicyCorsConfig$AccessControlAllowCredentials' => '<p>A Boolean that CloudFront uses as the value for the <code>Access-Control-Allow-Credentials</code> HTTP response header.</p> <p>For more information about the <code>Access-Control-Allow-Credentials</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials">Access-Control-Allow-Credentials</a> in the MDN Web Docs.</p>', 'ResponseHeadersPolicyCorsConfig$OriginOverride' => '<p>A Boolean that determines whether CloudFront overrides HTTP response headers received from the origin with the ones specified in this response headers policy.</p>', 'ResponseHeadersPolicyCustomHeader$Override' => '<p>A Boolean that determines whether CloudFront overrides a response header with the same name received from the origin with the header specified here.</p>', 'ResponseHeadersPolicyFrameOptions$Override' => '<p>A Boolean that determines whether CloudFront overrides the <code>X-Frame-Options</code> HTTP response header received from the origin with the one specified in this response headers policy.</p>', 'ResponseHeadersPolicyReferrerPolicy$Override' => '<p>A Boolean that determines whether CloudFront overrides the <code>Referrer-Policy</code> HTTP response header received from the origin with the one specified in this response headers policy.</p>', 'ResponseHeadersPolicyStrictTransportSecurity$Override' => '<p>A Boolean that determines whether CloudFront overrides the <code>Strict-Transport-Security</code> HTTP response header received from the origin with the one specified in this response headers policy.</p>', 'ResponseHeadersPolicyStrictTransportSecurity$IncludeSubdomains' => '<p>A Boolean that determines whether CloudFront includes the <code>includeSubDomains</code> directive in the <code>Strict-Transport-Security</code> HTTP response header.</p>', 'ResponseHeadersPolicyStrictTransportSecurity$Preload' => '<p>A Boolean that determines whether CloudFront includes the <code>preload</code> directive in the <code>Strict-Transport-Security</code> HTTP response header.</p>', 'ResponseHeadersPolicyXSSProtection$Override' => '<p>A Boolean that determines whether CloudFront overrides the <code>X-XSS-Protection</code> HTTP response header received from the origin with the one specified in this response headers policy.</p>', 'ResponseHeadersPolicyXSSProtection$Protection' => '<p>A Boolean that determines the value of the <code>X-XSS-Protection</code> HTTP response header. When this setting is <code>true</code>, the value of the <code>X-XSS-Protection</code> header is <code>1</code>. When this setting is <code>false</code>, the value of the <code>X-XSS-Protection</code> header is <code>0</code>.</p> <p>For more information about these settings, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>', 'ResponseHeadersPolicyXSSProtection$ModeBlock' => '<p>A Boolean that determines whether CloudFront includes the <code>mode=block</code> directive in the <code>X-XSS-Protection</code> header.</p> <p>For more information about this directive, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>', 'StreamingDistributionConfig$Enabled' => '<p>Whether the streaming distribution is enabled to accept user requests for content.</p>', 'StreamingDistributionList$IsTruncated' => '<p>A flag that indicates whether more streaming distributions remain to be listed. If your results were truncated, you can make a follow-up pagination request using the <code>Marker</code> request parameter to retrieve more distributions in the list. </p>', 'StreamingDistributionSummary$Enabled' => '<p>Whether the distribution is enabled to accept end user requests for content.</p>', 'StreamingLoggingConfig$Enabled' => '<p>Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don\'t want to enable logging when you create a streaming distribution or if you want to disable logging for an existing streaming distribution, specify <code>false</code> for <code>Enabled</code>, and specify <code>empty Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for <code>Enabled</code> but you specify values for <code>Bucket</code> and <code>Prefix</code>, the values are automatically deleted. </p>', 'TrustedKeyGroups$Enabled' => '<p>This field is <code>true</code> if any of the key groups in the list have public keys that CloudFront can use to verify the signatures of signed URLs and signed cookies. If not, this field is <code>false</code>.</p>', 'TrustedSigners$Enabled' => '<p>This field is <code>true</code> if any of the Amazon Web Services accounts have public keys that CloudFront can use to verify the signatures of signed URLs and signed cookies. If not, this field is <code>false</code>.</p>', 'ViewerCertificate$CloudFrontDefaultCertificate' => '<p>If the distribution uses the CloudFront domain name such as <code>d111111abcdef8.cloudfront.net</code>, set this field to <code>true</code>.</p> <p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), set this field to <code>false</code> and specify values for the following fields:</p> <ul> <li> <p> <code>ACMCertificateArn</code> or <code>IAMCertificateId</code> (specify a value for one, not both)</p> </li> <li> <p> <code>MinimumProtocolVersion</code> </p> </li> <li> <p> <code>SSLSupportMethod</code> </p> </li> </ul>', ], ], 'distributionIdString' => [ 'base' => NULL, 'refs' => [ 'ListConflictingAliasesRequest$DistributionId' => '<p>The ID of a distribution in your account that has an attached SSL/TLS certificate that includes the provided alias.</p>', ], ], 'integer' => [ 'base' => NULL, 'refs' => [ 'ActiveTrustedKeyGroups$Quantity' => '<p>The number of key groups in the list.</p>', 'ActiveTrustedSigners$Quantity' => '<p>The number of Amazon Web Services accounts in the list.</p>', 'Aliases$Quantity' => '<p>The number of CNAME aliases, if any, that you want to associate with this distribution.</p>', 'AllowedMethods$Quantity' => '<p>The number of HTTP methods that you want CloudFront to forward to your origin. Valid values are 2 (for <code>GET</code> and <code>HEAD</code> requests), 3 (for <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code> requests) and 7 (for <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code>, and <code>DELETE</code> requests).</p>', 'CacheBehaviors$Quantity' => '<p>The number of cache behaviors for this distribution. </p>', 'CachePolicyList$MaxItems' => '<p>The maximum number of cache policies requested.</p>', 'CachePolicyList$Quantity' => '<p>The total number of cache policies returned in the response.</p>', 'CachedMethods$Quantity' => '<p>The number of HTTP methods for which you want CloudFront to cache responses. Valid values are <code>2</code> (for caching responses to <code>GET</code> and <code>HEAD</code> requests) and <code>3</code> (for caching responses to <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code> requests).</p>', 'CloudFrontOriginAccessIdentityList$MaxItems' => '<p>The maximum number of origin access identities you want in the response body. </p>', 'CloudFrontOriginAccessIdentityList$Quantity' => '<p>The number of CloudFront origin access identities that were created by the current Amazon Web Services account.</p>', 'ConflictingAliasesList$MaxItems' => '<p>The maximum number of conflicting aliases requested.</p>', 'ConflictingAliasesList$Quantity' => '<p>The number of conflicting aliases returned in the response.</p>', 'ContentTypeProfiles$Quantity' => '<p>The number of field-level encryption content type-profile mappings. </p>', 'CookieNames$Quantity' => '<p>The number of cookie names in the <code>Items</code> list.</p>', 'CustomErrorResponse$ErrorCode' => '<p>The HTTP status code for which you want to specify a custom error page and/or a caching duration.</p>', 'CustomErrorResponses$Quantity' => '<p>The number of HTTP status codes for which you want to specify a custom error page and/or a caching duration. If <code>Quantity</code> is <code>0</code>, you can omit <code>Items</code>.</p>', 'CustomHeaders$Quantity' => '<p>The number of custom headers, if any, for this distribution.</p>', 'CustomOriginConfig$HTTPPort' => '<p>The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin listens on.</p>', 'CustomOriginConfig$HTTPSPort' => '<p>The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the origin listens on.</p>', 'CustomOriginConfig$OriginReadTimeout' => '<p>Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the <i>origin response timeout</i>. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don’t specify otherwise) is 30 seconds.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'CustomOriginConfig$OriginKeepaliveTimeout' => '<p>Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don’t specify otherwise) is 5 seconds.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout">Origin Keep-alive Timeout</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'Distribution$InProgressInvalidationBatches' => '<p>The number of invalidation batches currently in progress. </p>', 'DistributionIdList$MaxItems' => '<p>The maximum number of distribution IDs requested.</p>', 'DistributionIdList$Quantity' => '<p>The total number of distribution IDs returned in the response.</p>', 'DistributionList$MaxItems' => '<p>The value you provided for the <code>MaxItems</code> request parameter.</p>', 'DistributionList$Quantity' => '<p>The number of distributions that were created by the current Amazon Web Services account.</p>', 'EncryptionEntities$Quantity' => '<p>Number of field pattern items in a field-level encryption content type-profile mapping. </p>', 'FieldLevelEncryptionList$MaxItems' => '<p>The maximum number of elements you want in the response body. </p>', 'FieldLevelEncryptionList$Quantity' => '<p>The number of field-level encryption items.</p>', 'FieldLevelEncryptionProfileList$MaxItems' => '<p>The maximum number of field-level encryption profiles you want in the response body. </p>', 'FieldLevelEncryptionProfileList$Quantity' => '<p>The number of field-level encryption profiles.</p>', 'FieldPatterns$Quantity' => '<p>The number of field-level encryption field patterns.</p>', 'FunctionAssociations$Quantity' => '<p>The number of CloudFront functions in the list.</p>', 'FunctionList$MaxItems' => '<p>The maximum number of functions requested.</p>', 'FunctionList$Quantity' => '<p>The number of functions returned in the response.</p>', 'GeoRestriction$Quantity' => '<p>When geo restriction is <code>enabled</code>, this is the number of countries in your <code>whitelist</code> or <code>blacklist</code>. Otherwise, when it is not enabled, <code>Quantity</code> is <code>0</code>, and you can omit <code>Items</code>.</p>', 'Headers$Quantity' => '<p>The number of header names in the <code>Items</code> list.</p>', 'InvalidationList$MaxItems' => '<p>The value that you provided for the <code>MaxItems</code> request parameter.</p>', 'InvalidationList$Quantity' => '<p>The number of invalidation batches that were created by the current Amazon Web Services account. </p>', 'KeyGroupList$MaxItems' => '<p>The maximum number of key groups requested.</p>', 'KeyGroupList$Quantity' => '<p>The number of key groups returned in the response.</p>', 'KeyPairIds$Quantity' => '<p>The number of key pair identifiers in the list.</p>', 'LambdaFunctionAssociations$Quantity' => '<p>The number of Lambda@Edge function associations for this cache behavior.</p>', 'Origin$ConnectionAttempts' => '<p>The number of times that CloudFront attempts to connect to the origin. The minimum number is 1, the maximum is 3, and the default (if you don’t specify otherwise) is 3.</p> <p>For a custom origin (including an Amazon S3 bucket that’s configured with static website hosting), this value also specifies the number of times that CloudFront attempts to get a response from the origin, in the case of an <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts">Origin Connection Attempts</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'Origin$ConnectionTimeout' => '<p>The number of seconds that CloudFront waits when trying to establish a connection to the origin. The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you don’t specify otherwise) is 10 seconds.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout">Origin Connection Timeout</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'OriginGroupMembers$Quantity' => '<p>The number of origins in an origin group.</p>', 'OriginGroups$Quantity' => '<p>The number of origin groups.</p>', 'OriginRequestPolicyList$MaxItems' => '<p>The maximum number of origin request policies requested.</p>', 'OriginRequestPolicyList$Quantity' => '<p>The total number of origin request policies returned in the response.</p>', 'OriginSslProtocols$Quantity' => '<p>The number of SSL/TLS protocols that you want to allow CloudFront to use when establishing an HTTPS connection with this origin. </p>', 'Origins$Quantity' => '<p>The number of origins for this distribution.</p>', 'Paths$Quantity' => '<p>The number of invalidation paths specified for the objects that you want to invalidate.</p>', 'PublicKeyList$MaxItems' => '<p>The maximum number of public keys you want in the response.</p>', 'PublicKeyList$Quantity' => '<p>The number of public keys in the list.</p>', 'QueryArgProfiles$Quantity' => '<p>Number of profiles for query argument-profile mapping for field-level encryption.</p>', 'QueryStringCacheKeys$Quantity' => '<p>The number of <code>whitelisted</code> query string parameters for a cache behavior.</p>', 'QueryStringNames$Quantity' => '<p>The number of query string names in the <code>Items</code> list.</p>', 'RealtimeLogConfigs$MaxItems' => '<p>The maximum number of real-time log configurations requested.</p>', 'ResponseHeadersPolicyAccessControlAllowHeaders$Quantity' => '<p>The number of HTTP header names in the list.</p>', 'ResponseHeadersPolicyAccessControlAllowMethods$Quantity' => '<p>The number of HTTP methods in the list.</p>', 'ResponseHeadersPolicyAccessControlAllowOrigins$Quantity' => '<p>The number of origins in the list.</p>', 'ResponseHeadersPolicyAccessControlExposeHeaders$Quantity' => '<p>The number of HTTP headers in the list.</p>', 'ResponseHeadersPolicyCorsConfig$AccessControlMaxAgeSec' => '<p>A number that CloudFront uses as the value for the <code>Access-Control-Max-Age</code> HTTP response header.</p> <p>For more information about the <code>Access-Control-Max-Age</code> HTTP response header, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age">Access-Control-Max-Age</a> in the MDN Web Docs.</p>', 'ResponseHeadersPolicyCustomHeadersConfig$Quantity' => '<p>The number of HTTP response headers in the list.</p>', 'ResponseHeadersPolicyList$MaxItems' => '<p>The maximum number of response headers policies requested.</p>', 'ResponseHeadersPolicyList$Quantity' => '<p>The number of response headers policies returned.</p>', 'ResponseHeadersPolicyStrictTransportSecurity$AccessControlMaxAgeSec' => '<p>A number that CloudFront uses as the value for the <code>max-age</code> directive in the <code>Strict-Transport-Security</code> HTTP response header.</p>', 'StatusCodeList$member' => NULL, 'StatusCodes$Quantity' => '<p>The number of status codes.</p>', 'StreamingDistributionList$MaxItems' => '<p>The value you provided for the <code>MaxItems</code> request parameter. </p>', 'StreamingDistributionList$Quantity' => '<p>The number of streaming distributions that were created by the current Amazon Web Services account. </p>', 'TrustedKeyGroups$Quantity' => '<p>The number of key groups in the list.</p>', 'TrustedSigners$Quantity' => '<p>The number of Amazon Web Services accounts in the list.</p>', ], ], 'listConflictingAliasesMaxItemsInteger' => [ 'base' => NULL, 'refs' => [ 'ListConflictingAliasesRequest$MaxItems' => '<p>The maximum number of conflicting aliases that you want in the response.</p>', ], ], 'long' => [ 'base' => NULL, 'refs' => [ 'CacheBehavior$MinTTL' => '<p>This field is deprecated. We recommend that you use the <code>MinTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html"> Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <i> Amazon CloudFront Developer Guide</i>.</p> <p>You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all headers to your origin (under <code>Headers</code>, if you specify <code>1</code> for <code>Quantity</code> and <code>*</code> for <code>Name</code>).</p>', 'CacheBehavior$DefaultTTL' => '<p>This field is deprecated. We recommend that you use the <code>DefaultTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'CacheBehavior$MaxTTL' => '<p>This field is deprecated. We recommend that you use the <code>MaxTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'CachePolicyConfig$DefaultTTL' => '<p>The default amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value as the object’s time to live (TTL) only when the origin does <i>not</i> send <code>Cache-Control</code> or <code>Expires</code> headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>The default value for this field is 86400 seconds (one day). If the value of <code>MinTTL</code> is more than 86400 seconds, then the default value for this field is the same as the value of <code>MinTTL</code>.</p>', 'CachePolicyConfig$MaxTTL' => '<p>The maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value only when the origin sends <code>Cache-Control</code> or <code>Expires</code> headers with the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>The default value for this field is 31536000 seconds (one year). If the value of <code>MinTTL</code> or <code>DefaultTTL</code> is more than 31536000 seconds, then the default value for this field is the same as the value of <code>DefaultTTL</code>.</p>', 'CachePolicyConfig$MinTTL' => '<p>The minimum amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'CreateRealtimeLogConfigRequest$SamplingRate' => '<p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>', 'CustomErrorResponse$ErrorCachingMinTTL' => '<p>The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status code specified in <code>ErrorCode</code>. When this time period has elapsed, CloudFront queries your origin to see whether the problem that caused the error has been resolved and the requested object is now available.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'DefaultCacheBehavior$MinTTL' => '<p>This field is deprecated. We recommend that you use the <code>MinTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all headers to your origin (under <code>Headers</code>, if you specify <code>1</code> for <code>Quantity</code> and <code>*</code> for <code>Name</code>).</p>', 'DefaultCacheBehavior$DefaultTTL' => '<p>This field is deprecated. We recommend that you use the <code>DefaultTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'DefaultCacheBehavior$MaxTTL' => '<p>This field is deprecated. We recommend that you use the <code>MaxTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'RealtimeLogConfig$SamplingRate' => '<p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. The sampling rate is an integer between 1 and 100, inclusive.</p>', 'UpdateRealtimeLogConfigRequest$SamplingRate' => '<p>The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.</p>', ], ], 'sensitiveStringType' => [ 'base' => NULL, 'refs' => [ 'OriginCustomHeader$HeaderValue' => '<p>The value for the header that you specified in the <code>HeaderName</code> field.</p>', 'TestResult$FunctionErrorMessage' => '<p>If the result of testing the function was an error, this field contains the error message.</p>', 'TestResult$FunctionOutput' => '<p>The event object returned by the function. For more information about the structure of the event object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/functions-event-structure.html">Event object structure</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'AccessControlAllowHeadersList$member' => NULL, 'AccessControlAllowOriginsList$member' => NULL, 'AccessControlExposeHeadersList$member' => NULL, 'AccessDenied$Message' => NULL, 'AliasICPRecordal$CNAME' => '<p>A domain name associated with a distribution. </p>', 'AliasList$member' => NULL, 'AssociateAliasRequest$TargetDistributionId' => '<p>The ID of the distribution that you’re associating the alias with.</p>', 'AssociateAliasRequest$Alias' => '<p>The alias (also known as a CNAME) to add to the target distribution.</p>', 'AwsAccountNumberList$member' => NULL, 'BatchTooLarge$Message' => NULL, 'CNAMEAlreadyExists$Message' => NULL, 'CacheBehavior$PathPattern' => '<p>The pattern (for example, <code>images/*.jpg</code>) that specifies which requests to apply the behavior to. When CloudFront receives a viewer request, the requested path is compared with path patterns in the order in which cache behaviors are listed in the distribution.</p> <note> <p>You can optionally include a slash (<code>/</code>) at the beginning of the path pattern. For example, <code>/images/*.jpg</code>. CloudFront behavior is the same with or without the leading <code>/</code>.</p> </note> <p>The path pattern for the default cache behavior is <code>*</code> and cannot be changed. If the request for an object does not match the path pattern for any cache behaviors, CloudFront applies the behavior in the default cache behavior.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern">Path Pattern</a> in the <i> Amazon CloudFront Developer Guide</i>.</p>', 'CacheBehavior$TargetOriginId' => '<p>The value of <code>ID</code> for the origin that you want CloudFront to route requests to when they match this cache behavior.</p>', 'CacheBehavior$FieldLevelEncryptionId' => '<p>The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for this cache behavior.</p>', 'CacheBehavior$RealtimeLogConfigArn' => '<p>The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'CacheBehavior$CachePolicyId' => '<p>The unique identifier of the cache policy that is attached to this cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>A <code>CacheBehavior</code> must include either a <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you use a <code>CachePolicyId</code>.</p>', 'CacheBehavior$OriginRequestPolicyId' => '<p>The unique identifier of the origin request policy that is attached to this cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'CacheBehavior$ResponseHeadersPolicyId' => '<p>The identifier for a response headers policy.</p>', 'CachePolicy$Id' => '<p>The unique identifier for the cache policy.</p>', 'CachePolicyAlreadyExists$Message' => NULL, 'CachePolicyConfig$Comment' => '<p>A comment to describe the cache policy. The comment cannot be longer than 128 characters.</p>', 'CachePolicyConfig$Name' => '<p>A unique name to identify the cache policy.</p>', 'CachePolicyInUse$Message' => NULL, 'CachePolicyList$NextMarker' => '<p>If there are more items in the list than are in this response, this element is present. It contains the value that you should use in the <code>Marker</code> field of a subsequent request to continue listing cache policies where you left off.</p>', 'CannotChangeImmutablePublicKeyFields$Message' => NULL, 'CloudFrontOriginAccessIdentity$Id' => '<p>The ID for the origin access identity, for example, <code>E74FTE3AJFJ256A</code>. </p>', 'CloudFrontOriginAccessIdentity$S3CanonicalUserId' => '<p>The Amazon S3 canonical user ID for the origin access identity, used when giving the origin access identity read permission to an object in Amazon S3. </p>', 'CloudFrontOriginAccessIdentityAlreadyExists$Message' => NULL, 'CloudFrontOriginAccessIdentityConfig$CallerReference' => '<p>A unique value (for example, a date-time stamp) that ensures that the request can\'t be replayed.</p> <p>If the value of <code>CallerReference</code> is new (regardless of the content of the <code>CloudFrontOriginAccessIdentityConfig</code> object), a new origin access identity is created.</p> <p>If the <code>CallerReference</code> is a value already sent in a previous identity request, and the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is identical to the original request (ignoring white space), the response includes the same information returned to the original request. </p> <p>If the <code>CallerReference</code> is a value you already sent in a previous request to create an identity, but the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request, CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error. </p>', 'CloudFrontOriginAccessIdentityConfig$Comment' => '<p>A comment to describe the origin access identity. The comment cannot be longer than 128 characters.</p>', 'CloudFrontOriginAccessIdentityInUse$Message' => NULL, 'CloudFrontOriginAccessIdentityList$Marker' => '<p>Use this when paginating results to indicate where to begin in your list of origin access identities. The results include identities in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page\'s response (which is also the ID of the last identity on that page). </p>', 'CloudFrontOriginAccessIdentityList$NextMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you can use for the <code>Marker</code> request parameter to continue listing your origin access identities where they left off. </p>', 'CloudFrontOriginAccessIdentitySummary$Id' => '<p>The ID for the origin access identity. For example: <code>E74FTE3AJFJ256A</code>.</p>', 'CloudFrontOriginAccessIdentitySummary$S3CanonicalUserId' => '<p>The Amazon S3 canonical user ID for the origin access identity, which you use when giving the origin access identity read permission to an object in Amazon S3.</p>', 'CloudFrontOriginAccessIdentitySummary$Comment' => '<p>The comment for this origin access identity, as originally specified when created.</p>', 'ConflictingAlias$Alias' => '<p>An alias (also called a CNAME).</p>', 'ConflictingAlias$DistributionId' => '<p>The (partially hidden) ID of the CloudFront distribution associated with the alias.</p>', 'ConflictingAlias$AccountId' => '<p>The (partially hidden) ID of the Amazon Web Services account that owns the distribution that’s associated with the alias.</p>', 'ConflictingAliasesList$NextMarker' => '<p>If there are more items in the list than are in this response, this element is present. It contains the value that you should use in the <code>Marker</code> field of a subsequent request to continue listing conflicting aliases where you left off.</p>', 'ContentTypeProfile$ProfileId' => '<p>The profile ID for a field-level encryption content type-profile mapping. </p>', 'ContentTypeProfile$ContentType' => '<p>The content type for a field-level encryption content type-profile mapping. </p>', 'CookieNameList$member' => NULL, 'CreateCachePolicyResult$Location' => '<p>The fully qualified URI of the cache policy just created.</p>', 'CreateCachePolicyResult$ETag' => '<p>The current version of the cache policy.</p>', 'CreateCloudFrontOriginAccessIdentityResult$Location' => '<p>The fully qualified URI of the new origin access identity just created.</p>', 'CreateCloudFrontOriginAccessIdentityResult$ETag' => '<p>The current version of the origin access identity created.</p>', 'CreateDistributionResult$Location' => '<p>The fully qualified URI of the new distribution resource just created.</p>', 'CreateDistributionResult$ETag' => '<p>The current version of the distribution created.</p>', 'CreateDistributionWithTagsResult$Location' => '<p>The fully qualified URI of the new distribution resource just created.</p>', 'CreateDistributionWithTagsResult$ETag' => '<p>The current version of the distribution created.</p>', 'CreateFieldLevelEncryptionConfigResult$Location' => '<p>The fully qualified URI of the new configuration resource just created.</p>', 'CreateFieldLevelEncryptionConfigResult$ETag' => '<p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'CreateFieldLevelEncryptionProfileResult$Location' => '<p>The fully qualified URI of the new profile resource just created.</p>', 'CreateFieldLevelEncryptionProfileResult$ETag' => '<p>The current version of the field level encryption profile. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'CreateFunctionResult$Location' => '<p>The URL of the CloudFront function. Use the URL to manage the function with the CloudFront API.</p>', 'CreateFunctionResult$ETag' => '<p>The version identifier for the current version of the CloudFront function.</p>', 'CreateInvalidationRequest$DistributionId' => '<p>The distribution\'s id.</p>', 'CreateInvalidationResult$Location' => '<p>The fully qualified URI of the distribution and invalidation batch request, including the <code>Invalidation ID</code>.</p>', 'CreateKeyGroupResult$Location' => '<p>The URL of the key group.</p>', 'CreateKeyGroupResult$ETag' => '<p>The identifier for this version of the key group.</p>', 'CreateMonitoringSubscriptionRequest$DistributionId' => '<p>The ID of the distribution that you are enabling metrics for.</p>', 'CreateOriginRequestPolicyResult$Location' => '<p>The fully qualified URI of the origin request policy just created.</p>', 'CreateOriginRequestPolicyResult$ETag' => '<p>The current version of the origin request policy.</p>', 'CreatePublicKeyResult$Location' => '<p>The URL of the public key.</p>', 'CreatePublicKeyResult$ETag' => '<p>The identifier for this version of the public key.</p>', 'CreateRealtimeLogConfigRequest$Name' => '<p>A unique name to identify this real-time log configuration.</p>', 'CreateResponseHeadersPolicyResult$Location' => '<p>The URL of the response headers policy.</p>', 'CreateResponseHeadersPolicyResult$ETag' => '<p>The version identifier for the current version of the response headers policy.</p>', 'CreateStreamingDistributionResult$Location' => '<p>The fully qualified URI of the new streaming distribution resource just created.</p>', 'CreateStreamingDistributionResult$ETag' => '<p>The current version of the streaming distribution created.</p>', 'CreateStreamingDistributionWithTagsResult$Location' => '<p>The fully qualified URI of the new streaming distribution resource just created.</p>', 'CreateStreamingDistributionWithTagsResult$ETag' => '<p>The current version of the distribution created.</p>', 'CustomErrorResponse$ResponsePagePath' => '<p>The path to the custom error page that you want CloudFront to return to a viewer when your origin returns the HTTP status code specified by <code>ErrorCode</code>, for example, <code>/4xx-errors/403-forbidden.html</code>. If you want to store your objects and your custom error pages in different locations, your distribution must include a cache behavior for which the following is true:</p> <ul> <li> <p>The value of <code>PathPattern</code> matches the path to your custom error messages. For example, suppose you saved custom error pages for 4xx errors in an Amazon S3 bucket in a directory named <code>/4xx-errors</code>. Your distribution must include a cache behavior for which the path pattern routes requests for your custom error pages to that location, for example, <code>/4xx-errors/*</code>. </p> </li> <li> <p>The value of <code>TargetOriginId</code> specifies the value of the <code>ID</code> element for the origin that contains your custom error pages.</p> </li> </ul> <p>If you specify a value for <code>ResponsePagePath</code>, you must also specify a value for <code>ResponseCode</code>.</p> <p>We recommend that you store custom error pages in an Amazon S3 bucket. If you store custom error pages on an HTTP server and the server starts to return 5xx errors, CloudFront can\'t get the files that you want to return to viewers because the origin server is unavailable.</p>', 'CustomErrorResponse$ResponseCode' => '<p>The HTTP status code that you want CloudFront to return to the viewer along with the custom error page. There are a variety of reasons that you might want CloudFront to return a status code different from the status code that your origin returned to CloudFront, for example:</p> <ul> <li> <p>Some Internet devices (some firewalls and corporate proxies, for example) intercept HTTP 4xx and 5xx and prevent the response from being returned to the viewer. If you substitute <code>200</code>, the response typically won\'t be intercepted.</p> </li> <li> <p>If you don\'t care about distinguishing among different client errors or server errors, you can specify <code>400</code> or <code>500</code> as the <code>ResponseCode</code> for all 4xx or 5xx errors.</p> </li> <li> <p>You might want to return a <code>200</code> status code (OK) and static website so your customers don\'t know that your website is down.</p> </li> </ul> <p>If you specify a value for <code>ResponseCode</code>, you must also specify a value for <code>ResponsePagePath</code>.</p>', 'DefaultCacheBehavior$TargetOriginId' => '<p>The value of <code>ID</code> for the origin that you want CloudFront to route requests to when they use the default cache behavior.</p>', 'DefaultCacheBehavior$FieldLevelEncryptionId' => '<p>The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for the default cache behavior.</p>', 'DefaultCacheBehavior$RealtimeLogConfigArn' => '<p>The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'DefaultCacheBehavior$CachePolicyId' => '<p>The unique identifier of the cache policy that is attached to the default cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p> <p>A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or <code>ForwardedValues</code>. We recommend that you use a <code>CachePolicyId</code>.</p>', 'DefaultCacheBehavior$OriginRequestPolicyId' => '<p>The unique identifier of the origin request policy that is attached to the default cache behavior. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'DefaultCacheBehavior$ResponseHeadersPolicyId' => '<p>The identifier for a response headers policy.</p>', 'DeleteCachePolicyRequest$Id' => '<p>The unique identifier for the cache policy that you are deleting. To get the identifier, you can use <code>ListCachePolicies</code>.</p>', 'DeleteCachePolicyRequest$IfMatch' => '<p>The version of the cache policy that you are deleting. The version is the cache policy’s <code>ETag</code> value, which you can get using <code>ListCachePolicies</code>, <code>GetCachePolicy</code>, or <code>GetCachePolicyConfig</code>.</p>', 'DeleteCloudFrontOriginAccessIdentityRequest$Id' => '<p>The origin access identity\'s ID.</p>', 'DeleteCloudFrontOriginAccessIdentityRequest$IfMatch' => '<p>The value of the <code>ETag</code> header you received from a previous <code>GET</code> or <code>PUT</code> request. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'DeleteDistributionRequest$Id' => '<p>The distribution ID. </p>', 'DeleteDistributionRequest$IfMatch' => '<p>The value of the <code>ETag</code> header that you received when you disabled the distribution. For example: <code>E2QWRUHAPOMQZL</code>. </p>', 'DeleteFieldLevelEncryptionConfigRequest$Id' => '<p>The ID of the configuration you want to delete from CloudFront.</p>', 'DeleteFieldLevelEncryptionConfigRequest$IfMatch' => '<p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'DeleteFieldLevelEncryptionProfileRequest$Id' => '<p>Request the ID of the profile you want to delete from CloudFront.</p>', 'DeleteFieldLevelEncryptionProfileRequest$IfMatch' => '<p>The value of the <code>ETag</code> header that you received when retrieving the profile to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'DeleteFunctionRequest$Name' => '<p>The name of the function that you are deleting.</p>', 'DeleteFunctionRequest$IfMatch' => '<p>The current version (<code>ETag</code> value) of the function that you are deleting, which you can get using <code>DescribeFunction</code>.</p>', 'DeleteKeyGroupRequest$Id' => '<p>The identifier of the key group that you are deleting. To get the identifier, use <code>ListKeyGroups</code>.</p>', 'DeleteKeyGroupRequest$IfMatch' => '<p>The version of the key group that you are deleting. The version is the key group’s <code>ETag</code> value. To get the <code>ETag</code>, use <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.</p>', 'DeleteMonitoringSubscriptionRequest$DistributionId' => '<p>The ID of the distribution that you are disabling metrics for.</p>', 'DeleteOriginRequestPolicyRequest$Id' => '<p>The unique identifier for the origin request policy that you are deleting. To get the identifier, you can use <code>ListOriginRequestPolicies</code>.</p>', 'DeleteOriginRequestPolicyRequest$IfMatch' => '<p>The version of the origin request policy that you are deleting. The version is the origin request policy’s <code>ETag</code> value, which you can get using <code>ListOriginRequestPolicies</code>, <code>GetOriginRequestPolicy</code>, or <code>GetOriginRequestPolicyConfig</code>.</p>', 'DeletePublicKeyRequest$Id' => '<p>The ID of the public key you want to remove from CloudFront.</p>', 'DeletePublicKeyRequest$IfMatch' => '<p>The value of the <code>ETag</code> header that you received when retrieving the public key identity to delete. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'DeleteRealtimeLogConfigRequest$Name' => '<p>The name of the real-time log configuration to delete.</p>', 'DeleteRealtimeLogConfigRequest$ARN' => '<p>The Amazon Resource Name (ARN) of the real-time log configuration to delete.</p>', 'DeleteResponseHeadersPolicyRequest$Id' => '<p>The identifier for the response headers policy that you are deleting.</p> <p>To get the identifier, you can use <code>ListResponseHeadersPolicies</code>.</p>', 'DeleteResponseHeadersPolicyRequest$IfMatch' => '<p>The version of the response headers policy that you are deleting.</p> <p>The version is the response headers policy’s <code>ETag</code> value, which you can get using <code>ListResponseHeadersPolicies</code>, <code>GetResponseHeadersPolicy</code>, or <code>GetResponseHeadersPolicyConfig</code>.</p>', 'DeleteStreamingDistributionRequest$Id' => '<p>The distribution ID. </p>', 'DeleteStreamingDistributionRequest$IfMatch' => '<p>The value of the <code>ETag</code> header that you received when you disabled the streaming distribution. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'DescribeFunctionRequest$Name' => '<p>The name of the function that you are getting information about.</p>', 'DescribeFunctionResult$ETag' => '<p>The version identifier for the current version of the CloudFront function.</p>', 'Distribution$Id' => '<p>The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>. </p>', 'Distribution$ARN' => '<p>The ARN (Amazon Resource Name) for the distribution. For example: <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where <code>123456789012</code> is your Amazon Web Services account ID.</p>', 'Distribution$Status' => '<p>This response element indicates the current status of the distribution. When the status is <code>Deployed</code>, the distribution\'s information is fully propagated to all CloudFront edge locations. </p>', 'Distribution$DomainName' => '<p>The domain name corresponding to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>. </p>', 'DistributionAlreadyExists$Message' => NULL, 'DistributionConfig$CallerReference' => '<p>A unique value (for example, a date-time stamp) that ensures that the request can\'t be replayed.</p> <p>If the value of <code>CallerReference</code> is new (regardless of the content of the <code>DistributionConfig</code> object), CloudFront creates a new distribution.</p> <p>If <code>CallerReference</code> is a value that you already sent in a previous request to create a distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.</p>', 'DistributionConfig$DefaultRootObject' => '<p>The object that you want CloudFront to request from your origin (for example, <code>index.html</code>) when a viewer requests the root URL for your distribution (<code>http://www.example.com</code>) instead of an object in your distribution (<code>http://www.example.com/product-description.html</code>). Specifying a default root object avoids exposing the contents of your distribution.</p> <p>Specify only the object name, for example, <code>index.html</code>. Don\'t add a <code>/</code> before the object name.</p> <p>If you don\'t want to specify a default root object when you create a distribution, include an empty <code>DefaultRootObject</code> element.</p> <p>To delete the default root object from an existing distribution, update the distribution configuration and include an empty <code>DefaultRootObject</code> element.</p> <p>To replace the default root object, update the distribution configuration and specify the new object.</p> <p>For more information about the default root object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating a Default Root Object</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'DistributionConfig$WebACLId' => '<p>A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>. To specify a web ACL created using WAF Classic, use the ACL ID, for example <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</p> <p>WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, CloudFront responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page when a request is blocked. For more information about WAF, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF Developer Guide</a>. </p>', 'DistributionIdList$Marker' => '<p>The value provided in the <code>Marker</code> request field.</p>', 'DistributionIdList$NextMarker' => '<p>Contains the value that you should use in the <code>Marker</code> field of a subsequent request to continue listing distribution IDs where you left off.</p>', 'DistributionIdListSummary$member' => NULL, 'DistributionList$Marker' => '<p>The value you provided for the <code>Marker</code> request parameter.</p>', 'DistributionList$NextMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you can use for the <code>Marker</code> request parameter to continue listing your distributions where they left off. </p>', 'DistributionNotDisabled$Message' => NULL, 'DistributionSummary$Id' => '<p>The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.</p>', 'DistributionSummary$ARN' => '<p>The ARN (Amazon Resource Name) for the distribution. For example: <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where <code>123456789012</code> is your Amazon Web Services account ID.</p>', 'DistributionSummary$Status' => '<p>The current status of the distribution. When the status is <code>Deployed</code>, the distribution\'s information is propagated to all CloudFront edge locations.</p>', 'DistributionSummary$DomainName' => '<p>The domain name that corresponds to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>.</p>', 'DistributionSummary$Comment' => '<p>The comment originally specified when this distribution was created.</p>', 'DistributionSummary$WebACLId' => '<p>The Web ACL Id (if any) associated with the distribution.</p>', 'EncryptionEntity$PublicKeyId' => '<p>The public key associated with a set of field-level encryption patterns, to be used when encrypting the fields that match the patterns. </p>', 'EncryptionEntity$ProviderId' => '<p>The provider associated with the public key being used for encryption. This value must also be provided with the private key for applications to be able to decrypt data.</p>', 'EndPoint$StreamType' => '<p>The type of data stream where you are sending real-time log data. The only valid value is <code>Kinesis</code>.</p>', 'FieldLevelEncryption$Id' => '<p>The configuration ID for a field-level encryption configuration which includes a set of profiles that specify certain selected data fields to be encrypted by specific public keys.</p>', 'FieldLevelEncryptionConfig$CallerReference' => '<p>A unique number that ensures the request can\'t be replayed.</p>', 'FieldLevelEncryptionConfig$Comment' => '<p>An optional comment about the configuration. The comment cannot be longer than 128 characters.</p>', 'FieldLevelEncryptionConfigAlreadyExists$Message' => NULL, 'FieldLevelEncryptionConfigInUse$Message' => NULL, 'FieldLevelEncryptionList$NextMarker' => '<p>If there are more elements to be listed, this element is present and contains the value that you can use for the <code>Marker</code> request parameter to continue listing your configurations where you left off.</p>', 'FieldLevelEncryptionProfile$Id' => '<p>The ID for a field-level encryption profile configuration which includes a set of profiles that specify certain selected data fields to be encrypted by specific public keys.</p>', 'FieldLevelEncryptionProfileAlreadyExists$Message' => NULL, 'FieldLevelEncryptionProfileConfig$Name' => '<p>Profile name for the field-level encryption profile.</p>', 'FieldLevelEncryptionProfileConfig$CallerReference' => '<p>A unique number that ensures that the request can\'t be replayed.</p>', 'FieldLevelEncryptionProfileConfig$Comment' => '<p>An optional comment for the field-level encryption profile. The comment cannot be longer than 128 characters.</p>', 'FieldLevelEncryptionProfileInUse$Message' => NULL, 'FieldLevelEncryptionProfileList$NextMarker' => '<p>If there are more elements to be listed, this element is present and contains the value that you can use for the <code>Marker</code> request parameter to continue listing your profiles where you left off.</p>', 'FieldLevelEncryptionProfileSizeExceeded$Message' => NULL, 'FieldLevelEncryptionProfileSummary$Id' => '<p>ID for the field-level encryption profile summary.</p>', 'FieldLevelEncryptionProfileSummary$Name' => '<p>Name for the field-level encryption profile summary.</p>', 'FieldLevelEncryptionProfileSummary$Comment' => '<p>An optional comment for the field-level encryption profile summary. The comment cannot be longer than 128 characters.</p>', 'FieldLevelEncryptionSummary$Id' => '<p>The unique ID of a field-level encryption item.</p>', 'FieldLevelEncryptionSummary$Comment' => '<p>An optional comment about the field-level encryption item. The comment cannot be longer than 128 characters.</p>', 'FieldList$member' => NULL, 'FieldPatternList$member' => NULL, 'FunctionAlreadyExists$Message' => NULL, 'FunctionConfig$Comment' => '<p>A comment to describe the function.</p>', 'FunctionExecutionLogList$member' => NULL, 'FunctionInUse$Message' => NULL, 'FunctionList$NextMarker' => '<p>If there are more items in the list than are in this response, this element is present. It contains the value that you should use in the <code>Marker</code> field of a subsequent request to continue listing functions where you left off.</p>', 'FunctionMetadata$FunctionARN' => '<p>The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the function.</p>', 'FunctionSizeLimitExceeded$Message' => NULL, 'FunctionSummary$Status' => '<p>The status of the CloudFront function.</p>', 'GetCachePolicyConfigRequest$Id' => '<p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>', 'GetCachePolicyConfigResult$ETag' => '<p>The current version of the cache policy.</p>', 'GetCachePolicyRequest$Id' => '<p>The unique identifier for the cache policy. If the cache policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier using <code>ListCachePolicies</code>.</p>', 'GetCachePolicyResult$ETag' => '<p>The current version of the cache policy.</p>', 'GetCloudFrontOriginAccessIdentityConfigRequest$Id' => '<p>The identity\'s ID. </p>', 'GetCloudFrontOriginAccessIdentityConfigResult$ETag' => '<p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'GetCloudFrontOriginAccessIdentityRequest$Id' => '<p>The identity\'s ID.</p>', 'GetCloudFrontOriginAccessIdentityResult$ETag' => '<p>The current version of the origin access identity\'s information. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'GetDistributionConfigRequest$Id' => '<p>The distribution\'s ID. If the ID is empty, an empty distribution configuration is returned.</p>', 'GetDistributionConfigResult$ETag' => '<p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'GetDistributionRequest$Id' => '<p>The distribution\'s ID. If the ID is empty, an empty distribution configuration is returned.</p>', 'GetDistributionResult$ETag' => '<p>The current version of the distribution\'s information. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'GetFieldLevelEncryptionConfigRequest$Id' => '<p>Request the ID for the field-level encryption configuration information.</p>', 'GetFieldLevelEncryptionConfigResult$ETag' => '<p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'GetFieldLevelEncryptionProfileConfigRequest$Id' => '<p>Get the ID for the field-level encryption profile configuration information.</p>', 'GetFieldLevelEncryptionProfileConfigResult$ETag' => '<p>The current version of the field-level encryption profile configuration result. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'GetFieldLevelEncryptionProfileRequest$Id' => '<p>Get the ID for the field-level encryption profile information.</p>', 'GetFieldLevelEncryptionProfileResult$ETag' => '<p>The current version of the field level encryption profile. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'GetFieldLevelEncryptionRequest$Id' => '<p>Request the ID for the field-level encryption configuration information.</p>', 'GetFieldLevelEncryptionResult$ETag' => '<p>The current version of the field level encryption configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'GetFunctionRequest$Name' => '<p>The name of the function whose code you are getting.</p>', 'GetFunctionResult$ETag' => '<p>The version identifier for the current version of the CloudFront function.</p>', 'GetFunctionResult$ContentType' => '<p>The content type (media type) of the response.</p>', 'GetInvalidationRequest$DistributionId' => '<p>The distribution\'s ID.</p>', 'GetInvalidationRequest$Id' => '<p>The identifier for the invalidation request, for example, <code>IDFDVBD632BHDS5</code>.</p>', 'GetKeyGroupConfigRequest$Id' => '<p>The identifier of the key group whose configuration you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>', 'GetKeyGroupConfigResult$ETag' => '<p>The identifier for this version of the key group.</p>', 'GetKeyGroupRequest$Id' => '<p>The identifier of the key group that you are getting. To get the identifier, use <code>ListKeyGroups</code>.</p>', 'GetKeyGroupResult$ETag' => '<p>The identifier for this version of the key group.</p>', 'GetMonitoringSubscriptionRequest$DistributionId' => '<p>The ID of the distribution that you are getting metrics information for.</p>', 'GetOriginRequestPolicyConfigRequest$Id' => '<p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>', 'GetOriginRequestPolicyConfigResult$ETag' => '<p>The current version of the origin request policy.</p>', 'GetOriginRequestPolicyRequest$Id' => '<p>The unique identifier for the origin request policy. If the origin request policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.</p>', 'GetOriginRequestPolicyResult$ETag' => '<p>The current version of the origin request policy.</p>', 'GetPublicKeyConfigRequest$Id' => '<p>The identifier of the public key whose configuration you are getting.</p>', 'GetPublicKeyConfigResult$ETag' => '<p>The identifier for this version of the public key configuration.</p>', 'GetPublicKeyRequest$Id' => '<p>The identifier of the public key you are getting.</p>', 'GetPublicKeyResult$ETag' => '<p>The identifier for this version of the public key.</p>', 'GetRealtimeLogConfigRequest$Name' => '<p>The name of the real-time log configuration to get.</p>', 'GetRealtimeLogConfigRequest$ARN' => '<p>The Amazon Resource Name (ARN) of the real-time log configuration to get.</p>', 'GetResponseHeadersPolicyConfigRequest$Id' => '<p>The identifier for the response headers policy.</p> <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>', 'GetResponseHeadersPolicyConfigResult$ETag' => '<p>The version identifier for the current version of the response headers policy.</p>', 'GetResponseHeadersPolicyRequest$Id' => '<p>The identifier for the response headers policy.</p> <p>If the response headers policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.</p>', 'GetResponseHeadersPolicyResult$ETag' => '<p>The version identifier for the current version of the response headers policy.</p>', 'GetStreamingDistributionConfigRequest$Id' => '<p>The streaming distribution\'s ID.</p>', 'GetStreamingDistributionConfigResult$ETag' => '<p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>. </p>', 'GetStreamingDistributionRequest$Id' => '<p>The streaming distribution\'s ID.</p>', 'GetStreamingDistributionResult$ETag' => '<p>The current version of the streaming distribution\'s information. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'HeaderList$member' => NULL, 'IllegalDelete$Message' => NULL, 'IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior$Message' => NULL, 'IllegalUpdate$Message' => NULL, 'InconsistentQuantities$Message' => NULL, 'InvalidArgument$Message' => NULL, 'InvalidDefaultRootObject$Message' => NULL, 'InvalidErrorCode$Message' => NULL, 'InvalidForwardCookies$Message' => NULL, 'InvalidFunctionAssociation$Message' => NULL, 'InvalidGeoRestrictionParameter$Message' => NULL, 'InvalidHeadersForS3Origin$Message' => NULL, 'InvalidIfMatchVersion$Message' => NULL, 'InvalidLambdaFunctionAssociation$Message' => NULL, 'InvalidLocationCode$Message' => NULL, 'InvalidMinimumProtocolVersion$Message' => NULL, 'InvalidOrigin$Message' => NULL, 'InvalidOriginAccessIdentity$Message' => NULL, 'InvalidOriginKeepaliveTimeout$Message' => NULL, 'InvalidOriginReadTimeout$Message' => NULL, 'InvalidProtocolSettings$Message' => NULL, 'InvalidQueryStringParameters$Message' => NULL, 'InvalidRelativePath$Message' => NULL, 'InvalidRequiredProtocol$Message' => NULL, 'InvalidResponseCode$Message' => NULL, 'InvalidTTLOrder$Message' => NULL, 'InvalidTagging$Message' => NULL, 'InvalidViewerCertificate$Message' => NULL, 'InvalidWebACLId$Message' => NULL, 'Invalidation$Id' => '<p>The identifier for the invalidation request. For example: <code>IDFDVBD632BHDS5</code>.</p>', 'Invalidation$Status' => '<p>The status of the invalidation request. When the invalidation batch is finished, the status is <code>Completed</code>.</p>', 'InvalidationBatch$CallerReference' => '<p>A value that you specify to uniquely identify an invalidation request. CloudFront uses the value to prevent you from accidentally resubmitting an identical request. Whenever you create a new invalidation request, you must specify a new value for <code>CallerReference</code> and change other values in the request as applicable. One way to ensure that the value of <code>CallerReference</code> is unique is to use a <code>timestamp</code>, for example, <code>20120301090000</code>.</p> <p>If you make a second invalidation request with the same value for <code>CallerReference</code>, and if the rest of the request is the same, CloudFront doesn\'t create a new invalidation request. Instead, CloudFront returns information about the invalidation request that you previously created with the same <code>CallerReference</code>.</p> <p>If <code>CallerReference</code> is a value you already sent in a previous invalidation batch request but the content of any <code>Path</code> is different from the original request, CloudFront returns an <code>InvalidationBatchAlreadyExists</code> error.</p>', 'InvalidationList$Marker' => '<p>The value that you provided for the <code>Marker</code> request parameter.</p>', 'InvalidationList$NextMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value that you can use for the <code>Marker</code> request parameter to continue listing your invalidation batches where they left off.</p>', 'InvalidationSummary$Id' => '<p>The unique ID for an invalidation request.</p>', 'InvalidationSummary$Status' => '<p>The status of an invalidation request.</p>', 'KGKeyPairIds$KeyGroupId' => '<p>The identifier of the key group that contains the public keys.</p>', 'KeyGroup$Id' => '<p>The identifier for the key group.</p>', 'KeyGroupAlreadyExists$Message' => NULL, 'KeyGroupConfig$Name' => '<p>A name to identify the key group.</p>', 'KeyGroupConfig$Comment' => '<p>A comment to describe the key group. The comment cannot be longer than 128 characters.</p>', 'KeyGroupList$NextMarker' => '<p>If there are more items in the list than are in this response, this element is present. It contains the value that you should use in the <code>Marker</code> field of a subsequent request to continue listing key groups.</p>', 'KeyPairIdList$member' => NULL, 'KinesisStreamConfig$RoleARN' => '<p>The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that CloudFront can use to send real-time log data to your Kinesis data stream.</p> <p>For more information the IAM role, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role">Real-time log configuration IAM role</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'KinesisStreamConfig$StreamARN' => '<p>The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time log data.</p>', 'ListCachePoliciesRequest$Marker' => '<p>Use this field when paginating results to indicate where to begin in your list of cache policies. The response includes cache policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>', 'ListCachePoliciesRequest$MaxItems' => '<p>The maximum number of cache policies that you want in the response.</p>', 'ListCloudFrontOriginAccessIdentitiesRequest$Marker' => '<p>Use this when paginating results to indicate where to begin in your list of origin access identities. The results include identities in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page\'s response (which is also the ID of the last identity on that page).</p>', 'ListCloudFrontOriginAccessIdentitiesRequest$MaxItems' => '<p>The maximum number of origin access identities you want in the response body. </p>', 'ListConflictingAliasesRequest$Marker' => '<p>Use this field when paginating results to indicate where to begin in the list of conflicting aliases. The response includes conflicting aliases in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>', 'ListDistributionsByCachePolicyIdRequest$Marker' => '<p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>', 'ListDistributionsByCachePolicyIdRequest$MaxItems' => '<p>The maximum number of distribution IDs that you want in the response.</p>', 'ListDistributionsByCachePolicyIdRequest$CachePolicyId' => '<p>The ID of the cache policy whose associated distribution IDs you want to list.</p>', 'ListDistributionsByKeyGroupRequest$Marker' => '<p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>', 'ListDistributionsByKeyGroupRequest$MaxItems' => '<p>The maximum number of distribution IDs that you want in the response.</p>', 'ListDistributionsByKeyGroupRequest$KeyGroupId' => '<p>The ID of the key group whose associated distribution IDs you are listing.</p>', 'ListDistributionsByOriginRequestPolicyIdRequest$Marker' => '<p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>', 'ListDistributionsByOriginRequestPolicyIdRequest$MaxItems' => '<p>The maximum number of distribution IDs that you want in the response.</p>', 'ListDistributionsByOriginRequestPolicyIdRequest$OriginRequestPolicyId' => '<p>The ID of the origin request policy whose associated distribution IDs you want to list.</p>', 'ListDistributionsByRealtimeLogConfigRequest$Marker' => '<p>Use this field when paginating results to indicate where to begin in your list of distributions. The response includes distributions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>', 'ListDistributionsByRealtimeLogConfigRequest$MaxItems' => '<p>The maximum number of distributions that you want in the response.</p>', 'ListDistributionsByRealtimeLogConfigRequest$RealtimeLogConfigName' => '<p>The name of the real-time log configuration whose associated distributions you want to list.</p>', 'ListDistributionsByRealtimeLogConfigRequest$RealtimeLogConfigArn' => '<p>The Amazon Resource Name (ARN) of the real-time log configuration whose associated distributions you want to list.</p>', 'ListDistributionsByResponseHeadersPolicyIdRequest$Marker' => '<p>Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>', 'ListDistributionsByResponseHeadersPolicyIdRequest$MaxItems' => '<p>The maximum number of distribution IDs that you want to get in the response.</p>', 'ListDistributionsByResponseHeadersPolicyIdRequest$ResponseHeadersPolicyId' => '<p>The ID of the response headers policy whose associated distribution IDs you want to list.</p>', 'ListDistributionsByWebACLIdRequest$Marker' => '<p>Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more than <code>MaxItems</code> distributions that satisfy the request, the response includes a <code>NextMarker</code> element. To get the next page of results, submit another request. For the value of <code>Marker</code>, specify the value of <code>NextMarker</code> from the last response. (For the first request, omit <code>Marker</code>.) </p>', 'ListDistributionsByWebACLIdRequest$MaxItems' => '<p>The maximum number of distributions that you want CloudFront to return in the response body. The maximum and default values are both 100.</p>', 'ListDistributionsByWebACLIdRequest$WebACLId' => '<p>The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null" for the ID, the request returns a list of the distributions that aren\'t associated with a web ACL.</p>', 'ListDistributionsRequest$Marker' => '<p>Use this when paginating results to indicate where to begin in your list of distributions. The results include distributions in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page\'s response (which is also the ID of the last distribution on that page).</p>', 'ListDistributionsRequest$MaxItems' => '<p>The maximum number of distributions you want in the response body.</p>', 'ListFieldLevelEncryptionConfigsRequest$Marker' => '<p>Use this when paginating results to indicate where to begin in your list of configurations. The results include configurations in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page\'s response (which is also the ID of the last configuration on that page). </p>', 'ListFieldLevelEncryptionConfigsRequest$MaxItems' => '<p>The maximum number of field-level encryption configurations you want in the response body. </p>', 'ListFieldLevelEncryptionProfilesRequest$Marker' => '<p>Use this when paginating results to indicate where to begin in your list of profiles. The results include profiles in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page\'s response (which is also the ID of the last profile on that page). </p>', 'ListFieldLevelEncryptionProfilesRequest$MaxItems' => '<p>The maximum number of field-level encryption profiles you want in the response body. </p>', 'ListFunctionsRequest$Marker' => '<p>Use this field when paginating results to indicate where to begin in your list of functions. The response includes functions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>', 'ListFunctionsRequest$MaxItems' => '<p>The maximum number of functions that you want in the response.</p>', 'ListInvalidationsRequest$DistributionId' => '<p>The distribution\'s ID.</p>', 'ListInvalidationsRequest$Marker' => '<p>Use this parameter when paginating results to indicate where to begin in your list of invalidation batches. Because the results are returned in decreasing order from most recent to oldest, the most recent results are on the first page, the second page will contain earlier results, and so on. To get the next page of results, set <code>Marker</code> to the value of the <code>NextMarker</code> from the current page\'s response. This value is the same as the ID of the last invalidation batch on that page. </p>', 'ListInvalidationsRequest$MaxItems' => '<p>The maximum number of invalidation batches that you want in the response body.</p>', 'ListKeyGroupsRequest$Marker' => '<p>Use this field when paginating results to indicate where to begin in your list of key groups. The response includes key groups in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>', 'ListKeyGroupsRequest$MaxItems' => '<p>The maximum number of key groups that you want in the response.</p>', 'ListOriginRequestPoliciesRequest$Marker' => '<p>Use this field when paginating results to indicate where to begin in your list of origin request policies. The response includes origin request policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>', 'ListOriginRequestPoliciesRequest$MaxItems' => '<p>The maximum number of origin request policies that you want in the response.</p>', 'ListPublicKeysRequest$Marker' => '<p>Use this when paginating results to indicate where to begin in your list of public keys. The results include public keys in the list that occur after the marker. To get the next page of results, set the <code>Marker</code> to the value of the <code>NextMarker</code> from the current page\'s response (which is also the ID of the last public key on that page). </p>', 'ListPublicKeysRequest$MaxItems' => '<p>The maximum number of public keys you want in the response body. </p>', 'ListRealtimeLogConfigsRequest$MaxItems' => '<p>The maximum number of real-time log configurations that you want in the response.</p>', 'ListRealtimeLogConfigsRequest$Marker' => '<p>Use this field when paginating results to indicate where to begin in your list of real-time log configurations. The response includes real-time log configurations in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.</p>', 'ListResponseHeadersPoliciesRequest$Marker' => '<p>Use this field when paginating results to indicate where to begin in your list of response headers policies. The response includes response headers policies in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response. </p>', 'ListResponseHeadersPoliciesRequest$MaxItems' => '<p>The maximum number of response headers policies that you want to get in the response.</p>', 'ListStreamingDistributionsRequest$Marker' => '<p>The value that you provided for the <code>Marker</code> request parameter.</p>', 'ListStreamingDistributionsRequest$MaxItems' => '<p>The value that you provided for the <code>MaxItems</code> request parameter.</p>', 'LocationList$member' => NULL, 'LoggingConfig$Bucket' => '<p>The Amazon S3 bucket to store the access logs in, for example, <code>myawslogbucket.s3.amazonaws.com</code>.</p>', 'LoggingConfig$Prefix' => '<p>An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for this distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you don\'t want to specify a prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code> element.</p>', 'MissingBody$Message' => NULL, 'NoSuchCachePolicy$Message' => NULL, 'NoSuchCloudFrontOriginAccessIdentity$Message' => NULL, 'NoSuchDistribution$Message' => NULL, 'NoSuchFieldLevelEncryptionConfig$Message' => NULL, 'NoSuchFieldLevelEncryptionProfile$Message' => NULL, 'NoSuchFunctionExists$Message' => NULL, 'NoSuchInvalidation$Message' => NULL, 'NoSuchOrigin$Message' => NULL, 'NoSuchOriginRequestPolicy$Message' => NULL, 'NoSuchPublicKey$Message' => NULL, 'NoSuchRealtimeLogConfig$Message' => NULL, 'NoSuchResource$Message' => NULL, 'NoSuchResponseHeadersPolicy$Message' => NULL, 'NoSuchStreamingDistribution$Message' => NULL, 'Origin$Id' => '<p>A unique identifier for the origin. This value must be unique within the distribution.</p> <p>Use this value to specify the <code>TargetOriginId</code> in a <code>CacheBehavior</code> or <code>DefaultCacheBehavior</code>.</p>', 'Origin$DomainName' => '<p>The domain name for the origin.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName">Origin Domain Name</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'Origin$OriginPath' => '<p>An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath">Origin Path</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'OriginCustomHeader$HeaderName' => '<p>The name of a header that you want CloudFront to send to your origin. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html">Adding Custom Headers to Origin Requests</a> in the <i> Amazon CloudFront Developer Guide</i>.</p>', 'OriginGroup$Id' => '<p>The origin group\'s ID.</p>', 'OriginGroupMember$OriginId' => '<p>The ID for an origin in an origin group.</p>', 'OriginRequestPolicy$Id' => '<p>The unique identifier for the origin request policy.</p>', 'OriginRequestPolicyAlreadyExists$Message' => NULL, 'OriginRequestPolicyConfig$Comment' => '<p>A comment to describe the origin request policy. The comment cannot be longer than 128 characters.</p>', 'OriginRequestPolicyConfig$Name' => '<p>A unique name to identify the origin request policy.</p>', 'OriginRequestPolicyInUse$Message' => NULL, 'OriginRequestPolicyList$NextMarker' => '<p>If there are more items in the list than are in this response, this element is present. It contains the value that you should use in the <code>Marker</code> field of a subsequent request to continue listing origin request policies where you left off.</p>', 'PathList$member' => NULL, 'PreconditionFailed$Message' => NULL, 'PublicKey$Id' => '<p>The identifier of the public key.</p>', 'PublicKeyAlreadyExists$Message' => NULL, 'PublicKeyConfig$CallerReference' => '<p>A string included in the request to help make sure that the request can’t be replayed.</p>', 'PublicKeyConfig$Name' => '<p>A name to help identify the public key.</p>', 'PublicKeyConfig$EncodedKey' => '<p>The public key that you can use with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed cookies</a>, or with <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level encryption</a>.</p>', 'PublicKeyConfig$Comment' => '<p>A comment to describe the public key. The comment cannot be longer than 128 characters.</p>', 'PublicKeyIdList$member' => NULL, 'PublicKeyInUse$Message' => NULL, 'PublicKeyList$NextMarker' => '<p>If there are more elements to be listed, this element is present and contains the value that you can use for the <code>Marker</code> request parameter to continue listing your public keys where you left off.</p>', 'PublicKeySummary$Id' => '<p>The identifier of the public key.</p>', 'PublicKeySummary$Name' => '<p>A name to help identify the public key.</p>', 'PublicKeySummary$EncodedKey' => '<p>The public key.</p>', 'PublicKeySummary$Comment' => '<p>A comment to describe the public key. The comment cannot be longer than 128 characters.</p>', 'PublishFunctionRequest$Name' => '<p>The name of the function that you are publishing.</p>', 'PublishFunctionRequest$IfMatch' => '<p>The current version (<code>ETag</code> value) of the function that you are publishing, which you can get using <code>DescribeFunction</code>.</p>', 'QueryArgProfile$QueryArg' => '<p>Query argument for field-level encryption query argument-profile mapping.</p>', 'QueryArgProfile$ProfileId' => '<p>ID of profile to use for field-level encryption query argument-profile mapping</p>', 'QueryArgProfileEmpty$Message' => NULL, 'QueryStringCacheKeysList$member' => NULL, 'QueryStringNamesList$member' => NULL, 'RealtimeLogConfig$ARN' => '<p>The Amazon Resource Name (ARN) of this real-time log configuration.</p>', 'RealtimeLogConfig$Name' => '<p>The unique name of this real-time log configuration.</p>', 'RealtimeLogConfigAlreadyExists$Message' => NULL, 'RealtimeLogConfigInUse$Message' => NULL, 'RealtimeLogConfigOwnerMismatch$Message' => NULL, 'RealtimeLogConfigs$Marker' => '<p>This parameter indicates where this list of real-time log configurations begins. This list includes real-time log configurations that occur after the marker.</p>', 'RealtimeLogConfigs$NextMarker' => '<p>If there are more items in the list than are in this response, this element is present. It contains the value that you should use in the <code>Marker</code> field of a subsequent request to continue listing real-time log configurations where you left off. </p>', 'ResourceInUse$Message' => NULL, 'ResponseHeadersPolicy$Id' => '<p>The identifier for the response headers policy.</p>', 'ResponseHeadersPolicyAlreadyExists$Message' => NULL, 'ResponseHeadersPolicyConfig$Comment' => '<p>A comment to describe the response headers policy.</p> <p>The comment cannot be longer than 128 characters.</p>', 'ResponseHeadersPolicyConfig$Name' => '<p>A name to identify the response headers policy.</p> <p>The name must be unique for response headers policies in this Amazon Web Services account.</p>', 'ResponseHeadersPolicyContentSecurityPolicy$ContentSecurityPolicy' => '<p>The policy directives and their values that CloudFront includes as values for the <code>Content-Security-Policy</code> HTTP response header.</p>', 'ResponseHeadersPolicyCustomHeader$Header' => '<p>The HTTP response header name.</p>', 'ResponseHeadersPolicyCustomHeader$Value' => '<p>The value for the HTTP response header.</p>', 'ResponseHeadersPolicyInUse$Message' => NULL, 'ResponseHeadersPolicyList$NextMarker' => '<p>If there are more items in the list than are in this response, this element is present. It contains the value that you should use in the <code>Marker</code> field of a subsequent request to continue listing response headers policies where you left off.</p>', 'ResponseHeadersPolicyXSSProtection$ReportUri' => '<p>A reporting URI, which CloudFront uses as the value of the <code>report</code> directive in the <code>X-XSS-Protection</code> header.</p> <p>You cannot specify a <code>ReportUri</code> when <code>ModeBlock</code> is <code>true</code>.</p> <p>For more information about using a reporting URL, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection">X-XSS-Protection</a> in the MDN Web Docs.</p>', 'S3Origin$DomainName' => '<p>The DNS name of the Amazon S3 origin. </p>', 'S3Origin$OriginAccessIdentity' => '<p>The CloudFront origin access identity to associate with the distribution. Use an origin access identity to configure the distribution so that end users can only access objects in an Amazon S3 bucket through CloudFront.</p> <p>If you want end users to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty <code>OriginAccessIdentity</code> element.</p> <p>To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty <code>OriginAccessIdentity</code> element.</p> <p>To replace the origin access identity, update the distribution configuration and specify the new origin access identity.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content</a> in the <i> Amazon CloudFront Developer Guide</i>.</p>', 'S3OriginConfig$OriginAccessIdentity' => '<p>The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure the origin so that viewers can <i>only</i> access objects in an Amazon S3 bucket through CloudFront. The format of the value is:</p> <p>origin-access-identity/cloudfront/<i>ID-of-origin-access-identity</i> </p> <p>where <code> <i>ID-of-origin-access-identity</i> </code> is the value that CloudFront returned in the <code>ID</code> element when you created the origin access identity.</p> <p>If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty <code>OriginAccessIdentity</code> element.</p> <p>To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty <code>OriginAccessIdentity</code> element.</p> <p>To replace the origin access identity, update the distribution configuration and specify the new origin access identity.</p> <p>For more information about the origin access identity, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>', 'Signer$AwsAccountNumber' => '<p>An Amazon Web Services account number that contains active CloudFront key pairs that CloudFront can use to verify the signatures of signed URLs and signed cookies. If the Amazon Web Services account that owns the key pairs is the same account that owns the CloudFront distribution, the value of this field is <code>self</code>.</p>', 'StreamingDistribution$Id' => '<p>The identifier for the RTMP distribution. For example: <code>EGTXBD79EXAMPLE</code>.</p>', 'StreamingDistribution$ARN' => '<p>The ARN (Amazon Resource Name) for the distribution. For example: <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where <code>123456789012</code> is your Amazon Web Services account ID.</p>', 'StreamingDistribution$Status' => '<p>The current status of the RTMP distribution. When the status is <code>Deployed</code>, the distribution\'s information is propagated to all CloudFront edge locations.</p>', 'StreamingDistribution$DomainName' => '<p>The domain name that corresponds to the streaming distribution, for example, <code>s5c39gqb8ow64r.cloudfront.net</code>. </p>', 'StreamingDistributionAlreadyExists$Message' => NULL, 'StreamingDistributionConfig$CallerReference' => '<p>A unique value (for example, a date-time stamp) that ensures that the request can\'t be replayed.</p> <p>If the value of <code>CallerReference</code> is new (regardless of the content of the <code>StreamingDistributionConfig</code> object), CloudFront creates a new distribution.</p> <p>If <code>CallerReference</code> is a value that you already sent in a previous request to create a distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.</p>', 'StreamingDistributionConfig$Comment' => '<p>Any comments you want to include about the streaming distribution. </p>', 'StreamingDistributionList$Marker' => '<p>The value you provided for the <code>Marker</code> request parameter. </p>', 'StreamingDistributionList$NextMarker' => '<p>If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you can use for the <code>Marker</code> request parameter to continue listing your RTMP distributions where they left off. </p>', 'StreamingDistributionNotDisabled$Message' => NULL, 'StreamingDistributionSummary$Id' => '<p>The identifier for the distribution, for example, <code>EDFDVBD632BHDS5</code>.</p>', 'StreamingDistributionSummary$ARN' => '<p> The ARN (Amazon Resource Name) for the streaming distribution. For example: <code>arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5</code>, where <code>123456789012</code> is your Amazon Web Services account ID.</p>', 'StreamingDistributionSummary$Status' => '<p> Indicates the current status of the distribution. When the status is <code>Deployed</code>, the distribution\'s information is fully propagated throughout the Amazon CloudFront system.</p>', 'StreamingDistributionSummary$DomainName' => '<p>The domain name corresponding to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>.</p>', 'StreamingDistributionSummary$Comment' => '<p>The comment originally specified when this distribution was created.</p>', 'StreamingLoggingConfig$Bucket' => '<p>The Amazon S3 bucket to store the access logs in, for example, <code>myawslogbucket.s3.amazonaws.com</code>.</p>', 'StreamingLoggingConfig$Prefix' => '<p>An optional string that you want CloudFront to prefix to the access log filenames for this streaming distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you don\'t want to specify a prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code> element.</p>', 'TestFunctionFailed$Message' => NULL, 'TestFunctionRequest$Name' => '<p>The name of the function that you are testing.</p>', 'TestFunctionRequest$IfMatch' => '<p>The current version (<code>ETag</code> value) of the function that you are testing, which you can get using <code>DescribeFunction</code>.</p>', 'TestResult$ComputeUtilization' => '<p>The amount of time that the function took to run as a percentage of the maximum allowed time. For example, a compute utilization of 35 means that the function completed in 35% of the maximum allowed time.</p>', 'TooManyCacheBehaviors$Message' => NULL, 'TooManyCachePolicies$Message' => NULL, 'TooManyCertificates$Message' => NULL, 'TooManyCloudFrontOriginAccessIdentities$Message' => NULL, 'TooManyCookieNamesInWhiteList$Message' => NULL, 'TooManyCookiesInCachePolicy$Message' => NULL, 'TooManyCookiesInOriginRequestPolicy$Message' => NULL, 'TooManyCustomHeadersInResponseHeadersPolicy$Message' => NULL, 'TooManyDistributionCNAMEs$Message' => NULL, 'TooManyDistributions$Message' => NULL, 'TooManyDistributionsAssociatedToCachePolicy$Message' => NULL, 'TooManyDistributionsAssociatedToFieldLevelEncryptionConfig$Message' => NULL, 'TooManyDistributionsAssociatedToKeyGroup$Message' => NULL, 'TooManyDistributionsAssociatedToOriginRequestPolicy$Message' => NULL, 'TooManyDistributionsAssociatedToResponseHeadersPolicy$Message' => NULL, 'TooManyDistributionsWithFunctionAssociations$Message' => NULL, 'TooManyDistributionsWithLambdaAssociations$Message' => NULL, 'TooManyDistributionsWithSingleFunctionARN$Message' => NULL, 'TooManyFieldLevelEncryptionConfigs$Message' => NULL, 'TooManyFieldLevelEncryptionContentTypeProfiles$Message' => NULL, 'TooManyFieldLevelEncryptionEncryptionEntities$Message' => NULL, 'TooManyFieldLevelEncryptionFieldPatterns$Message' => NULL, 'TooManyFieldLevelEncryptionProfiles$Message' => NULL, 'TooManyFieldLevelEncryptionQueryArgProfiles$Message' => NULL, 'TooManyFunctionAssociations$Message' => NULL, 'TooManyFunctions$Message' => NULL, 'TooManyHeadersInCachePolicy$Message' => NULL, 'TooManyHeadersInForwardedValues$Message' => NULL, 'TooManyHeadersInOriginRequestPolicy$Message' => NULL, 'TooManyInvalidationsInProgress$Message' => NULL, 'TooManyKeyGroups$Message' => NULL, 'TooManyKeyGroupsAssociatedToDistribution$Message' => NULL, 'TooManyLambdaFunctionAssociations$Message' => NULL, 'TooManyOriginCustomHeaders$Message' => NULL, 'TooManyOriginGroupsPerDistribution$Message' => NULL, 'TooManyOriginRequestPolicies$Message' => NULL, 'TooManyOrigins$Message' => NULL, 'TooManyPublicKeys$Message' => NULL, 'TooManyPublicKeysInKeyGroup$Message' => NULL, 'TooManyQueryStringParameters$Message' => NULL, 'TooManyQueryStringsInCachePolicy$Message' => NULL, 'TooManyQueryStringsInOriginRequestPolicy$Message' => NULL, 'TooManyRealtimeLogConfigs$Message' => NULL, 'TooManyResponseHeadersPolicies$Message' => NULL, 'TooManyStreamingDistributionCNAMEs$Message' => NULL, 'TooManyStreamingDistributions$Message' => NULL, 'TooManyTrustedSigners$Message' => NULL, 'TrustedKeyGroupDoesNotExist$Message' => NULL, 'TrustedKeyGroupIdList$member' => NULL, 'TrustedSignerDoesNotExist$Message' => NULL, 'UnsupportedOperation$Message' => NULL, 'UpdateCachePolicyRequest$Id' => '<p>The unique identifier for the cache policy that you are updating. The identifier is returned in a cache behavior’s <code>CachePolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>', 'UpdateCachePolicyRequest$IfMatch' => '<p>The version of the cache policy that you are updating. The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetCachePolicyConfig</code>.</p>', 'UpdateCachePolicyResult$ETag' => '<p>The current version of the cache policy.</p>', 'UpdateCloudFrontOriginAccessIdentityRequest$Id' => '<p>The identity\'s id.</p>', 'UpdateCloudFrontOriginAccessIdentityRequest$IfMatch' => '<p>The value of the <code>ETag</code> header that you received when retrieving the identity\'s configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'UpdateCloudFrontOriginAccessIdentityResult$ETag' => '<p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'UpdateDistributionRequest$Id' => '<p>The distribution\'s id.</p>', 'UpdateDistributionRequest$IfMatch' => '<p>The value of the <code>ETag</code> header that you received when retrieving the distribution\'s configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'UpdateDistributionResult$ETag' => '<p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'UpdateFieldLevelEncryptionConfigRequest$Id' => '<p>The ID of the configuration you want to update.</p>', 'UpdateFieldLevelEncryptionConfigRequest$IfMatch' => '<p>The value of the <code>ETag</code> header that you received when retrieving the configuration identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'UpdateFieldLevelEncryptionConfigResult$ETag' => '<p>The value of the <code>ETag</code> header that you received when updating the configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'UpdateFieldLevelEncryptionProfileRequest$Id' => '<p>The ID of the field-level encryption profile request. </p>', 'UpdateFieldLevelEncryptionProfileRequest$IfMatch' => '<p>The value of the <code>ETag</code> header that you received when retrieving the profile identity to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'UpdateFieldLevelEncryptionProfileResult$ETag' => '<p>The result of the field-level encryption profile request. </p>', 'UpdateFunctionRequest$Name' => '<p>The name of the function that you are updating.</p>', 'UpdateFunctionRequest$IfMatch' => '<p>The current version (<code>ETag</code> value) of the function that you are updating, which you can get using <code>DescribeFunction</code>.</p>', 'UpdateFunctionResult$ETag' => '<p>The version identifier for the current version of the CloudFront function.</p>', 'UpdateKeyGroupRequest$Id' => '<p>The identifier of the key group that you are updating.</p>', 'UpdateKeyGroupRequest$IfMatch' => '<p>The version of the key group that you are updating. The version is the key group’s <code>ETag</code> value.</p>', 'UpdateKeyGroupResult$ETag' => '<p>The identifier for this version of the key group.</p>', 'UpdateOriginRequestPolicyRequest$Id' => '<p>The unique identifier for the origin request policy that you are updating. The identifier is returned in a cache behavior’s <code>OriginRequestPolicyId</code> field in the response to <code>GetDistributionConfig</code>.</p>', 'UpdateOriginRequestPolicyRequest$IfMatch' => '<p>The version of the origin request policy that you are updating. The version is returned in the origin request policy’s <code>ETag</code> field in the response to <code>GetOriginRequestPolicyConfig</code>.</p>', 'UpdateOriginRequestPolicyResult$ETag' => '<p>The current version of the origin request policy.</p>', 'UpdatePublicKeyRequest$Id' => '<p>The identifier of the public key that you are updating.</p>', 'UpdatePublicKeyRequest$IfMatch' => '<p>The value of the <code>ETag</code> header that you received when retrieving the public key to update. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'UpdatePublicKeyResult$ETag' => '<p>The identifier of the current version of the public key.</p>', 'UpdateRealtimeLogConfigRequest$Name' => '<p>The name for this real-time log configuration.</p>', 'UpdateRealtimeLogConfigRequest$ARN' => '<p>The Amazon Resource Name (ARN) for this real-time log configuration.</p>', 'UpdateResponseHeadersPolicyRequest$Id' => '<p>The identifier for the response headers policy that you are updating.</p>', 'UpdateResponseHeadersPolicyRequest$IfMatch' => '<p>The version of the response headers policy that you are updating.</p> <p>The version is returned in the cache policy’s <code>ETag</code> field in the response to <code>GetResponseHeadersPolicyConfig</code>.</p>', 'UpdateResponseHeadersPolicyResult$ETag' => '<p>The current version of the response headers policy.</p>', 'UpdateStreamingDistributionRequest$Id' => '<p>The streaming distribution\'s id.</p>', 'UpdateStreamingDistributionRequest$IfMatch' => '<p>The value of the <code>ETag</code> header that you received when retrieving the streaming distribution\'s configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'UpdateStreamingDistributionResult$ETag' => '<p>The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.</p>', 'ViewerCertificate$IAMCertificateId' => '<p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Identity and Access Management (IAM)</a>, provide the ID of the IAM certificate.</p> <p>If you specify an IAM certificate ID, you must also specify values for <code>MinimumProtocolVersion</code> and <code>SSLSupportMethod</code>. </p>', 'ViewerCertificate$ACMCertificateArn' => '<p>If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html">Certificate Manager (ACM)</a>, provide the Amazon Resource Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US East (N. Virginia) Region (<code>us-east-1</code>).</p> <p>If you specify an ACM certificate ARN, you must also specify values for <code>MinimumProtocolVersion</code> and <code>SSLSupportMethod</code>.</p>', 'ViewerCertificate$Certificate' => '<p>This field is deprecated. Use one of the following fields instead:</p> <ul> <li> <p> <code>ACMCertificateArn</code> </p> </li> <li> <p> <code>IAMCertificateId</code> </p> </li> <li> <p> <code>CloudFrontDefaultCertificate</code> </p> </li> </ul>', ], ], 'timestamp' => [ 'base' => NULL, 'refs' => [ 'CachePolicy$LastModifiedTime' => '<p>The date and time when the cache policy was last modified.</p>', 'Distribution$LastModifiedTime' => '<p>The date and time the distribution was last modified. </p>', 'DistributionSummary$LastModifiedTime' => '<p>The date and time the distribution was last modified.</p>', 'FieldLevelEncryption$LastModifiedTime' => '<p>The last time the field-level encryption configuration was changed. </p>', 'FieldLevelEncryptionProfile$LastModifiedTime' => '<p>The last time the field-level encryption profile was updated.</p>', 'FieldLevelEncryptionProfileSummary$LastModifiedTime' => '<p>The time when the the field-level encryption profile summary was last updated.</p>', 'FieldLevelEncryptionSummary$LastModifiedTime' => '<p>The last time that the summary of field-level encryption items was modified.</p>', 'FunctionMetadata$CreatedTime' => '<p>The date and time when the function was created.</p>', 'FunctionMetadata$LastModifiedTime' => '<p>The date and time when the function was most recently updated.</p>', 'Invalidation$CreateTime' => '<p>The date and time the invalidation request was first made. </p>', 'InvalidationSummary$CreateTime' => '<p>The time that an invalidation request was created.</p>', 'KeyGroup$LastModifiedTime' => '<p>The date and time when the key group was last modified.</p>', 'OriginRequestPolicy$LastModifiedTime' => '<p>The date and time when the origin request policy was last modified.</p>', 'PublicKey$CreatedTime' => '<p>The date and time when the public key was uploaded.</p>', 'PublicKeySummary$CreatedTime' => '<p>The date and time when the public key was uploaded.</p>', 'ResponseHeadersPolicy$LastModifiedTime' => '<p>The date and time when the response headers policy was last modified.</p>', 'StreamingDistribution$LastModifiedTime' => '<p>The date and time that the distribution was last modified. </p>', 'StreamingDistributionSummary$LastModifiedTime' => '<p>The date and time the distribution was last modified.</p>', ], ], ],];
