<?php
// This file was auto-generated from sdk-root/src/data/drs/2020-02-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS Elastic Disaster Recovery Service.</p>', 'operations' => [ 'CreateReplicationConfigurationTemplate' => '<p>Creates a new ReplicationConfigurationTemplate.</p>', 'DeleteJob' => '<p>Deletes a single Job by ID.</p>', 'DeleteRecoveryInstance' => '<p>Deletes a single Recovery Instance by ID. This deletes the Recovery Instance resource from Elastic Disaster Recovery. The Recovery Instance must be disconnected first in order to delete it.</p>', 'DeleteReplicationConfigurationTemplate' => '<p>Deletes a single Replication Configuration Template by ID</p>', 'DeleteSourceServer' => '<p>Deletes a single Source Server by ID. The Source Server must be disconnected first.</p>', 'DescribeJobLogItems' => '<p>Retrieves a detailed Job log with pagination.</p>', 'DescribeJobs' => '<p>Returns a list of Jobs. Use the JobsID and fromDate and toDate filters to limit which jobs are returned. The response is sorted by creationDataTime - latest date first. Jobs are created by the StartRecovery, TerminateRecoveryInstances and StartFailbackLaunch APIs. Jobs are also created by DiagnosticLaunch and TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant support tickets.</p>', 'DescribeRecoveryInstances' => '<p>Lists all Recovery Instances or multiple Recovery Instances by ID.</p>', 'DescribeRecoverySnapshots' => '<p>Lists all Recovery Snapshots for a single Source Server.</p>', 'DescribeReplicationConfigurationTemplates' => '<p>Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.</p>', 'DescribeSourceServers' => '<p>Lists all Source Servers or multiple Source Servers filtered by ID.</p>', 'DisconnectRecoveryInstance' => '<p>Disconnect a Recovery Instance from Elastic Disaster Recovery. Data replication is stopped immediately. All AWS resources created by Elastic Disaster Recovery for enabling the replication of the Recovery Instance will be terminated / deleted within 90 minutes. If the agent on the Recovery Instance has not been prevented from communicating with the Elastic Disaster Recovery service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following properties of the Recovery Instance will be changed immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.</p>', 'DisconnectSourceServer' => '<p>Disconnects a specific Source Server from Elastic Disaster Recovery. Data replication is stopped immediately. All AWS resources created by Elastic Disaster Recovery for enabling the replication of the Source Server will be terminated / deleted within 90 minutes. You cannot disconnect a Source Server if it has a Recovery Instance. If the agent on the Source Server has not been prevented from communicating with the Elastic Disaster Recovery service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.</p>', 'GetFailbackReplicationConfiguration' => '<p>Lists all Failback ReplicationConfigurations, filtered by Recovery Instance ID.</p>', 'GetLaunchConfiguration' => '<p>Gets a LaunchConfiguration, filtered by Source Server IDs.</p>', 'GetReplicationConfiguration' => '<p>Gets a ReplicationConfiguration, filtered by Source Server ID.</p>', 'InitializeService' => '<p>Initialize Elastic Disaster Recovery.</p>', 'ListTagsForResource' => '<p>List all tags for your Elastic Disaster Recovery resources.</p>', 'RetryDataReplication' => '<p>Causes the data replication initiation sequence to begin immediately upon next Handshake for the specified Source Server ID, regardless of when the previous initiation started. This command will work only if the Source Server is stalled or is in a DISCONNECTED or STOPPED state.</p>', 'StartFailbackLaunch' => '<p>Initiates a Job for launching the machine that is being failed back to from the specified Recovery Instance. This will run conversion on the failback client and will reboot your machine, thus completing the failback process.</p>', 'StartRecovery' => '<p>Launches Recovery Instances for the specified Source Servers. For each Source Server you may choose a point in time snapshot to launch from, or use an on demand snapshot.</p>', 'StopFailback' => '<p>Stops the failback process for a specified Recovery Instance. This changes the Failback State of the Recovery Instance back to FAILBACK_NOT_STARTED.</p>', 'TagResource' => '<p>Adds or overwrites only the specified tags for the specified Elastic Disaster Recovery resource or resources. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value.</p>', 'TerminateRecoveryInstances' => '<p>Initiates a Job for terminating the EC2 resources associated with the specified Recovery Instances, and then will delete the Recovery Instances from the Elastic Disaster Recovery service.</p>', 'UntagResource' => '<p>Deletes the specified set of tags from the specified set of Elastic Disaster Recovery resources.</p>', 'UpdateFailbackReplicationConfiguration' => '<p>Allows you to update the failback replication configuration of a Recovery Instance by ID.</p>', 'UpdateLaunchConfiguration' => '<p>Updates a LaunchConfiguration by Source Server ID.</p>', 'UpdateReplicationConfiguration' => '<p>Allows you to update a ReplicationConfiguration by Source Server ID.</p>', 'UpdateReplicationConfigurationTemplate' => '<p>Updates a ReplicationConfigurationTemplate by ID.</p>', ], 'shapes' => [ 'ARN' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$ebsEncryptionKeyArn' => '<p>The ARN of the EBS encryption key to be used during replication.</p>', 'Job$arn' => '<p>The ARN of a Job.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource whose tags should be returned.</p>', 'RecoveryInstance$arn' => '<p>The ARN of the Recovery Instance.</p>', 'ReplicationConfiguration$ebsEncryptionKeyArn' => '<p>The ARN of the EBS encryption key to be used during replication.</p>', 'ReplicationConfigurationTemplate$arn' => '<p>The Replication Configuration Template ARN.</p>', 'ReplicationConfigurationTemplate$ebsEncryptionKeyArn' => '<p>The ARN of the EBS encryption key to be used during replication.</p>', 'SourceServer$arn' => '<p>The ARN of the Source Server.</p>', 'TagResourceRequest$resourceArn' => '<p>ARN of the resource for which tags are to be added or updated.</p>', 'UntagResourceRequest$resourceArn' => '<p>ARN of the resource for which tags are to be removed.</p>', 'UpdateReplicationConfigurationRequest$ebsEncryptionKeyArn' => '<p>The ARN of the EBS encryption key to be used during replication.</p>', 'UpdateReplicationConfigurationTemplateRequest$arn' => '<p>The Replication Configuration Template ARN.</p>', 'UpdateReplicationConfigurationTemplateRequest$ebsEncryptionKeyArn' => '<p>The ARN of the EBS encryption key to be used during replication.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>TYou do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$associateDefaultSecurityGroup' => '<p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>', 'CreateReplicationConfigurationTemplateRequest$createPublicIP' => '<p>Whether to create a Public IP for the Recovery Instance by default.</p>', 'CreateReplicationConfigurationTemplateRequest$useDedicatedReplicationServer' => '<p>Whether to use a dedicated Replication Server in the replication staging area.</p>', 'GetFailbackReplicationConfigurationResponse$usePrivateIP' => '<p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>', 'LaunchConfiguration$copyPrivateIp' => '<p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>', 'LaunchConfiguration$copyTags' => '<p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>', 'Licensing$osByol' => '<p>Whether to enable "Bring your own license" or not.</p>', 'NetworkInterface$isPrimary' => '<p>Whether this is the primary network interface.</p>', 'PITPolicyRule$enabled' => '<p>Whether this rule is enabled or not.</p>', 'RecoveryInstance$isDrill' => '<p>Whether this Recovery Instance was created for a drill or for an actual Recovery event.</p>', 'RecoveryInstanceFailback$failbackToOriginalServer' => '<p>Whether we are failing back to the original Source Server for this Recovery Instance.</p>', 'ReplicationConfiguration$associateDefaultSecurityGroup' => '<p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>', 'ReplicationConfiguration$createPublicIP' => '<p>Whether to create a Public IP for the Recovery Instance by default.</p>', 'ReplicationConfiguration$useDedicatedReplicationServer' => '<p>Whether to use a dedicated Replication Server in the replication staging area.</p>', 'ReplicationConfigurationReplicatedDisk$isBootDisk' => '<p>Whether to boot from this disk or not.</p>', 'ReplicationConfigurationTemplate$associateDefaultSecurityGroup' => '<p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>', 'ReplicationConfigurationTemplate$createPublicIP' => '<p>Whether to create a Public IP for the Recovery Instance by default.</p>', 'ReplicationConfigurationTemplate$useDedicatedReplicationServer' => '<p>Whether to use a dedicated Replication Server in the replication staging area.</p>', 'StartRecoveryRequest$isDrill' => '<p>Whether this Source Server Recovery operation is a drill or not.</p>', 'UpdateFailbackReplicationConfigurationRequest$usePrivateIP' => '<p>Whether to use Private IP for the failback replication of the Recovery Instance.</p>', 'UpdateLaunchConfigurationRequest$copyPrivateIp' => '<p>Whether we should copy the Private IP of the Source Server to the Recovery Instance.</p>', 'UpdateLaunchConfigurationRequest$copyTags' => '<p>Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.</p>', 'UpdateReplicationConfigurationRequest$associateDefaultSecurityGroup' => '<p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration.</p>', 'UpdateReplicationConfigurationRequest$createPublicIP' => '<p>Whether to create a Public IP for the Recovery Instance by default.</p>', 'UpdateReplicationConfigurationRequest$useDedicatedReplicationServer' => '<p>Whether to use a dedicated Replication Server in the replication staging area.</p>', 'UpdateReplicationConfigurationTemplateRequest$associateDefaultSecurityGroup' => '<p>Whether to associate the default Elastic Disaster Recovery Security group with the Replication Configuration Template.</p>', 'UpdateReplicationConfigurationTemplateRequest$createPublicIP' => '<p>Whether to create a Public IP for the Recovery Instance by default.</p>', 'UpdateReplicationConfigurationTemplateRequest$useDedicatedReplicationServer' => '<p>Whether to use a dedicated Replication Server in the replication staging area.</p>', ], ], 'BoundedString' => [ 'base' => NULL, 'refs' => [ 'CPU$modelName' => '<p>The model name of the CPU.</p>', 'DataReplicationInfoReplicatedDisk$deviceName' => '<p>The name of the device.</p>', 'DescribeSourceServersRequestFilters$hardwareId' => '<p>An ID that describes the hardware of the Source Server. This is either an EC2 instance id, a VMware uuid or a mac address.</p>', 'Disk$deviceName' => '<p>The disk or device name.</p>', 'GetFailbackReplicationConfigurationResponse$name' => '<p>The name of the Failback Replication Configuration.</p>', 'IPsList$member' => NULL, 'IdentificationHints$fqdn' => '<p>Fully Qualified Domain Name identification hint.</p>', 'IdentificationHints$hostname' => '<p>Hostname identification hint.</p>', 'IdentificationHints$vmWareUuid' => '<p>vCenter VM path identification hint.</p>', 'LaunchConfiguration$ec2LaunchTemplateID' => '<p>The EC2 launch template ID of this launch configuration.</p>', 'NetworkInterface$macAddress' => '<p>The MAC address of the network interface.</p>', 'OS$fullString' => '<p>The long name of the Operating System.</p>', 'RecoveryInstanceDataReplicationInfoReplicatedDisk$deviceName' => '<p>The name of the device.</p>', 'RecoveryInstanceDisk$internalDeviceName' => '<p>The internal device name of this disk. This is the name that is visible on the machine itself and not from the EC2 console.</p>', 'RecoveryInstanceFailback$failbackClientID' => '<p>The ID of the failback client that this Recovery Instance is associated with.</p>', 'ReplicationConfigurationReplicatedDisk$deviceName' => '<p>The name of the device.</p>', 'UpdateFailbackReplicationConfigurationRequest$name' => '<p>The name of the Failback Replication Configuration.</p>', ], ], 'CPU' => [ 'base' => '<p>Information about a server\'s CPU.</p>', 'refs' => [ 'Cpus$member' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>The request could not be completed due to a conflict with the current state of the target resource.</p>', 'refs' => [], ], 'Cpus' => [ 'base' => NULL, 'refs' => [ 'RecoveryInstanceProperties$cpus' => '<p>An array of CPUs.</p>', 'SourceProperties$cpus' => '<p>An array of CPUs.</p>', ], ], 'CreateReplicationConfigurationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DataReplicationError' => [ 'base' => '<p>Error in data replication.</p>', 'refs' => [ 'DataReplicationInfo$dataReplicationError' => '<p>Error in data replication.</p>', ], ], 'DataReplicationErrorString' => [ 'base' => NULL, 'refs' => [ 'DataReplicationError$error' => '<p>Error in data replication.</p>', ], ], 'DataReplicationInfo' => [ 'base' => '<p>Information about Data Replication</p>', 'refs' => [ 'SourceServer$dataReplicationInfo' => '<p>The Data Replication Info of the Source Server.</p>', ], ], 'DataReplicationInfoReplicatedDisk' => [ 'base' => '<p>A disk that should be replicated.</p>', 'refs' => [ 'DataReplicationInfoReplicatedDisks$member' => NULL, ], ], 'DataReplicationInfoReplicatedDisks' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInfo$replicatedDisks' => '<p>The disks that should be replicated.</p>', ], ], 'DataReplicationInitiation' => [ 'base' => '<p>Data replication initiation.</p>', 'refs' => [ 'DataReplicationInfo$dataReplicationInitiation' => '<p>Information about whether the data replication has been initiated.</p>', ], ], 'DataReplicationInitiationStep' => [ 'base' => '<p>Data replication initiation step.</p>', 'refs' => [ 'DataReplicationInitiationSteps$member' => NULL, ], ], 'DataReplicationInitiationStepName' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInitiationStep$name' => '<p>The name of the step.</p>', ], ], 'DataReplicationInitiationStepStatus' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInitiationStep$status' => '<p>The status of the step.</p>', ], ], 'DataReplicationInitiationSteps' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInitiation$steps' => '<p>The steps of the current attempt to initiate data replication.</p>', ], ], 'DataReplicationState' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInfo$dataReplicationState' => '<p>The state of the data replication.</p>', ], ], 'DeleteJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRecoveryInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReplicationConfigurationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReplicationConfigurationTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSourceServerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobLogItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobLogItemsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobsRequestFilters' => [ 'base' => '<p>A set of filters by which to return Jobs.</p>', 'refs' => [ 'DescribeJobsRequest$filters' => '<p>A set of filters by which to return Jobs.</p>', ], ], 'DescribeJobsRequestFiltersJobIDs' => [ 'base' => NULL, 'refs' => [ 'DescribeJobsRequestFilters$jobIDs' => '<p>An array of Job IDs that should be returned. An empty array means all jobs.</p>', ], ], 'DescribeJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecoveryInstancesItems' => [ 'base' => NULL, 'refs' => [ 'DescribeRecoveryInstancesResponse$items' => '<p>An array of Recovery Instances.</p>', ], ], 'DescribeRecoveryInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecoveryInstancesRequestFilters' => [ 'base' => '<p>A set of filters by which to return Recovery Instances.</p>', 'refs' => [ 'DescribeRecoveryInstancesRequest$filters' => '<p>A set of filters by which to return Recovery Instances.</p>', ], ], 'DescribeRecoveryInstancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecoverySnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecoverySnapshotsRequestFilters' => [ 'base' => '<p>A set of filters by which to return Recovery Snapshots.</p>', 'refs' => [ 'DescribeRecoverySnapshotsRequest$filters' => '<p>A set of filters by which to return Recovery Snapshots.</p>', ], ], 'DescribeRecoverySnapshotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReplicationConfigurationTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReplicationConfigurationTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSourceServersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSourceServersRequestFilters' => [ 'base' => '<p>A set of filters by which to return Source Servers.</p>', 'refs' => [ 'DescribeSourceServersRequest$filters' => '<p>A set of filters by which to return Source Servers.</p>', ], ], 'DescribeSourceServersRequestFiltersIDs' => [ 'base' => NULL, 'refs' => [ 'DescribeSourceServersRequestFilters$sourceServerIDs' => '<p>An array of Source Servers IDs that should be returned. An empty array means all Source Servers.</p>', ], ], 'DescribeSourceServersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisconnectRecoveryInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisconnectSourceServerRequest' => [ 'base' => NULL, 'refs' => [], ], 'Disk' => [ 'base' => '<p>An object representing a data storage device on a server.</p>', 'refs' => [ 'Disks$member' => NULL, ], ], 'Disks' => [ 'base' => NULL, 'refs' => [ 'SourceProperties$disks' => '<p>An array of disks.</p>', ], ], 'EC2InstanceID' => [ 'base' => NULL, 'refs' => [ 'IdentificationHints$awsInstanceID' => '<p>AWS Instance ID identification hint.</p>', 'JobLogEventData$conversionServerID' => '<p>The ID of a conversion server.</p>', 'JobLogEventData$targetInstanceID' => '<p>The ID of a Recovery Instance.</p>', 'RecoveryInstance$ec2InstanceID' => '<p>The EC2 instance ID of the Recovery Instance.</p>', ], ], 'EC2InstanceState' => [ 'base' => NULL, 'refs' => [ 'RecoveryInstance$ec2InstanceState' => '<p>The state of the EC2 instance for this Recovery Instance.</p>', ], ], 'EC2InstanceType' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$replicationServerInstanceType' => '<p>The instance type to be used for the replication server.</p>', 'ReplicationConfiguration$replicationServerInstanceType' => '<p>The instance type to be used for the replication server.</p>', 'ReplicationConfigurationTemplate$replicationServerInstanceType' => '<p>The instance type to be used for the replication server.</p>', 'SourceProperties$recommendedInstanceType' => '<p>The recommended EC2 instance type that will be used when recovering the Source Server.</p>', 'UpdateReplicationConfigurationRequest$replicationServerInstanceType' => '<p>The instance type to be used for the replication server.</p>', 'UpdateReplicationConfigurationTemplateRequest$replicationServerInstanceType' => '<p>The instance type to be used for the replication server.</p>', ], ], 'EbsSnapshotsList' => [ 'base' => NULL, 'refs' => [ 'RecoverySnapshot$ebsSnapshots' => '<p>A list of EBS snapshots.</p>', ], ], 'EbsVolumeID' => [ 'base' => NULL, 'refs' => [ 'RecoveryInstanceDisk$ebsVolumeID' => '<p>The EBS Volume ID of this disk.</p>', ], ], 'FailbackReplicationError' => [ 'base' => NULL, 'refs' => [ 'RecoveryInstanceDataReplicationError$error' => '<p>Error in data replication.</p>', ], ], 'FailbackState' => [ 'base' => NULL, 'refs' => [ 'RecoveryInstanceFailback$state' => '<p>The state of the failback process that this Recovery Instance is in.</p>', ], ], 'GetFailbackReplicationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFailbackReplicationConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetReplicationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'IPsList' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$ips' => '<p>Network interface IPs.</p>', ], ], 'ISO8601DatetimeString' => [ 'base' => NULL, 'refs' => [ 'DataReplicationInfo$etaDateTime' => '<p>An estimate of when the data replication will be completed.</p>', 'DataReplicationInfo$lagDuration' => '<p>Data replication lag duration.</p>', 'DataReplicationInitiation$nextAttemptDateTime' => '<p>The date and time of the next attempt to initiate data replication.</p>', 'DataReplicationInitiation$startDateTime' => '<p>The date and time of the current attempt to initiate data replication.</p>', 'DescribeJobsRequestFilters$fromDate' => '<p>The start date in a date range query.</p>', 'DescribeJobsRequestFilters$toDate' => '<p>The end date in a date range query.</p>', 'DescribeRecoverySnapshotsRequestFilters$fromDateTime' => '<p>The start date in a date range query.</p>', 'DescribeRecoverySnapshotsRequestFilters$toDateTime' => '<p>The end date in a date range query.</p>', 'Job$creationDateTime' => '<p>The date and time of when the Job was created.</p>', 'Job$endDateTime' => '<p>The date and time of when the Job ended.</p>', 'JobLog$logDateTime' => '<p>The date and time the log was taken.</p>', 'LifeCycle$addedToServiceDateTime' => '<p>The date and time of when the Source Server was added to the service.</p>', 'LifeCycle$elapsedReplicationDuration' => '<p>The amount of time that the Source Server has been replicating for.</p>', 'LifeCycle$firstByteDateTime' => '<p>The date and time of the first byte that was replicated from the Source Server.</p>', 'LifeCycle$lastSeenByServiceDateTime' => '<p>The date and time this Source Server was last seen by the service.</p>', 'LifeCycleLastLaunchInitiated$apiCallDateTime' => '<p>The date and time the last Source Server launch was initiated.</p>', 'RecoveryInstance$pointInTimeSnapshotDateTime' => '<p>The date and time of the Point in Time (PIT) snapshot that this Recovery Instance was launched from.</p>', 'RecoveryInstanceDataReplicationInfo$etaDateTime' => '<p>An estimate of when the data replication will be completed.</p>', 'RecoveryInstanceDataReplicationInfo$lagDuration' => '<p>Data replication lag duration.</p>', 'RecoveryInstanceDataReplicationInitiation$startDateTime' => '<p>The date and time of the current attempt to initiate data replication.</p>', 'RecoveryInstanceFailback$agentLastSeenByServiceDateTime' => '<p>The date and time the agent on the Recovery Instance was last seen by the service.</p>', 'RecoveryInstanceFailback$elapsedReplicationDuration' => '<p>The amount of time that the Recovery Instance has been replicating for.</p>', 'RecoveryInstanceFailback$failbackClientLastSeenByServiceDateTime' => '<p>The date and time that the failback client was last seen by the service.</p>', 'RecoveryInstanceFailback$failbackInitiationTime' => '<p>The date and time that the failback initiation started.</p>', 'RecoveryInstanceFailback$firstByteDateTime' => '<p>The date and time of the first byte that was replicated from the Recovery Instance.</p>', 'RecoveryInstanceProperties$lastUpdatedDateTime' => '<p>The date and time the Recovery Instance properties were last updated on.</p>', 'RecoverySnapshot$expectedTimestamp' => '<p>The timestamp of when we expect the snapshot to be taken.</p>', 'RecoverySnapshot$timestamp' => '<p>The actual timestamp that the snapshot was taken.</p>', 'SourceProperties$lastUpdatedDateTime' => '<p>The date and time the Source Properties were last updated on.</p>', ], ], 'IdentificationHints' => [ 'base' => '<p>Hints used to uniquely identify a machine.</p>', 'refs' => [ 'RecoveryInstanceProperties$identificationHints' => '<p>Hints used to uniquely identify a machine.</p>', 'SourceProperties$identificationHints' => '<p>Hints used to uniquely identify a machine.</p>', ], ], 'InitializeServiceRequest' => [ 'base' => NULL, 'refs' => [], ], 'InitializeServiceResponse' => [ 'base' => NULL, 'refs' => [], ], 'InitiatedBy' => [ 'base' => NULL, 'refs' => [ 'Job$initiatedBy' => '<p>A string representing who initiated the Job.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure.</p>', 'refs' => [], ], 'Job' => [ 'base' => '<p>A job is an asynchronous workflow.</p>', 'refs' => [ 'JobsList$member' => NULL, 'StartFailbackLaunchResponse$job' => '<p>The failback launch Job.</p>', 'StartRecoveryResponse$job' => '<p>The Recovery Job.</p>', 'TerminateRecoveryInstancesResponse$job' => '<p>The Job for terminating the Recovery Instances.</p>', ], ], 'JobID' => [ 'base' => NULL, 'refs' => [ 'DeleteJobRequest$jobID' => '<p>The ID of the Job to be deleted.</p>', 'DescribeJobLogItemsRequest$jobID' => '<p>The ID of the Job for which Job log items will be retrieved.</p>', 'DescribeJobsRequestFiltersJobIDs$member' => NULL, 'Job$jobID' => '<p>The ID of the Job.</p>', 'LifeCycleLastLaunchInitiated$jobID' => '<p>The ID of the Job that was used to last launch the Source Server.</p>', 'RecoveryInstance$jobID' => '<p>The ID of the Job that created the Recovery Instance.</p>', 'RecoveryInstanceFailback$failbackJobID' => '<p>The Job ID of the last failback log for this Recovery Instance.</p>', ], ], 'JobLog' => [ 'base' => '<p>A log outputted by a Job.</p>', 'refs' => [ 'JobLogs$member' => NULL, ], ], 'JobLogEvent' => [ 'base' => NULL, 'refs' => [ 'JobLog$event' => '<p>The event represents the type of a log.</p>', ], ], 'JobLogEventData' => [ 'base' => '<p>Metadata associated with a Job log.</p>', 'refs' => [ 'JobLog$eventData' => '<p>Metadata associated with a Job log.</p>', ], ], 'JobLogs' => [ 'base' => NULL, 'refs' => [ 'DescribeJobLogItemsResponse$items' => '<p>An array of Job log items.</p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'Job$status' => '<p>The status of the Job.</p>', ], ], 'JobType' => [ 'base' => NULL, 'refs' => [ 'Job$type' => '<p>The type of the Job.</p>', ], ], 'JobsList' => [ 'base' => NULL, 'refs' => [ 'DescribeJobsResponse$items' => '<p>An array of Jobs.</p>', ], ], 'LargeBoundedString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$code' => NULL, 'AccessDeniedException$message' => NULL, 'ConflictException$code' => NULL, 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The ID of the resource.</p>', 'ConflictException$resourceType' => '<p>The type of the resource.</p>', 'DataReplicationError$rawError' => '<p>Error in data replication.</p>', 'InternalServerException$message' => NULL, 'JobLogEventData$rawError' => '<p>A string representing a job error.</p>', 'RecoveryInstanceDataReplicationError$rawError' => '<p>Error in data replication.</p>', 'ResourceNotFoundException$code' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The ID of the resource.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of the resource.</p>', 'ServiceQuotaExceededException$code' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$quotaCode' => '<p>Quota code.</p>', 'ServiceQuotaExceededException$resourceId' => '<p>The ID of the resource.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The type of the resource.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>Service code.</p>', 'ThrottlingException$message' => NULL, 'ThrottlingException$quotaCode' => '<p>Quota code.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The number of seconds after which the request should be safe to retry.</p>', 'ThrottlingException$serviceCode' => '<p>Service code.</p>', 'UninitializedAccountException$code' => NULL, 'UninitializedAccountException$message' => NULL, 'ValidationException$code' => NULL, 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>Validate exception field message.</p>', 'ValidationExceptionField$name' => '<p>Validate exception field name.</p>', ], ], 'LastLaunchResult' => [ 'base' => NULL, 'refs' => [ 'SourceServer$lastLaunchResult' => '<p>The status of the last recovery launch of this Source Server.</p>', ], ], 'LastLaunchType' => [ 'base' => NULL, 'refs' => [ 'LifeCycleLastLaunchInitiated$type' => '<p>The Job type that was used to last launch the Source Server.</p>', ], ], 'LaunchConfiguration' => [ 'base' => NULL, 'refs' => [], ], 'LaunchDisposition' => [ 'base' => NULL, 'refs' => [ 'LaunchConfiguration$launchDisposition' => '<p>The state of the Recovery Instance in EC2 after the recovery operation.</p>', 'UpdateLaunchConfigurationRequest$launchDisposition' => '<p>The state of the Recovery Instance in EC2 after the recovery operation.</p>', ], ], 'LaunchStatus' => [ 'base' => NULL, 'refs' => [ 'ParticipatingServer$launchStatus' => '<p>The launch status of a participating server.</p>', ], ], 'Licensing' => [ 'base' => '<p>Configuration of a machine\'s license.</p>', 'refs' => [ 'LaunchConfiguration$licensing' => '<p>The licensing configuration to be used for this launch configuration.</p>', 'UpdateLaunchConfigurationRequest$licensing' => '<p>The licensing configuration to be used for this launch configuration.</p>', ], ], 'LifeCycle' => [ 'base' => '<p>An object representing the Source Server Lifecycle.</p>', 'refs' => [ 'SourceServer$lifeCycle' => '<p>The lifecycle information of this Source Server.</p>', ], ], 'LifeCycleLastLaunch' => [ 'base' => '<p>An object containing information regarding the last launch of a Source Server.</p>', 'refs' => [ 'LifeCycle$lastLaunch' => '<p>An object containing information regarding the last launch of the Source Server.</p>', ], ], 'LifeCycleLastLaunchInitiated' => [ 'base' => '<p>An object containing information regarding the initiation of the last launch of a Source Server.</p>', 'refs' => [ 'LifeCycleLastLaunch$initiated' => '<p>An object containing information regarding the initiation of the last launch of a Source Server.</p>', ], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'NetworkInterface' => [ 'base' => '<p>Network interface.</p>', 'refs' => [ 'NetworkInterfaces$member' => NULL, ], ], 'NetworkInterfaces' => [ 'base' => NULL, 'refs' => [ 'RecoveryInstanceProperties$networkInterfaces' => '<p>An array of network interfaces.</p>', 'SourceProperties$networkInterfaces' => '<p>An array of network interfaces.</p>', ], ], 'OS' => [ 'base' => '<p>Operating System.</p>', 'refs' => [ 'RecoveryInstanceProperties$os' => '<p>Operating system.</p>', 'SourceProperties$os' => '<p>Operating system.</p>', ], ], 'PITPolicy' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$pitPolicy' => '<p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>', 'ReplicationConfiguration$pitPolicy' => '<p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>', 'ReplicationConfigurationTemplate$pitPolicy' => '<p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>', 'UpdateReplicationConfigurationRequest$pitPolicy' => '<p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>', 'UpdateReplicationConfigurationTemplateRequest$pitPolicy' => '<p>The Point in time (PIT) policy to manage snapshots taken during replication.</p>', ], ], 'PITPolicyRule' => [ 'base' => '<p>A rule in the Point in Time (PIT) policy representing when to take snapshots and how long to retain them for.</p>', 'refs' => [ 'PITPolicy$member' => NULL, ], ], 'PITPolicyRuleUnits' => [ 'base' => NULL, 'refs' => [ 'PITPolicyRule$units' => '<p>The units used to measure the interval and retentionDuration.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'DescribeJobLogItemsRequest$nextToken' => '<p>The token of the next Job log items to retrieve.</p>', 'DescribeJobLogItemsResponse$nextToken' => '<p>The token of the next Job log items to retrieve.</p>', 'DescribeJobsRequest$nextToken' => '<p>The token of the next Job to retrieve.</p>', 'DescribeJobsResponse$nextToken' => '<p>The token of the next Job to retrieve.</p>', 'DescribeRecoveryInstancesRequest$nextToken' => '<p>The token of the next Recovery Instance to retrieve.</p>', 'DescribeRecoveryInstancesResponse$nextToken' => '<p>The token of the next Recovery Instance to retrieve.</p>', 'DescribeRecoverySnapshotsRequest$nextToken' => '<p>The token of the next Recovery Snapshot to retrieve.</p>', 'DescribeRecoverySnapshotsResponse$nextToken' => '<p>The token of the next Recovery Snapshot to retrieve.</p>', 'DescribeReplicationConfigurationTemplatesRequest$nextToken' => '<p>The token of the next Replication Configuration Template to retrieve.</p>', 'DescribeReplicationConfigurationTemplatesResponse$nextToken' => '<p>The token of the next Replication Configuration Template to retrieve.</p>', 'DescribeSourceServersRequest$nextToken' => '<p>The token of the next Source Server to retrieve.</p>', 'DescribeSourceServersResponse$nextToken' => '<p>The token of the next Source Server to retrieve.</p>', ], ], 'ParticipatingServer' => [ 'base' => '<p>Represents a server participating in an asynchronous Job.</p>', 'refs' => [ 'ParticipatingServers$member' => NULL, ], ], 'ParticipatingServers' => [ 'base' => NULL, 'refs' => [ 'Job$participatingServers' => '<p>A list of servers that the Job is acting upon.</p>', ], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'CPU$cores' => '<p>The number of CPU cores.</p>', 'CreateReplicationConfigurationTemplateRequest$bandwidthThrottling' => '<p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>', 'DataReplicationInfoReplicatedDisk$backloggedStorageBytes' => '<p>The size of the replication backlog in bytes.</p>', 'DataReplicationInfoReplicatedDisk$replicatedStorageBytes' => '<p>The amount of data replicated so far in bytes.</p>', 'DataReplicationInfoReplicatedDisk$rescannedStorageBytes' => '<p>The amount of data to be rescanned in bytes.</p>', 'DataReplicationInfoReplicatedDisk$totalStorageBytes' => '<p>The total amount of data to be replicated in bytes.</p>', 'Disk$bytes' => '<p>The amount of storage on the disk in bytes.</p>', 'GetFailbackReplicationConfigurationResponse$bandwidthThrottling' => '<p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>', 'InternalServerException$retryAfterSeconds' => '<p>The number of seconds after which the request should be safe to retry.</p>', 'PITPolicyRule$ruleID' => '<p>The ID of the rule.</p>', 'RecoveryInstanceDataReplicationInfoReplicatedDisk$backloggedStorageBytes' => '<p>The size of the replication backlog in bytes.</p>', 'RecoveryInstanceDataReplicationInfoReplicatedDisk$replicatedStorageBytes' => '<p>The amount of data replicated so far in bytes.</p>', 'RecoveryInstanceDataReplicationInfoReplicatedDisk$rescannedStorageBytes' => '<p>The amount of data to be rescanned in bytes.</p>', 'RecoveryInstanceDataReplicationInfoReplicatedDisk$totalStorageBytes' => '<p>The total amount of data to be replicated in bytes.</p>', 'RecoveryInstanceDisk$bytes' => '<p>The amount of storage on the disk in bytes.</p>', 'RecoveryInstanceProperties$ramBytes' => '<p>The amount of RAM in bytes.</p>', 'ReplicationConfiguration$bandwidthThrottling' => '<p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>', 'ReplicationConfigurationReplicatedDisk$iops' => '<p>The requested number of I/O operations per second (IOPS).</p>', 'ReplicationConfigurationReplicatedDisk$throughput' => '<p>The throughput to use for the EBS volume in MiB/s. This parameter is valid only for gp3 volumes.</p>', 'ReplicationConfigurationTemplate$bandwidthThrottling' => '<p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>', 'SourceProperties$ramBytes' => '<p>The amount of RAM in bytes.</p>', 'UpdateFailbackReplicationConfigurationRequest$bandwidthThrottling' => '<p>Configure bandwidth throttling for the outbound data transfer rate of the Recovery Instance in Mbps.</p>', 'UpdateReplicationConfigurationRequest$bandwidthThrottling' => '<p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>', 'UpdateReplicationConfigurationTemplateRequest$bandwidthThrottling' => '<p>Configure bandwidth throttling for the outbound data transfer rate of the Source Server in Mbps.</p>', ], ], 'RecoveryInstance' => [ 'base' => '<p>A Recovery Instance is a replica of a Source Server running on EC2.</p>', 'refs' => [ 'DescribeRecoveryInstancesItems$member' => NULL, ], ], 'RecoveryInstanceDataReplicationError' => [ 'base' => '<p>Error in data replication.</p>', 'refs' => [ 'RecoveryInstanceDataReplicationInfo$dataReplicationError' => '<p>Information about Data Replication</p>', ], ], 'RecoveryInstanceDataReplicationInfo' => [ 'base' => '<p>Information about Data Replication</p>', 'refs' => [ 'RecoveryInstance$dataReplicationInfo' => '<p>The Data Replication Info of the Recovery Instance.</p>', ], ], 'RecoveryInstanceDataReplicationInfoReplicatedDisk' => [ 'base' => '<p>A disk that should be replicated.</p>', 'refs' => [ 'RecoveryInstanceDataReplicationInfoReplicatedDisks$member' => NULL, ], ], 'RecoveryInstanceDataReplicationInfoReplicatedDisks' => [ 'base' => NULL, 'refs' => [ 'RecoveryInstanceDataReplicationInfo$replicatedDisks' => '<p>The disks that should be replicated.</p>', ], ], 'RecoveryInstanceDataReplicationInitiation' => [ 'base' => '<p>Data replication initiation.</p>', 'refs' => [ 'RecoveryInstanceDataReplicationInfo$dataReplicationInitiation' => '<p>Information about whether the data replication has been initiated.</p>', ], ], 'RecoveryInstanceDataReplicationInitiationStep' => [ 'base' => '<p>Data replication initiation step.</p>', 'refs' => [ 'RecoveryInstanceDataReplicationInitiationSteps$member' => NULL, ], ], 'RecoveryInstanceDataReplicationInitiationStepName' => [ 'base' => NULL, 'refs' => [ 'RecoveryInstanceDataReplicationInitiationStep$name' => '<p>The name of the step.</p>', ], ], 'RecoveryInstanceDataReplicationInitiationStepStatus' => [ 'base' => NULL, 'refs' => [ 'RecoveryInstanceDataReplicationInitiationStep$status' => '<p>The status of the step.</p>', ], ], 'RecoveryInstanceDataReplicationInitiationSteps' => [ 'base' => NULL, 'refs' => [ 'RecoveryInstanceDataReplicationInitiation$steps' => '<p>The steps of the current attempt to initiate data replication.</p>', ], ], 'RecoveryInstanceDataReplicationState' => [ 'base' => NULL, 'refs' => [ 'RecoveryInstanceDataReplicationInfo$dataReplicationState' => '<p>The state of the data replication.</p>', ], ], 'RecoveryInstanceDisk' => [ 'base' => '<p>An object representing a block storage device on the Recovery Instance.</p>', 'refs' => [ 'RecoveryInstanceDisks$member' => NULL, ], ], 'RecoveryInstanceDisks' => [ 'base' => NULL, 'refs' => [ 'RecoveryInstanceProperties$disks' => '<p>An array of disks.</p>', ], ], 'RecoveryInstanceFailback' => [ 'base' => '<p>An object representing failback related information of the Recovery Instance.</p>', 'refs' => [ 'RecoveryInstance$failback' => '<p>An object representing failback related information of the Recovery Instance.</p>', ], ], 'RecoveryInstanceID' => [ 'base' => NULL, 'refs' => [ 'DeleteRecoveryInstanceRequest$recoveryInstanceID' => '<p>RThe ID of the Recovery Instance to be deleted.</p>', 'DisconnectRecoveryInstanceRequest$recoveryInstanceID' => '<p>The ID of the Recovery Instance to disconnect.</p>', 'GetFailbackReplicationConfigurationRequest$recoveryInstanceID' => '<p>The ID of the Recovery Instance whose failback replication configuration should be returned.</p>', 'GetFailbackReplicationConfigurationResponse$recoveryInstanceID' => '<p>The ID of the Recovery Instance.</p>', 'ParticipatingServer$recoveryInstanceID' => '<p>The Recovery Instance ID of a participating server.</p>', 'RecoveryInstance$recoveryInstanceID' => '<p>The ID of the Recovery Instance.</p>', 'RecoveryInstanceIDs$member' => NULL, 'RecoveryInstancesForTerminationRequest$member' => NULL, 'SourceServer$recoveryInstanceId' => '<p>The ID of the Recovery Instance associated with this Source Server.</p>', 'StartFailbackRequestRecoveryInstanceIDs$member' => NULL, 'StopFailbackRequest$recoveryInstanceID' => '<p>The ID of the Recovery Instance we want to stop failback for.</p>', 'UpdateFailbackReplicationConfigurationRequest$recoveryInstanceID' => '<p>The ID of the Recovery Instance.</p>', ], ], 'RecoveryInstanceIDs' => [ 'base' => NULL, 'refs' => [ 'DescribeRecoveryInstancesRequestFilters$recoveryInstanceIDs' => '<p>An array of Recovery Instance IDs that should be returned. An empty array means all Recovery Instances.</p>', ], ], 'RecoveryInstanceProperties' => [ 'base' => '<p>Properties of the Recovery Instance machine.</p>', 'refs' => [ 'RecoveryInstance$recoveryInstanceProperties' => '<p>Properties of the Recovery Instance machine.</p>', ], ], 'RecoveryInstancesForTerminationRequest' => [ 'base' => NULL, 'refs' => [ 'TerminateRecoveryInstancesRequest$recoveryInstanceIDs' => '<p>The IDs of the Recovery Instances that should be terminated.</p>', ], ], 'RecoverySnapshot' => [ 'base' => '<p>A snapshot of a Source Server used during recovery.</p>', 'refs' => [ 'RecoverySnapshotsList$member' => NULL, ], ], 'RecoverySnapshotID' => [ 'base' => NULL, 'refs' => [ 'RecoverySnapshot$snapshotID' => '<p>The ID of the Recovery Snapshot.</p>', 'StartRecoveryRequestSourceServer$recoverySnapshotID' => '<p>The ID of a Recovery Snapshot we want to recover from. Omit this field to launch from the latest data by taking an on-demand snapshot.</p>', ], ], 'RecoverySnapshotsList' => [ 'base' => NULL, 'refs' => [ 'DescribeRecoverySnapshotsResponse$items' => '<p>An array of Recovery Snapshots.</p>', ], ], 'RecoverySnapshotsOrder' => [ 'base' => NULL, 'refs' => [ 'DescribeRecoverySnapshotsRequest$order' => '<p>The sorted ordering by which to return Recovery Snapshots.</p>', ], ], 'ReplicationConfiguration' => [ 'base' => NULL, 'refs' => [], ], 'ReplicationConfigurationDataPlaneRouting' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$dataPlaneRouting' => '<p>The data plane routing mechanism that will be used for replication.</p>', 'ReplicationConfiguration$dataPlaneRouting' => '<p>The data plane routing mechanism that will be used for replication.</p>', 'ReplicationConfigurationTemplate$dataPlaneRouting' => '<p>The data plane routing mechanism that will be used for replication.</p>', 'UpdateReplicationConfigurationRequest$dataPlaneRouting' => '<p>The data plane routing mechanism that will be used for replication.</p>', 'UpdateReplicationConfigurationTemplateRequest$dataPlaneRouting' => '<p>The data plane routing mechanism that will be used for replication.</p>', ], ], 'ReplicationConfigurationDefaultLargeStagingDiskType' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$defaultLargeStagingDiskType' => '<p>The Staging Disk EBS volume type to be used during replication.</p>', 'ReplicationConfiguration$defaultLargeStagingDiskType' => '<p>The Staging Disk EBS volume type to be used during replication.</p>', 'ReplicationConfigurationTemplate$defaultLargeStagingDiskType' => '<p>The Staging Disk EBS volume type to be used during replication.</p>', 'UpdateReplicationConfigurationRequest$defaultLargeStagingDiskType' => '<p>The Staging Disk EBS volume type to be used during replication.</p>', 'UpdateReplicationConfigurationTemplateRequest$defaultLargeStagingDiskType' => '<p>The Staging Disk EBS volume type to be used during replication.</p>', ], ], 'ReplicationConfigurationEbsEncryption' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$ebsEncryption' => '<p>The type of EBS encryption to be used during replication.</p>', 'ReplicationConfiguration$ebsEncryption' => '<p>The type of EBS encryption to be used during replication.</p>', 'ReplicationConfigurationTemplate$ebsEncryption' => '<p>The type of EBS encryption to be used during replication.</p>', 'UpdateReplicationConfigurationRequest$ebsEncryption' => '<p>The type of EBS encryption to be used during replication.</p>', 'UpdateReplicationConfigurationTemplateRequest$ebsEncryption' => '<p>The type of EBS encryption to be used during replication.</p>', ], ], 'ReplicationConfigurationReplicatedDisk' => [ 'base' => '<p>The configuration of a disk of the Source Server to be replicated.</p>', 'refs' => [ 'ReplicationConfigurationReplicatedDisks$member' => NULL, ], ], 'ReplicationConfigurationReplicatedDiskStagingDiskType' => [ 'base' => NULL, 'refs' => [ 'ReplicationConfigurationReplicatedDisk$stagingDiskType' => '<p>The Staging Disk EBS volume type to be used during replication.</p>', ], ], 'ReplicationConfigurationReplicatedDisks' => [ 'base' => NULL, 'refs' => [ 'ReplicationConfiguration$replicatedDisks' => '<p>The configuration of the disks of the Source Server to be replicated.</p>', 'UpdateReplicationConfigurationRequest$replicatedDisks' => '<p>The configuration of the disks of the Source Server to be replicated.</p>', ], ], 'ReplicationConfigurationTemplate' => [ 'base' => NULL, 'refs' => [ 'ReplicationConfigurationTemplates$member' => NULL, ], ], 'ReplicationConfigurationTemplateID' => [ 'base' => NULL, 'refs' => [ 'DeleteReplicationConfigurationTemplateRequest$replicationConfigurationTemplateID' => '<p>The ID of the Replication Configuration Template to be deleted.</p>', 'ReplicationConfigurationTemplate$replicationConfigurationTemplateID' => '<p>The Replication Configuration Template ID.</p>', 'ReplicationConfigurationTemplateIDs$member' => NULL, 'UpdateReplicationConfigurationTemplateRequest$replicationConfigurationTemplateID' => '<p>The Replication Configuration Template ID.</p>', ], ], 'ReplicationConfigurationTemplateIDs' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicationConfigurationTemplatesRequest$replicationConfigurationTemplateIDs' => '<p>The IDs of the Replication Configuration Templates to retrieve. An empty list means all Replication Configuration Templates.</p>', ], ], 'ReplicationConfigurationTemplates' => [ 'base' => NULL, 'refs' => [ 'DescribeReplicationConfigurationTemplatesResponse$items' => '<p>An array of Replication Configuration Templates.</p>', ], ], 'ReplicationServersSecurityGroupsIDs' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$replicationServersSecurityGroupsIDs' => '<p>The security group IDs that will be used by the replication server.</p>', 'ReplicationConfiguration$replicationServersSecurityGroupsIDs' => '<p>The security group IDs that will be used by the replication server.</p>', 'ReplicationConfigurationTemplate$replicationServersSecurityGroupsIDs' => '<p>The security group IDs that will be used by the replication server.</p>', 'UpdateReplicationConfigurationRequest$replicationServersSecurityGroupsIDs' => '<p>The security group IDs that will be used by the replication server.</p>', 'UpdateReplicationConfigurationTemplateRequest$replicationServersSecurityGroupsIDs' => '<p>The security group IDs that will be used by the replication server.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource for this operation was not found.</p>', 'refs' => [], ], 'RetryDataReplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'SecurityGroupID' => [ 'base' => NULL, 'refs' => [ 'ReplicationServersSecurityGroupsIDs$member' => NULL, ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request could not be completed because its exceeded the service quota.</p>', 'refs' => [], ], 'SmallBoundedString' => [ 'base' => NULL, 'refs' => [ 'LaunchConfiguration$name' => '<p>The name of the launch configuration.</p>', 'ReplicationConfiguration$name' => '<p>The name of the Replication Configuration.</p>', 'UpdateLaunchConfigurationRequest$name' => '<p>The name of the launch configuration.</p>', 'UpdateReplicationConfigurationRequest$name' => '<p>The name of the Replication Configuration.</p>', ], ], 'SourceProperties' => [ 'base' => '<p>Properties of the Source Server machine.</p>', 'refs' => [ 'SourceServer$sourceProperties' => '<p>The source properties of the Source Server.</p>', ], ], 'SourceServer' => [ 'base' => NULL, 'refs' => [ 'SourceServersList$member' => NULL, ], ], 'SourceServerID' => [ 'base' => NULL, 'refs' => [ 'DeleteSourceServerRequest$sourceServerID' => '<p>The ID of the Source Server to be deleted.</p>', 'DescribeRecoverySnapshotsRequest$sourceServerID' => '<p>Filter Recovery Snapshots by Source Server ID.</p>', 'DescribeSourceServersRequestFiltersIDs$member' => NULL, 'DisconnectSourceServerRequest$sourceServerID' => '<p>The ID of the Source Server to disconnect.</p>', 'GetLaunchConfigurationRequest$sourceServerID' => '<p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>', 'GetReplicationConfigurationRequest$sourceServerID' => '<p>The ID of the Source Serve for this Replication Configuration.r</p>', 'JobLogEventData$sourceServerID' => '<p>The ID of a Source Server.</p>', 'LaunchConfiguration$sourceServerID' => '<p>The ID of the Source Server for this launch configuration.</p>', 'ParticipatingServer$sourceServerID' => '<p>The Source Server ID of a participating server.</p>', 'RecoveryInstance$sourceServerID' => '<p>The Source Server ID that this Recovery Instance is associated with.</p>', 'RecoverySnapshot$sourceServerID' => '<p>The ID of the Source Server that the snapshot was taken for.</p>', 'ReplicationConfiguration$sourceServerID' => '<p>The ID of the Source Server for this Replication Configuration.</p>', 'RetryDataReplicationRequest$sourceServerID' => '<p>The ID of the Source Server whose data replication should be retried.</p>', 'SourceServer$sourceServerID' => '<p>The ID of the Source Server.</p>', 'SourceServerIDs$member' => NULL, 'StartRecoveryRequestSourceServer$sourceServerID' => '<p>The ID of the Source Server you want to recover.</p>', 'UpdateLaunchConfigurationRequest$sourceServerID' => '<p>The ID of the Source Server that we want to retrieve a Launch Configuration for.</p>', 'UpdateReplicationConfigurationRequest$sourceServerID' => '<p>The ID of the Source Server for this Replication Configuration.</p>', ], ], 'SourceServerIDs' => [ 'base' => NULL, 'refs' => [ 'DescribeRecoveryInstancesRequestFilters$sourceServerIDs' => '<p>An array of Source Server IDs for which associated Recovery Instances should be returned.</p>', ], ], 'SourceServersList' => [ 'base' => NULL, 'refs' => [ 'DescribeSourceServersResponse$items' => '<p>An array of Source Servers.</p>', ], ], 'StartFailbackLaunchRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartFailbackLaunchResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartFailbackRequestRecoveryInstanceIDs' => [ 'base' => NULL, 'refs' => [ 'StartFailbackLaunchRequest$recoveryInstanceIDs' => '<p>The IDs of the Recovery Instance whose failback launch we want to request.</p>', ], ], 'StartRecoveryRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartRecoveryRequestSourceServer' => [ 'base' => '<p>An object representing the Source Server to recover.</p>', 'refs' => [ 'StartRecoveryRequestSourceServers$member' => NULL, ], ], 'StartRecoveryRequestSourceServers' => [ 'base' => NULL, 'refs' => [ 'StartRecoveryRequest$sourceServers' => '<p>The Source Servers that we want to start a Recovery Job for.</p>', ], ], 'StartRecoveryResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopFailbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'StrictlyPositiveInteger' => [ 'base' => NULL, 'refs' => [ 'DescribeJobLogItemsRequest$maxResults' => '<p>Maximum number of Job log items to retrieve.</p>', 'DescribeJobsRequest$maxResults' => '<p>Maximum number of Jobs to retrieve.</p>', 'DescribeRecoveryInstancesRequest$maxResults' => '<p>Maximum number of Recovery Instances to retrieve.</p>', 'DescribeRecoverySnapshotsRequest$maxResults' => '<p>Maximum number of Recovery Snapshots to retrieve.</p>', 'DescribeReplicationConfigurationTemplatesRequest$maxResults' => '<p>Maximum number of Replication Configuration Templates to retrieve.</p>', 'DescribeSourceServersRequest$maxResults' => '<p>Maximum number of Source Servers to retrieve.</p>', 'PITPolicyRule$interval' => '<p>How often, in the chosen units, a snapshot should be taken.</p>', 'PITPolicyRule$retentionDuration' => '<p>The duration to retain a snapshot for, in the chosen units.</p>', ], ], 'SubnetID' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$stagingAreaSubnetId' => '<p>The subnet to be used by the replication staging area.</p>', 'ReplicationConfiguration$stagingAreaSubnetId' => '<p>The subnet to be used by the replication staging area.</p>', 'ReplicationConfigurationTemplate$stagingAreaSubnetId' => '<p>The subnet to be used by the replication staging area.</p>', 'UpdateReplicationConfigurationRequest$stagingAreaSubnetId' => '<p>The subnet to be used by the replication staging area.</p>', 'UpdateReplicationConfigurationTemplateRequest$stagingAreaSubnetId' => '<p>The subnet to be used by the replication staging area.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeys$member' => NULL, 'TagsMap$key' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>Array of tags to be removed.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagsMap$value' => NULL, ], ], 'TagsMap' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationConfigurationTemplateRequest$stagingAreaTags' => '<p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>', 'CreateReplicationConfigurationTemplateRequest$tags' => '<p>A set of tags to be associated with the Replication Configuration Template resource.</p>', 'Job$tags' => '<p>A list of tags associated with the Job.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags of the requested resource.</p>', 'RecoveryInstance$tags' => '<p>An array of tags that are associated with the Recovery Instance.</p>', 'ReplicationConfiguration$stagingAreaTags' => '<p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>', 'ReplicationConfigurationTemplate$stagingAreaTags' => '<p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>', 'ReplicationConfigurationTemplate$tags' => '<p>A set of tags to be associated with the Replication Configuration Template resource.</p>', 'SourceServer$tags' => '<p>The tags associated with the Source Server.</p>', 'StartFailbackLaunchRequest$tags' => '<p>The tags to be associated with the failback launch Job.</p>', 'StartRecoveryRequest$tags' => '<p>The tags to be associated with the Recovery Job.</p>', 'TagResourceRequest$tags' => '<p>Array of tags to be added or updated.</p>', 'UpdateReplicationConfigurationRequest$stagingAreaTags' => '<p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>', 'UpdateReplicationConfigurationTemplateRequest$stagingAreaTags' => '<p>A set of tags to be associated with all resources created in the replication staging area: EC2 replication server, EBS volumes, EBS snapshots, etc.</p>', ], ], 'TargetInstanceTypeRightSizingMethod' => [ 'base' => NULL, 'refs' => [ 'LaunchConfiguration$targetInstanceTypeRightSizingMethod' => '<p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>', 'UpdateLaunchConfigurationRequest$targetInstanceTypeRightSizingMethod' => '<p>Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS, CPU, and RAM of your Source Server.</p>', ], ], 'TerminateRecoveryInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'TerminateRecoveryInstancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'UninitializedAccountException' => [ 'base' => '<p>The account performing the request has not been initialized.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFailbackReplicationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLaunchConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReplicationConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReplicationConfigurationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by the AWS service.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Validate exception field.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>A list of fields that failed validation.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>Validation exception reason.</p>', ], ], 'ebsSnapshot' => [ 'base' => NULL, 'refs' => [ 'EbsSnapshotsList$member' => NULL, ], ], ],];
