<?php
// This file was auto-generated from sdk-root/src/data/evidently/2021-02-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>You can use Amazon CloudWatch Evidently to safely validate new features by serving them to a specified percentage of your users while you roll out the feature. You can monitor the performance of the new feature to help you decide when to ramp up traffic to your users. This helps you reduce risk and identify unintended consequences before you fully launch the feature.</p> <p>You can also conduct A/B experiments to make feature design decisions based on evidence and data. An experiment can test as many as five variations at once. Evidently collects experiment data and analyzes it using statistical methods. It also provides clear recommendations about which variations perform better. You can test both user-facing features and backend features.</p>', 'operations' => [ 'BatchEvaluateFeature' => '<p>This operation assigns feature variation to user sessions. For each user session, you pass in an <code>entityID</code> that represents the user. Evidently then checks the evaluation rules and assigns the variation.</p> <p>The first rules that are evaluated are the override rules. If the user\'s <code>entityID</code> matches an override rule, the user is served the variation specified by that rule.</p> <p>Next, if there is a launch of the feature, the user might be assigned to a variation in the launch. The chance of this depends on the percentage of users that are allocated to that launch. If the user is enrolled in the launch, the variation they are served depends on the allocation of the various feature variations used for the launch.</p> <p>If the user is not assigned to a launch, and there is an ongoing experiment for this feature, the user might be assigned to a variation in the experiment. The chance of this depends on the percentage of users that are allocated to that experiment. If the user is enrolled in the experiment, the variation they are served depends on the allocation of the various feature variations used for the experiment. </p> <p>If the user is not assigned to a launch or experiment, they are served the default variation.</p>', 'CreateExperiment' => '<p>Creates an Evidently <i>experiment</i>. Before you create an experiment, you must create the feature to use for the experiment.</p> <p>An experiment helps you make feature design decisions based on evidence and data. An experiment can test as many as five variations at once. Evidently collects experiment data and analyzes it by statistical methods, and provides clear recommendations about which variations perform better.</p> <p>Don\'t use this operation to update an existing experiment. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateExperiment.html">UpdateExperiment</a>. </p>', 'CreateFeature' => '<p>Creates an Evidently <i>feature</i> that you want to launch or test. You can define up to five variations of a feature, and use these variations in your launches and experiments. A feature must be created in a project. For information about creating a project, see <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html">CreateProject</a>.</p> <p>Don\'t use this operation to update an existing feature. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateFeature.html">UpdateFeature</a>. </p>', 'CreateLaunch' => '<p>Creates a <i>launch</i> of a given feature. Before you create a launch, you must create the feature to use for the launch.</p> <p>You can use a launch to safely validate new features by serving them to a specified percentage of your users while you roll out the feature. You can monitor the performance of the new feature to help you decide when to ramp up traffic to more users. This helps you reduce risk and identify unintended consequences before you fully launch the feature.</p> <p>Don\'t use this operation to update an existing launch. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateLaunch.html">UpdateLaunch</a>. </p>', 'CreateProject' => '<p>Creates a project, which is the logical object in Evidently that can contain features, launches, and experiments. Use projects to group similar features together.</p> <p>To update an existing project, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProject.html">UpdateProject</a>.</p>', 'DeleteExperiment' => '<p>Deletes an Evidently experiment. The feature used for the experiment is not deleted.</p> <p>To stop an experiment without deleting it, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopExperiment.html">StopExperiment</a>. </p>', 'DeleteFeature' => '<p>Deletes an Evidently feature.</p>', 'DeleteLaunch' => '<p>Deletes an Evidently launch. The feature used for the launch is not deleted.</p> <p>To stop a launch without deleting it, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_StopLaunch.html">StopLaunch</a>. </p>', 'DeleteProject' => '<p>Deletes an Evidently project. Before you can delete a project, you must delete all the features that the project contains. To delete a feature, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_DeleteFeature.html">DeleteFeature</a>.</p>', 'EvaluateFeature' => '<p>This operation assigns a feature variation to one given user session. You pass in an <code>entityID</code> that represents the user. Evidently then checks the evaluation rules and assigns the variation.</p> <p>The first rules that are evaluated are the override rules. If the user\'s <code>entityID</code> matches an override rule, the user is served the variation specified by that rule.</p> <p>Next, if there is a launch of the feature, the user might be assigned to a variation in the launch. The chance of this depends on the percentage of users that are allocated to that launch. If the user is enrolled in the launch, the variation they are served depends on the allocation of the various feature variations used for the launch.</p> <p>If the user is not assigned to a launch, and there is an ongoing experiment for this feature, the user might be assigned to a variation in the experiment. The chance of this depends on the percentage of users that are allocated to that experiment. If the user is enrolled in the experiment, the variation they are served depends on the allocation of the various feature variations used for the experiment. </p> <p>If the user is not assigned to a launch or experiment, they are served the default variation.</p>', 'GetExperiment' => '<p>Returns the details about one experiment. You must already know the experiment name. To retrieve a list of experiments in your account, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListExperiments.html">ListExperiments</a>.</p>', 'GetExperimentResults' => '<p>Retrieves the results of a running or completed experiment.</p>', 'GetFeature' => '<p>Returns the details about one feature. You must already know the feature name. To retrieve a list of features in your account, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListFeatures.html">ListFeatures</a>.</p>', 'GetLaunch' => '<p>Returns the details about one launch. You must already know the launch name. To retrieve a list of launches in your account, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListLaunches.html">ListLaunches</a>.</p>', 'GetProject' => '<p>Returns the details about one launch. You must already know the project name. To retrieve a list of projects in your account, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ListProjects.html">ListProjects</a>.</p>', 'ListExperiments' => '<p>Returns configuration details about all the experiments in the specified project.</p>', 'ListFeatures' => '<p>Returns configuration details about all the features in the specified project.</p>', 'ListLaunches' => '<p>Returns configuration details about all the launches in the specified project.</p>', 'ListProjects' => '<p>Returns configuration details about all the projects in the current Region in your account.</p>', 'ListTagsForResource' => '<p>Displays the tags associated with an Evidently resource.</p>', 'PutProjectEvents' => '<p>Sends performance events to Evidently. These events can be used to evaluate a launch or an experiment.</p>', 'StartExperiment' => '<p>Starts an existing experiment. To create an experiment, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateExperiment.html">CreateExperiment</a>.</p>', 'StartLaunch' => '<p>Starts an existing launch. To create a launch, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateLaunch.html">CreateLaunch</a>.</p>', 'StopExperiment' => '<p>Stops an experiment that is currently running. If you stop an experiment, you can\'t resume it or restart it.</p>', 'StopLaunch' => '<p>Stops a launch that is currently running. After you stop a launch, you will not be able to resume it or restart it. Also, it will not be evaluated as a rule for traffic allocation, and the traffic that was allocated to the launch will instead be available to the feature\'s experiment, if there is one. Otherwise, all traffic will be served the default variation after the launch is stopped.</p>', 'TagResource' => '<p>Assigns one or more tags (key-value pairs) to the specified CloudWatch Evidently resource. Projects, features, launches, and experiments can be tagged.</p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p> <p>Tags don\'t have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p> <p>You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p> <p>You can associate as many as 50 tags with a resource.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>', 'UntagResource' => '<p>Removes one or more tags from the specified resource.</p>', 'UpdateExperiment' => '<p>Updates an Evidently experiment. </p> <p>Don\'t use this operation to update an experiment\'s tag. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>. </p>', 'UpdateFeature' => '<p>Updates an existing feature.</p> <p>You can\'t use this operation to update the tags of an existing feature. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>. </p>', 'UpdateLaunch' => '<p>Updates a launch of a given feature. </p> <p>Don\'t use this operation to update the tags of an existing launch. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>. </p>', 'UpdateProject' => '<p>Updates the description of an existing project.</p> <p>To create a new project, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_CreateProject.html">CreateProject</a>.</p> <p>Don\'t use this operation to update the data storage options of a project. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_UpdateProjectDataDelivery.html">UpdateProjectDataDelivery</a>. </p> <p>Don\'t use this operation to update the tags of a project. Instead, use <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_TagResource.html">TagResource</a>. </p>', 'UpdateProjectDataDelivery' => '<p>Updates the data storage options for this project. If you store evaluation events, you an keep them and analyze them on your own. If you choose not to store evaluation events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.</p> <p>You can\'t specify both <code>cloudWatchLogs</code> and <code>s3Destination</code> in the same operation.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient permissions to perform this action. </p>', 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'EvaluationResult$project' => '<p>The name or ARN of the project that contains the feature being evaluated.</p>', 'FeatureSummary$arn' => '<p>The ARN of the feature.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource that you want to see the tags of.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of the CloudWatch Evidently resource that you\'re adding tags to.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of the CloudWatch Evidently resource that you\'re removing tags from.</p>', ], ], 'BatchEvaluateFeatureRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchEvaluateFeatureResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'VariableValue$boolValue' => '<p>If this feature uses the Boolean variation type, this field contains the Boolean value of this variation.</p>', ], ], 'ChangeDirectionEnum' => [ 'base' => NULL, 'refs' => [ 'MetricGoal$desiredChange' => '<p> <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.</p> <p> <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.</p>', 'MetricGoalConfig$desiredChange' => '<p> <code>INCREASE</code> means that a variation with a higher number for this metric is performing better.</p> <p> <code>DECREASE</code> means that a variation with a lower number for this metric is performing better.</p>', ], ], 'CloudWatchLogsDestination' => [ 'base' => '<p>A structure containing the CloudWatch Logs log group where the project stores evaluation events.</p>', 'refs' => [ 'ProjectDataDelivery$cloudWatchLogs' => '<p>If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.</p>', ], ], 'CloudWatchLogsDestinationConfig' => [ 'base' => '<p>A structure containing the CloudWatch Logs log group where the project stores evaluation events.</p>', 'refs' => [ 'ProjectDataDeliveryConfig$cloudWatchLogs' => '<p>If the project stores evaluation events in CloudWatch Logs, this structure stores the log group name.</p>', 'UpdateProjectDataDeliveryRequest$cloudWatchLogs' => '<p>A structure containing the CloudWatch Logs log group where you want to store evaluation events.</p>', ], ], 'ConflictException' => [ 'base' => '<p>A resource was in an inconsistent state during an update or a deletion.</p>', 'refs' => [], ], 'CreateExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFeatureRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFeatureResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLaunchRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLaunchResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'CwDimensionSafeName' => [ 'base' => NULL, 'refs' => [ 'ExperimentReport$metricName' => '<p>The name of the metric that is analyzed in this experiment report.</p>', 'ExperimentResultsData$metricName' => '<p>The name of the metric.</p>', 'MetricDefinition$name' => '<p>The name of the metric.</p>', 'MetricDefinitionConfig$name' => '<p>A name for the metric.</p>', 'MetricNameList$member' => NULL, ], ], 'CwLogGroupSafeName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLogsDestination$logGroup' => '<p>The name of the log group where the project stores evaluation events.</p>', 'CloudWatchLogsDestinationConfig$logGroup' => '<p>The name of the log group where the project stores evaluation events.</p>', ], ], 'DeleteExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFeatureRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFeatureResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentRequest$description' => '<p>An optional description of the experiment.</p>', 'CreateFeatureRequest$description' => '<p>An optional description of the feature.</p>', 'CreateLaunchRequest$description' => '<p>An optional description for the launch.</p>', 'CreateProjectRequest$description' => '<p>An optional description of the project.</p>', 'Experiment$description' => '<p>A description of the experiment.</p>', 'Experiment$statusReason' => '<p>If the experiment was stopped, this is the string that was entered by the person who stopped the experiment, to explain why it was stopped.</p>', 'Feature$description' => '<p>The description of the feature.</p>', 'Launch$description' => '<p>The description of the launch.</p>', 'Launch$statusReason' => '<p>If the launch was stopped, this is the string that was entered by the person who stopped the launch, to explain why it was stopped.</p>', 'LaunchGroup$description' => '<p>A description of the launch group.</p>', 'LaunchGroupConfig$description' => '<p>A description of the launch group.</p>', 'Project$description' => '<p>The user-entered description of the project.</p>', 'ProjectSummary$description' => '<p>The description of the project.</p>', 'StopExperimentRequest$reason' => '<p>A string that describes why you are stopping the experiment.</p>', 'StopLaunchRequest$reason' => '<p>A string that describes why you are stopping the launch.</p>', 'Treatment$description' => '<p>The description of the treatment.</p>', 'TreatmentConfig$description' => '<p>A description for this treatment.</p>', 'UpdateExperimentRequest$description' => '<p>An optional description of the experiment.</p>', 'UpdateFeatureRequest$description' => '<p>An optional description of the feature.</p>', 'UpdateLaunchRequest$description' => '<p>An optional description for the launch.</p>', 'UpdateProjectRequest$description' => '<p>An optional description of the project.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'DoubleValueList$member' => NULL, 'VariableValue$doubleValue' => '<p>If this feature uses the double integer variation type, this field contains the double integer value of this variation.</p>', ], ], 'DoubleValueList' => [ 'base' => NULL, 'refs' => [ 'ExperimentResultsData$values' => '<p>The values for the <code>metricName</code> that were recorded in the experiment.</p>', ], ], 'EntityId' => [ 'base' => NULL, 'refs' => [ 'EntityOverrideMap$key' => NULL, 'EvaluateFeatureRequest$entityId' => '<p>An internal ID that represents a unique user of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>', 'EvaluationRequest$entityId' => '<p>An internal ID that represents a unique user session of the application. This <code>entityID</code> is checked against any override rules assigned for this feature.</p>', 'EvaluationResult$entityId' => '<p>An internal ID that represents a unique user session of the application.</p>', ], ], 'EntityOverrideMap' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureRequest$entityOverrides' => '<p>Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>', 'Feature$entityOverrides' => '<p>A set of key-value pairs that specify users who should always be served a specific variation of a feature. Each key specifies a user using their user ID, account ID, or some other identifier. The value specifies the name of the variation that the user is to be served.</p> <p>For the override to be successful, the value of the key must match the <code>entityId</code> used in the <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html">EvaluateFeature</a> operation.</p>', 'UpdateFeatureRequest$entityOverrides' => '<p>Specified users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.</p>', ], ], 'ErrorCodeEnum' => [ 'base' => '<p>Recommended errors from AWS API standards: https://w.amazon.com/bin/view/AWS/API_Standards/Exceptions ErrorCode = &quot;ValidationException&quot;|&quot;ServiceQuotaExceededException&quot;|&quot;AccessDeniedException&quot;|&quot;ResourceNotFoundException&quot;|&quot;ConflictException&quot;|&quot;ThrottlingException&quot;|&quot;InternalServerException&quot;|string;</p>', 'refs' => [ 'PutProjectEventsResultEntry$errorCode' => '<p>If the <code>PutProjectEvents</code> operation has an error, the error code is returned here.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'PutProjectEventsResultEntry$errorMessage' => '<p>If the <code>PutProjectEvents</code> operation has an error, the error message is returned here.</p>', ], ], 'EvaluateFeatureRequest' => [ 'base' => NULL, 'refs' => [], ], 'EvaluateFeatureResponse' => [ 'base' => NULL, 'refs' => [], ], 'EvaluationRequest' => [ 'base' => '<p>This structure assigns a feature variation to one user session.</p>', 'refs' => [ 'EvaluationRequestsList$member' => NULL, ], ], 'EvaluationRequestsList' => [ 'base' => NULL, 'refs' => [ 'BatchEvaluateFeatureRequest$requests' => '<p>An array of structures, where each structure assigns a feature variation to one user session.</p>', ], ], 'EvaluationResult' => [ 'base' => '<p>This structure displays the results of one feature evaluation assignment to one user session.</p>', 'refs' => [ 'EvaluationResultsList$member' => NULL, ], ], 'EvaluationResultsList' => [ 'base' => NULL, 'refs' => [ 'BatchEvaluateFeatureResponse$results' => '<p>An array of structures, where each structure displays the results of one feature evaluation assignment to one user session.</p>', ], ], 'EvaluationRule' => [ 'base' => '<p>A structure that contains the information about an evaluation rule for this feature, if it is used in a launch or experiment.</p>', 'refs' => [ 'EvaluationRulesList$member' => NULL, ], ], 'EvaluationRulesList' => [ 'base' => NULL, 'refs' => [ 'Feature$evaluationRules' => '<p>An array of structures that define the evaluation rules for the feature.</p>', 'FeatureSummary$evaluationRules' => '<p>An array of structures that define</p>', ], ], 'Event' => [ 'base' => '<p>A structure that contains the information about one evaluation event or custom event sent to Evidently. This is a JSON payload. If this event specifies a pre-defined event type, the payload must follow the defined event schema.</p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'PutProjectEventsRequest$events' => '<p>An array of event structures that contain the performance data that is being sent to Evidently.</p>', ], ], 'EventType' => [ 'base' => NULL, 'refs' => [ 'Event$type' => '<p> <code>aws.evidently.evaluation</code> specifies an evaluation event, which determines which feature variation that a user sees. <code>aws.evidently.custom</code> specifies a custom event, which generates metrics from user actions such as clicks and checkouts.</p>', ], ], 'Experiment' => [ 'base' => '<p>A structure containing the configuration details of an experiment.</p>', 'refs' => [ 'CreateExperimentResponse$experiment' => '<p>A structure containing the configuration details of the experiment that you created.</p>', 'ExperimentList$member' => NULL, 'GetExperimentResponse$experiment' => '<p>A structure containing the configuration details of the experiment.</p>', 'UpdateExperimentResponse$experiment' => '<p>A structure containing the configuration details of the experiment that was updated.</p>', ], ], 'ExperimentArn' => [ 'base' => NULL, 'refs' => [ 'Experiment$arn' => '<p>The ARN of the experiment.</p>', ], ], 'ExperimentBaseStat' => [ 'base' => NULL, 'refs' => [ 'GetExperimentResultsRequest$baseStat' => '<p>The statistic used to calculate experiment results. Currently the only valid value is <code>mean</code>, which uses the mean of the collected values as the statistic.</p>', ], ], 'ExperimentExecution' => [ 'base' => '<p>This structure contains the date and time that the experiment started and ended.</p>', 'refs' => [ 'Experiment$execution' => '<p>A structure that contains the date and time that the experiment started and ended.</p>', ], ], 'ExperimentList' => [ 'base' => NULL, 'refs' => [ 'ListExperimentsResponse$experiments' => '<p>An array of structures that contain the configuration details of the experiments in the specified project.</p>', ], ], 'ExperimentName' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentRequest$name' => '<p>A name for the new experiment.</p>', 'DeleteExperimentRequest$experiment' => '<p>The name of the experiment to delete.</p>', 'Experiment$name' => '<p>The name of the experiment.</p>', 'GetExperimentRequest$experiment' => '<p>The name of the experiment that you want to see the details of.</p>', 'GetExperimentResultsRequest$experiment' => '<p>The name of the experiment to retrieve the results of.</p>', 'StartExperimentRequest$experiment' => '<p>The name of the experiment to start.</p>', 'StopExperimentRequest$experiment' => '<p>The name of the experiment to stop.</p>', 'UpdateExperimentRequest$experiment' => '<p>The name of the experiment to update.</p>', ], ], 'ExperimentReport' => [ 'base' => '<p>A structure that contains results of an experiment.</p>', 'refs' => [ 'ExperimentReportList$member' => NULL, ], ], 'ExperimentReportList' => [ 'base' => NULL, 'refs' => [ 'GetExperimentResultsResponse$reports' => '<p>An array of structures that include the reports that you requested.</p>', ], ], 'ExperimentReportName' => [ 'base' => NULL, 'refs' => [ 'ExperimentReport$reportName' => '<p>The type of analysis used for this report.</p>', 'ExperimentReportNameList$member' => NULL, ], ], 'ExperimentReportNameList' => [ 'base' => NULL, 'refs' => [ 'GetExperimentResultsRequest$reportNames' => '<p>The names of the report types that you want to see. Currently, <code>BayesianInference</code> is the only valid value.</p>', ], ], 'ExperimentResultRequestType' => [ 'base' => NULL, 'refs' => [ 'ExperimentResultRequestTypeList$member' => NULL, ], ], 'ExperimentResultRequestTypeList' => [ 'base' => NULL, 'refs' => [ 'GetExperimentResultsRequest$resultStats' => '<p>The statistics that you want to see in the returned results.</p> <ul> <li> <p> <code>PValue</code> specifies to use p-values for the results. A p-value is used in hypothesis testing to measure how often you are willing to make a mistake in rejecting the null hypothesis. A general practice is to reject the null hypothesis and declare that the results are statistically significant when the p-value is less than 0.05.</p> </li> <li> <p> <code>ConfidenceInterval</code> specifies a confidence interval for the results. The confidence interval represents the range of values for the chosen metric that is likely to contain the true difference between the <code>baseStat</code> of a variation and the baseline. Evidently returns the 95% confidence interval. </p> </li> <li> <p> <code>TreatmentEffect</code> is the difference in the statistic specified by the <code>baseStat</code> parameter between each variation and the default variation. </p> </li> <li> <p> <code>BaseStat</code> returns the statistical values collected for the metric for each variation. The statistic uses the same statistic specified in the <code>baseStat</code> parameter. Therefore, if <code>baseStat</code> is <code>mean</code>, this returns the mean of the values collected for each variation.</p> </li> </ul>', ], ], 'ExperimentResultResponseType' => [ 'base' => NULL, 'refs' => [ 'ExperimentResultsData$resultStat' => '<p>The experiment statistic that these results pertain to.</p>', ], ], 'ExperimentResultsData' => [ 'base' => '<p>A structure that contains experiment results for one metric that is monitored in the experiment.</p>', 'refs' => [ 'ExperimentResultsDataList$member' => NULL, ], ], 'ExperimentResultsDataList' => [ 'base' => NULL, 'refs' => [ 'GetExperimentResultsResponse$resultsData' => '<p>An array of structures that include experiment results including metric names and values. </p>', ], ], 'ExperimentSchedule' => [ 'base' => '<p>This structure contains the time and date that Evidently completed the analysis of the experiment.</p>', 'refs' => [ 'Experiment$schedule' => '<p>A structure that contains the time and date that Evidently completed the analysis of the experiment.</p>', ], ], 'ExperimentStatus' => [ 'base' => NULL, 'refs' => [ 'Experiment$status' => '<p>The current state of the experiment.</p>', ], ], 'ExperimentStopDesiredState' => [ 'base' => NULL, 'refs' => [ 'StopExperimentRequest$desiredState' => '<p>Specify whether the experiment is to be considered <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>', ], ], 'ExperimentType' => [ 'base' => NULL, 'refs' => [ 'Experiment$type' => '<p>The type of this experiment. Currently, this value must be <code>aws.experiment.onlineab</code>.</p>', ], ], 'Feature' => [ 'base' => '<p>This structure contains information about one Evidently feature in your account.</p>', 'refs' => [ 'CreateFeatureResponse$feature' => '<p>A structure that contains information about the new feature.</p>', 'GetFeatureResponse$feature' => '<p>A structure containing the configuration details of the feature.</p>', 'UpdateFeatureResponse$feature' => '<p>A structure that contains information about the updated feature.</p>', ], ], 'FeatureArn' => [ 'base' => NULL, 'refs' => [ 'Feature$arn' => '<p>The ARN of the feature.</p>', ], ], 'FeatureEvaluationStrategy' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureRequest$evaluationStrategy' => '<p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>', 'Feature$evaluationStrategy' => '<p>If this value is <code>ALL_RULES</code>, the traffic allocation specified by any ongoing launches or experiments is being used. If this is <code>DEFAULT_VARIATION</code>, the default variation is being served to all users.</p>', 'FeatureSummary$evaluationStrategy' => '<p>If this value is <code>ALL_RULES</code>, the traffic allocation specified by any ongoing launches or experiments is being used. If this is <code>DEFAULT_VARIATION</code>, the default variation is being served to all users.</p>', 'UpdateFeatureRequest$evaluationStrategy' => '<p>Specify <code>ALL_RULES</code> to activate the traffic allocation specified by any ongoing launches or experiments. Specify <code>DEFAULT_VARIATION</code> to serve the default variation to all users instead.</p>', ], ], 'FeatureName' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureRequest$name' => '<p>The name for the new feature.</p>', 'DeleteFeatureRequest$feature' => '<p>The name of the feature to delete.</p>', 'EvaluateFeatureRequest$feature' => '<p>The name of the feature being evaluated.</p>', 'EvaluationRequest$feature' => '<p>The name of the feature being evaluated.</p>', 'EvaluationResult$feature' => '<p>The name of the feature being evaluated.</p>', 'Feature$name' => '<p>The name of the feature.</p>', 'FeatureSummary$name' => '<p>The name of the feature.</p>', 'FeatureToVariationMap$key' => NULL, 'GetFeatureRequest$feature' => '<p>The name of the feature that you want to retrieve information for.</p>', 'LaunchGroupConfig$feature' => '<p>The feature that this launch is using.</p>', 'TreatmentConfig$feature' => '<p>The feature that this experiment is testing.</p>', 'UpdateFeatureRequest$feature' => '<p>The name of the feature to be updated.</p>', ], ], 'FeatureStatus' => [ 'base' => NULL, 'refs' => [ 'Feature$status' => '<p>The current state of the feature.</p>', 'FeatureSummary$status' => '<p>The current state of the feature.</p>', ], ], 'FeatureSummariesList' => [ 'base' => NULL, 'refs' => [ 'ListFeaturesResponse$features' => '<p>An array of structures that contain the configuration details of the features in the specified project.</p>', ], ], 'FeatureSummary' => [ 'base' => '<p>This structure contains information about one Evidently feature in your account.</p>', 'refs' => [ 'FeatureSummariesList$member' => NULL, ], ], 'FeatureToVariationMap' => [ 'base' => NULL, 'refs' => [ 'LaunchGroup$featureVariations' => '<p>The feature variation for this launch group. This is a key-value pair.</p>', 'Treatment$featureVariations' => '<p>The feature variation used for this treatment. This is a key-value pair. The key is the feature name, and the value is the variation name.</p>', ], ], 'GetExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetExperimentResultsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetExperimentResultsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFeatureRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFeatureResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'GroupName' => [ 'base' => NULL, 'refs' => [ 'GroupToWeightMap$key' => NULL, 'LaunchGroup$name' => '<p>The name of the launch group.</p>', 'LaunchGroupConfig$name' => '<p>A name for this launch group.</p>', ], ], 'GroupToWeightMap' => [ 'base' => NULL, 'refs' => [ 'ScheduledSplit$groupWeights' => '<p>The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step.</p>', 'ScheduledSplitConfig$groupWeights' => '<p>The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'PutProjectEventsResponse$failedEventCount' => '<p>The number of events in the operation that could not be used by Evidently.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Unexpected error while processing the request. Retry the request.</p>', 'refs' => [], ], 'JsonPath' => [ 'base' => NULL, 'refs' => [ 'MetricDefinition$entityIdKey' => '<p>The entity, such as a user or session, that does an action that causes a metric value to be recorded.</p>', 'MetricDefinition$valueKey' => '<p>The value that is tracked to produce the metric.</p>', 'MetricDefinitionConfig$entityIdKey' => '<p>The entity, such as a user or session, that does an action that causes a metric value to be recorded. An example is <code>userDetails.userID</code>.</p>', 'MetricDefinitionConfig$valueKey' => '<p>The value that is tracked to produce the metric.</p>', ], ], 'JsonValue' => [ 'base' => NULL, 'refs' => [ 'EvaluateFeatureRequest$evaluationContext' => '<p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>', 'EvaluateFeatureResponse$details' => '<p>If this user was assigned to a launch or experiment, this field lists the launch or experiment name.</p>', 'EvaluationRequest$evaluationContext' => '<p>A JSON block of attributes that you can optionally pass in. This JSON block is included in the evaluation events sent to Evidently from the user session. </p>', 'EvaluationResult$details' => '<p>If this user was assigned to a launch or experiment, this field lists the launch or experiment name.</p>', 'Event$data' => '<p>The event data.</p>', 'ExperimentReport$content' => '<p>The content of the report.</p>', 'MetricDefinition$eventPattern' => '<p>The EventBridge event pattern that defines how the metric is recorded.</p> <p>For more information about EventBridge event patterns, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event patterns</a>.</p>', ], ], 'Launch' => [ 'base' => '<p>This structure contains the configuration details of one Evidently launch.</p>', 'refs' => [ 'CreateLaunchResponse$launch' => '<p>A structure that contains the configuration of the launch that was created.</p>', 'GetLaunchResponse$launch' => '<p>A structure containing the configuration details of the launch.</p>', 'LaunchesList$member' => NULL, 'StartLaunchResponse$launch' => '<p>A structure that contains information about the launch that was started.</p>', 'UpdateLaunchResponse$launch' => '<p>A structure that contains the new configuration of the launch that was updated.</p>', ], ], 'LaunchArn' => [ 'base' => NULL, 'refs' => [ 'Launch$arn' => '<p>The ARN of the launch.</p>', ], ], 'LaunchExecution' => [ 'base' => '<p>This structure contains information about the start and end times of the launch.</p>', 'refs' => [ 'Launch$execution' => '<p>A structure that contains information about the start and end times of the launch.</p>', ], ], 'LaunchGroup' => [ 'base' => '<p>A structure that defines one launch group in a launch. A launch group is a variation of the feature that you are including in the launch.</p>', 'refs' => [ 'LaunchGroupList$member' => NULL, ], ], 'LaunchGroupConfig' => [ 'base' => '<p>A structure that defines one launch group in a launch. A launch group is a variation of the feature that you are including in the launch.</p>', 'refs' => [ 'LaunchGroupConfigList$member' => NULL, ], ], 'LaunchGroupConfigList' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchRequest$groups' => '<p>An array of structures that contains the feature and variations that are to be used for the launch.</p>', 'UpdateLaunchRequest$groups' => '<p>An array of structures that contains the feature and variations that are to be used for the launch.</p>', ], ], 'LaunchGroupList' => [ 'base' => NULL, 'refs' => [ 'Launch$groups' => '<p>An array of structures that define the feature variations that are being used in the launch.</p>', ], ], 'LaunchName' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchRequest$name' => '<p>The name for the new launch.</p>', 'DeleteLaunchRequest$launch' => '<p>The name of the launch to delete.</p>', 'GetLaunchRequest$launch' => '<p>The name of the launch that you want to see the details of.</p>', 'Launch$name' => '<p>The name of the launch.</p>', 'StartLaunchRequest$launch' => '<p>The name of the launch to start.</p>', 'StopLaunchRequest$launch' => '<p>The name of the launch to stop.</p>', 'UpdateLaunchRequest$launch' => '<p>The name of the launch that is to be updated.</p>', ], ], 'LaunchStatus' => [ 'base' => NULL, 'refs' => [ 'Launch$status' => '<p>The current state of the launch.</p>', ], ], 'LaunchStopDesiredState' => [ 'base' => NULL, 'refs' => [ 'StopLaunchRequest$desiredState' => '<p>Specify whether to consider the launch as <code>COMPLETED</code> or <code>CANCELLED</code> after it stops.</p>', ], ], 'LaunchType' => [ 'base' => NULL, 'refs' => [ 'Launch$type' => '<p>The type of launch.</p>', ], ], 'LaunchesList' => [ 'base' => NULL, 'refs' => [ 'ListLaunchesResponse$launches' => '<p>An array of structures that contain the configuration details of the launches in the specified project.</p>', ], ], 'ListExperimentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFeaturesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFeaturesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLaunchesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLaunchesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'Project$activeExperimentCount' => '<p>The number of ongoing experiments currently in the project.</p>', 'Project$activeLaunchCount' => '<p>The number of ongoing launches currently in the project.</p>', 'Project$experimentCount' => '<p>The number of experiments currently in the project. This includes all experiments that have been created and not deleted, whether they are ongoing or not.</p>', 'Project$featureCount' => '<p>The number of features currently in the project.</p>', 'Project$launchCount' => '<p>The number of launches currently in the project. This includes all launches that have been created and not deleted, whether they are ongoing or not.</p>', 'ProjectSummary$activeExperimentCount' => '<p>The number of experiments currently in the project.</p>', 'ProjectSummary$activeLaunchCount' => '<p>The number of ongoing launches currently in the project.</p>', 'ProjectSummary$experimentCount' => '<p>The number of experiments currently in the project.</p>', 'ProjectSummary$featureCount' => '<p>The number of features currently in the project.</p>', 'ProjectSummary$launchCount' => '<p>The number of launches currently in the project, including launches that are ongoing, completed, and not started yet.</p>', ], ], 'MaxExperiments' => [ 'base' => NULL, 'refs' => [ 'ListExperimentsRequest$maxResults' => '<p>The maximum number of results to include in the response.</p>', ], ], 'MaxFeatures' => [ 'base' => NULL, 'refs' => [ 'ListFeaturesRequest$maxResults' => '<p>The maximum number of results to include in the response.</p>', ], ], 'MaxLaunches' => [ 'base' => NULL, 'refs' => [ 'ListLaunchesRequest$maxResults' => '<p>The maximum number of results to include in the response.</p>', ], ], 'MaxProjects' => [ 'base' => NULL, 'refs' => [ 'ListProjectsRequest$maxResults' => '<p>The maximum number of results to include in the response.</p>', ], ], 'MetricDefinition' => [ 'base' => '<p>This structure defines a metric that is being used to evaluate the variations during a launch or experiment.</p>', 'refs' => [ 'MetricGoal$metricDefinition' => '<p>A structure that contains details about the metric.</p>', 'MetricMonitor$metricDefinition' => '<p>A structure that defines the metric.</p>', ], ], 'MetricDefinitionConfig' => [ 'base' => '<p>This structure defines a metric that you want to use to evaluate the variations during a launch or experiment.</p>', 'refs' => [ 'MetricGoalConfig$metricDefinition' => '<p>A structure that contains details about the metric.</p>', 'MetricMonitorConfig$metricDefinition' => '<p>A structure that defines the metric.</p>', ], ], 'MetricDefinitionConfigEventPatternString' => [ 'base' => NULL, 'refs' => [ 'MetricDefinitionConfig$eventPattern' => '<p>The EventBridge event pattern that defines how the metric is recorded.</p> <p>For more information about EventBridge event patterns, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event patterns</a>.</p>', ], ], 'MetricGoal' => [ 'base' => '<p>A structure that tells Evidently whether higher or lower values are desired for a metric that is used in an experiment.</p>', 'refs' => [ 'MetricGoalsList$member' => NULL, ], ], 'MetricGoalConfig' => [ 'base' => '<p>Use this structure to tell Evidently whether higher or lower values are desired for a metric that is used in an experiment.</p>', 'refs' => [ 'MetricGoalConfigList$member' => NULL, ], ], 'MetricGoalConfigList' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentRequest$metricGoals' => '<p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>', 'UpdateExperimentRequest$metricGoals' => '<p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>', ], ], 'MetricGoalsList' => [ 'base' => NULL, 'refs' => [ 'Experiment$metricGoals' => '<p>An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal.</p>', ], ], 'MetricMonitor' => [ 'base' => '<p>A structure that defines a metric to be used to monitor performance of the variations during a launch.</p>', 'refs' => [ 'MetricMonitorList$member' => NULL, ], ], 'MetricMonitorConfig' => [ 'base' => '<p>A structure that defines a metric to be used to monitor performance of the variations during a launch.</p>', 'refs' => [ 'MetricMonitorConfigList$member' => NULL, ], ], 'MetricMonitorConfigList' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchRequest$metricMonitors' => '<p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>', 'UpdateLaunchRequest$metricMonitors' => '<p>An array of structures that define the metrics that will be used to monitor the launch performance.</p>', ], ], 'MetricMonitorList' => [ 'base' => NULL, 'refs' => [ 'Launch$metricMonitors' => '<p>An array of structures that define the metrics that are being used to monitor the launch performance.</p>', ], ], 'MetricNameList' => [ 'base' => NULL, 'refs' => [ 'GetExperimentResultsRequest$metricNames' => '<p>The names of the experiment metrics that you want to see the results of.</p>', ], ], 'MetricUnitLabel' => [ 'base' => NULL, 'refs' => [ 'MetricDefinition$unitLabel' => '<p>The label for the units that the metric is measuring.</p>', 'MetricDefinitionConfig$unitLabel' => '<p>A label for the units that the metric is measuring.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListExperimentsRequest$nextToken' => '<p>The token to use when requesting the next set of results. You received this token from a previous <code>ListExperiments</code> operation.</p>', 'ListExperimentsResponse$nextToken' => '<p>The token to use in a subsequent <code>ListExperiments</code> operation to return the next set of results.</p>', 'ListFeaturesRequest$nextToken' => '<p>The token to use when requesting the next set of results. You received this token from a previous <code>ListFeatures</code> operation.</p>', 'ListFeaturesResponse$nextToken' => '<p>The token to use in a subsequent <code>ListFeatures</code> operation to return the next set of results.</p>', 'ListLaunchesRequest$nextToken' => '<p>The token to use when requesting the next set of results. You received this token from a previous <code>ListLaunches</code> operation.</p>', 'ListLaunchesResponse$nextToken' => '<p>The token to use in a subsequent <code>ListLaunches</code> operation to return the next set of results.</p>', 'ListProjectsRequest$nextToken' => '<p>The token to use when requesting the next set of results. You received this token from a previous <code>ListProjects</code> operation.</p>', 'ListProjectsResponse$nextToken' => '<p>The token to use in a subsequent <code>ListProjects</code> operation to return the next set of results.</p>', ], ], 'OnlineAbConfig' => [ 'base' => '<p>A structure that contains the configuration of which variation to use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>', 'refs' => [ 'CreateExperimentRequest$onlineAbConfig' => '<p>A structure that contains the configuration of which variation to use as the "control" version. tThe "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>', 'UpdateExperimentRequest$onlineAbConfig' => '<p>A structure that contains the configuration of which variation o use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>', ], ], 'OnlineAbDefinition' => [ 'base' => '<p>A structure that contains the configuration of which variation to use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>', 'refs' => [ 'Experiment$onlineAbDefinition' => '<p>A structure that contains the configuration of which variation to use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.</p>', ], ], 'Project' => [ 'base' => '<p>This structure defines a project, which is the logical object in Evidently that can contain features, launches, and experiments. Use projects to group similar features together.</p>', 'refs' => [ 'CreateProjectResponse$project' => '<p>A structure that contains information about the created project.</p>', 'GetProjectResponse$project' => '<p>A structure containing the configuration details of the project.</p>', 'UpdateProjectDataDeliveryResponse$project' => '<p>A structure containing details about the project that you updated.</p>', 'UpdateProjectResponse$project' => '<p>A structure containing information about the updated project.</p>', ], ], 'ProjectArn' => [ 'base' => NULL, 'refs' => [ 'Experiment$project' => '<p>The name or ARN of the project that contains this experiment.</p>', 'Feature$project' => '<p>The name or ARN of the project that contains the feature.</p>', 'Project$arn' => '<p>The name or ARN of the project.</p>', 'ProjectSummary$arn' => '<p>The name or ARN of the project.</p>', ], ], 'ProjectDataDelivery' => [ 'base' => '<p>A structure that contains information about where Evidently is to store evaluation events for longer term storage.</p>', 'refs' => [ 'Project$dataDelivery' => '<p>A structure that contains information about where Evidently is to store evaluation events for longer term storage.</p>', ], ], 'ProjectDataDeliveryConfig' => [ 'base' => '<p>A structure that contains information about where Evidently is to store evaluation events for longer term storage.</p>', 'refs' => [ 'CreateProjectRequest$dataDelivery' => '<p>A structure that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.</p>', ], ], 'ProjectName' => [ 'base' => NULL, 'refs' => [ 'CreateProjectRequest$name' => '<p>The name for the project.</p>', 'Project$name' => '<p>The name of the project.</p>', 'ProjectSummary$name' => '<p>The name of the project.</p>', ], ], 'ProjectRef' => [ 'base' => NULL, 'refs' => [ 'BatchEvaluateFeatureRequest$project' => '<p>The name or ARN of the project that contains the feature being evaluated.</p>', 'CreateExperimentRequest$project' => '<p>The name or ARN of the project that you want to create the new experiment in.</p>', 'CreateFeatureRequest$project' => '<p>The name or ARN of the project that is to contain the new feature.</p>', 'CreateLaunchRequest$project' => '<p>The name or ARN of the project that you want to create the launch in.</p>', 'DeleteExperimentRequest$project' => '<p>The name or ARN of the project that contains the experiment to delete.</p>', 'DeleteFeatureRequest$project' => '<p>The name or ARN of the project that contains the feature to delete.</p>', 'DeleteLaunchRequest$project' => '<p>The name or ARN of the project that contains the launch to delete.</p>', 'DeleteProjectRequest$project' => '<p>The name or ARN of the project to delete.</p>', 'EvaluateFeatureRequest$project' => '<p>The name or ARN of the project that contains this feature.</p>', 'FeatureSummary$project' => '<p>The name or ARN of the project that contains the feature.</p>', 'GetExperimentRequest$project' => '<p>The name or ARN of the project that contains the experiment.</p>', 'GetExperimentResultsRequest$project' => '<p>The name or ARN of the project that contains the experiment that you want to see the results of.</p>', 'GetFeatureRequest$project' => '<p>The name or ARN of the project that contains the feature.</p>', 'GetLaunchRequest$project' => '<p>The name or ARN of the project that contains the launch.</p>', 'GetProjectRequest$project' => '<p>The name or ARN of the project that you want to see the details of.</p>', 'Launch$project' => '<p>The name or ARN of the project that contains the launch.</p>', 'ListExperimentsRequest$project' => '<p>The name or ARN of the project to return the experiment list from.</p>', 'ListFeaturesRequest$project' => '<p>The name or ARN of the project to return the feature list from.</p>', 'ListLaunchesRequest$project' => '<p>The name or ARN of the project to return the launch list from.</p>', 'PutProjectEventsRequest$project' => '<p>The name or ARN of the project to write the events to.</p>', 'StartExperimentRequest$project' => '<p>The name or ARN of the project that contains the experiment to start.</p>', 'StartLaunchRequest$project' => '<p>The name or ARN of the project that contains the launch to start.</p>', 'StopExperimentRequest$project' => '<p>The name or ARN of the project that contains the experiment to stop.</p>', 'StopLaunchRequest$project' => '<p>The name or ARN of the project that contains the launch that you want to stop.</p>', 'UpdateExperimentRequest$project' => '<p>The name or ARN of the project that contains the experiment that you want to update.</p>', 'UpdateFeatureRequest$project' => '<p>The name or ARN of the project that contains the feature to be updated.</p>', 'UpdateLaunchRequest$project' => '<p>The name or ARN of the project that contains the launch that you want to update.</p>', 'UpdateProjectDataDeliveryRequest$project' => '<p>The name or ARN of the project that you want to modify the data storage options for.</p>', 'UpdateProjectRequest$project' => '<p>The name or ARN of the project to update.</p>', ], ], 'ProjectStatus' => [ 'base' => NULL, 'refs' => [ 'Project$status' => '<p>The current state of the project.</p>', 'ProjectSummary$status' => '<p>The current state of the project.</p>', ], ], 'ProjectSummariesList' => [ 'base' => NULL, 'refs' => [ 'ListProjectsResponse$projects' => '<p>An array of structures that contain the configuration details of the projects in the Region.</p>', ], ], 'ProjectSummary' => [ 'base' => '<p>A structure that contains configuration information about an Evidently project.</p>', 'refs' => [ 'ProjectSummariesList$member' => NULL, ], ], 'PutProjectEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutProjectEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutProjectEventsResultEntry' => [ 'base' => '<p>A structure that contains Evidently\'s response to the sent events, including an event ID and error codes, if any. </p>', 'refs' => [ 'PutProjectEventsResultEntryList$member' => NULL, ], ], 'PutProjectEventsResultEntryList' => [ 'base' => NULL, 'refs' => [ 'PutProjectEventsResponse$eventResults' => '<p>A structure that contains Evidently\'s response to the sent events, including an event ID and error codes, if any.</p>', ], ], 'RandomizationSalt' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentRequest$randomizationSalt' => '<p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>', 'CreateLaunchRequest$randomizationSalt' => '<p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationsSalt</code>.</p>', 'Experiment$randomizationSalt' => '<p>This value is used when Evidently assigns a particular user session to the experiment. It helps create a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>.</p>', 'Launch$randomizationSalt' => '<p>This value is used when Evidently assigns a particular user session to the launch, to help create a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>.</p>', 'UpdateExperimentRequest$randomizationSalt' => '<p>When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the experiment name as the <code>randomizationSalt</code>.</p>', 'UpdateLaunchRequest$randomizationSalt' => '<p>When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and <code>randomizationSalt</code>. If you omit <code>randomizationSalt</code>, Evidently uses the launch name as the <code>randomizationSalt</code>.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request references a resource that does not exist.</p>', 'refs' => [], ], 'ResultsPeriod' => [ 'base' => NULL, 'refs' => [ 'GetExperimentResultsRequest$period' => '<p>In seconds, the amount of time to aggregate results together. </p>', ], ], 'RuleName' => [ 'base' => NULL, 'refs' => [ 'EvaluationRule$name' => '<p>The name of the experiment or launch.</p>', ], ], 'RuleType' => [ 'base' => NULL, 'refs' => [ 'EvaluationRule$type' => '<p>This value is <code>aws.evidently.splits</code> if this is an evaluation rule for a launch, and it is <code>aws.evidently.onlineab</code> if this is an evaluation rule for an experiment.</p>', ], ], 'S3BucketSafeName' => [ 'base' => NULL, 'refs' => [ 'S3Destination$bucket' => '<p>The name of the bucket in which Evidently stores evaluation events.</p>', 'S3DestinationConfig$bucket' => '<p>The name of the bucket in which Evidently stores evaluation events.</p>', ], ], 'S3Destination' => [ 'base' => '<p>If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.</p>', 'refs' => [ 'ProjectDataDelivery$s3Destination' => '<p>If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.</p>', ], ], 'S3DestinationConfig' => [ 'base' => '<p>If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.</p>', 'refs' => [ 'ProjectDataDeliveryConfig$s3Destination' => '<p>If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.</p>', 'UpdateProjectDataDeliveryRequest$s3Destination' => '<p>A structure containing the S3 bucket name and bucket prefix where you want to store evaluation events.</p>', ], ], 'S3PrefixSafeName' => [ 'base' => NULL, 'refs' => [ 'S3Destination$prefix' => '<p>The bucket prefix in which Evidently stores evaluation events.</p>', 'S3DestinationConfig$prefix' => '<p>The bucket prefix in which Evidently stores evaluation events.</p>', ], ], 'ScheduledSplit' => [ 'base' => '<p>This structure defines the traffic allocation percentages among the feature variations during one step of a launch, and the start time of that step.</p>', 'refs' => [ 'ScheduledStepList$member' => NULL, ], ], 'ScheduledSplitConfig' => [ 'base' => '<p>This structure defines the traffic allocation percentages among the feature variations during one step of a launch, and the start time of that step.</p>', 'refs' => [ 'ScheduledSplitConfigList$member' => NULL, ], ], 'ScheduledSplitConfigList' => [ 'base' => NULL, 'refs' => [ 'ScheduledSplitsLaunchConfig$steps' => '<p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step.</p>', ], ], 'ScheduledSplitsLaunchConfig' => [ 'base' => '<p>An array of structures that define the traffic allocation percentages among the feature variations during each step of a launch. This also defines the start time of each step.</p>', 'refs' => [ 'CreateLaunchRequest$scheduledSplitsConfig' => '<p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>', 'UpdateLaunchRequest$scheduledSplitsConfig' => '<p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>', ], ], 'ScheduledSplitsLaunchDefinition' => [ 'base' => '<p>An array of structures that define the traffic allocation percentages among the feature variations during each step of a launch. This also defines the start time of each step.</p>', 'refs' => [ 'Launch$scheduledSplitsDefinition' => '<p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.</p>', ], ], 'ScheduledStepList' => [ 'base' => NULL, 'refs' => [ 'ScheduledSplitsLaunchDefinition$steps' => '<p>An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request would cause a service quota to be exceeded.</p>', 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service was unavailable. Retry the request.</p>', 'refs' => [], ], 'SplitWeight' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentRequest$samplingRate' => '<p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p> <p>This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.</p>', 'Experiment$samplingRate' => '<p>In thousandths of a percent, the amount of the available audience that is allocated to this experiment. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p> <p>This is represented in thousandths of a percent, so a value of 10,000 is 10% of the available audience.</p>', 'GroupToWeightMap$value' => NULL, 'TreatmentToWeightMap$value' => NULL, 'UpdateExperimentRequest$samplingRate' => '<p>The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.</p> <p>This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the available audience.</p>', ], ], 'StartExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartLaunchRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartLaunchResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopLaunchRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopLaunchResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The ID of the resource that caused the exception.</p>', 'ConflictException$resourceType' => '<p>The type of the resource that is associated with the error.</p>', 'EvaluateFeatureResponse$reason' => '<p>Specifies the reason that the user session was assigned this variation. Possible values include <code>DEFAULT</code>, meaning the user was served the default variation; <code>LAUNCH_RULE_MATCH</code>, if the user session was enrolled in a launch; <code>EXPERIMENT_RULE_MATCH</code>, if the user session was enrolled in an experiment; or <code>ENTITY_OVERRIDES_MATCH</code>, if the user\'s <code>entityId</code> matches an override rule.</p>', 'EvaluateFeatureResponse$variation' => '<p>The name of the variation that was served to the user session.</p>', 'EvaluationResult$reason' => '<p>Specifies the reason that the user session was assigned this variation. Possible values include <code>DEFAULT</code>, meaning the user was served the default variation; <code>LAUNCH_RULE_MATCH</code>, if the user session was enrolled in a launch; or <code>EXPERIMENT_RULE_MATCH</code>, if the user session was enrolled in an experiment.</p>', 'EvaluationResult$variation' => '<p>The name of the variation that was served to the user session.</p>', 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The ID of the resource that caused the exception.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of the resource that is associated with the error.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$quotaCode' => '<p>The ID of the service quota that was exceeded.</p>', 'ServiceQuotaExceededException$resourceId' => '<p>The ID of the resource that caused the exception.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The type of the resource that is associated with the error.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>The ID of the service that is associated with the error.</p>', 'ServiceUnavailableException$message' => NULL, 'ThrottlingException$message' => NULL, 'ThrottlingException$quotaCode' => '<p>The ID of the service quota that was exceeded.</p>', 'ThrottlingException$serviceCode' => '<p>The ID of the service that is associated with the error.</p>', 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>The error message.</p>', 'ValidationExceptionField$name' => '<p>The error name.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The list of tag keys to remove from the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentRequest$tags' => '<p>Assigns one or more tags (key-value pairs) to the experiment.</p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p> <p>Tags don\'t have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p> <pre><code> &lt;p&gt;You can associate as many as 50 tags with an experiment.&lt;/p&gt; &lt;p&gt;For more information, see &lt;a href=&quot;https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html&quot;&gt;Tagging Amazon Web Services resources&lt;/a&gt;.&lt;/p&gt; </code></pre>', 'CreateFeatureRequest$tags' => '<p>Assigns one or more tags (key-value pairs) to the feature.</p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p> <p>Tags don\'t have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p> <pre><code> &lt;p&gt;You can associate as many as 50 tags with a feature.&lt;/p&gt; &lt;p&gt;For more information, see &lt;a href=&quot;https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html&quot;&gt;Tagging Amazon Web Services resources&lt;/a&gt;.&lt;/p&gt; </code></pre>', 'CreateLaunchRequest$tags' => '<p>Assigns one or more tags (key-value pairs) to the launch.</p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p> <p>Tags don\'t have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p> <pre><code> &lt;p&gt;You can associate as many as 50 tags with a launch.&lt;/p&gt; &lt;p&gt;For more information, see &lt;a href=&quot;https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html&quot;&gt;Tagging Amazon Web Services resources&lt;/a&gt;.&lt;/p&gt; </code></pre>', 'CreateProjectRequest$tags' => '<p>Assigns one or more tags (key-value pairs) to the project.</p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p> <p>Tags don\'t have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p> <pre><code> &lt;p&gt;You can associate as many as 50 tags with a project.&lt;/p&gt; &lt;p&gt;For more information, see &lt;a href=&quot;https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html&quot;&gt;Tagging Amazon Web Services resources&lt;/a&gt;.&lt;/p&gt; </code></pre>', 'Experiment$tags' => '<p>The list of tag keys and values associated with this experiment.</p>', 'Feature$tags' => '<p>The list of tag keys and values associated with this feature.</p>', 'FeatureSummary$tags' => '<p>The list of tag keys and values associated with this feature.</p>', 'Launch$tags' => '<p>The list of tag keys and values associated with this launch.</p>', 'ListTagsForResourceResponse$tags' => '<p>The list of tag keys and values associated with the resource you specified.</p>', 'Project$tags' => '<p>The list of tag keys and values associated with this project.</p>', 'ProjectSummary$tags' => '<p>The list of tag keys and values associated with this project.</p>', 'TagResourceRequest$tags' => '<p>The list of key-value pairs to associate with the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied because of request throttling. Retry the request.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Event$timestamp' => '<p>The timestamp of the event.</p>', 'Experiment$createdTime' => '<p>The date and time that the experiment is first created.</p>', 'Experiment$lastUpdatedTime' => '<p>The date and time that the experiment was most recently updated.</p>', 'ExperimentExecution$endedTime' => '<p>The date and time that the experiment ended.</p>', 'ExperimentExecution$startedTime' => '<p>The date and time that the experiment started.</p>', 'ExperimentSchedule$analysisCompleteTime' => '<p>The time and date that Evidently completed the analysis of the experiment.</p>', 'Feature$createdTime' => '<p>The date and time that the feature is created.</p>', 'Feature$lastUpdatedTime' => '<p>The date and time that the feature was most recently updated.</p>', 'FeatureSummary$createdTime' => '<p>The date and time that the feature is created.</p>', 'FeatureSummary$lastUpdatedTime' => '<p>The date and time that the feature was most recently updated.</p>', 'GetExperimentResultsRequest$endTime' => '<p>The date and time that the experiment ended, if it is completed.</p>', 'GetExperimentResultsRequest$startTime' => '<p>The date and time that the experiment started.</p>', 'Launch$createdTime' => '<p>The date and time that the launch is created.</p>', 'Launch$lastUpdatedTime' => '<p>The date and time that the launch was most recently updated.</p>', 'LaunchExecution$endedTime' => '<p>The date and time that the launch ended.</p>', 'LaunchExecution$startedTime' => '<p>The date and time that the launch started.</p>', 'Project$createdTime' => '<p>The date and time that the project is created.</p>', 'Project$lastUpdatedTime' => '<p>The date and time that the project was most recently updated.</p>', 'ProjectSummary$createdTime' => '<p>The date and time that the project is created.</p>', 'ProjectSummary$lastUpdatedTime' => '<p>The date and time that the project was most recently updated.</p>', 'ScheduledSplit$startTime' => '<p>The date and time that this step of the launch starts.</p>', 'ScheduledSplitConfig$startTime' => '<p>The date and time that this step of the launch starts.</p>', 'StartExperimentRequest$analysisCompleteTime' => '<p>The date and time to end the experiment.</p>', 'StartExperimentResponse$startedTime' => '<p>A timestamp that indicates when the experiment started.</p>', 'StopExperimentResponse$endedTime' => '<p>The date and time that the experiment stopped.</p>', 'StopLaunchResponse$endedTime' => '<p>The date and time that the launch stopped.</p>', 'TimestampList$member' => NULL, ], ], 'TimestampList' => [ 'base' => NULL, 'refs' => [ 'GetExperimentResultsResponse$timestamps' => '<p>The timestamps of each result returned.</p>', ], ], 'Treatment' => [ 'base' => '<p>A structure that defines one treatment in an experiment. A treatment is a variation of the feature that you are including in the experiment.</p>', 'refs' => [ 'TreatmentList$member' => NULL, ], ], 'TreatmentConfig' => [ 'base' => '<p>A structure that defines one treatment in an experiment. A treatment is a variation of the feature that you are including in the experiment.</p>', 'refs' => [ 'TreatmentConfigList$member' => NULL, ], ], 'TreatmentConfigList' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentRequest$treatments' => '<p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>', 'UpdateExperimentRequest$treatments' => '<p>An array of structures that define the variations being tested in the experiment.</p>', ], ], 'TreatmentList' => [ 'base' => NULL, 'refs' => [ 'Experiment$treatments' => '<p>An array of structures that describe the configuration of each feature variation used in the experiment.</p>', ], ], 'TreatmentName' => [ 'base' => NULL, 'refs' => [ 'ExperimentReport$treatmentName' => '<p>The name of the variation that this report pertains to.</p>', 'ExperimentResultsData$treatmentName' => '<p>The treatment, or variation, that returned the <code>values</code> in this structure.</p>', 'OnlineAbConfig$controlTreatmentName' => '<p>The name of the variation that is to be the default variation that the other variations are compared to.</p>', 'OnlineAbDefinition$controlTreatmentName' => '<p>The name of the variation that is the default variation that the other variations are compared to.</p>', 'Treatment$name' => '<p>The name of this treatment.</p>', 'TreatmentConfig$name' => '<p>A name for this treatment.</p>', 'TreatmentNameList$member' => NULL, 'TreatmentToWeightMap$key' => NULL, ], ], 'TreatmentNameList' => [ 'base' => NULL, 'refs' => [ 'GetExperimentResultsRequest$treatmentNames' => '<p>The names of the experiment treatments that you want to see the results for.</p>', ], ], 'TreatmentToWeightMap' => [ 'base' => NULL, 'refs' => [ 'OnlineAbConfig$treatmentWeights' => '<p>A set of key-value pairs. The keys are variation names, and the values are the portion of experiment traffic to be assigned to that variation. Specify the traffic portion in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.</p>', 'OnlineAbDefinition$treatmentWeights' => '<p>A set of key-value pairs. The keys are variation names, and the values are the portion of experiment traffic to be assigned to that variation. The traffic portion is specified in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFeatureRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFeatureResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLaunchRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLaunchResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProjectDataDeliveryRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProjectDataDeliveryResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'Uuid' => [ 'base' => NULL, 'refs' => [ 'PutProjectEventsResultEntry$eventId' => '<p>A unique ID assigned to this <code>PutProjectEvents</code> operation. </p>', ], ], 'ValidationException' => [ 'base' => '<p>The value of a parameter in the request caused an error.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>A structure containing an error name and message.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>The parameter that caused the exception.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>A reason for the error.</p>', ], ], 'VariableValue' => [ 'base' => '<p>The value assigned to a feature variation. This structure must contain exactly one field. It can be <code>boolValue</code>, <code>doubleValue</code>, <code>longValue</code>, or <code>stringValue</code>.</p>', 'refs' => [ 'EvaluateFeatureResponse$value' => '<p>The value assigned to this variation to differentiate it from the other variations of this feature.</p>', 'EvaluationResult$value' => '<p>The value assigned to this variation to differentiate it from the other variations of this feature.</p>', 'Variation$value' => '<p>The value assigned to this variation.</p>', 'VariationConfig$value' => '<p>The value assigned to this variation.</p>', ], ], 'VariableValueLongValueLong' => [ 'base' => NULL, 'refs' => [ 'VariableValue$longValue' => '<p>If this feature uses the long variation type, this field contains the long value of this variation.</p>', ], ], 'VariableValueStringValueString' => [ 'base' => NULL, 'refs' => [ 'VariableValue$stringValue' => '<p>If this feature uses the string variation type, this field contains the string value of this variation.</p>', ], ], 'Variation' => [ 'base' => '<p>This structure contains the name and variation value of one variation of a feature.</p>', 'refs' => [ 'VariationsList$member' => NULL, ], ], 'VariationConfig' => [ 'base' => '<p>This structure contains the name and variation value of one variation of a feature.</p>', 'refs' => [ 'VariationConfigsList$member' => NULL, ], ], 'VariationConfigsList' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureRequest$variations' => '<p>An array of structures that contain the configuration of the feature\'s different variations.</p>', 'UpdateFeatureRequest$addOrUpdateVariations' => '<p>To update variation configurations for this feature, or add new ones, specify this structure. In this array, include any variations that you want to add or update. If the array includes a variation name that already exists for this feature, it is updated. If it includes a new variation name, it is added as a new variation.</p>', ], ], 'VariationName' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureRequest$defaultVariation' => '<p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p> <p>This variation must also be listed in the <code>variations</code> structure.</p> <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>', 'EntityOverrideMap$value' => NULL, 'Feature$defaultVariation' => '<p>The name of the variation that is used as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p> <p>This variation must also be listed in the <code>variations</code> structure.</p> <p>If you omit <code>defaultVariation</code>, the first variation listed in the <code>variations</code> structure is used as the default variation.</p>', 'FeatureSummary$defaultVariation' => '<p>The name of the variation that is used as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>', 'FeatureToVariationMap$value' => NULL, 'LaunchGroupConfig$variation' => '<p>The feature variation to use for this launch group.</p>', 'TreatmentConfig$variation' => '<p>The name of the variation to use as this treatment in the experiment.</p>', 'UpdateFeatureRequest$defaultVariation' => '<p>The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.</p>', 'Variation$name' => '<p>The name of the variation.</p>', 'VariationConfig$name' => '<p>The name of the variation.</p>', 'VariationNameList$member' => NULL, ], ], 'VariationNameList' => [ 'base' => NULL, 'refs' => [ 'UpdateFeatureRequest$removeVariations' => '<p>Removes a variation from the feature. If the variation you specify doesn\'t exist, then this makes no change and does not report an error.</p> <p>This operation fails if you try to remove a variation that is part of an ongoing launch or experiment.</p>', ], ], 'VariationValueType' => [ 'base' => NULL, 'refs' => [ 'Feature$valueType' => '<p>Defines the type of value used to define the different feature variations. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-variationtypes.html">Variation types</a> </p>', ], ], 'VariationsList' => [ 'base' => NULL, 'refs' => [ 'Feature$variations' => '<p>An array of structures that contain the configuration of the feature\'s different variations.</p>', ], ], ],];
