<?php
// This file was auto-generated from sdk-root/src/data/finspace/2021-03-12/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The FinSpace management service provides the APIs for managing FinSpace environments.</p>', 'operations' => [ 'CreateEnvironment' => '<p>Create a new FinSpace environment.</p>', 'DeleteEnvironment' => '<p>Delete an FinSpace environment.</p>', 'GetEnvironment' => '<p>Returns the FinSpace environment object.</p>', 'ListEnvironments' => '<p>A list of all of your FinSpace environments.</p>', 'ListTagsForResource' => '<p>A list of all tags for a resource.</p>', 'TagResource' => '<p>Adds metadata tags to a FinSpace resource.</p>', 'UntagResource' => '<p>Removes metadata tags from a FinSpace resource.</p>', 'UpdateEnvironment' => '<p>Update your FinSpace environment.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AttributeMap' => [ 'base' => NULL, 'refs' => [ 'FederationParameters$attributeMap' => '<p>SAML attribute name and value. The name must always be <code>Email</code> and the value should be set to the attribute definition in which user email is set. For example, name would be <code>Email</code> and value <code>http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress</code>. Please check your SAML 2.0 compliant identity provider (IdP) documentation for details.</p>', ], ], 'CreateEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataBundleArn' => [ 'base' => '<p>The Amazon Resource Name (ARN) of the data bundle.</p>', 'refs' => [ 'DataBundleArns$member' => NULL, ], ], 'DataBundleArns' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$dataBundles' => '<p>The list of Amazon Resource Names (ARN) of the data bundles to install. Currently supported data bundle ARNs:</p> <ul> <li> <p> <code>arn:aws:finspace:${Region}::data-bundle/capital-markets-sample</code> - Contains sample Capital Markets datasets, categories and controlled vocabularies.</p> </li> <li> <p> <code>arn:aws:finspace:${Region}::data-bundle/taq</code> (default) - Contains trades and quotes data in addition to sample Capital Markets data.</p> </li> </ul>', ], ], 'DeleteEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$description' => '<p>The description of the FinSpace environment to be created.</p>', 'Environment$description' => '<p>The description of the FinSpace environment.</p>', 'UpdateEnvironmentRequest$description' => '<p>The description of the environment.</p>', ], ], 'EmailId' => [ 'base' => NULL, 'refs' => [ 'SuperuserParameters$emailAddress' => '<p>The email address of the superuser.</p>', ], ], 'Environment' => [ 'base' => '<p>Represents an FinSpace environment.</p>', 'refs' => [ 'EnvironmentList$member' => NULL, 'GetEnvironmentResponse$environment' => '<p>The name of the FinSpace environment.</p>', 'UpdateEnvironmentResponse$environment' => '<p>Returns the FinSpace environment object.</p>', ], ], 'EnvironmentArn' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentResponse$environmentArn' => '<p>The Amazon Resource Name (ARN) of the FinSpace environment that you created.</p>', 'Environment$environmentArn' => '<p>The Amazon Resource Name (ARN) of your FinSpace environment.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name of the resource.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) for the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>A FinSpace resource from which you want to remove a tag or tags. The value for this parameter is an Amazon Resource Name (ARN).</p>', ], ], 'EnvironmentList' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsResponse$environments' => '<p>A list of all of your FinSpace environments.</p>', ], ], 'EnvironmentName' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$name' => '<p>The name of the FinSpace environment to be created.</p>', 'Environment$name' => '<p>The name of the FinSpace environment.</p>', 'UpdateEnvironmentRequest$name' => '<p>The name of the environment.</p>', ], ], 'EnvironmentStatus' => [ 'base' => NULL, 'refs' => [ 'Environment$status' => '<p>The current status of creation of the FinSpace environment.</p>', ], ], 'FederationAttributeKey' => [ 'base' => NULL, 'refs' => [ 'AttributeMap$key' => NULL, ], ], 'FederationMode' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$federationMode' => '<p>Authentication mode for the environment.</p> <ul> <li> <p> <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.</p> </li> <li> <p> <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace environment.</p> </li> </ul>', 'Environment$federationMode' => '<p>The authentication mode for the environment.</p>', 'UpdateEnvironmentRequest$federationMode' => '<p>Authentication mode for the environment.</p> <ul> <li> <p> <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.</p> </li> <li> <p> <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace environment.</p> </li> </ul>', ], ], 'FederationParameters' => [ 'base' => '<p>Configuration information when authentication mode is FEDERATED.</p>', 'refs' => [ 'CreateEnvironmentRequest$federationParameters' => '<p>Configuration information when authentication mode is FEDERATED.</p>', 'Environment$federationParameters' => '<p>Configuration information when authentication mode is FEDERATED.</p>', 'UpdateEnvironmentRequest$federationParameters' => NULL, ], ], 'FederationProviderName' => [ 'base' => NULL, 'refs' => [ 'FederationParameters$federationProviderName' => '<p>Name of the identity provider (IdP).</p>', ], ], 'GetEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'IdType' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentResponse$environmentId' => '<p>The unique identifier for FinSpace environment that you created.</p>', 'DeleteEnvironmentRequest$environmentId' => '<p>The identifier for the FinSpace environment.</p>', 'Environment$environmentId' => '<p>The identifier of the FinSpace environment.</p>', 'Environment$awsAccountId' => '<p>The ID of the AWS account in which the FinSpace environment is created.</p>', 'Environment$dedicatedServiceAccountId' => '<p>The AWS account ID of the dedicated service account associated with your FinSpace environment.</p>', 'GetEnvironmentRequest$environmentId' => '<p>The identifier of the FinSpace environment.</p>', 'UpdateEnvironmentRequest$environmentId' => '<p>The identifier of the FinSpace environment.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request is invalid. Something is wrong with the input to the request.</p>', 'refs' => [], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$kmsKeyId' => '<p>The KMS key id to encrypt your data in the FinSpace environment.</p>', 'Environment$kmsKeyId' => '<p>The KMS key id used to encrypt in the FinSpace environment.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>A service limit or quota is exceeded.</p>', 'refs' => [], ], 'ListEnvironmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'NameString' => [ 'base' => NULL, 'refs' => [ 'SuperuserParameters$firstName' => '<p>The first name of the superuser.</p>', 'SuperuserParameters$lastName' => '<p>The last name of the superuser.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsRequest$nextToken' => '<p>A token generated by FinSpace that specifies where to continue pagination if a previous request was truncated. To get the next set of pages, pass in the nextToken value from the response object of the previous page call.</p>', 'ListEnvironmentsResponse$nextToken' => '<p>A token that you can use in a subsequent call to retrieve the next set of results.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>One or more resources can\'t be found.</p>', 'refs' => [], ], 'ResultLimit' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsRequest$maxResults' => '<p>The maximum number of results to return in this request.</p>', ], ], 'SamlMetadataDocument' => [ 'base' => NULL, 'refs' => [ 'FederationParameters$samlMetadataDocument' => '<p>SAML 2.0 Metadata document from identity provider (IdP).</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p> You have exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use Service Quotas to request a service quota increase.</p>', 'refs' => [], ], 'SmsDomainUrl' => [ 'base' => NULL, 'refs' => [ 'Environment$sageMakerStudioDomainUrl' => '<p>The url of the integrated FinSpace notebook environment in your web application.</p>', ], ], 'SuperuserParameters' => [ 'base' => '<p>Configuration information for the superuser.</p>', 'refs' => [ 'CreateEnvironmentRequest$superuserParameters' => '<p>Configuration information for the superuser.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys (names) of one or more tags to be removed.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$tags' => '<p>Add tags to your FinSpace environment.</p>', 'ListTagsForResourceResponse$tags' => '<p>A list of all tags for a resource.</p>', 'TagResourceRequest$tags' => '<p>One or more tags to be assigned to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an AWS service.</p>', 'refs' => [], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$message' => NULL, 'InvalidRequestException$message' => NULL, 'LimitExceededException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'url' => [ 'base' => NULL, 'refs' => [ 'AttributeMap$value' => NULL, 'CreateEnvironmentResponse$environmentUrl' => '<p>The sign-in url for the web application of the FinSpace environment you created.</p>', 'Environment$environmentUrl' => '<p>The sign-in url for the web application of your FinSpace environment.</p>', 'FederationParameters$samlMetadataURL' => '<p>Provide the metadata URL from your SAML 2.0 compliant identity provider (IdP).</p>', 'FederationParameters$applicationCallBackURL' => '<p>The redirect or sign-in URL that should be entered into the SAML 2.0 compliant identity provider configuration (IdP).</p>', ], ], 'urn' => [ 'base' => NULL, 'refs' => [ 'FederationParameters$federationURN' => '<p>The Uniform Resource Name (URN). Also referred as Service Provider URN or Audience URI or Service Provider Entity ID.</p>', ], ], ],];
