<?php
// This file was auto-generated from sdk-root/src/data/forecastquery/2018-06-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Provides APIs for creating and managing Amazon Forecast resources.</p>', 'operations' => [ 'QueryForecast' => '<p>Retrieves a forecast for a single item, filtered by the supplied criteria.</p> <p>The criteria is a key-value pair. The key is either <code>item_id</code> (or the equivalent non-timestamp, non-target field) from the <code>TARGET_TIME_SERIES</code> dataset, or one of the forecast dimensions specified as part of the <code>FeaturizationConfig</code> object.</p> <p>By default, <code>QueryForecast</code> returns the complete date range for the filtered forecast. You can request a specific date range.</p> <p>To get the full forecast, use the <a href="https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateForecastExportJob.html">CreateForecastExportJob</a> operation.</p> <note> <p>The forecasts generated by Amazon Forecast are in the same timezone as the dataset that was used to create the predictor.</p> </note>', ], 'shapes' => [ 'Arn' => [ 'base' => NULL, 'refs' => [ 'QueryForecastRequest$ForecastArn' => '<p>The Amazon Resource Name (ARN) of the forecast to query.</p>', ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'Filters$key' => NULL, ], ], 'AttributeValue' => [ 'base' => NULL, 'refs' => [ 'Filters$value' => NULL, ], ], 'DataPoint' => [ 'base' => '<p>The forecast value for a specific date. Part of the <a>Forecast</a> object.</p>', 'refs' => [ 'TimeSeries$member' => NULL, ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'QueryForecastRequest$StartDate' => '<p>The start date for the forecast. Specify the date using this format: yyyy-MM-dd\'T\'HH:mm:ss (ISO 8601 format). For example, 2015-01-01T08:00:00.</p>', 'QueryForecastRequest$EndDate' => '<p>The end date for the forecast. Specify the date using this format: yyyy-MM-dd\'T\'HH:mm:ss (ISO 8601 format). For example, 2015-01-01T20:00:00. </p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'DataPoint$Value' => '<p>The forecast value.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidInputException$Message' => NULL, 'InvalidNextTokenException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'QueryForecastRequest$Filters' => '<p>The filtering criteria to apply when retrieving the forecast. For example, to get the forecast for <code>client_21</code> in the electricity usage dataset, specify the following:</p> <p> <code>{"item_id" : "client_21"}</code> </p> <p>To get the full forecast, use the <a href="https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateForecastExportJob.html">CreateForecastExportJob</a> operation.</p>', ], ], 'Forecast' => [ 'base' => '<p>Provides information about a forecast. Returned as part of the <a>QueryForecast</a> response.</p>', 'refs' => [ 'QueryForecastResponse$Forecast' => '<p>The forecast.</p>', ], ], 'InvalidInputException' => [ 'base' => '<p>The value is invalid or is too long.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The token is not valid. Tokens expire after 24 hours.</p>', 'refs' => [], ], 'LimitExceededException' => [ 'base' => '<p>The limit on the number of requests per second has been exceeded.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'QueryForecastRequest$NextToken' => '<p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>', ], ], 'Predictions' => [ 'base' => NULL, 'refs' => [ 'Forecast$Predictions' => '<p>The forecast.</p> <p>The <i>string</i> of the string-to-array map is one of the following values:</p> <ul> <li> <p>p10</p> </li> <li> <p>p50</p> </li> <li> <p>p90</p> </li> </ul>', ], ], 'QueryForecastRequest' => [ 'base' => NULL, 'refs' => [], ], 'QueryForecastResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceInUseException' => [ 'base' => '<p>The specified resource is in use.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>We can\'t find that resource. Check the information that you\'ve provided and try again.</p>', 'refs' => [], ], 'Statistic' => [ 'base' => NULL, 'refs' => [ 'Predictions$key' => NULL, ], ], 'TimeSeries' => [ 'base' => NULL, 'refs' => [ 'Predictions$value' => NULL, ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'DataPoint$Timestamp' => '<p>The timestamp of the specific forecast.</p>', ], ], ],];
