<?php
// This file was auto-generated from sdk-root/src/data/globalaccelerator/2018-08-08/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS Global Accelerator</fullname> <p>This is the <i>AWS Global Accelerator API Reference</i>. This guide is for developers who need detailed information about AWS Global Accelerator API actions, data types, and errors. For more information about Global Accelerator features, see the <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/Welcome.html">AWS Global Accelerator Developer Guide</a>.</p> <p>AWS Global Accelerator is a service in which you create <i>accelerators</i> to improve the performance of your applications for local and global users. Depending on the type of accelerator you choose, you can gain additional benefits. </p> <ul> <li> <p>By using a standard accelerator, you can improve availability of your internet applications that are used by a global audience. With a standard accelerator, Global Accelerator directs traffic to optimal endpoints over the AWS global network. </p> </li> <li> <p>For other scenarios, you might choose a custom routing accelerator. With a custom routing accelerator, you can use application logic to directly map one or more users to a specific endpoint among many endpoints.</p> </li> </ul> <important> <p>Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the US West (Oregon) Region to create or update accelerators.</p> </important> <p>By default, Global Accelerator provides you with two static IP addresses that you associate with your accelerator. With a standard accelerator, instead of using the IP addresses that Global Accelerator provides, you can configure these entry points to be IPv4 addresses from your own IP address ranges that you bring to Global Accelerator. The static IP addresses are anycast from the AWS edge network. For a standard accelerator, they distribute incoming application traffic across multiple endpoint resources in multiple AWS Regions, which increases the availability of your applications. Endpoints for standard accelerators can be Network Load Balancers, Application Load Balancers, Amazon EC2 instances, or Elastic IP addresses that are located in one AWS Region or multiple Regions. For custom routing accelerators, you map traffic that arrives to the static IP addresses to specific Amazon EC2 servers in endpoints that are virtual private cloud (VPC) subnets.</p> <important> <p>The static IP addresses remain assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static IP addresses that are assigned to it, so you can no longer route traffic by using them. You can use IAM policies like tag-based permissions with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/access-control-manage-access-tag-policies.html">Tag-based policies</a>.</p> </important> <p>For standard accelerators, Global Accelerator uses the AWS global network to route traffic to the optimal regional endpoint based on health, client location, and policies that you configure. The service reacts instantly to changes in health or configuration to ensure that internet traffic from clients is always directed to healthy endpoints.</p> <p>For a list of the AWS Regions where Global Accelerator and other services are currently supported, see the <a href="https://docs.aws.amazon.com/about-aws/global-infrastructure/regional-product-services/">AWS Region Table</a>.</p> <p>AWS Global Accelerator includes the following components:</p> <dl> <dt>Static IP addresses</dt> <dd> <p>Global Accelerator provides you with a set of two static IP addresses that are anycast from the AWS edge network. If you bring your own IP address range to AWS (BYOIP) to use with a standard accelerator, you can instead assign IP addresses from your own pool to use with your accelerator. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html"> Bring your own IP addresses (BYOIP) in AWS Global Accelerator</a>.</p> <p>The IP addresses serve as single fixed entry points for your clients. If you already have Elastic Load Balancing load balancers, Amazon EC2 instances, or Elastic IP address resources set up for your applications, you can easily add those to a standard accelerator in Global Accelerator. This allows Global Accelerator to use static IP addresses to access the resources.</p> <p>The static IP addresses remain assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static IP addresses that are assigned to it, so you can no longer route traffic by using them. You can use IAM policies like tag-based permissions with Global Accelerator to delete an accelerator. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/access-control-manage-access-tag-policies.html">Tag-based policies</a>.</p> </dd> <dt>Accelerator</dt> <dd> <p>An accelerator directs traffic to endpoints over the AWS global network to improve the performance of your internet applications. Each accelerator includes one or more listeners.</p> <p>There are two types of accelerators:</p> <ul> <li> <p>A <i>standard</i> accelerator directs traffic to the optimal AWS endpoint based on several factors, including the user’s location, the health of the endpoint, and the endpoint weights that you configure. This improves the availability and performance of your applications. Endpoints can be Network Load Balancers, Application Load Balancers, Amazon EC2 instances, or Elastic IP addresses.</p> </li> <li> <p>A <i>custom routing</i> accelerator directs traffic to one of possibly thousands of Amazon EC2 instances running in a single or multiple virtual private clouds (VPCs). With custom routing, listener ports are mapped to statically associate port ranges with VPC subnets, which allows Global Accelerator to determine an EC2 instance IP address at the time of connection. By default, all port mapping destinations in a VPC subnet can\'t receive traffic. You can choose to configure all destinations in the subnet to receive traffic, or to specify individual port mappings that can receive traffic.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/introduction-accelerator-types.html">Types of accelerators</a>.</p> </dd> <dt>DNS name</dt> <dd> <p>Global Accelerator assigns each accelerator a default Domain Name System (DNS) name, similar to <code>a1234567890abcdef.awsglobalaccelerator.com</code>, that points to the static IP addresses that Global Accelerator assigns to you or that you choose from your own IP address range. Depending on the use case, you can use your accelerator\'s static IP addresses or DNS name to route traffic to your accelerator, or set up DNS records to route traffic using your own custom domain name.</p> </dd> <dt>Network zone</dt> <dd> <p>A network zone services the static IP addresses for your accelerator from a unique IP subnet. Similar to an AWS Availability Zone, a network zone is an isolated unit with its own set of physical infrastructure. When you configure an accelerator, by default, Global Accelerator allocates two IPv4 addresses for it. If one IP address from a network zone becomes unavailable due to IP address blocking by certain client networks, or network disruptions, then client applications can retry on the healthy static IP address from the other isolated network zone.</p> </dd> <dt>Listener</dt> <dd> <p>A listener processes inbound connections from clients to Global Accelerator, based on the port (or port range) and protocol (or protocols) that you configure. A listener can be configured for TCP, UDP, or both TCP and UDP protocols. Each listener has one or more endpoint groups associated with it, and traffic is forwarded to endpoints in one of the groups. You associate endpoint groups with listeners by specifying the Regions that you want to distribute traffic to. With a standard accelerator, traffic is distributed to optimal endpoints within the endpoint groups associated with a listener.</p> </dd> <dt>Endpoint group</dt> <dd> <p>Each endpoint group is associated with a specific AWS Region. Endpoint groups include one or more endpoints in the Region. With a standard accelerator, you can increase or reduce the percentage of traffic that would be otherwise directed to an endpoint group by adjusting a setting called a <i>traffic dial</i>. The traffic dial lets you easily do performance testing or blue/green deployment testing, for example, for new releases across different AWS Regions. </p> </dd> <dt>Endpoint</dt> <dd> <p>An endpoint is a resource that Global Accelerator directs traffic to.</p> <p>Endpoints for standard accelerators can be Network Load Balancers, Application Load Balancers, Amazon EC2 instances, or Elastic IP addresses. An Application Load Balancer endpoint can be internet-facing or internal. Traffic for standard accelerators is routed to endpoints based on the health of the endpoint along with configuration options that you choose, such as endpoint weights. For each endpoint, you can configure weights, which are numbers that you can use to specify the proportion of traffic to route to each one. This can be useful, for example, to do performance testing within a Region.</p> <p>Endpoints for custom routing accelerators are virtual private cloud (VPC) subnets with one or many EC2 instances.</p> </dd> </dl>', 'operations' => [ 'AddCustomRoutingEndpoints' => '<p>Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.</p> <p>The listener port range must be large enough to support the number of IP addresses that can be specified in your subnet. The number of ports required is: subnet size times the number of ports per destination EC2 instances. For example, a subnet defined as /24 requires a listener port range of at least 255 ports. </p> <p>Note: You must have enough remaining listener ports available to map to the subnet ports, or the call will fail with a LimitExceededException.</p> <p>By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html"> AllowCustomRoutingTraffic</a> operation.</p>', 'AdvertiseByoipCidr' => '<p>Advertises an IPv4 address range that is provisioned for use with your AWS resources through bring your own IP addresses (BYOIP). It can take a few minutes before traffic to the specified addresses starts routing to AWS because of propagation delays. </p> <p>To stop advertising the BYOIP address range, use <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html"> WithdrawByoipCidr</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'AllowCustomRoutingTraffic' => '<p>Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive traffic for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or allow traffic to a specified list of destination IP addresses and ports in the subnet. Note that you cannot specify IP addresses or ports outside of the range that you configured for the endpoint group.</p> <p>After you make changes, you can verify that the updates are complete by checking the status of your accelerator: the status changes from IN_PROGRESS to DEPLOYED.</p>', 'CreateAccelerator' => '<p>Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct traffic to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers. </p> <important> <p>Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the US West (Oregon) Region to create or update accelerators.</p> </important>', 'CreateCustomRoutingAccelerator' => '<p>Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands of Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.</p> <p>Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive traffic. To enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html"> AllowCustomRoutingTraffic</a> operation.</p> <important> <p>Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the US West (Oregon) Region to create or update accelerators.</p> </important>', 'CreateCustomRoutingEndpointGroup' => '<p>Create an endpoint group for the specified listener for a custom routing accelerator. An endpoint group is a collection of endpoints in one AWS Region. </p>', 'CreateCustomRoutingListener' => '<p>Create a listener to process inbound connections from clients to a custom routing accelerator. Connections arrive to assigned static IP addresses on the port range that you specify. </p>', 'CreateEndpointGroup' => '<p>Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one AWS Region. A resource must be valid and active when you add it as an endpoint.</p>', 'CreateListener' => '<p>Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned static IP addresses on a port, port range, or list of port ranges that you specify. </p>', 'DeleteAccelerator' => '<p>Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set <code>Enabled</code> to false.</p> <important> <p>When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP addresses. Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses from those ranges. </p> <p>The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Authentication and Access Control</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p> </important>', 'DeleteCustomRoutingAccelerator' => '<p>Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set <code>Enabled</code> to false.</p> <important> <p>When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two static IP addresses. </p> <p>The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Authentication and Access Control</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p> </important>', 'DeleteCustomRoutingEndpointGroup' => '<p>Delete an endpoint group from a listener for a custom routing accelerator.</p>', 'DeleteCustomRoutingListener' => '<p>Delete a listener for a custom routing accelerator.</p>', 'DeleteEndpointGroup' => '<p>Delete an endpoint group from a listener.</p>', 'DeleteListener' => '<p>Delete a listener from an accelerator.</p>', 'DenyCustomRoutingTraffic' => '<p>Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot receive traffic for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint, or deny traffic to a specified list of destination IP addresses and ports. Note that you cannot specify IP addresses or ports outside of the range that you configured for the endpoint group.</p> <p>After you make changes, you can verify that the updates are complete by checking the status of your accelerator: the status changes from IN_PROGRESS to DEPLOYED.</p>', 'DeprovisionByoipCidr' => '<p>Releases the specified address range that you provisioned to use with your AWS resources through bring your own IP addresses (BYOIP) and deletes the corresponding address pool. </p> <p>Before you can release an address range, you must stop advertising it by using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">WithdrawByoipCidr</a> and you must not have any accelerators that are using static IP addresses allocated from its address range. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'DescribeAccelerator' => '<p>Describe an accelerator. </p>', 'DescribeAcceleratorAttributes' => '<p>Describe the attributes of an accelerator. </p>', 'DescribeCustomRoutingAccelerator' => '<p>Describe a custom routing accelerator. </p>', 'DescribeCustomRoutingAcceleratorAttributes' => '<p>Describe the attributes of a custom routing accelerator. </p>', 'DescribeCustomRoutingEndpointGroup' => '<p>Describe an endpoint group for a custom routing accelerator. </p>', 'DescribeCustomRoutingListener' => '<p>The description of a listener for a custom routing accelerator.</p>', 'DescribeEndpointGroup' => '<p>Describe an endpoint group. </p>', 'DescribeListener' => '<p>Describe a listener. </p>', 'ListAccelerators' => '<p>List the accelerators for an AWS account. </p>', 'ListByoipCidrs' => '<p>Lists the IP address ranges that were specified in calls to <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr</a>, including the current state and a history of state changes.</p>', 'ListCustomRoutingAccelerators' => '<p>List the custom routing accelerators for an AWS account. </p>', 'ListCustomRoutingEndpointGroups' => '<p>List the endpoint groups that are associated with a listener for a custom routing accelerator. </p>', 'ListCustomRoutingListeners' => '<p>List the listeners for a custom routing accelerator. </p>', 'ListCustomRoutingPortMappings' => '<p>Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port mappings don\'t change after Global Accelerator generates them, so you can retrieve and cache the full mapping on your servers. </p> <p>If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don\'t change). If you add or remove EC2 instances in your subnet, the port mappings don\'t change, because the mappings are created when you add the subnet to Global Accelerator.</p> <p>The mappings also include a flag for each destination denoting which destination IP addresses and ports are allowed or denied traffic.</p>', 'ListCustomRoutingPortMappingsByDestination' => '<p>List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a specific destination instance.</p>', 'ListEndpointGroups' => '<p>List the endpoint groups that are associated with a listener. </p>', 'ListListeners' => '<p>List the listeners for an accelerator. </p>', 'ListTagsForResource' => '<p>List all tags for an accelerator. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>. </p>', 'ProvisionByoipCidr' => '<p>Provisions an IP address range to use with your AWS resources through bring your own IP addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be advertised using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html"> AdvertiseByoipCidr</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'RemoveCustomRoutingEndpoints' => '<p>Remove endpoints from a custom routing accelerator.</p>', 'TagResource' => '<p>Add tags to an accelerator resource. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>. </p>', 'UntagResource' => '<p>Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and its associated value. The operation succeeds even if you attempt to remove tags from an accelerator that was already removed.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'UpdateAccelerator' => '<p>Update an accelerator. </p> <important> <p>Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the US West (Oregon) Region to create or update accelerators.</p> </important>', 'UpdateAcceleratorAttributes' => '<p>Update the attributes for an accelerator. </p>', 'UpdateCustomRoutingAccelerator' => '<p>Update a custom routing accelerator. </p>', 'UpdateCustomRoutingAcceleratorAttributes' => '<p>Update the attributes for a custom routing accelerator. </p>', 'UpdateCustomRoutingListener' => '<p>Update a listener for a custom routing accelerator. </p>', 'UpdateEndpointGroup' => '<p>Update an endpoint group. A resource must be valid and active when you add it as an endpoint.</p>', 'UpdateListener' => '<p>Update a listener. </p>', 'WithdrawByoipCidr' => '<p>Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time.</p> <p>It can take a few minutes before traffic to the specified addresses stops routing to AWS because of propagation delays.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', ], 'shapes' => [ 'Accelerator' => [ 'base' => '<p>An accelerator is a complex type that includes one or more listeners that process inbound connections and then direct traffic to one or more endpoint groups, each of which includes endpoints, such as load balancers.</p>', 'refs' => [ 'Accelerators$member' => NULL, 'CreateAcceleratorResponse$Accelerator' => '<p>The accelerator that is created by specifying a listener and the supported IP address types.</p>', 'DescribeAcceleratorResponse$Accelerator' => '<p>The description of the accelerator.</p>', 'UpdateAcceleratorResponse$Accelerator' => '<p>Information about the updated accelerator.</p>', ], ], 'AcceleratorAttributes' => [ 'base' => '<p>Attributes of an accelerator.</p>', 'refs' => [ 'DescribeAcceleratorAttributesResponse$AcceleratorAttributes' => '<p>The attributes of the accelerator.</p>', 'UpdateAcceleratorAttributesResponse$AcceleratorAttributes' => '<p>Updated attributes for the accelerator.</p>', ], ], 'AcceleratorNotDisabledException' => [ 'base' => '<p>The accelerator that you specified could not be disabled.</p>', 'refs' => [], ], 'AcceleratorNotFoundException' => [ 'base' => '<p>The accelerator that you specified doesn\'t exist.</p>', 'refs' => [], ], 'AcceleratorStatus' => [ 'base' => NULL, 'refs' => [ 'Accelerator$Status' => '<p>Describes the deployment status of the accelerator.</p>', ], ], 'Accelerators' => [ 'base' => NULL, 'refs' => [ 'ListAcceleratorsResponse$Accelerators' => '<p>The list of accelerators for a customer account.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You don\'t have access permission.</p>', 'refs' => [], ], 'AddCustomRoutingEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddCustomRoutingEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AdvertiseByoipCidrRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdvertiseByoipCidrResponse' => [ 'base' => NULL, 'refs' => [], ], 'AllowCustomRoutingTrafficRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociatedEndpointGroupFoundException' => [ 'base' => '<p>The listener that you specified has an endpoint group associated with it. You must remove all dependent resources from a listener before you can delete it.</p>', 'refs' => [], ], 'AssociatedListenerFoundException' => [ 'base' => '<p>The accelerator that you specified has a listener associated with it. You must remove all dependent resources from an accelerator before you can delete it.</p>', 'refs' => [], ], 'ByoipCidr' => [ 'base' => '<p>Information about an IP address range that is provisioned for use with your AWS resources through bring your own IP address (BYOIP).</p> <p>The following describes each BYOIP <code>State</code> that your IP address range can be in.</p> <ul> <li> <p> <b>PENDING_PROVISIONING</b> — You’ve submitted a request to provision an IP address range but it is not yet provisioned with AWS Global Accelerator.</p> </li> <li> <p> <b>READY</b> — The address range is provisioned with AWS Global Accelerator and can be advertised.</p> </li> <li> <p> <b>PENDING_ADVERTISING</b> — You’ve submitted a request for AWS Global Accelerator to advertise an address range but it is not yet being advertised.</p> </li> <li> <p> <b>ADVERTISING</b> — The address range is being advertised by AWS Global Accelerator.</p> </li> <li> <p> <b>PENDING_WITHDRAWING</b> — You’ve submitted a request to withdraw an address range from being advertised but it is still being advertised by AWS Global Accelerator.</p> </li> <li> <p> <b>PENDING_DEPROVISIONING</b> — You’ve submitted a request to deprovision an address range from AWS Global Accelerator but it is still provisioned.</p> </li> <li> <p> <b>DEPROVISIONED</b> — The address range is deprovisioned from AWS Global Accelerator.</p> </li> <li> <p> <b>FAILED_PROVISION </b> — The request to provision the address range from AWS Global Accelerator was not successful. Please make sure that you provide all of the correct information, and try again. If the request fails a second time, contact AWS support.</p> </li> <li> <p> <b>FAILED_ADVERTISING</b> — The request for AWS Global Accelerator to advertise the address range was not successful. Please make sure that you provide all of the correct information, and try again. If the request fails a second time, contact AWS support.</p> </li> <li> <p> <b>FAILED_WITHDRAW</b> — The request to withdraw the address range from advertising by AWS Global Accelerator was not successful. Please make sure that you provide all of the correct information, and try again. If the request fails a second time, contact AWS support.</p> </li> <li> <p> <b>FAILED_DEPROVISION </b> — The request to deprovision the address range from AWS Global Accelerator was not successful. Please make sure that you provide all of the correct information, and try again. If the request fails a second time, contact AWS support.</p> </li> </ul>', 'refs' => [ 'AdvertiseByoipCidrResponse$ByoipCidr' => '<p>Information about the address range.</p>', 'ByoipCidrs$member' => NULL, 'DeprovisionByoipCidrResponse$ByoipCidr' => '<p>Information about the address range.</p>', 'ProvisionByoipCidrResponse$ByoipCidr' => '<p>Information about the address range.</p>', 'WithdrawByoipCidrResponse$ByoipCidr' => '<p>Information about the address pool.</p>', ], ], 'ByoipCidrEvent' => [ 'base' => '<p>A complex type that contains a <code>Message</code> and a <code>Timestamp</code> value for changes that you make in the status an IP address range that you bring to AWS Global Accelerator through bring your own IP address (BYOIP).</p>', 'refs' => [ 'ByoipCidrEvents$member' => NULL, ], ], 'ByoipCidrEvents' => [ 'base' => NULL, 'refs' => [ 'ByoipCidr$Events' => '<p>A history of status changes for an IP address range that you bring to AWS Global Accelerator through bring your own IP address (BYOIP).</p>', ], ], 'ByoipCidrNotFoundException' => [ 'base' => '<p>The CIDR that you specified was not found or is incorrect.</p>', 'refs' => [], ], 'ByoipCidrState' => [ 'base' => NULL, 'refs' => [ 'ByoipCidr$State' => '<p>The state of the address pool.</p>', ], ], 'ByoipCidrs' => [ 'base' => NULL, 'refs' => [ 'ListByoipCidrsResponse$ByoipCidrs' => '<p>Information about your address ranges.</p>', ], ], 'CidrAuthorizationContext' => [ 'base' => '<p>Provides authorization for Amazon to bring a specific IP address range to a specific AWS account using bring your own IP addresses (BYOIP). </p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'refs' => [ 'ProvisionByoipCidrRequest$CidrAuthorizationContext' => '<p>A signed document that proves that you are authorized to bring the specified IP address range to Amazon using BYOIP. </p>', ], ], 'ClientAffinity' => [ 'base' => NULL, 'refs' => [ 'CreateListenerRequest$ClientAffinity' => '<p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications, regardless of the port and protocol of the client request. Client affinity gives you control over whether to always route each client to the same specific endpoint.</p> <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port, destination IP address, destination port, and protocol—to select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not be always routed to the same endpoint because the hash value changes. </p> <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.</p> <p>The default value is <code>NONE</code>.</p>', 'Listener$ClientAffinity' => '<p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications, regardless of the port and protocol of the client request. Client affinity gives you control over whether to always route each client to the same specific endpoint.</p> <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port, destination IP address, destination port, and protocol—to select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not be always routed to the same endpoint because the hash value changes. </p> <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.</p> <p>The default value is <code>NONE</code>.</p>', 'UpdateListenerRequest$ClientAffinity' => '<p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications, regardless of the port and protocol of the client request. Client affinity gives you control over whether to always route each client to the same specific endpoint.</p> <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port, destination IP address, destination port, and protocol—to select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not be always routed to the same endpoint because the hash value changes. </p> <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.</p> <p>The default value is <code>NONE</code>.</p>', ], ], 'ConflictException' => [ 'base' => '<p>You can\'t use both of those options.</p>', 'refs' => [], ], 'CreateAcceleratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAcceleratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomRoutingAcceleratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomRoutingAcceleratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomRoutingEndpointGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomRoutingEndpointGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomRoutingListenerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomRoutingListenerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateListenerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateListenerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomRoutingAccelerator' => [ 'base' => '<p>Attributes of a custom routing accelerator.</p>', 'refs' => [ 'CreateCustomRoutingAcceleratorResponse$Accelerator' => '<p>The accelerator that is created.</p>', 'CustomRoutingAccelerators$member' => NULL, 'DescribeCustomRoutingAcceleratorResponse$Accelerator' => '<p>The description of the custom routing accelerator.</p>', 'UpdateCustomRoutingAcceleratorResponse$Accelerator' => '<p>Information about the updated custom routing accelerator.</p>', ], ], 'CustomRoutingAcceleratorAttributes' => [ 'base' => '<p>Attributes of a custom routing accelerator.</p>', 'refs' => [ 'DescribeCustomRoutingAcceleratorAttributesResponse$AcceleratorAttributes' => '<p>The attributes of the custom routing accelerator.</p>', 'UpdateCustomRoutingAcceleratorAttributesResponse$AcceleratorAttributes' => '<p>Updated custom routing accelerator.</p>', ], ], 'CustomRoutingAcceleratorStatus' => [ 'base' => NULL, 'refs' => [ 'CustomRoutingAccelerator$Status' => '<p>Describes the deployment status of the accelerator.</p>', ], ], 'CustomRoutingAccelerators' => [ 'base' => NULL, 'refs' => [ 'ListCustomRoutingAcceleratorsResponse$Accelerators' => '<p>The list of custom routing accelerators for a customer account.</p>', ], ], 'CustomRoutingDestinationConfiguration' => [ 'base' => '<p>For a custom routing accelerator, sets the port range and protocol for all endpoints (virtual private cloud subnets) in an endpoint group to accept client traffic on.</p>', 'refs' => [ 'CustomRoutingDestinationConfigurations$member' => NULL, ], ], 'CustomRoutingDestinationConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateCustomRoutingEndpointGroupRequest$DestinationConfigurations' => '<p>Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing endpoint group to accept client traffic on.</p>', ], ], 'CustomRoutingDestinationDescription' => [ 'base' => '<p>For a custom routing accelerator, describes the port range and protocol for all endpoints (virtual private cloud subnets) in an endpoint group to accept client traffic on.</p>', 'refs' => [ 'CustomRoutingDestinationDescriptions$member' => NULL, ], ], 'CustomRoutingDestinationDescriptions' => [ 'base' => NULL, 'refs' => [ 'CustomRoutingEndpointGroup$DestinationDescriptions' => '<p>For a custom routing accelerator, describes the port range and protocol for all endpoints (virtual private cloud subnets) in an endpoint group to accept client traffic on.</p>', ], ], 'CustomRoutingDestinationTrafficState' => [ 'base' => NULL, 'refs' => [ 'DestinationPortMapping$DestinationTrafficState' => '<p>Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.</p>', 'PortMapping$DestinationTrafficState' => '<p>Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.</p>', ], ], 'CustomRoutingEndpointConfiguration' => [ 'base' => '<p>The list of endpoint objects. For custom routing, this is a list of virtual private cloud (VPC) subnet IDs.</p>', 'refs' => [ 'CustomRoutingEndpointConfigurations$member' => NULL, ], ], 'CustomRoutingEndpointConfigurations' => [ 'base' => NULL, 'refs' => [ 'AddCustomRoutingEndpointsRequest$EndpointConfigurations' => '<p>The list of endpoint objects to add to a custom routing accelerator.</p>', ], ], 'CustomRoutingEndpointDescription' => [ 'base' => '<p>A complex type for an endpoint for a custom routing accelerator. Each endpoint group can include one or more endpoints, which are virtual private cloud (VPC) subnets.</p>', 'refs' => [ 'CustomRoutingEndpointDescriptions$member' => NULL, ], ], 'CustomRoutingEndpointDescriptions' => [ 'base' => NULL, 'refs' => [ 'AddCustomRoutingEndpointsResponse$EndpointDescriptions' => '<p>The endpoint objects added to the custom routing accelerator.</p>', 'CustomRoutingEndpointGroup$EndpointDescriptions' => '<p>For a custom routing accelerator, describes the endpoints (virtual private cloud subnets) in an endpoint group to accept client traffic on.</p>', ], ], 'CustomRoutingEndpointGroup' => [ 'base' => '<p>A complex type for the endpoint group for a custom routing accelerator. An AWS Region can have only one endpoint group for a specific listener. </p>', 'refs' => [ 'CreateCustomRoutingEndpointGroupResponse$EndpointGroup' => '<p>The information about the endpoint group created for a custom routing accelerator.</p>', 'CustomRoutingEndpointGroups$member' => NULL, 'DescribeCustomRoutingEndpointGroupResponse$EndpointGroup' => '<p>The description of an endpoint group for a custom routing accelerator.</p>', ], ], 'CustomRoutingEndpointGroups' => [ 'base' => NULL, 'refs' => [ 'ListCustomRoutingEndpointGroupsResponse$EndpointGroups' => '<p>The list of the endpoint groups associated with a listener for a custom routing accelerator.</p>', ], ], 'CustomRoutingListener' => [ 'base' => '<p>A complex type for a listener for a custom routing accelerator.</p>', 'refs' => [ 'CreateCustomRoutingListenerResponse$Listener' => '<p>The listener that you\'ve created for a custom routing accelerator.</p>', 'CustomRoutingListeners$member' => NULL, 'DescribeCustomRoutingListenerResponse$Listener' => '<p>The description of a listener for a custom routing accelerator.</p>', 'UpdateCustomRoutingListenerResponse$Listener' => '<p>Information for the updated listener for a custom routing accelerator.</p>', ], ], 'CustomRoutingListeners' => [ 'base' => NULL, 'refs' => [ 'ListCustomRoutingListenersResponse$Listeners' => '<p>The list of listeners for a custom routing accelerator.</p>', ], ], 'CustomRoutingProtocol' => [ 'base' => NULL, 'refs' => [ 'CustomRoutingProtocols$member' => NULL, ], ], 'CustomRoutingProtocols' => [ 'base' => NULL, 'refs' => [ 'CustomRoutingDestinationConfiguration$Protocols' => '<p>The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either TCP or UDP.</p>', 'PortMapping$Protocols' => '<p>The protocols supported by the endpoint group.</p>', ], ], 'DeleteAcceleratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomRoutingAcceleratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomRoutingEndpointGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomRoutingListenerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEndpointGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteListenerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DenyCustomRoutingTrafficRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeprovisionByoipCidrRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeprovisionByoipCidrResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAcceleratorAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAcceleratorAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAcceleratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAcceleratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomRoutingAcceleratorAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomRoutingAcceleratorAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomRoutingAcceleratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomRoutingAcceleratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomRoutingEndpointGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomRoutingEndpointGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomRoutingListenerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomRoutingListenerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeListenerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeListenerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DestinationAddresses' => [ 'base' => NULL, 'refs' => [ 'AllowCustomRoutingTrafficRequest$DestinationAddresses' => '<p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to allow to receive traffic. The IP addresses must be a subset of the IP addresses that you specified for the endpoint group.</p> <p> <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is <code>FALSE</code> or is not specified.</p>', 'DenyCustomRoutingTrafficRequest$DestinationAddresses' => '<p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to prevent from receiving traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC subnet associated with the endpoint group.</p>', ], ], 'DestinationPortMapping' => [ 'base' => '<p>The port mappings for a specified endpoint IP address (destination).</p>', 'refs' => [ 'DestinationPortMappings$member' => NULL, ], ], 'DestinationPortMappings' => [ 'base' => NULL, 'refs' => [ 'ListCustomRoutingPortMappingsByDestinationResponse$DestinationPortMappings' => '<p>The port mappings for the endpoint IP address that you specified in the request.</p>', ], ], 'DestinationPorts' => [ 'base' => NULL, 'refs' => [ 'AllowCustomRoutingTrafficRequest$DestinationPorts' => '<p>A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive traffic.</p>', 'DenyCustomRoutingTrafficRequest$DestinationPorts' => '<p>A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to prevent from receiving traffic.</p>', ], ], 'EndpointAlreadyExistsException' => [ 'base' => '<p>The endpoint that you specified doesn\'t exist.</p>', 'refs' => [], ], 'EndpointConfiguration' => [ 'base' => '<p>A complex type for endpoints. A resource must be valid and active when you add it as an endpoint.</p>', 'refs' => [ 'EndpointConfigurations$member' => NULL, ], ], 'EndpointConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointGroupRequest$EndpointConfigurations' => '<p>The list of endpoint objects.</p>', 'UpdateEndpointGroupRequest$EndpointConfigurations' => '<p>The list of endpoint objects. A resource must be valid and active when you add it as an endpoint.</p>', ], ], 'EndpointDescription' => [ 'base' => '<p>A complex type for an endpoint. Each endpoint group can include one or more endpoints, such as load balancers.</p>', 'refs' => [ 'EndpointDescriptions$member' => NULL, ], ], 'EndpointDescriptions' => [ 'base' => NULL, 'refs' => [ 'EndpointGroup$EndpointDescriptions' => '<p>The list of endpoint objects.</p>', ], ], 'EndpointGroup' => [ 'base' => '<p>A complex type for the endpoint group. An AWS Region can have only one endpoint group for a specific listener. </p>', 'refs' => [ 'CreateEndpointGroupResponse$EndpointGroup' => '<p>The information about the endpoint group that was created.</p>', 'DescribeEndpointGroupResponse$EndpointGroup' => '<p>The description of an endpoint group.</p>', 'EndpointGroups$member' => NULL, 'UpdateEndpointGroupResponse$EndpointGroup' => '<p>The information about the endpoint group that was updated.</p>', ], ], 'EndpointGroupAlreadyExistsException' => [ 'base' => '<p>The endpoint group that you specified already exists.</p>', 'refs' => [], ], 'EndpointGroupNotFoundException' => [ 'base' => '<p>The endpoint group that you specified doesn\'t exist.</p>', 'refs' => [], ], 'EndpointGroups' => [ 'base' => NULL, 'refs' => [ 'ListEndpointGroupsResponse$EndpointGroups' => '<p>The list of the endpoint groups associated with a listener.</p>', ], ], 'EndpointIds' => [ 'base' => NULL, 'refs' => [ 'RemoveCustomRoutingEndpointsRequest$EndpointIds' => '<p>The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud (VPC) subnet IDs. </p>', ], ], 'EndpointNotFoundException' => [ 'base' => '<p>The endpoint that you specified doesn\'t exist.</p>', 'refs' => [], ], 'EndpointWeight' => [ 'base' => NULL, 'refs' => [ 'EndpointConfiguration$Weight' => '<p>The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second and third endpoints, and 6/20 is routed to the last endpoint. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint Weights</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'EndpointDescription$Weight' => '<p>The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second and third endpoints, and 6/20 is routed to the last endpoint. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint Weights</a> in the <i>AWS Global Accelerator Developer Guide</i>. </p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AcceleratorNotDisabledException$Message' => NULL, 'AcceleratorNotFoundException$Message' => NULL, 'AccessDeniedException$Message' => NULL, 'AssociatedEndpointGroupFoundException$Message' => NULL, 'AssociatedListenerFoundException$Message' => NULL, 'ByoipCidrNotFoundException$Message' => NULL, 'ConflictException$Message' => NULL, 'EndpointAlreadyExistsException$Message' => NULL, 'EndpointGroupAlreadyExistsException$Message' => NULL, 'EndpointGroupNotFoundException$Message' => NULL, 'EndpointNotFoundException$Message' => NULL, 'IncorrectCidrStateException$Message' => NULL, 'InternalServiceErrorException$Message' => NULL, 'InvalidArgumentException$Message' => NULL, 'InvalidNextTokenException$Message' => NULL, 'InvalidPortRangeException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'ListenerNotFoundException$Message' => NULL, ], ], 'GenericBoolean' => [ 'base' => NULL, 'refs' => [ 'Accelerator$Enabled' => '<p>Indicates whether the accelerator is enabled. The value is true or false. The default value is true. </p> <p>If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.</p>', 'AcceleratorAttributes$FlowLogsEnabled' => '<p>Indicates whether flow logs are enabled. The default value is false. If the value is true, <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'AllowCustomRoutingTrafficRequest$AllowAllTrafficToEndpoint' => '<p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p> <p>When set to TRUE, <i>all</i> destinations in the custom routing VPC subnet can receive traffic. Note that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p> <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that are allowed to receive traffic. A list of ports is optional. If you don\'t specify a list of ports, the ports that can accept traffic is the same as the ports configured for the endpoint group.</p> <p>The default value is FALSE.</p>', 'CreateAcceleratorRequest$Enabled' => '<p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p> <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>', 'CreateCustomRoutingAcceleratorRequest$Enabled' => '<p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p> <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>', 'CustomRoutingAccelerator$Enabled' => '<p>Indicates whether the accelerator is enabled. The value is true or false. The default value is true. </p> <p>If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.</p>', 'CustomRoutingAcceleratorAttributes$FlowLogsEnabled' => '<p>Indicates whether flow logs are enabled. The default value is false. If the value is true, <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'DenyCustomRoutingTrafficRequest$DenyAllTrafficToEndpoint' => '<p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint <i>cannot</i> receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p> <p>When set to TRUE, <i>no</i> destinations in the custom routing VPC subnet can receive traffic. Note that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p> <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that cannot receive traffic. A list of ports is optional. If you don\'t specify a list of ports, the ports that can accept traffic is the same as the ports configured for the endpoint group.</p> <p>The default value is FALSE.</p>', 'EndpointConfiguration$ClientIPPreservationEnabled' => '<p>Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint. The value is true or false. The default value is true for new accelerators. </p> <p>If the value is set to true, the client\'s IP address is preserved in the <code>X-Forwarded-For</code> request header as traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html"> Preserve Client IP Addresses in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'EndpointDescription$ClientIPPreservationEnabled' => '<p>Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint. The value is true or false. The default value is true for new accelerators. </p> <p>If the value is set to true, the client\'s IP address is preserved in the <code>X-Forwarded-For</code> request header as traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/introduction-how-it-works-client-ip.html"> Viewing Client IP Addresses in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'UpdateAcceleratorAttributesRequest$FlowLogsEnabled' => '<p>Update whether flow logs are enabled. The default value is false. If the value is true, <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'UpdateAcceleratorRequest$Enabled' => '<p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p> <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>', 'UpdateCustomRoutingAcceleratorAttributesRequest$FlowLogsEnabled' => '<p>Update whether flow logs are enabled. The default value is false. If the value is true, <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'UpdateCustomRoutingAcceleratorRequest$Enabled' => '<p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p> <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>', ], ], 'GenericString' => [ 'base' => NULL, 'refs' => [ 'Accelerator$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the accelerator.</p>', 'Accelerator$Name' => '<p>The name of the accelerator. The name must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>', 'Accelerator$DnsName' => '<p>The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator\'s static IP addresses. </p> <p>The naming convention for the DNS name is the following: A lowercase letter a, followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For example: a1234567890abcdef.awsglobalaccelerator.com.</p> <p>For more information about the default DNS name, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing"> Support for DNS Addressing in Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'AcceleratorAttributes$FlowLogsS3Bucket' => '<p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the bucket.</p>', 'AcceleratorAttributes$FlowLogsS3Prefix' => '<p>The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>.</p> <p>If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p> <p>s3-bucket_name//AWSLogs/aws_account_id</p>', 'AddCustomRoutingEndpointsRequest$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.</p>', 'AddCustomRoutingEndpointsResponse$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.</p>', 'AdvertiseByoipCidrRequest$Cidr' => '<p>The address range, in CIDR notation. This must be the exact range that you provisioned. You can\'t advertise only a portion of the provisioned range.</p>', 'AllowCustomRoutingTrafficRequest$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group.</p>', 'AllowCustomRoutingTrafficRequest$EndpointId' => '<p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>', 'ByoipCidr$Cidr' => '<p>The address range, in CIDR notation.</p>', 'ByoipCidrEvent$Message' => '<p>A string that contains an <code>Event</code> message describing changes that you make in the status of an IP address range that you bring to AWS Global Accelerator through bring your own IP address (BYOIP).</p>', 'CidrAuthorizationContext$Message' => '<p>The plain-text authorization message for the prefix and account.</p>', 'CidrAuthorizationContext$Signature' => '<p>The signed authorization message for the prefix and account.</p>', 'CreateAcceleratorRequest$Name' => '<p>The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>', 'CreateCustomRoutingAcceleratorRequest$Name' => '<p>The name of a custom routing accelerator. The name can have a maximum of 64 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>', 'CreateCustomRoutingEndpointGroupRequest$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.</p>', 'CreateCustomRoutingEndpointGroupRequest$EndpointGroupRegion' => '<p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a specific Region.</p>', 'CreateCustomRoutingListenerRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.</p>', 'CreateEndpointGroupRequest$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'CreateEndpointGroupRequest$EndpointGroupRegion' => '<p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a specific Region.</p>', 'CreateListenerRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of your accelerator.</p>', 'CustomRoutingAccelerator$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the custom routing accelerator.</p>', 'CustomRoutingAccelerator$Name' => '<p>The name of the accelerator. The name must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>', 'CustomRoutingAccelerator$DnsName' => '<p>The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator\'s static IP addresses. </p> <p>The naming convention for the DNS name is the following: A lowercase letter a, followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For example: a1234567890abcdef.awsglobalaccelerator.com.</p> <p>For more information about the default DNS name, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing"> Support for DNS Addressing in Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'CustomRoutingAcceleratorAttributes$FlowLogsS3Bucket' => '<p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the bucket.</p>', 'CustomRoutingAcceleratorAttributes$FlowLogsS3Prefix' => '<p>The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>.</p> <p>If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p> <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>', 'CustomRoutingEndpointConfiguration$EndpointId' => '<p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID. </p>', 'CustomRoutingEndpointDescription$EndpointId' => '<p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID. </p>', 'CustomRoutingEndpointGroup$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group.</p>', 'CustomRoutingEndpointGroup$EndpointGroupRegion' => '<p>The AWS Region where the endpoint group is located.</p>', 'CustomRoutingListener$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'DeleteAcceleratorRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of an accelerator.</p>', 'DeleteCustomRoutingAcceleratorRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the custom routing accelerator to delete.</p>', 'DeleteCustomRoutingEndpointGroupRequest$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>', 'DeleteCustomRoutingListenerRequest$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener to delete.</p>', 'DeleteEndpointGroupRequest$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>', 'DeleteListenerRequest$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'DenyCustomRoutingTrafficRequest$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group.</p>', 'DenyCustomRoutingTrafficRequest$EndpointId' => '<p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>', 'DeprovisionByoipCidrRequest$Cidr' => '<p>The address range, in CIDR notation. The prefix must be the same prefix that you specified when you provisioned the address range.</p>', 'DescribeAcceleratorAttributesRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the accelerator with the attributes that you want to describe.</p>', 'DescribeAcceleratorRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>', 'DescribeCustomRoutingAcceleratorAttributesRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the custom routing accelerator to describe the attributes for.</p>', 'DescribeCustomRoutingAcceleratorRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>', 'DescribeCustomRoutingEndpointGroupRequest$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>', 'DescribeCustomRoutingListenerRequest$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener to describe.</p>', 'DescribeEndpointGroupRequest$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>', 'DescribeListenerRequest$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener to describe.</p>', 'DestinationPortMapping$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the custom routing accelerator that you have port mappings for.</p>', 'DestinationPortMapping$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group.</p>', 'DestinationPortMapping$EndpointId' => '<p>The ID for the virtual private cloud (VPC) subnet.</p>', 'DestinationPortMapping$EndpointGroupRegion' => '<p>The AWS Region for the endpoint group.</p>', 'EndpointConfiguration$EndpointId' => '<p>An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. A resource must be valid and active when you add it as an endpoint.</p> <p>An Application Load Balancer can be either internal or internet-facing.</p>', 'EndpointDescription$EndpointId' => '<p>An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. </p> <p>An Application Load Balancer can be either internal or internet-facing.</p>', 'EndpointDescription$HealthReason' => '<p>Returns a null result.</p>', 'EndpointGroup$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group.</p>', 'EndpointGroup$EndpointGroupRegion' => '<p>The AWS Region where the endpoint group is located.</p>', 'EndpointIds$member' => NULL, 'IpSet$IpFamily' => '<p>The types of IP addresses included in this IP set.</p>', 'ListAcceleratorsRequest$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListAcceleratorsResponse$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListByoipCidrsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'ListByoipCidrsResponse$NextToken' => '<p>The token for the next page of results.</p>', 'ListCustomRoutingAcceleratorsRequest$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListCustomRoutingAcceleratorsResponse$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListCustomRoutingEndpointGroupsRequest$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener to list endpoint groups for.</p>', 'ListCustomRoutingEndpointGroupsRequest$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListCustomRoutingEndpointGroupsResponse$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListCustomRoutingListenersRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the accelerator to list listeners for.</p>', 'ListCustomRoutingListenersRequest$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListCustomRoutingListenersResponse$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListCustomRoutingPortMappingsByDestinationRequest$EndpointId' => '<p>The ID for the virtual private cloud (VPC) subnet.</p>', 'ListCustomRoutingPortMappingsByDestinationRequest$DestinationAddress' => '<p>The endpoint IP address in a virtual private cloud (VPC) subnet for which you want to receive back port mappings.</p>', 'ListCustomRoutingPortMappingsByDestinationRequest$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListCustomRoutingPortMappingsByDestinationResponse$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListCustomRoutingPortMappingsRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.</p>', 'ListCustomRoutingPortMappingsRequest$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for.</p>', 'ListCustomRoutingPortMappingsRequest$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListCustomRoutingPortMappingsResponse$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListEndpointGroupsRequest$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'ListEndpointGroupsRequest$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListEndpointGroupsResponse$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListListenersRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the accelerator for which you want to list listener objects.</p>', 'ListListenersRequest$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListListenersResponse$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'Listener$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener.</p>', 'PortMapping$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group.</p>', 'PortMapping$EndpointId' => '<p>The IP address of the VPC subnet (the subnet ID).</p>', 'ProvisionByoipCidrRequest$Cidr' => '<p>The public IPv4 address range, in CIDR notation. The most specific IP prefix that you can specify is /24. The address range cannot overlap with another address range that you\'ve brought to this or another Region.</p>', 'RemoveCustomRoutingEndpointsRequest$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.</p>', 'SocketAddress$IpAddress' => '<p>The IP address for the socket address.</p>', 'UpdateAcceleratorAttributesRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the accelerator that you want to update.</p>', 'UpdateAcceleratorAttributesRequest$FlowLogsS3Bucket' => '<p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the bucket.</p>', 'UpdateAcceleratorAttributesRequest$FlowLogsS3Prefix' => '<p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. </p> <p>If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p> <p>s3-bucket_name//AWSLogs/aws_account_id</p>', 'UpdateAcceleratorRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the accelerator to update.</p>', 'UpdateAcceleratorRequest$Name' => '<p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>', 'UpdateCustomRoutingAcceleratorAttributesRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.</p>', 'UpdateCustomRoutingAcceleratorAttributesRequest$FlowLogsS3Bucket' => '<p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the bucket.</p>', 'UpdateCustomRoutingAcceleratorAttributesRequest$FlowLogsS3Prefix' => '<p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. </p> <p>If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p> <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>', 'UpdateCustomRoutingAcceleratorRequest$AcceleratorArn' => '<p>The Amazon Resource Name (ARN) of the accelerator to update.</p>', 'UpdateCustomRoutingAcceleratorRequest$Name' => '<p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>', 'UpdateCustomRoutingListenerRequest$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener to update.</p>', 'UpdateEndpointGroupRequest$EndpointGroupArn' => '<p>The Amazon Resource Name (ARN) of the endpoint group.</p>', 'UpdateListenerRequest$ListenerArn' => '<p>The Amazon Resource Name (ARN) of the listener to update.</p>', 'WithdrawByoipCidrRequest$Cidr' => '<p>The address range, in CIDR notation.</p>', ], ], 'HealthCheckIntervalSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointGroupRequest$HealthCheckIntervalSeconds' => '<p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>', 'EndpointGroup$HealthCheckIntervalSeconds' => '<p>The time—10 seconds or 30 seconds—between health checks for each endpoint. The default value is 30.</p>', 'UpdateEndpointGroupRequest$HealthCheckIntervalSeconds' => '<p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>', ], ], 'HealthCheckPath' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointGroupRequest$HealthCheckPath' => '<p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (/).</p>', 'EndpointGroup$HealthCheckPath' => '<p>If the protocol is HTTP/S, then this value provides the ping path that Global Accelerator uses for the destination on the endpoints for health checks. The default is slash (/).</p>', 'UpdateEndpointGroupRequest$HealthCheckPath' => '<p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (/).</p>', ], ], 'HealthCheckPort' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointGroupRequest$HealthCheckPort' => '<p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the first port in the list.</p>', 'EndpointGroup$HealthCheckPort' => '<p>The port that Global Accelerator uses to perform health checks on endpoints that are part of this endpoint group. </p> <p>The default port is the port for the listener that this endpoint group is associated with. If the listener port is a list, Global Accelerator uses the first specified port in the list of ports.</p>', 'UpdateEndpointGroupRequest$HealthCheckPort' => '<p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If the listener port is a list of ports, Global Accelerator uses the first port in the list.</p>', ], ], 'HealthCheckProtocol' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointGroupRequest$HealthCheckProtocol' => '<p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP.</p>', 'EndpointGroup$HealthCheckProtocol' => '<p>The protocol that Global Accelerator uses to perform health checks on endpoints that are part of this endpoint group. The default value is TCP.</p>', 'UpdateEndpointGroupRequest$HealthCheckProtocol' => '<p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP.</p>', ], ], 'HealthState' => [ 'base' => NULL, 'refs' => [ 'EndpointDescription$HealthState' => '<p>The health status of the endpoint.</p>', ], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'CreateAcceleratorRequest$IdempotencyToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of an accelerator.</p>', 'CreateCustomRoutingAcceleratorRequest$IdempotencyToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>', 'CreateCustomRoutingEndpointGroupRequest$IdempotencyToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>', 'CreateCustomRoutingListenerRequest$IdempotencyToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>', 'CreateEndpointGroupRequest$IdempotencyToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>', 'CreateListenerRequest$IdempotencyToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>', ], ], 'IncorrectCidrStateException' => [ 'base' => '<p>The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be incorrect for this action.</p>', 'refs' => [], ], 'InternalServiceErrorException' => [ 'base' => '<p>There was an internal error for AWS Global Accelerator.</p>', 'refs' => [], ], 'InvalidArgumentException' => [ 'base' => '<p>An argument that you specified is invalid.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>There isn\'t another item to return.</p>', 'refs' => [], ], 'InvalidPortRangeException' => [ 'base' => '<p>The port numbers that you specified are not valid numbers or are not unique for this accelerator.</p>', 'refs' => [], ], 'IpAddress' => [ 'base' => NULL, 'refs' => [ 'DestinationAddresses$member' => NULL, 'IpAddresses$member' => NULL, ], ], 'IpAddressType' => [ 'base' => NULL, 'refs' => [ 'Accelerator$IpAddressType' => '<p>The value for the address type must be IPv4. </p>', 'CreateAcceleratorRequest$IpAddressType' => '<p>The value for the address type must be IPv4.</p>', 'CreateCustomRoutingAcceleratorRequest$IpAddressType' => '<p>The value for the address type must be IPv4.</p>', 'CustomRoutingAccelerator$IpAddressType' => '<p>The value for the address type must be IPv4.</p>', 'DestinationPortMapping$IpAddressType' => '<p>The IP address type, which must be IPv4.</p>', 'UpdateAcceleratorRequest$IpAddressType' => '<p>The IP address type, which must be IPv4.</p>', 'UpdateCustomRoutingAcceleratorRequest$IpAddressType' => '<p>The value for the address type must be IPv4.</p>', ], ], 'IpAddresses' => [ 'base' => NULL, 'refs' => [ 'CreateAcceleratorRequest$IpAddresses' => '<p>Optionally, if you\'ve added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses from your own pool to use for the accelerator\'s static IP addresses when you create an accelerator. You can specify one or two addresses, separated by a space. Do not include the /32 suffix.</p> <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only one IP address from your IP address range, Global Accelerator assigns a second static IP address for the accelerator from the AWS IP address pool.</p> <p>Note that you can\'t update IP addresses for an existing accelerator. To change them, you must create a new accelerator with the new addresses.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'CreateCustomRoutingAcceleratorRequest$IpAddresses' => '<p>Optionally, if you\'ve added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses from your own pool to use for the accelerator\'s static IP addresses when you create an accelerator. You can specify one or two addresses, separated by a space. Do not include the /32 suffix.</p> <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only one IP address from your IP address range, Global Accelerator assigns a second static IP address for the accelerator from the AWS IP address pool.</p> <p>Note that you can\'t update IP addresses for an existing accelerator. To change them, you must create a new accelerator with the new addresses.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'IpSet$IpAddresses' => '<p>The array of IP addresses in the IP address set. An IP address set can have a maximum of two IP addresses.</p>', ], ], 'IpSet' => [ 'base' => '<p>A complex type for the set of IP addresses for an accelerator.</p>', 'refs' => [ 'IpSets$member' => NULL, ], ], 'IpSets' => [ 'base' => NULL, 'refs' => [ 'Accelerator$IpSets' => '<p>The static IP addresses that Global Accelerator associates with the accelerator.</p>', 'CustomRoutingAccelerator$IpSets' => '<p>The static IP addresses that Global Accelerator associates with the accelerator.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>Processing your request would cause you to exceed an AWS Global Accelerator limit.</p>', 'refs' => [], ], 'ListAcceleratorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAcceleratorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListByoipCidrsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListByoipCidrsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomRoutingAcceleratorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomRoutingAcceleratorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomRoutingEndpointGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomRoutingEndpointGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomRoutingListenersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomRoutingListenersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomRoutingPortMappingsByDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomRoutingPortMappingsByDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomRoutingPortMappingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomRoutingPortMappingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListListenersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListListenersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Listener' => [ 'base' => '<p>A complex type for a listener.</p>', 'refs' => [ 'CreateListenerResponse$Listener' => '<p>The listener that you\'ve created.</p>', 'DescribeListenerResponse$Listener' => '<p>The description of a listener.</p>', 'Listeners$member' => NULL, 'UpdateListenerResponse$Listener' => '<p>Information for the updated listener.</p>', ], ], 'ListenerNotFoundException' => [ 'base' => '<p>The listener that you specified doesn\'t exist.</p>', 'refs' => [], ], 'Listeners' => [ 'base' => NULL, 'refs' => [ 'ListListenersResponse$Listeners' => '<p>The list of listeners for an accelerator.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAcceleratorsRequest$MaxResults' => '<p>The number of Global Accelerator objects that you want to return with this call. The default value is 10.</p>', 'ListByoipCidrsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'ListCustomRoutingAcceleratorsRequest$MaxResults' => '<p>The number of custom routing Global Accelerator objects that you want to return with this call. The default value is 10.</p>', 'ListCustomRoutingEndpointGroupsRequest$MaxResults' => '<p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>', 'ListCustomRoutingListenersRequest$MaxResults' => '<p>The number of listener objects that you want to return with this call. The default value is 10.</p>', 'ListEndpointGroupsRequest$MaxResults' => '<p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>', 'ListListenersRequest$MaxResults' => '<p>The number of listener objects that you want to return with this call. The default value is 10.</p>', ], ], 'PortMapping' => [ 'base' => '<p>Returns the ports and associated IP addresses and ports of Amazon EC2 instances in your virtual private cloud (VPC) subnets. Custom routing is a port mapping protocol in AWS Global Accelerator that statically associates port ranges with VPC subnets, which allows Global Accelerator to route to specific instances and ports within one or more subnets. </p>', 'refs' => [ 'PortMappings$member' => NULL, ], ], 'PortMappings' => [ 'base' => NULL, 'refs' => [ 'ListCustomRoutingPortMappingsResponse$PortMappings' => '<p>The port mappings for a custom routing accelerator.</p>', ], ], 'PortMappingsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCustomRoutingPortMappingsByDestinationRequest$MaxResults' => '<p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>', 'ListCustomRoutingPortMappingsRequest$MaxResults' => '<p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>', ], ], 'PortNumber' => [ 'base' => NULL, 'refs' => [ 'CustomRoutingDestinationConfiguration$FromPort' => '<p>The first port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>', 'CustomRoutingDestinationConfiguration$ToPort' => '<p>The last port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>', 'CustomRoutingDestinationDescription$FromPort' => '<p>The first port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>', 'CustomRoutingDestinationDescription$ToPort' => '<p>The last port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>', 'DestinationPorts$member' => NULL, 'PortMapping$AcceleratorPort' => '<p>The accelerator port.</p>', 'PortOverride$ListenerPort' => '<p>The listener port that you want to map to a specific endpoint port. This is the port that user traffic arrives to the Global Accelerator on.</p>', 'PortOverride$EndpointPort' => '<p>The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint, such as the Application Load Balancer or Amazon EC2 instance.</p>', 'PortRange$FromPort' => '<p>The first port in the range of ports, inclusive.</p>', 'PortRange$ToPort' => '<p>The last port in the range of ports, inclusive.</p>', 'SocketAddress$Port' => '<p>The port for the socket address.</p>', ], ], 'PortOverride' => [ 'base' => '<p>Override specific listener ports used to route traffic to endpoints that are part of an endpoint group. For example, you can create a port override in which the listener receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080 and 1443, respectively, on the endpoints.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html"> Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'refs' => [ 'PortOverrides$member' => NULL, ], ], 'PortOverrides' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointGroupRequest$PortOverrides' => '<p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. For example, you can create a port override in which the listener receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080 and 1443, respectively, on the endpoints.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html"> Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'EndpointGroup$PortOverrides' => '<p>Allows you to override the destination ports used to route traffic to an endpoint. Using a port override lets you to map a list of external destination ports (that your users send traffic to) to a list of internal destination ports that you want an application endpoint to receive traffic on. </p>', 'UpdateEndpointGroupRequest$PortOverrides' => '<p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. For example, you can create a port override in which the listener receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080 and 1443, respectively, on the endpoints.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html"> Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', ], ], 'PortRange' => [ 'base' => '<p>A complex type for a range of ports for a listener.</p>', 'refs' => [ 'PortRanges$member' => NULL, ], ], 'PortRanges' => [ 'base' => NULL, 'refs' => [ 'CreateCustomRoutingListenerRequest$PortRanges' => '<p>The port range to support for connections from clients to your accelerator.</p> <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About endpoints for custom routing accelerators</a>.</p>', 'CreateListenerRequest$PortRanges' => '<p>The list of port ranges to support for connections from clients to your accelerator.</p>', 'CustomRoutingListener$PortRanges' => '<p>The port range to support for connections from clients to your accelerator.</p> <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About endpoints for custom routing accelerators</a>.</p>', 'Listener$PortRanges' => '<p>The list of port ranges for the connections from clients to the accelerator.</p>', 'UpdateCustomRoutingListenerRequest$PortRanges' => '<p>The updated port range to support for connections from clients to your accelerator. If you remove ports that are currently being used by a subnet endpoint, the call fails.</p> <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About endpoints for custom routing accelerators</a>.</p>', 'UpdateListenerRequest$PortRanges' => '<p>The updated list of port ranges for the connections from clients to the accelerator.</p>', ], ], 'Protocol' => [ 'base' => NULL, 'refs' => [ 'CreateListenerRequest$Protocol' => '<p>The protocol for connections from clients to your accelerator.</p>', 'Listener$Protocol' => '<p>The protocol for the connections from clients to the accelerator.</p>', 'Protocols$member' => NULL, 'UpdateListenerRequest$Protocol' => '<p>The updated protocol for the connections from clients to the accelerator.</p>', ], ], 'Protocols' => [ 'base' => NULL, 'refs' => [ 'CustomRoutingDestinationDescription$Protocols' => '<p>The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either TCP or UDP.</p>', ], ], 'ProvisionByoipCidrRequest' => [ 'base' => NULL, 'refs' => [], ], 'ProvisionByoipCidrResponse' => [ 'base' => NULL, 'refs' => [], ], 'RemoveCustomRoutingEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the accelerator to list tags for. An ARN uniquely identifies an accelerator.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Global Accelerator resource to add tags to. An ARN uniquely identifies a resource.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Global Accelerator resource to remove tags from. An ARN uniquely identifies a resource.</p>', ], ], 'SocketAddress' => [ 'base' => '<p>An IP address/port combination.</p>', 'refs' => [ 'DestinationPortMapping$DestinationSocketAddress' => '<p>The endpoint IP address/port combination for traffic received on the accelerator socket address.</p>', 'PortMapping$DestinationSocketAddress' => '<p>The EC2 instance IP address and port number in the virtual private cloud (VPC) subnet.</p>', 'SocketAddresses$member' => NULL, ], ], 'SocketAddresses' => [ 'base' => NULL, 'refs' => [ 'DestinationPortMapping$AcceleratorSocketAddresses' => '<p>The IP address/port combinations (sockets) that map to a given destination socket address.</p>', ], ], 'Tag' => [ 'base' => '<p>A complex type that contains a <code>Tag</code> key and <code>Tag</code> value.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>A string that contains a <code>Tag</code> key.</p>', 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag key pairs that you want to remove from the specified resources.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>A string that contains a <code>Tag</code> value.</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateAcceleratorRequest$Tags' => '<p>Create tags for an accelerator.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'CreateCustomRoutingAcceleratorRequest$Tags' => '<p>Create tags for an accelerator.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Root level tag for the Tags parameters.</p>', 'TagResourceRequest$Tags' => '<p>The tags to add to a resource. A tag consists of a key and a value that you define.</p>', ], ], 'ThresholdCount' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointGroupRequest$ThresholdCount' => '<p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.</p>', 'EndpointGroup$ThresholdCount' => '<p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.</p>', 'UpdateEndpointGroupRequest$ThresholdCount' => '<p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Accelerator$CreatedTime' => '<p>The date and time that the accelerator was created.</p>', 'Accelerator$LastModifiedTime' => '<p>The date and time that the accelerator was last modified.</p>', 'ByoipCidrEvent$Timestamp' => '<p>A timestamp when you make a status change for an IP address range that you bring to AWS Global Accelerator through bring your own IP address (BYOIP).</p>', 'CustomRoutingAccelerator$CreatedTime' => '<p>The date and time that the accelerator was created.</p>', 'CustomRoutingAccelerator$LastModifiedTime' => '<p>The date and time that the accelerator was last modified.</p>', ], ], 'TrafficDialPercentage' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointGroupRequest$TrafficDialPercentage' => '<p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener. </p> <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p> <p>The default value is 100.</p>', 'EndpointGroup$TrafficDialPercentage' => '<p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener. </p> <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p> <p>The default value is 100.</p>', 'UpdateEndpointGroupRequest$TrafficDialPercentage' => '<p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener. </p> <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p> <p>The default value is 100.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAcceleratorAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAcceleratorAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAcceleratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAcceleratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCustomRoutingAcceleratorAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCustomRoutingAcceleratorAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCustomRoutingAcceleratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCustomRoutingAcceleratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCustomRoutingListenerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCustomRoutingListenerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateListenerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateListenerResponse' => [ 'base' => NULL, 'refs' => [], ], 'WithdrawByoipCidrRequest' => [ 'base' => NULL, 'refs' => [], ], 'WithdrawByoipCidrResponse' => [ 'base' => NULL, 'refs' => [], ], ],];
