<?php
// This file was auto-generated from sdk-root/src/data/honeycode/2020-03-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> Amazon Honeycode is a fully managed service that allows you to quickly build mobile and web apps for teams—without programming. Build Honeycode apps for managing almost anything, like projects, customers, operations, approvals, resources, and even your team. </p>', 'operations' => [ 'BatchCreateTableRows' => '<p> The BatchCreateTableRows API allows you to create one or more rows at the end of a table in a workbook. The API allows you to specify the values to set in some or all of the columns in the new rows. </p> <p> If a column is not explicitly set in a specific row, then the column level formula specified in the table will be applied to the new row. If there is no column level formula but the last row of the table has a formula, then that formula will be copied down to the new row. If there is no column level formula and no formula in the last row of the table, then that column will be left blank for the new rows. </p>', 'BatchDeleteTableRows' => '<p> The BatchDeleteTableRows API allows you to delete one or more rows from a table in a workbook. You need to specify the ids of the rows that you want to delete from the table. </p>', 'BatchUpdateTableRows' => '<p> The BatchUpdateTableRows API allows you to update one or more rows in a table in a workbook. </p> <p> You can specify the values to set in some or all of the columns in the table for the specified rows. If a column is not explicitly specified in a particular row, then that column will not be updated for that row. To clear out the data in a specific cell, you need to set the value as an empty string (""). </p>', 'BatchUpsertTableRows' => '<p> The BatchUpsertTableRows API allows you to upsert one or more rows in a table. The upsert operation takes a filter expression as input and evaluates it to find matching rows on the destination table. If matching rows are found, it will update the cells in the matching rows to new values specified in the request. If no matching rows are found, a new row is added at the end of the table and the cells in that row are set to the new values specified in the request. </p> <p> You can specify the values to set in some or all of the columns in the table for the matching or newly appended rows. If a column is not explicitly specified for a particular row, then that column will not be updated for that row. To clear out the data in a specific cell, you need to set the value as an empty string (""). </p>', 'DescribeTableDataImportJob' => '<p> The DescribeTableDataImportJob API allows you to retrieve the status and details of a table data import job. </p>', 'GetScreenData' => '<p> The GetScreenData API allows retrieval of data from a screen in a Honeycode app. The API allows setting local variables in the screen to filter, sort or otherwise affect what will be displayed on the screen. </p>', 'InvokeScreenAutomation' => '<p> The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app. The API allows setting local variables, which can then be used in the automation being invoked. This allows automating the Honeycode app interactions to write, update or delete data in the workbook. </p>', 'ListTableColumns' => '<p> The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook. </p>', 'ListTableRows' => '<p> The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook. </p>', 'ListTables' => '<p> The ListTables API allows you to retrieve a list of all the tables in a workbook. </p>', 'ListTagsForResource' => '<p> The ListTagsForResource API allows you to return a resource\'s tags. </p>', 'QueryTableRows' => '<p> The QueryTableRows API allows you to use a filter formula to query for specific rows in a table. </p>', 'StartTableDataImportJob' => '<p> The StartTableDataImportJob API allows you to start an import job on a table. This API will only return the id of the job that was started. To find out the status of the import request, you need to call the DescribeTableDataImportJob API. </p>', 'TagResource' => '<p> The TagResource API allows you to add tags to an ARN-able resource. Resource includes workbook, table, screen and screen-automation. </p>', 'UntagResource' => '<p> The UntagResource API allows you to removes tags from an ARN-able resource. Resource includes workbook, table, screen and screen-automation. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p> You do not have sufficient access to perform this action. Check that the workbook is owned by you and your IAM policy allows access to the resource in the request. </p>', 'refs' => [], ], 'AutomationExecutionException' => [ 'base' => '<p>The automation execution did not end successfully.</p>', 'refs' => [], ], 'AutomationExecutionTimeoutException' => [ 'base' => '<p>The automation execution timed out.</p>', 'refs' => [], ], 'AwsUserArn' => [ 'base' => NULL, 'refs' => [ 'ImportJobSubmitter$userArn' => '<p>The AWS user ARN of the submitter of the import job, if available.</p>', ], ], 'BatchCreateTableRowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreateTableRowsResult' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteTableRowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteTableRowsResult' => [ 'base' => NULL, 'refs' => [], ], 'BatchErrorMessage' => [ 'base' => NULL, 'refs' => [ 'FailedBatchItem$errorMessage' => '<p> The error message that indicates why the batch item failed. </p>', ], ], 'BatchItemId' => [ 'base' => NULL, 'refs' => [ 'CreateRowData$batchItemId' => '<p> An external identifier that represents the single row that is being created as part of the BatchCreateTableRows request. This can be any string that you can use to identify the row in the request. The BatchCreateTableRows API puts the batch item id in the results to allow you to link data in the request to data in the results. </p>', 'CreatedRowsMap$key' => NULL, 'FailedBatchItem$id' => '<p> The id of the batch item that failed. This is the batch item id for the BatchCreateTableRows and BatchUpsertTableRows operations and the row id for the BatchUpdateTableRows and BatchDeleteTableRows operations. </p>', 'UpsertRowData$batchItemId' => '<p> An external identifier that represents a single item in the request that is being upserted as part of the BatchUpsertTableRows request. This can be any string that you can use to identify the item in the request. The BatchUpsertTableRows API puts the batch item id in the results to allow you to link data in the request to data in the results. </p>', 'UpsertRowsResultMap$key' => NULL, ], ], 'BatchUpdateTableRowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateTableRowsResult' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpsertTableRowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpsertTableRowsResult' => [ 'base' => NULL, 'refs' => [], ], 'Cell' => [ 'base' => '<p>An object that represents a single cell in a table.</p>', 'refs' => [ 'Cells$member' => NULL, ], ], 'CellInput' => [ 'base' => '<p> CellInput object contains the data needed to create or update cells in a table. </p> <note> <p> CellInput object has only a facts field or a fact field, but not both. A 400 bad request will be thrown if both fact and facts field are present. </p> </note>', 'refs' => [ 'RowDataInput$value' => NULL, ], ], 'Cells' => [ 'base' => NULL, 'refs' => [ 'TableRow$cells' => '<p>A list of cells in the table row. The cells appear in the same order as the columns of the table. </p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'BatchCreateTableRowsRequest$clientRequestToken' => '<p> The request token for performing the batch create operation. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the operation again. </p> <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>', 'BatchDeleteTableRowsRequest$clientRequestToken' => '<p> The request token for performing the delete action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p> <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>', 'BatchUpdateTableRowsRequest$clientRequestToken' => '<p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p> <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>', 'BatchUpsertTableRowsRequest$clientRequestToken' => '<p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p> <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>', 'InvokeScreenAutomationRequest$clientRequestToken' => '<p> The request token for performing the automation action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will return the response of the previous call rather than performing the action again. </p> <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>', 'StartTableDataImportJobRequest$clientRequestToken' => '<p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p> <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>', ], ], 'ColumnMetadata' => [ 'base' => '<p>Metadata for column in the table.</p>', 'refs' => [ 'ResultHeader$member' => NULL, ], ], 'CreateRowData' => [ 'base' => '<p> Data needed to create a single row in a table as part of the BatchCreateTableRows request. </p>', 'refs' => [ 'CreateRowDataList$member' => NULL, ], ], 'CreateRowDataList' => [ 'base' => NULL, 'refs' => [ 'BatchCreateTableRowsRequest$rowsToCreate' => '<p> The list of rows to create at the end of the table. Each item in this list needs to have a batch item id to uniquely identify the element in the request and the cells to create for that row. You need to specify at least one item in this list. </p> <p> Note that if one of the column ids in any of the rows in the request does not exist in the table, then the request fails and no updates are made to the table. </p>', ], ], 'CreatedRowsMap' => [ 'base' => NULL, 'refs' => [ 'BatchCreateTableRowsResult$createdRows' => '<p>The map of batch item id to the row id that was created for that item.</p>', ], ], 'DataItem' => [ 'base' => '<p>The data in a particular data cell defined on the screen.</p>', 'refs' => [ 'DataItems$member' => NULL, ], ], 'DataItems' => [ 'base' => NULL, 'refs' => [ 'ResultRow$dataItems' => '<p>List of all the data cells in a row.</p>', ], ], 'DelimitedTextDelimiter' => [ 'base' => NULL, 'refs' => [ 'DelimitedTextImportOptions$delimiter' => '<p>The delimiter to use for separating columns in a single row of the input.</p>', ], ], 'DelimitedTextImportOptions' => [ 'base' => '<p> An object that contains the options relating to parsing delimited text as part of an import request. </p>', 'refs' => [ 'ImportOptions$delimitedTextOptions' => '<p>Options relating to parsing delimited text. Required if dataFormat is DELIMITED_TEXT.</p>', ], ], 'DescribeTableDataImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTableDataImportJobResult' => [ 'base' => NULL, 'refs' => [], ], 'DestinationOptions' => [ 'base' => '<p>An object that contains the options relating to the destination of the import request.</p>', 'refs' => [ 'ImportOptions$destinationOptions' => '<p>Options relating to the destination of the import request.</p>', ], ], 'Email' => [ 'base' => NULL, 'refs' => [ 'ImportJobSubmitter$email' => '<p>The email id of the submitter of the import job, if available.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'DescribeTableDataImportJobResult$errorCode' => '<p> If job status is failed, error code to understand reason for the failure. </p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AutomationExecutionException$message' => NULL, 'AutomationExecutionTimeoutException$message' => NULL, 'InternalServerException$message' => NULL, 'RequestTimeoutException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ServiceUnavailableException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'Fact' => [ 'base' => NULL, 'refs' => [ 'CellInput$fact' => '<p> Fact represents the data that is entered into a cell. This data can be free text or a formula. Formulas need to start with the equals (=) sign. </p>', 'FactList$member' => NULL, ], ], 'FactList' => [ 'base' => NULL, 'refs' => [ 'CellInput$facts' => '<p> A list representing the values that are entered into a ROWSET cell. Facts list can have either only values or rowIDs, and rowIDs should from the same table. </p>', ], ], 'FailedBatchItem' => [ 'base' => '<p> A single item in a batch that failed to perform the intended action because of an error preventing it from succeeding. </p>', 'refs' => [ 'FailedBatchItems$member' => NULL, ], ], 'FailedBatchItems' => [ 'base' => NULL, 'refs' => [ 'BatchCreateTableRowsResult$failedBatchItems' => '<p> The list of batch items in the request that could not be added to the table. Each element in this list contains one item from the request that could not be added to the table along with the reason why that item could not be added. </p>', 'BatchDeleteTableRowsResult$failedBatchItems' => '<p> The list of row ids in the request that could not be deleted from the table. Each element in this list contains one row id from the request that could not be deleted along with the reason why that item could not be deleted. </p>', 'BatchUpdateTableRowsResult$failedBatchItems' => '<p> The list of batch items in the request that could not be updated in the table. Each element in this list contains one item from the request that could not be updated in the table along with the reason why that item could not be updated. </p>', 'BatchUpsertTableRowsResult$failedBatchItems' => '<p> The list of batch items in the request that could not be updated or appended in the table. Each element in this list contains one item from the request that could not be updated in the table along with the reason why that item could not be updated or appended. </p>', ], ], 'Filter' => [ 'base' => '<p> An object that represents a filter formula along with the id of the context row under which the filter function needs to evaluate. </p>', 'refs' => [ 'QueryTableRowsRequest$filterFormula' => '<p>An object that represents a filter formula along with the id of the context row under which the filter function needs to evaluate.</p>', 'UpsertRowData$filter' => '<p> The filter formula to use to find existing matching rows to update. The formula needs to return zero or more rows. If the formula returns 0 rows, then a new row will be appended in the target table. If the formula returns one or more rows, then the returned rows will be updated. </p> <p> Note that the filter formula needs to return rows from the target table for the upsert operation to succeed. If the filter formula has a syntax error or it doesn\'t evaluate to zero or more rows in the target table for any one item in the input list, then the entire BatchUpsertTableRows request fails and no updates are made to the table. </p>', ], ], 'Format' => [ 'base' => NULL, 'refs' => [ 'Cell$format' => '<p>The format of the cell. If this field is empty, then the format is either not specified in the workbook or the format is set to AUTO.</p>', 'ColumnMetadata$format' => '<p>The format of the column.</p>', 'DataItem$overrideFormat' => '<p> The overrideFormat is optional and is specified only if a particular row of data has a different format for the data than the default format defined on the screen or the table. </p>', 'TableColumn$format' => '<p> The column level format that is applied in the table. An empty value in this field means that the column format is the default value \'AUTO\'. </p>', ], ], 'FormattedValue' => [ 'base' => NULL, 'refs' => [ 'Cell$formattedValue' => '<p> The formatted value of the cell. This is the value that you see displayed in the cell in the UI. </p> <p> Note that the formatted value of a cell is always represented as a string irrespective of the data that is stored in the cell. For example, if a cell contains a date, the formatted value of the cell is the string representation of the formatted date being shown in the cell in the UI. See details in the rawValue field below for how cells of different formats will have different raw and formatted values. </p>', 'DataItem$formattedValue' => '<p>The formatted value of the data. e.g. John Smith.</p>', 'FormattedValuesList$member' => NULL, ], ], 'FormattedValuesList' => [ 'base' => NULL, 'refs' => [ 'Cell$formattedValues' => '<p> A list of formatted values of the cell. This field is only returned when the cell is ROWSET format (aka multi-select or multi-record picklist). Values in the list are always represented as strings. The formattedValue field will be empty if this field is returned. </p>', ], ], 'Formula' => [ 'base' => NULL, 'refs' => [ 'Cell$formula' => '<p> The formula contained in the cell. This field is empty if a cell does not have a formula. </p>', 'Filter$formula' => '<p> A formula representing a filter function that returns zero or more matching rows from a table. Valid formulas in this field return a list of rows from a table. The most common ways of writing a formula to return a list of rows are to use the FindRow() or Filter() functions. Any other formula that returns zero or more rows is also acceptable. For example, you can use a formula that points to a cell that contains a filter function. </p>', ], ], 'GetScreenDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetScreenDataResult' => [ 'base' => NULL, 'refs' => [], ], 'HasHeaderRow' => [ 'base' => NULL, 'refs' => [ 'DelimitedTextImportOptions$hasHeaderRow' => '<p>Indicates whether the input file has a header row at the top containing the column names.</p>', ], ], 'IgnoreEmptyRows' => [ 'base' => NULL, 'refs' => [ 'DelimitedTextImportOptions$ignoreEmptyRows' => '<p>A parameter to indicate whether empty rows should be ignored or be included in the import.</p>', ], ], 'ImportColumnMap' => [ 'base' => NULL, 'refs' => [ 'DestinationOptions$columnMap' => '<p>A map of the column id to the import properties for each column.</p>', ], ], 'ImportDataCharacterEncoding' => [ 'base' => NULL, 'refs' => [ 'DelimitedTextImportOptions$dataCharacterEncoding' => '<p>The encoding of the data in the input file.</p>', ], ], 'ImportDataSource' => [ 'base' => '<p>An object that has details about the source of the data that was submitted for import.</p>', 'refs' => [ 'StartTableDataImportJobRequest$dataSource' => '<p> The source of the data that is being imported. The size of source must be no larger than 100 MB. Source must have no more than 100,000 cells and no more than 1,000 rows. </p>', 'TableDataImportJobMetadata$dataSource' => '<p>The source of the data that was submitted for import.</p>', ], ], 'ImportDataSourceConfig' => [ 'base' => '<p> An object that contains the configuration parameters for the data source of an import request. </p>', 'refs' => [ 'ImportDataSource$dataSourceConfig' => '<p>The configuration parameters for the data source of the import</p>', ], ], 'ImportJobSubmitter' => [ 'base' => '<p>An object that contains the attributes of the submitter of the import job.</p>', 'refs' => [ 'TableDataImportJobMetadata$submitter' => '<p>Details about the submitter of the import request.</p>', ], ], 'ImportOptions' => [ 'base' => '<p>An object that contains the options specified by the sumitter of the import request.</p>', 'refs' => [ 'StartTableDataImportJobRequest$importOptions' => '<p> The options for customizing this import request. </p>', 'TableDataImportJobMetadata$importOptions' => '<p>The options that was specified at the time of submitting the import request.</p>', ], ], 'ImportSourceDataFormat' => [ 'base' => NULL, 'refs' => [ 'StartTableDataImportJobRequest$dataFormat' => '<p> The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT". </p>', ], ], 'InternalServerException' => [ 'base' => '<p>There were unexpected errors from the server.</p>', 'refs' => [], ], 'InvokeScreenAutomationRequest' => [ 'base' => NULL, 'refs' => [], ], 'InvokeScreenAutomationResult' => [ 'base' => NULL, 'refs' => [], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'DescribeTableDataImportJobRequest$jobId' => '<p>The ID of the job that was returned by the StartTableDataImportJob request.</p> <p> If a job with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'StartTableDataImportJobResult$jobId' => '<p> The id that is assigned to this import job. Future requests to find out the status of this import job need to send this id in the appropriate parameter in the request. </p>', ], ], 'ListTableColumnsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTableColumnsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListTableRowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTableRowsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListTablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTablesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetScreenDataRequest$maxResults' => '<p> The number of results to be returned on a single page. Specify a number between 1 and 100. The maximum value is 100. </p> <p> This parameter is optional. If you don\'t specify this parameter, the default page size is 100. </p>', 'ListTableRowsRequest$maxResults' => '<p>The maximum number of rows to return in each page of the results.</p>', 'ListTablesRequest$maxResults' => '<p>The maximum number of tables to return in each page of the results.</p>', 'QueryTableRowsRequest$maxResults' => '<p>The maximum number of rows to return in each page of the results.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'ColumnMetadata$name' => '<p>The name of the column.</p>', 'ResultSetMap$key' => NULL, ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'GetScreenDataRequest$nextToken' => '<p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p> <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>', 'GetScreenDataResult$nextToken' => '<p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the query has been loaded. </p>', 'ListTableColumnsRequest$nextToken' => '<p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p> <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>', 'ListTableColumnsResult$nextToken' => '<p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>', 'ListTableRowsRequest$nextToken' => '<p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p> <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>', 'ListTableRowsResult$nextToken' => '<p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>', 'ListTablesRequest$nextToken' => '<p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p> <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>', 'ListTablesResult$nextToken' => '<p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>', 'QueryTableRowsRequest$nextToken' => '<p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p> <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>', 'QueryTableRowsResult$nextToken' => '<p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>', ], ], 'QueryTableRowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'QueryTableRowsResult' => [ 'base' => NULL, 'refs' => [], ], 'RawValue' => [ 'base' => NULL, 'refs' => [ 'Cell$rawValue' => '<p> The raw value of the data contained in the cell. The raw value depends on the format of the data in the cell. However the attribute in the API return value is always a string containing the raw value. </p> <p> Cells with format DATE, DATE_TIME or TIME have the raw value as a floating point number where the whole number represents the number of days since 1/1/1900 and the fractional part represents the fraction of the day since midnight. For example, a cell with date 11/3/2020 has the raw value "44138". A cell with the time 9:00 AM has the raw value "0.375" and a cell with date/time value of 11/3/2020 9:00 AM has the raw value "44138.375". Notice that even though the raw value is a number in all three cases, it is still represented as a string. </p> <p> Cells with format NUMBER, CURRENCY, PERCENTAGE and ACCOUNTING have the raw value of the data as the number representing the data being displayed. For example, the number 1.325 with two decimal places in the format will have it\'s raw value as "1.325" and formatted value as "1.33". A currency value for $10 will have the raw value as "10" and formatted value as "$10.00". A value representing 20% with two decimal places in the format will have its raw value as "0.2" and the formatted value as "20.00%". An accounting value of -$25 will have "-25" as the raw value and "$ (25.00)" as the formatted value. </p> <p> Cells with format TEXT will have the raw text as the raw value. For example, a cell with text "John Smith" will have "John Smith" as both the raw value and the formatted value. </p> <p> Cells with format CONTACT will have the name of the contact as a formatted value and the email address of the contact as the raw value. For example, a contact for John Smith will have "John Smith" as the formatted value and "john.smith@example.com" as the raw value. </p> <p> Cells with format ROWLINK (aka picklist) will have the first column of the linked row as the formatted value and the row id of the linked row as the raw value. For example, a cell containing a picklist to a table that displays task status might have "Completed" as the formatted value and "row:dfcefaee-5b37-4355-8f28-40c3e4ff5dd4/ca432b2f-b8eb-431d-9fb5-cbe0342f9f03" as the raw value. </p> <p> Cells with format ROWSET (aka multi-select or multi-record picklist) will by default have the first column of each of the linked rows as the formatted value in the list, and the rowset id of the linked rows as the raw value. For example, a cell containing a multi-select picklist to a table that contains items might have "Item A", "Item B" in the formatted value list and "rows:b742c1f4-6cb0-4650-a845-35eb86fcc2bb/ [fdea123b-8f68-474a-aa8a-5ff87aa333af,6daf41f0-a138-4eee-89da-123086d36ecf]" as the raw value. </p> <p> Cells with format ATTACHMENT will have the name of the attachment as the formatted value and the attachment id as the raw value. For example, a cell containing an attachment named "image.jpeg" will have "image.jpeg" as the formatted value and "attachment:ca432b2f-b8eb-431d-9fb5-cbe0342f9f03" as the raw value. </p> <p> Cells with format AUTO or cells without any format that are auto-detected as one of the formats above will contain the raw and formatted values as mentioned above, based on the auto-detected formats. If there is no auto-detected format, the raw and formatted values will be the same as the data in the cell. </p>', 'DataItem$rawValue' => '<p>The raw value of the data. e.g. jsmith@example.com</p>', 'VariableValue$rawValue' => '<p>Raw value of the variable.</p>', ], ], 'RequestTimeoutException' => [ 'base' => '<p>The request timed out.</p>', 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The resource\'s Amazon Resource Name (ARN).</p>', 'TagResourceRequest$resourceArn' => '<p>The resource\'s Amazon Resource Name (ARN).</p>', 'UntagResourceRequest$resourceArn' => '<p>The resource\'s Amazon Resource Name (ARN).</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'BatchCreateTableRowsRequest$workbookId' => '<p>The ID of the workbook where the new rows are being added.</p> <p> If a workbook with the specified ID could not be found, this API throws ResourceNotFoundException. </p>', 'BatchCreateTableRowsRequest$tableId' => '<p>The ID of the table where the new rows are being added.</p> <p> If a table with the specified ID could not be found, this API throws ResourceNotFoundException. </p>', 'BatchDeleteTableRowsRequest$workbookId' => '<p>The ID of the workbook where the rows are being deleted.</p> <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'BatchDeleteTableRowsRequest$tableId' => '<p>The ID of the table where the rows are being deleted.</p> <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'BatchUpdateTableRowsRequest$workbookId' => '<p>The ID of the workbook where the rows are being updated.</p> <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'BatchUpdateTableRowsRequest$tableId' => '<p>The ID of the table where the rows are being updated.</p> <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'BatchUpsertTableRowsRequest$workbookId' => '<p>The ID of the workbook where the rows are being upserted.</p> <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'BatchUpsertTableRowsRequest$tableId' => '<p>The ID of the table where the rows are being upserted.</p> <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'DescribeTableDataImportJobRequest$workbookId' => '<p>The ID of the workbook into which data was imported.</p> <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'DescribeTableDataImportJobRequest$tableId' => '<p>The ID of the table into which data was imported.</p> <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'GetScreenDataRequest$workbookId' => '<p>The ID of the workbook that contains the screen.</p>', 'GetScreenDataRequest$appId' => '<p>The ID of the app that contains the screen.</p>', 'GetScreenDataRequest$screenId' => '<p>The ID of the screen.</p>', 'ImportColumnMap$key' => NULL, 'InvokeScreenAutomationRequest$workbookId' => '<p>The ID of the workbook that contains the screen automation.</p>', 'InvokeScreenAutomationRequest$appId' => '<p>The ID of the app that contains the screen automation.</p>', 'InvokeScreenAutomationRequest$screenId' => '<p>The ID of the screen that contains the screen automation.</p>', 'InvokeScreenAutomationRequest$screenAutomationId' => '<p>The ID of the automation action to be performed.</p>', 'ListTableColumnsRequest$workbookId' => '<p>The ID of the workbook that contains the table whose columns are being retrieved.</p> <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'ListTableColumnsRequest$tableId' => '<p>The ID of the table whose columns are being retrieved.</p> <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'ListTableRowsRequest$workbookId' => '<p>The ID of the workbook that contains the table whose rows are being retrieved.</p> <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'ListTableRowsRequest$tableId' => '<p>The ID of the table whose rows are being retrieved.</p> <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'ListTablesRequest$workbookId' => '<p>The ID of the workbook whose tables are being retrieved.</p> <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'QueryTableRowsRequest$workbookId' => '<p>The ID of the workbook whose table rows are being queried.</p> <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'QueryTableRowsRequest$tableId' => '<p>The ID of the table whose rows are being queried.</p> <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'ResourceIds$member' => NULL, 'RowDataInput$key' => NULL, 'StartTableDataImportJobRequest$workbookId' => '<p>The ID of the workbook where the rows are being imported.</p> <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'StartTableDataImportJobRequest$destinationTableId' => '<p>The ID of the table where the rows are being imported.</p> <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>', 'Table$tableId' => '<p>The id of the table.</p>', 'TableColumn$tableColumnId' => '<p>The id of the column in the table.</p>', ], ], 'ResourceIds' => [ 'base' => NULL, 'refs' => [ 'ListTableRowsResult$columnIds' => '<p> The list of columns in the table whose row data is returned in the result. </p>', 'QueryTableRowsResult$columnIds' => '<p> The list of columns in the table whose row data is returned in the result. </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A Workbook, Table, App, Screen or Screen Automation was not found with the given ID.</p>', 'refs' => [], ], 'ResultHeader' => [ 'base' => NULL, 'refs' => [ 'ResultSet$headers' => '<p> List of headers for all the data cells in the block. The header identifies the name and default format of the data cell. Data cells appear in the same order in all rows as defined in the header. The names and formats are not repeated in the rows. If a particular row does not have a value for a data cell, a blank value is used. </p> <p> For example, a task list that displays the task name, due date and assigned person might have headers [ { "name": "Task Name"}, {"name": "Due Date", "format": "DATE"}, {"name": "Assigned", "format": "CONTACT"} ]. Every row in the result will have the task name as the first item, due date as the second item and assigned person as the third item. If a particular task does not have a due date, that row will still have a blank value in the second element and the assigned person will still be in the third element. </p>', ], ], 'ResultRow' => [ 'base' => '<p>A single row in the ResultSet.</p>', 'refs' => [ 'ResultRows$member' => NULL, ], ], 'ResultRows' => [ 'base' => NULL, 'refs' => [ 'ResultSet$rows' => '<p> List of rows returned by the request. Each row has a row Id and a list of data cells in that row. The data cells will be present in the same order as they are defined in the header. </p>', ], ], 'ResultSet' => [ 'base' => '<p> ResultSet contains the results of the request for a single block or list defined on the screen. </p>', 'refs' => [ 'ResultSetMap$value' => NULL, ], ], 'ResultSetMap' => [ 'base' => NULL, 'refs' => [ 'GetScreenDataResult$results' => '<p>A map of all the rows on the screen keyed by block name.</p>', ], ], 'RowDataInput' => [ 'base' => NULL, 'refs' => [ 'CreateRowData$cellsToCreate' => '<p> A map representing the cells to create in the new row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>', 'UpdateRowData$cellsToUpdate' => '<p> A map representing the cells to update in the given row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>', 'UpsertRowData$cellsToUpdate' => '<p> A map representing the cells to update for the matching rows or an appended row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>', ], ], 'RowId' => [ 'base' => NULL, 'refs' => [ 'CreatedRowsMap$value' => NULL, 'Filter$contextRowId' => '<p> The optional contextRowId attribute can be used to specify the row id of the context row if the filter formula contains unqualified references to table columns and needs a context row to evaluate them successfully. </p>', 'InvokeScreenAutomationRequest$rowId' => '<p> The row ID for the automation if the automation is defined inside a block with source or list. </p>', 'ResultRow$rowId' => '<p>The ID for a particular row.</p>', 'RowIdList$member' => NULL, 'TableRow$rowId' => '<p>The id of the row in the table.</p>', 'UpdateRowData$rowId' => '<p> The id of the row that needs to be updated. </p>', ], ], 'RowIdList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteTableRowsRequest$rowIds' => '<p> The list of row ids to delete from the table. You need to specify at least one row id in this list. </p> <p> Note that if one of the row ids provided in the request does not exist in the table, then the request fails and no rows are deleted from the table. </p>', 'ListTableRowsRequest$rowIds' => '<p> This parameter is optional. If one or more row ids are specified in this list, then only the specified row ids are returned in the result. If no row ids are specified here, then all the rows in the table are returned. </p>', 'ListTableRowsResult$rowIdsNotFound' => '<p> The list of row ids included in the request that were not found in the table. </p>', 'UpsertRowsResult$rowIds' => '<p> The list of row ids that were changed as part of an upsert row operation. If the upsert resulted in an update, this list could potentially contain multiple rows that matched the filter and hence got updated. If the upsert resulted in an append, this list would only have the single row that was appended. </p>', ], ], 'SecureURL' => [ 'base' => NULL, 'refs' => [ 'ImportDataSourceConfig$dataSourceUrl' => '<p> The URL from which source data will be downloaded for the import request. </p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p> The request caused service quota to be breached. </p>', 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>Remote service is unreachable.</p>', 'refs' => [], ], 'SourceDataColumnIndex' => [ 'base' => NULL, 'refs' => [ 'SourceDataColumnProperties$columnIndex' => '<p>The index of the column in the input file.</p>', ], ], 'SourceDataColumnProperties' => [ 'base' => '<p>An object that contains the properties for importing data to a specific column in a table.</p>', 'refs' => [ 'ImportColumnMap$value' => NULL, ], ], 'StartTableDataImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTableDataImportJobResult' => [ 'base' => NULL, 'refs' => [], ], 'Table' => [ 'base' => '<p>An object representing the properties of a table in a workbook.</p>', 'refs' => [ 'Tables$member' => NULL, ], ], 'TableColumn' => [ 'base' => '<p>An object that contains attributes about a single column in a table</p>', 'refs' => [ 'TableColumns$member' => NULL, ], ], 'TableColumnName' => [ 'base' => NULL, 'refs' => [ 'TableColumn$tableColumnName' => '<p>The name of the column in the table.</p>', ], ], 'TableColumns' => [ 'base' => NULL, 'refs' => [ 'ListTableColumnsResult$tableColumns' => '<p> The list of columns in the table. </p>', ], ], 'TableDataImportJobMessage' => [ 'base' => NULL, 'refs' => [ 'DescribeTableDataImportJobResult$message' => '<p> A message providing more details about the current status of the import job. </p>', ], ], 'TableDataImportJobMetadata' => [ 'base' => '<p>The metadata associated with the table data import job that was submitted.</p>', 'refs' => [ 'DescribeTableDataImportJobResult$jobMetadata' => '<p> The metadata about the job that was submitted for import. </p>', ], ], 'TableDataImportJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTableDataImportJobResult$jobStatus' => '<p> The current status of the import job. </p>', 'StartTableDataImportJobResult$jobStatus' => '<p> The status of the import job immediately after submitting the request. </p>', ], ], 'TableName' => [ 'base' => NULL, 'refs' => [ 'Table$tableName' => '<p>The name of the table.</p>', ], ], 'TableRow' => [ 'base' => '<p>An object that contains attributes about a single row in a table</p>', 'refs' => [ 'TableRows$member' => NULL, ], ], 'TableRows' => [ 'base' => NULL, 'refs' => [ 'ListTableRowsResult$rows' => '<p> The list of rows in the table. Note that this result is paginated, so this list contains a maximum of 100 rows. </p>', 'QueryTableRowsResult$rows' => '<p> The list of rows in the table that match the query filter. </p>', ], ], 'Tables' => [ 'base' => NULL, 'refs' => [ 'ListTablesResult$tables' => '<p> The list of tables in the workbook. </p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeysList$member' => NULL, 'TagsMap$key' => NULL, ], ], 'TagKeysList' => [ 'base' => '<p>A list of tag keys</p>', 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of tag keys to remove from the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagsMap$value' => NULL, ], ], 'TagsMap' => [ 'base' => '<p>A string to string map representing tags</p>', 'refs' => [ 'ListTagsForResourceResult$tags' => '<p>The resource\'s tags.</p>', 'TagResourceRequest$tags' => '<p>A list of tags to apply to the resource.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Tps(transactions per second) rate reached.</p>', 'refs' => [], ], 'TimestampInMillis' => [ 'base' => NULL, 'refs' => [ 'TableDataImportJobMetadata$submitTime' => '<p>The timestamp when the job was submitted for import.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRowData' => [ 'base' => '<p> Data needed to create a single row in a table as part of the BatchCreateTableRows request. </p>', 'refs' => [ 'UpdateRowDataList$member' => NULL, ], ], 'UpdateRowDataList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateTableRowsRequest$rowsToUpdate' => '<p> The list of rows to update in the table. Each item in this list needs to contain the row id to update along with the map of column id to cell values for each column in that row that needs to be updated. You need to specify at least one row in this list, and for each row, you need to specify at least one column to update. </p> <p> Note that if one of the row or column ids in the request does not exist in the table, then the request fails and no updates are made to the table. </p>', ], ], 'UpsertAction' => [ 'base' => NULL, 'refs' => [ 'UpsertRowsResult$upsertAction' => '<p> The result of the upsert action. </p>', ], ], 'UpsertRowData' => [ 'base' => '<p> Data needed to upsert rows in a table as part of a single item in the BatchUpsertTableRows request. </p>', 'refs' => [ 'UpsertRowDataList$member' => NULL, ], ], 'UpsertRowDataList' => [ 'base' => NULL, 'refs' => [ 'BatchUpsertTableRowsRequest$rowsToUpsert' => '<p> The list of rows to upsert in the table. Each item in this list needs to have a batch item id to uniquely identify the element in the request, a filter expression to find the rows to update for that element and the cell values to set for each column in the upserted rows. You need to specify at least one item in this list. </p> <p> Note that if one of the filter formulas in the request fails to evaluate because of an error or one of the column ids in any of the rows does not exist in the table, then the request fails and no updates are made to the table. </p>', ], ], 'UpsertRowsResult' => [ 'base' => '<p> An object that represents the result of a single upsert row request. </p>', 'refs' => [ 'UpsertRowsResultMap$value' => NULL, ], ], 'UpsertRowsResultMap' => [ 'base' => NULL, 'refs' => [ 'BatchUpsertTableRowsResult$rows' => '<p> A map with the batch item id as the key and the result of the upsert operation as the value. The result of the upsert operation specifies whether existing rows were updated or a new row was appended, along with the list of row ids that were affected. </p>', ], ], 'ValidationException' => [ 'base' => '<p> Request is invalid. The message in the response contains details on why the request is invalid. </p>', 'refs' => [], ], 'VariableName' => [ 'base' => NULL, 'refs' => [ 'VariableValueMap$key' => NULL, ], ], 'VariableValue' => [ 'base' => '<p>The input variables to the app to be used by the InvokeScreenAutomation action request.</p>', 'refs' => [ 'VariableValueMap$value' => NULL, ], ], 'VariableValueMap' => [ 'base' => NULL, 'refs' => [ 'GetScreenDataRequest$variables' => '<p> Variables are optional and are needed only if the screen requires them to render correctly. Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen. </p>', 'InvokeScreenAutomationRequest$variables' => '<p> Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen. Any variables defined in a screen are required to be passed in the call. </p>', ], ], 'WorkbookCursor' => [ 'base' => NULL, 'refs' => [ 'BatchCreateTableRowsResult$workbookCursor' => '<p>The updated workbook cursor after adding the new rows at the end of the table.</p>', 'BatchDeleteTableRowsResult$workbookCursor' => '<p>The updated workbook cursor after deleting the rows from the table.</p>', 'BatchUpdateTableRowsResult$workbookCursor' => '<p>The updated workbook cursor after adding the new rows at the end of the table.</p>', 'BatchUpsertTableRowsResult$workbookCursor' => '<p>The updated workbook cursor after updating or appending rows in the table.</p>', 'GetScreenDataResult$workbookCursor' => '<p> Indicates the cursor of the workbook at which the data returned by this workbook is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>', 'InvokeScreenAutomationResult$workbookCursor' => '<p>The updated workbook cursor after performing the automation action.</p>', 'ListTableColumnsResult$workbookCursor' => '<p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>', 'ListTableRowsResult$workbookCursor' => '<p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>', 'ListTablesResult$workbookCursor' => '<p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>', 'QueryTableRowsResult$workbookCursor' => '<p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>', ], ], ],];
