<?php
// This file was auto-generated from sdk-root/src/data/lex-models/2017-04-19/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Lex Build-Time Actions</fullname> <p> Amazon Lex is an AWS service for building conversational voice and text interfaces. Use these actions to create, update, and delete conversational bots for new and existing client applications. </p>', 'operations' => [ 'CreateBotVersion' => '<p>Creates a new version of the bot based on the <code>$LATEST</code> version. If the <code>$LATEST</code> version of this resource hasn\'t changed since you created the last version, Amazon Lex doesn\'t create a new version. It returns the last created version.</p> <note> <p>You can update only the <code>$LATEST</code> version of the bot. You can\'t update the numbered versions that you create with the <code>CreateBotVersion</code> operation.</p> </note> <p> When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1. For more information, see <a>versioning-intro</a>. </p> <p> This operation requires permission for the <code>lex:CreateBotVersion</code> action. </p>', 'CreateIntentVersion' => '<p>Creates a new version of an intent based on the <code>$LATEST</code> version of the intent. If the <code>$LATEST</code> version of this intent hasn\'t changed since you last updated it, Amazon Lex doesn\'t create a new version. It returns the last version you created.</p> <note> <p>You can update only the <code>$LATEST</code> version of the intent. You can\'t update the numbered versions that you create with the <code>CreateIntentVersion</code> operation.</p> </note> <p> When you create a version of an intent, Amazon Lex sets the version to 1. Subsequent versions increment by 1. For more information, see <a>versioning-intro</a>. </p> <p>This operation requires permissions to perform the <code>lex:CreateIntentVersion</code> action. </p>', 'CreateSlotTypeVersion' => '<p>Creates a new version of a slot type based on the <code>$LATEST</code> version of the specified slot type. If the <code>$LATEST</code> version of this resource has not changed since the last version that you created, Amazon Lex doesn\'t create a new version. It returns the last version that you created. </p> <note> <p>You can update only the <code>$LATEST</code> version of a slot type. You can\'t update the numbered versions that you create with the <code>CreateSlotTypeVersion</code> operation.</p> </note> <p>When you create a version of a slot type, Amazon Lex sets the version to 1. Subsequent versions increment by 1. For more information, see <a>versioning-intro</a>. </p> <p>This operation requires permissions for the <code>lex:CreateSlotTypeVersion</code> action.</p>', 'DeleteBot' => '<p>Deletes all versions of the bot, including the <code>$LATEST</code> version. To delete a specific version of the bot, use the <a>DeleteBotVersion</a> operation. The <code>DeleteBot</code> operation doesn\'t immediately remove the bot schema. Instead, it is marked for deletion and removed later.</p> <p>Amazon Lex stores utterances indefinitely for improving the ability of your bot to respond to user inputs. These utterances are not removed when the bot is deleted. To remove the utterances, use the <a>DeleteUtterances</a> operation.</p> <p>If a bot has an alias, you can\'t delete it. Instead, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code> exception that includes a reference to the alias that refers to the bot. To remove the reference to the bot, delete the alias. If you get the same exception again, delete the referring alias until the <code>DeleteBot</code> operation is successful.</p> <p>This operation requires permissions for the <code>lex:DeleteBot</code> action.</p>', 'DeleteBotAlias' => '<p>Deletes an alias for the specified bot. </p> <p>You can\'t delete an alias that is used in the association between a bot and a messaging channel. If an alias is used in a channel association, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code> exception that includes a reference to the channel association that refers to the bot. You can remove the reference to the alias by deleting the channel association. If you get the same exception again, delete the referring association until the <code>DeleteBotAlias</code> operation is successful.</p>', 'DeleteBotChannelAssociation' => '<p>Deletes the association between an Amazon Lex bot and a messaging platform.</p> <p>This operation requires permission for the <code>lex:DeleteBotChannelAssociation</code> action.</p>', 'DeleteBotVersion' => '<p>Deletes a specific version of a bot. To delete all versions of a bot, use the <a>DeleteBot</a> operation. </p> <p>This operation requires permissions for the <code>lex:DeleteBotVersion</code> action.</p>', 'DeleteIntent' => '<p>Deletes all versions of the intent, including the <code>$LATEST</code> version. To delete a specific version of the intent, use the <a>DeleteIntentVersion</a> operation.</p> <p> You can delete a version of an intent only if it is not referenced. To delete an intent that is referred to in one or more bots (see <a>how-it-works</a>), you must remove those references first. </p> <note> <p> If you get the <code>ResourceInUseException</code> exception, it provides an example reference that shows where the intent is referenced. To remove the reference to the intent, either update the bot or delete it. If you get the same exception when you attempt to delete the intent again, repeat until the intent has no references and the call to <code>DeleteIntent</code> is successful. </p> </note> <p> This operation requires permission for the <code>lex:DeleteIntent</code> action. </p>', 'DeleteIntentVersion' => '<p>Deletes a specific version of an intent. To delete all versions of a intent, use the <a>DeleteIntent</a> operation. </p> <p>This operation requires permissions for the <code>lex:DeleteIntentVersion</code> action.</p>', 'DeleteSlotType' => '<p>Deletes all versions of the slot type, including the <code>$LATEST</code> version. To delete a specific version of the slot type, use the <a>DeleteSlotTypeVersion</a> operation.</p> <p> You can delete a version of a slot type only if it is not referenced. To delete a slot type that is referred to in one or more intents, you must remove those references first. </p> <note> <p> If you get the <code>ResourceInUseException</code> exception, the exception provides an example reference that shows the intent where the slot type is referenced. To remove the reference to the slot type, either update the intent or delete it. If you get the same exception when you attempt to delete the slot type again, repeat until the slot type has no references and the <code>DeleteSlotType</code> call is successful. </p> </note> <p>This operation requires permission for the <code>lex:DeleteSlotType</code> action.</p>', 'DeleteSlotTypeVersion' => '<p>Deletes a specific version of a slot type. To delete all versions of a slot type, use the <a>DeleteSlotType</a> operation. </p> <p>This operation requires permissions for the <code>lex:DeleteSlotTypeVersion</code> action.</p>', 'DeleteUtterances' => '<p>Deletes stored utterances.</p> <p>Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the <a>GetUtterancesView</a> operation, and then stored indefinitely for use in improving the ability of your bot to respond to user input.</p> <p>Use the <code>DeleteUtterances</code> operation to manually delete stored utterances for a specific user. When you use the <code>DeleteUtterances</code> operation, utterances stored for improving your bot\'s ability to respond to user input are deleted immediately. Utterances stored for use with the <code>GetUtterancesView</code> operation are deleted after 15 days.</p> <p>This operation requires permissions for the <code>lex:DeleteUtterances</code> action.</p>', 'GetBot' => '<p>Returns metadata information for a specific bot. You must provide the bot name and the bot version or alias. </p> <p> This operation requires permissions for the <code>lex:GetBot</code> action. </p>', 'GetBotAlias' => '<p>Returns information about an Amazon Lex bot alias. For more information about aliases, see <a>versioning-aliases</a>.</p> <p>This operation requires permissions for the <code>lex:GetBotAlias</code> action.</p>', 'GetBotAliases' => '<p>Returns a list of aliases for a specified Amazon Lex bot.</p> <p>This operation requires permissions for the <code>lex:GetBotAliases</code> action.</p>', 'GetBotChannelAssociation' => '<p>Returns information about the association between an Amazon Lex bot and a messaging platform.</p> <p>This operation requires permissions for the <code>lex:GetBotChannelAssociation</code> action.</p>', 'GetBotChannelAssociations' => '<p> Returns a list of all of the channels associated with the specified bot. </p> <p>The <code>GetBotChannelAssociations</code> operation requires permissions for the <code>lex:GetBotChannelAssociations</code> action.</p>', 'GetBotVersions' => '<p>Gets information about all of the versions of a bot.</p> <p>The <code>GetBotVersions</code> operation returns a <code>BotMetadata</code> object for each version of a bot. For example, if a bot has three numbered versions, the <code>GetBotVersions</code> operation returns four <code>BotMetadata</code> objects in the response, one for each numbered version and one for the <code>$LATEST</code> version. </p> <p>The <code>GetBotVersions</code> operation always returns at least one version, the <code>$LATEST</code> version.</p> <p>This operation requires permissions for the <code>lex:GetBotVersions</code> action.</p>', 'GetBots' => '<p>Returns bot information as follows: </p> <ul> <li> <p>If you provide the <code>nameContains</code> field, the response includes information for the <code>$LATEST</code> version of all bots whose name contains the specified string.</p> </li> <li> <p>If you don\'t specify the <code>nameContains</code> field, the operation returns information about the <code>$LATEST</code> version of all of your bots.</p> </li> </ul> <p>This operation requires permission for the <code>lex:GetBots</code> action.</p>', 'GetBuiltinIntent' => '<p>Returns information about a built-in intent.</p> <p>This operation requires permission for the <code>lex:GetBuiltinIntent</code> action.</p>', 'GetBuiltinIntents' => '<p>Gets a list of built-in intents that meet the specified criteria.</p> <p>This operation requires permission for the <code>lex:GetBuiltinIntents</code> action.</p>', 'GetBuiltinSlotTypes' => '<p>Gets a list of built-in slot types that meet the specified criteria.</p> <p>For a list of built-in slot types, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.</p> <p>This operation requires permission for the <code>lex:GetBuiltInSlotTypes</code> action.</p>', 'GetExport' => '<p>Exports the contents of a Amazon Lex resource in a specified format. </p>', 'GetImport' => '<p>Gets information about an import job started with the <code>StartImport</code> operation.</p>', 'GetIntent' => '<p> Returns information about an intent. In addition to the intent name, you must specify the intent version. </p> <p> This operation requires permissions to perform the <code>lex:GetIntent</code> action. </p>', 'GetIntentVersions' => '<p>Gets information about all of the versions of an intent.</p> <p>The <code>GetIntentVersions</code> operation returns an <code>IntentMetadata</code> object for each version of an intent. For example, if an intent has three numbered versions, the <code>GetIntentVersions</code> operation returns four <code>IntentMetadata</code> objects in the response, one for each numbered version and one for the <code>$LATEST</code> version. </p> <p>The <code>GetIntentVersions</code> operation always returns at least one version, the <code>$LATEST</code> version.</p> <p>This operation requires permissions for the <code>lex:GetIntentVersions</code> action.</p>', 'GetIntents' => '<p>Returns intent information as follows: </p> <ul> <li> <p>If you specify the <code>nameContains</code> field, returns the <code>$LATEST</code> version of all intents that contain the specified string.</p> </li> <li> <p> If you don\'t specify the <code>nameContains</code> field, returns information about the <code>$LATEST</code> version of all intents. </p> </li> </ul> <p> The operation requires permission for the <code>lex:GetIntents</code> action. </p>', 'GetMigration' => '<p>Provides details about an ongoing or complete migration from an Amazon Lex V1 bot to an Amazon Lex V2 bot. Use this operation to view the migration alerts and warnings related to the migration.</p>', 'GetMigrations' => '<p>Gets a list of migrations between Amazon Lex V1 and Amazon Lex V2.</p>', 'GetSlotType' => '<p>Returns information about a specific version of a slot type. In addition to specifying the slot type name, you must specify the slot type version.</p> <p>This operation requires permissions for the <code>lex:GetSlotType</code> action.</p>', 'GetSlotTypeVersions' => '<p>Gets information about all versions of a slot type.</p> <p>The <code>GetSlotTypeVersions</code> operation returns a <code>SlotTypeMetadata</code> object for each version of a slot type. For example, if a slot type has three numbered versions, the <code>GetSlotTypeVersions</code> operation returns four <code>SlotTypeMetadata</code> objects in the response, one for each numbered version and one for the <code>$LATEST</code> version. </p> <p>The <code>GetSlotTypeVersions</code> operation always returns at least one version, the <code>$LATEST</code> version.</p> <p>This operation requires permissions for the <code>lex:GetSlotTypeVersions</code> action.</p>', 'GetSlotTypes' => '<p>Returns slot type information as follows: </p> <ul> <li> <p>If you specify the <code>nameContains</code> field, returns the <code>$LATEST</code> version of all slot types that contain the specified string.</p> </li> <li> <p> If you don\'t specify the <code>nameContains</code> field, returns information about the <code>$LATEST</code> version of all slot types. </p> </li> </ul> <p> The operation requires permission for the <code>lex:GetSlotTypes</code> action. </p>', 'GetUtterancesView' => '<p>Use the <code>GetUtterancesView</code> operation to get information about the utterances that your users have made to your bot. You can use this list to tune the utterances that your bot responds to.</p> <p>For example, say that you have created a bot to order flowers. After your users have used your bot for a while, use the <code>GetUtterancesView</code> operation to see the requests that they have made and whether they have been successful. You might find that the utterance "I want flowers" is not being recognized. You could add this utterance to the <code>OrderFlowers</code> intent so that your bot recognizes that utterance.</p> <p>After you publish a new version of a bot, you can get information about the old version and the new so that you can compare the performance across the two versions. </p> <p>Utterance statistics are generated once a day. Data is available for the last 15 days. You can request information for up to 5 versions of your bot in each request. Amazon Lex returns the most frequent utterances received by the bot in the last 15 days. The response contains information about a maximum of 100 utterances for each version.</p> <p>If you set <code>childDirected</code> field to true when you created your bot, if you are using slot obfuscation with one or more slots, or if you opted out of participating in improving Amazon Lex, utterances are not available.</p> <p>This operation requires permissions for the <code>lex:GetUtterancesView</code> action.</p>', 'ListTagsForResource' => '<p>Gets a list of tags associated with the specified resource. Only bots, bot aliases, and bot channels can have tags associated with them.</p>', 'PutBot' => '<p>Creates an Amazon Lex conversational bot or replaces an existing bot. When you create or update a bot you are only required to specify a name, a locale, and whether the bot is directed toward children under age 13. You can use this to add intents later, or to remove intents from an existing bot. When you create a bot with the minimum information, the bot is created or updated but Amazon Lex returns the <code/> response <code>FAILED</code>. You can build the bot after you add one or more intents. For more information about Amazon Lex bots, see <a>how-it-works</a>. </p> <p>If you specify the name of an existing bot, the fields in the request replace the existing values in the <code>$LATEST</code> version of the bot. Amazon Lex removes any fields that you don\'t provide values for in the request, except for the <code>idleTTLInSeconds</code> and <code>privacySettings</code> fields, which are set to their default values. If you don\'t specify values for required fields, Amazon Lex throws an exception.</p> <p>This operation requires permissions for the <code>lex:PutBot</code> action. For more information, see <a>security-iam</a>.</p>', 'PutBotAlias' => '<p>Creates an alias for the specified version of the bot or replaces an alias for the specified bot. To change the version of the bot that the alias points to, replace the alias. For more information about aliases, see <a>versioning-aliases</a>.</p> <p>This operation requires permissions for the <code>lex:PutBotAlias</code> action. </p>', 'PutIntent' => '<p>Creates an intent or replaces an existing intent.</p> <p>To define the interaction between the user and your bot, you use one or more intents. For a pizza ordering bot, for example, you would create an <code>OrderPizza</code> intent. </p> <p>To create an intent or replace an existing intent, you must provide the following:</p> <ul> <li> <p>Intent name. For example, <code>OrderPizza</code>.</p> </li> <li> <p>Sample utterances. For example, "Can I order a pizza, please." and "I want to order a pizza."</p> </li> <li> <p>Information to be gathered. You specify slot types for the information that your bot will request from the user. You can specify standard slot types, such as a date or a time, or custom slot types such as the size and crust of a pizza.</p> </li> <li> <p>How the intent will be fulfilled. You can provide a Lambda function or configure the intent to return the intent information to the client application. If you use a Lambda function, when all of the intent information is available, Amazon Lex invokes your Lambda function. If you configure your intent to return the intent information to the client application. </p> </li> </ul> <p>You can specify other optional information in the request, such as:</p> <ul> <li> <p>A confirmation prompt to ask the user to confirm an intent. For example, "Shall I order your pizza?"</p> </li> <li> <p>A conclusion statement to send to the user after the intent has been fulfilled. For example, "I placed your pizza order."</p> </li> <li> <p>A follow-up prompt that asks the user for additional activity. For example, asking "Do you want to order a drink with your pizza?"</p> </li> </ul> <p>If you specify an existing intent name to update the intent, Amazon Lex replaces the values in the <code>$LATEST</code> version of the intent with the values in the request. Amazon Lex removes fields that you don\'t provide in the request. If you don\'t specify the required fields, Amazon Lex throws an exception. When you update the <code>$LATEST</code> version of an intent, the <code>status</code> field of any bot that uses the <code>$LATEST</code> version of the intent is set to <code>NOT_BUILT</code>.</p> <p>For more information, see <a>how-it-works</a>.</p> <p>This operation requires permissions for the <code>lex:PutIntent</code> action.</p>', 'PutSlotType' => '<p>Creates a custom slot type or replaces an existing custom slot type.</p> <p>To create a custom slot type, specify a name for the slot type and a set of enumeration values, which are the values that a slot of this type can assume. For more information, see <a>how-it-works</a>.</p> <p>If you specify the name of an existing slot type, the fields in the request replace the existing values in the <code>$LATEST</code> version of the slot type. Amazon Lex removes the fields that you don\'t provide in the request. If you don\'t specify required fields, Amazon Lex throws an exception. When you update the <code>$LATEST</code> version of a slot type, if a bot uses the <code>$LATEST</code> version of an intent that contains the slot type, the bot\'s <code>status</code> field is set to <code>NOT_BUILT</code>.</p> <p>This operation requires permissions for the <code>lex:PutSlotType</code> action.</p>', 'StartImport' => '<p>Starts a job to import a resource to Amazon Lex.</p>', 'StartMigration' => '<p>Starts migrating a bot from Amazon Lex V1 to Amazon Lex V2. Migrate your bot when you want to take advantage of the new features of Amazon Lex V2.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/migrate.html">Migrating a bot</a> in the <i>Amazon Lex developer guide</i>.</p>', 'TagResource' => '<p>Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced with the new value.</p>', 'UntagResource' => '<p>Removes tags from a bot, bot alias or bot channel.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Your IAM user or role does not have permission to call the Amazon Lex V2 APIs required to migrate your bot.</p>', 'refs' => [], ], 'AliasName' => [ 'base' => NULL, 'refs' => [ 'BotAliasMetadata$name' => '<p>The name of the bot alias.</p>', 'BotChannelAssociation$botAlias' => '<p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made. </p>', 'DeleteBotAliasRequest$name' => '<p>The name of the alias to delete. The name is case sensitive. </p>', 'DeleteBotChannelAssociationRequest$botAlias' => '<p>An alias that points to the specific version of the Amazon Lex bot to which this association is being made.</p>', 'GetBotAliasRequest$name' => '<p>The name of the bot alias. The name is case sensitive.</p>', 'GetBotAliasResponse$name' => '<p>The name of the bot alias.</p>', 'GetBotAliasesRequest$nameContains' => '<p>Substring to match in bot alias names. An alias will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>', 'GetBotChannelAssociationRequest$botAlias' => '<p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.</p>', 'GetBotChannelAssociationResponse$botAlias' => '<p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.</p>', 'PutBotAliasRequest$name' => '<p>The name of the alias. The name is <i>not</i> case sensitive.</p>', 'PutBotAliasResponse$name' => '<p>The name of the alias.</p>', ], ], 'AliasNameOrListAll' => [ 'base' => NULL, 'refs' => [ 'GetBotChannelAssociationsRequest$botAlias' => '<p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to get a list of tags for.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to tag.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>', 'refs' => [], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'StartImportRequest$payload' => '<p>A zip archive in binary format. The archive should contain one file, a JSON file containing the resource to import. The resource should match the type specified in the <code>resourceType</code> field.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateBotVersionResponse$childDirected' => '<p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children\'s Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.</p> <p>If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a> </p>', 'CreateBotVersionResponse$enableModelImprovements' => '<p>Indicates whether the bot uses accuracy improvements. <code>true</code> indicates that the bot is using the improvements, otherwise, <code>false</code>.</p>', 'CreateBotVersionResponse$detectSentiment' => '<p>Indicates whether utterances entered by the user should be sent to Amazon Comprehend for sentiment analysis.</p>', 'GetBotResponse$enableModelImprovements' => '<p>Indicates whether the bot uses accuracy improvements. <code>true</code> indicates that the bot is using the improvements, otherwise, <code>false</code>.</p>', 'GetBotResponse$childDirected' => '<p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children\'s Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.</p> <p>If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a> </p>', 'GetBotResponse$detectSentiment' => '<p>Indicates whether user utterances should be sent to Amazon Comprehend for sentiment analysis.</p>', 'PutBotRequest$enableModelImprovements' => '<p>Set to <code>true</code> to enable access to natural language understanding improvements. </p> <p>When you set the <code>enableModelImprovements</code> parameter to <code>true</code> you can use the <code>nluIntentConfidenceThreshold</code> parameter to configure confidence scores. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html">Confidence Scores</a>.</p> <p>You can only set the <code>enableModelImprovements</code> parameter in certain Regions. If you set the parameter to <code>true</code>, your bot has access to accuracy improvements.</p> <p>The Regions where you can set the <code>enableModelImprovements</code> parameter to <code>true</code> are:</p> <ul> <li> <p>US East (N. Virginia) (us-east-1)</p> </li> <li> <p>US West (Oregon) (us-west-2)</p> </li> <li> <p>Asia Pacific (Sydney) (ap-southeast-2)</p> </li> <li> <p>EU (Ireland) (eu-west-1)</p> </li> </ul> <p>In other Regions, the <code>enableModelImprovements</code> parameter is set to <code>true</code> by default. In these Regions setting the parameter to <code>false</code> throws a <code>ValidationException</code> exception.</p>', 'PutBotRequest$childDirected' => '<p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children\'s Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.</p> <p>If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a> </p>', 'PutBotRequest$detectSentiment' => '<p>When set to <code>true</code> user utterances are sent to Amazon Comprehend for sentiment analysis. If you don\'t specify <code>detectSentiment</code>, the default is <code>false</code>.</p>', 'PutBotRequest$createVersion' => '<p>When set to <code>true</code> a new numbered version of the bot is created. This is the same as calling the <code>CreateBotVersion</code> operation. If you don\'t specify <code>createVersion</code>, the default is <code>false</code>.</p>', 'PutBotResponse$enableModelImprovements' => '<p>Indicates whether the bot uses accuracy improvements. <code>true</code> indicates that the bot is using the improvements, otherwise, <code>false</code>.</p>', 'PutBotResponse$childDirected' => '<p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children\'s Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.</p> <p>If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a> </p>', 'PutBotResponse$createVersion' => '<p> <code>True</code> if a new version of the bot was created. If the <code>createVersion</code> field was not specified in the request, the <code>createVersion</code> field is set to false in the response.</p>', 'PutBotResponse$detectSentiment' => '<p> <code>true</code> if the bot is configured to send user utterances to Amazon Comprehend for sentiment analysis. If the <code>detectSentiment</code> field was not specified in the request, the <code>detectSentiment</code> field is <code>false</code> in the response.</p>', 'PutIntentRequest$createVersion' => '<p>When set to <code>true</code> a new numbered version of the intent is created. This is the same as calling the <code>CreateIntentVersion</code> operation. If you do not specify <code>createVersion</code>, the default is <code>false</code>.</p>', 'PutIntentResponse$createVersion' => '<p> <code>True</code> if a new version of the intent was created. If the <code>createVersion</code> field was not specified in the request, the <code>createVersion</code> field is set to false in the response.</p>', 'PutSlotTypeRequest$createVersion' => '<p>When set to <code>true</code> a new numbered version of the slot type is created. This is the same as calling the <code>CreateSlotTypeVersion</code> operation. If you do not specify <code>createVersion</code>, the default is <code>false</code>.</p>', 'PutSlotTypeResponse$createVersion' => '<p> <code>True</code> if a new version of the slot type was created. If the <code>createVersion</code> field was not specified in the request, the <code>createVersion</code> field is set to false in the response.</p>', ], ], 'BotAliasMetadata' => [ 'base' => '<p>Provides information about a bot alias.</p>', 'refs' => [ 'BotAliasMetadataList$member' => NULL, ], ], 'BotAliasMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetBotAliasesResponse$BotAliases' => '<p>An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.</p>', ], ], 'BotChannelAssociation' => [ 'base' => '<p>Represents an association between an Amazon Lex bot and an external messaging platform.</p>', 'refs' => [ 'BotChannelAssociationList$member' => NULL, ], ], 'BotChannelAssociationList' => [ 'base' => NULL, 'refs' => [ 'GetBotChannelAssociationsResponse$botChannelAssociations' => '<p>An array of objects, one for each association, that provides information about the Amazon Lex bot and its association with the channel. </p>', ], ], 'BotChannelName' => [ 'base' => NULL, 'refs' => [ 'BotChannelAssociation$name' => '<p>The name of the association between the bot and the channel. </p>', 'DeleteBotChannelAssociationRequest$name' => '<p>The name of the association. The name is case sensitive. </p>', 'GetBotChannelAssociationRequest$name' => '<p>The name of the association between the bot and the channel. The name is case sensitive. </p>', 'GetBotChannelAssociationResponse$name' => '<p>The name of the association between the bot and the channel.</p>', 'GetBotChannelAssociationsRequest$nameContains' => '<p>Substring to match in channel association names. An association will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To return all bot channel associations, use a hyphen ("-") as the <code>nameContains</code> parameter.</p>', ], ], 'BotMetadata' => [ 'base' => '<p>Provides information about a bot. .</p>', 'refs' => [ 'BotMetadataList$member' => NULL, ], ], 'BotMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetBotVersionsResponse$bots' => '<p>An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for the <code>$LATEST</code> version.</p>', 'GetBotsResponse$bots' => '<p>An array of <code>botMetadata</code> objects, with one entry for each bot. </p>', ], ], 'BotName' => [ 'base' => NULL, 'refs' => [ 'BotAliasMetadata$botName' => '<p>The name of the bot to which the alias points.</p>', 'BotChannelAssociation$botName' => '<p>The name of the Amazon Lex bot to which this association is being made. </p> <note> <p>Currently, Amazon Lex supports associations with Facebook and Slack, and Twilio.</p> </note>', 'BotMetadata$name' => '<p>The name of the bot. </p>', 'CreateBotVersionRequest$name' => '<p>The name of the bot that you want to create a new version of. The name is case sensitive. </p>', 'CreateBotVersionResponse$name' => '<p>The name of the bot.</p>', 'DeleteBotAliasRequest$botName' => '<p>The name of the bot that the alias points to.</p>', 'DeleteBotChannelAssociationRequest$botName' => '<p>The name of the Amazon Lex bot.</p>', 'DeleteBotRequest$name' => '<p>The name of the bot. The name is case sensitive. </p>', 'DeleteBotVersionRequest$name' => '<p>The name of the bot.</p>', 'DeleteUtterancesRequest$botName' => '<p>The name of the bot that stored the utterances.</p>', 'GetBotAliasRequest$botName' => '<p>The name of the bot.</p>', 'GetBotAliasResponse$botName' => '<p>The name of the bot that the alias points to.</p>', 'GetBotAliasesRequest$botName' => '<p>The name of the bot.</p>', 'GetBotChannelAssociationRequest$botName' => '<p>The name of the Amazon Lex bot.</p>', 'GetBotChannelAssociationResponse$botName' => '<p>The name of the Amazon Lex bot.</p>', 'GetBotChannelAssociationsRequest$botName' => '<p>The name of the Amazon Lex bot in the association.</p>', 'GetBotRequest$name' => '<p>The name of the bot. The name is case sensitive. </p>', 'GetBotResponse$name' => '<p>The name of the bot.</p>', 'GetBotVersionsRequest$name' => '<p>The name of the bot for which versions should be returned.</p>', 'GetBotsRequest$nameContains' => '<p>Substring to match in bot names. A bot will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>', 'GetMigrationResponse$v1BotName' => '<p>The name of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>', 'GetMigrationsRequest$v1BotNameContains' => '<p>Filters the list to contain only bots whose name contains the specified string. The string is matched anywhere in bot name.</p>', 'GetUtterancesViewRequest$botName' => '<p>The name of the bot for which utterance information should be returned.</p>', 'GetUtterancesViewResponse$botName' => '<p>The name of the bot for which utterance information was returned.</p>', 'MigrationSummary$v1BotName' => '<p>The name of the Amazon Lex V1 bot that is the source of the migration.</p>', 'PutBotAliasRequest$botName' => '<p>The name of the bot.</p>', 'PutBotAliasResponse$botName' => '<p>The name of the bot that the alias points to.</p>', 'PutBotRequest$name' => '<p>The name of the bot. The name is <i>not</i> case sensitive. </p>', 'PutBotResponse$name' => '<p>The name of the bot.</p>', 'StartMigrationRequest$v1BotName' => '<p>The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.</p>', 'StartMigrationResponse$v1BotName' => '<p>The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.</p>', ], ], 'BotVersions' => [ 'base' => NULL, 'refs' => [ 'GetUtterancesViewRequest$botVersions' => '<p>An array of bot versions for which utterance information should be returned. The limit is 5 versions per request.</p>', ], ], 'BuiltinIntentMetadata' => [ 'base' => '<p>Provides metadata for a built-in intent.</p>', 'refs' => [ 'BuiltinIntentMetadataList$member' => NULL, ], ], 'BuiltinIntentMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetBuiltinIntentsResponse$intents' => '<p>An array of <code>builtinIntentMetadata</code> objects, one for each intent in the response.</p>', ], ], 'BuiltinIntentSignature' => [ 'base' => NULL, 'refs' => [ 'BuiltinIntentMetadata$signature' => '<p>A unique identifier for the built-in intent. To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>', 'CreateIntentVersionResponse$parentIntentSignature' => '<p>A unique identifier for a built-in intent.</p>', 'GetBuiltinIntentRequest$signature' => '<p>The unique identifier for a built-in intent. To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>', 'GetBuiltinIntentResponse$signature' => '<p>The unique identifier for a built-in intent.</p>', 'GetIntentResponse$parentIntentSignature' => '<p>A unique identifier for a built-in intent.</p>', 'PutIntentRequest$parentIntentSignature' => '<p>A unique identifier for the built-in intent to base this intent on. To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>', 'PutIntentResponse$parentIntentSignature' => '<p>A unique identifier for the built-in intent that this intent is based on.</p>', ], ], 'BuiltinIntentSlot' => [ 'base' => '<p>Provides information about a slot used in a built-in intent.</p>', 'refs' => [ 'BuiltinIntentSlotList$member' => NULL, ], ], 'BuiltinIntentSlotList' => [ 'base' => NULL, 'refs' => [ 'GetBuiltinIntentResponse$slots' => '<p>An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.</p>', ], ], 'BuiltinSlotTypeMetadata' => [ 'base' => '<p>Provides information about a built in slot type.</p>', 'refs' => [ 'BuiltinSlotTypeMetadataList$member' => NULL, ], ], 'BuiltinSlotTypeMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetBuiltinSlotTypesResponse$slotTypes' => '<p>An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.</p>', ], ], 'BuiltinSlotTypeSignature' => [ 'base' => NULL, 'refs' => [ 'BuiltinSlotTypeMetadata$signature' => '<p>A unique identifier for the built-in slot type. To find the signature for a slot type, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.</p>', ], ], 'ChannelConfigurationMap' => [ 'base' => NULL, 'refs' => [ 'BotChannelAssociation$botConfiguration' => '<p>Provides information necessary to communicate with the messaging platform. </p>', 'GetBotChannelAssociationResponse$botConfiguration' => '<p>Provides information that the messaging platform needs to communicate with the Amazon Lex bot.</p>', ], ], 'ChannelStatus' => [ 'base' => NULL, 'refs' => [ 'BotChannelAssociation$status' => '<p>The status of the bot channel. </p> <ul> <li> <p> <code>CREATED</code> - The channel has been created and is ready for use.</p> </li> <li> <p> <code>IN_PROGRESS</code> - Channel creation is in progress.</p> </li> <li> <p> <code>FAILED</code> - There was an error creating the channel. For information about the reason for the failure, see the <code>failureReason</code> field.</p> </li> </ul>', 'GetBotChannelAssociationResponse$status' => '<p>The status of the bot channel. </p> <ul> <li> <p> <code>CREATED</code> - The channel has been created and is ready for use.</p> </li> <li> <p> <code>IN_PROGRESS</code> - Channel creation is in progress.</p> </li> <li> <p> <code>FAILED</code> - There was an error creating the channel. For information about the reason for the failure, see the <code>failureReason</code> field.</p> </li> </ul>', ], ], 'ChannelType' => [ 'base' => NULL, 'refs' => [ 'BotChannelAssociation$type' => '<p>Specifies the type of association by indicating the type of channel being established between the Amazon Lex bot and the external messaging platform.</p>', 'GetBotChannelAssociationResponse$type' => '<p>The type of the messaging platform.</p>', ], ], 'CodeHook' => [ 'base' => '<p>Specifies a Lambda function that verifies requests to a bot or fulfills the user\'s request to a bot..</p>', 'refs' => [ 'CreateIntentVersionResponse$dialogCodeHook' => '<p>If defined, Amazon Lex invokes this Lambda function for each user input.</p>', 'FulfillmentActivity$codeHook' => '<p> A description of the Lambda function that is run to fulfill the intent. </p>', 'GetIntentResponse$dialogCodeHook' => '<p>If defined in the bot, Amazon Amazon Lex invokes this Lambda function for each user input. For more information, see <a>PutIntent</a>. </p>', 'PutIntentRequest$dialogCodeHook' => '<p> Specifies a Lambda function to invoke for each user input. You can invoke this Lambda function to personalize user interaction. </p> <p>For example, suppose your bot determines that the user is John. Your Lambda function might retrieve John\'s information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, <code>GlutenIntolerant</code>, to true. You might find John\'s phone number and set the corresponding session attribute. </p>', 'PutIntentResponse$dialogCodeHook' => '<p>If defined in the intent, Amazon Lex invokes this Lambda function for each user input.</p>', ], ], 'ConfidenceThreshold' => [ 'base' => NULL, 'refs' => [ 'GetBotResponse$nluIntentConfidenceThreshold' => '<p>The score that determines where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response. <code>AMAZON.FallbackIntent</code> is inserted if the confidence score for all intents is below this value. <code>AMAZON.KendraSearchIntent</code> is only inserted if it is configured for the bot.</p>', 'PutBotRequest$nluIntentConfidenceThreshold' => '<p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot.</p> <p>You must set the <code>enableModelImprovements</code> parameter to <code>true</code> to use confidence scores in the following regions.</p> <ul> <li> <p>US East (N. Virginia) (us-east-1)</p> </li> <li> <p>US West (Oregon) (us-west-2)</p> </li> <li> <p>Asia Pacific (Sydney) (ap-southeast-2)</p> </li> <li> <p>EU (Ireland) (eu-west-1)</p> </li> </ul> <p>In other Regions, the <code>enableModelImprovements</code> parameter is set to <code>true</code> by default.</p> <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>PostText</code> operation would be:</p> <ul> <li> <p>AMAZON.FallbackIntent</p> </li> <li> <p>IntentA</p> </li> <li> <p>IntentB</p> </li> <li> <p>IntentC</p> </li> </ul>', 'PutBotResponse$nluIntentConfidenceThreshold' => '<p>The score that determines where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response. <code>AMAZON.FallbackIntent</code> is inserted if the confidence score for all intents is below this value. <code>AMAZON.KendraSearchIntent</code> is only inserted if it is configured for the bot.</p>', ], ], 'ConflictException' => [ 'base' => '<p> There was a conflict processing the request. Try your request again. </p>', 'refs' => [], ], 'ContentString' => [ 'base' => NULL, 'refs' => [ 'Message$content' => '<p>The text of the message.</p>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'Message$contentType' => '<p>The content type of the message string.</p>', ], ], 'ContextTimeToLiveInSeconds' => [ 'base' => NULL, 'refs' => [ 'OutputContext$timeToLiveInSeconds' => '<p>The number of seconds that the context should be active after it is first sent in a <code>PostContent</code> or <code>PostText</code> response. You can set the value between 5 and 86,400 seconds (24 hours).</p>', ], ], 'ContextTurnsToLive' => [ 'base' => NULL, 'refs' => [ 'OutputContext$turnsToLive' => '<p>The number of conversation turns that the context should be active. A conversation turn is one <code>PostContent</code> or <code>PostText</code> request and the corresponding response from Amazon Lex.</p>', ], ], 'ConversationLogsRequest' => [ 'base' => '<p>Provides the settings needed for conversation logs.</p>', 'refs' => [ 'PutBotAliasRequest$conversationLogs' => '<p>Settings for conversation logs for the alias.</p>', ], ], 'ConversationLogsResponse' => [ 'base' => '<p>Contains information about conversation log settings.</p>', 'refs' => [ 'BotAliasMetadata$conversationLogs' => '<p>Settings that determine how Amazon Lex uses conversation logs for the alias.</p>', 'GetBotAliasResponse$conversationLogs' => '<p>The settings that determine how Amazon Lex uses conversation logs for the alias.</p>', 'PutBotAliasResponse$conversationLogs' => '<p>The settings that determine how Amazon Lex uses conversation logs for the alias.</p>', ], ], 'Count' => [ 'base' => NULL, 'refs' => [ 'UtteranceData$count' => '<p>The number of times that the utterance was processed.</p>', 'UtteranceData$distinctUsers' => '<p>The total number of individuals that used the utterance.</p>', ], ], 'CreateBotVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBotVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIntentVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIntentVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSlotTypeVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSlotTypeVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomOrBuiltinSlotTypeName' => [ 'base' => NULL, 'refs' => [ 'CreateSlotTypeVersionResponse$parentSlotTypeSignature' => '<p>The built-in slot type used a the parent of the slot type.</p>', 'GetSlotTypeResponse$parentSlotTypeSignature' => '<p>The built-in slot type used as a parent for the slot type.</p>', 'PutSlotTypeRequest$parentSlotTypeSignature' => '<p>The built-in slot type used as the parent of the slot type. When you define a parent slot type, the new slot type has all of the same configuration as the parent.</p> <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>', 'PutSlotTypeResponse$parentSlotTypeSignature' => '<p>The built-in slot type used as the parent of the slot type.</p>', 'Slot$slotType' => '<p>The type of the slot, either a custom slot type that you defined or one of the built-in slot types.</p>', ], ], 'DeleteBotAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotChannelAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBotVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIntentVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSlotTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSlotTypeVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUtterancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'BotAliasMetadata$description' => '<p>A description of the bot alias.</p>', 'BotChannelAssociation$description' => '<p>A text description of the association you are creating. </p>', 'BotMetadata$description' => '<p>A description of the bot.</p>', 'CreateBotVersionResponse$description' => '<p>A description of the bot.</p>', 'CreateIntentVersionResponse$description' => '<p>A description of the intent.</p>', 'CreateSlotTypeVersionResponse$description' => '<p>A description of the slot type.</p>', 'GetBotAliasResponse$description' => '<p>A description of the bot alias.</p>', 'GetBotChannelAssociationResponse$description' => '<p>A description of the association between the bot and the channel.</p>', 'GetBotResponse$description' => '<p>A description of the bot.</p>', 'GetIntentResponse$description' => '<p>A description of the intent.</p>', 'GetSlotTypeResponse$description' => '<p>A description of the slot type.</p>', 'IntentMetadata$description' => '<p>A description of the intent.</p>', 'PutBotAliasRequest$description' => '<p>A description of the alias.</p>', 'PutBotAliasResponse$description' => '<p>A description of the alias.</p>', 'PutBotRequest$description' => '<p>A description of the bot.</p>', 'PutBotResponse$description' => '<p>A description of the bot.</p>', 'PutIntentRequest$description' => '<p>A description of the intent.</p>', 'PutIntentResponse$description' => '<p>A description of the intent.</p>', 'PutSlotTypeRequest$description' => '<p>A description of the slot type.</p>', 'PutSlotTypeResponse$description' => '<p>A description of the slot type.</p>', 'Slot$description' => '<p>A description of the slot.</p>', 'SlotTypeMetadata$description' => '<p>A description of the slot type.</p>', ], ], 'Destination' => [ 'base' => NULL, 'refs' => [ 'LogSettingsRequest$destination' => '<p>Where the logs will be delivered. Text logs are delivered to a CloudWatch Logs log group. Audio logs are delivered to an S3 bucket.</p>', 'LogSettingsResponse$destination' => '<p>The destination where logs are delivered.</p>', ], ], 'EnumerationValue' => [ 'base' => '<p>Each slot type can have a set of values. Each enumeration value represents a value the slot type can take. </p> <p>For example, a pizza ordering bot could have a slot type that specifies the type of crust that the pizza should have. The slot type could include the values </p> <ul> <li> <p>thick</p> </li> <li> <p>thin</p> </li> <li> <p>stuffed</p> </li> </ul>', 'refs' => [ 'EnumerationValues$member' => NULL, ], ], 'EnumerationValues' => [ 'base' => NULL, 'refs' => [ 'CreateSlotTypeVersionResponse$enumerationValues' => '<p>A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.</p>', 'GetSlotTypeResponse$enumerationValues' => '<p>A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.</p>', 'PutSlotTypeRequest$enumerationValues' => '<p>A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take. Each value can have a list of <code>synonyms</code>, which are additional values that help train the machine learning model about the values that it resolves for a slot. </p> <p>A regular expression slot type doesn\'t require enumeration values. All other slot types require a list of enumeration values.</p> <p>When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible values for the slot. If you are using a Lambda function, this resolution list is passed to the function. If you are not using a Lambda function you can choose to return the value that the user entered or the first value in the resolution list as the slot value. The <code>valueSelectionStrategy</code> field indicates the option to use. </p>', 'PutSlotTypeResponse$enumerationValues' => '<p>A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.</p>', ], ], 'ExportStatus' => [ 'base' => NULL, 'refs' => [ 'GetExportResponse$exportStatus' => '<p>The status of the export. </p> <ul> <li> <p> <code>IN_PROGRESS</code> - The export is in progress.</p> </li> <li> <p> <code>READY</code> - The export is complete.</p> </li> <li> <p> <code>FAILED</code> - The export could not be completed.</p> </li> </ul>', ], ], 'ExportType' => [ 'base' => NULL, 'refs' => [ 'GetExportRequest$exportType' => '<p>The format of the exported data.</p>', 'GetExportResponse$exportType' => '<p>The format of the exported data.</p>', ], ], 'FollowUpPrompt' => [ 'base' => '<p>A prompt for additional activity after an intent is fulfilled. For example, after the <code>OrderPizza</code> intent is fulfilled, you might prompt the user to find out whether the user wants to order drinks.</p>', 'refs' => [ 'CreateIntentVersionResponse$followUpPrompt' => '<p>If defined, Amazon Lex uses this prompt to solicit additional user activity after the intent is fulfilled. </p>', 'GetIntentResponse$followUpPrompt' => '<p>If defined in the bot, Amazon Lex uses this prompt to solicit additional user activity after the intent is fulfilled. For more information, see <a>PutIntent</a>.</p>', 'PutIntentRequest$followUpPrompt' => '<p>Amazon Lex uses this prompt to solicit additional activity after fulfilling an intent. For example, after the <code>OrderPizza</code> intent is fulfilled, you might prompt the user to order a drink.</p> <p>The action that Amazon Lex takes depends on the user\'s response, as follows:</p> <ul> <li> <p>If the user says "Yes" it responds with the clarification prompt that is configured for the bot.</p> </li> <li> <p>if the user says "Yes" and continues with an utterance that triggers an intent it starts a conversation for the intent.</p> </li> <li> <p>If the user says "No" it responds with the rejection statement configured for the the follow-up prompt.</p> </li> <li> <p>If it doesn\'t recognize the utterance it repeats the follow-up prompt again.</p> </li> </ul> <p>The <code>followUpPrompt</code> field and the <code>conclusionStatement</code> field are mutually exclusive. You can specify only one. </p>', 'PutIntentResponse$followUpPrompt' => '<p>If defined in the intent, Amazon Lex uses this prompt to solicit additional user activity after the intent is fulfilled.</p>', ], ], 'FulfillmentActivity' => [ 'base' => '<p> Describes how the intent is fulfilled after the user provides all of the information required for the intent. You can provide a Lambda function to process the intent, or you can return the intent information to the client application. We recommend that you use a Lambda function so that the relevant logic lives in the Cloud and limit the client-side code primarily to presentation. If you need to update the logic, you only update the Lambda function; you don\'t need to upgrade your client application. </p> <p>Consider the following examples:</p> <ul> <li> <p>In a pizza ordering application, after the user provides all of the information for placing an order, you use a Lambda function to place an order with a pizzeria. </p> </li> <li> <p>In a gaming application, when a user says "pick up a rock," this information must go back to the client application so that it can perform the operation and update the graphics. In this case, you want Amazon Lex to return the intent data to the client. </p> </li> </ul>', 'refs' => [ 'CreateIntentVersionResponse$fulfillmentActivity' => '<p> Describes how the intent is fulfilled. </p>', 'GetIntentResponse$fulfillmentActivity' => '<p>Describes how the intent is fulfilled. For more information, see <a>PutIntent</a>. </p>', 'PutIntentRequest$fulfillmentActivity' => '<p>Required. Describes how the intent is fulfilled. For example, after a user provides all of the information for a pizza order, <code>fulfillmentActivity</code> defines how the bot places an order with a local pizza store. </p> <p> You might configure Amazon Lex to return all of the intent information to the client application, or direct it to invoke a Lambda function that can process the intent (for example, place an order with a pizzeria). </p>', 'PutIntentResponse$fulfillmentActivity' => '<p>If defined in the intent, Amazon Lex invokes this Lambda function to fulfill the intent after the user provides all of the information required by the intent.</p>', ], ], 'FulfillmentActivityType' => [ 'base' => NULL, 'refs' => [ 'FulfillmentActivity$type' => '<p> How the intent should be fulfilled, either by running a Lambda function or by returning the slot data to the client application. </p>', ], ], 'GetBotAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBotAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBotChannelAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotChannelAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBotChannelAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotChannelAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBotVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBuiltinIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBuiltinIntentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBuiltinIntentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBuiltinIntentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBuiltinSlotTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBuiltinSlotTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetExportRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetExportResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIntentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIntentVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIntentVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIntentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIntentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMigrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMigrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMigrationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMigrationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSlotTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSlotTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSlotTypeVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSlotTypeVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSlotTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSlotTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUtterancesViewRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUtterancesViewResponse' => [ 'base' => NULL, 'refs' => [], ], 'GroupNumber' => [ 'base' => NULL, 'refs' => [ 'Message$groupNumber' => '<p>Identifies the message group that the message belongs to. When a group is assigned to a message, Amazon Lex returns one message from each group in the response.</p>', ], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'ConversationLogsRequest$iamRoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role with permission to write to your CloudWatch Logs for text logs and your S3 bucket for audio logs. If audio encryption is enabled, this role also provides access permission for the AWS KMS key used for encrypting audio logs. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/conversation-logs-role-and-policy.html">Creating an IAM Role and Policy for Conversation Logs</a>.</p>', 'ConversationLogsResponse$iamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used to write your logs to CloudWatch Logs or an S3 bucket.</p>', 'GetMigrationResponse$v2BotRole' => '<p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>', 'MigrationSummary$v2BotRole' => '<p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>', 'StartMigrationRequest$v2BotRole' => '<p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>', 'StartMigrationResponse$v2BotRole' => '<p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>', ], ], 'ImportStatus' => [ 'base' => NULL, 'refs' => [ 'GetImportResponse$importStatus' => '<p>The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the failure from the <code>failureReason</code> field.</p>', 'StartImportResponse$importStatus' => '<p>The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the failure using the <code>GetImport</code> operation.</p>', ], ], 'InputContext' => [ 'base' => '<p>The name of a context that must be active for an intent to be selected by Amazon Lex.</p>', 'refs' => [ 'InputContextList$member' => NULL, ], ], 'InputContextList' => [ 'base' => NULL, 'refs' => [ 'CreateIntentVersionResponse$inputContexts' => '<p>An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to choose the intent in a conversation with the user.</p>', 'GetIntentResponse$inputContexts' => '<p>An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to choose the intent in a conversation with the user.</p>', 'PutIntentRequest$inputContexts' => '<p>An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to choose the intent in a conversation with the user.</p>', 'PutIntentResponse$inputContexts' => '<p>An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to choose the intent in a conversation with the user.</p>', ], ], 'InputContextName' => [ 'base' => NULL, 'refs' => [ 'InputContext$name' => '<p>The name of the context.</p>', ], ], 'Intent' => [ 'base' => '<p>Identifies the specific version of an intent.</p>', 'refs' => [ 'IntentList$member' => NULL, ], ], 'IntentList' => [ 'base' => NULL, 'refs' => [ 'CreateBotVersionResponse$intents' => '<p>An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.</p>', 'GetBotResponse$intents' => '<p>An array of <code>intent</code> objects. For more information, see <a>PutBot</a>.</p>', 'PutBotRequest$intents' => '<p>An array of <code>Intent</code> objects. Each intent represents a command that a user can express. For example, a pizza ordering bot might support an OrderPizza intent. For more information, see <a>how-it-works</a>.</p>', 'PutBotResponse$intents' => '<p>An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.</p>', ], ], 'IntentMetadata' => [ 'base' => '<p>Provides information about an intent.</p>', 'refs' => [ 'IntentMetadataList$member' => NULL, ], ], 'IntentMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetIntentVersionsResponse$intents' => '<p>An array of <code>IntentMetadata</code> objects, one for each numbered version of the intent plus one for the <code>$LATEST</code> version.</p>', 'GetIntentsResponse$intents' => '<p>An array of <code>Intent</code> objects. For more information, see <a>PutBot</a>.</p>', ], ], 'IntentName' => [ 'base' => NULL, 'refs' => [ 'CreateIntentVersionRequest$name' => '<p>The name of the intent that you want to create a new version of. The name is case sensitive. </p>', 'CreateIntentVersionResponse$name' => '<p>The name of the intent.</p>', 'DeleteIntentRequest$name' => '<p>The name of the intent. The name is case sensitive. </p>', 'DeleteIntentVersionRequest$name' => '<p>The name of the intent.</p>', 'GetIntentRequest$name' => '<p>The name of the intent. The name is case sensitive. </p>', 'GetIntentResponse$name' => '<p>The name of the intent.</p>', 'GetIntentVersionsRequest$name' => '<p>The name of the intent for which versions should be returned.</p>', 'GetIntentsRequest$nameContains' => '<p>Substring to match in intent names. An intent will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>', 'Intent$intentName' => '<p>The name of the intent.</p>', 'IntentMetadata$name' => '<p>The name of the intent.</p>', 'PutIntentRequest$name' => '<p>The name of the intent. The name is <i>not</i> case sensitive. </p> <p>The name can\'t match a built-in intent name, or a built-in intent name with "AMAZON." removed. For example, because there is a built-in intent called <code>AMAZON.HelpIntent</code>, you can\'t create a custom intent called <code>HelpIntent</code>.</p> <p>For a list of built-in intents, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>', 'PutIntentResponse$name' => '<p>The name of the intent.</p>', ], ], 'IntentUtteranceList' => [ 'base' => NULL, 'refs' => [ 'CreateIntentVersionResponse$sampleUtterances' => '<p>An array of sample utterances configured for the intent. </p>', 'GetIntentResponse$sampleUtterances' => '<p>An array of sample utterances configured for the intent.</p>', 'PutIntentRequest$sampleUtterances' => '<p>An array of utterances (strings) that a user might say to signal the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas". </p> <p>In each utterance, a slot name is enclosed in curly braces. </p>', 'PutIntentResponse$sampleUtterances' => '<p> An array of sample utterances that are configured for the intent. </p>', ], ], 'InternalFailureException' => [ 'base' => '<p>An internal Amazon Lex error occurred. Try your request again.</p>', 'refs' => [], ], 'KendraConfiguration' => [ 'base' => '<p>Provides configuration information for the AMAZON.KendraSearchIntent intent. When you use this intent, Amazon Lex searches the specified Amazon Kendra index and returns documents from the index that match the user\'s utterance. For more information, see <a href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html"> AMAZON.KendraSearchIntent</a>.</p>', 'refs' => [ 'CreateIntentVersionResponse$kendraConfiguration' => '<p>Configuration information, if any, for connecting an Amazon Kendra index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>', 'GetIntentResponse$kendraConfiguration' => '<p>Configuration information, if any, to connect to an Amazon Kendra index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>', 'PutIntentRequest$kendraConfiguration' => '<p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra index. For more information, see <a href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html"> AMAZON.KendraSearchIntent</a>.</p>', 'PutIntentResponse$kendraConfiguration' => '<p>Configuration information, if any, required to connect to an Amazon Kendra index and use the <code>AMAZON.KendraSearchIntent</code> intent.</p>', ], ], 'KendraIndexArn' => [ 'base' => NULL, 'refs' => [ 'KendraConfiguration$kendraIndex' => '<p>The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the AMAZON.KendraSearchIntent intent to search. The index must be in the same account and Region as the Amazon Lex bot. If the Amazon Kendra index does not exist, you get an exception when you call the <code>PutIntent</code> operation.</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'LogSettingsRequest$kmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the AWS KMS customer managed key for encrypting audio logs delivered to an S3 bucket. The key does not apply to CloudWatch Logs and is optional for S3 buckets.</p>', 'LogSettingsResponse$kmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the key used to encrypt audio logs in an S3 bucket.</p>', ], ], 'LambdaARN' => [ 'base' => NULL, 'refs' => [ 'CodeHook$uri' => '<p>The Amazon Resource Name (ARN) of the Lambda function.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request exceeded a limit. Try your request again.</p>', 'refs' => [], ], 'ListOfUtterance' => [ 'base' => NULL, 'refs' => [ 'UtteranceList$utterances' => '<p>One or more <a>UtteranceData</a> objects that contain information about the utterances that have been made to a bot. The maximum number of object is 100.</p>', ], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListsOfUtterances' => [ 'base' => NULL, 'refs' => [ 'GetUtterancesViewResponse$utterances' => '<p>An array of <a>UtteranceList</a> objects, each containing a list of <a>UtteranceData</a> objects describing the utterances that were processed by your bot. The response contains a maximum of 100 <code>UtteranceData</code> objects for each version. Amazon Lex returns the most frequent utterances received by the bot in the last 15 days.</p>', ], ], 'Locale' => [ 'base' => NULL, 'refs' => [ 'CreateBotVersionResponse$locale' => '<p> Specifies the target locale for the bot. </p>', 'GetBotResponse$locale' => '<p> The target locale for the bot. </p>', 'GetBuiltinIntentsRequest$locale' => '<p>A list of locales that the intent supports.</p>', 'GetBuiltinSlotTypesRequest$locale' => '<p>A list of locales that the slot type supports.</p>', 'GetMigrationResponse$v1BotLocale' => '<p>The locale of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>', 'LocaleList$member' => NULL, 'MigrationSummary$v1BotLocale' => '<p>The locale of the Amazon Lex V1 bot that is the source of the migration.</p>', 'PutBotRequest$locale' => '<p> Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. </p> <p>The default is <code>en-US</code>.</p>', 'PutBotResponse$locale' => '<p> The target locale for the bot. </p>', 'StartMigrationResponse$v1BotLocale' => '<p>The locale used for the Amazon Lex V1 bot. </p>', ], ], 'LocaleList' => [ 'base' => NULL, 'refs' => [ 'BuiltinIntentMetadata$supportedLocales' => '<p>A list of identifiers for the locales that the intent supports.</p>', 'BuiltinSlotTypeMetadata$supportedLocales' => '<p>A list of target locales for the slot. </p>', 'GetBuiltinIntentResponse$supportedLocales' => '<p>A list of locales that the intent supports.</p>', ], ], 'LogSettingsRequest' => [ 'base' => '<p>Settings used to configure delivery mode and destination for conversation logs.</p>', 'refs' => [ 'LogSettingsRequestList$member' => NULL, ], ], 'LogSettingsRequestList' => [ 'base' => NULL, 'refs' => [ 'ConversationLogsRequest$logSettings' => '<p>The settings for your conversation logs. You can log the conversation text, conversation audio, or both.</p>', ], ], 'LogSettingsResponse' => [ 'base' => '<p>The settings for conversation logs.</p>', 'refs' => [ 'LogSettingsResponseList$member' => NULL, ], ], 'LogSettingsResponseList' => [ 'base' => NULL, 'refs' => [ 'ConversationLogsResponse$logSettings' => '<p>The settings for your conversation logs. You can log text, audio, or both.</p>', ], ], 'LogType' => [ 'base' => NULL, 'refs' => [ 'LogSettingsRequest$logType' => '<p>The type of logging to enable. Text logs are delivered to a CloudWatch Logs log group. Audio logs are delivered to an S3 bucket.</p>', 'LogSettingsResponse$logType' => '<p>The type of logging that is enabled.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetBotAliasesRequest$maxResults' => '<p>The maximum number of aliases to return in the response. The default is 50. . </p>', 'GetBotChannelAssociationsRequest$maxResults' => '<p>The maximum number of associations to return in the response. The default is 50. </p>', 'GetBotVersionsRequest$maxResults' => '<p>The maximum number of bot versions to return in the response. The default is 10.</p>', 'GetBotsRequest$maxResults' => '<p>The maximum number of bots to return in the response that the request will return. The default is 10.</p>', 'GetBuiltinIntentsRequest$maxResults' => '<p>The maximum number of intents to return in the response. The default is 10.</p>', 'GetBuiltinSlotTypesRequest$maxResults' => '<p>The maximum number of slot types to return in the response. The default is 10.</p>', 'GetIntentVersionsRequest$maxResults' => '<p>The maximum number of intent versions to return in the response. The default is 10.</p>', 'GetIntentsRequest$maxResults' => '<p>The maximum number of intents to return in the response. The default is 10.</p>', 'GetMigrationsRequest$maxResults' => '<p>The maximum number of migrations to return in the response. The default is 10.</p>', 'GetSlotTypeVersionsRequest$maxResults' => '<p>The maximum number of slot type versions to return in the response. The default is 10.</p>', 'GetSlotTypesRequest$maxResults' => '<p>The maximum number of slot types to return in the response. The default is 10.</p>', ], ], 'MergeStrategy' => [ 'base' => NULL, 'refs' => [ 'GetImportResponse$mergeStrategy' => '<p>The action taken when there was a conflict between an existing resource and a resource in the import file.</p>', 'StartImportRequest$mergeStrategy' => '<p>Specifies the action that the <code>StartImport</code> operation should take when there is an existing resource with the same name.</p> <ul> <li> <p>FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import file and an existing resource. The name of the resource causing the conflict is in the <code>failureReason</code> field of the response to the <code>GetImport</code> operation.</p> <p>OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource. The $LASTEST version of the existing resource is overwritten with the data from the import file.</p> </li> </ul>', 'StartImportResponse$mergeStrategy' => '<p>The action to take when there is a merge conflict.</p>', ], ], 'Message' => [ 'base' => '<p>The message object that provides the message text and its type.</p>', 'refs' => [ 'MessageList$member' => NULL, ], ], 'MessageList' => [ 'base' => NULL, 'refs' => [ 'Prompt$messages' => '<p>An array of objects, each of which provides a message string and its type. You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).</p>', 'Statement$messages' => '<p>A collection of message objects.</p>', ], ], 'MessageVersion' => [ 'base' => NULL, 'refs' => [ 'CodeHook$messageVersion' => '<p>The version of the request-response that you want Amazon Lex to use to invoke your Lambda function. For more information, see <a>using-lambda</a>.</p>', ], ], 'MigrationAlert' => [ 'base' => '<p>Provides information about alerts and warnings that Amazon Lex sends during a migration. The alerts include information about how to resolve the issue.</p>', 'refs' => [ 'MigrationAlerts$member' => NULL, ], ], 'MigrationAlertDetail' => [ 'base' => NULL, 'refs' => [ 'MigrationAlertDetails$member' => NULL, ], ], 'MigrationAlertDetails' => [ 'base' => NULL, 'refs' => [ 'MigrationAlert$details' => '<p>Additional details about the alert.</p>', ], ], 'MigrationAlertMessage' => [ 'base' => NULL, 'refs' => [ 'MigrationAlert$message' => '<p>A message that describes why the alert was issued.</p>', ], ], 'MigrationAlertReferenceURL' => [ 'base' => NULL, 'refs' => [ 'MigrationAlertReferenceURLs$member' => NULL, ], ], 'MigrationAlertReferenceURLs' => [ 'base' => NULL, 'refs' => [ 'MigrationAlert$referenceURLs' => '<p>A link to the Amazon Lex documentation that describes how to resolve the alert.</p>', ], ], 'MigrationAlertType' => [ 'base' => NULL, 'refs' => [ 'MigrationAlert$type' => '<p>The type of alert. There are two kinds of alerts:</p> <ul> <li> <p> <code>ERROR</code> - There was an issue with the migration that can\'t be resolved. The migration stops.</p> </li> <li> <p> <code>WARN</code> - There was an issue with the migration that requires manual changes to the new Amazon Lex V2 bot. The migration continues.</p> </li> </ul>', ], ], 'MigrationAlerts' => [ 'base' => NULL, 'refs' => [ 'GetMigrationResponse$alerts' => '<p>A list of alerts and warnings that indicate issues with the migration for the Amazon Lex V1 bot to Amazon Lex V2. You receive a warning when an Amazon Lex V1 feature has a different implementation if Amazon Lex V2.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/migrate.html">Migrating a bot</a> in the <i>Amazon Lex V2 developer guide</i>.</p>', ], ], 'MigrationId' => [ 'base' => NULL, 'refs' => [ 'GetMigrationRequest$migrationId' => '<p>The unique identifier of the migration to view. The <code>migrationID</code> is returned by the operation.</p>', 'GetMigrationResponse$migrationId' => '<p>The unique identifier of the migration. This is the same as the identifier used when calling the <code>GetMigration</code> operation.</p>', 'MigrationSummary$migrationId' => '<p>The unique identifier that Amazon Lex assigned to the migration.</p>', 'StartMigrationResponse$migrationId' => '<p>The unique identifier that Amazon Lex assigned to the migration.</p>', ], ], 'MigrationSortAttribute' => [ 'base' => NULL, 'refs' => [ 'GetMigrationsRequest$sortByAttribute' => '<p>The field to sort the list of migrations by. You can sort by the Amazon Lex V1 bot name or the date and time that the migration was started.</p>', ], ], 'MigrationStatus' => [ 'base' => NULL, 'refs' => [ 'GetMigrationResponse$migrationStatus' => '<p>Indicates the status of the migration. When the status is <code>COMPLETE</code> the migration is finished and the bot is available in Amazon Lex V2. There may be alerts and warnings that need to be resolved to complete the migration.</p>', 'GetMigrationsRequest$migrationStatusEquals' => '<p>Filters the list to contain only migrations in the specified state.</p>', 'MigrationSummary$migrationStatus' => '<p>The status of the operation. When the status is <code>COMPLETE</code> the bot is available in Amazon Lex V2. There may be alerts and warnings that need to be resolved to complete the migration.</p>', ], ], 'MigrationStrategy' => [ 'base' => NULL, 'refs' => [ 'GetMigrationResponse$migrationStrategy' => '<p>The strategy used to conduct the migration.</p> <ul> <li> <p> <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.</p> </li> <li> <p> <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being migrated. It doesn\'t change any other locales in the Amazon Lex V2 bot. If the locale doesn\'t exist, a new locale is created in the Amazon Lex V2 bot.</p> </li> </ul>', 'MigrationSummary$migrationStrategy' => '<p>The strategy used to conduct the migration.</p>', 'StartMigrationRequest$migrationStrategy' => '<p>The strategy used to conduct the migration.</p> <ul> <li> <p> <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.</p> </li> <li> <p> <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being migrated. It doesn\'t change any other locales in the Amazon Lex V2 bot. If the locale doesn\'t exist, a new locale is created in the Amazon Lex V2 bot.</p> </li> </ul>', 'StartMigrationResponse$migrationStrategy' => '<p>The strategy used to conduct the migration.</p>', ], ], 'MigrationSummary' => [ 'base' => '<p>Provides information about migrating a bot from Amazon Lex V1 to Amazon Lex V2.</p>', 'refs' => [ 'MigrationSummaryList$member' => NULL, ], ], 'MigrationSummaryList' => [ 'base' => NULL, 'refs' => [ 'GetMigrationsResponse$migrationSummaries' => '<p>An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the migration, use the <code>migrationId</code> from the summary in a call to the operation.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'GetExportRequest$name' => '<p>The name of the bot to export.</p>', 'GetExportResponse$name' => '<p>The name of the bot being exported.</p>', 'GetImportResponse$name' => '<p>The name given to the import job.</p>', 'ResourceReference$name' => '<p>The name of the resource that is using the resource that you are trying to delete.</p>', 'StartImportResponse$name' => '<p>The name given to the import job.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetBotAliasesRequest$nextToken' => '<p>A pagination token for fetching the next page of aliases. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of aliases, specify the pagination token in the next request. </p>', 'GetBotAliasesResponse$nextToken' => '<p>A pagination token for fetching next page of aliases. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of aliases, specify the pagination token in the next request. </p>', 'GetBotChannelAssociationsRequest$nextToken' => '<p>A pagination token for fetching the next page of associations. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of associations, specify the pagination token in the next request. </p>', 'GetBotChannelAssociationsResponse$nextToken' => '<p>A pagination token that fetches the next page of associations. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of associations, specify the pagination token in the next request. </p>', 'GetBotVersionsRequest$nextToken' => '<p>A pagination token for fetching the next page of bot versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>', 'GetBotVersionsResponse$nextToken' => '<p>A pagination token for fetching the next page of bot versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>', 'GetBotsRequest$nextToken' => '<p>A pagination token that fetches the next page of bots. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of bots, specify the pagination token in the next request. </p>', 'GetBotsResponse$nextToken' => '<p>If the response is truncated, it includes a pagination token that you can specify in your next request to fetch the next page of bots. </p>', 'GetBuiltinIntentsRequest$nextToken' => '<p>A pagination token that fetches the next page of intents. If this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents, use the pagination token in the next request.</p>', 'GetBuiltinIntentsResponse$nextToken' => '<p>A pagination token that fetches the next page of intents. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents, specify the pagination token in the next request.</p>', 'GetBuiltinSlotTypesRequest$nextToken' => '<p>A pagination token that fetches the next page of slot types. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of slot types, specify the pagination token in the next request.</p>', 'GetBuiltinSlotTypesResponse$nextToken' => '<p>If the response is truncated, the response includes a pagination token that you can use in your next request to fetch the next page of slot types.</p>', 'GetIntentVersionsRequest$nextToken' => '<p>A pagination token for fetching the next page of intent versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>', 'GetIntentVersionsResponse$nextToken' => '<p>A pagination token for fetching the next page of intent versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>', 'GetIntentsRequest$nextToken' => '<p>A pagination token that fetches the next page of intents. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents, specify the pagination token in the next request. </p>', 'GetIntentsResponse$nextToken' => '<p>If the response is truncated, the response includes a pagination token that you can specify in your next request to fetch the next page of intents. </p>', 'GetMigrationsRequest$nextToken' => '<p>A pagination token that fetches the next page of migrations. If the response to this operation is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of migrations, specify the pagination token in the request.</p>', 'GetMigrationsResponse$nextToken' => '<p>If the response is truncated, it includes a pagination token that you can specify in your next request to fetch the next page of migrations.</p>', 'GetSlotTypeVersionsRequest$nextToken' => '<p>A pagination token for fetching the next page of slot type versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>', 'GetSlotTypeVersionsResponse$nextToken' => '<p>A pagination token for fetching the next page of slot type versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>', 'GetSlotTypesRequest$nextToken' => '<p>A pagination token that fetches the next page of slot types. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch next page of slot types, specify the pagination token in the next request.</p>', 'GetSlotTypesResponse$nextToken' => '<p>If the response is truncated, it includes a pagination token that you can specify in your next request to fetch the next page of slot types.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>The resource specified in the request was not found. Check the resource and try again.</p>', 'refs' => [], ], 'NumericalVersion' => [ 'base' => NULL, 'refs' => [ 'DeleteBotVersionRequest$version' => '<p>The version of the bot to delete. You cannot delete the <code>$LATEST</code> version of the bot. To delete the <code>$LATEST</code> version, use the <a>DeleteBot</a> operation.</p>', 'DeleteIntentVersionRequest$version' => '<p>The version of the intent to delete. You cannot delete the <code>$LATEST</code> version of the intent. To delete the <code>$LATEST</code> version, use the <a>DeleteIntent</a> operation.</p>', 'DeleteSlotTypeVersionRequest$version' => '<p>The version of the slot type to delete. You cannot delete the <code>$LATEST</code> version of the slot type. To delete the <code>$LATEST</code> version, use the <a>DeleteSlotType</a> operation.</p>', 'GetExportRequest$version' => '<p>The version of the bot to export.</p>', 'GetExportResponse$version' => '<p>The version of the bot being exported.</p>', ], ], 'ObfuscationSetting' => [ 'base' => NULL, 'refs' => [ 'Slot$obfuscationSetting' => '<p>Determines whether a slot is obfuscated in conversation logs and stored utterances. When you obfuscate a slot, the value is replaced by the slot name in curly braces ({}). For example, if the slot name is "full_name", obfuscated values are replaced with "{full_name}". For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/how-obfuscate.html"> Slot Obfuscation </a>. </p>', ], ], 'OutputContext' => [ 'base' => '<p>The specification of an output context that is set when an intent is fulfilled.</p>', 'refs' => [ 'OutputContextList$member' => NULL, ], ], 'OutputContextList' => [ 'base' => NULL, 'refs' => [ 'CreateIntentVersionResponse$outputContexts' => '<p>An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the intent is fulfilled.</p>', 'GetIntentResponse$outputContexts' => '<p>An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the intent is fulfilled.</p>', 'PutIntentRequest$outputContexts' => '<p>An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the intent is fulfilled.</p>', 'PutIntentResponse$outputContexts' => '<p>An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the intent is fulfilled.</p>', ], ], 'OutputContextName' => [ 'base' => NULL, 'refs' => [ 'OutputContext$name' => '<p>The name of the context.</p>', ], ], 'PreconditionFailedException' => [ 'base' => '<p> The checksum of the resource that you are trying to change does not match the checksum in the request. Check the resource\'s checksum and try again.</p>', 'refs' => [], ], 'Priority' => [ 'base' => NULL, 'refs' => [ 'Slot$priority' => '<p> Directs Amazon Lex the order in which to elicit this slot value from the user. For example, if the intent has two slots with priorities 1 and 2, AWS Amazon Lex first elicits a value for the slot with priority 1.</p> <p>If multiple slots share the same priority, the order in which Amazon Lex elicits values is arbitrary.</p>', ], ], 'ProcessBehavior' => [ 'base' => NULL, 'refs' => [ 'PutBotRequest$processBehavior' => '<p>If you set the <code>processBehavior</code> element to <code>BUILD</code>, Amazon Lex builds the bot so that it can be run. If you set the element to <code>SAVE</code> Amazon Lex saves the bot, but doesn\'t build it. </p> <p>If you don\'t specify this value, the default value is <code>BUILD</code>.</p>', ], ], 'Prompt' => [ 'base' => '<p>Obtains information from the user. To define a prompt, provide one or more messages and specify the number of attempts to get information from the user. If you provide more than one message, Amazon Lex chooses one of the messages to use to prompt the user. For more information, see <a>how-it-works</a>.</p>', 'refs' => [ 'CreateBotVersionResponse$clarificationPrompt' => '<p>The message that Amazon Lex uses when it doesn\'t understand the user\'s request. For more information, see <a>PutBot</a>. </p>', 'CreateIntentVersionResponse$confirmationPrompt' => '<p>If defined, the prompt that Amazon Lex uses to confirm the user\'s intent before fulfilling it. </p>', 'FollowUpPrompt$prompt' => '<p>Prompts for information from the user. </p>', 'GetBotResponse$clarificationPrompt' => '<p>The message Amazon Lex uses when it doesn\'t understand the user\'s request. For more information, see <a>PutBot</a>. </p>', 'GetIntentResponse$confirmationPrompt' => '<p>If defined in the bot, Amazon Lex uses prompt to confirm the intent before fulfilling the user\'s request. For more information, see <a>PutIntent</a>. </p>', 'PutBotRequest$clarificationPrompt' => '<p>When Amazon Lex doesn\'t understand the user\'s intent, it uses this message to get clarification. To specify how many times Amazon Lex should repeat the clarification prompt, use the <code>maxAttempts</code> field. If Amazon Lex still doesn\'t understand, it sends the message in the <code>abortStatement</code> field. </p> <p>When you create a clarification prompt, make sure that it suggests the correct response from the user. for example, for a bot that orders pizza and drinks, you might create this clarification prompt: "What would you like to do? You can say \'Order a pizza\' or \'Order a drink.\'"</p> <p>If you have defined a fallback intent, it will be invoked if the clarification prompt is repeated the number of times defined in the <code>maxAttempts</code> field. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html"> AMAZON.FallbackIntent</a>.</p> <p>If you don\'t define a clarification prompt, at runtime Amazon Lex will return a 400 Bad Request exception in three cases: </p> <ul> <li> <p>Follow-up prompt - When the user responds to a follow-up prompt but does not provide an intent. For example, in response to a follow-up prompt that says "Would you like anything else today?" the user says "Yes." Amazon Lex will return a 400 Bad Request exception because it does not have a clarification prompt to send to the user to get an intent.</p> </li> <li> <p>Lambda function - When using a Lambda function, you return an <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a clarification prompt to get an intent from the user, it returns a 400 Bad Request exception.</p> </li> <li> <p>PutSession operation - When using the <code>PutSession</code> operation, you send an <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a clarification prompt to get an intent from the user, it returns a 400 Bad Request exception.</p> </li> </ul>', 'PutBotResponse$clarificationPrompt' => '<p> The prompts that Amazon Lex uses when it doesn\'t understand the user\'s intent. For more information, see <a>PutBot</a>. </p>', 'PutIntentRequest$confirmationPrompt' => '<p>Prompts the user to confirm the intent. This question should have a yes or no answer.</p> <p>Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct before placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask the user for confirmation before providing the information. </p> <note> <p>You you must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or neither.</p> </note>', 'PutIntentResponse$confirmationPrompt' => '<p>If defined in the intent, Amazon Lex prompts the user to confirm the intent before fulfilling it.</p>', 'Slot$valueElicitationPrompt' => '<p>The prompt that Amazon Lex uses to elicit the slot value from the user.</p>', ], ], 'PromptMaxAttempts' => [ 'base' => NULL, 'refs' => [ 'Prompt$maxAttempts' => '<p>The number of times to prompt the user for information.</p>', ], ], 'PutBotAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBotAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBotResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutIntentRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutIntentResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutSlotTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutSlotTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'QueryFilterString' => [ 'base' => NULL, 'refs' => [ 'KendraConfiguration$queryFilterString' => '<p>A query filter that Amazon Lex sends to Amazon Kendra to filter the response from the query. The filter is in the format defined by Amazon Kendra. For more information, see <a href="http://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering queries</a>.</p> <p>You can override this filter string with a new filter string at runtime.</p>', ], ], 'ReferenceType' => [ 'base' => NULL, 'refs' => [ 'ResourceInUseException$referenceType' => NULL, ], ], 'RegexPattern' => [ 'base' => NULL, 'refs' => [ 'SlotTypeRegexConfiguration$pattern' => '<p>A regular expression used to validate the value of a slot. </p> <p>Use a standard regular expression. Amazon Lex supports the following characters in the regular expression:</p> <ul> <li> <p>A-Z, a-z</p> </li> <li> <p>0-9</p> </li> <li> <p>Unicode characters ("\\ u&lt;Unicode&gt;")</p> </li> </ul> <p>Represent Unicode characters with four digits, for example "\\u0041" or "\\u005A".</p> <p>The following regular expression operators are not supported:</p> <ul> <li> <p>Infinite repeaters: *, +, or {x,} with no upper bound.</p> </li> <li> <p>Wild card (.)</p> </li> </ul>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'LogSettingsRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket where the logs should be delivered.</p>', 'LogSettingsResponse$resourceArn' => '<p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket where the logs are delivered.</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>The resource that you are attempting to delete is referred to by another resource. Use this information to remove references to the resource that you are trying to delete.</p> <p>The body of the exception contains a JSON object that describes the resource.</p> <p> <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code> </p> <p> <code>"resourceReference": {</code> </p> <p> <code>"name": <i>string</i>, "version": <i>string</i> } }</code> </p>', 'refs' => [], ], 'ResourcePrefix' => [ 'base' => NULL, 'refs' => [ 'LogSettingsResponse$resourcePrefix' => '<p>The resource prefix is the first part of the S3 object key within the S3 bucket that you specified to contain audio logs. For CloudWatch Logs it is the prefix of the log stream name within the log group that you specified. </p>', ], ], 'ResourceReference' => [ 'base' => '<p>Describes the resource that refers to the resource that you are attempting to delete. This object is returned as part of the <code>ResourceInUseException</code> exception. </p>', 'refs' => [ 'ResourceInUseException$exampleReference' => NULL, ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'GetExportRequest$resourceType' => '<p>The type of resource to export. </p>', 'GetExportResponse$resourceType' => '<p>The type of the exported resource.</p>', 'GetImportResponse$resourceType' => '<p>The type of resource imported.</p>', 'StartImportRequest$resourceType' => '<p>Specifies the type of resource to export. Each resource also exports any resources that it depends on. </p> <ul> <li> <p>A bot exports dependent intents.</p> </li> <li> <p>An intent exports dependent slot types.</p> </li> </ul>', 'StartImportResponse$resourceType' => '<p>The type of resource to import.</p>', ], ], 'ResponseCard' => [ 'base' => NULL, 'refs' => [ 'Prompt$responseCard' => '<p>A response card. Amazon Lex uses this prompt at runtime, in the <code>PostText</code> API response. It substitutes session attributes and slot values for placeholders in the response card. For more information, see <a>ex-resp-card</a>. </p>', 'Slot$responseCard' => '<p> A set of possible responses for the slot type used by text-based clients. A user chooses an option from the response card, instead of using text to reply. </p>', 'Statement$responseCard' => '<p> At runtime, if the client is using the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> API, Amazon Lex includes the response card in the response. It substitutes all of the session attributes and slot values for placeholders in the response card. </p>', ], ], 'SessionTTL' => [ 'base' => NULL, 'refs' => [ 'CreateBotVersionResponse$idleSessionTTLInSeconds' => '<p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. For more information, see <a>PutBot</a>.</p>', 'GetBotResponse$idleSessionTTLInSeconds' => '<p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. For more information, see <a>PutBot</a>.</p>', 'PutBotRequest$idleSessionTTLInSeconds' => '<p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.</p> <p>A user interaction session remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p> <p>For example, suppose that a user chooses the OrderPizza intent, but gets sidetracked halfway through placing an order. If the user doesn\'t complete the order within the specified time, Amazon Lex discards the slot information that it gathered, and the user must start over.</p> <p>If you don\'t include the <code>idleSessionTTLInSeconds</code> element in a <code>PutBot</code> operation request, Amazon Lex uses the default value. This is also true if the request replaces an existing bot.</p> <p>The default is 300 seconds (5 minutes).</p>', 'PutBotResponse$idleSessionTTLInSeconds' => '<p>The maximum length of time that Amazon Lex retains the data gathered in a conversation. For more information, see <a>PutBot</a>.</p>', ], ], 'Slot' => [ 'base' => '<p>Identifies the version of a specific slot.</p>', 'refs' => [ 'SlotList$member' => NULL, ], ], 'SlotConstraint' => [ 'base' => NULL, 'refs' => [ 'Slot$slotConstraint' => '<p>Specifies whether the slot is required or optional. </p>', ], ], 'SlotDefaultValue' => [ 'base' => '<p>A default value for a slot.</p>', 'refs' => [ 'SlotDefaultValueList$member' => NULL, ], ], 'SlotDefaultValueList' => [ 'base' => NULL, 'refs' => [ 'SlotDefaultValueSpec$defaultValueList' => '<p>The default values for a slot. You can specify more than one default. For example, you can specify a default value to use from a matching context variable, a session attribute, or a fixed value.</p> <p>The default value chosen is selected based on the order that you specify them in the list. For example, if you specify a context variable and a fixed value in that order, Amazon Lex uses the context variable if it is available, else it uses the fixed value.</p>', ], ], 'SlotDefaultValueSpec' => [ 'base' => '<p>Contains the default values for a slot. Default values are used when Amazon Lex hasn\'t determined a value for a slot.</p>', 'refs' => [ 'Slot$defaultValueSpec' => '<p>A list of default values for the slot. Default values are used when Amazon Lex hasn\'t determined a value for a slot. You can specify default values from context variables, session attributes, and defined values.</p>', ], ], 'SlotDefaultValueString' => [ 'base' => NULL, 'refs' => [ 'SlotDefaultValue$defaultValue' => '<p>The default value for the slot. You can specify one of the following:</p> <ul> <li> <p> <code>#context-name.slot-name</code> - The slot value "slot-name" in the context "context-name."</p> </li> <li> <p> <code>{attribute}</code> - The slot value of the session attribute "attribute."</p> </li> <li> <p> <code>\'value\'</code> - The discrete value "value."</p> </li> </ul>', ], ], 'SlotList' => [ 'base' => NULL, 'refs' => [ 'CreateIntentVersionResponse$slots' => '<p>An array of slot types that defines the information required to fulfill the intent.</p>', 'GetIntentResponse$slots' => '<p>An array of intent slots configured for the intent.</p>', 'PutIntentRequest$slots' => '<p>An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using prompts defined in the slots. For more information, see <a>how-it-works</a>. </p>', 'PutIntentResponse$slots' => '<p>An array of intent slots that are configured for the intent.</p>', ], ], 'SlotName' => [ 'base' => NULL, 'refs' => [ 'Slot$name' => '<p>The name of the slot.</p>', ], ], 'SlotTypeConfiguration' => [ 'base' => '<p>Provides configuration information for a slot type.</p>', 'refs' => [ 'SlotTypeConfigurations$member' => NULL, ], ], 'SlotTypeConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateSlotTypeVersionResponse$slotTypeConfigurations' => '<p>Configuration information that extends the parent built-in slot type.</p>', 'GetSlotTypeResponse$slotTypeConfigurations' => '<p>Configuration information that extends the parent built-in slot type.</p>', 'PutSlotTypeRequest$slotTypeConfigurations' => '<p>Configuration information that extends the parent built-in slot type. The configuration is added to the settings for the parent slot type.</p>', 'PutSlotTypeResponse$slotTypeConfigurations' => '<p>Configuration information that extends the parent built-in slot type.</p>', ], ], 'SlotTypeMetadata' => [ 'base' => '<p>Provides information about a slot type..</p>', 'refs' => [ 'SlotTypeMetadataList$member' => NULL, ], ], 'SlotTypeMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetSlotTypeVersionsResponse$slotTypes' => '<p>An array of <code>SlotTypeMetadata</code> objects, one for each numbered version of the slot type plus one for the <code>$LATEST</code> version.</p>', 'GetSlotTypesResponse$slotTypes' => '<p>An array of objects, one for each slot type, that provides information such as the name of the slot type, the version, and a description.</p>', ], ], 'SlotTypeName' => [ 'base' => NULL, 'refs' => [ 'CreateSlotTypeVersionRequest$name' => '<p>The name of the slot type that you want to create a new version for. The name is case sensitive. </p>', 'CreateSlotTypeVersionResponse$name' => '<p>The name of the slot type.</p>', 'DeleteSlotTypeRequest$name' => '<p>The name of the slot type. The name is case sensitive. </p>', 'DeleteSlotTypeVersionRequest$name' => '<p>The name of the slot type.</p>', 'GetSlotTypeRequest$name' => '<p>The name of the slot type. The name is case sensitive. </p>', 'GetSlotTypeResponse$name' => '<p>The name of the slot type.</p>', 'GetSlotTypeVersionsRequest$name' => '<p>The name of the slot type for which versions should be returned.</p>', 'GetSlotTypesRequest$nameContains' => '<p>Substring to match in slot type names. A slot type will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>', 'PutSlotTypeRequest$name' => '<p>The name of the slot type. The name is <i>not</i> case sensitive. </p> <p>The name can\'t match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For example, because there is a built-in slot type called <code>AMAZON.DATE</code>, you can\'t create a custom slot type called <code>DATE</code>.</p> <p>For a list of built-in slot types, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.</p>', 'PutSlotTypeResponse$name' => '<p>The name of the slot type.</p>', 'SlotTypeMetadata$name' => '<p>The name of the slot type.</p>', ], ], 'SlotTypeRegexConfiguration' => [ 'base' => '<p>Provides a regular expression used to validate the value of a slot.</p>', 'refs' => [ 'SlotTypeConfiguration$regexConfiguration' => '<p>A regular expression used to validate the value of a slot.</p>', ], ], 'SlotUtteranceList' => [ 'base' => NULL, 'refs' => [ 'Slot$sampleUtterances' => '<p> If you know a specific pattern with which users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is capable of understanding user utterances. </p>', ], ], 'SlotValueSelectionStrategy' => [ 'base' => NULL, 'refs' => [ 'CreateSlotTypeVersionResponse$valueSelectionStrategy' => '<p>The strategy that Amazon Lex uses to determine the value of the slot. For more information, see <a>PutSlotType</a>.</p>', 'GetSlotTypeResponse$valueSelectionStrategy' => '<p>The strategy that Amazon Lex uses to determine the value of the slot. For more information, see <a>PutSlotType</a>.</p>', 'PutSlotTypeRequest$valueSelectionStrategy' => '<p>Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to one of the following values:</p> <ul> <li> <p> <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li> <li> <p> <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</p> </li> </ul> <p>If you don\'t specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.</p>', 'PutSlotTypeResponse$valueSelectionStrategy' => '<p>The slot resolution strategy that Amazon Lex uses to determine the value of the slot. For more information, see <a>PutSlotType</a>.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'GetMigrationsRequest$sortByOrder' => '<p>The order so sort the list.</p>', ], ], 'StartImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartMigrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartMigrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Statement' => [ 'base' => '<p>A collection of messages that convey information to the user. At runtime, Amazon Lex selects the message to convey. </p>', 'refs' => [ 'CreateBotVersionResponse$abortStatement' => '<p>The message that Amazon Lex uses to cancel a conversation. For more information, see <a>PutBot</a>.</p>', 'CreateIntentVersionResponse$rejectionStatement' => '<p>If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p>', 'CreateIntentVersionResponse$conclusionStatement' => '<p>After the Lambda function specified in the <code>fulfillmentActivity</code> field fulfills the intent, Amazon Lex conveys this statement to the user. </p>', 'FollowUpPrompt$rejectionStatement' => '<p>If the user answers "no" to the question defined in the <code>prompt</code> field, Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p>', 'GetBotResponse$abortStatement' => '<p>The message that Amazon Lex returns when the user elects to end the conversation without completing it. For more information, see <a>PutBot</a>.</p>', 'GetIntentResponse$rejectionStatement' => '<p>If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p>', 'GetIntentResponse$conclusionStatement' => '<p>After the Lambda function specified in the <code>fulfillmentActivity</code> element fulfills the intent, Amazon Lex conveys this statement to the user.</p>', 'PutBotRequest$abortStatement' => '<p>When Amazon Lex can\'t understand the user\'s input in context, it tries to elicit the information a few times. After that, Amazon Lex sends the message defined in <code>abortStatement</code> to the user, and then cancels the conversation. To set the number of retries, use the <code>valueElicitationPrompt</code> field for the slot type. </p> <p>For example, in a pizza ordering bot, Amazon Lex might ask a user "What type of crust would you like?" If the user\'s response is not one of the expected responses (for example, "thin crust, "deep dish," etc.), Amazon Lex tries to elicit a correct response a few more times. </p> <p>For example, in a pizza ordering application, <code>OrderPizza</code> might be one of the intents. This intent might require the <code>CrustType</code> slot. You specify the <code>valueElicitationPrompt</code> field when you create the <code>CrustType</code> slot.</p> <p>If you have defined a fallback intent the cancel statement will not be sent to the user, the fallback intent is used instead. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html"> AMAZON.FallbackIntent</a>.</p>', 'PutBotResponse$abortStatement' => '<p>The message that Amazon Lex uses to cancel a conversation. For more information, see <a>PutBot</a>.</p>', 'PutIntentRequest$rejectionStatement' => '<p>When the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p> <note> <p>You must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or neither.</p> </note>', 'PutIntentRequest$conclusionStatement' => '<p> The statement that you want Amazon Lex to convey to the user after the intent is successfully fulfilled by the Lambda function. </p> <p>This element is relevant only if you provide a Lambda function in the <code>fulfillmentActivity</code>. If you return the intent to the client application, you can\'t specify this element.</p> <note> <p>The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can specify only one.</p> </note>', 'PutIntentResponse$rejectionStatement' => '<p>If the user answers "no" to the question defined in <code>confirmationPrompt</code> Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p>', 'PutIntentResponse$conclusionStatement' => '<p>After the Lambda function specified in the<code>fulfillmentActivity</code>intent fulfills the intent, Amazon Lex conveys this statement to the user.</p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'BotMetadata$status' => '<p>The status of the bot.</p>', 'CreateBotVersionResponse$status' => '<p> When you send a request to create or update a bot, Amazon Lex sets the <code>status</code> response element to <code>BUILDING</code>. After Amazon Lex builds the bot, it sets <code>status</code> to <code>READY</code>. If Amazon Lex can\'t build the bot, it sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns the reason for the failure in the <code>failureReason</code> response element. </p>', 'GetBotResponse$status' => '<p>The status of the bot. </p> <p>When the status is <code>BUILDING</code> Amazon Lex is building the bot for testing and use.</p> <p>If the status of the bot is <code>READY_BASIC_TESTING</code>, you can test the bot using the exact utterances specified in the bot\'s intents. When the bot is ready for full testing or to run, the status is <code>READY</code>.</p> <p>If there was a problem with building the bot, the status is <code>FAILED</code> and the <code>failureReason</code> field explains why the bot did not build.</p> <p>If the bot was saved but not built, the status is <code>NOT_BUILT</code>.</p>', 'PutBotResponse$status' => '<p> When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>, Amazon Lex sets the <code>status</code> response element to <code>BUILDING</code>.</p> <p>In the <code>READY_BASIC_TESTING</code> state you can test the bot with user inputs that exactly match the utterances configured for the bot\'s intents and values in the slot types.</p> <p>If Amazon Lex can\'t build the bot, Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns the reason for the failure in the <code>failureReason</code> response element. </p> <p>When you set <code>processBehavior</code> to <code>SAVE</code>, Amazon Lex sets the status code to <code>NOT BUILT</code>.</p> <p>When the bot is in the <code>READY</code> state you can test and publish the bot.</p>', ], ], 'StatusType' => [ 'base' => NULL, 'refs' => [ 'GetUtterancesViewRequest$statusType' => '<p>To return utterances that were recognized and handled, use <code>Detected</code>. To return utterances that were not recognized, use <code>Missed</code>.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'BadRequestException$message' => NULL, 'BotAliasMetadata$checksum' => '<p>Checksum of the bot alias.</p>', 'BotChannelAssociation$failureReason' => '<p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to create the association.</p>', 'BuiltinIntentSlot$name' => '<p>A list of the slots defined for the intent.</p>', 'ChannelConfigurationMap$key' => NULL, 'ChannelConfigurationMap$value' => NULL, 'ConflictException$message' => NULL, 'CreateBotVersionRequest$checksum' => '<p>Identifies a specific revision of the <code>$LATEST</code> version of the bot. If you specify a checksum and the <code>$LATEST</code> version of the bot has a different checksum, a <code>PreconditionFailedException</code> exception is returned and Amazon Lex doesn\'t publish a new version. If you don\'t specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>', 'CreateBotVersionResponse$failureReason' => '<p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the bot.</p>', 'CreateBotVersionResponse$voiceId' => '<p>The Amazon Polly voice ID that Amazon Lex uses for voice interactions with the user.</p>', 'CreateBotVersionResponse$checksum' => '<p>Checksum identifying the version of the bot that was created.</p>', 'CreateIntentVersionRequest$checksum' => '<p>Checksum of the <code>$LATEST</code> version of the intent that should be used to create the new version. If you specify a checksum and the <code>$LATEST</code> version of the intent has a different checksum, Amazon Lex returns a <code>PreconditionFailedException</code> exception and doesn\'t publish a new version. If you don\'t specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>', 'CreateIntentVersionResponse$checksum' => '<p>Checksum of the intent version created.</p>', 'CreateSlotTypeVersionRequest$checksum' => '<p>Checksum for the <code>$LATEST</code> version of the slot type that you want to publish. If you specify a checksum and the <code>$LATEST</code> version of the slot type has a different checksum, Amazon Lex returns a <code>PreconditionFailedException</code> exception and doesn\'t publish the new version. If you don\'t specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>', 'CreateSlotTypeVersionResponse$checksum' => '<p>Checksum of the <code>$LATEST</code> version of the slot type.</p>', 'GetBotAliasResponse$checksum' => '<p>Checksum of the bot alias.</p>', 'GetBotChannelAssociationResponse$failureReason' => '<p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to create the association.</p>', 'GetBotRequest$versionOrAlias' => '<p>The version or alias of the bot.</p>', 'GetBotResponse$failureReason' => '<p>If <code>status</code> is <code>FAILED</code>, Amazon Lex explains why it failed to build the bot.</p>', 'GetBotResponse$voiceId' => '<p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. For more information, see <a>PutBot</a>.</p>', 'GetBotResponse$checksum' => '<p>Checksum of the bot used to identify a specific revision of the bot\'s <code>$LATEST</code> version.</p>', 'GetBuiltinIntentsRequest$signatureContains' => '<p>Substring to match in built-in intent signatures. An intent will be returned if any part of its signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>', 'GetBuiltinSlotTypesRequest$signatureContains' => '<p>Substring to match in built-in slot type signatures. A slot type will be returned if any part of its signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>', 'GetExportResponse$failureReason' => '<p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to export the resource.</p>', 'GetExportResponse$url' => '<p>An S3 pre-signed URL that provides the location of the exported resource. The exported resource is a ZIP archive that contains the exported resource in JSON format. The structure of the archive may change. Your code should not rely on the archive structure.</p>', 'GetImportRequest$importId' => '<p>The identifier of the import job information to return.</p>', 'GetImportResponse$importId' => '<p>The identifier for the specific import job.</p>', 'GetIntentResponse$checksum' => '<p>Checksum of the intent.</p>', 'GetSlotTypeResponse$checksum' => '<p>Checksum of the <code>$LATEST</code> version of the slot type.</p>', 'InternalFailureException$message' => NULL, 'LimitExceededException$retryAfterSeconds' => NULL, 'LimitExceededException$message' => NULL, 'NotFoundException$message' => NULL, 'PreconditionFailedException$message' => NULL, 'PutBotAliasRequest$checksum' => '<p>Identifies a specific revision of the <code>$LATEST</code> version.</p> <p>When you create a new bot alias, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p> <p>When you want to update a bot alias, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don\'t specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>', 'PutBotAliasResponse$checksum' => '<p>The checksum for the current version of the alias.</p>', 'PutBotRequest$voiceId' => '<p>The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Voices in Amazon Polly</a> in the <i>Amazon Polly Developer Guide</i>.</p>', 'PutBotRequest$checksum' => '<p>Identifies a specific revision of the <code>$LATEST</code> version.</p> <p>When you create a new bot, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p> <p>When you want to update a bot, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don\'t specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>', 'PutBotResponse$failureReason' => '<p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the bot.</p>', 'PutBotResponse$voiceId' => '<p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. For more information, see <a>PutBot</a>.</p>', 'PutBotResponse$checksum' => '<p>Checksum of the bot that you created.</p>', 'PutIntentRequest$checksum' => '<p>Identifies a specific revision of the <code>$LATEST</code> version.</p> <p>When you create a new intent, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p> <p>When you want to update a intent, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don\'t specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>', 'PutIntentResponse$checksum' => '<p>Checksum of the <code>$LATEST</code>version of the intent created or updated.</p>', 'PutSlotTypeRequest$checksum' => '<p>Identifies a specific revision of the <code>$LATEST</code> version.</p> <p>When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p> <p>When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don\'t specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>', 'PutSlotTypeResponse$checksum' => '<p>Checksum of the <code>$LATEST</code> version of the slot type.</p>', 'StartImportResponse$importId' => '<p>The identifier for the specific import job.</p>', 'StringList$member' => NULL, ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'GetImportResponse$failureReason' => '<p>A string that describes why an import job failed to complete.</p>', ], ], 'SynonymList' => [ 'base' => NULL, 'refs' => [ 'EnumerationValue$synonyms' => '<p>Additional values related to the slot type value.</p>', ], ], 'Tag' => [ 'base' => '<p>A list of key/value pairs that identify a bot, bot alias, or bot channel. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The key for the tag. Keys are not case-sensitive and must be unique.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of tag keys to remove from the resource. If a tag key does not exist on the resource, it is ignored.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceResponse$tags' => '<p>The tags associated with a resource.</p>', 'PutBotAliasRequest$tags' => '<p>A list of tags to add to the bot alias. You can only add tags when you create an alias, you can\'t use the <code>PutBotAlias</code> operation to update the tags on a bot alias. To update tags, use the <code>TagResource</code> operation.</p>', 'PutBotAliasResponse$tags' => '<p>A list of tags associated with a bot.</p>', 'PutBotRequest$tags' => '<p>A list of tags to add to the bot. You can only add tags when you create a bot, you can\'t use the <code>PutBot</code> operation to update the tags on a bot. To update tags, use the <code>TagResource</code> operation.</p>', 'PutBotResponse$tags' => '<p>A list of tags associated with the bot.</p>', 'StartImportRequest$tags' => '<p>A list of tags to add to the imported bot. You can only add tags when you import a bot, you can\'t add tags to an intent or slot type.</p>', 'StartImportResponse$tags' => '<p>A list of tags added to the imported bot.</p>', 'TagResourceRequest$tags' => '<p>A list of tag keys to add to the resource. If a tag key already exists, the existing value is replaced with the new value.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The value associated with a key. The value may be an empty string but it can\'t be null.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'BotAliasMetadata$lastUpdatedDate' => '<p>The date that the bot alias was updated. When you create a resource, the creation date and last updated date are the same.</p>', 'BotAliasMetadata$createdDate' => '<p>The date that the bot alias was created.</p>', 'BotChannelAssociation$createdDate' => '<p>The date that the association between the Amazon Lex bot and the channel was created. </p>', 'BotMetadata$lastUpdatedDate' => '<p>The date that the bot was updated. When you create a bot, the creation date and last updated date are the same. </p>', 'BotMetadata$createdDate' => '<p>The date that the bot was created.</p>', 'CreateBotVersionResponse$lastUpdatedDate' => '<p>The date when the <code>$LATEST</code> version of this bot was updated. </p>', 'CreateBotVersionResponse$createdDate' => '<p>The date when the bot version was created.</p>', 'CreateIntentVersionResponse$lastUpdatedDate' => '<p>The date that the intent was updated. </p>', 'CreateIntentVersionResponse$createdDate' => '<p>The date that the intent was created.</p>', 'CreateSlotTypeVersionResponse$lastUpdatedDate' => '<p>The date that the slot type was updated. When you create a resource, the creation date and last update date are the same.</p>', 'CreateSlotTypeVersionResponse$createdDate' => '<p>The date that the slot type was created.</p>', 'GetBotAliasResponse$lastUpdatedDate' => '<p>The date that the bot alias was updated. When you create a resource, the creation date and the last updated date are the same.</p>', 'GetBotAliasResponse$createdDate' => '<p>The date that the bot alias was created.</p>', 'GetBotChannelAssociationResponse$createdDate' => '<p>The date that the association between the bot and the channel was created.</p>', 'GetBotResponse$lastUpdatedDate' => '<p>The date that the bot was updated. When you create a resource, the creation date and last updated date are the same. </p>', 'GetBotResponse$createdDate' => '<p>The date that the bot was created.</p>', 'GetImportResponse$createdDate' => '<p>A timestamp for the date and time that the import job was created.</p>', 'GetIntentResponse$lastUpdatedDate' => '<p>The date that the intent was updated. When you create a resource, the creation date and the last updated date are the same. </p>', 'GetIntentResponse$createdDate' => '<p>The date that the intent was created.</p>', 'GetMigrationResponse$migrationTimestamp' => '<p>The date and time that the migration started.</p>', 'GetSlotTypeResponse$lastUpdatedDate' => '<p>The date that the slot type was updated. When you create a resource, the creation date and last update date are the same.</p>', 'GetSlotTypeResponse$createdDate' => '<p>The date that the slot type was created.</p>', 'IntentMetadata$lastUpdatedDate' => '<p>The date that the intent was updated. When you create an intent, the creation date and last updated date are the same.</p>', 'IntentMetadata$createdDate' => '<p>The date that the intent was created.</p>', 'MigrationSummary$migrationTimestamp' => '<p>The date and time that the migration started.</p>', 'PutBotAliasResponse$lastUpdatedDate' => '<p>The date that the bot alias was updated. When you create a resource, the creation date and the last updated date are the same.</p>', 'PutBotAliasResponse$createdDate' => '<p>The date that the bot alias was created.</p>', 'PutBotResponse$lastUpdatedDate' => '<p>The date that the bot was updated. When you create a resource, the creation date and last updated date are the same.</p>', 'PutBotResponse$createdDate' => '<p>The date that the bot was created.</p>', 'PutIntentResponse$lastUpdatedDate' => '<p>The date that the intent was updated. When you create a resource, the creation date and last update dates are the same.</p>', 'PutIntentResponse$createdDate' => '<p>The date that the intent was created.</p>', 'PutSlotTypeResponse$lastUpdatedDate' => '<p>The date that the slot type was updated. When you create a slot type, the creation date and last update date are the same.</p>', 'PutSlotTypeResponse$createdDate' => '<p>The date that the slot type was created.</p>', 'SlotTypeMetadata$lastUpdatedDate' => '<p>The date that the slot type was updated. When you create a resource, the creation date and last updated date are the same. </p>', 'SlotTypeMetadata$createdDate' => '<p>The date that the slot type was created.</p>', 'StartImportResponse$createdDate' => '<p>A timestamp for the date and time that the import job was requested.</p>', 'StartMigrationResponse$migrationTimestamp' => '<p>The date and time that the migration started.</p>', 'UtteranceData$firstUtteredDate' => '<p>The date that the utterance was first recorded.</p>', 'UtteranceData$lastUtteredDate' => '<p>The date that the utterance was last recorded.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'DeleteUtterancesRequest$userId' => '<p> The unique identifier for the user that made the utterances. This is the user ID that was sent in the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> operation request that contained the utterance.</p>', ], ], 'Utterance' => [ 'base' => NULL, 'refs' => [ 'IntentUtteranceList$member' => NULL, 'SlotUtteranceList$member' => NULL, ], ], 'UtteranceData' => [ 'base' => '<p>Provides information about a single utterance that was made to your bot. </p>', 'refs' => [ 'ListOfUtterance$member' => NULL, ], ], 'UtteranceList' => [ 'base' => '<p>Provides a list of utterances that have been made to a specific version of your bot. The list contains a maximum of 100 utterances.</p>', 'refs' => [ 'ListsOfUtterances$member' => NULL, ], ], 'UtteranceString' => [ 'base' => NULL, 'refs' => [ 'UtteranceData$utteranceString' => '<p>The text that was entered by the user or the text representation of an audio clip.</p>', ], ], 'V2BotId' => [ 'base' => NULL, 'refs' => [ 'GetMigrationResponse$v2BotId' => '<p>The unique identifier of the Amazon Lex V2 bot that the Amazon Lex V1 is being migrated to.</p>', 'MigrationSummary$v2BotId' => '<p>The unique identifier of the Amazon Lex V2 that is the destination of the migration.</p>', 'StartMigrationResponse$v2BotId' => '<p>The unique identifier for the Amazon Lex V2 bot. </p>', ], ], 'V2BotName' => [ 'base' => NULL, 'refs' => [ 'StartMigrationRequest$v2BotName' => '<p>The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex V1 bot to. </p> <ul> <li> <p>If the Amazon Lex V2 bot doesn\'t exist, you must use the <code>CREATE_NEW</code> migration strategy.</p> </li> <li> <p>If the Amazon Lex V2 bot exists, you must use the <code>UPDATE_EXISTING</code> migration strategy to change the contents of the Amazon Lex V2 bot.</p> </li> </ul>', ], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'EnumerationValue$value' => '<p>The value of the slot type.</p>', 'SynonymList$member' => NULL, ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'BotAliasMetadata$botVersion' => '<p>The version of the Amazon Lex bot to which the alias points.</p>', 'BotMetadata$version' => '<p>The version of the bot. For a new bot, the version is always <code>$LATEST</code>.</p>', 'BotVersions$member' => NULL, 'CreateBotVersionResponse$version' => '<p>The version of the bot. </p>', 'CreateIntentVersionResponse$version' => '<p>The version number assigned to the new version of the intent.</p>', 'CreateSlotTypeVersionResponse$version' => '<p>The version assigned to the new slot type version. </p>', 'GetBotAliasResponse$botVersion' => '<p>The version of the bot that the alias points to.</p>', 'GetBotResponse$version' => '<p>The version of the bot. For a new bot, the version is always <code>$LATEST</code>.</p>', 'GetIntentRequest$version' => '<p>The version of the intent.</p>', 'GetIntentResponse$version' => '<p>The version of the intent.</p>', 'GetMigrationResponse$v1BotVersion' => '<p>The version of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>', 'GetSlotTypeRequest$version' => '<p>The version of the slot type. </p>', 'GetSlotTypeResponse$version' => '<p>The version of the slot type.</p>', 'Intent$intentVersion' => '<p>The version of the intent.</p>', 'IntentMetadata$version' => '<p>The version of the intent.</p>', 'MigrationSummary$v1BotVersion' => '<p>The version of the Amazon Lex V1 bot that is the source of the migration.</p>', 'PutBotAliasRequest$botVersion' => '<p>The version of the bot.</p>', 'PutBotAliasResponse$botVersion' => '<p>The version of the bot that the alias points to.</p>', 'PutBotResponse$version' => '<p>The version of the bot. For a new bot, the version is always <code>$LATEST</code>.</p>', 'PutIntentResponse$version' => '<p>The version of the intent. For a new intent, the version is always <code>$LATEST</code>.</p>', 'PutSlotTypeResponse$version' => '<p>The version of the slot type. For a new slot type, the version is always <code>$LATEST</code>. </p>', 'ResourceReference$version' => '<p>The version of the resource that is using the resource that you are trying to delete.</p>', 'Slot$slotTypeVersion' => '<p>The version of the slot type.</p>', 'SlotTypeMetadata$version' => '<p>The version of the slot type.</p>', 'StartMigrationRequest$v1BotVersion' => '<p>The version of the bot to migrate to Amazon Lex V2. You can migrate the <code>$LATEST</code> version as well as any numbered version.</p>', 'StartMigrationResponse$v1BotVersion' => '<p>The version of the bot to migrate to Amazon Lex V2. </p>', 'UtteranceList$botVersion' => '<p>The version of the bot that processed the list.</p>', ], ], 'roleArn' => [ 'base' => NULL, 'refs' => [ 'KendraConfiguration$role' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permission to search the Amazon Kendra index. The role must be in the same account and Region as the Amazon Lex bot. If the role does not exist, you get an exception when you call the <code>PutIntent</code> operation.</p>', ], ], ],];
