<?php
// This file was auto-generated from sdk-root/src/data/rbin/2021-06-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the <i>Recycle Bin API Reference</i>. This documentation provides descriptions and syntax for each of the actions and data types in Recycle Bin.</p> <p>Recycle Bin is a snapshot recovery feature that enables you to restore accidentally deleted snapshots. When using Recycle Bin, if your snapshots are deleted, they are retained in the Recycle Bin for a time period that you specify.</p> <p>You can restore a snapshot from the Recycle Bin at any time before its retention period expires. After you restore a snapshot from the Recycle Bin, the snapshot is removed from the Recycle Bin, and you can then use it in the same way you use any other snapshot in your account. If the retention period expires and the snapshot is not restored, the snapshot is permanently deleted from the Recycle Bin and is no longer available for recovery. For more information about Recycle Bin, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-recycle-bin.html"> Recycle Bin</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'operations' => [ 'CreateRule' => '<p>Creates a Recycle Bin retention rule. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-create-rule"> Create Recycle Bin retention rules</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'DeleteRule' => '<p>Deletes a Recycle Bin retention rule. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-delete-rule"> Delete Recycle Bin retention rules</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'GetRule' => '<p>Gets information about a Recycle Bin retention rule.</p>', 'ListRules' => '<p>Lists the Recycle Bin retention rules in the Region.</p>', 'ListTagsForResource' => '<p>Lists the tags assigned a specific resource.</p>', 'TagResource' => '<p>Assigns tags to the specified resource.</p>', 'UntagResource' => '<p>Unassigns a tag from a resource.</p>', 'UpdateRule' => '<p>Updates an existing Recycle Bin retention rule. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-update-rule"> Update Recycle Bin retention rules</a> in the <i>Amazon EC2 User Guide</i>.</p>', ], 'shapes' => [ 'CreateRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$Description' => '<p>A brief description for the retention rule.</p>', 'CreateRuleResponse$Description' => '<p>The retention rule description.</p>', 'GetRuleResponse$Description' => '<p>The description assigned to the retention rule.</p>', 'RuleSummary$Description' => '<p>The description for the retention rule.</p>', 'UpdateRuleRequest$Description' => '<p>The retention rule description.</p>', 'UpdateRuleResponse$Description' => '<p>The retention rule description.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'GetRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>The service could not respond to the request due to an internal problem.</p>', 'refs' => [], ], 'ListRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListRulesRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListRulesRequest$NextToken' => '<p>The token to use to retrieve the next page of results.</p>', 'ListRulesResponse$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource was not found.</p>', 'refs' => [], ], 'ResourceNotFoundExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$Reason' => '<p>The reason for the exception.</p>', ], ], 'ResourceTag' => [ 'base' => '<p>Information about a resource tag used to identify resources that are to be retained by a Recycle Bin retention rule.</p>', 'refs' => [ 'ResourceTags$member' => NULL, ], ], 'ResourceTagKey' => [ 'base' => NULL, 'refs' => [ 'ResourceTag$ResourceTagKey' => '<p>The tag key.</p>', ], ], 'ResourceTagValue' => [ 'base' => NULL, 'refs' => [ 'ResourceTag$ResourceTagValue' => '<p>The tag value.</p>', ], ], 'ResourceTags' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$ResourceTags' => '<p>Information about the resource tags to use to identify resources that are to be retained by the retention rule. The retention rule retains only deleted snapshots that have one or more of the specified tag key and value pairs. If a snapshot is deleted, but it does not have any of the specified tag key and value pairs, it is immediately deleted without being retained by the retention rule.</p> <p>You can add the same tag key and value pair to a maximum or five retention rules.</p>', 'CreateRuleResponse$ResourceTags' => '<p>Information about the resource tags used to identify resources that are retained by the retention rule.</p>', 'GetRuleResponse$ResourceTags' => '<p>The resource tags used to identify resources that are to be retained by the retention rule.</p>', 'ListRulesRequest$ResourceTags' => '<p>The tags used to identify resources that are to be retained by the retention rule.</p>', 'UpdateRuleRequest$ResourceTags' => '<p>Information about the resource tags to use to identify resources that are to be retained by the retention rule. The retention rule retains only deleted snapshots that have one or more of the specified tag key and value pairs. If a snapshot is deleted, but it does not have any of the specified tag key and value pairs, it is immediately deleted without being retained by the retention rule. </p> <p>You can add the same tag key and value pair to a maximum or five retention rules.</p>', 'UpdateRuleResponse$ResourceTags' => '<p>Information about the resource tags used to identify resources that are retained by the retention rule.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$ResourceType' => '<p>The resource type to be retained by the retention rule. Currently, only Amazon EBS snapshots are supported.</p>', 'CreateRuleResponse$ResourceType' => '<p>The resource type retained by the retention rule.</p>', 'GetRuleResponse$ResourceType' => '<p>The resource type retained by the retention rule. Currently, only Amazon EBS snapshots are supported.</p>', 'ListRulesRequest$ResourceType' => '<p>The resource type retained by the retention rule. Only retention rules that retain the specified resource type are listed.</p>', 'UpdateRuleRequest$ResourceType' => '<p>The resource type to be retained by the retention rule. Currently, only Amazon EBS snapshots are supported.</p>', 'UpdateRuleResponse$ResourceType' => '<p>The resource type retained by the retention rule.</p>', ], ], 'RetentionPeriod' => [ 'base' => '<p>Information about the retention period for which a retention rule is to retain resources.</p>', 'refs' => [ 'CreateRuleRequest$RetentionPeriod' => '<p>Information about the retention period for which the retention rule is to retain resources.</p>', 'CreateRuleResponse$RetentionPeriod' => NULL, 'GetRuleResponse$RetentionPeriod' => '<p>Information about the period for which the retention rule retains resources.</p>', 'RuleSummary$RetentionPeriod' => '<p>Information about the retention period for which the retention rule retains resources</p>', 'UpdateRuleRequest$RetentionPeriod' => '<p>Information about the retention period for which the retention rule is to retain resources.</p>', 'UpdateRuleResponse$RetentionPeriod' => NULL, ], ], 'RetentionPeriodUnit' => [ 'base' => NULL, 'refs' => [ 'RetentionPeriod$RetentionPeriodUnit' => '<p>The unit of time in which the retention period is measured. Currently, only <code>DAYS</code> is supported.</p>', ], ], 'RetentionPeriodValue' => [ 'base' => NULL, 'refs' => [ 'RetentionPeriod$RetentionPeriodValue' => '<p>The period value for which the retention rule is to retain resources. The period is measured using the unit specified for <b>RetentionPeriodUnit</b>.</p>', ], ], 'RuleArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which to list the tags.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to which to assign the tags.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource from which to unassign the tags.</p>', ], ], 'RuleIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateRuleResponse$Identifier' => '<p>The unique identifier of the retention rule.</p>', 'DeleteRuleRequest$Identifier' => '<p>The unique ID of the retention rule to delete.</p>', 'GetRuleRequest$Identifier' => '<p>The unique ID of the retention rule.</p>', 'GetRuleResponse$Identifier' => '<p>The unique ID of the retention rule.</p>', 'RuleSummary$Identifier' => '<p>The unique ID of the retention rule.</p>', 'UpdateRuleRequest$Identifier' => '<p>The unique ID of the retention rule to update.</p>', 'UpdateRuleResponse$Identifier' => '<p>The unique ID of the retention rule.</p>', ], ], 'RuleStatus' => [ 'base' => NULL, 'refs' => [ 'CreateRuleResponse$Status' => '<p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>', 'GetRuleResponse$Status' => '<p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>', 'UpdateRuleResponse$Status' => '<p>The state of the retention rule. Only retention rules that are in the <code>available</code> state retain snapshots.</p>', ], ], 'RuleSummary' => [ 'base' => '<p>Information about a Recycle Bin retention rule.</p>', 'refs' => [ 'RuleSummaryList$member' => NULL, ], ], 'RuleSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRulesResponse$Rules' => '<p>Information about the retention rules.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request would cause a service quota for the number of tags per resource to be exceeded.</p>', 'refs' => [], ], 'ServiceQuotaExceededExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$Reason' => '<p>The reason for the exception.</p>', ], ], 'Tag' => [ 'base' => '<p>Information about the tags assigned to a Recycle Bin retention rule.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The tag key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>Information about the tags to unassign from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$Tags' => '<p>Information about the tags to assign to the retention rule.</p>', 'CreateRuleResponse$Tags' => '<p>The tags assigned to the retention rule.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Information about the tags assigned to the resource.</p>', 'TagResourceRequest$Tags' => '<p>Information about the tags to assign to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The tag value.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>One or more of the parameters in the request is not valid.</p>', 'refs' => [], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Reason' => '<p>The reason for the exception.</p>', ], ], ],];
