<?php
// This file was auto-generated from sdk-root/src/data/route53-recovery-cluster/2019-12-02/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the Amazon Route 53 Application Recovery Controller API Reference Guide for Recovery Control Data Plane .</p> <p>Recovery control in Route 53 Application Recovery Controller includes extremely reliable routing controls that enable you to recover applications by rerouting traffic, for example, across Availability Zones or AWS Regions. Routing controls are simple on/off switches hosted on a cluster. A cluster is a set of five redundant regional endpoints against which you can execute API calls to update or get the state of routing controls. You use routing controls to failover traffic to recover your application across Availability Zones or Regions.</p> <p>This API guide includes information about how to get and update routing control states in Route 53 Application Recovery Controller.</p> <p>For more information about Route 53 Application Recovery Controller, see the following:</p> <ul> <li> <p>You can create clusters, routing controls, and control panels by using the control plane API for Recovery Control. For more information, see <a href="https://docs.aws.amazon.com/recovery-cluster/latest/api/">Amazon Route 53 Application Recovery Controller Recovery Control API Reference</a>.</p> </li> <li> <p>Route 53 Application Recovery Controller also provides continuous readiness checks to ensure that your applications are scaled to handle failover traffic. For more information about the related API actions, see <a href="https://docs.aws.amazon.com/recovery-readiness/latest/api/">Amazon Route 53 Application Recovery Controller Recovery Readiness API Reference</a>.</p> </li> <li> <p>For more information about creating resilient applications and preparing for recovery readiness with Route 53 Application Recovery Controller, see the <a href="r53recovery/latest/dg/">Amazon Route 53 Application Recovery Controller Developer Guide</a>.</p> </li> </ul>', 'operations' => [ 'GetRoutingControlState' => '<p>Get the state for a routing control. A routing control is a simple on/off switch that you can use to route traffic to cells. When the state is On, traffic flows to a cell. When it\'s off, traffic does not flow. </p> <p>Before you can create a routing control, you first must create a cluster to host the control. For more information, see <a href="https://docs.aws.amazon.com/recovery-cluster/latest/api/cluster.html">CreateCluster</a>. Access one of the endpoints for the cluster to get or update the routing control state to redirect traffic.</p> <p>For more information about working with routing controls, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html">Routing control</a> in the Route 53 Application Recovery Controller Developer Guide.</p>', 'UpdateRoutingControlState' => '<p>Set the state of the routing control to reroute traffic. You can set the value to be On or Off. When the state is On, traffic flows to a cell. When it\'s off, traffic does not flow.</p> <p>For more information about working with routing controls, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html">Routing control</a> in the Route 53 Application Recovery Controller Developer Guide.</p>', 'UpdateRoutingControlStates' => '<p>Set multiple routing control states. You can set the value for each state to be On or Off. When the state is On, traffic flows to a cell. When it\'s off, traffic does not flow.</p> <p>For more information about working with routing controls, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.html">Routing control</a> in the Route 53 Application Recovery Controller Developer Guide.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have sufficient permissions to query the routing control state.</p>', 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'GetRoutingControlStateRequest$RoutingControlArn' => '<p>The Amazon Resource Number (ARN) for the routing control that you want to get the state for.</p>', 'GetRoutingControlStateResponse$RoutingControlArn' => '<p>The Amazon Resource Number (ARN) of the response.</p>', 'UpdateRoutingControlStateEntry$RoutingControlArn' => '<p>The Amazon Resource Number (ARN) for the routing control state entry.</p>', 'UpdateRoutingControlStateRequest$RoutingControlArn' => '<p>The Amazon Resource Number (ARN) for the routing control that you want to update the state for.</p>', ], ], 'ConflictException' => [ 'base' => '<p>There was a conflict with this request. Try again.</p>', 'refs' => [], ], 'EndpointTemporarilyUnavailableException' => [ 'base' => '<p>The cluster endpoint isn\'t available. Try another cluster endpoint.</p>', 'refs' => [], ], 'GetRoutingControlStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRoutingControlStateResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>There was an unexpected error during processing of the request.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request references a routing control that was not found.</p>', 'refs' => [], ], 'RetryAfterSeconds' => [ 'base' => 'Advice to clients on when the call can be safely retried', 'refs' => [ 'InternalServerException$retryAfterSeconds' => NULL, 'ThrottlingException$retryAfterSeconds' => NULL, ], ], 'RoutingControlState' => [ 'base' => NULL, 'refs' => [ 'GetRoutingControlStateResponse$RoutingControlState' => '<p>The state of the routing control.</p>', 'UpdateRoutingControlStateEntry$RoutingControlState' => '<p>The routing control state in a set of routing control state entries.</p>', 'UpdateRoutingControlStateRequest$RoutingControlState' => '<p>The state of the routing control. You can set the value to be On or Off.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => 'Description of the ConflictException error', 'ConflictException$resourceId' => 'Identifier of the resource in use', 'ConflictException$resourceType' => 'Type of the resource in use', 'EndpointTemporarilyUnavailableException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => 'Hypothetical resource identifier that was not found', 'ResourceNotFoundException$resourceType' => 'Hypothetical resource type that was not found', 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, 'ValidationExceptionField$name' => '<p>The field that had the validation exception.</p>', 'ValidationExceptionField$message' => '<p>Information about the validation exception.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied because of request throttling.</p>', 'refs' => [], ], 'UpdateRoutingControlStateEntries' => [ 'base' => NULL, 'refs' => [ 'UpdateRoutingControlStatesRequest$UpdateRoutingControlStateEntries' => '<p>A set of routing control entries that you want to update.</p>', ], ], 'UpdateRoutingControlStateEntry' => [ 'base' => '<p>A routing control state.</p>', 'refs' => [ 'UpdateRoutingControlStateEntries$member' => NULL, ], ], 'UpdateRoutingControlStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingControlStateResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingControlStatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingControlStatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>There was a validation error on the request.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>There was a validation error on the request.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => 'The fields that caused the error, if applicable', 'refs' => [ 'ValidationException$fields' => NULL, ], ], 'ValidationExceptionReason' => [ 'base' => 'Reason the request failed validation', 'refs' => [ 'ValidationException$reason' => NULL, ], ], ],];
