<?php
// This file was auto-generated from sdk-root/src/data/s3control/2018-08-20/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> Amazon Web Services S3 Control provides access to Amazon S3 control plane actions. </p>', 'operations' => [ 'CreateAccessPoint' => '<p>Creates an access point and associates it with the specified bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing Data Access with Amazon S3 Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p/> <note> <p>S3 on Outposts only supports VPC-style access points. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html"> Accessing Amazon S3 on Outposts using virtual private cloud (VPC) only access points</a> in the <i>Amazon S3 User Guide</i>.</p> </note> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html#API_control_CreateAccessPoint_Examples">Examples</a> section.</p> <p/> <p>The following actions are related to <code>CreateAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a> </p> </li> </ul>', 'CreateAccessPointForObjectLambda' => '<p>Creates an Object Lambda Access Point. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/transforming-objects.html">Transforming objects with Object Lambda Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>CreateAccessPointForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">DeleteAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">GetAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">ListAccessPointsForObjectLambda</a> </p> </li> </ul>', 'CreateBucket' => '<note> <p>This action creates an Amazon S3 on Outposts bucket. To create an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">Create Bucket</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Creates a new Outposts bucket. By creating the bucket, you become the bucket owner. To create an Outposts bucket, you must have S3 on Outposts. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p> <p>Not every string is an acceptable bucket name. For information on bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html#bucketnamingrules">Working with Amazon S3 Buckets</a>.</p> <p>S3 on Outposts buckets support:</p> <ul> <li> <p>Tags</p> </li> <li> <p>LifecycleConfigurations for deleting expired objects</p> </li> </ul> <p>For a complete list of restrictions and Amazon S3 feature limitations on S3 on Outposts, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OnOutpostsRestrictionsLimitations.html"> Amazon S3 on Outposts Restrictions and Limitations</a>.</p> <p>For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and <code>x-amz-outpost-id</code> in your API request, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html#API_control_CreateBucket_Examples">Examples</a> section.</p> <p>The following actions are related to <code>CreateBucket</code> for Amazon S3 on Outposts:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html">GetBucket</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html">DeleteBucket</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">PutAccessPointPolicy</a> </p> </li> </ul>', 'CreateJob' => '<p>You can use S3 Batch Operations to perform large-scale batch actions on Amazon S3 objects. Batch Operations can run a single action on lists of Amazon S3 objects that you specify. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p> <p>This action creates a S3 Batch Operations job.</p> <p/> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_JobOperation.html">JobOperation</a> </p> </li> </ul>', 'CreateMultiRegionAccessPoint' => '<p>Creates a Multi-Region Access Point and associates it with the specified buckets. For more information about creating Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html">Creating Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>This request is asynchronous, meaning that you might receive a response before the command has completed. When this request provides a response, it provides a token that you can use to monitor the status of the request with <code>DescribeMultiRegionAccessPointOperation</code>.</p> <p>The following actions are related to <code>CreateMultiRegionAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a> </p> </li> </ul>', 'DeleteAccessPoint' => '<p>Deletes the specified access point.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html#API_control_DeleteAccessPoint_Examples">Examples</a> section.</p> <p>The following actions are related to <code>DeleteAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a> </p> </li> </ul>', 'DeleteAccessPointForObjectLambda' => '<p>Deletes the specified Object Lambda Access Point.</p> <p>The following actions are related to <code>DeleteAccessPointForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">CreateAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">GetAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">ListAccessPointsForObjectLambda</a> </p> </li> </ul>', 'DeleteAccessPointPolicy' => '<p>Deletes the access point policy for the specified access point.</p> <p/> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html#API_control_DeleteAccessPointPolicy_Examples">Examples</a> section.</p> <p>The following actions are related to <code>DeleteAccessPointPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">PutAccessPointPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html">GetAccessPointPolicy</a> </p> </li> </ul>', 'DeleteAccessPointPolicyForObjectLambda' => '<p>Removes the resource policy for an Object Lambda Access Point.</p> <p>The following actions are related to <code>DeleteAccessPointPolicyForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html">GetAccessPointPolicyForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html">PutAccessPointPolicyForObjectLambda</a> </p> </li> </ul>', 'DeleteBucket' => '<note> <p>This action deletes an Amazon S3 on Outposts bucket. To delete an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Deletes the Amazon S3 on Outposts bucket. All objects (including all object versions and delete markers) in the bucket must be deleted before the bucket itself can be deleted. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html#API_control_DeleteBucket_Examples">Examples</a> section.</p> <p class="title"> <b>Related Resources</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html">CreateBucket</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html">GetBucket</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a> </p> </li> </ul>', 'DeleteBucketLifecycleConfiguration' => '<note> <p>This action deletes an Amazon S3 on Outposts bucket\'s lifecycle configuration. To delete an S3 bucket\'s lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html">DeleteBucketLifecycle</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Deletes the lifecycle configuration from the specified Outposts bucket. Amazon S3 on Outposts removes all the lifecycle configuration rules in the lifecycle subresource associated with the bucket. Your objects never expire, and Amazon S3 on Outposts no longer automatically deletes any objects on the basis of rules contained in the deleted lifecycle configuration. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p> <p>To use this action, you must have permission to perform the <code>s3-outposts:DeleteLifecycleConfiguration</code> action. By default, the bucket owner has this permission and the Outposts bucket owner can grant this permission to others.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html#API_control_DeleteBucketLifecycleConfiguration_Examples">Examples</a> section.</p> <p>For more information about object expiration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions">Elements to Describe Lifecycle Actions</a>.</p> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a> </p> </li> </ul>', 'DeleteBucketPolicy' => '<note> <p>This action deletes an Amazon S3 on Outposts bucket policy. To delete an S3 bucket policy, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketPolicy.html">DeleteBucketPolicy</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>This implementation of the DELETE action uses the policy subresource to delete the policy of a specified Amazon S3 on Outposts bucket. If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the <code>s3-outposts:DeleteBucketPolicy</code> permissions on the specified Outposts bucket and belong to the bucket owner\'s account to use this action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p> <p>If you don\'t have <code>DeleteBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code> error. If you have the correct permissions, but you\'re not using an identity that belongs to the bucket owner\'s account, Amazon S3 returns a <code>405 Method Not Allowed</code> error. </p> <important> <p>As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action.</p> </important> <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>. </p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html#API_control_DeleteBucketPolicy_Examples">Examples</a> section.</p> <p>The following actions are related to <code>DeleteBucketPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html">GetBucketPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html">PutBucketPolicy</a> </p> </li> </ul>', 'DeleteBucketTagging' => '<note> <p>This action deletes an Amazon S3 on Outposts bucket\'s tags. To delete an S3 bucket tags, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html">DeleteBucketTagging</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Deletes the tags from the Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p> <p>To use this action, you must have permission to perform the <code>PutBucketTagging</code> action. By default, the bucket owner has this permission and can grant this permission to others. </p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html#API_control_DeleteBucketTagging_Examples">Examples</a> section.</p> <p>The following actions are related to <code>DeleteBucketTagging</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html">GetBucketTagging</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html">PutBucketTagging</a> </p> </li> </ul>', 'DeleteJobTagging' => '<p>Removes the entire tag set from the specified S3 Batch Operations job. To use this operation, you must have permission to perform the <code>s3:DeleteJobTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags">Controlling access and labeling jobs using tags</a> in the <i>Amazon S3 User Guide</i>.</p> <p/> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html">PutJobTagging</a> </p> </li> </ul>', 'DeleteMultiRegionAccessPoint' => '<p>Deletes a Multi-Region Access Point. This action does not delete the buckets associated with the Multi-Region Access Point, only the Multi-Region Access Point itself.</p> <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>This request is asynchronous, meaning that you might receive a response before the command has completed. When this request provides a response, it provides a token that you can use to monitor the status of the request with <code>DescribeMultiRegionAccessPointOperation</code>.</p> <p>The following actions are related to <code>DeleteMultiRegionAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a> </p> </li> </ul>', 'DeletePublicAccessBlock' => '<p>Removes the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon S3 block public access</a>.</p> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html">GetPublicAccessBlock</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html">PutPublicAccessBlock</a> </p> </li> </ul>', 'DeleteStorageLensConfiguration' => '<p>Deletes the Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>To use this action, you must have permission to perform the <code>s3:DeleteStorageLensConfiguration</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'DeleteStorageLensConfigurationTagging' => '<p>Deletes the Amazon S3 Storage Lens configuration tags. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>To use this action, you must have permission to perform the <code>s3:DeleteStorageLensConfigurationTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'DescribeJob' => '<p>Retrieves the configuration parameters and status for a Batch Operations job. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p> <p/> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li> </ul>', 'DescribeMultiRegionAccessPointOperation' => '<p>Retrieves the status of an asynchronous request to manage a Multi-Region Access Point. For more information about managing Multi-Region Access Points and how asynchronous requests work, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>GetMultiRegionAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a> </p> </li> </ul>', 'GetAccessPoint' => '<p>Returns configuration information about the specified access point.</p> <p/> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples">Examples</a> section.</p> <p>The following actions are related to <code>GetAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a> </p> </li> </ul>', 'GetAccessPointConfigurationForObjectLambda' => '<p>Returns configuration for an Object Lambda Access Point.</p> <p>The following actions are related to <code>GetAccessPointConfigurationForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointConfigurationForObjectLambda.html">PutAccessPointConfigurationForObjectLambda</a> </p> </li> </ul>', 'GetAccessPointForObjectLambda' => '<p>Returns configuration information about the specified Object Lambda Access Point</p> <p>The following actions are related to <code>GetAccessPointForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">CreateAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">DeleteAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">ListAccessPointsForObjectLambda</a> </p> </li> </ul>', 'GetAccessPointPolicy' => '<p>Returns the access point policy associated with the specified access point.</p> <p>The following actions are related to <code>GetAccessPointPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">PutAccessPointPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html">DeleteAccessPointPolicy</a> </p> </li> </ul>', 'GetAccessPointPolicyForObjectLambda' => '<p>Returns the resource policy for an Object Lambda Access Point.</p> <p>The following actions are related to <code>GetAccessPointPolicyForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html">DeleteAccessPointPolicyForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html">PutAccessPointPolicyForObjectLambda</a> </p> </li> </ul>', 'GetAccessPointPolicyStatus' => '<p>Indicates whether the specified access point currently has a policy that allows public access. For more information about public access through access points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing Data Access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>', 'GetAccessPointPolicyStatusForObjectLambda' => '<p>Returns the status of the resource policy associated with an Object Lambda Access Point.</p>', 'GetBucket' => '<p>Gets an Amazon S3 on Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html"> Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If you are using an identity other than the root user of the Amazon Web Services account that owns the Outposts bucket, the calling identity must have the <code>s3-outposts:GetBucket</code> permissions on the specified Outposts bucket and belong to the Outposts bucket owner\'s account in order to use this action. Only users from Outposts bucket owner account with the right permissions can perform actions on an Outposts bucket. </p> <p> If you don\'t have <code>s3-outposts:GetBucket</code> permissions or you\'re not using an identity that belongs to the bucket owner\'s account, Amazon S3 returns a <code>403 Access Denied</code> error.</p> <p>The following actions are related to <code>GetBucket</code> for Amazon S3 on Outposts:</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html#API_control_GetBucket_Examples">Examples</a> section.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html">CreateBucket</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html">DeleteBucket</a> </p> </li> </ul>', 'GetBucketLifecycleConfiguration' => '<note> <p>This action gets an Amazon S3 on Outposts bucket\'s lifecycle configuration. To get an S3 bucket\'s lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Returns the lifecycle configuration information set on the Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> and for information about lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html"> Object Lifecycle Management</a> in <i>Amazon S3 User Guide</i>.</p> <p>To use this action, you must have permission to perform the <code>s3-outposts:GetLifecycleConfiguration</code> action. The Outposts bucket owner has this permission, by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html#API_control_GetBucketLifecycleConfiguration_Examples">Examples</a> section.</p> <p> <code>GetBucketLifecycleConfiguration</code> has the following special error:</p> <ul> <li> <p>Error code: <code>NoSuchLifecycleConfiguration</code> </p> <ul> <li> <p>Description: The lifecycle configuration does not exist.</p> </li> <li> <p>HTTP Status Code: 404 Not Found</p> </li> <li> <p>SOAP Fault Code Prefix: Client</p> </li> </ul> </li> </ul> <p>The following actions are related to <code>GetBucketLifecycleConfiguration</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html">DeleteBucketLifecycleConfiguration</a> </p> </li> </ul>', 'GetBucketPolicy' => '<note> <p>This action gets a bucket policy for an Amazon S3 on Outposts bucket. To get a policy for an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicy.html">GetBucketPolicy</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Returns the policy of a specified Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the <code>GetBucketPolicy</code> permissions on the specified bucket and belong to the bucket owner\'s account in order to use this action.</p> <p>Only users from Outposts bucket owner account with the right permissions can perform actions on an Outposts bucket. If you don\'t have <code>s3-outposts:GetBucketPolicy</code> permissions or you\'re not using an identity that belongs to the bucket owner\'s account, Amazon S3 returns a <code>403 Access Denied</code> error.</p> <important> <p>As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action.</p> </important> <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html#API_control_GetBucketPolicy_Examples">Examples</a> section.</p> <p>The following actions are related to <code>GetBucketPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html">PutBucketPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html">DeleteBucketPolicy</a> </p> </li> </ul>', 'GetBucketTagging' => '<note> <p>This action gets an Amazon S3 on Outposts bucket\'s tags. To get an S3 bucket tags, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html">GetBucketTagging</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Returns the tag set associated with the Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <p>To use this action, you must have permission to perform the <code>GetBucketTagging</code> action. By default, the bucket owner has this permission and can grant this permission to others.</p> <p> <code>GetBucketTagging</code> has the following special error:</p> <ul> <li> <p>Error code: <code>NoSuchTagSetError</code> </p> <ul> <li> <p>Description: There is no tag set associated with the bucket.</p> </li> </ul> </li> </ul> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html#API_control_GetBucketTagging_Examples">Examples</a> section.</p> <p>The following actions are related to <code>GetBucketTagging</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html">PutBucketTagging</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html">DeleteBucketTagging</a> </p> </li> </ul>', 'GetJobTagging' => '<p>Returns the tags on an S3 Batch Operations job. To use this operation, you must have permission to perform the <code>s3:GetJobTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags">Controlling access and labeling jobs using tags</a> in the <i>Amazon S3 User Guide</i>.</p> <p/> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html">PutJobTagging</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a> </p> </li> </ul>', 'GetMultiRegionAccessPoint' => '<p>Returns configuration information about the specified Multi-Region Access Point.</p> <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>GetMultiRegionAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a> </p> </li> </ul>', 'GetMultiRegionAccessPointPolicy' => '<p>Returns the access control policy of the specified Multi-Region Access Point.</p> <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>GetMultiRegionAccessPointPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html">GetMultiRegionAccessPointPolicyStatus</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html">PutMultiRegionAccessPointPolicy</a> </p> </li> </ul>', 'GetMultiRegionAccessPointPolicyStatus' => '<p>Indicates whether the specified Multi-Region Access Point has an access control policy that allows public access.</p> <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>GetMultiRegionAccessPointPolicyStatus</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html">GetMultiRegionAccessPointPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html">PutMultiRegionAccessPointPolicy</a> </p> </li> </ul>', 'GetPublicAccessBlock' => '<p>Retrieves the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon S3 block public access</a>.</p> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html">DeletePublicAccessBlock</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html">PutPublicAccessBlock</a> </p> </li> </ul>', 'GetStorageLensConfiguration' => '<p>Gets the Amazon S3 Storage Lens configuration. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>To use this action, you must have permission to perform the <code>s3:GetStorageLensConfiguration</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'GetStorageLensConfigurationTagging' => '<p>Gets the tags of Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>To use this action, you must have permission to perform the <code>s3:GetStorageLensConfigurationTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'ListAccessPoints' => '<p>Returns a list of the access points currently associated with the specified bucket. You can retrieve up to 1000 access points per call. If the specified bucket has more than 1,000 access points (or the number specified in <code>maxResults</code>, whichever is less), the response will include a continuation token that you can use to list the additional access points.</p> <p/> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples">Examples</a> section.</p> <p>The following actions are related to <code>ListAccessPoints</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a> </p> </li> </ul>', 'ListAccessPointsForObjectLambda' => '<p>Returns a list of the access points associated with the Object Lambda Access Point. You can retrieve up to 1000 access points per call. If there are more than 1,000 access points (or the number specified in <code>maxResults</code>, whichever is less), the response will include a continuation token that you can use to list the additional access points.</p> <p>The following actions are related to <code>ListAccessPointsForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">CreateAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">DeleteAccessPointForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">GetAccessPointForObjectLambda</a> </p> </li> </ul>', 'ListJobs' => '<p>Lists current S3 Batch Operations jobs and jobs that have ended within the last 30 days for the Amazon Web Services account making the request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p> <p>Related actions include:</p> <p/> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li> </ul>', 'ListMultiRegionAccessPoints' => '<p>Returns a list of the Multi-Region Access Points currently associated with the specified Amazon Web Services account. Each call can return up to 100 Multi-Region Access Points, the maximum number of Multi-Region Access Points that can be associated with a single account.</p> <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>ListMultiRegionAccessPoint</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a> </p> </li> </ul>', 'ListRegionalBuckets' => '<p>Returns a list of all Outposts buckets in an Outpost that are owned by the authenticated sender of the request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <p>For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and <code>x-amz-outpost-id</code> in your request, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListRegionalBuckets.html#API_control_ListRegionalBuckets_Examples">Examples</a> section.</p>', 'ListStorageLensConfigurations' => '<p>Gets a list of Amazon S3 Storage Lens configurations. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>To use this action, you must have permission to perform the <code>s3:ListStorageLensConfigurations</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'PutAccessPointConfigurationForObjectLambda' => '<p>Replaces configuration for an Object Lambda Access Point.</p> <p>The following actions are related to <code>PutAccessPointConfigurationForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointConfigurationForObjectLambda.html">GetAccessPointConfigurationForObjectLambda</a> </p> </li> </ul>', 'PutAccessPointPolicy' => '<p>Associates an access policy with the specified access point. Each access point can have only one policy, so a request made to this API replaces any existing policy associated with the specified access point.</p> <p/> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html#API_control_PutAccessPointPolicy_Examples">Examples</a> section.</p> <p>The following actions are related to <code>PutAccessPointPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html">GetAccessPointPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html">DeleteAccessPointPolicy</a> </p> </li> </ul>', 'PutAccessPointPolicyForObjectLambda' => '<p>Creates or replaces resource policy for an Object Lambda Access Point. For an example policy, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-create.html#olap-create-cli">Creating Object Lambda Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>PutAccessPointPolicyForObjectLambda</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html">DeleteAccessPointPolicyForObjectLambda</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html">GetAccessPointPolicyForObjectLambda</a> </p> </li> </ul>', 'PutBucketLifecycleConfiguration' => '<note> <p>This action puts a lifecycle configuration to an Amazon S3 on Outposts bucket. To put a lifecycle configuration to an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces an existing lifecycle configuration. Outposts buckets only support lifecycle configurations that delete/expire objects after a certain period of time and abort incomplete multipart uploads.</p> <p/> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html#API_control_PutBucketLifecycleConfiguration_Examples">Examples</a> section.</p> <p>The following actions are related to <code>PutBucketLifecycleConfiguration</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html">DeleteBucketLifecycleConfiguration</a> </p> </li> </ul>', 'PutBucketPolicy' => '<note> <p>This action puts a bucket policy to an Amazon S3 on Outposts bucket. To put a policy on an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketPolicy.html">PutBucketPolicy</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Applies an Amazon S3 bucket policy to an Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If you are using an identity other than the root user of the Amazon Web Services account that owns the Outposts bucket, the calling identity must have the <code>PutBucketPolicy</code> permissions on the specified Outposts bucket and belong to the bucket owner\'s account in order to use this action.</p> <p>If you don\'t have <code>PutBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code> error. If you have the correct permissions, but you\'re not using an identity that belongs to the bucket owner\'s account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.</p> <important> <p> As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action. </p> </important> <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>.</p> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html#API_control_PutBucketPolicy_Examples">Examples</a> section.</p> <p>The following actions are related to <code>PutBucketPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html">GetBucketPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html">DeleteBucketPolicy</a> </p> </li> </ul>', 'PutBucketTagging' => '<note> <p>This action puts tags on an Amazon S3 on Outposts bucket. To put tags on an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html">PutBucketTagging</a> in the <i>Amazon S3 API Reference</i>. </p> </note> <p>Sets the tags for an S3 on Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p> <p>Use tags to organize your Amazon Web Services bill to reflect your own cost structure. To do this, sign up to get your Amazon Web Services account bill with tag key values included. Then, to see the cost of combined resources, organize your billing information according to resources with the same tag key values. For example, you can tag several resources with a specific application name, and then organize your billing information to see the total cost of that application across several services. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Cost allocation and tagging</a>.</p> <note> <p>Within a bucket, if you add a tag that has the same key as an existing tag, the new value overwrites the old value. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html"> Using cost allocation in Amazon S3 bucket tags</a>.</p> </note> <p>To use this action, you must have permissions to perform the <code>s3-outposts:PutBucketTagging</code> action. The Outposts bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"> Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing access permissions to your Amazon S3 resources</a>.</p> <p> <code>PutBucketTagging</code> has the following special errors:</p> <ul> <li> <p>Error code: <code>InvalidTagError</code> </p> <ul> <li> <p>Description: The tag provided was not a valid tag. This error can occur if the tag did not pass input validation. For information about tag restrictions, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html"> User-Defined Tag Restrictions</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/aws-tag-restrictions.html"> Amazon Web Services-Generated Cost Allocation Tag Restrictions</a>.</p> </li> </ul> </li> <li> <p>Error code: <code>MalformedXMLError</code> </p> <ul> <li> <p>Description: The XML provided does not match the schema.</p> </li> </ul> </li> <li> <p>Error code: <code>OperationAbortedError </code> </p> <ul> <li> <p>Description: A conflicting conditional action is currently in progress against this resource. Try again.</p> </li> </ul> </li> <li> <p>Error code: <code>InternalError</code> </p> <ul> <li> <p>Description: The service was unable to apply the provided tag to the bucket.</p> </li> </ul> </li> </ul> <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html#API_control_PutBucketTagging_Examples">Examples</a> section.</p> <p>The following actions are related to <code>PutBucketTagging</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html">GetBucketTagging</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html">DeleteBucketTagging</a> </p> </li> </ul>', 'PutJobTagging' => '<p>Sets the supplied tag-set on an S3 Batch Operations job.</p> <p>A tag is a key-value pair. You can associate S3 Batch Operations tags with any job by sending a PUT request against the tagging subresource that is associated with the job. To modify the existing tag set, you can either replace the existing tag set entirely, or make changes within the existing tag set by retrieving the existing tag set using <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a>, modify that tag set, and use this action to replace the tag set with the one you modified. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags">Controlling access and labeling jobs using tags</a> in the <i>Amazon S3 User Guide</i>. </p> <p/> <note> <ul> <li> <p>If you send this request with an empty tag set, Amazon S3 deletes the existing tag set on the Batch Operations job. If you use this method, you are charged for a Tier 1 Request (PUT). For more information, see <a href="http://aws.amazon.com/s3/pricing/">Amazon S3 pricing</a>.</p> </li> <li> <p>For deleting existing tags for your Batch Operations job, a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a> request is preferred because it achieves the same result without incurring charges.</p> </li> <li> <p>A few things to consider about using tags:</p> <ul> <li> <p>Amazon S3 limits the maximum number of tags to 50 tags per job.</p> </li> <li> <p>You can associate up to 50 tags with a job as long as they have unique tag keys.</p> </li> <li> <p>A tag key can be up to 128 Unicode characters in length, and tag values can be up to 256 Unicode characters in length.</p> </li> <li> <p>The key and values are case sensitive.</p> </li> <li> <p>For tagging-related restrictions related to characters and encodings, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined Tag Restrictions</a> in the <i>Billing and Cost Management User Guide</i>.</p> </li> </ul> </li> </ul> </note> <p/> <p>To use this action, you must have permission to perform the <code>s3:PutJobTagging</code> action.</p> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreatJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a> </p> </li> </ul>', 'PutMultiRegionAccessPointPolicy' => '<p>Associates an access control policy with the specified Multi-Region Access Point. Each Multi-Region Access Point can have only one policy, so a request made to this action replaces any existing policy that is associated with the specified Multi-Region Access Point.</p> <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p> <p>The following actions are related to <code>PutMultiRegionAccessPointPolicy</code>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html">GetMultiRegionAccessPointPolicy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html">GetMultiRegionAccessPointPolicyStatus</a> </p> </li> </ul>', 'PutPublicAccessBlock' => '<p>Creates or modifies the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon S3 block public access</a>.</p> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html">GetPublicAccessBlock</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html">DeletePublicAccessBlock</a> </p> </li> </ul>', 'PutStorageLensConfiguration' => '<p>Puts an Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Working with Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>To use this action, you must have permission to perform the <code>s3:PutStorageLensConfiguration</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'PutStorageLensConfigurationTagging' => '<p>Put or replace tags on an existing Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note> <p>To use this action, you must have permission to perform the <code>s3:PutStorageLensConfigurationTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> </note>', 'UpdateJobPriority' => '<p>Updates an existing S3 Batch Operations job\'s priority. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p> <p/> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li> </ul>', 'UpdateJobStatus' => '<p>Updates the status for the specified job. Use this action to confirm that you want to run a job or to cancel an existing job. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p> <p/> <p>Related actions include:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li> </ul>', ], 'shapes' => [ 'AbortIncompleteMultipartUpload' => [ 'base' => '<p>The container for abort incomplete multipart upload</p>', 'refs' => [ 'LifecycleRule$AbortIncompleteMultipartUpload' => '<p>Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 waits before permanently removing all parts of the upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a> in the <i>Amazon S3 User Guide</i>.</p>', ], ], 'AccessPoint' => [ 'base' => '<p>An access point used to access a bucket.</p>', 'refs' => [ 'AccessPointList$member' => NULL, ], ], 'AccessPointList' => [ 'base' => NULL, 'refs' => [ 'ListAccessPointsResult$AccessPointList' => '<p>Contains identification and configuration information for one or more access points associated with the specified bucket.</p>', ], ], 'AccessPointName' => [ 'base' => NULL, 'refs' => [ 'AccessPoint$Name' => '<p>The name of this access point.</p>', 'CreateAccessPointRequest$Name' => '<p>The name you want to assign to this access point.</p>', 'DeleteAccessPointPolicyRequest$Name' => '<p>The name of the access point whose policy you want to delete.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/accesspoint/&lt;my-accesspoint-name&gt;</code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>', 'DeleteAccessPointRequest$Name' => '<p>The name of the access point you want to delete.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/accesspoint/&lt;my-accesspoint-name&gt;</code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>', 'GetAccessPointPolicyRequest$Name' => '<p>The name of the access point whose policy you want to retrieve.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/accesspoint/&lt;my-accesspoint-name&gt;</code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>', 'GetAccessPointPolicyStatusRequest$Name' => '<p>The name of the access point whose policy status you want to retrieve.</p>', 'GetAccessPointRequest$Name' => '<p>The name of the access point whose configuration information you want to retrieve.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/accesspoint/&lt;my-accesspoint-name&gt;</code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>', 'GetAccessPointResult$Name' => '<p>The name of the specified access point.</p>', 'PutAccessPointPolicyRequest$Name' => '<p>The name of the access point that you want to associate with the specified policy.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/accesspoint/&lt;my-accesspoint-name&gt;</code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'CreateAccessPointForObjectLambdaRequest$AccountId' => '<p>The Amazon Web Services account ID for owner of the specified Object Lambda Access Point.</p>', 'CreateAccessPointRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the bucket for which you want to create an access point.</p>', 'CreateJobRequest$AccountId' => '<p>The Amazon Web Services account ID that creates the job.</p>', 'CreateMultiRegionAccessPointRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the Multi-Region Access Point also must own the underlying buckets.</p>', 'DeleteAccessPointForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'DeleteAccessPointPolicyForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'DeleteAccessPointPolicyRequest$AccountId' => '<p>The account ID for the account that owns the specified access point.</p>', 'DeleteAccessPointRequest$AccountId' => '<p>The account ID for the account that owns the specified access point.</p>', 'DeleteBucketLifecycleConfigurationRequest$AccountId' => '<p>The account ID of the lifecycle configuration to delete.</p>', 'DeleteBucketPolicyRequest$AccountId' => '<p>The account ID of the Outposts bucket.</p>', 'DeleteBucketRequest$AccountId' => '<p>The account ID that owns the Outposts bucket.</p>', 'DeleteBucketTaggingRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket tag set to be removed.</p>', 'DeleteJobTaggingRequest$AccountId' => '<p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>', 'DeleteMultiRegionAccessPointRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'DeletePublicAccessBlockRequest$AccountId' => '<p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to remove.</p>', 'DeleteStorageLensConfigurationRequest$AccountId' => '<p>The account ID of the requester.</p>', 'DeleteStorageLensConfigurationTaggingRequest$AccountId' => '<p>The account ID of the requester.</p>', 'DescribeJobRequest$AccountId' => '<p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>', 'DescribeMultiRegionAccessPointOperationRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'GetAccessPointConfigurationForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'GetAccessPointForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'GetAccessPointPolicyForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'GetAccessPointPolicyRequest$AccountId' => '<p>The account ID for the account that owns the specified access point.</p>', 'GetAccessPointPolicyStatusForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'GetAccessPointPolicyStatusRequest$AccountId' => '<p>The account ID for the account that owns the specified access point.</p>', 'GetAccessPointRequest$AccountId' => '<p>The account ID for the account that owns the specified access point.</p>', 'GetBucketLifecycleConfigurationRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'GetBucketPolicyRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'GetBucketRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'GetBucketTaggingRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'GetJobTaggingRequest$AccountId' => '<p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>', 'GetMultiRegionAccessPointPolicyRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'GetMultiRegionAccessPointPolicyStatusRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'GetMultiRegionAccessPointRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'GetPublicAccessBlockRequest$AccountId' => '<p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to retrieve.</p>', 'GetStorageLensConfigurationRequest$AccountId' => '<p>The account ID of the requester.</p>', 'GetStorageLensConfigurationTaggingRequest$AccountId' => '<p>The account ID of the requester.</p>', 'ListAccessPointsForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'ListAccessPointsRequest$AccountId' => '<p>The Amazon Web Services account ID for owner of the bucket whose access points you want to list.</p>', 'ListJobsRequest$AccountId' => '<p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>', 'ListMultiRegionAccessPointsRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'ListRegionalBucketsRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'ListStorageLensConfigurationsRequest$AccountId' => '<p>The account ID of the requester.</p>', 'PutAccessPointConfigurationForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'PutAccessPointPolicyForObjectLambdaRequest$AccountId' => '<p>The account ID for the account that owns the specified Object Lambda Access Point.</p>', 'PutAccessPointPolicyRequest$AccountId' => '<p>The Amazon Web Services account ID for owner of the bucket associated with the specified access point.</p>', 'PutBucketLifecycleConfigurationRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'PutBucketPolicyRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'PutBucketTaggingRequest$AccountId' => '<p>The Amazon Web Services account ID of the Outposts bucket.</p>', 'PutJobTaggingRequest$AccountId' => '<p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>', 'PutMultiRegionAccessPointPolicyRequest$AccountId' => '<p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>', 'PutPublicAccessBlockRequest$AccountId' => '<p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to set.</p>', 'PutStorageLensConfigurationRequest$AccountId' => '<p>The account ID of the requester.</p>', 'PutStorageLensConfigurationTaggingRequest$AccountId' => '<p>The account ID of the requester.</p>', 'S3BucketDestination$AccountId' => '<p>The account ID of the owner of the S3 Storage Lens metrics export bucket.</p>', 'UpdateJobPriorityRequest$AccountId' => '<p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>', 'UpdateJobStatusRequest$AccountId' => '<p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>', ], ], 'AccountLevel' => [ 'base' => '<p>A container for the account level Amazon S3 Storage Lens configuration.</p>', 'refs' => [ 'StorageLensConfiguration$AccountLevel' => '<p>A container for all the account-level configurations of your S3 Storage Lens configuration.</p>', ], ], 'ActivityMetrics' => [ 'base' => '<p>A container for the activity metrics.</p>', 'refs' => [ 'AccountLevel$ActivityMetrics' => '<p>A container for the S3 Storage Lens activity metrics.</p>', 'BucketLevel$ActivityMetrics' => '<p>A container for the bucket-level activity metrics for Amazon S3 Storage Lens</p>', ], ], 'Alias' => [ 'base' => NULL, 'refs' => [ 'AccessPoint$Alias' => '<p>The name or alias of the access point.</p>', 'CreateAccessPointResult$Alias' => '<p>The name or alias of the access point.</p>', 'GetAccessPointResult$Alias' => '<p>The name or alias of the access point.</p>', ], ], 'AsyncCreationTimestamp' => [ 'base' => NULL, 'refs' => [ 'AsyncOperation$CreationTime' => '<p>The time that the request was sent to the service.</p>', ], ], 'AsyncErrorDetails' => [ 'base' => '<p>Error details for the failed asynchronous operation.</p>', 'refs' => [ 'AsyncResponseDetails$ErrorDetails' => '<p>Error details for an asynchronous request.</p>', ], ], 'AsyncOperation' => [ 'base' => '<p>A container for the information about an asynchronous operation.</p>', 'refs' => [ 'DescribeMultiRegionAccessPointOperationResult$AsyncOperation' => '<p>A container element containing the details of the asynchronous operation.</p>', ], ], 'AsyncOperationName' => [ 'base' => NULL, 'refs' => [ 'AsyncOperation$Operation' => '<p>The specific operation for the asynchronous request.</p>', ], ], 'AsyncRequestParameters' => [ 'base' => '<p>A container for the request parameters associated with an asynchronous request.</p>', 'refs' => [ 'AsyncOperation$RequestParameters' => '<p>The parameters associated with the request.</p>', ], ], 'AsyncRequestStatus' => [ 'base' => NULL, 'refs' => [ 'AsyncOperation$RequestStatus' => '<p>The current status of the request.</p>', 'MultiRegionAccessPointRegionalResponse$RequestStatus' => '<p>The current status of the Multi-Region Access Point in this Region.</p>', ], ], 'AsyncRequestTokenARN' => [ 'base' => NULL, 'refs' => [ 'AsyncOperation$RequestTokenARN' => '<p>The request token associated with the request.</p>', 'CreateMultiRegionAccessPointResult$RequestTokenARN' => '<p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of asynchronous requests.</p>', 'DeleteMultiRegionAccessPointResult$RequestTokenARN' => '<p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of asynchronous requests.</p>', 'DescribeMultiRegionAccessPointOperationRequest$RequestTokenARN' => '<p>The request token associated with the request you want to know about. This request token is returned as part of the response when you make an asynchronous request. You provide this token to query about the status of the asynchronous action.</p>', 'PutMultiRegionAccessPointPolicyResult$RequestTokenARN' => '<p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of asynchronous requests.</p>', ], ], 'AsyncResponseDetails' => [ 'base' => '<p>A container for the response details that are returned when querying about an asynchronous request.</p>', 'refs' => [ 'AsyncOperation$ResponseDetails' => '<p>The details of the response.</p>', ], ], 'AwsLambdaTransformation' => [ 'base' => '<p>Lambda function used to transform objects through an Object Lambda Access Point.</p>', 'refs' => [ 'ObjectLambdaContentTransformation$AwsLambda' => '<p>A container for an Lambda function.</p>', ], ], 'AwsLambdaTransformationPayload' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaTransformation$FunctionPayload' => '<p>Additional JSON that provides supplemental data to the Lambda function used to transform objects.</p>', ], ], 'AwsOrgArn' => [ 'base' => NULL, 'refs' => [ 'StorageLensAwsOrg$Arn' => '<p>A container for the Amazon Resource Name (ARN) of the Amazon Web Services organization. This property is read-only and follows the following format: <code> arn:aws:organizations:<i>us-east-1</i>:<i>example-account-id</i>:organization/<i>o-ex2l495dck</i> </code> </p>', ], ], 'BadRequestException' => [ 'base' => '<p/>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'JobReport$Enabled' => '<p>Indicates whether the specified job will generate a job-completion report.</p>', 'ObjectLambdaConfiguration$CloudWatchMetricsEnabled' => '<p>A container for whether the CloudWatch metrics configuration is enabled.</p>', 'S3CopyObjectOperation$RequesterPays' => '<p/>', 'S3CopyObjectOperation$BucketKeyEnabled' => '<p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Amazon Web Services KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p> <p>Specifying this header with an <i>object</i> action doesn’t affect <i>bucket-level</i> settings for S3 Bucket Key.</p>', 'S3ObjectMetadata$RequesterCharged' => '<p/>', 'S3SetObjectRetentionOperation$BypassGovernanceRetention' => '<p>Indicates if the action should be applied to objects in the Batch Operations job even if they have Object Lock <code> GOVERNANCE</code> type in place.</p>', ], ], 'BucketAlreadyExists' => [ 'base' => '<p>The requested Outposts bucket name is not available. The bucket namespace is shared by all users of the Outposts in this Region. Select a different name and try again.</p>', 'refs' => [], ], 'BucketAlreadyOwnedByYou' => [ 'base' => '<p>The Outposts bucket you tried to create already exists, and you own it. </p>', 'refs' => [], ], 'BucketCannedACL' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$ACL' => '<p>The canned ACL to apply to the bucket.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'BucketLevel' => [ 'base' => '<p>A container for the bucket-level configuration.</p>', 'refs' => [ 'AccountLevel$BucketLevel' => '<p>A container for the S3 Storage Lens bucket-level configuration.</p>', ], ], 'BucketLocationConstraint' => [ 'base' => NULL, 'refs' => [ 'CreateBucketConfiguration$LocationConstraint' => '<p>Specifies the Region where the bucket will be created. If you are creating a bucket on the US East (N. Virginia) Region (us-east-1), you do not need to specify the location. </p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'AccessPoint$Bucket' => '<p>The name of the bucket associated with this access point.</p>', 'CreateAccessPointRequest$Bucket' => '<p>The name of the bucket that you want to associate this access point with.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'CreateBucketRequest$Bucket' => '<p>The name of the bucket.</p>', 'DeleteBucketLifecycleConfigurationRequest$Bucket' => '<p>Specifies the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'DeleteBucketPolicyRequest$Bucket' => '<p>Specifies the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'DeleteBucketRequest$Bucket' => '<p>Specifies the bucket being deleted.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'DeleteBucketTaggingRequest$Bucket' => '<p>The bucket ARN that has the tag set to be removed.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'GetAccessPointResult$Bucket' => '<p>The name of the bucket associated with the specified access point.</p>', 'GetBucketLifecycleConfigurationRequest$Bucket' => '<p>The Amazon Resource Name (ARN) of the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'GetBucketPolicyRequest$Bucket' => '<p>Specifies the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'GetBucketRequest$Bucket' => '<p>Specifies the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'GetBucketResult$Bucket' => '<p>The Outposts bucket requested.</p>', 'GetBucketTaggingRequest$Bucket' => '<p>Specifies the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'ListAccessPointsRequest$Bucket' => '<p>The name of the bucket whose associated access points you want to list.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'PutBucketLifecycleConfigurationRequest$Bucket' => '<p>The name of the bucket for which to set the configuration.</p>', 'PutBucketPolicyRequest$Bucket' => '<p>Specifies the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'PutBucketTaggingRequest$Bucket' => '<p>The Amazon Resource Name (ARN) of the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'Region$Bucket' => '<p>The name of the associated bucket for the Region.</p>', 'RegionReport$Bucket' => '<p>The name of the bucket.</p>', 'RegionalBucket$Bucket' => '<p/>', ], ], 'Buckets' => [ 'base' => NULL, 'refs' => [ 'Exclude$Buckets' => '<p>A container for the S3 Storage Lens bucket excludes.</p>', 'Include$Buckets' => '<p>A container for the S3 Storage Lens bucket includes.</p>', ], ], 'CloudWatchMetrics' => [ 'base' => '<p>A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.</p> <p>For more information about publishing S3 Storage Lens metrics to CloudWatch, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_view_metrics_cloudwatch.html">Monitor S3 Storage Lens metrics in CloudWatch</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'StorageLensDataExport$CloudWatchMetrics' => '<p>A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.</p>', ], ], 'ConfigId' => [ 'base' => NULL, 'refs' => [ 'DeleteStorageLensConfigurationRequest$ConfigId' => '<p>The ID of the S3 Storage Lens configuration.</p>', 'DeleteStorageLensConfigurationTaggingRequest$ConfigId' => '<p>The ID of the S3 Storage Lens configuration.</p>', 'GetStorageLensConfigurationRequest$ConfigId' => '<p>The ID of the Amazon S3 Storage Lens configuration.</p>', 'GetStorageLensConfigurationTaggingRequest$ConfigId' => '<p>The ID of the Amazon S3 Storage Lens configuration.</p>', 'ListStorageLensConfigurationEntry$Id' => '<p>A container for the S3 Storage Lens configuration ID.</p>', 'PutStorageLensConfigurationRequest$ConfigId' => '<p>The ID of the S3 Storage Lens configuration.</p>', 'PutStorageLensConfigurationTaggingRequest$ConfigId' => '<p>The ID of the S3 Storage Lens configuration.</p>', 'StorageLensConfiguration$Id' => '<p>A container for the Amazon S3 Storage Lens configuration ID.</p>', ], ], 'ConfirmRemoveSelfBucketAccess' => [ 'base' => NULL, 'refs' => [ 'PutBucketPolicyRequest$ConfirmRemoveSelfBucketAccess' => '<p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'ConfirmationRequired' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$ConfirmationRequired' => '<p>Indicates whether confirmation is required before Amazon S3 runs the job. Confirmation is only required for jobs created through the Amazon S3 console.</p>', 'JobDescriptor$ConfirmationRequired' => '<p>Indicates whether confirmation is required before Amazon S3 begins running the specified job. Confirmation is required only for jobs created through the Amazon S3 console.</p>', ], ], 'ContinuationToken' => [ 'base' => NULL, 'refs' => [ 'ListStorageLensConfigurationsRequest$NextToken' => '<p>A pagination token to request the next page of results.</p>', 'ListStorageLensConfigurationsResult$NextToken' => '<p>If the request produced more than the maximum number of S3 Storage Lens configuration results, you can pass this value into a subsequent request to retrieve the next page of results.</p>', ], ], 'CreateAccessPointForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessPointForObjectLambdaResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessPointResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateBucketConfiguration' => [ 'base' => '<p>The container for the bucket configuration.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', 'refs' => [ 'CreateBucketRequest$CreateBucketConfiguration' => '<p>The configuration information for the bucket.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'CreateBucketRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBucketResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateMultiRegionAccessPointInput' => [ 'base' => '<p>A container for the information associated with a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> request. </p>', 'refs' => [ 'AsyncRequestParameters$CreateMultiRegionAccessPointRequest' => '<p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> request.</p>', 'CreateMultiRegionAccessPointRequest$Details' => '<p>A container element containing details about the Multi-Region Access Point.</p>', ], ], 'CreateMultiRegionAccessPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMultiRegionAccessPointResult' => [ 'base' => NULL, 'refs' => [], ], 'CreationDate' => [ 'base' => NULL, 'refs' => [ 'GetAccessPointForObjectLambdaResult$CreationDate' => '<p>The date and time when the specified Object Lambda Access Point was created.</p>', 'GetAccessPointResult$CreationDate' => '<p>The date and time when the specified access point was created.</p>', 'GetBucketResult$CreationDate' => '<p>The creation date of the Outposts bucket.</p>', 'RegionalBucket$CreationDate' => '<p>The creation date of the regional bucket</p>', ], ], 'CreationTimestamp' => [ 'base' => NULL, 'refs' => [ 'MultiRegionAccessPointReport$CreatedAt' => '<p>When the Multi-Region Access Point create request was received.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'LifecycleExpiration$Date' => '<p>Indicates at what date the object is to be deleted. Should be in GMT ISO 8601 format.</p>', 'Transition$Date' => '<p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>', ], ], 'Days' => [ 'base' => NULL, 'refs' => [ 'LifecycleExpiration$Days' => '<p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>', 'NoncurrentVersionExpiration$NoncurrentDays' => '<p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates When an Object Became Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>', 'NoncurrentVersionTransition$NoncurrentDays' => '<p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations"> How Amazon S3 Calculates How Long an Object Has Been Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>', 'Transition$Days' => '<p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>', ], ], 'DaysAfterInitiation' => [ 'base' => NULL, 'refs' => [ 'AbortIncompleteMultipartUpload$DaysAfterInitiation' => '<p>Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload to the Outposts bucket.</p>', ], ], 'DeleteAccessPointForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessPointPolicyForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessPointPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketLifecycleConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBucketTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobTaggingResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMultiRegionAccessPointInput' => [ 'base' => '<p>A container for the information associated with a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> request.</p>', 'refs' => [ 'AsyncRequestParameters$DeleteMultiRegionAccessPointRequest' => '<p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> request.</p>', 'DeleteMultiRegionAccessPointRequest$Details' => '<p>A container element containing details about the Multi-Region Access Point.</p>', ], ], 'DeleteMultiRegionAccessPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMultiRegionAccessPointResult' => [ 'base' => NULL, 'refs' => [], ], 'DeletePublicAccessBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStorageLensConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStorageLensConfigurationTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStorageLensConfigurationTaggingResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMultiRegionAccessPointOperationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMultiRegionAccessPointOperationResult' => [ 'base' => NULL, 'refs' => [], ], 'Endpoints' => [ 'base' => NULL, 'refs' => [ 'GetAccessPointResult$Endpoints' => '<p>The VPC endpoint for the access point.</p>', ], ], 'EstablishedMultiRegionAccessPointPolicy' => [ 'base' => '<p>The last established access control policy for a Multi-Region Access Point.</p> <p>When you update the policy, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.</p>', 'refs' => [ 'MultiRegionAccessPointPolicyDocument$Established' => '<p>The last established policy for the Multi-Region Access Point.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Message' => NULL, 'IdempotencyException$Message' => NULL, 'InternalServiceException$Message' => NULL, 'InvalidNextTokenException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'JobStatusException$Message' => NULL, 'NotFoundException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, 'TooManyTagsException$Message' => NULL, ], ], 'Exclude' => [ 'base' => '<p>A container for what Amazon S3 Storage Lens will exclude.</p>', 'refs' => [ 'StorageLensConfiguration$Exclude' => '<p>A container for what is excluded in this configuration. This container can only be valid if there is no <code>Include</code> container submitted, and it\'s not empty. </p>', ], ], 'ExpirationStatus' => [ 'base' => NULL, 'refs' => [ 'LifecycleRule$Status' => '<p>If \'Enabled\', the rule is currently being applied. If \'Disabled\', the rule is not currently being applied.</p>', ], ], 'ExpiredObjectDeleteMarker' => [ 'base' => NULL, 'refs' => [ 'LifecycleExpiration$ExpiredObjectDeleteMarker' => '<p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired. If set to false, the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>', ], ], 'Format' => [ 'base' => NULL, 'refs' => [ 'S3BucketDestination$Format' => '<p/>', ], ], 'FunctionArnString' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaTransformation$FunctionArn' => '<p>The Amazon Resource Name (ARN) of the Lambda function.</p>', 'LambdaInvokeOperation$FunctionArn' => '<p>The Amazon Resource Name (ARN) for the Lambda function that the specified job will invoke on every object in the manifest.</p>', ], ], 'GetAccessPointConfigurationForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointConfigurationForObjectLambdaResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointForObjectLambdaResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyForObjectLambdaResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyStatusForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyStatusForObjectLambdaResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointPolicyStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPointResult' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketLifecycleConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketLifecycleConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketResult' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBucketTaggingResult' => [ 'base' => NULL, 'refs' => [], ], 'GetJobTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobTaggingResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMultiRegionAccessPointPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMultiRegionAccessPointPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMultiRegionAccessPointPolicyStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMultiRegionAccessPointPolicyStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMultiRegionAccessPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMultiRegionAccessPointResult' => [ 'base' => NULL, 'refs' => [], ], 'GetPublicAccessBlockOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPublicAccessBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageLensConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageLensConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageLensConfigurationTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStorageLensConfigurationTaggingResult' => [ 'base' => NULL, 'refs' => [], ], 'GrantFullControl' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$GrantFullControl' => '<p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'GrantRead' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$GrantRead' => '<p>Allows grantee to list the objects in the bucket.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'GrantReadACP' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$GrantReadACP' => '<p>Allows grantee to read the bucket ACL.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'GrantWrite' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$GrantWrite' => '<p>Allows grantee to create, overwrite, and delete any object in the bucket.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'GrantWriteACP' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$GrantWriteACP' => '<p>Allows grantee to write the ACL for the applicable bucket.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'IAMRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role that Batch Operations will use to run this job\'s action on every object in the manifest.</p>', 'JobDescriptor$RoleArn' => '<p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role assigned to run the tasks for this job.</p>', ], ], 'ID' => [ 'base' => NULL, 'refs' => [ 'LifecycleRule$ID' => '<p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>', ], ], 'IdempotencyException' => [ 'base' => '<p/>', 'refs' => [], ], 'Include' => [ 'base' => '<p>A container for what Amazon S3 Storage Lens configuration includes.</p>', 'refs' => [ 'StorageLensConfiguration$Include' => '<p>A container for what is included in this configuration. This container can only be valid if there is no <code>Exclude</code> container submitted, and it\'s not empty. </p>', ], ], 'InternalServiceException' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p/>', 'refs' => [], ], 'IsEnabled' => [ 'base' => NULL, 'refs' => [ 'ActivityMetrics$IsEnabled' => '<p>A container for whether the activity metrics are enabled.</p>', 'CloudWatchMetrics$IsEnabled' => '<p>A container that indicates whether CloudWatch publishing for S3 Storage Lens metrics is enabled. A value of <code>true</code> indicates that CloudWatch publishing for S3 Storage Lens metrics is enabled.</p>', 'ListStorageLensConfigurationEntry$IsEnabled' => '<p>A container for whether the S3 Storage Lens configuration is enabled. This property is required.</p>', 'PrefixLevelStorageMetrics$IsEnabled' => '<p>A container for whether prefix-level storage metrics are enabled.</p>', 'StorageLensConfiguration$IsEnabled' => '<p>A container for whether the S3 Storage Lens configuration is enabled.</p>', ], ], 'IsPublic' => [ 'base' => NULL, 'refs' => [ 'PolicyStatus$IsPublic' => '<p/>', ], ], 'JobArn' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$JobArn' => '<p>The Amazon Resource Name (ARN) for this job.</p>', ], ], 'JobCreationTime' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$CreationTime' => '<p>A timestamp indicating when this job was created.</p>', 'JobListDescriptor$CreationTime' => '<p>A timestamp indicating when the specified job was created.</p>', ], ], 'JobDescriptor' => [ 'base' => '<p>A container element for the job configuration and status information returned by a <code>Describe Job</code> request.</p>', 'refs' => [ 'DescribeJobResult$Job' => '<p>Contains the configuration parameters and status for the job specified in the <code>Describe Job</code> request.</p>', ], ], 'JobFailure' => [ 'base' => '<p>If this job failed, this element indicates why the job failed.</p>', 'refs' => [ 'JobFailureList$member' => NULL, ], ], 'JobFailureCode' => [ 'base' => NULL, 'refs' => [ 'JobFailure$FailureCode' => '<p>The failure code, if any, for the specified job.</p>', ], ], 'JobFailureList' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$FailureReasons' => '<p>If the specified job failed, this field contains information describing the failure.</p>', ], ], 'JobFailureReason' => [ 'base' => NULL, 'refs' => [ 'JobFailure$FailureReason' => '<p>The failure reason, if any, for the specified job.</p>', ], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'CreateJobResult$JobId' => '<p>The ID for this job. Amazon S3 generates this ID automatically and returns it after a successful <code>Create Job</code> request.</p>', 'DeleteJobTaggingRequest$JobId' => '<p>The ID for the S3 Batch Operations job whose tags you want to delete.</p>', 'DescribeJobRequest$JobId' => '<p>The ID for the job whose information you want to retrieve.</p>', 'GetJobTaggingRequest$JobId' => '<p>The ID for the S3 Batch Operations job whose tags you want to retrieve.</p>', 'JobDescriptor$JobId' => '<p>The ID for the specified job.</p>', 'JobListDescriptor$JobId' => '<p>The ID for the specified job.</p>', 'PutJobTaggingRequest$JobId' => '<p>The ID for the S3 Batch Operations job whose tags you want to replace.</p>', 'UpdateJobPriorityRequest$JobId' => '<p>The ID for the job whose priority you want to update.</p>', 'UpdateJobPriorityResult$JobId' => '<p>The ID for the job whose priority Amazon S3 updated.</p>', 'UpdateJobStatusRequest$JobId' => '<p>The ID of the job whose status you want to update.</p>', 'UpdateJobStatusResult$JobId' => '<p>The ID for the job whose status was updated.</p>', ], ], 'JobListDescriptor' => [ 'base' => '<p>Contains the configuration and status information for a single job retrieved as part of a job list.</p>', 'refs' => [ 'JobListDescriptorList$member' => NULL, ], ], 'JobListDescriptorList' => [ 'base' => NULL, 'refs' => [ 'ListJobsResult$Jobs' => '<p>The list of current jobs and jobs that have ended within the last 30 days.</p>', ], ], 'JobManifest' => [ 'base' => '<p>Contains the configuration information for a job\'s manifest.</p>', 'refs' => [ 'CreateJobRequest$Manifest' => '<p>Configuration parameters for the manifest.</p>', 'JobDescriptor$Manifest' => '<p>The configuration information for the specified job\'s manifest object.</p>', ], ], 'JobManifestFieldList' => [ 'base' => NULL, 'refs' => [ 'JobManifestSpec$Fields' => '<p>If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this element describes which columns contain the required data.</p>', ], ], 'JobManifestFieldName' => [ 'base' => NULL, 'refs' => [ 'JobManifestFieldList$member' => NULL, ], ], 'JobManifestFormat' => [ 'base' => NULL, 'refs' => [ 'JobManifestSpec$Format' => '<p>Indicates which of the available formats the specified manifest uses.</p>', ], ], 'JobManifestLocation' => [ 'base' => '<p>Contains the information required to locate a manifest object.</p>', 'refs' => [ 'JobManifest$Location' => '<p>Contains the information required to locate the specified job\'s manifest.</p>', ], ], 'JobManifestSpec' => [ 'base' => '<p>Describes the format of a manifest. If the manifest is in CSV format, also describes the columns contained within the manifest.</p>', 'refs' => [ 'JobManifest$Spec' => '<p>Describes the format of the specified job\'s manifest. If the manifest is in CSV format, also describes the columns contained within the manifest.</p>', ], ], 'JobNumberOfTasksFailed' => [ 'base' => NULL, 'refs' => [ 'JobProgressSummary$NumberOfTasksFailed' => '<p/>', ], ], 'JobNumberOfTasksSucceeded' => [ 'base' => NULL, 'refs' => [ 'JobProgressSummary$NumberOfTasksSucceeded' => '<p/>', ], ], 'JobOperation' => [ 'base' => '<p>The operation that you want this job to perform on every object listed in the manifest. For more information about the available operations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-operations.html">Operations</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'CreateJobRequest$Operation' => '<p>The action that you want this job to perform on every object listed in the manifest. For more information about the available actions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-actions.html">Operations</a> in the <i>Amazon S3 User Guide</i>.</p>', 'JobDescriptor$Operation' => '<p>The operation that the specified job is configured to run on the objects listed in the manifest.</p>', ], ], 'JobPriority' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$Priority' => '<p>The numerical priority for this job. Higher numbers indicate higher priority.</p>', 'JobDescriptor$Priority' => '<p>The priority of the specified job.</p>', 'JobListDescriptor$Priority' => '<p>The current priority for the specified job.</p>', 'UpdateJobPriorityRequest$Priority' => '<p>The priority you want to assign to this job.</p>', 'UpdateJobPriorityResult$Priority' => '<p>The new priority assigned to the specified job.</p>', ], ], 'JobProgressSummary' => [ 'base' => '<p>Describes the total number of tasks that the specified job has started, the number of tasks that succeeded, and the number of tasks that failed.</p>', 'refs' => [ 'JobDescriptor$ProgressSummary' => '<p>Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.</p>', 'JobListDescriptor$ProgressSummary' => '<p>Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.</p>', ], ], 'JobReport' => [ 'base' => '<p>Contains the configuration parameters for a job-completion report.</p>', 'refs' => [ 'CreateJobRequest$Report' => '<p>Configuration parameters for the optional job-completion report.</p>', 'JobDescriptor$Report' => '<p>Contains the configuration information for the job-completion report if you requested one in the <code>Create Job</code> request.</p>', ], ], 'JobReportFormat' => [ 'base' => NULL, 'refs' => [ 'JobReport$Format' => '<p>The format of the specified job-completion report.</p>', ], ], 'JobReportScope' => [ 'base' => NULL, 'refs' => [ 'JobReport$ReportScope' => '<p>Indicates whether the job-completion report will include details of all tasks or only failed tasks.</p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$Status' => '<p>The current status of the specified job.</p>', 'JobListDescriptor$Status' => '<p>The specified job\'s current status.</p>', 'JobStatusList$member' => NULL, 'UpdateJobStatusResult$Status' => '<p>The current status for the specified job.</p>', ], ], 'JobStatusException' => [ 'base' => '<p/>', 'refs' => [], ], 'JobStatusList' => [ 'base' => NULL, 'refs' => [ 'ListJobsRequest$JobStatuses' => '<p>The <code>List Jobs</code> request returns jobs that match the statuses listed in this element.</p>', ], ], 'JobStatusUpdateReason' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$StatusUpdateReason' => '<p>The reason for updating the job.</p>', 'UpdateJobStatusRequest$StatusUpdateReason' => '<p>A description of the reason why you want to change the specified job\'s status. This field can be any string up to the maximum length.</p>', 'UpdateJobStatusResult$StatusUpdateReason' => '<p>The reason that the specified job\'s status was updated.</p>', ], ], 'JobTerminationDate' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$TerminationDate' => '<p>A timestamp indicating when this job terminated. A job\'s termination date is the date and time when it succeeded, failed, or was canceled.</p>', 'JobListDescriptor$TerminationDate' => '<p>A timestamp indicating when the specified job terminated. A job\'s termination date is the date and time when it succeeded, failed, or was canceled.</p>', ], ], 'JobTotalNumberOfTasks' => [ 'base' => NULL, 'refs' => [ 'JobProgressSummary$TotalNumberOfTasks' => '<p/>', ], ], 'KmsKeyArnString' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$SSEAwsKmsKeyId' => '<p/>', ], ], 'LambdaInvokeOperation' => [ 'base' => '<p>Contains the configuration parameters for a <code>Lambda Invoke</code> operation.</p>', 'refs' => [ 'JobOperation$LambdaInvoke' => '<p>Directs the specified job to invoke an Lambda function on every object in the manifest.</p>', ], ], 'LifecycleConfiguration' => [ 'base' => '<p>The container for the Outposts bucket lifecycle configuration.</p>', 'refs' => [ 'PutBucketLifecycleConfigurationRequest$LifecycleConfiguration' => '<p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>', ], ], 'LifecycleExpiration' => [ 'base' => '<p>The container of the Outposts bucket lifecycle expiration.</p>', 'refs' => [ 'LifecycleRule$Expiration' => '<p>Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.</p>', ], ], 'LifecycleRule' => [ 'base' => '<p>The container for the Outposts bucket lifecycle rule.</p>', 'refs' => [ 'LifecycleRules$member' => NULL, ], ], 'LifecycleRuleAndOperator' => [ 'base' => '<p>The container for the Outposts bucket lifecycle rule and operator.</p>', 'refs' => [ 'LifecycleRuleFilter$And' => '<p>The container for the <code>AND</code> condition for the lifecycle rule.</p>', ], ], 'LifecycleRuleFilter' => [ 'base' => '<p>The container for the filter of the lifecycle rule.</p>', 'refs' => [ 'LifecycleRule$Filter' => '<p>The container for the filter of lifecycle rule.</p>', ], ], 'LifecycleRules' => [ 'base' => NULL, 'refs' => [ 'GetBucketLifecycleConfigurationResult$Rules' => '<p>Container for the lifecycle rule of the Outposts bucket.</p>', 'LifecycleConfiguration$Rules' => '<p>A lifecycle rule for individual objects in an Outposts bucket. </p>', ], ], 'ListAccessPointsForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessPointsForObjectLambdaResult' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessPointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessPointsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListMultiRegionAccessPointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMultiRegionAccessPointsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListRegionalBucketsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRegionalBucketsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListStorageLensConfigurationEntry' => [ 'base' => '<p>Part of <code>ListStorageLensConfigurationResult</code>. Each entry includes the description of the S3 Storage Lens configuration, its home Region, whether it is enabled, its Amazon Resource Name (ARN), and config ID.</p>', 'refs' => [ 'StorageLensConfigurationList$member' => NULL, ], ], 'ListStorageLensConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStorageLensConfigurationsResult' => [ 'base' => NULL, 'refs' => [], ], 'Location' => [ 'base' => NULL, 'refs' => [ 'CreateBucketResult$Location' => '<p>The location of the bucket.</p>', ], ], 'MaxLength1024String' => [ 'base' => NULL, 'refs' => [ 'AsyncErrorDetails$Code' => '<p>A string that uniquely identifies the error condition.</p>', 'AsyncErrorDetails$Message' => '<p>A generic descritpion of the error condition in English.</p>', 'AsyncErrorDetails$Resource' => '<p>The identifier of the resource associated with the error.</p>', 'AsyncErrorDetails$RequestId' => '<p>The ID of the request associated with the error.</p>', 'S3UserMetadata$value' => NULL, ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAccessPointsForObjectLambdaRequest$MaxResults' => '<p>The maximum number of access points that you want to include in the list. If there are more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>', 'ListAccessPointsRequest$MaxResults' => '<p>The maximum number of access points that you want to include in the list. If the specified bucket has more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>', 'ListJobsRequest$MaxResults' => '<p>The maximum number of jobs that Amazon S3 will include in the <code>List Jobs</code> response. If there are more jobs than this number, the response will include a pagination token in the <code>NextToken</code> field to enable you to retrieve the next page of results.</p>', 'ListMultiRegionAccessPointsRequest$MaxResults' => '<p>Not currently used. Do not use this parameter.</p>', 'ListRegionalBucketsRequest$MaxResults' => '<p/>', ], ], 'MinStorageBytesPercentage' => [ 'base' => NULL, 'refs' => [ 'SelectionCriteria$MinStorageBytesPercentage' => '<p>The minimum number of storage bytes percentage whose metrics will be selected.</p> <note> <p>You must choose a value greater than or equal to <code>1.0</code>.</p> </note>', ], ], 'MultiRegionAccessPointAlias' => [ 'base' => NULL, 'refs' => [ 'MultiRegionAccessPointReport$Alias' => '<p>The alias for the Multi-Region Access Point. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a>.</p>', ], ], 'MultiRegionAccessPointClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateMultiRegionAccessPointRequest$ClientToken' => '<p>An idempotency token used to identify the request and guarantee that requests are unique.</p>', 'DeleteMultiRegionAccessPointRequest$ClientToken' => '<p>An idempotency token used to identify the request and guarantee that requests are unique.</p>', 'PutMultiRegionAccessPointPolicyRequest$ClientToken' => '<p>An idempotency token used to identify the request and guarantee that requests are unique.</p>', ], ], 'MultiRegionAccessPointName' => [ 'base' => NULL, 'refs' => [ 'CreateMultiRegionAccessPointInput$Name' => '<p>The name of the Multi-Region Access Point associated with this request.</p>', 'DeleteMultiRegionAccessPointInput$Name' => '<p>The name of the Multi-Region Access Point associated with this request.</p>', 'GetMultiRegionAccessPointPolicyRequest$Name' => '<p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>', 'GetMultiRegionAccessPointPolicyStatusRequest$Name' => '<p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>', 'GetMultiRegionAccessPointRequest$Name' => '<p>The name of the Multi-Region Access Point whose configuration information you want to receive. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>', 'MultiRegionAccessPointReport$Name' => '<p>The name of the Multi-Region Access Point.</p>', 'PutMultiRegionAccessPointPolicyInput$Name' => '<p>The name of the Multi-Region Access Point associated with the request.</p>', ], ], 'MultiRegionAccessPointPolicyDocument' => [ 'base' => '<p>The Multi-Region Access Point access control policy.</p> <p>When you update the policy, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.</p>', 'refs' => [ 'GetMultiRegionAccessPointPolicyResult$Policy' => '<p>The policy associated with the specified Multi-Region Access Point.</p>', ], ], 'MultiRegionAccessPointRegionalResponse' => [ 'base' => '<p>Status information for a single Multi-Region Access Point Region.</p>', 'refs' => [ 'MultiRegionAccessPointRegionalResponseList$member' => NULL, ], ], 'MultiRegionAccessPointRegionalResponseList' => [ 'base' => NULL, 'refs' => [ 'MultiRegionAccessPointsAsyncResponse$Regions' => '<p>A collection of status information for the different Regions that a Multi-Region Access Point supports.</p>', ], ], 'MultiRegionAccessPointReport' => [ 'base' => '<p>A collection of statuses for a Multi-Region Access Point in the various Regions it supports.</p>', 'refs' => [ 'GetMultiRegionAccessPointResult$AccessPoint' => '<p>A container element containing the details of the requested Multi-Region Access Point.</p>', 'MultiRegionAccessPointReportList$member' => NULL, ], ], 'MultiRegionAccessPointReportList' => [ 'base' => NULL, 'refs' => [ 'ListMultiRegionAccessPointsResult$AccessPoints' => '<p>The list of Multi-Region Access Points associated with the user.</p>', ], ], 'MultiRegionAccessPointStatus' => [ 'base' => NULL, 'refs' => [ 'MultiRegionAccessPointReport$Status' => '<p>The current status of the Multi-Region Access Point.</p> <p> <code>CREATING</code> and <code>DELETING</code> are temporary states that exist while the request is propogating and being completed. If a Multi-Region Access Point has a status of <code>PARTIALLY_CREATED</code>, you can retry creation or send a request to delete the Multi-Region Access Point. If a Multi-Region Access Point has a status of <code>PARTIALLY_DELETED</code>, you can retry a delete request to finish the deletion of the Multi-Region Access Point.</p>', ], ], 'MultiRegionAccessPointsAsyncResponse' => [ 'base' => '<p>The Multi-Region Access Point details that are returned when querying about an asynchronous request.</p>', 'refs' => [ 'AsyncResponseDetails$MultiRegionAccessPointDetails' => '<p>The details for the Multi-Region Access Point.</p>', ], ], 'NetworkOrigin' => [ 'base' => NULL, 'refs' => [ 'AccessPoint$NetworkOrigin' => '<p>Indicates whether this access point allows access from the public internet. If <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point doesn\'t allow access from the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the public internet, subject to the access point and bucket access policies.</p>', 'GetAccessPointResult$NetworkOrigin' => '<p>Indicates whether this access point allows access from the public internet. If <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point doesn\'t allow access from the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the public internet, subject to the access point and bucket access policies.</p> <p>This will always be true for an Amazon S3 on Outposts access point</p>', ], ], 'NoSuchPublicAccessBlockConfiguration' => [ 'base' => '<p>Amazon S3 throws this exception if you make a <code>GetPublicAccessBlock</code> request against an account that doesn\'t have a <code>PublicAccessBlockConfiguration</code> set.</p>', 'refs' => [], ], 'NoSuchPublicAccessBlockConfigurationMessage' => [ 'base' => NULL, 'refs' => [ 'NoSuchPublicAccessBlockConfiguration$Message' => NULL, ], ], 'NonEmptyMaxLength1024String' => [ 'base' => NULL, 'refs' => [ 'Endpoints$value' => NULL, 'JobManifestLocation$ETag' => '<p>The ETag for the specified manifest object.</p>', 'ListAccessPointsForObjectLambdaRequest$NextToken' => '<p>If the list has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>', 'ListAccessPointsForObjectLambdaResult$NextToken' => '<p>If the list has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>', 'ListAccessPointsRequest$NextToken' => '<p>A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation token in the <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve the next page of results.</p>', 'ListAccessPointsResult$NextToken' => '<p>If the specified bucket has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>', 'ListMultiRegionAccessPointsRequest$NextToken' => '<p>Not currently used. Do not use this parameter.</p>', 'ListMultiRegionAccessPointsResult$NextToken' => '<p>If the specified bucket has more Multi-Region Access Points than can be returned in one call to this action, this field contains a continuation token. You can use this token tin subsequent calls to this action to retrieve additional Multi-Region Access Points.</p>', 'ListRegionalBucketsRequest$NextToken' => '<p/>', 'ListRegionalBucketsResult$NextToken' => '<p> <code>NextToken</code> is sent when <code>isTruncated</code> is true, which means there are more buckets that can be listed. The next list requests to Amazon S3 can be continued with this <code>NextToken</code>. <code>NextToken</code> is obfuscated and is not a real key.</p>', 'S3CopyObjectOperation$TargetKeyPrefix' => '<p>Specifies the folder prefix into which you would like the objects to be copied. For example, to copy objects into a folder named "Folder1" in the destination bucket, set the TargetKeyPrefix to "Folder1/".</p>', 'S3Grantee$Identifier' => '<p/>', 'S3Grantee$DisplayName' => '<p/>', 'S3ObjectMetadata$CacheControl' => '<p/>', 'S3ObjectMetadata$ContentDisposition' => '<p/>', 'S3ObjectMetadata$ContentEncoding' => '<p/>', 'S3ObjectMetadata$ContentLanguage' => '<p/>', 'S3ObjectMetadata$ContentMD5' => '<p/>', 'S3ObjectMetadata$ContentType' => '<p/>', 'S3ObjectOwner$ID' => '<p/>', 'S3ObjectOwner$DisplayName' => '<p/>', 'S3UserMetadata$key' => NULL, ], ], 'NonEmptyMaxLength2048String' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$RedirectLocation' => '<p>Specifies an optional metadata property for website redirects, <code>x-amz-website-redirect-location</code>. Allows webpage redirects if the object is accessed through a website endpoint.</p>', ], ], 'NonEmptyMaxLength256String' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$Description' => '<p>A description for this job. You can use any string within the permitted length. Descriptions don\'t need to be unique and can be used for multiple jobs.</p>', 'JobDescriptor$Description' => '<p>The description for this job, if one was provided in this job\'s <code>Create Job</code> request.</p>', 'JobListDescriptor$Description' => '<p>The user-specified description that was included in the specified job\'s <code>Create Job</code> request.</p>', ], ], 'NonEmptyMaxLength64String' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$OutpostId' => '<p>The ID of the Outposts where the bucket is being created.</p> <note> <p>This is required by Amazon S3 on Outposts buckets.</p> </note>', 'CreateJobRequest$ClientRequestToken' => '<p>An idempotency token to ensure that you don\'t accidentally submit the same request twice. You can use any string up to the maximum length.</p>', 'Endpoints$key' => NULL, 'ListRegionalBucketsRequest$OutpostId' => '<p>The ID of the Outposts.</p> <note> <p>This is required by Amazon S3 on Outposts buckets.</p> </note>', 'RegionalBucket$OutpostId' => '<p>The Outposts ID of the regional bucket.</p>', ], ], 'NoncurrentVersionExpiration' => [ 'base' => '<p>The container of the noncurrent version expiration.</p>', 'refs' => [ 'LifecycleRule$NoncurrentVersionExpiration' => '<p>The noncurrent version expiration of the lifecycle rule.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'NoncurrentVersionTransition' => [ 'base' => '<p>The container for the noncurrent version transition.</p>', 'refs' => [ 'NoncurrentVersionTransitionList$member' => NULL, ], ], 'NoncurrentVersionTransitionList' => [ 'base' => NULL, 'refs' => [ 'LifecycleRule$NoncurrentVersionTransitions' => '<p> Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object\'s lifetime. </p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'NotFoundException' => [ 'base' => '<p/>', 'refs' => [], ], 'ObjectLambdaAccessPoint' => [ 'base' => '<p>An access point with an attached Lambda function used to access transformed data from an Amazon S3 bucket.</p>', 'refs' => [ 'ObjectLambdaAccessPointList$member' => NULL, ], ], 'ObjectLambdaAccessPointArn' => [ 'base' => NULL, 'refs' => [ 'CreateAccessPointForObjectLambdaResult$ObjectLambdaAccessPointArn' => '<p>Specifies the ARN for the Object Lambda Access Point.</p>', 'ObjectLambdaAccessPoint$ObjectLambdaAccessPointArn' => '<p>Specifies the ARN for the Object Lambda Access Point.</p>', ], ], 'ObjectLambdaAccessPointList' => [ 'base' => NULL, 'refs' => [ 'ListAccessPointsForObjectLambdaResult$ObjectLambdaAccessPointList' => '<p>Returns list of Object Lambda Access Points.</p>', ], ], 'ObjectLambdaAccessPointName' => [ 'base' => NULL, 'refs' => [ 'CreateAccessPointForObjectLambdaRequest$Name' => '<p>The name you want to assign to this Object Lambda Access Point.</p>', 'DeleteAccessPointForObjectLambdaRequest$Name' => '<p>The name of the access point you want to delete.</p>', 'DeleteAccessPointPolicyForObjectLambdaRequest$Name' => '<p>The name of the Object Lambda Access Point you want to delete the policy for.</p>', 'GetAccessPointConfigurationForObjectLambdaRequest$Name' => '<p>The name of the Object Lambda Access Point you want to return the configuration for.</p>', 'GetAccessPointForObjectLambdaRequest$Name' => '<p>The name of the Object Lambda Access Point.</p>', 'GetAccessPointForObjectLambdaResult$Name' => '<p>The name of the Object Lambda Access Point.</p>', 'GetAccessPointPolicyForObjectLambdaRequest$Name' => '<p>The name of the Object Lambda Access Point.</p>', 'GetAccessPointPolicyStatusForObjectLambdaRequest$Name' => '<p>The name of the Object Lambda Access Point.</p>', 'ObjectLambdaAccessPoint$Name' => '<p>The name of the Object Lambda Access Point.</p>', 'PutAccessPointConfigurationForObjectLambdaRequest$Name' => '<p>The name of the Object Lambda Access Point.</p>', 'PutAccessPointPolicyForObjectLambdaRequest$Name' => '<p>The name of the Object Lambda Access Point.</p>', ], ], 'ObjectLambdaAllowedFeature' => [ 'base' => NULL, 'refs' => [ 'ObjectLambdaAllowedFeaturesList$member' => NULL, ], ], 'ObjectLambdaAllowedFeaturesList' => [ 'base' => NULL, 'refs' => [ 'ObjectLambdaConfiguration$AllowedFeatures' => '<p>A container for allowed features. Valid inputs are <code>GetObject-Range</code> and <code>GetObject-PartNumber</code>.</p>', ], ], 'ObjectLambdaConfiguration' => [ 'base' => '<p>A configuration used when creating an Object Lambda Access Point.</p>', 'refs' => [ 'CreateAccessPointForObjectLambdaRequest$Configuration' => '<p>Object Lambda Access Point configuration as a JSON document.</p>', 'GetAccessPointConfigurationForObjectLambdaResult$Configuration' => '<p>Object Lambda Access Point configuration document.</p>', 'PutAccessPointConfigurationForObjectLambdaRequest$Configuration' => '<p>Object Lambda Access Point configuration document.</p>', ], ], 'ObjectLambdaContentTransformation' => [ 'base' => '<p>A container for AwsLambdaTransformation.</p>', 'refs' => [ 'ObjectLambdaTransformationConfiguration$ContentTransformation' => '<p>A container for the content transformation of an Object Lambda Access Point configuration.</p>', ], ], 'ObjectLambdaPolicy' => [ 'base' => NULL, 'refs' => [ 'GetAccessPointPolicyForObjectLambdaResult$Policy' => '<p>Object Lambda Access Point resource policy document.</p>', 'PutAccessPointPolicyForObjectLambdaRequest$Policy' => '<p>Object Lambda Access Point resource policy document.</p>', ], ], 'ObjectLambdaSupportingAccessPointArn' => [ 'base' => NULL, 'refs' => [ 'ObjectLambdaConfiguration$SupportingAccessPoint' => '<p>Standard access point associated with the Object Lambda Access Point.</p>', ], ], 'ObjectLambdaTransformationConfiguration' => [ 'base' => '<p>A configuration used when creating an Object Lambda Access Point transformation.</p>', 'refs' => [ 'ObjectLambdaTransformationConfigurationsList$member' => NULL, ], ], 'ObjectLambdaTransformationConfigurationAction' => [ 'base' => NULL, 'refs' => [ 'ObjectLambdaTransformationConfigurationActionsList$member' => NULL, ], ], 'ObjectLambdaTransformationConfigurationActionsList' => [ 'base' => NULL, 'refs' => [ 'ObjectLambdaTransformationConfiguration$Actions' => '<p>A container for the action of an Object Lambda Access Point configuration. Valid input is <code>GetObject</code>.</p>', ], ], 'ObjectLambdaTransformationConfigurationsList' => [ 'base' => NULL, 'refs' => [ 'ObjectLambdaConfiguration$TransformationConfigurations' => '<p>A container for transformation configurations for an Object Lambda Access Point.</p>', ], ], 'ObjectLockEnabledForBucket' => [ 'base' => NULL, 'refs' => [ 'CreateBucketRequest$ObjectLockEnabledForBucket' => '<p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'OperationName' => [ 'base' => NULL, 'refs' => [ 'JobListDescriptor$Operation' => '<p>The operation that the specified job is configured to run on every object listed in the manifest.</p>', ], ], 'OutputSchemaVersion' => [ 'base' => NULL, 'refs' => [ 'S3BucketDestination$OutputSchemaVersion' => '<p>The schema version of the export file.</p>', ], ], 'Policy' => [ 'base' => NULL, 'refs' => [ 'EstablishedMultiRegionAccessPointPolicy$Policy' => '<p>The details of the last established policy.</p>', 'GetAccessPointPolicyResult$Policy' => '<p>The access point policy associated with the specified access point.</p>', 'GetBucketPolicyResult$Policy' => '<p>The policy of the Outposts bucket.</p>', 'ProposedMultiRegionAccessPointPolicy$Policy' => '<p>The details of the proposed policy.</p>', 'PutAccessPointPolicyRequest$Policy' => '<p>The policy that you want to apply to the specified access point. For more information about access point policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing data access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>', 'PutBucketPolicyRequest$Policy' => '<p>The bucket policy as a JSON document.</p>', 'PutMultiRegionAccessPointPolicyInput$Policy' => '<p>The policy details for the <code>PutMultiRegionAccessPoint</code> request.</p>', ], ], 'PolicyStatus' => [ 'base' => '<p>Indicates whether this access point policy is public. For more information about how Amazon S3 evaluates policies to determine whether they are public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>. </p>', 'refs' => [ 'GetAccessPointPolicyStatusForObjectLambdaResult$PolicyStatus' => NULL, 'GetAccessPointPolicyStatusResult$PolicyStatus' => '<p>Indicates the current policy status of the specified access point.</p>', 'GetMultiRegionAccessPointPolicyStatusResult$Established' => NULL, ], ], 'Prefix' => [ 'base' => NULL, 'refs' => [ 'LifecycleRuleAndOperator$Prefix' => '<p>Prefix identifying one or more objects to which the rule applies.</p>', 'LifecycleRuleFilter$Prefix' => '<p>Prefix identifying one or more objects to which the rule applies.</p> <important> <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p> </important>', 'S3BucketDestination$Prefix' => '<p>The prefix of the destination bucket where the metrics export will be delivered.</p>', ], ], 'PrefixLevel' => [ 'base' => '<p>A container for the prefix-level configuration.</p>', 'refs' => [ 'BucketLevel$PrefixLevel' => '<p>A container for the bucket-level prefix-level metrics for S3 Storage Lens</p>', ], ], 'PrefixLevelStorageMetrics' => [ 'base' => '<p>A container for the prefix-level storage metrics for S3 Storage Lens.</p>', 'refs' => [ 'PrefixLevel$StorageMetrics' => '<p>A container for the prefix-level storage metrics for S3 Storage Lens.</p>', ], ], 'ProposedMultiRegionAccessPointPolicy' => [ 'base' => '<p>The proposed access control policy for the Multi-Region Access Point.</p> <p>When you update the policy, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.</p>', 'refs' => [ 'MultiRegionAccessPointPolicyDocument$Proposed' => '<p>The proposed policy for the Multi-Region Access Point.</p>', ], ], 'PublicAccessBlockConfiguration' => [ 'base' => '<p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p> <p>This is not supported for Amazon S3 on Outposts.</p>', 'refs' => [ 'CreateAccessPointRequest$PublicAccessBlockConfiguration' => '<p> The <code>PublicAccessBlock</code> configuration that you want to apply to the access point. </p>', 'CreateMultiRegionAccessPointInput$PublicAccessBlock' => NULL, 'GetAccessPointForObjectLambdaResult$PublicAccessBlockConfiguration' => '<p>Configuration to block all public access. This setting is turned on and can not be edited. </p>', 'GetAccessPointResult$PublicAccessBlockConfiguration' => NULL, 'GetPublicAccessBlockOutput$PublicAccessBlockConfiguration' => '<p>The <code>PublicAccessBlock</code> configuration currently in effect for this Amazon Web Services account.</p>', 'MultiRegionAccessPointReport$PublicAccessBlock' => NULL, 'PutPublicAccessBlockRequest$PublicAccessBlockConfiguration' => '<p>The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web Services account.</p>', ], ], 'PublicAccessBlockEnabled' => [ 'base' => NULL, 'refs' => [ 'GetBucketResult$PublicAccessBlockEnabled' => '<p/>', 'RegionalBucket$PublicAccessBlockEnabled' => '<p/>', ], ], 'PutAccessPointConfigurationForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAccessPointPolicyForObjectLambdaRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAccessPointPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketLifecycleConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutBucketTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutJobTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutJobTaggingResult' => [ 'base' => NULL, 'refs' => [], ], 'PutMultiRegionAccessPointPolicyInput' => [ 'base' => '<p>A container for the information associated with a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html">PutMultiRegionAccessPoint</a> request.</p>', 'refs' => [ 'AsyncRequestParameters$PutMultiRegionAccessPointPolicyRequest' => '<p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html">PutMultiRegionAccessPoint</a> request.</p>', 'PutMultiRegionAccessPointPolicyRequest$Details' => '<p>A container element containing the details of the policy for the Multi-Region Access Point.</p>', ], ], 'PutMultiRegionAccessPointPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutMultiRegionAccessPointPolicyResult' => [ 'base' => NULL, 'refs' => [], ], 'PutPublicAccessBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutStorageLensConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutStorageLensConfigurationTaggingRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutStorageLensConfigurationTaggingResult' => [ 'base' => NULL, 'refs' => [], ], 'Region' => [ 'base' => '<p>A Region that supports a Multi-Region Access Point as well as the associated bucket for the Region.</p>', 'refs' => [ 'RegionCreationList$member' => NULL, ], ], 'RegionCreationList' => [ 'base' => NULL, 'refs' => [ 'CreateMultiRegionAccessPointInput$Regions' => '<p>The buckets in different Regions that are associated with the Multi-Region Access Point.</p>', ], ], 'RegionName' => [ 'base' => NULL, 'refs' => [ 'MultiRegionAccessPointRegionalResponse$Name' => '<p>The name of the Region in the Multi-Region Access Point.</p>', 'RegionReport$Region' => '<p>The name of the Region.</p>', ], ], 'RegionReport' => [ 'base' => '<p>A combination of a bucket and Region that\'s part of a Multi-Region Access Point.</p>', 'refs' => [ 'RegionReportList$member' => NULL, ], ], 'RegionReportList' => [ 'base' => NULL, 'refs' => [ 'MultiRegionAccessPointReport$Regions' => '<p>A collection of the Regions and buckets associated with the Multi-Region Access Point.</p>', ], ], 'RegionalBucket' => [ 'base' => '<p>The container for the regional bucket.</p>', 'refs' => [ 'RegionalBucketList$member' => NULL, ], ], 'RegionalBucketList' => [ 'base' => NULL, 'refs' => [ 'ListRegionalBucketsResult$RegionalBucketList' => '<p/>', ], ], 'Regions' => [ 'base' => NULL, 'refs' => [ 'Exclude$Regions' => '<p>A container for the S3 Storage Lens Region excludes.</p>', 'Include$Regions' => '<p>A container for the S3 Storage Lens Region includes.</p>', ], ], 'ReportPrefixString' => [ 'base' => NULL, 'refs' => [ 'JobReport$Prefix' => '<p>An optional prefix to describe where in the specified bucket the job-completion report will be stored. Amazon S3 stores the job-completion report at <code>&lt;prefix&gt;/job-&lt;job-id&gt;/report.json</code>.</p>', ], ], 'RequestedJobStatus' => [ 'base' => NULL, 'refs' => [ 'UpdateJobStatusRequest$RequestedJobStatus' => '<p>The status that you want to move the specified job to.</p>', ], ], 'S3AWSRegion' => [ 'base' => NULL, 'refs' => [ 'ListStorageLensConfigurationEntry$HomeRegion' => '<p>A container for the S3 Storage Lens home Region. Your metrics data is stored and retained in your designated S3 Storage Lens home Region.</p>', 'Regions$member' => NULL, ], ], 'S3AccessControlList' => [ 'base' => '<p/>', 'refs' => [ 'S3AccessControlPolicy$AccessControlList' => '<p/>', ], ], 'S3AccessControlPolicy' => [ 'base' => '<p/>', 'refs' => [ 'S3SetObjectAclOperation$AccessControlPolicy' => '<p/>', ], ], 'S3AccessPointArn' => [ 'base' => NULL, 'refs' => [ 'AccessPoint$AccessPointArn' => '<p>The ARN for the access point.</p>', 'CreateAccessPointResult$AccessPointArn' => '<p>The ARN of the access point.</p> <note> <p>This is only supported by Amazon S3 on Outposts.</p> </note>', 'GetAccessPointResult$AccessPointArn' => '<p>The ARN of the access point.</p>', ], ], 'S3BucketArnString' => [ 'base' => NULL, 'refs' => [ 'Buckets$member' => NULL, 'JobReport$Bucket' => '<p>The Amazon Resource Name (ARN) for the bucket where specified job-completion report will be stored.</p>', 'S3BucketDestination$Arn' => '<p>The Amazon Resource Name (ARN) of the bucket. This property is read-only and follows the following format: <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:bucket/<i>your-destination-bucket-name</i> </code> </p>', 'S3CopyObjectOperation$TargetResource' => '<p>Specifies the destination bucket ARN for the batch copy operation. For example, to copy objects to a bucket named "destinationBucket", set the TargetResource to "arn:aws:s3:::destinationBucket".</p>', ], ], 'S3BucketDestination' => [ 'base' => '<p>A container for the bucket where the Amazon S3 Storage Lens metrics export files are located.</p>', 'refs' => [ 'StorageLensDataExport$S3BucketDestination' => '<p>A container for the bucket where the S3 Storage Lens metrics export will be located.</p> <note> <p>This bucket must be located in the same Region as the storage lens configuration. </p> </note>', ], ], 'S3CannedAccessControlList' => [ 'base' => NULL, 'refs' => [ 'S3AccessControlPolicy$CannedAccessControlList' => '<p/>', 'S3CopyObjectOperation$CannedAccessControlList' => '<p/>', ], ], 'S3ContentLength' => [ 'base' => NULL, 'refs' => [ 'S3ObjectMetadata$ContentLength' => '<p/>', ], ], 'S3CopyObjectOperation' => [ 'base' => '<p>Contains the configuration parameters for a PUT Copy object operation. S3 Batch Operations passes every object to the underlying PUT Copy object API. For more information about the parameters for this operation, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectCOPY.html">PUT Object - Copy</a>.</p>', 'refs' => [ 'JobOperation$S3PutObjectCopy' => '<p>Directs the specified job to run a PUT Copy object call on every object in the manifest.</p>', ], ], 'S3DeleteObjectTaggingOperation' => [ 'base' => '<p>Contains no configuration parameters because the DELETE Object tagging API only accepts the bucket name and key name as parameters, which are defined in the job\'s manifest.</p>', 'refs' => [ 'JobOperation$S3DeleteObjectTagging' => '<p>Directs the specified job to execute a DELETE Object tagging call on every object in the manifest.</p>', ], ], 'S3ExpirationInDays' => [ 'base' => NULL, 'refs' => [ 'S3InitiateRestoreObjectOperation$ExpirationInDays' => '<p>This argument specifies how long the S3 Glacier Flexible Retrieval or S3 Glacier Deep Archive object remains available in Amazon S3. S3 Initiate Restore Object jobs that target S3 Glacier Flexible Retrieval and S3 Glacier Deep Archive objects require <code>ExpirationInDays</code> set to 1 or greater.</p> <p>Conversely, do <i>not</i> set <code>ExpirationInDays</code> when creating S3 Initiate Restore Object jobs that target S3 Intelligent-Tiering Archive Access and Deep Archive Access tier objects. Objects in S3 Intelligent-Tiering archive access tiers are not subject to restore expiry, so specifying <code>ExpirationInDays</code> results in restore request failure.</p> <p>S3 Batch Operations jobs can operate either on S3 Glacier Flexible Retrieval and S3 Glacier Deep Archive storage class objects or on S3 Intelligent-Tiering Archive Access and Deep Archive Access storage tier objects, but not both types in the same job. If you need to restore objects of both types you <i>must</i> create separate Batch Operations jobs. </p>', ], ], 'S3GlacierJobTier' => [ 'base' => NULL, 'refs' => [ 'S3InitiateRestoreObjectOperation$GlacierJobTier' => '<p>S3 Batch Operations supports <code>STANDARD</code> and <code>BULK</code> retrieval tiers, but not the <code>EXPEDITED</code> retrieval tier.</p>', ], ], 'S3Grant' => [ 'base' => '<p/>', 'refs' => [ 'S3GrantList$member' => NULL, ], ], 'S3GrantList' => [ 'base' => NULL, 'refs' => [ 'S3AccessControlList$Grants' => '<p/>', 'S3CopyObjectOperation$AccessControlGrants' => '<p/>', ], ], 'S3Grantee' => [ 'base' => '<p/>', 'refs' => [ 'S3Grant$Grantee' => '<p/>', ], ], 'S3GranteeTypeIdentifier' => [ 'base' => NULL, 'refs' => [ 'S3Grantee$TypeIdentifier' => '<p/>', ], ], 'S3InitiateRestoreObjectOperation' => [ 'base' => '<p>Contains the configuration parameters for an S3 Initiate Restore Object job. S3 Batch Operations passes every object to the underlying POST Object restore API. For more information about the parameters for this operation, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html#RESTObjectPOSTrestore-restore-request">RestoreObject</a>.</p>', 'refs' => [ 'JobOperation$S3InitiateRestoreObject' => '<p>Directs the specified job to initiate restore requests for every archived object in the manifest.</p>', ], ], 'S3KeyArnString' => [ 'base' => NULL, 'refs' => [ 'JobManifestLocation$ObjectArn' => '<p>The Amazon Resource Name (ARN) for a manifest object.</p> <important> <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p> </important>', ], ], 'S3MetadataDirective' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$MetadataDirective' => '<p/>', ], ], 'S3ObjectLockLegalHold' => [ 'base' => '<p>Whether S3 Object Lock legal hold will be applied to objects in an S3 Batch Operations job.</p>', 'refs' => [ 'S3SetObjectLegalHoldOperation$LegalHold' => '<p>Contains the Object Lock legal hold status to be applied to all objects in the Batch Operations job.</p>', ], ], 'S3ObjectLockLegalHoldStatus' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$ObjectLockLegalHoldStatus' => '<p>The legal hold status to be applied to all objects in the Batch Operations job.</p>', 'S3ObjectLockLegalHold$Status' => '<p>The Object Lock legal hold status to be applied to all objects in the Batch Operations job.</p>', ], ], 'S3ObjectLockMode' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$ObjectLockMode' => '<p>The retention mode to be applied to all objects in the Batch Operations job.</p>', ], ], 'S3ObjectLockRetentionMode' => [ 'base' => NULL, 'refs' => [ 'S3Retention$Mode' => '<p>The Object Lock retention mode to be applied to all objects in the Batch Operations job.</p>', ], ], 'S3ObjectMetadata' => [ 'base' => '<p/>', 'refs' => [ 'S3CopyObjectOperation$NewObjectMetadata' => '<p/>', ], ], 'S3ObjectOwner' => [ 'base' => '<p/>', 'refs' => [ 'S3AccessControlList$Owner' => '<p/>', ], ], 'S3ObjectVersionId' => [ 'base' => NULL, 'refs' => [ 'JobManifestLocation$ObjectVersionId' => '<p>The optional version ID to identify a specific version of the manifest object.</p>', ], ], 'S3Permission' => [ 'base' => NULL, 'refs' => [ 'S3Grant$Permission' => '<p/>', ], ], 'S3RegionalBucketArn' => [ 'base' => NULL, 'refs' => [ 'CreateBucketResult$BucketArn' => '<p>The Amazon Resource Name (ARN) of the bucket.</p> <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p> <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>', 'RegionalBucket$BucketArn' => '<p>The Amazon Resource Name (ARN) for the regional bucket.</p>', ], ], 'S3Retention' => [ 'base' => '<p>Contains the S3 Object Lock retention mode to be applied to all objects in the S3 Batch Operations job. If you don\'t provide <code>Mode</code> and <code>RetainUntilDate</code> data types in your operation, you will remove the retention from your objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'S3SetObjectRetentionOperation$Retention' => '<p>Contains the Object Lock retention mode to be applied to all objects in the Batch Operations job. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>', ], ], 'S3SSEAlgorithm' => [ 'base' => NULL, 'refs' => [ 'S3ObjectMetadata$SSEAlgorithm' => '<p/>', ], ], 'S3SetObjectAclOperation' => [ 'base' => '<p>Contains the configuration parameters for a Set Object ACL operation. S3 Batch Operations passes every object to the underlying PUT Object acl API. For more information about the parameters for this operation, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTacl.html">PUT Object acl</a>.</p>', 'refs' => [ 'JobOperation$S3PutObjectAcl' => '<p>Directs the specified job to run a PUT Object acl call on every object in the manifest.</p>', ], ], 'S3SetObjectLegalHoldOperation' => [ 'base' => '<p>Contains the configuration for an S3 Object Lock legal hold operation that an S3 Batch Operations job passes every object to the underlying <code>PutObjectLegalHold</code> API. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html">Using S3 Object Lock legal hold with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'JobOperation$S3PutObjectLegalHold' => NULL, ], ], 'S3SetObjectRetentionOperation' => [ 'base' => '<p>Contains the configuration parameters for the Object Lock retention action for an S3 Batch Operations job. Batch Operations passes every object to the underlying <code>PutObjectRetention</code> API. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'JobOperation$S3PutObjectRetention' => NULL, ], ], 'S3SetObjectTaggingOperation' => [ 'base' => '<p>Contains the configuration parameters for a Set Object Tagging operation. S3 Batch Operations passes every object to the underlying PUT Object tagging API. For more information about the parameters for this operation, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTtagging.html">PUT Object tagging</a>.</p>', 'refs' => [ 'JobOperation$S3PutObjectTagging' => '<p>Directs the specified job to run a PUT Object tagging call on every object in the manifest.</p>', ], ], 'S3StorageClass' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$StorageClass' => '<p/>', ], ], 'S3Tag' => [ 'base' => '<p/>', 'refs' => [ 'LifecycleRuleFilter$Tag' => NULL, 'S3TagSet$member' => NULL, ], ], 'S3TagSet' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$Tags' => '<p>A set of tags to associate with the S3 Batch Operations job. This is an optional parameter. </p>', 'GetBucketTaggingResult$TagSet' => '<p>The tags set of the Outposts bucket.</p>', 'GetJobTaggingResult$Tags' => '<p>The set of tags associated with the S3 Batch Operations job.</p>', 'LifecycleRuleAndOperator$Tags' => '<p>All of these tags must exist in the object\'s tag set in order for the rule to apply.</p>', 'PutJobTaggingRequest$Tags' => '<p>The set of tags to associate with the S3 Batch Operations job.</p>', 'S3CopyObjectOperation$NewObjectTagging' => '<p/>', 'S3SetObjectTaggingOperation$TagSet' => '<p/>', 'Tagging$TagSet' => '<p>A collection for a set of tags.</p>', ], ], 'S3UserMetadata' => [ 'base' => NULL, 'refs' => [ 'S3ObjectMetadata$UserMetadata' => '<p/>', ], ], 'SSEKMS' => [ 'base' => '<p/>', 'refs' => [ 'StorageLensDataExportEncryption$SSEKMS' => '<p/>', ], ], 'SSEKMSKeyId' => [ 'base' => NULL, 'refs' => [ 'SSEKMS$KeyId' => '<p>A container for the ARN of the SSE-KMS encryption. This property is read-only and follows the following format: <code> arn:aws:kms:<i>us-east-1</i>:<i>example-account-id</i>:key/<i>example-9a73-4afc-8d29-8f5900cef44e</i> </code> </p>', ], ], 'SSES3' => [ 'base' => '<p/>', 'refs' => [ 'StorageLensDataExportEncryption$SSES3' => '<p/>', ], ], 'SelectionCriteria' => [ 'base' => '<p/>', 'refs' => [ 'PrefixLevelStorageMetrics$SelectionCriteria' => NULL, ], ], 'Setting' => [ 'base' => NULL, 'refs' => [ 'PublicAccessBlockConfiguration$BlockPublicAcls' => '<p>Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to <code>TRUE</code> causes the following behavior:</p> <ul> <li> <p>PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.</p> </li> <li> <p>PUT Object calls fail if the request includes a public ACL.</p> </li> <li> <p>PUT Bucket calls fail if the request includes a public ACL.</p> </li> </ul> <p>Enabling this setting doesn\'t affect existing policies or ACLs.</p> <p>This is not supported for Amazon S3 on Outposts.</p>', 'PublicAccessBlockConfiguration$IgnorePublicAcls' => '<p>Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. </p> <p>Enabling this setting doesn\'t affect the persistence of any existing ACLs and doesn\'t prevent new public ACLs from being set.</p> <p>This is not supported for Amazon S3 on Outposts.</p>', 'PublicAccessBlockConfiguration$BlockPublicPolicy' => '<p>Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. </p> <p>Enabling this setting doesn\'t affect existing bucket policies.</p> <p>This is not supported for Amazon S3 on Outposts.</p>', 'PublicAccessBlockConfiguration$RestrictPublicBuckets' => '<p>Specifies whether Amazon S3 should restrict public bucket policies for buckets in this account. Setting this element to <code>TRUE</code> restricts access to buckets with public policies to only Amazon Web Service principals and authorized users within this account.</p> <p>Enabling this setting doesn\'t affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.</p> <p>This is not supported for Amazon S3 on Outposts.</p>', ], ], 'StorageLensArn' => [ 'base' => NULL, 'refs' => [ 'ListStorageLensConfigurationEntry$StorageLensArn' => '<p>The ARN of the S3 Storage Lens configuration. This property is read-only.</p>', 'StorageLensConfiguration$StorageLensArn' => '<p>The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This property is read-only and follows the following format: <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:storage-lens/<i>your-dashboard-name</i> </code> </p>', ], ], 'StorageLensAwsOrg' => [ 'base' => '<p>The Amazon Web Services organization for your S3 Storage Lens.</p>', 'refs' => [ 'StorageLensConfiguration$AwsOrg' => '<p>A container for the Amazon Web Services organization for this S3 Storage Lens configuration.</p>', ], ], 'StorageLensConfiguration' => [ 'base' => '<p>A container for the Amazon S3 Storage Lens configuration.</p>', 'refs' => [ 'GetStorageLensConfigurationResult$StorageLensConfiguration' => '<p>The S3 Storage Lens configuration requested.</p>', 'PutStorageLensConfigurationRequest$StorageLensConfiguration' => '<p>The S3 Storage Lens configuration.</p>', ], ], 'StorageLensConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListStorageLensConfigurationsResult$StorageLensConfigurationList' => '<p>A list of S3 Storage Lens configurations.</p>', ], ], 'StorageLensDataExport' => [ 'base' => '<p>A container to specify the properties of your S3 Storage Lens metrics export, including the destination, schema, and format.</p>', 'refs' => [ 'StorageLensConfiguration$DataExport' => '<p>A container to specify the properties of your S3 Storage Lens metrics export including, the destination, schema and format.</p>', ], ], 'StorageLensDataExportEncryption' => [ 'base' => '<p>A container for the encryption of the S3 Storage Lens metrics exports.</p>', 'refs' => [ 'S3BucketDestination$Encryption' => '<p>The container for the type encryption of the metrics exports in this bucket.</p>', ], ], 'StorageLensPrefixLevelDelimiter' => [ 'base' => NULL, 'refs' => [ 'SelectionCriteria$Delimiter' => '<p>A container for the delimiter of the selection criteria being used.</p>', ], ], 'StorageLensPrefixLevelMaxDepth' => [ 'base' => NULL, 'refs' => [ 'SelectionCriteria$MaxDepth' => '<p>The max depth of the selection criteria</p>', ], ], 'StorageLensTag' => [ 'base' => '<p/>', 'refs' => [ 'StorageLensTags$member' => NULL, ], ], 'StorageLensTags' => [ 'base' => NULL, 'refs' => [ 'GetStorageLensConfigurationTaggingResult$Tags' => '<p>The tags of S3 Storage Lens configuration requested.</p>', 'PutStorageLensConfigurationRequest$Tags' => '<p>The tag set of the S3 Storage Lens configuration.</p> <note> <p>You can set up to a maximum of 50 tags.</p> </note>', 'PutStorageLensConfigurationTaggingRequest$Tags' => '<p>The tag set of the S3 Storage Lens configuration.</p> <note> <p>You can set up to a maximum of 50 tags.</p> </note>', ], ], 'StringForNextToken' => [ 'base' => NULL, 'refs' => [ 'ListJobsRequest$NextToken' => '<p>A pagination token to request the next page of results. Use the token that Amazon S3 returned in the <code>NextToken</code> element of the <code>ListJobsResult</code> from the previous <code>List Jobs</code> request.</p>', 'ListJobsResult$NextToken' => '<p>If the <code>List Jobs</code> request produced more than the maximum number of results, you can pass this value into a subsequent <code>List Jobs</code> request in order to retrieve the next page of results.</p>', ], ], 'SuspendedCause' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$SuspendedCause' => '<p>The reason why the specified job was suspended. A job is only suspended if you create it through the Amazon S3 console. When you create the job, it enters the <code>Suspended</code> state to await confirmation before running. After you confirm the job, it automatically exits the <code>Suspended</code> state.</p>', ], ], 'SuspendedDate' => [ 'base' => NULL, 'refs' => [ 'JobDescriptor$SuspendedDate' => '<p>The timestamp when this job was suspended, if it has been suspended.</p>', ], ], 'TagKeyString' => [ 'base' => NULL, 'refs' => [ 'S3Tag$Key' => '<p/>', 'StorageLensTag$Key' => '<p/>', ], ], 'TagValueString' => [ 'base' => NULL, 'refs' => [ 'S3Tag$Value' => '<p/>', 'StorageLensTag$Value' => '<p/>', ], ], 'Tagging' => [ 'base' => '<p/>', 'refs' => [ 'PutBucketTaggingRequest$Tagging' => '<p/>', ], ], 'TimeStamp' => [ 'base' => NULL, 'refs' => [ 'S3CopyObjectOperation$ModifiedSinceConstraint' => '<p/>', 'S3CopyObjectOperation$UnModifiedSinceConstraint' => '<p/>', 'S3CopyObjectOperation$ObjectLockRetainUntilDate' => '<p>The date when the applied object retention configuration expires on all objects in the Batch Operations job.</p>', 'S3ObjectMetadata$HttpExpiresDate' => '<p/>', 'S3Retention$RetainUntilDate' => '<p>The date when the applied Object Lock retention will expire on all objects set by the Batch Operations job.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p/>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>Amazon S3 throws this exception if you have too many tags in your tag set.</p>', 'refs' => [], ], 'Transition' => [ 'base' => '<p>Specifies when an object transitions to a specified storage class. For more information about Amazon S3 Lifecycle configuration rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html"> Transitioning objects using Amazon S3 Lifecycle</a> in the <i>Amazon S3 User Guide</i>.</p>', 'refs' => [ 'TransitionList$member' => NULL, ], ], 'TransitionList' => [ 'base' => NULL, 'refs' => [ 'LifecycleRule$Transitions' => '<p>Specifies when an Amazon S3 object transitions to a specified storage class.</p> <note> <p>This is not supported by Amazon S3 on Outposts buckets.</p> </note>', ], ], 'TransitionStorageClass' => [ 'base' => NULL, 'refs' => [ 'NoncurrentVersionTransition$StorageClass' => '<p>The class of storage used to store the object.</p>', 'Transition$StorageClass' => '<p>The storage class to which you want the object to transition.</p>', ], ], 'UpdateJobPriorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobPriorityResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'VpcConfiguration' => [ 'base' => '<p>The virtual private cloud (VPC) configuration for an access point.</p>', 'refs' => [ 'AccessPoint$VpcConfiguration' => '<p>The virtual private cloud (VPC) configuration for this access point, if one exists.</p> <note> <p>This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.</p> </note>', 'CreateAccessPointRequest$VpcConfiguration' => '<p>If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).</p> <note> <p>This is required for creating an access point for Amazon S3 on Outposts buckets.</p> </note>', 'GetAccessPointResult$VpcConfiguration' => '<p>Contains the virtual private cloud (VPC) configuration for the specified access point.</p> <note> <p>This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.</p> </note>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$VpcId' => '<p>If this field is specified, this access point will only allow connections from the specified VPC ID.</p>', ], ], ],];
