<?php
// This file was auto-generated from sdk-root/src/data/servicecatalog-appregistry/2020-06-24/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> Amazon Web Services Service Catalog AppRegistry enables organizations to understand the application context of their Amazon Web Services resources. AppRegistry provides a repository of your applications, their resources, and the application metadata that you use within your enterprise.</p>', 'operations' => [ 'AssociateAttributeGroup' => '<p>Associates an attribute group with an application to augment the application\'s metadata with the group\'s attributes. This feature enables applications to be described with user-defined details that are machine-readable, such as third-party integrations.</p>', 'AssociateResource' => '<p>Associates a resource with an application. Both the resource and the application can be specified either by ID or name.</p>', 'CreateApplication' => '<p>Creates a new application that is the top-level node in a hierarchy of related cloud resource abstractions.</p>', 'CreateAttributeGroup' => '<p>Creates a new attribute group as a container for user-defined attributes. This feature enables users to have full control over their cloud application\'s metadata in a rich machine-readable format to facilitate integration with automated workflows and third-party tools.</p>', 'DeleteApplication' => '<p>Deletes an application that is specified either by its application ID or name. All associated attribute groups and resources must be disassociated from it before deleting an application.</p>', 'DeleteAttributeGroup' => '<p>Deletes an attribute group, specified either by its attribute group ID or name.</p>', 'DisassociateAttributeGroup' => '<p>Disassociates an attribute group from an application to remove the extra attributes contained in the attribute group from the application\'s metadata. This operation reverts <code>AssociateAttributeGroup</code>.</p>', 'DisassociateResource' => '<p>Disassociates a resource from application. Both the resource and the application can be specified either by ID or name.</p>', 'GetApplication' => '<p>Retrieves metadata information about one of your applications. The application can be specified either by its unique ID or by its name (which is unique within one account in one region at a given point in time). Specify by ID in automated workflows if you want to make sure that the exact same application is returned or a <code>ResourceNotFoundException</code> is thrown, avoiding the ABA addressing problem.</p>', 'GetAssociatedResource' => '<p>Gets the resource associated with the application.</p>', 'GetAttributeGroup' => '<p>Retrieves an attribute group, either by its name or its ID. The attribute group can be specified either by its unique ID or by its name.</p>', 'ListApplications' => '<p>Retrieves a list of all of your applications. Results are paginated.</p>', 'ListAssociatedAttributeGroups' => '<p>Lists all attribute groups that are associated with specified application. Results are paginated.</p>', 'ListAssociatedResources' => '<p>Lists all resources that are associated with specified application. Results are paginated.</p>', 'ListAttributeGroups' => '<p>Lists all attribute groups which you have access to. Results are paginated.</p>', 'ListTagsForResource' => '<p>Lists all of the tags on the resource.</p>', 'SyncResource' => '<p>Syncs the resource with current AppRegistry records.</p> <p>Specifically, the resource’s AppRegistry system tags sync with its associated application. We remove the resource\'s AppRegistry system tags if it does not associate with the application. The caller must have permissions to read and update the resource.</p>', 'TagResource' => '<p>Assigns one or more tags (key-value pairs) to the specified resource.</p> <p>Each tag consists of a key and an optional value. If a tag with the same key is already associated with the resource, this action updates its value.</p> <p>This operation returns an empty response if the call was successful.</p>', 'UntagResource' => '<p>Removes tags from a resource.</p> <p>This operation returns an empty response if the call was successful.</p>', 'UpdateApplication' => '<p>Updates an existing application with new attributes.</p>', 'UpdateAttributeGroup' => '<p>Updates an existing attribute group with new details. </p>', ], 'shapes' => [ 'Application' => [ 'base' => '<p>Represents a Amazon Web Services Service Catalog AppRegistry application that is the top-level node in a hierarchy of related cloud resource abstractions.</p>', 'refs' => [ 'CreateApplicationResponse$application' => '<p>Information about the application.</p>', 'UpdateApplicationResponse$application' => '<p>The updated information of the application.</p>', ], ], 'ApplicationArn' => [ 'base' => NULL, 'refs' => [ 'Application$arn' => '<p>The Amazon resource name (ARN) that specifies the application across services.</p>', 'ApplicationSummary$arn' => '<p>The Amazon resource name (ARN) that specifies the application across services.</p>', 'AssociateAttributeGroupResponse$applicationArn' => '<p>The Amazon resource name (ARN) of the application that was augmented with attributes.</p>', 'AssociateResourceResponse$applicationArn' => '<p>The Amazon resource name (ARN) of the application that was augmented with attributes.</p>', 'DisassociateAttributeGroupResponse$applicationArn' => '<p>The Amazon resource name (ARN) that specifies the application.</p>', 'DisassociateResourceResponse$applicationArn' => '<p>The Amazon resource name (ARN) that specifies the application.</p>', 'GetApplicationResponse$arn' => '<p>The Amazon resource name (ARN) that specifies the application across services.</p>', 'SyncResourceResponse$applicationArn' => '<p>The Amazon resource name (ARN) that specifies the application.</p>', ], ], 'ApplicationId' => [ 'base' => NULL, 'refs' => [ 'Application$id' => '<p>The identifier of the application.</p>', 'ApplicationSummary$id' => '<p>The identifier of the application.</p>', 'GetApplicationResponse$id' => '<p>The identifier of the application.</p>', ], ], 'ApplicationSpecifier' => [ 'base' => NULL, 'refs' => [ 'AssociateAttributeGroupRequest$application' => '<p>The name or ID of the application.</p>', 'AssociateResourceRequest$application' => '<p>The name or ID of the application.</p>', 'DeleteApplicationRequest$application' => '<p>The name or ID of the application.</p>', 'DisassociateAttributeGroupRequest$application' => '<p>The name or ID of the application.</p>', 'DisassociateResourceRequest$application' => '<p>The name or ID of the application.</p>', 'GetApplicationRequest$application' => '<p>The name or ID of the application.</p>', 'GetAssociatedResourceRequest$application' => '<p>The name or ID of the application.</p>', 'ListAssociatedAttributeGroupsRequest$application' => '<p>The name or ID of the application.</p>', 'ListAssociatedResourcesRequest$application' => '<p>The name or ID of the application.</p>', 'UpdateApplicationRequest$application' => '<p>The name or ID of the application that will be updated.</p>', ], ], 'ApplicationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsResponse$applications' => '<p>This list of applications.</p>', ], ], 'ApplicationSummary' => [ 'base' => '<p>Summary of a Amazon Web Services Service Catalog AppRegistry application.</p>', 'refs' => [ 'ApplicationSummaries$member' => NULL, 'DeleteApplicationResponse$application' => '<p>Information about the deleted application.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AssociateResourceResponse$resourceArn' => '<p>The Amazon resource name (ARN) that specifies the resource.</p>', 'DisassociateResourceResponse$resourceArn' => '<p>The Amazon resource name (ARN) that specifies the resource.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon resource name (ARN) that specifies the resource.</p>', 'ResourceGroup$arn' => '<p>The Amazon resource name (ARN) of the resource group.</p>', 'SyncResourceResponse$resourceArn' => '<p>The Amazon resource name (ARN) that specifies the resource.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon resource name (ARN) that specifies the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon resource name (ARN) that specifies the resource.</p>', ], ], 'AssociateAttributeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateAttributeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociationCount' => [ 'base' => NULL, 'refs' => [ 'GetApplicationResponse$associatedResourceCount' => '<p>The number of top-level resources that were registered as part of this application.</p>', ], ], 'AttributeGroup' => [ 'base' => '<p>Represents a Amazon Web Services Service Catalog AppRegistry attribute group that is rich metadata which describes an application and its components.</p>', 'refs' => [ 'CreateAttributeGroupResponse$attributeGroup' => '<p>Information about the attribute group.</p>', 'UpdateAttributeGroupResponse$attributeGroup' => '<p>The updated information of the attribute group.</p>', ], ], 'AttributeGroupArn' => [ 'base' => NULL, 'refs' => [ 'AssociateAttributeGroupResponse$attributeGroupArn' => '<p>The Amazon resource name (ARN) of the attribute group that contains the application\'s new attributes.</p>', 'AttributeGroup$arn' => '<p>The Amazon resource name (ARN) that specifies the attribute group across services.</p>', 'AttributeGroupSummary$arn' => '<p>The Amazon resource name (ARN) that specifies the attribute group across services.</p>', 'DisassociateAttributeGroupResponse$attributeGroupArn' => '<p>The Amazon resource name (ARN) that specifies the attribute group.</p>', 'GetAttributeGroupResponse$arn' => '<p>The Amazon resource name (ARN) that specifies the attribute group across services.</p>', ], ], 'AttributeGroupId' => [ 'base' => NULL, 'refs' => [ 'AttributeGroup$id' => '<p>The globally unique attribute group identifier of the attribute group.</p>', 'AttributeGroupIds$member' => NULL, 'AttributeGroupSummary$id' => '<p>The globally unique attribute group identifier of the attribute group.</p>', 'GetAttributeGroupResponse$id' => '<p>The identifier of the attribute group.</p>', ], ], 'AttributeGroupIds' => [ 'base' => NULL, 'refs' => [ 'ListAssociatedAttributeGroupsResponse$attributeGroups' => '<p>A list of attribute group IDs.</p>', ], ], 'AttributeGroupSpecifier' => [ 'base' => NULL, 'refs' => [ 'AssociateAttributeGroupRequest$attributeGroup' => '<p>The name or ID of the attribute group that holds the attributes to describe the application.</p>', 'DeleteAttributeGroupRequest$attributeGroup' => '<p>The name or ID of the attribute group that holds the attributes to describe the application.</p>', 'DisassociateAttributeGroupRequest$attributeGroup' => '<p>The name or ID of the attribute group that holds the attributes to describe the application.</p>', 'GetAttributeGroupRequest$attributeGroup' => '<p>The name or ID of the attribute group that holds the attributes to describe the application.</p>', 'UpdateAttributeGroupRequest$attributeGroup' => '<p>The name or ID of the attribute group that holds the attributes to describe the application.</p>', ], ], 'AttributeGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAttributeGroupsResponse$attributeGroups' => '<p>This list of attribute groups.</p>', ], ], 'AttributeGroupSummary' => [ 'base' => '<p>Summary of a Amazon Web Services Service Catalog AppRegistry attribute group.</p>', 'refs' => [ 'AttributeGroupSummaries$member' => NULL, 'DeleteAttributeGroupResponse$attributeGroup' => '<p>Information about the deleted attribute group.</p>', ], ], 'Attributes' => [ 'base' => NULL, 'refs' => [ 'CreateAttributeGroupRequest$attributes' => '<p>A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.</p>', 'GetAttributeGroupResponse$attributes' => '<p>A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.</p>', 'UpdateAttributeGroupRequest$attributes' => '<p>A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationRequest$clientToken' => '<p>A unique identifier that you provide to ensure idempotency. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails.</p>', 'CreateAttributeGroupRequest$clientToken' => '<p>A unique identifier that you provide to ensure idempotency. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails.</p>', ], ], 'ConflictException' => [ 'base' => '<p>There was a conflict when processing the request (for example, a resource with the given name already exists within the account).</p>', 'refs' => [], ], 'CreateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAttributeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAttributeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAttributeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAttributeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'Application$description' => '<p>The description of the application.</p>', 'ApplicationSummary$description' => '<p>The description of the application.</p>', 'AttributeGroup$description' => '<p>The description of the attribute group that the user provides.</p>', 'AttributeGroupSummary$description' => '<p>The description of the attribute group that the user provides.</p>', 'CreateApplicationRequest$description' => '<p>The description of the application.</p>', 'CreateAttributeGroupRequest$description' => '<p>The description of the attribute group that the user provides.</p>', 'GetApplicationResponse$description' => '<p>The description of the application.</p>', 'GetAttributeGroupResponse$description' => '<p>The description of the attribute group that the user provides.</p>', 'UpdateApplicationRequest$description' => '<p>The new description of the application.</p>', 'UpdateAttributeGroupRequest$description' => '<p>The description of the attribute group that the user provides.</p>', ], ], 'DisassociateAttributeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateAttributeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAssociatedResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAssociatedResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAttributeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAttributeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'Integrations' => [ 'base' => '<p> The information about the service integration.</p>', 'refs' => [ 'GetApplicationResponse$integrations' => '<p>The information about the integration of the application with other services, such as Resource Groups.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The service is experiencing internal problems.</p>', 'refs' => [], ], 'ListApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedAttributeGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedAttributeGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociatedResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAttributeGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAttributeGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsRequest$maxResults' => '<p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>', 'ListAssociatedAttributeGroupsRequest$maxResults' => '<p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>', 'ListAssociatedResourcesRequest$maxResults' => '<p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>', 'ListAttributeGroupsRequest$maxResults' => '<p>The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'Application$name' => '<p>The name of the application. The name must be unique in the region in which you are creating the application.</p>', 'ApplicationSummary$name' => '<p>The name of the application. The name must be unique in the region in which you are creating the application.</p>', 'AttributeGroup$name' => '<p>The name of the attribute group.</p>', 'AttributeGroupSummary$name' => '<p>The name of the attribute group.</p>', 'CreateApplicationRequest$name' => '<p>The name of the application. The name must be unique in the region in which you are creating the application.</p>', 'CreateAttributeGroupRequest$name' => '<p>The name of the attribute group.</p>', 'GetApplicationResponse$name' => '<p>The name of the application. The name must be unique in the region in which you are creating the application.</p>', 'GetAttributeGroupResponse$name' => '<p>The name of the attribute group.</p>', 'UpdateApplicationRequest$name' => '<p>The new name of the application. The name must be unique in the region in which you are updating the application.</p>', 'UpdateAttributeGroupRequest$name' => '<p>The new name of the attribute group. The name must be unique in the region in which you are updating the attribute group.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsRequest$nextToken' => '<p>The token to use to get the next page of results after a previous API call. </p>', 'ListApplicationsResponse$nextToken' => '<p>The token to use to get the next page of results after a previous API call. </p>', 'ListAssociatedAttributeGroupsRequest$nextToken' => '<p>The token to use to get the next page of results after a previous API call. </p>', 'ListAssociatedAttributeGroupsResponse$nextToken' => '<p>The token to use to get the next page of results after a previous API call. </p>', 'ListAssociatedResourcesRequest$nextToken' => '<p>The token to use to get the next page of results after a previous API call. </p>', 'ListAssociatedResourcesResponse$nextToken' => '<p>The token to use to get the next page of results after a previous API call. </p>', 'ListAttributeGroupsRequest$nextToken' => '<p>The token to use to get the next page of results after a previous API call. </p>', 'ListAttributeGroupsResponse$nextToken' => '<p>The token to use to get the next page of results after a previous API call. </p>', ], ], 'Resource' => [ 'base' => '<p> The information about the resource.</p>', 'refs' => [ 'GetAssociatedResourceResponse$resource' => '<p>The resource associated with the application.</p>', ], ], 'ResourceGroup' => [ 'base' => '<p>The information about the resource group integration.</p>', 'refs' => [ 'Integrations$resourceGroup' => '<p> The information about the resource group integration.</p>', 'ResourceIntegrations$resourceGroup' => '<p>The information about the integration of Resource Groups.</p>', ], ], 'ResourceGroupState' => [ 'base' => NULL, 'refs' => [ 'ResourceGroup$state' => '<p>The state of the propagation process for the resource group. The states includes:</p> <p> <code>CREATING </code>if the resource group is in the process of being created.</p> <p> <code>CREATE_COMPLETE</code> if the resource group was created successfully.</p> <p> <code>CREATE_FAILED</code> if the resource group failed to be created.</p> <p> <code>UPDATING</code> if the resource group is in the process of being updated.</p> <p> <code>UPDATE_COMPLETE</code> if the resource group updated successfully.</p> <p> <code>UPDATE_FAILED</code> if the resource group could not update successfully.</p>', ], ], 'ResourceInfo' => [ 'base' => '<p>The information about the resource.</p>', 'refs' => [ 'Resources$member' => NULL, ], ], 'ResourceIntegrations' => [ 'base' => '<p>The service integration information about the resource.</p>', 'refs' => [ 'Resource$integrations' => '<p>The service integration information about the resource. </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource does not exist.</p>', 'refs' => [], ], 'ResourceSpecifier' => [ 'base' => NULL, 'refs' => [ 'AssociateResourceRequest$resource' => '<p>The name or ID of the resource of which the application will be associated.</p>', 'DisassociateResourceRequest$resource' => '<p>The name or ID of the resource.</p>', 'GetAssociatedResourceRequest$resource' => '<p>The name or ID of the resource associated with the application.</p>', 'Resource$name' => '<p>The name of the resource.</p>', 'ResourceInfo$name' => '<p>The name of the resource.</p>', 'SyncResourceRequest$resource' => '<p>An entity you can work with and specify with a name or ID. Examples include an Amazon EC2 instance, an Amazon Web Services CloudFormation stack, or an Amazon S3 bucket.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'AssociateResourceRequest$resourceType' => '<p>The type of resource of which the application will be associated.</p>', 'DisassociateResourceRequest$resourceType' => '<p>The type of the resource that is being disassociated.</p>', 'GetAssociatedResourceRequest$resourceType' => '<p>The type of resource associated with the application.</p>', 'SyncResourceRequest$resourceType' => '<p>The type of resource of which the application will be associated.</p>', ], ], 'Resources' => [ 'base' => NULL, 'refs' => [ 'ListAssociatedResourcesResponse$resources' => '<p>Information about the resources.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The maximum number of resources per account has been reached.</p>', 'refs' => [], ], 'StackArn' => [ 'base' => NULL, 'refs' => [ 'Resource$arn' => '<p>The Amazon resource name (ARN) of the resource.</p>', 'ResourceInfo$arn' => '<p>The Amazon resource name (ARN) that specifies the resource across services.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ConflictException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceGroup$errorMessage' => '<p>The error message that generates when the propagation process for the resource group fails.</p>', 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'SyncAction' => [ 'base' => NULL, 'refs' => [ 'SyncResourceResponse$actionTaken' => '<p>The results of the output if an application is associated with an ARN value, which could be <code>syncStarted</code> or None.</p>', ], ], 'SyncResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'SyncResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeys$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of the tag keys to remove from the specified resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'Application$tags' => '<p>Key-value pairs you can use to associate with the application.</p>', 'AttributeGroup$tags' => '<p>Key-value pairs you can use to associate with the attribute group.</p>', 'CreateApplicationRequest$tags' => '<p>Key-value pairs you can use to associate with the application.</p>', 'CreateAttributeGroupRequest$tags' => '<p>Key-value pairs you can use to associate with the attribute group.</p>', 'GetApplicationResponse$tags' => '<p>Key-value pairs associated with the application.</p>', 'GetAttributeGroupResponse$tags' => '<p>Key-value pairs associated with the attribute group.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags on the resource.</p>', 'TagResourceRequest$tags' => '<p>The new or modified tags for the resource.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Application$creationTime' => '<p>The ISO-8601 formatted timestamp of the moment when the application was created.</p>', 'Application$lastUpdateTime' => '<p> The ISO-8601 formatted timestamp of the moment when the application was last updated.</p>', 'ApplicationSummary$creationTime' => '<p>The ISO-8601 formatted timestamp of the moment when the application was created.</p>', 'ApplicationSummary$lastUpdateTime' => '<p> The ISO-8601 formatted timestamp of the moment when the application was last updated.</p>', 'AttributeGroup$creationTime' => '<p>The ISO-8601 formatted timestamp of the moment the attribute group was created.</p>', 'AttributeGroup$lastUpdateTime' => '<p>The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.</p>', 'AttributeGroupSummary$creationTime' => '<p>The ISO-8601 formatted timestamp of the moment the attribute group was created.</p>', 'AttributeGroupSummary$lastUpdateTime' => '<p>The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.</p>', 'GetApplicationResponse$creationTime' => '<p>The ISO-8601 formatted timestamp of the moment when the application was created.</p>', 'GetApplicationResponse$lastUpdateTime' => '<p>The ISO-8601 formatted timestamp of the moment when the application was last updated.</p>', 'GetAttributeGroupResponse$creationTime' => '<p>The ISO-8601 formatted timestamp of the moment the attribute group was created.</p>', 'GetAttributeGroupResponse$lastUpdateTime' => '<p>The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.</p>', 'Resource$associationTime' => '<p>The time the resource was associated with the application.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAttributeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAttributeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The request has invalid or missing parameters.</p>', 'refs' => [], ], ],];
